/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.data;

import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffSampleType;

public class TiffUnusualPrecisions {
    private TiffUnusualPrecisions() {
    }

    public static boolean isUnusualPrecisions(TiffIFD ifd) throws TiffException {
        Objects.requireNonNull(ifd, "Null IFD");
        return TiffUnusualPrecisions.getInfo(ifd).isUnusual();
    }

    public static byte[] unpackUnusualPrecisions(byte[] samples, TiffIFD ifd, int numberOfChannels, long numberOfPixels, boolean scaleUnsignedInt24) throws TiffException {
        long size;
        Objects.requireNonNull(samples, "Null samples");
        Objects.requireNonNull(ifd, "Null IFD");
        TiffIFD.checkNumberOfChannels(numberOfChannels);
        if (numberOfPixels < 0L) {
            throw new IllegalArgumentException("Negative numberOfPixels = " + numberOfPixels);
        }
        PrecisionsInfo info = TiffUnusualPrecisions.getInfo(ifd);
        if (!info.isUnusual()) {
            return samples;
        }
        assert (info.packedBytesPerSample <= 4);
        ByteOrder byteOrder = ifd.getByteOrder();
        if (numberOfPixels > Integer.MAX_VALUE || (size = numberOfPixels * (long)numberOfChannels * 4L) > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of pixels " + numberOfPixels + " (" + numberOfChannels + " samples/pixel, 4 bytes/sample): it requires > 2 GB to store");
        }
        int numberOfSamples = (int)((long)numberOfChannels * numberOfPixels);
        if ((long)numberOfSamples * (long)info.packedBytesPerSample > (long)samples.length) {
            throw new IllegalArgumentException("Too short samples array byte[" + samples.length + "]: it does not contain " + numberOfPixels + " pixels per " + numberOfChannels + " samples, " + info.packedBytesPerSample + " bytes/sample");
        }
        byte[] unpacked = new byte[(int)size];
        if (info.int24) {
            int i = 0;
            int disp = 0;
            while (i < numberOfSamples) {
                long value = JArrays.getBytes8((byte[])samples, (int)disp, (int)info.packedBytesPerSample, (ByteOrder)byteOrder);
                long newValue = scaleUnsignedInt24 ? value << 8 : value;
                JArrays.setBytes8((byte[])unpacked, (int)(i * 4), (long)newValue, (int)4, (ByteOrder)byteOrder);
                ++i;
                disp += info.packedBytesPerSample;
            }
            return unpacked;
        }
        int i = 0;
        int disp = 0;
        while (i < numberOfSamples) {
            int packedValue = (int)JArrays.getBytes8((byte[])samples, (int)disp, (int)info.packedBytesPerSample, (ByteOrder)byteOrder);
            int value = info.float16 ? TiffUnusualPrecisions.unpackFloat16Bit((short)packedValue) : TiffUnusualPrecisions.unpackFloat24Bit(packedValue);
            JArrays.setBytes8((byte[])unpacked, (int)(i * 4), (long)value, (int)4, (ByteOrder)byteOrder);
            ++i;
            disp += info.packedBytesPerSample;
        }
        return unpacked;
    }

    private static PrecisionsInfo getInfo(TiffIFD ifd) throws TiffException {
        int packedBytesPerSample = ifd.alignedBitDepth() + 7 >>> 3;
        TiffSampleType sampleType = ifd.sampleType();
        boolean floatingPoint = sampleType.isFloatingPoint();
        if (packedBytesPerSample < 1 || (floatingPoint ? packedBytesPerSample > 4 && packedBytesPerSample != 8 : packedBytesPerSample > 4)) {
            throw new AssertionError((Object)("sampleType() did not check supported bit depth: " + String.valueOf(ifd)));
        }
        int bitsPerSample = ifd.tryEqualBitDepth().orElse(-1);
        boolean float16 = bitsPerSample == 16 && floatingPoint;
        boolean float24 = bitsPerSample == 24 && floatingPoint;
        boolean int24 = packedBytesPerSample == 3 && !float24;
        return new PrecisionsInfo(packedBytesPerSample, float16, float24, int24);
    }

    private static int unpackFloat(int value, int mantissaBits, int exponentBits) {
        int exponentIncrement = 127 - (TiffUnusualPrecisions.pow2(exponentBits - 1) - 1);
        int power2ExponentBitsMinus1 = TiffUnusualPrecisions.pow2(exponentBits) - 1;
        int packedBitsPerSampleMinus1 = mantissaBits + exponentBits;
        int sign = value >> packedBitsPerSampleMinus1;
        int power2MantissaBits = TiffUnusualPrecisions.pow2(mantissaBits);
        int exponent = value >> mantissaBits & power2ExponentBitsMinus1;
        int mantissa = value & power2MantissaBits - 1;
        if (exponent == 0) {
            if (mantissa != 0) {
                while ((mantissa & power2MantissaBits) == 0) {
                    mantissa <<= 1;
                    --exponent;
                }
                ++exponent;
                mantissa &= power2MantissaBits - 1;
                exponent += exponentIncrement;
            }
        } else {
            exponent = exponent == power2ExponentBitsMinus1 ? 255 : (exponent += exponentIncrement);
        }
        return sign << 31 | exponent << 23 | (mantissa <<= 23 - mantissaBits);
    }

    private static int unpackFloat24Bit(int value) {
        int mantissaBits = 16;
        int exponentIncrement = 64;
        int power2ExponentBitsMinus1 = 127;
        int sign = value >> 23;
        int power2MantissaBits = 65536;
        int exponent = value >> 16 & 0x7F;
        int mantissa = value & 0xFFFF;
        if (exponent == 0) {
            if (mantissa != 0) {
                while ((mantissa & 0x10000) == 0) {
                    mantissa <<= 1;
                    --exponent;
                }
                ++exponent;
                mantissa &= 0xFFFF;
                exponent += 64;
            }
        } else {
            exponent = exponent == 127 ? 255 : (exponent += 64);
        }
        return sign << 31 | exponent << 23 | (mantissa <<= 7);
    }

    private static int unpackFloat16Bit(short value) {
        int mantissa = value & 0x3FF;
        int exponent = value & 0x7C00;
        if (exponent == 31744) {
            exponent = 261120;
        } else if (exponent != 0) {
            exponent += 114688;
        } else if (mantissa != 0) {
            exponent = 115712;
            do {
                exponent -= 1024;
            } while (((mantissa <<= 1) & 0x400) == 0);
            mantissa &= 0x3FF;
        }
        return (value & 0x8000) << 16 | (exponent | mantissa) << 13;
    }

    private static int pow2(int b) {
        return 1 << b;
    }

    private record PrecisionsInfo(int packedBytesPerSample, boolean float16, boolean float24, boolean int24) {
        public boolean isUnusual() {
            return this.float16 || this.float24 || this.int24;
        }
    }
}

