/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tiles;

import java.util.Objects;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.tiles.TiffMap;
import net.algart.matrices.tiff.tiles.TiffTile;

public final class TiffTileIndex {
    private final TiffMap map;
    private final TiffIFD ifd;
    private final int ifdIdentity;
    private final int xIndex;
    private final int yIndex;
    private final int separatedPlaneIndex;
    private final int fromX;
    private final int fromY;
    private final int toX;
    private final int toY;

    public TiffTileIndex(TiffMap map, int xIndex, int yIndex, int separatedPlaneIndex) {
        Objects.requireNonNull(map, "Null containing tile map");
        if (!map.isPlanarSeparated()) {
            if (separatedPlaneIndex != 0) {
                throw new IllegalArgumentException("Non-zero separatedPlaneIndex = " + separatedPlaneIndex + " is allowed only in planar-separated images");
            }
        } else {
            assert (map.numberOfSeparatedPlanes() == map.numberOfChannels());
            if (separatedPlaneIndex < 0 || separatedPlaneIndex >= map.numberOfChannels()) {
                throw new IllegalArgumentException("Index of separatedPlaneIndex " + separatedPlaneIndex + " is out of range 0.." + (map.numberOfChannels() - 1));
            }
        }
        if (xIndex < 0) {
            throw new IllegalArgumentException("Negative x-index = " + xIndex);
        }
        if (yIndex < 0) {
            throw new IllegalArgumentException("Negative y-index = " + yIndex);
        }
        if (xIndex > 1000000000) {
            throw new IllegalArgumentException("Too large x-index = " + xIndex + " > 1000000000");
        }
        if (yIndex > 1000000000) {
            throw new IllegalArgumentException("Too large y-index = " + yIndex + " > 1000000000");
        }
        long fromX = (long)xIndex * (long)map.tileSizeX();
        long fromY = (long)yIndex * (long)map.tileSizeY();
        long toX = fromX + (long)map.tileSizeX();
        long toY = fromY + (long)map.tileSizeY();
        if (toX > Integer.MAX_VALUE || toY > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large tile indexes (" + xIndex + ", " + yIndex + ") lead to too large coordinates (" + (toX - 1L) + ", " + (toY - 1L) + ") of right-bottom pixel of the tile: coordinates >= 2^31 are not supported");
        }
        this.map = map;
        this.ifd = map.ifd();
        this.ifdIdentity = System.identityHashCode(this.ifd);
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        this.separatedPlaneIndex = separatedPlaneIndex;
        this.fromX = (int)fromX;
        this.fromY = (int)fromY;
        this.toX = (int)toX;
        this.toY = (int)toY;
    }

    public TiffMap map() {
        assert (this.map != null);
        return this.map;
    }

    public TiffIFD ifd() {
        return this.ifd;
    }

    public int xIndex() {
        return this.xIndex;
    }

    public int yIndex() {
        return this.yIndex;
    }

    public int separatedPlaneIndex() {
        return this.separatedPlaneIndex;
    }

    public int fromX() {
        return this.fromX;
    }

    public int fromY() {
        return this.fromY;
    }

    public int toX() {
        return this.toX;
    }

    public int toY() {
        return this.toY;
    }

    public int linearIndex() {
        return this.map.linearIndex(this.xIndex, this.yIndex, this.separatedPlaneIndex);
    }

    public TiffTile existingTile() {
        return this.map.get(this);
    }

    public boolean isInBounds() {
        assert (this.separatedPlaneIndex < this.map.numberOfSeparatedPlanes()) : "must be checked in the constructor!";
        return this.xIndex < this.map.gridCountX() && this.yIndex < this.map.gridCountY();
    }

    public void checkInBounds() {
        if (!this.isInBounds()) {
            throw new IllegalStateException("Tile index is out of current TIFF map grid sizes " + this.map.gridCountX() + "x" + this.map.gridCountY() + ": " + String.valueOf(this));
        }
    }

    public String toString() {
        return "(" + this.xIndex + ", " + this.yIndex + ")" + (String)(this.map.isPlanarSeparated() ? ", channel " + this.separatedPlaneIndex : "") + " [coordinates (" + this.fromX + ", " + this.fromY + ") in IFD @" + Integer.toHexString(this.ifdIdentity) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiffTileIndex that = (TiffTileIndex)o;
        return this.separatedPlaneIndex == that.separatedPlaneIndex && this.xIndex == that.xIndex && this.yIndex == that.yIndex && this.ifd == that.ifd;
    }

    public int hashCode() {
        int result = this.ifdIdentity;
        result = 31 * result + this.separatedPlaneIndex;
        result = 31 * result + this.yIndex;
        result = 31 * result + this.xIndex;
        return result;
    }
}

