/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.demo.CallSimpleChainForImage;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.CombineChainSettings;
import net.algart.json.Jsons;

public class CallSimpleChainWithSettings {
    private static void customizeViaParameters(ChainExecutor executor, String a, String b) {
        executor.setStringParameter("a", a);
        executor.setStringParameter("b", b);
    }

    private static void customizeViaBuilder(ChainExecutor executor, String a, String b) {
        SettingsBuilder settingsBuilder = executor.settingsBuilder();
        Parameters parameters = new Parameters().setString("a", a).setString("b", b).setDouble("delta", 0.003);
        JsonObject settingsJson = settingsBuilder.build(parameters);
        System.out.printf("%nSettings JSON: %s%n%n", Jsons.toPrettyString((JsonObject)settingsJson));
        executor.putSettings(settingsJson);
    }

    private static void customizeViaCombiner(ChainExecutor executor, String a, String b) {
        CombineChainSettings combiner = executor.newCombine();
        combiner.setStringParameter("a", a);
        combiner.setStringParameter("b", b);
        combiner.setDoubleParameter("delta", 0.003);
        String settingsScalar = combiner.combine();
        System.out.printf("%nCombined JSON: %s%n%n", settingsScalar);
        executor.putSettings(settingsScalar);
    }

    public static void main(String[] args) throws IOException {
        boolean builder = false;
        boolean combine = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-builder")) {
            builder = true;
            ++startArgIndex;
        } else if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-combine")) {
            combine = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 3) {
            System.out.printf("Usage: %s [-builder|-combine] some_chain.chain x y [a b]%nsome_chain.chain should be a chain with settings, which process 2 scalars x and y and have 2 parameters named a and b. However, this is not necessary.", CallSimpleChainWithSettings.class.getName());
            return;
        }
        Path chainPath = Paths.get(args[startArgIndex], new String[0]);
        String x = args[startArgIndex + 1];
        String y = args[startArgIndex + 2];
        String parameterA = args.length > startArgIndex + 3 ? args[startArgIndex + 3] : null;
        String parameterB = args.length > startArgIndex + 4 ? args[startArgIndex + 4] : null;
        ExecutionBlock.initializeExecutionSystem();
        System.out.printf("Loading %s...%n", chainPath.toAbsolutePath());
        try (ChainExecutor executor = UseChain.newSharedExecutor((Path)chainPath);){
            CallSimpleChainForImage.printChainExecutors();
            CallSimpleChainForImage.printExecutorInterface((ExecutionBlock)executor);
            executor.putStringScalar("x", x);
            executor.putStringScalar("y", y);
            if (combine) {
                CallSimpleChainWithSettings.customizeViaCombiner(executor, parameterA, parameterB);
            } else if (builder) {
                CallSimpleChainWithSettings.customizeViaBuilder(executor, parameterA, parameterB);
            } else {
                CallSimpleChainWithSettings.customizeViaParameters(executor, parameterA, parameterB);
            }
            executor.execute();
            System.out.printf("%s%nDone: result is %s%n", executor, executor.getData());
        }
    }
}

