/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.demo.CallSimpleChainForImage;
import net.algart.executors.api.mappings.MappingBuilder;
import net.algart.executors.api.mappings.core.MappingExecutor;
import net.algart.executors.api.mappings.core.UseMapping;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.json.Jsons;

public class CallSimpleMapping {
    public static void main(String[] args) throws IOException {
        boolean builder = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-builder")) {
            builder = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 3) {
            System.out.printf("Usage: %s [-builder] some_mapping.map name1 value1 name2 value2 ...", CallSimpleMapping.class.getName());
            return;
        }
        Path mappingPath = Paths.get(args[startArgIndex], new String[0]);
        System.out.printf("Loading %s...%n", mappingPath.toAbsolutePath());
        if (builder) {
            MappingBuilder mappingBuilder = MappingBuilder.read((Path)mappingPath);
            Parameters parameters = new Parameters();
            int i = startArgIndex + 1;
            while (i + 1 < args.length) {
                String name = args[i];
                String value = args[i + 1];
                parameters.setString(name, value);
                i += 2;
            }
            JsonObject resultJson = mappingBuilder.build(parameters);
            System.out.printf("Done: result JSON is%n%s%n", Jsons.toPrettyString((JsonObject)resultJson));
        } else {
            ExecutionBlock.initializeExecutionSystem();
            ExecutorFactory factory = ExecutorFactory.newSharedFactory();
            try (MappingExecutor executor = UseMapping.newSharedExecutor((ExecutorFactory)factory, (Path)mappingPath);){
                int i = startArgIndex + 1;
                while (i + 1 < args.length) {
                    String name = args[i];
                    String value = args[i + 1];
                    executor.setStringParameter(name, value);
                    i += 2;
                }
                String result = executor.build();
                System.out.printf("%s%nDone: result is%n%s%n", executor, result);
                CallSimpleChainForImage.printExecutorInterface((ExecutionBlock)executor);
            }
        }
    }
}

