/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.demo.CallSimpleChainForImage;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.CombineSettings;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.json.Jsons;

public class CallSimpleSettings {
    public static void main(String[] args) throws IOException {
        boolean builder = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-builder")) {
            builder = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 4) {
            System.out.printf("Usage: %s [-builder] some_settings.ss [a b str]%nsome_settings.ss should be some settings specification, which has 3 parameters named a, b and str.", CallSimpleSettings.class.getName());
            return;
        }
        Path settingsPath = Paths.get(args[startArgIndex], new String[0]);
        String parameterA = args[startArgIndex + 1];
        String parameterB = args[startArgIndex + 2];
        String parameterStr = args[startArgIndex + 3];
        System.out.printf("Loading %s...%n", settingsPath.toAbsolutePath());
        if (builder) {
            SettingsBuilder settingsBuilder = SettingsBuilder.read((Path)settingsPath);
            Parameters parameters = new Parameters().setString("a", parameterA).setString("b", parameterB).setString("str", parameterStr);
            JsonObject resultJson = settingsBuilder.build(parameters);
            System.out.printf("Done: result JSON is%n%s%n", Jsons.toPrettyString((JsonObject)resultJson));
        } else {
            ExecutionBlock.initializeExecutionSystem();
            ExecutorFactory factory = ExecutorFactory.newSharedFactory();
            try (CombineSettings executor = UseSettings.newSharedExecutor((ExecutorFactory)factory, (Path)settingsPath);){
                executor.setStringParameter("a", parameterA);
                executor.setStringParameter("b", parameterB);
                executor.setStringParameter("str", parameterStr);
                String result = executor.combine();
                System.out.printf("%s%nDone: result is%n%s%n", executor, result);
                CallSimpleChainForImage.printExecutorInterface((ExecutionBlock)executor);
            }
        }
    }
}

