/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.multichains.MultiChainSpecification;
import net.algart.executors.api.multichains.core.MultiChainExecutor;
import net.algart.executors.api.multichains.core.UseMultiChain;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.settings.core.CombineSettings;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SettingsTree;
import net.algart.executors.api.system.SmartSearchSettings;
import net.algart.json.Jsons;

public class SettingsTreeDemo {
    private static JsonObject buildCustomSettings(SettingsTree tree) {
        return tree.settingsJson(path -> {
            ControlSpecification control = path.reqControl();
            if (control.getValueType() == ParameterValueType.STRING) {
                return Jsons.toJsonStringValue((String)path.toString());
            }
            return Jsons.toJsonDoubleValue((double)111.0);
        });
    }

    public static void main(String[] args) throws IOException {
        CombineSettings executor;
        boolean smart = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-smart")) {
            smart = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.printf("Usage: %s some.chain/some.mchain/some.ss", SettingsTreeDemo.class.getName());
            return;
        }
        ExecutionBlock.initializeExecutionSystem();
        ExecutorFactory factory = ExecutorFactory.newSharedFactory();
        Path executorPath = Paths.get(args[startArgIndex], new String[0]);
        if (SettingsSpecification.isSettingsSpecificationFile((Path)executorPath)) {
            executor = UseSettings.newSharedExecutor((ExecutorFactory)factory, (Path)executorPath);
        } else if (ChainSpecification.isChainSpecificationFile((Path)executorPath)) {
            ChainExecutor chainExecutor = UseChain.newSharedExecutor((Path)executorPath);
            executor = chainExecutor.newCombine();
        } else if (MultiChainSpecification.isMultiChainSpecificationFile((Path)executorPath)) {
            MultiChainExecutor multiChainExecutor = UseMultiChain.newSharedExecutor((Path)executorPath);
            executor = multiChainExecutor.newCombine();
        } else {
            throw new IllegalArgumentException("This file is not settings, chain or multi-chain: " + String.valueOf(executorPath));
        }
        ExecutorSpecification specification = executor.getSpecification();
        SettingsTree tree = smart ? SettingsTree.of((SmartSearchSettings)SmartSearchSettings.newSharedInstance(), (ExecutorSpecification)specification) : SettingsTree.of((ExecutorSpecificationFactory)factory, (ExecutorSpecification)specification);
        System.out.println();
        System.out.printf("**** %s **** %n%s%n%n", tree, tree.specificationJsonString(ExecutorSpecification.JsonMode.CONTROLS_ONLY));
        System.out.printf("**** Default values: **** %n%s%n%n", tree.defaultSettingsJsonString());
        JsonObject customSettings = SettingsTreeDemo.buildCustomSettings(tree);
        System.out.printf("**** Some custom values: **** %n%s%n%n", Jsons.toPrettyString((JsonObject)customSettings));
        System.out.println("**** Trees: ****");
        for (SettingsTree.Path path : tree.treePaths()) {
            System.out.printf("%s:%n    node: %s%n    root: %s%n", path, path.reqTree(), path.rootTree());
        }
        System.out.println();
        System.out.println("**** Controls: ****");
        for (SettingsTree.Path path : tree.controlPaths()) {
            System.out.printf("%s:%n    %s%n", path, path.reqControl().toJson());
        }
    }
}

