/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.js.scriptengine.tests;

import java.util.Locale;
import javax.script.ScriptEngine;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptContextContainer;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;

public class JavaScriptSpeed {
    private static final int N = 1000000;

    public static void main(String[] args) {
        ScriptEngine context = JavaScriptContextContainer.getInstance().getLocalContext();
        JavaScriptPerformer scriptWithLoopOnArray = JavaScriptPerformer.newInstance((String)"var n = 1000000\n    var sum = 0\n    for (let k = 0; k < n; k++) {\n        sum += a[k]\n    }\n", (ScriptEngine)context);
        JavaScriptPerformer scriptWithLoopOnInternalArray = JavaScriptPerformer.newInstance((String)"var n = 1000000\nvar a = new Float64Array(n)\n    for (let k = 0; k < n; k++) {\n        a[k] = k * 0.001;\n    }\n", (ScriptEngine)context);
        JavaScriptPerformer.newInstance((String)"var index=0", (ScriptEngine)context).perform();
        JavaScriptPerformer shortFormula = JavaScriptPerformer.newInstance((String)"var result=index++ * 0.001; a[0]=result", (ScriptEngine)context);
        double[] a = new double[10];
        double[] b = new double[10];
        double[] c = new double[10];
        shortFormula.putVariable("a", (Object)a);
        shortFormula.putVariable("b", (Object)b);
        shortFormula.putVariable("c", (Object)c);
        for (int test = 1; test <= 10; ++test) {
            System.out.printf("Test #%d...%n", test);
            long t1 = System.nanoTime();
            scriptWithLoopOnArray.perform();
            long t2 = System.nanoTime();
            System.out.printf(Locale.US, "eval long script with loop (%s): time %.3f ms, %.4f ns/iteration%n", a[1], (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
            t1 = System.nanoTime();
            scriptWithLoopOnInternalArray.perform();
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "eval long script with loop on Float64Array (%s): time %.3f ms, %.4f ns/iteration%n", a[1], (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
            t1 = System.nanoTime();
            double result = 0.0;
            for (int k = 1; k <= 1000000; ++k) {
                result = shortFormula.calculateDouble();
            }
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "loop of evalDouble (%s): time %.3f ms, %.4f ns/iteration%n%n", result, (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
        }
    }
}

