/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.js.tests;

import java.util.Locale;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.graalvm.js.core.arrays.BlockJSModifyingNamedNumbers;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;
import net.algart.executors.modules.core.numbers.creation.CreateRandomNumbers;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;

public class ArraysJavaScriptSpeed {
    private static final int N = 1000000;
    final ScriptEngine engine = new ScriptEngineManager().getEngineByName("graal.js");
    final CreateRandomNumbers execCreate;
    final BlockJSModifyingNamedNumbers execScript;
    final SNumbers numbers;
    final JavaScriptPerformer formula;
    final Context graalContext;

    public ArraysJavaScriptSpeed() {
        Bindings bindings = this.engine.getBindings(100);
        bindings.put("polyglot.js.allowHostAccess", (Object)true);
        this.execCreate = new CreateRandomNumbers();
        this.execScript = new BlockJSModifyingNamedNumbers();
        this.formula = JavaScriptPerformer.newInstance((String)"var result=index++/1000.0; a[0]=b[1]=c[2]=result", (ScriptEngine)this.engine);
        this.graalContext = Context.newBuilder((String[])new String[]{"js"}).allowExperimentalOptions(true).allowHostAccess(HostAccess.ALL).allowPolyglotAccess(PolyglotAccess.ALL).build();
        this.execCreate.setElementType(Float.TYPE).setBlockLength(5).setNumberOfBlocks(1000000).setMin(-2600000.0).setMax(2500000.0).setRandSeed(2L);
        this.execCreate.process();
        this.numbers = this.execCreate.getNumbers();
        this.execScript.setMainOperator("x1 = x0 + 2.0");
        JavaScriptPerformer.newInstance((String)"var index=0", (ScriptEngine)this.engine).perform();
        this.graalContext.eval("js", (CharSequence)"var index=0");
    }

    private void testExecutor() {
        long t1 = System.nanoTime();
        this.execScript.processNumbers(this.numbers);
        long t2 = System.nanoTime();
        System.out.printf("Numbers processed: %s; %.3f ms, %.2f ns/element%n", this.numbers.getValue(1), (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
    }

    private void testDirectScript() {
        double[] a = new double[10];
        double[] b = new double[10];
        double[] c = new double[10];
        this.formula.putVariable("a", (Object)a);
        this.formula.putVariable("b", (Object)b);
        this.formula.putVariable("c", (Object)c);
        long t1 = System.nanoTime();
        double result = 0.0;
        for (int k = 0; k <= 1000000; ++k) {
            result = this.formula.calculateDouble();
        }
        long t2 = System.nanoTime();
        System.out.printf(Locale.US, "Script executed: %s; %.3f ms, %.4f ns/iteration%n", result + ", " + a[0], (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
    }

    private void testDirectGraal() {
        Value bindings = this.graalContext.getBindings("js");
        double[] a = new double[10];
        double[] b = new double[10];
        double[] c = new double[10];
        bindings.putMember("a", (Object)a);
        bindings.putMember("b", (Object)b);
        bindings.putMember("c", (Object)c);
        long t1 = System.nanoTime();
        double result = 0.0;
        for (int k = 0; k <= 1000000; ++k) {
            result = this.graalContext.eval("js", (CharSequence)this.formula.script()).asDouble();
        }
        long t2 = System.nanoTime();
        System.out.printf(Locale.US, "GraalVM script executed: %s; %.3f ms, %.4f ns/iteration%n", result + ", " + a[0], (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
    }

    public static void main(String[] args) {
        ArraysJavaScriptSpeed test = new ArraysJavaScriptSpeed();
        for (int testIndex = 1; testIndex <= 10; ++testIndex) {
            System.out.printf("%nTest #%d...%n", testIndex);
            test.testExecutor();
            test.testDirectScript();
            test.testDirectGraal();
        }
    }
}

