/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.system.ControlEditionType;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.json.Jsons;

public class CreateExecutorSpecificationTest {
    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 1) {
            System.out.printf("Usage: %s result.json%n", CreateExecutorSpecificationTest.class.getName());
            return;
        }
        Path resultFile = Paths.get(args[0], new String[0]);
        ExecutorSpecification specification = new ExecutorSpecification();
        specification.setVersion("0.0.11");
        specification.setPlatformId("~~~SOME_PLATFORM");
        specification.setCategory("some.category");
        specification.setName("some executor");
        specification.setId("144f8656-91c7-45a8-9e32-c19b179b9d34");
        specification.setLanguage("java");
        ExecutorSpecification.Java java = new ExecutorSpecification.Java();
        java.setJson("{\"class\":\"" + TestExecutor.class.getName() + "\"}");
        specification.setJava(java);
        ExecutorSpecification.Options options = new ExecutorSpecification.Options();
        ExecutorSpecification.Options.Behavior behavior = new ExecutorSpecification.Options.Behavior();
        options.setBehavior(behavior);
        specification.setOptions(options);
        LinkedHashMap<String, PortSpecification> outputPorts = new LinkedHashMap<String, PortSpecification>();
        outputPorts.put("output", new PortSpecification().setName("output").setValueType(DataType.SCALAR));
        specification.setOutputPorts(outputPorts);
        LinkedHashMap<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>();
        controls.put("width", new ControlSpecification().setName("width").setValueType(ParameterValueType.INT));
        ArrayList<ControlSpecification.EnumItem> items = new ArrayList<ControlSpecification.EnumItem>();
        items.add(new ControlSpecification.EnumItem().setValue("MODE_1").setCaption("mode 2"));
        items.add(new ControlSpecification.EnumItem().setValue("MODE_2").setCaption("mode 2"));
        controls.put("mode", new ControlSpecification().setName("mode").setValueType(ParameterValueType.STRING).setCaption("Mode").setEditionType(ControlEditionType.ENUM).setItems(items).setDefaultStringValue("MODE_1"));
        items = new ArrayList();
        items.add(new ControlSpecification.EnumItem().setValue((JsonValue)Jsons.toJsonIntValue((int)1)).setCaption("m_1"));
        items.add(new ControlSpecification.EnumItem().setValue((JsonValue)Jsons.toJsonIntValue((int)2)).setCaption("m_2"));
        controls.put("modeInt", new ControlSpecification().setName("modeInt").setValueType(ParameterValueType.INT).setCaption("Mode (int)").setEditionType(ControlEditionType.ENUM).setItems(items).setDefaultJsonValue((JsonValue)Jsons.toJsonIntValue((int)2)));
        specification.setControls(controls);
        String jsonString = specification.jsonString();
        Files.writeString(resultFile, (CharSequence)jsonString, new OpenOption[0]);
        System.out.printf("Minimal configuration:%n", new Object[0]);
        System.out.println(specification.minimalSpecification());
        System.out.printf("%nFull specification:%n", new Object[0]);
        System.out.println(specification);
        if (specification.isJavaExecutor()) {
            System.out.printf("%nExecutor object:%n", new Object[0]);
            Thread.sleep(100L);
            try {
                Executor executor = (Executor)ExecutionBlock.newExecutor((String)"some_session", (String)specification.minimalSpecification());
                executor.disableOnChangeParametersAutomatic();
                executor.setIntParameter("modeInt", 1);
                System.out.println();
                System.out.println("Full specification:");
                System.out.println(specification.jsonString());
                System.out.println("Minimal specification for creation:");
                System.out.println(executor.getSpecification().jsonString());
                System.out.println("Parameters:");
                System.out.println(executor.parameters());
                System.out.println("Executor:");
                System.out.println(executor);
                System.out.println();
                executor.execute();
            }
            catch (ClassNotFoundException e) {
                System.out.printf("Cannot load required class: %s%n", e);
            }
        }
    }

    public static class TestExecutor
    extends Executor {
        public void process() {
            System.out.println("    Hi from TestExecutor!");
            System.out.println("    My ID: " + this.getExecutorId());
            System.out.println("    Current session ID: " + this.getSessionId());
            System.out.println("    My mode (int): " + this.parameters().getInteger("modeInt"));
        }
    }
}

