/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrays;
import net.algart.arrays.PArray;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.SystemEnvironment;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainOutputPort;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.extensions.InstalledExtensions;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecificationSet;
import net.algart.executors.modules.core.common.TimingStatistics;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public class ExecutingChain {
    public static final String SESSION_ID = "~~DUMMY_SESSION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int k;
        ExecutionBlock.initializeExecutionSystem();
        boolean detailed = false;
        boolean monochrome = false;
        boolean cleanCopy = false;
        boolean executeAll = false;
        boolean multithreading = false;
        boolean ignoreExceptions = false;
        boolean gc = false;
        boolean checkStability = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-detailed")) {
            detailed = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-mono")) {
            monochrome = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-clean")) {
            cleanCopy = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-all")) {
            executeAll = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-multithreading")) {
            multithreading = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-ignoreExceptions")) {
            ignoreExceptions = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-gc")) {
            gc = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-checkStability")) {
            checkStability = true;
            ++startArgIndex;
        }
        System.out.printf("Extensions root: %s%n", InstalledExtensions.EXTENSIONS_ROOT);
        if (args.length < startArgIndex + 1) {
            System.out.printf("Usage: %s [-mono] ]-clean] [-all] [-multithreading] [-ignoreExceptions] [-gc] chain.json [some_image_file result_folder [number_of_tests]]%n", ExecutingChain.class.getName());
            System.out.println("Also please specify the following system variables:");
            System.out.println("    -Dnet.algart.executors.path=folder_with_all_executor_JSONs");
            System.out.println("    -Dnet.algart.executors.api.chains.path=folder_with_standard_chains (optional)");
            System.out.println("    -Dnet.algart.executors.modules.opencv.useGPU=true/false (optional)");
            return;
        }
        Path chainFile = Paths.get(args[startArgIndex], new String[0]);
        Path sourceFile = startArgIndex + 1 < args.length ? Path.of(args[startArgIndex + 1], new String[0]) : null;
        Path resultFolder = startArgIndex + 2 < args.length ? Path.of(args[startArgIndex + 2], new String[0]) : null;
        int numberOfTests = startArgIndex + 3 < args.length ? Integer.parseInt(args[startArgIndex + 3]) : 1;
        System.out.printf("Reading%n    %s%n...", JArrays.toString((Object[])InstalledExtensions.installedExtensionsPaths().toArray(), (String)String.format(";%n    ", new Object[0]), (int)16384));
        long t1 = System.nanoTime();
        ExecutorSpecificationSet executorSpecificationSet = ExecutorSpecificationSet.allBuiltIn();
        long t2 = System.nanoTime();
        System.out.printf(" done (%d executors, %.3f ms)%n", executorSpecificationSet.all().size(), (double)(t2 - t1) * 1.0E-6);
        ExecutorFactory executorFactory = ExecutorFactory.newFactory((String)SESSION_ID);
        System.out.printf("Reading %s...", chainFile);
        t1 = System.nanoTime();
        ChainSpecification chainSpecification = ChainSpecification.read((Path)chainFile);
        Chain originalChain = Chain.of(null, (ExecutorFactory)executorFactory, (ChainSpecification)chainSpecification);
        originalChain.setMultithreading(multithreading);
        originalChain.setExecuteAll(executeAll);
        originalChain.setIgnoreExceptions(ignoreExceptions);
        originalChain.setTimingByExecutorsEnabled(true);
        originalChain.setTimingSettings(1000, new TimingStatistics.Settings().setUniformPercentileLevels(5));
        originalChain.reinitializeAll();
        t2 = System.nanoTime();
        System.out.printf(" done (%.3f ms)%n", (double)(t2 - t1) * 1.0E-6);
        System.out.printf("Chain to execute: %s%n", originalChain);
        if (detailed) {
            System.out.printf("Detailed chain:%n", new Object[0]);
            System.out.println(originalChain.toString(true));
        }
        SMat sourceMat = sourceFile == null ? null : SMat.of((BufferedImage)ImageIO.read(sourceFile.toFile()));
        HashMap<String, SMat> inputs = new HashMap<String, SMat>();
        if (sourceMat != null) {
            if (monochrome) {
                sourceMat = SMat.of((MultiMatrix)sourceMat.toMultiMatrix2D().asMono().clone());
            }
            System.out.printf("Reading source image %s%s: %s%n", monochrome ? "(monochrome) " : "", sourceFile, sourceMat);
            inputs.put(Executor.DEFAULT_INPUT_PORT, sourceMat);
        }
        originalChain.setInputData(inputs);
        System.out.printf("%nExecuting %s blocks, %s mode...%n", executeAll ? "all" : "output and dependent", multithreading ? "multithreading" : "single-thread");
        if (resultFolder != null && !Files.exists(resultFolder, new LinkOption[0])) {
            Files.createDirectory(resultFolder, new FileAttribute[0]);
        }
        for (int test = 1; test <= numberOfTests; ++test) {
            System.out.printf("%nTest #%d/%d...%n", test, numberOfTests);
            System.gc();
            if (gc) {
                for (int k2 = 0; k2 < 5; ++k2) {
                    System.gc();
                }
            }
            System.out.println(Executor.Timing.getInstance().startingInfo());
            t1 = System.nanoTime();
            Executor.Timing.getInstance().start();
            Chain chain = originalChain;
            if (cleanCopy) {
                chain = chain.cleanCopy();
                chain.reinitializeAll();
                chain.setInputData(inputs);
            }
            t2 = System.nanoTime();
            try {
                chain.execute();
            }
            finally {
                Executor.Timing.getInstance().finish();
            }
            long t3 = System.nanoTime();
            boolean unstable = false;
            for (ChainBlock block : chain.getAllOutputs()) {
                ChainOutputPort outputPort = block.reqStandardOutputPort();
                Data data = outputPort.getData();
                String name = block.getStandardInputOutputName();
                String nameForFile = name.replaceAll("[\\/\\\\]", "_");
                System.out.printf("Output block \"%s\" result: %s%n", name, data);
                if (data.isInitialized() && resultFolder != null) {
                    Object text;
                    Path textFile = resultFolder.resolve(nameForFile + ".txt");
                    if (checkStability && data instanceof SMat) {
                        MultiMatrix2D multiMatrix2D = ((SMat)data).toMultiMatrix2D();
                        PArray halftone = (PArray)multiMatrix2D.intensityChannel().array();
                        text = String.valueOf(multiMatrix2D) + ": data hash=" + halftone.hashCode() + ", mean=" + Arrays.sumOf((PArray)halftone) / (double)halftone.length() / halftone.maxPossibleValue(1.0);
                    } else {
                        text = data instanceof SNumbers ? ((SNumbers)data).toString(true) : data.toString();
                    }
                    boolean changed = false;
                    if (checkStability && test > 1) {
                        String previous = Files.readString(textFile);
                        if (((String)text).equalsIgnoreCase(previous)) {
                            System.out.printf("Checking stability of \"%s\": stable result%n", name);
                        } else {
                            changed = true;
                            unstable = true;
                            System.err.printf("Output block \"%s\" CHANGED!%n[[[%s]]]%n instead of %n[[[%s]]]%n%n", name, text, previous);
                        }
                    }
                    Files.writeString(textFile, (CharSequence)text, new OpenOption[0]);
                    if (!(data instanceof SMat) || ((SMat)data).getDimCount() != 2) continue;
                    Path imageFile = resultFolder.resolve(nameForFile + (changed ? ".changed" : "") + ".bmp");
                    BufferedImage bufferedImage = ((SMat)data).toBufferedImage();
                    assert (bufferedImage != null);
                    System.out.printf("Saving result in %s%n", imageFile);
                    MatrixIO.writeBufferedImage((Path)imageFile, (BufferedImage)bufferedImage);
                    continue;
                }
                System.out.printf("WARNING: output block \"%s\" has no initialized data%n", name);
            }
            System.out.println();
            System.out.printf(Locale.US, "Executed %d/%d blocks%n", chain.numberOfReadyBlocks(), chain.numberOfBlocks());
            if (unstable) {
                return;
            }
            System.out.printf(Locale.US, "Execution time: %.3f ms%s%n", (double)(t3 - t1) * 1.0E-6, cleanCopy ? String.format(Locale.US, ", including %.3f ms initializing", (double)(t2 - t1) * 1.0E-6) : "");
            System.out.println(Executor.Timing.getInstance().finishingInfo());
            System.out.println(chain.timingInfo());
            chain.freeData();
            if (!gc) continue;
            for (int k3 = 0; k3 < 5; ++k3) {
                System.gc();
            }
        }
        originalChain.freeResources();
        if (gc) {
            for (k = 0; k < 5; ++k) {
                System.gc();
            }
        }
        System.out.print(Executor.Timing.memoryInfo());
        originalChain = null;
        if (gc) {
            for (k = 0; k < 10; ++k) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.print(Executor.Timing.memoryInfo());
            }
        }
    }

    static {
        String property = System.getProperty("java.util.logging.config.file");
        if (property != null) {
            property = SystemEnvironment.replaceHomeEnvironmentVariable((String)property);
            System.setProperty("java.util.logging.config.file", property);
        }
    }
}

