/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.util.Locale;
import net.algart.executors.api.ExecutionStatus;

public class ExecutionStatusTest {
    public static void main(String[] args) {
        ExecutionStatus parent = ExecutionStatus.newNamedInstance((String)"parent");
        parent.open(null);
        parent.setMessage(() -> "parent");
        System.out.println("parent: " + String.valueOf(parent));
        ExecutionStatus child1 = ExecutionStatus.newInstance();
        child1.open(parent);
        child1.setMessage(() -> "child1");
        System.out.println("parent: " + String.valueOf(parent));
        child1.close();
        System.out.println("parent: " + String.valueOf(parent));
        ExecutionStatus child2 = ExecutionStatus.newInstance();
        child2.open(parent);
        child2.setMessage(() -> "child2");
        child2.setExecutorSimpleClassName(ExecutionStatusTest.class.getName());
        child2.setStartProcessingTimeStamp();
        child2.setClassInformationIncluded(true);
        System.out.println("parent: " + String.valueOf(parent));
        System.out.println("child2: " + String.valueOf(child2));
        ExecutionStatus child3 = ExecutionStatus.newInstance();
        ExecutionStatus child4 = ExecutionStatus.newInstance();
        child3.open(child2);
        child4.open(child3);
        child3.setMessage(() -> "child3").setComment(() -> "some executor");
        child4.setMessage(() -> "child4");
        System.out.println("parent: " + String.valueOf(parent));
        System.out.println("child2: " + String.valueOf(child2));
        child3.clear();
        System.out.println("parent: " + String.valueOf(parent));
        System.out.println("child2: " + String.valueOf(child2));
        child4.close();
        child3.close();
        System.out.println("parent: " + String.valueOf(parent));
        child2.close();
        System.out.println("parent: " + String.valueOf(parent));
        child1.open(parent);
        child1.setMessage(() -> "child1 again");
        for (int test = 1; test <= 16; ++test) {
            System.out.printf("Test #%d...%n", test);
            int n = 1000000;
            long t1 = System.nanoTime();
            for (int k = 0; k < 1000000; ++k) {
                child1.setMessageString(k + 1 + "/1000000 executed");
            }
            long t2 = System.nanoTime();
            System.out.printf(Locale.US, "setMessageString: %.2f ns/call - %s%n", (double)(t2 - t1) / 1000000.0, parent);
            t1 = System.nanoTime();
            int k = 0;
            while (k < 1000000) {
                int index = k++;
                child1.setMessage(() -> index + 1 + "/1000000 executed");
            }
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "setMessage:       %.2f ns/call - %s%n", (double)(t2 - t1) / 1000000.0, parent);
        }
        System.out.println();
        child2.open(child1);
        System.out.println("parent again: " + String.valueOf(parent));
    }
}

