/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.io.IOException;
import java.util.Set;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SmartSearchSettings;

public class ExecutorLoaderSetTest {
    private static ExecutorSpecificationFactory factory(boolean parseAll) {
        ExecutorLoaderSet global = ExecutionBlock.globalLoaders();
        return parseAll ? executorId -> global.getSpecification(null, executorId, true) : global.newFactory("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f");
    }

    public static void main(String[] args) throws IOException {
        ExecutorSpecificationFactory factory;
        int test;
        boolean parseAll = args.length > 0 && args[0].equals("--parse-all");
        System.out.println(parseAll ? "Using slow non-optimized factory (parsing all)" : "Using standard factory");
        long t1 = System.nanoTime();
        ExecutionBlock.initializeExecutionSystem();
        long t2 = System.nanoTime();
        ExecutorLoaderSet global = ExecutionBlock.globalLoaders();
        Set allIds = global.allExecutorIds(null, true);
        System.out.printf("Found %d standard executors in %.3f ms%n", allIds.size(), (double)(t2 - t1) * 1.0E-6);
        long n = 0L;
        for (test = 1; test <= 16; ++test) {
            factory = ExecutorLoaderSetTest.factory(parseAll);
            t1 = System.nanoTime();
            n = allIds.stream().filter(id -> factory.getSettingsSpecification(id) != null).count();
            t2 = System.nanoTime();
            System.out.printf("Test #%d: found %d settings among all %d in %.3f ms%n", test, n, allIds.size(), (double)(t2 - t1) * 1.0E-6);
        }
        System.out.println();
        for (test = 1; test <= 16; ++test) {
            factory = ExecutorLoaderSetTest.factory(parseAll);
            t1 = System.nanoTime();
            Set probableIds = SmartSearchSettings.probableSettingsIds((ExecutorLoaderSet)global, null);
            t2 = System.nanoTime();
            long m = probableIds.stream().filter(id -> factory.getSettingsSpecification(id) != null).count();
            long t3 = System.nanoTime();
            if (n != m) {
                throw new AssertionError((Object)(m + " != " + n));
            }
            System.out.printf("Test #%d: found %d settings among %d probables in %.3f ms + %.3f ms%n", test, n, probableIds.size(), (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6);
        }
    }
}

