/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;

public class ExtensionTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.printf("Usage: %s extensionFolder result.json%n", ExtensionTest.class.getName());
            return;
        }
        Path extensionFolder = Paths.get(args[0], new String[0]);
        Path resultFile = Paths.get(args[1], new String[0]);
        System.out.printf("Analysing extension folder %s...%n", extensionFolder);
        ExtensionSpecification extension = ExtensionSpecification.readFromFolder((Path)extensionFolder);
        System.out.printf("Writing %s...%n", resultFile);
        extension.write(resultFile, new OpenOption[0]);
        System.out.printf("Extension:%n%s%n", extension);
        System.out.printf("Its platforms:%n", new Object[0]);
        for (ExtensionSpecification.Platform platform : extension.getPlatforms()) {
            System.out.printf("    Technologies: %s%n", platform.getTechnologies());
            System.out.printf("    Folders: %s%n", platform.getFolders());
            if (!platform.isJvmTechnology()) continue;
            ExtensionSpecification.Platform.Configuration configuration = platform.getConfiguration();
            System.out.printf("        classpath: %s%n", configuration.getClasspath());
            System.out.printf("        VM options: %s%n", configuration.getVmOptions());
        }
        ExtensionSpecification.Platform empty = new ExtensionSpecification.Platform().setId("some id").setCategory("some category").setName("some name").setTechnologies(List.of("jvm"));
        System.out.printf("%nEmpty JVM platform:%n    %s%n%s%n", empty, empty.jsonString());
        System.out.printf("%n%n****************%nInstalled extensions:%n", new Object[0]);
        for (ExtensionSpecification extensionSpecification : InstalledExtensions.allInstalledExtensions()) {
            System.out.println(extensionSpecification.jsonString());
        }
        System.out.printf("%n%n****************%nInstalled platforms:%n", new Object[0]);
        for (Map.Entry entry : InstalledExtensions.allInstalledPlatformsMap().entrySet()) {
            ExtensionSpecification.Platform platform = (ExtensionSpecification.Platform)entry.getValue();
            System.out.println((String)entry.getKey() + ": " + platform.jsonString() + " [" + (platform.isBuiltIn() ? "supported, " : "") + String.valueOf(platform.getFolders().getRoot()) + "]");
        }
    }
}

