/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.util.Arrays;
import java.util.Date;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SScalar;

public class SScalarTest {
    private static void show(SScalar scalar) {
        double[] doubles;
        String toDoubles = null;
        String toDoubles3 = null;
        try {
            doubles = scalar.toDoubles();
            toDoubles = "double[" + doubles.length + "] = " + Arrays.toString(doubles);
        }
        catch (NumberFormatException e) {
            toDoubles = "{{EXCEPTION: " + e.getMessage() + "}}";
        }
        try {
            doubles = scalar.toDoubles(3);
            toDoubles3 = "double[" + doubles.length + "] = " + Arrays.toString(doubles);
        }
        catch (IllegalStateException | NumberFormatException e) {
            toDoubles3 = "{{EXCEPTION: " + e.getMessage() + "}}";
        }
        System.out.printf("Scalar value: %s;%n  toString(): \"%s\";%n  toDoubles(): %s;%n  toDoubles(3): %s%n", scalar.getValue() == null ? "<<null>>" : "\"" + scalar.getValue() + "\"", scalar.toString(), toDoubles, toDoubles3);
    }

    public static void main(String[] args) {
        SScalar scalar = new SScalar();
        SScalarTest.show(scalar);
        scalar.setTo(123);
        SScalarTest.show(scalar);
        scalar.setTo(123.0);
        SScalarTest.show(scalar);
        scalar.setTo("");
        SScalarTest.show(scalar);
        scalar.setTo(Arrays.asList("A", "B", "C"));
        SScalarTest.show(scalar);
        scalar.setTo(new double[]{255.0, 255.0, 0.0});
        SScalarTest.show(scalar);
        scalar.setToNull();
        SScalarTest.show(scalar);
        scalar.setTo(new SScalar().setTo("Other scalar"));
        SScalarTest.show(scalar);
        try {
            scalar.setTo((Data)new SMat());
            SScalarTest.show(scalar);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        scalar.setTo((Object)new Date());
        SScalarTest.show(scalar);
        scalar.setTo("");
        SScalarTest.show(scalar);
        scalar.setTo(" 123\r");
        SScalarTest.show(scalar);
        scalar.setTo(" 123\n\t124\t; 125,1 ,126.11111");
        SScalarTest.show(scalar);
        scalar.setTo(123456789);
        System.out.printf("%ntoDouble(): %s, toInt(): %s%n", scalar.toDouble(), scalar.toInt());
        scalar.setTo(1.2345678912345E13);
        try {
            System.out.printf("%ntoDouble(): %s, toInt(): %s%n", scalar.toDouble(), scalar.toInt());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

