/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.awt.geom.Point2D;
import java.util.Locale;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.contexts.InterruptionException;
import net.algart.contours.ContourHeader;
import net.algart.contours.ContourNestingAnalyser;
import net.algart.contours.Contours;
import net.algart.contours.InsideContourStatus;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ContoursInsideStatusTest
extends Executor {
    public static final String INPUT_BACKGROUND = "background";
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_STATUS = "status";
    public static final String OUTPUT_POINT_INFORMATION = "point_information";
    public static final String OUTPUT_ROUNDED_POINT_INFORMATION = "rounded_point_information";
    private boolean processAllPixels = false;
    private boolean unpackContours = false;
    private boolean simpleCheckOfAllContours = false;
    private double x = 0.0;
    private double y = 0.0;
    private int startX = 0;
    private int startY = 0;
    private int sizeX = 256;
    private int sizeY = 256;
    private double scale = 1.0;
    private boolean multiplySizesByScale = false;
    private float horizontalBoundaryCode = 1000.5f;
    private float boundaryIncrement = 500.5f;
    private boolean findRepresentatives = true;
    private float insideRepresentativeCode = 800.0f;
    private float boundaryRepresentativeCode = 900.0f;

    public ContoursInsideStatusTest() {
        this.setDefaultInputNumbers(INPUT_CONTOURS);
        this.addInputMat(INPUT_BACKGROUND);
        this.setDefaultOutputMat(OUTPUT_STATUS);
        this.addOutputScalar(OUTPUT_POINT_INFORMATION);
        this.addOutputScalar(OUTPUT_ROUNDED_POINT_INFORMATION);
    }

    public boolean isProcessAllPixels() {
        return this.processAllPixels;
    }

    public ContoursInsideStatusTest setProcessAllPixels(boolean processAllPixels) {
        this.processAllPixels = processAllPixels;
        return this;
    }

    public boolean isUnpackContours() {
        return this.unpackContours;
    }

    public ContoursInsideStatusTest setUnpackContours(boolean unpackContours) {
        this.unpackContours = unpackContours;
        return this;
    }

    public boolean isSimpleCheckOfAllContours() {
        return this.simpleCheckOfAllContours;
    }

    public ContoursInsideStatusTest setSimpleCheckOfAllContours(boolean simpleCheckOfAllContours) {
        this.simpleCheckOfAllContours = simpleCheckOfAllContours;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public ContoursInsideStatusTest setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public ContoursInsideStatusTest setY(double y) {
        this.y = y;
        return this;
    }

    public int getStartX() {
        return this.startX;
    }

    public ContoursInsideStatusTest setStartX(int startX) {
        this.startX = startX;
        return this;
    }

    public int getStartY() {
        return this.startY;
    }

    public ContoursInsideStatusTest setStartY(int startY) {
        this.startY = startY;
        return this;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public ContoursInsideStatusTest setSizeX(int sizeX) {
        this.sizeX = ContoursInsideStatusTest.positive((int)sizeX);
        return this;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public ContoursInsideStatusTest setSizeY(int sizeY) {
        this.sizeY = ContoursInsideStatusTest.positive((int)sizeY);
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public ContoursInsideStatusTest setScale(double scale) {
        this.scale = scale;
        return this;
    }

    public boolean isMultiplySizesByScale() {
        return this.multiplySizesByScale;
    }

    public ContoursInsideStatusTest setMultiplySizesByScale(boolean multiplySizesByScale) {
        this.multiplySizesByScale = multiplySizesByScale;
        return this;
    }

    public float getHorizontalBoundaryCode() {
        return this.horizontalBoundaryCode;
    }

    public ContoursInsideStatusTest setHorizontalBoundaryCode(float horizontalBoundaryCode) {
        this.horizontalBoundaryCode = horizontalBoundaryCode;
        return this;
    }

    public float getBoundaryIncrement() {
        return this.boundaryIncrement;
    }

    public ContoursInsideStatusTest setBoundaryIncrement(float boundaryIncrement) {
        this.boundaryIncrement = boundaryIncrement;
        return this;
    }

    public boolean isFindRepresentatives() {
        return this.findRepresentatives;
    }

    public ContoursInsideStatusTest setFindRepresentatives(boolean findRepresentatives) {
        this.findRepresentatives = findRepresentatives;
        return this;
    }

    public float getInsideRepresentativeCode() {
        return this.insideRepresentativeCode;
    }

    public ContoursInsideStatusTest setInsideRepresentativeCode(float insideRepresentativeCode) {
        this.insideRepresentativeCode = insideRepresentativeCode;
        return this;
    }

    public float getBoundaryRepresentativeCode() {
        return this.boundaryRepresentativeCode;
    }

    public ContoursInsideStatusTest setBoundaryRepresentativeCode(float boundaryRepresentativeCode) {
        this.boundaryRepresentativeCode = boundaryRepresentativeCode;
        return this;
    }

    public void process() {
        SNumbers inputContours = this.getInputNumbers(INPUT_CONTOURS);
        Contours sourceContours = Contours.deserialize((int[])inputContours.toIntArrayOrReference());
        Contours contours = this.unpackContours ? sourceContours.unpackContours(true) : sourceContours;
        double scaleInv = 1.0 / this.scale;
        ContourNestingAnalyser analyser = ContourNestingAnalyser.newInstance((Contours)contours, (boolean)this.unpackContours, null);
        this.getScalar(OUTPUT_POINT_INFORMATION).setTo(ContoursInsideStatusTest.testPointDetailed(analyser, (this.x + (double)this.startX) * scaleInv, (this.y + (double)this.startY) * scaleInv));
        this.getScalar(OUTPUT_ROUNDED_POINT_INFORMATION).setTo(ContoursInsideStatusTest.testPointDetailed(analyser, (Math.rint(this.x) + (double)this.startX) * scaleInv, (Math.rint(this.y) + (double)this.startY) * scaleInv));
        if (this.processAllPixels) {
            long t1 = ContoursInsideStatusTest.debugTime();
            int sizeX = this.multiplySizesByScale ? Arrays.round32((double)((double)this.sizeX * this.scale)) : this.sizeX;
            int sizeY = this.multiplySizesByScale ? Arrays.round32((double)((double)this.sizeY * this.scale)) : this.sizeY;
            float[] infoMap = new float[sizeX * sizeY];
            IntStream.range(0, sizeY).parallel().forEach(i -> {
                PointTester tester = new PointTester(contours);
                int j = 0;
                int disp = i * sizeX;
                while (j < sizeX) {
                    double x = (double)(j + this.startX) * scaleInv;
                    double y = (double)(i + this.startY) * scaleInv;
                    if (this.simpleCheckOfAllContours) {
                        infoMap[disp] = this.testPoint(contours, x, y);
                    } else {
                        tester.initialize(x, y);
                        analyser.findRectanglesContainingPoint(x, y, (IntConsumer)tester);
                        infoMap[disp] = tester.result();
                    }
                    ++j;
                    ++disp;
                }
                if (this.isInterrupted()) {
                    throw new InterruptionException("Processing pixels was interrupted");
                }
            });
            long t2 = ContoursInsideStatusTest.debugTime();
            if (this.findRepresentatives) {
                Point2D.Double point = new Point2D.Double();
                int n = contours.numberOfContours();
                for (int k = 0; k < n; ++k) {
                    boolean found = contours.findSomePointInside((Point2D)point, k, this.unpackContours);
                    float code = found ? this.insideRepresentativeCode : this.boundaryRepresentativeCode;
                    int j = (int)(((Point2D)point).getX() * this.scale - (double)this.startX);
                    int i2 = (int)(((Point2D)point).getY() * this.scale - (double)this.startY);
                    if (j < 0 || j >= sizeX || i2 < 0 || i2 >= sizeY) continue;
                    infoMap[i2 * sizeX + j] = code;
                }
            }
            long t3 = ContoursInsideStatusTest.debugTime();
            MultiMatrix2D result = MultiMatrix.of2DMono((Matrix)Matrices.matrix((Array)SimpleMemoryModel.asUpdatableFloatArray((float[])infoMap), (long[])new long[]{sizeX, sizeY}));
            ContoursInsideStatusTest.logDebug(() -> String.format(Locale.US, "Checking %d contours in %.3f ms, %.5f mcs/pixel; finding representatives %.3f ms", contours.numberOfContours(), (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001 / (double)infoMap.length, (double)(t3 - t2) * 1.0E-6));
            this.getMat().setTo((MultiMatrix)result);
            if (this.findRepresentatives) {
                Point2D.Double point = new Point2D.Double();
                int n = contours.numberOfContours();
                for (int k = 0; k < n; ++k) {
                    boolean found = contours.findSomePointInside((Point2D)point, k, this.unpackContours);
                    double information = contours.pointInsideContourInformation(k, ((Point2D)point).getX(), ((Point2D)point).getY(), this.unpackContours);
                    int j = (int)(((Point2D)point).getX() * this.scale - (double)this.startX);
                    int i3 = (int)(((Point2D)point).getY() * this.scale - (double)this.startY);
                    if (found) {
                        if (!InsideContourStatus.isStrictlyInside((double)information)) {
                            throw new AssertionError((Object)("Failure of finding inside point in the contour #" + k + ": " + String.valueOf(point) + " (" + j + ", " + i3 + " at the image) is not inside, its status is " + String.valueOf(InsideContourStatus.valueOfInformation((double)information)) + " (information: " + information + ")"));
                        }
                        continue;
                    }
                    if (((Point2D)point).getX() != contours.getContourPointX(k, 0) || ((Point2D)point).getY() != contours.getContourPointY(k, 0)) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private float testPoint(Contours contours, double x, double y) {
        double minWidth = Double.POSITIVE_INFINITY;
        boolean boundary = false;
        ContourHeader header = new ContourHeader();
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            double width;
            contours.getHeader(header, k);
            if ((double)header.minX() > x || x > (double)header.maxX() || (double)header.minY() > y || y > (double)header.maxY()) continue;
            double info = contours.pointInsideContourInformation(k, x, y, this.unpackContours);
            InsideContourStatus status = InsideContourStatus.valueOfInformation((double)info);
            if (status.isBoundary()) {
                boundary = true;
                if (InsideContourStatus.isHorizontalBoundary((double)info)) {
                    return this.horizontalBoundaryCode;
                }
                width = Math.abs(InsideContourStatus.getBoundarySectionSecondEnd((double)info) - x);
                if (!(width < minWidth)) continue;
                minWidth = width;
                continue;
            }
            if (!status.isStrictlyInside() || !((width = InsideContourStatus.getInsideSectionWidth((double)info)) < minWidth)) continue;
            minWidth = width;
        }
        return minWidth == Double.POSITIVE_INFINITY ? -1.0f : (boundary ? (float)minWidth + this.boundaryIncrement : (float)minWidth);
    }

    private static String testPointDetailed(ContourNestingAnalyser analyser, double x, double y) {
        StringBuilder sb = new StringBuilder();
        Contours contours = analyser.contours();
        sb.append("Contours, containing point (").append(x).append(", ").append(y).append("):");
        analyser.findContoursContainingInside(x, y, index -> sb.append(" ").append(index));
        sb.append("\nMinimal containing contour: ");
        ContourNestingAnalyser.NestingInformation nesting = analyser.analysePoint(x, y);
        sb.append(nesting.getNestingParent());
        sb.append(", nesting level: ");
        sb.append(nesting.getNestingLevel());
        sb.append("\n");
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            double info = contours.pointInsideContourInformation(k, x, y, false);
            InsideContourStatus status = InsideContourStatus.valueOfInformation((double)info);
            if (status.isBoundary()) {
                sb.append("boundary of contour #").append(k);
                if (InsideContourStatus.isHorizontalBoundary((double)info)) {
                    sb.append(", horizontal part");
                } else if (InsideContourStatus.isLeftBoundary((double)info)) {
                    sb.append(", left point, the right end is ").append(InsideContourStatus.getBoundarySectionSecondEnd((double)info));
                } else if (InsideContourStatus.isRightBoundary((double)info)) {
                    sb.append(", degenerated (both left and right)");
                    double storedX = InsideContourStatus.getBoundarySectionSecondEnd((double)info);
                    if (storedX != x) {
                        throw new AssertionError((Object)("Invalid stored X = " + storedX));
                    }
                } else {
                    throw new AssertionError((Object)("Unknown boundary code " + info));
                }
                sb.append("\n");
                contours.pointInsideContourInformation(k, x, y, false);
                continue;
            }
            if (!status.isStrictlyInside()) continue;
            sb.append("inside contour #").append(k).append(", section width ").append(InsideContourStatus.getInsideSectionWidth((double)info)).append("\n");
        }
        return sb.length() == 0 ? "outside all" : sb.toString();
    }

    private class PointTester
    implements IntConsumer {
        final Contours contours;
        private double x;
        private double y;
        private double minWidth;
        boolean boundary;
        boolean horizontalBoundary;

        PointTester(Contours contours) {
            this.contours = contours;
        }

        void initialize(double x, double y) {
            this.x = x;
            this.y = y;
            this.minWidth = Double.POSITIVE_INFINITY;
            this.boundary = false;
            this.horizontalBoundary = false;
        }

        @Override
        public void accept(int index) {
            double width;
            double info = this.contours.pointInsideContourInformation(index, this.x, this.y, ContoursInsideStatusTest.this.unpackContours);
            InsideContourStatus status = InsideContourStatus.valueOfInformation((double)info);
            if (status.isBoundary()) {
                this.boundary = true;
                if (InsideContourStatus.isHorizontalBoundary((double)info)) {
                    this.horizontalBoundary = true;
                } else {
                    double width2 = Math.abs(InsideContourStatus.getBoundarySectionSecondEnd((double)info) - this.x);
                    if (width2 < this.minWidth) {
                        this.minWidth = width2;
                    }
                }
            } else if (status.isStrictlyInside() && (width = InsideContourStatus.getInsideSectionWidth((double)info)) < this.minWidth) {
                this.minWidth = width;
            }
        }

        public float result() {
            return this.horizontalBoundary ? ContoursInsideStatusTest.this.horizontalBoundaryCode : (this.minWidth == Double.POSITIVE_INFINITY ? -1.0f : (this.boundary ? (float)this.minWidth + ContoursInsideStatusTest.this.boundaryIncrement : (float)this.minWidth));
        }
    }
}

