/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelGenerator;
import net.algart.executors.modules.core.matrices.drawing.DrawArrow;

public final class ExampleKimRotemDatan
extends MultiMatrixChannelGenerator {
    private static final String KIM_COLOR = "#bebe00ff";
    private static final String ROTEM_COLOR = "#8e0000ff";
    private static final String DATAN_COLOR = "#00005eff";

    public ExampleKimRotemDatan() {
        this.setNumberOfChannels(4);
        this.setElementType(Byte.TYPE);
    }

    public void process() {
        super.process();
        if (this.parameters().getBoolean("arrows", false)) {
            BufferedImage bufferedImage = this.getMat().toBufferedImage();
            this.addArrows(bufferedImage);
            this.getMat().setTo(bufferedImage);
        }
    }

    protected Matrix<? extends PArray> createChannel() {
        double width;
        double beta;
        double alpha;
        int y;
        double maxPossibleValue = 255.0;
        int dimX = (int)this.getDimX();
        int dimY = (int)this.getDimY();
        int yFrom = dimY / 10;
        int y3StreamsFrom = dimY / 3;
        int y3StreamsTo = 2 * dimY / 3;
        int kimValue = (int)this.colorChannel(KIM_COLOR, 255.0);
        int rotemValue = (int)this.colorChannel(ROTEM_COLOR, 255.0);
        int datanValue = (int)this.colorChannel(DATAN_COLOR, 255.0);
        int transparentValue = this.currentChannel() == 3 ? 0 : 255;
        int[] ryb = new int[dimX];
        for (int x = 0; x < dimX; ++x) {
            ryb[x] = x < dimX / 3 ? kimValue : (x < 2 * dimX / 3 ? rotemValue : datanValue);
        }
        int[] transparent = new int[dimX];
        for (int x = 0; x < dimX; ++x) {
            transparent[x] = transparentValue;
        }
        int[] spectrum = new int[dimX];
        for (int x = 0; x < dimX; ++x) {
            double h = 1.0 - (double)x / (double)dimX + 0.5;
            Color color = Color.getHSBColor((float)h, 1.0f, 1.0f);
            spectrum[x] = (int)this.colorChannel(color, 255.0);
        }
        byte[] bytes = new byte[dimX * dimY];
        JArrays.fill((byte[])bytes, (byte)((byte)transparentValue));
        for (y = 0; y < yFrom; ++y) {
            alpha = (double)y / (double)yFrom;
            beta = (double)y / (double)y3StreamsFrom;
            width = (double)dimX * (0.5 + 0.5 * beta);
            ExampleKimRotemDatan.compressLine(bytes, y * dimX, spectrum, Math.pow(alpha, 0.5), transparent, width);
        }
        for (y = yFrom; y < y3StreamsFrom; ++y) {
            alpha = (double)(y - yFrom) / (double)(y3StreamsFrom - yFrom);
            beta = (double)y / (double)y3StreamsFrom;
            width = (double)dimX * (0.5 + 0.5 * beta);
            ExampleKimRotemDatan.compressLine(bytes, y * dimX, ryb, alpha, spectrum, width);
        }
        int disp = y * dimX;
        for (y = y3StreamsFrom; y < y3StreamsTo; ++y) {
            int x = 0;
            while (x < dimX) {
                bytes[disp] = (byte)ryb[x];
                ++x;
                ++disp;
            }
        }
        for (y = y3StreamsTo; y < dimY; ++y) {
            double alpha2 = (double)(dimY - 1 - y) / (double)(dimY - y3StreamsTo);
            double width2 = (double)dimX * (0.5 + 0.5 * alpha2);
            ExampleKimRotemDatan.compressLine(bytes, y * dimX, ryb, Math.pow(alpha2, 0.5), transparent, width2);
        }
        return Matrix.as((Object)bytes, (long[])new long[]{dimX, dimY});
    }

    private void addArrows(BufferedImage image) {
        int dimX = (int)this.getDimX();
        int dimY = (int)this.getDimY();
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(Color.WHITE);
        int length = (int)(0.1 * (double)dimY);
        int yCenter = (int)(0.55 * (double)dimY);
        for (int k = 0; k < 3; ++k) {
            int x = (int)Math.round((0.16666666666666666 + (double)k / 3.0) * (double)dimX);
            DrawArrow.drawArrowLine((Graphics2D)g, (int)x, (int)(yCenter + length), (int)x, (int)(yCenter - length), (double)5.0, (double)(0.3 * (double)length), (double)(0.1 * (double)length));
        }
    }

    private static void compressLine(byte[] result, int resultOffset, int[] data1, double alpha1, int[] data2, double compressedWidth) {
        int dimX = data1.length;
        double alpha2 = 1.0 - alpha1;
        int x = 0;
        int disp = resultOffset;
        while (x < dimX) {
            int i = dimX / 2 + (int)((double)(x - dimX / 2) * (double)dimX / compressedWidth);
            if (i >= 0 && i < dimX) {
                result[disp] = (byte)((double)data1[i] * alpha1 + (double)data2[i] * alpha2);
            }
            ++x;
            ++disp;
        }
    }

    private static String getFileExtension(String fileName) {
        int p = fileName.lastIndexOf(46);
        if (p == -1) {
            return "bmp";
        }
        return fileName.substring(p + 1);
    }

    public static void main(String[] args) throws IOException {
        BufferedImage result;
        if (args.length < 1) {
            System.out.printf("Usage: %s resultFile.png%n", ExampleKimRotemDatan.class.getName());
            return;
        }
        File resultFile = new File(args[0]);
        try (ExampleKimRotemDatan executor = new ExampleKimRotemDatan();){
            executor.setDimX(250L);
            executor.setDimY(500L);
            executor.setAllOutputsNecessary(true);
            executor.execute();
            result = executor.getMat().toBufferedImage();
        }
        ImageIO.write((RenderedImage)result, ExampleKimRotemDatan.getFileExtension(resultFile.getName()), resultFile);
    }
}

