/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.executors.api.Executor;
import net.algart.executors.api.Previewable;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SScalar;

public final class ExampleSMatPreviewable
extends Executor
implements Previewable {
    private int width = 100;
    private int height = 100;
    private final AtomicLong executeCount = new AtomicLong();
    private final AtomicLong previewCount = new AtomicLong();

    public ExampleSMatPreviewable() {
        this.setDefaultOutputMat("output");
    }

    public void process() {
        assert (this.width > 10);
        System.out.println("execute properties.color = " + this.parameters().getString("color"));
        Port output = this.getOutputPort("output");
        SMat m = (SMat)output.getData();
        System.out.println("ExampleSMatPreviewable: execute #" + this.executeCount.incrementAndGet());
        this.createResult(m);
    }

    public Data createPreview() {
        System.out.println("preview properties.color = " + this.parameters().getString("color"));
        System.out.println("ExampleSMatPreviewable: preview #" + this.previewCount.incrementAndGet());
        return this.width <= 100 && this.height <= 100 ? SScalar.of((Object)"Small matrix") : this.getOutputPort("output").getData();
    }

    public void onChangeParameter(String name) {
        switch (name) {
            case "width": {
                this.width = this.parameters().getInteger(name);
                break;
            }
            case "height": {
                this.height = this.parameters().getInteger(name);
            }
        }
    }

    private void createResult(SMat m) {
        Color color = Color.decode(this.parameters().getString("color"));
        System.out.println("Filling by " + String.valueOf(color));
        int channels = 3;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.height * this.width * channels);
        byteBuffer.position(0);
        m.setAll(new long[]{this.width, this.height}, SMat.Depth.U8, channels, byteBuffer, false);
        for (int i = 0; i < byteBuffer.capacity() / 3; ++i) {
            int r = (byte)i * color.getRed() / 255;
            int g = (byte)i * color.getGreen() / 255;
            int b = (byte)i * color.getBlue() / 255;
            byteBuffer.put((byte)b);
            byteBuffer.put((byte)g);
            byteBuffer.put((byte)r);
        }
    }
}

