/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.nio.file.Path;
import javax.script.ScriptException;
import net.algart.arrays.Matrix;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.graalvm.GraalSafety;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalBindingTest {
    Context safe = GraalSafety.SAFE.newBuilder(new String[0]).currentWorkingDirectory(Path.of("/tmp", new String[0]).toAbsolutePath()).build();
    Context pure = GraalSafety.PURE.newBuilder(new String[0]).build();
    Source creation = Source.newBuilder((String)"js", (CharSequence)"function createObject() { return new Object() }\ncreateObject", (String)"test.mjs").buildLiteral();
    Source code = Source.newBuilder((String)"js", (CharSequence)"function exec(obj) {   obj.d = obj.a[0] + obj.a[1] + obj.b;\n   print('Object: ' + obj, typeof(obj));\n   print('a: ' + obj.a, typeof(obj.a));\n   print('b: ' + obj.b, typeof(obj.b));\n   print('c1: ' + obj.c1, typeof(obj.c1));\n   print('c2: ' + obj.c2, typeof(obj.c2));\n   print('c2.length: ' + obj.c2.length);\n   print('d: ' + obj.d, typeof(obj.d));\n   return obj.d\n}\n\nexec", (String)"test2.mjs").buildLiteral();

    public void testJSObject(Context context) {
        Value func = context.eval(this.code);
        Value creator = context.eval(this.creation);
        Value obj = creator.execute(new Object[0]);
        obj.putMember("a", (Object)new double[]{1.2, 10.0});
        obj.putMember("b", (Object)100.0);
        obj.putMember("c1", (Object)new SMat().setToInterleavedBGR(Matrix.newMatrix(Byte.TYPE, (long[])new long[]{1L, 10L, 10L})));
        obj.putMember("c2", (Object)"JavaString");
        Value result = func.execute(new Object[]{obj});
        System.out.printf("Found %s = %s%n", result, obj.getMember("d"));
    }

    public static void main(String[] args) throws ScriptException, InterruptedException {
        GraalBindingTest test = new GraalBindingTest();
        System.out.println("Testing safe:");
        test.testJSObject(test.safe);
        System.out.println();
        System.out.println("Testing pure:");
        test.testJSObject(test.pure);
    }
}

