/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalSourceFileSimpleTest {
    public static void main(String[] args) throws ScriptException, IOException {
        boolean useReturnExports = args.length > 0 && args[0].equals("exports");
        System.out.println("useReturnExports: " + useReturnExports);
        Path currentDirectory = Paths.get("src/test/java/net/algart/graalvm/tests", new String[0]);
        String moduleFile = "./js/sometest.mjs";
        Path modulePath = currentDirectory.resolve(Paths.get("./js/sometest.mjs", new String[0]));
        System.out.println("Loading " + String.valueOf(modulePath.toAbsolutePath().normalize().toUri()));
        Source.Builder sourceBuilder = Source.newBuilder((String)"js", (File)modulePath.toFile());
        sourceBuilder.mimeType("application/javascript+module");
        Source source = sourceBuilder.build();
        Context.Builder contextBuilder = Context.newBuilder((String[])new String[]{"js"});
        contextBuilder.allowAllAccess(true);
        if (useReturnExports) {
            contextBuilder.option("js.esm-eval-returns-exports", "true");
        }
        try (Context context = contextBuilder.build();){
            Value module = context.eval(source);
            System.out.println("Module/last line: " + String.valueOf(module) + ", hasMembers: " + module.hasMembers());
            System.out.println("Member keys: " + String.valueOf(module.getMemberKeys()));
            Value func = module.hasMember("simpleTest") ? module.getMember("simpleTest") : module;
            System.out.println("Function simpleTest: " + String.valueOf(func));
            Value m = module.getMember("toJsonString");
            System.out.println("Function toJsonString: " + String.valueOf(m) + ", " + (m == null ? null : Boolean.valueOf(m.canExecute())));
            m = module.getMember("__StringClass");
            System.out.println("Constant __StringClass: " + String.valueOf(m) + ", " + (m == null ? null : Boolean.valueOf(m.canExecute())));
            Value result = func.execute(new Object[0]);
            System.out.println("execute result: " + String.valueOf(result));
        }
    }
}

