/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.algart.graalvm.GraalContextCustomizer;
import net.algart.graalvm.GraalPerformerContainer;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalVMScriptEngineTest {
    private static void gc() throws InterruptedException {
        System.out.println("gc");
        System.gc();
        Thread.sleep(200L);
        System.gc();
    }

    private static void test() throws ScriptException {
        Value executeResult;
        String moduleFile = "./src/test/java/net/algart/graalvm/tests/js/sometest.mjs";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("graal.js");
        Bindings bindings = engine.getBindings(100);
        bindings.put("a", (Object)2);
        String simpleScript = "10 * a";
        Object result = engine.eval("10 * a");
        System.out.println(result);
        System.out.println();
        System.out.println();
        engine = new ScriptEngineManager().getEngineByName("graal.js");
        bindings = engine.getBindings(100);
        bindings.put("polyglot.js.allowHostAccess", (Object)true);
        bindings.put("polyglot.js.allowHostClassLookup", s -> true);
        String script = "//import {toJson} from './src/test/java/net/algart/graalvm/tests/js/sometest.mjs';\nvar s1 = new java.lang.String(\"123\");\nvar ObjectClass = Java.type('java.lang.Object');\nvar StringClass = Java.type('java.lang.String');\nvar s = new StringClass(\"123\");\nvar File = Java.type(\"java.io.File\")\nvar a = new File(\"/tmp\").listFiles();\nvar Arrays = Java.type(\"java.util.Arrays\");\nvar thread = new java.lang.Thread(); thread.start(); print(thread);\nfunction testFunc(s) { print('Hello'); return s + '_' };\nprint(Arrays.toString(a));\nprint(s);\ntestFunc";
        engine.eval("//import {toJson} from './src/test/java/net/algart/graalvm/tests/js/sometest.mjs';\nvar s1 = new java.lang.String(\"123\");\nvar ObjectClass = Java.type('java.lang.Object');\nvar StringClass = Java.type('java.lang.String');\nvar s = new StringClass(\"123\");\nvar File = Java.type(\"java.io.File\")\nvar a = new File(\"/tmp\").listFiles();\nvar Arrays = Java.type(\"java.util.Arrays\");\nvar thread = new java.lang.Thread(); thread.start(); print(thread);\nfunction testFunc(s) { print('Hello'); return s + '_' };\nprint(Arrays.toString(a));\nprint(s);\ntestFunc");
        System.out.println();
        System.out.println();
        String language = "js";
        GraalPerformerContainer container = GraalPerformerContainer.getShared((GraalContextCustomizer)GraalContextCustomizer.ALL_ACCESS).setJsEsmEvalReturnsExports(false);
        Context context = container.performer((Object)"some-id").context();
        Source source = Source.newBuilder((String)language, (CharSequence)"//import {toJson} from './src/test/java/net/algart/graalvm/tests/js/sometest.mjs';\nvar s1 = new java.lang.String(\"123\");\nvar ObjectClass = Java.type('java.lang.Object');\nvar StringClass = Java.type('java.lang.String');\nvar s = new StringClass(\"123\");\nvar File = Java.type(\"java.io.File\")\nvar a = new File(\"/tmp\").listFiles();\nvar Arrays = Java.type(\"java.util.Arrays\");\nvar thread = new java.lang.Thread(); thread.start(); print(thread);\nfunction testFunc(s) { print('Hello'); return s + '_' };\nprint(Arrays.toString(a));\nprint(s);\ntestFunc", (String)"Unnamed.mjs").buildLiteral();
        Value v = context.eval(source);
        System.out.println("Result of script: " + String.valueOf(v));
        Engine e = context.getEngine();
        System.out.println("Languages: " + String.valueOf(e.getLanguages()));
        System.out.println("Instruments: " + String.valueOf(e.getInstruments()));
        System.out.println("Number of shared contexts: " + GraalPerformerContainer.numberOfSharedPerformers());
        System.out.println();
        System.out.println("Again:");
        v = context.eval(source);
        System.out.println(v);
        System.out.println();
        Value member = context.getBindings("js").getMember("testFunc");
        System.out.println("testFunc: " + String.valueOf(member));
        if (member != null) {
            executeResult = member.execute(new Object[]{"Java-String"});
            System.out.println("Result: " + String.valueOf(executeResult));
        }
        executeResult = v.execute(new Object[]{"Some string"});
        System.out.println("Stored function result: " + String.valueOf(executeResult));
        System.out.println("Number of shared contexts (inside) " + GraalPerformerContainer.numberOfSharedPerformers());
        container.freeResources(false);
    }

    public static void main(String[] args) throws ScriptException, InterruptedException {
        GraalVMScriptEngineTest.test();
        GraalVMScriptEngineTest.gc();
        System.out.println("Number of shared contexts (outside) " + GraalPerformerContainer.numberOfSharedPerformers());
        GraalVMScriptEngineTest.gc();
        GraalVMScriptEngineTest.gc();
    }
}

