/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.tests;

import jep.MainInterpreter;
import jep.PyConfig;
import jep.SharedInterpreter;
import jep.SubInterpreter;
import jep.python.PyCallable;
import jep.python.PyObject;

public class JepAccessMembersTest {
    private static final String TEST_SCRIPT = "import sys\n\nclass TestClass:\n    def __init__(self):\n        self.a = 12\n\ndef test():\n    result = str(sys.path)\n    result = result + \"\\nHello from Python: \" + str(sys.version)\n    a = TestClass()\n    return result\n";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.printf("Usage: %s path_to_Python%n", JepAccessMembersTest.class.getName());
            return;
        }
        String pythonHome = args[0];
        PyConfig pyConfig = new PyConfig();
        pyConfig.setPythonHome(pythonHome);
        MainInterpreter.setInitParams((PyConfig)pyConfig);
        SharedInterpreter interpreter = new SharedInterpreter();
        System.out.printf("Interpreter 1: %s%n", interpreter);
        interpreter.exec(TEST_SCRIPT);
        Object result = interpreter.invoke("test", new Object[0]);
        System.out.printf("invoke():%n%s%n", result);
        interpreter.close();
        interpreter = new SharedInterpreter();
        System.out.printf("%nInterpreter 2: %s%n", interpreter);
        interpreter.exec(TEST_SCRIPT);
        PyCallable testFunction = (PyCallable)interpreter.getValue("test", PyCallable.class);
        result = testFunction.callAs(Object.class, new Object[0]);
        System.out.printf("callAs:%n%s%n", result);
        PyCallable testClass = (PyCallable)interpreter.getValue("TestClass", PyCallable.class);
        PyObject testInstance = (PyObject)testClass.callAs(PyObject.class, new Object[0]);
        result = testInstance.getAttr("a");
        System.out.printf("getAttr:%n%s%n", result);
        interpreter.close();
        interpreter = new SubInterpreter();
        System.out.printf("%nInterpreter 3: %s%n", interpreter);
        interpreter.exec(TEST_SCRIPT);
        testFunction = (PyCallable)interpreter.getValue("test");
        result = testFunction.call(new Object[0]);
        System.out.printf("call:%n%s%n", result);
        testInstance = (PyObject)interpreter.invoke("TestClass", new Object[0]);
        result = testInstance.getAttr("a");
        System.out.printf("getAttr:%n%s%n", result);
        interpreter.close();
    }
}

