/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.tests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import net.algart.jep.JepPerformer;
import net.algart.jep.JepPerformerContainer;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.GlobalPythonConfiguration;
import net.algart.jep.additions.JepType;

public class JepBridgeTest {
    static boolean gc = false;
    static boolean free = false;
    private static final String SHARED_SCRIPT = "import numpy as np\n\nconstArray = np.array([2, 3, 4])\nclass TestClass:\n    def __init__(self):\n        self.a = 2\n\n    def test(self):\n        result = np.array([3, 4])\n        # result = np.zeros(3) # works almost same time\n        return result\n";
    private static final String LOCAL_SCRIPT = "import time;\nclass TestClass:\n    def __init__(self):\n        pass\n\n    def test(self):\n        return 'Hello from JEP';\n";
    final JepPerformerContainer normalContainer = JepPerformerContainer.newContainer((JepType)JepType.NORMAL);
    final JepPerformerContainer localContainer = JepPerformerContainer.newContainer((JepType)JepType.SUB_INTERPRETER);

    private static void showMemory(String message) {
        Runtime rt = Runtime.getRuntime();
        System.out.printf("%s: %.2f/%.2f MB%n", message, (double)(rt.totalMemory() - rt.freeMemory()) * 1.0E-6, (double)rt.maxMemory() * 1.0E-6);
    }

    private static void gc() {
        System.gc();
        for (int k = 0; k < 2; ++k) {
            System.gc();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void performTesting() throws InterruptedException {
        long t2;
        long t1;
        JepBridgeTest.showMemory("Starting memory");
        for (int test = 1; test <= 4; ++test) {
            Object result;
            long t3;
            boolean shared = test % 2 == 1;
            System.out.printf(Locale.US, "%nTest #%d%n", test);
            System.out.printf(Locale.US, "Number of active threads: %d%n", Thread.activeCount());
            t1 = System.nanoTime();
            JepPerformer performer = (shared ? this.normalContainer : this.localContainer).performer();
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "Getting interpreter %s: %.3f mcs; number of active threads: %d%n    configuration: %s%n    verification status: %s%n", performer.context(), (double)(t2 - t1) * 0.001, Thread.activeCount(), performer.configuration(), performer.verificationStatus());
            JepBridgeTest.showMemory("Memory");
            t1 = System.nanoTime();
            performer.perform(shared ? SHARED_SCRIPT : LOCAL_SCRIPT);
            t2 = System.nanoTime();
            try (AtomicPyObject testClass = performer.newObject("TestClass", new Object[0]);){
                t3 = System.nanoTime();
                result = testClass.invoke("test", new Object[0]);
            }
            long t4 = System.nanoTime();
            System.out.printf(Locale.US, "Executing Python: %s (%s), %.3f + %.3f + %.3f mcs; number of active threads: %d%n", result instanceof int[] ? Arrays.toString((int[])result) : result, result.getClass().getCanonicalName(), (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001, Thread.activeCount());
            JepBridgeTest.showMemory("Memory");
        }
        System.out.printf("%n%n", new Object[0]);
        System.out.printf(Locale.US, "Number of active threads before freeResources: %d%n", Thread.activeCount());
        if (free) {
            t1 = System.nanoTime();
            this.normalContainer.close();
            this.localContainer.close();
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "freeResources(): %.3f ms; number of active threads: %d%n", (double)(t2 - t1) * 1.0E-6, Thread.activeCount());
        }
        Thread.sleep(1000L);
        System.out.printf("Number of active threads: %d%n", Thread.activeCount());
        System.out.printf("Done%n", new Object[0]);
    }

    public static void callTest(String[] args) throws InterruptedException {
        JepBridgeTest test = new JepBridgeTest();
        JepBridgeTest.configure(test.localContainer);
        JepBridgeTest.configure(test.normalContainer);
        test.performTesting();
    }

    public static void configure(JepPerformerContainer performerContainer) {
        String jepApiClassName = "net.algart.executors.api.jep.JepAPI";
        try {
            Class<?> jepApiClass = Class.forName("net.algart.executors.api.jep.JepAPI");
            Method configureMethod = jepApiClass.getMethod("initialize", JepPerformerContainer.class);
            try {
                configureMethod.invoke(null, performerContainer);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            System.out.println(String.valueOf(performerContainer) + " configured by JepAPI");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            System.out.println("net.algart.executors.api.jep.JepAPI class is not available or incorrect: " + String.valueOf(e));
        }
    }

    public static void main(String[] args) throws InterruptedException {
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-gc")) {
            gc = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-free")) {
            free = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.println("Usage:");
            System.out.println("    " + JepBridgeTest.class.getName() + " [-gc] [-free] number-of-tests");
            return;
        }
        int numberOfTests = Integer.parseInt(args[startArgIndex]);
        System.out.printf("Python information: %s%n", GlobalPythonConfiguration.INSTANCE.pythonHomeInformation());
        GlobalPythonConfiguration.INSTANCE.useForJep();
        System.out.printf("Number of active threads at the beginning: %d%n", Thread.activeCount());
        for (int m = 1; m < numberOfTests; ++m) {
            System.out.printf("%n--------%nTest block #%d; number of active threads: %d%n", m, Thread.activeCount());
            JepBridgeTest.callTest(args);
            if (!gc) continue;
            JepBridgeTest.gc();
            JepBridgeTest.gc();
            System.out.printf("GC #%d: Number of active threads: %d%n%n%n", m, Thread.activeCount());
        }
    }
}

