/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.tests;

import jep.DirectNDArray;
import jep.Interpreter;
import jep.MainInterpreter;
import jep.NDArray;
import jep.PyConfig;
import jep.SharedInterpreter;
import net.algart.jep.additions.JepInterpretation;
import net.algart.jep.additions.JepNumpyIntegrationException;

public class JepNumpyIntegrationTest {
    private static final String NUMPY_SCRIPT = "import sys\nimport numpy\n\ndef info():\n    return str(sys.version) + \"\\n\" + str(sys.prefix)\n\ndef array():\n    return numpy.array([1, 2])\n";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.printf("Usage: %s path_to_Python%n", JepNumpyIntegrationTest.class.getName());
            return;
        }
        String pythonHome = args[0];
        PyConfig pyConfig = new PyConfig();
        pyConfig.setPythonHome(pythonHome);
        System.out.printf("Using Python home: %s%n", pythonHome);
        MainInterpreter.setInitParams((PyConfig)pyConfig);
        SharedInterpreter interpreter = new SharedInterpreter();
        try {
            Object array;
            System.out.println("Interpreter: " + String.valueOf(interpreter));
            System.out.println();
            interpreter.exec(NUMPY_SCRIPT);
            System.out.println("From Python:");
            Object info = interpreter.invoke("info", new Object[0]);
            System.out.printf("%ninfo() = %s%n", info);
            try {
                array = JepInterpretation.checkNumpyIntegration((Interpreter)interpreter, (String)"array");
            }
            catch (JepNumpyIntegrationException e) {
                System.out.printf("Numpy IS NOT WELL-CONFIGURED TOGETHER with JEP: returned array is %s%n", e.isReturnedNull() ? null : e.getActualResultClass().getSimpleName());
                System.out.printf("%nException:%n%s%n", e.getMessage());
                interpreter.close();
                return;
            }
            System.out.printf("%narray() = %s%n", array);
            assert (array instanceof NDArray || array instanceof DirectNDArray);
            System.out.printf("Numpy is normally installed: array = %s%n", array.getClass().getSimpleName());
        }
        finally {
            try {
                interpreter.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }
}

