/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.tests;

import java.io.OutputStream;
import jep.JepConfig;
import jep.SharedInterpreter;
import jep.python.PyCallable;
import jep.python.PyObject;

public class SimpleJepForInterpretersAndNumpy {
    public static void main(String[] args) throws InterruptedException {
        SharedInterpreter.setConfig((JepConfig)new JepConfig().redirectStdout((OutputStream)System.out));
        Thread t = new Thread(() -> {
            try (SharedInterpreter interp = new SharedInterpreter();){
                Object result = null;
                System.out.printf("%nInterpreter: %s%n", interp);
                interp.exec("import numpy\n");
                interp.exec("class myClass():\n    pass\n");
                interp.exec("def createMyClass():\n    return myClass()\n");
                interp.exec("def myTestString():\n    return '123'\n");
                interp.exec("def myTestArray():\n    return [1,2,3]\n");
                interp.exec("def myTestNumber():\n    return 123\n");
                interp.exec("print(myTestNumber())");
                System.out.println("Getting PyCallable");
                PyCallable callable = (PyCallable)interp.getValue("myClass", PyCallable.class);
                System.out.println("Calling PyCallable");
                result = callable.call(new Object[0]);
                System.out.printf("call result: %s%n", result);
                System.out.println("Calling constructor");
                PyObject myClass = (PyObject)interp.invoke("myClass", new Object[0]);
                System.out.printf("invoke result: %s%n", myClass);
                interp.exec("_myClass = myClass()");
                result = interp.getValue("_myClass");
                System.out.printf("getValue result: %s%n", result);
                System.out.println("Calling function");
                result = interp.invoke("myTestString", new Object[0]);
                System.out.printf("invoke result: %s%n", result);
            }
        });
        t.start();
        t.join();
        System.out.println();
        System.err.println();
        t = new Thread(() -> {
            try (SharedInterpreter interp = new SharedInterpreter();){
                System.out.printf("%nInterpreter: %s%n", interp);
                interp.exec("import numpy as np\n");
                interp.exec("def myTest():\n    return np.array([2, 3, 4])\n");
                interp.exec("print(myTest())");
                Object result = interp.invoke("myTest", new Object[0]);
                System.out.printf("invoke result: %s (%s)%n", result, result.getClass().getCanonicalName());
            }
        });
        t.start();
        t.join();
    }
}

