/*
 * Decompiled with CFR 0.152.
 */
package com.siams.data.vpjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.data.vpjson.VideoPanoramaStareProjectBuilder;
import com.siams.data.vpjson.project.Project;
import com.siams.data.vpjson.project.contour.Contours;
import com.siams.data.vpjson.project.contour.property.Property;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VideoPanoramaJson {
    @JsonProperty(value="multi_project")
    int multiProject;
    @JsonProperty(value="project")
    private Project project;
    @JsonProperty(value="projects")
    private List<Project> projects;

    public VideoPanoramaJson(Project project) {
        this.project = project;
    }

    @JsonCreator
    public VideoPanoramaJson() {
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public static void save(Path file, VideoPanoramaJson videoPanoramaJson) throws IOException {
        if (videoPanoramaJson == null) {
            throw new NullPointerException("video panorama json required");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue(file.toFile(), (Object)videoPanoramaJson);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file.toFile()), StandardCharsets.UTF_8);){
            out.write("\ufeff");
            out.write(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)videoPanoramaJson));
        }
    }

    public static VideoPanoramaJson load(Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException(file.toFile().getAbsolutePath());
        }
        ObjectMapper mapper = new ObjectMapper();
        return (VideoPanoramaJson)mapper.readValue(file.toFile(), VideoPanoramaJson.class);
    }

    public int getMultiProject() {
        return this.multiProject;
    }

    public void setMultiProject(int multiProject) {
        this.multiProject = multiProject;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public Project getProjectByStepUid(String stepUid) {
        if (this.projects == null) {
            return null;
        }
        return this.projects.stream().filter(project -> project.getStepUid() != null && project.getStepUid().equals(stepUid)).findFirst().orElse(null);
    }

    public static VideoPanoramaJson empty() {
        Property property = new Property();
        property.setConnectivity(8);
        property.setContourType(Property.ContourType.DIAGONAL);
        Contours contours = new Contours();
        contours.setProperties(property);
        Project project = new Project();
        project.setContours(contours);
        VideoPanoramaJson vp = new VideoPanoramaJson();
        vp.setProject(project);
        return vp;
    }

    public static VideoPanoramaJson emptyStareProject() {
        return VideoPanoramaStareProjectBuilder.buildEmpty();
    }

    public static <T> T findAndRemove(Collection<T> collection, Predicate<T> predicate) {
        T removed = null;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T obj = iterator.next();
            if (!predicate.test(obj)) continue;
            iterator.remove();
            removed = obj;
            break;
        }
        return removed;
    }
}

