/*
 * Decompiled with CFR 0.152.
 */
package com.siams.data.vpjson.project.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.data.vpjson.project.filter.ColorMode;
import com.siams.data.vpjson.project.filter.Morphology;
import com.siams.data.vpjson.project.filter.Plugin;
import com.siams.data.vpjson.project.filter.Segmentation;
import com.siams.data.vpjson.project.filter.plugin.GaussBlur;
import com.siams.data.vpjson.project.filter.plugin.StarePlugin;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Filter {
    @JsonProperty(value="ptype")
    protected String ptype;
    @JsonProperty(value="visible")
    protected Boolean visible = true;
    @JsonProperty(value="readonly")
    protected Boolean readOnly = true;
    @JsonProperty(value="title")
    String title;

    private static Class<? extends Filter> jsFactory(String pluginName, String filterName, Map<String, Object> props) {
        ObjectMapper mapper = new ObjectMapper();
        switch (filterName) {
            case "gauss_blur": {
                return GaussBlur.class;
            }
            case "local_contrast": {
                System.out.println("LocalContrast.class not defined");
                return Plugin.class;
            }
        }
        System.out.println(String.format("unhandled js filter name: '%s'", filterName));
        return null;
    }

    private static Class<? extends Filter> stareFactory(String pluginName, String filterName, Map<String, Object> props) {
        ObjectMapper mapper = new ObjectMapper();
        switch (filterName) {
            case "stare_ex": {
                return StarePlugin.class;
            }
        }
        System.out.println(String.format("unhandled stare filter name: '%s'", filterName));
        return null;
    }

    private static Class<? extends Filter> pluginFactory(Map<String, Object> props) {
        String filterName = "";
        String pluginName = "";
        if (props.containsKey("plugin_name")) {
            pluginName = (String)props.get("plugin_name");
        }
        if (props.containsKey("filter_name")) {
            filterName = (String)props.get("filter_name");
        }
        Class clazz = Plugin.class;
        switch (pluginName) {
            case "jscript": {
                clazz = Filter.jsFactory(pluginName, filterName, props);
                break;
            }
            case "stare": {
                clazz = Filter.stareFactory(pluginName, filterName, props);
                break;
            }
            default: {
                System.out.println(String.format("unhandled plugin name: '%s'", pluginName));
            }
        }
        return clazz;
    }

    @JsonCreator
    public static Filter factory(Map<String, Object> props) {
        String pType = "";
        if (props.containsKey("ptype")) {
            pType = (String)props.get("ptype");
        }
        ObjectMapper mapper = new ObjectMapper();
        Class clazz = Plugin.class;
        if (!pType.isEmpty()) {
            switch (pType) {
                case "morphology": {
                    clazz = Morphology.class;
                    break;
                }
                case "segmentation": {
                    clazz = Segmentation.class;
                    break;
                }
                case "color_mode": {
                    clazz = ColorMode.class;
                    break;
                }
                case "plugin": {
                    clazz = Filter.pluginFactory(props);
                    break;
                }
                default: {
                    System.out.println(String.format("unhandled ptype: '%s'", pType));
                }
            }
        }
        return (Filter)mapper.convertValue(props, clazz);
    }

    @JsonGetter(value="ptype")
    public String getFilterType() {
        return this.ptype;
    }

    @JsonSetter(value="ptype")
    public void setFilterType(String filterType) {
        this.ptype = filterType;
    }

    @JsonGetter(value="visible")
    Integer getIsVisible() {
        return this.visible != false ? 1 : 0;
    }

    @JsonIgnore
    public boolean getVisible() {
        return this.visible;
    }

    @JsonSetter(value="visible")
    void setIsVisible(Integer isVisible) {
        this.visible = isVisible == 1;
    }

    @JsonIgnore
    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    @JsonGetter(value="readonly")
    Integer getIsReadOnly() {
        return this.readOnly != false ? 1 : 0;
    }

    @JsonIgnore
    public boolean getReadOnly() {
        return this.readOnly;
    }

    @JsonSetter(value="readonly")
    void setIsReadOnly(Integer isReadOnly) {
        this.readOnly = isReadOnly == 1;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonSetter(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public void setReadOnly(boolean isReadOnly) {
        this.readOnly = isReadOnly;
    }

    public Filter(String filterType) {
        this.ptype = filterType;
    }

    public static enum Type {
        COLOR_MODE("color_mode"),
        MORPHOLOGY("morphology"),
        PLUGIN("plugin"),
        SEGMENTATION("segmentation");

        String id;

        private Type(String id) {
            this.id = id;
        }

        public static Type of(String filterType) {
            for (Type type : Type.values()) {
                if (!type.id.equals(filterType)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unsupported filter type");
        }

        public String toString() {
            return this.id;
        }
    }
}

