/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2020 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 8.6.3
 * @date    2020-03-18
 */

(function webpackUniversalModuleDefinition(root, factory) {
    if (typeof exports === 'object' && typeof module === 'object')
        module.exports = factory();
    else if (typeof define === 'function' && define.amd)
        define([], factory);
    else if (typeof exports === 'object')
        exports["JSONEditor"] = factory();
    else
        root["JSONEditor"] = factory();
})(window, function () {
    return /******/ (function (modules) { // webpackBootstrap
        /******/ 	// The module cache
        /******/
        var installedModules = {};
        /******/
        /******/ 	// The require function
        /******/
        function __webpack_require__(moduleId) {
            /******/
            /******/ 		// Check if module is in cache
            /******/
            if (installedModules[moduleId]) {
                /******/
                return installedModules[moduleId].exports;
                /******/
            }
            /******/ 		// Create a new module (and put it into the cache)
            /******/
            var module = installedModules[moduleId] = {
                /******/            i: moduleId,
                /******/            l: false,
                /******/            exports: {}
                /******/
            };
            /******/
            /******/ 		// Execute the module function
            /******/
            modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
            /******/
            /******/ 		// Flag the module as loaded
            /******/
            module.l = true;
            /******/
            /******/ 		// Return the exports of the module
            /******/
            return module.exports;
            /******/
        }

        /******/
        /******/
        /******/ 	// expose the modules object (__webpack_modules__)
        /******/
        __webpack_require__.m = modules;
        /******/
        /******/ 	// expose the module cache
        /******/
        __webpack_require__.c = installedModules;
        /******/
        /******/ 	// define getter function for harmony exports
        /******/
        __webpack_require__.d = function (exports, name, getter) {
            /******/
            if (!__webpack_require__.o(exports, name)) {
                /******/
                Object.defineProperty(exports, name, {enumerable: true, get: getter});
                /******/
            }
            /******/
        };
        /******/
        /******/ 	// define __esModule on exports
        /******/
        __webpack_require__.r = function (exports) {
            /******/
            if (typeof Symbol !== 'undefined' && Symbol.toStringTag) {
                /******/
                Object.defineProperty(exports, Symbol.toStringTag, {value: 'Module'});
                /******/
            }
            /******/
            Object.defineProperty(exports, '__esModule', {value: true});
            /******/
        };
        /******/
        /******/ 	// create a fake namespace object
        /******/ 	// mode & 1: value is a module id, require it
        /******/ 	// mode & 2: merge all properties of value into the ns
        /******/ 	// mode & 4: return value when already ns object
        /******/ 	// mode & 8|1: behave like require
        /******/
        __webpack_require__.t = function (value, mode) {
            /******/
            if (mode & 1) value = __webpack_require__(value);
            /******/
            if (mode & 8) return value;
            /******/
            if ((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
            /******/
            var ns = Object.create(null);
            /******/
            __webpack_require__.r(ns);
            /******/
            Object.defineProperty(ns, 'default', {enumerable: true, value: value});
            /******/
            if (mode & 2 && typeof value != 'string') for (var key in value) __webpack_require__.d(ns, key, function (key) {
                return value[key];
            }.bind(null, key));
            /******/
            return ns;
            /******/
        };
        /******/
        /******/ 	// getDefaultExport function for compatibility with non-harmony modules
        /******/
        __webpack_require__.n = function (module) {
            /******/
            var getter = module && module.__esModule ?
                /******/            function getDefault() {
                    return module['default'];
                } :
                /******/            function getModuleExports() {
                    return module;
                };
            /******/
            __webpack_require__.d(getter, 'a', getter);
            /******/
            return getter;
            /******/
        };
        /******/
        /******/ 	// Object.prototype.hasOwnProperty.call
        /******/
        __webpack_require__.o = function (object, property) {
            return Object.prototype.hasOwnProperty.call(object, property);
        };
        /******/
        /******/ 	// __webpack_public_path__
        /******/
        __webpack_require__.p = "";
        /******/
        /******/
        /******/ 	// Load entry module and return exports
        /******/
        return __webpack_require__(__webpack_require__.s = 36);
        /******/
    })
        /************************************************************************/
        /******/ ([
            /* 0 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                __webpack_require__.r(__webpack_exports__);
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "parse", function () {
                    return parse;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "repair", function () {
                    return repair;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "escapeUnicodeChars", function () {
                    return escapeUnicodeChars;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "validate", function () {
                    return validate;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "extend", function () {
                    return extend;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "clear", function () {
                    return clear;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getType", function () {
                    return getType;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isUrl", function () {
                    return isUrl;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isArray", function () {
                    return isArray;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getAbsoluteLeft", function () {
                    return getAbsoluteLeft;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getAbsoluteTop", function () {
                    return getAbsoluteTop;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "addClassName", function () {
                    return addClassName;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "removeAllClassNames", function () {
                    return removeAllClassNames;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "removeClassName", function () {
                    return removeClassName;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "stripFormatting", function () {
                    return stripFormatting;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "setEndOfContentEditable", function () {
                    return setEndOfContentEditable;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "selectContentEditable", function () {
                    return selectContentEditable;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getSelection", function () {
                    return getSelection;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "setSelection", function () {
                    return setSelection;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getSelectionOffset", function () {
                    return getSelectionOffset;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "setSelectionOffset", function () {
                    return setSelectionOffset;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getInnerText", function () {
                    return getInnerText;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "hasParentNode", function () {
                    return hasParentNode;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getInternetExplorerVersion", function () {
                    return getInternetExplorerVersion;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isFirefox", function () {
                    return isFirefox;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "addEventListener", function () {
                    return addEventListener;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "removeEventListener", function () {
                    return removeEventListener;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isChildOf", function () {
                    return isChildOf;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "parsePath", function () {
                    return parsePath;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "stringifyPath", function () {
                    return stringifyPath;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "improveSchemaError", function () {
                    return improveSchemaError;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isPromise", function () {
                    return isPromise;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isValidValidationError", function () {
                    return isValidValidationError;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "insideRect", function () {
                    return insideRect;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "debounce", function () {
                    return debounce;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "textDiff", function () {
                    return textDiff;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getInputSelection", function () {
                    return getInputSelection;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getIndexForPosition", function () {
                    return getIndexForPosition;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getPositionForPath", function () {
                    return getPositionForPath;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "compileJSONPointer", function () {
                    return compileJSONPointer;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getColorCSS", function () {
                    return getColorCSS;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isValidColor", function () {
                    return isValidColor;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "makeFieldTooltip", function () {
                    return makeFieldTooltip;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "get", function () {
                    return get;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "findUniqueName", function () {
                    return findUniqueName;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "getChildPaths", function () {
                    return getChildPaths;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "sort", function () {
                    return sort;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "sortObjectKeys", function () {
                    return sortObjectKeys;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "parseString", function () {
                    return parseString;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isTimestamp", function () {
                    return isTimestamp;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "formatSize", function () {
                    return formatSize;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "limitCharacters", function () {
                    return limitCharacters;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isObject", function () {
                    return isObject;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "contains", function () {
                    return contains;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "isValidationErrorChanged", function () {
                    return isValidationErrorChanged;
                });
                /* harmony import */
                var _polyfills__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(24);
                /* harmony import */
                var _polyfills__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_polyfills__WEBPACK_IMPORTED_MODULE_0__);
                /* harmony import */
                var javascript_natural_sort__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11);
                /* harmony import */
                var javascript_natural_sort__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(javascript_natural_sort__WEBPACK_IMPORTED_MODULE_1__);
                /* harmony import */
                var _assets_jsonlint_jsonlint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22);
                /* harmony import */
                var _assets_jsonlint_jsonlint__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_assets_jsonlint_jsonlint__WEBPACK_IMPORTED_MODULE_2__);
                /* harmony import */
                var json_source_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33);
                /* harmony import */
                var json_source_map__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(json_source_map__WEBPACK_IMPORTED_MODULE_3__);
                /* harmony import */
                var _i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1);


                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }


                var MAX_ITEMS_FIELDS_COLLECTION = 10000;
                var YEAR_2000 = 946684800000;

                /**
                 * Parse JSON using the parser built-in in the browser.
                 * On exception, the jsonString is validated and a detailed error is thrown.
                 * @param {String} jsonString
                 * @return {JSON} json
                 */

                function parse(jsonString) {
                    try {
                        return JSON.parse(jsonString);
                    } catch (err) {
                        // try to throw a more detailed error message using validate
                        validate(jsonString); // rethrow the original error

                        throw err;
                    }
                }

                /**
                 * Repair a JSON-like string containing. For example changes JavaScript
                 * notation into JSON notation.
                 * This function for example changes a string like "{a: 2, 'b': {c: 'd'}"
                 * into '{"a": 2, "b": {"c": "d"}'
                 * @param {string} jsString
                 * @returns {string} json
                 */

                function repair(jsString) {
                    // TODO: refactor this function, it's too large and complicated now
                    // escape all single and double quotes inside strings
                    var chars = [];
                    var i = 0; // If JSON starts with a function (characters/digits/"_-"), remove this function.
                    // This is useful for "stripping" JSONP objects to become JSON
                    // For example: /* some comment */ function_12321321 ( [{"a":"b"}] ); => [{"a":"b"}]

                    var match = jsString.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);

                    if (match) {
                        jsString = match[3];
                    }

                    var controlChars = {
                        '\b': '\\b',
                        '\f': '\\f',
                        '\n': '\\n',
                        '\r': '\\r',
                        '\t': '\\t'
                    };
                    var quote = '\'';
                    var quoteDbl = '"';
                    var quoteLeft = "\u2018";
                    var quoteRight = "\u2019";
                    var quoteDblLeft = "\u201C";
                    var quoteDblRight = "\u201D";
                    var graveAccent = "`";
                    var acuteAccent = "\xB4";
                    var pythonConstants = {
                        None: 'null',
                        True: 'true',
                        False: 'false'
                    }; // helper functions to get the current/prev/next character

                    function curr() {
                        return jsString.charAt(i);
                    }

                    function next() {
                        return jsString.charAt(i + 1);
                    }

                    function prev() {
                        return jsString.charAt(i - 1);
                    }

                    function isWhiteSpace(c) {
                        return c === ' ' || c === '\n' || c === '\r' || c === '\t';
                    } // get the last parsed non-whitespace character


                    function lastNonWhitespace() {
                        var p = chars.length - 1;

                        while (p >= 0) {
                            var pp = chars[p];

                            if (!isWhiteSpace(pp)) {
                                return pp;
                            }

                            p--;
                        }

                        return '';
                    } // get at the first next non-white space character


                    function nextNonWhiteSpace() {
                        var iNext = i + 1;

                        while (iNext < jsString.length && isWhiteSpace(jsString[iNext])) {
                            iNext++;
                        }

                        return jsString[iNext];
                    } // skip a block comment '/* ... */'


                    function skipBlockComment() {
                        i += 2;

                        while (i < jsString.length && (curr() !== '*' || next() !== '/')) {
                            i++;
                        }

                        i += 2;
                    } // skip a comment '// ...'


                    function skipComment() {
                        i += 2;

                        while (i < jsString.length && curr() !== '\n') {
                            i++;
                        }
                    }

                    /**
                     * parse single or double quoted string. Returns the parsed string
                     * @param {string} endQuote
                     * @return {string}
                     */


                    function parseString(endQuote) {
                        var string = '';
                        string += '"';
                        i++;
                        var c = curr();

                        while (i < jsString.length && c !== endQuote) {
                            if (c === '"' && prev() !== '\\') {
                                // unescaped double quote, escape it
                                string += '\\"';
                            } else if (c in controlChars) {
                                // replace unescaped control characters with escaped ones
                                string += controlChars[c];
                            } else if (c === '\\') {
                                // remove the escape character when followed by a single quote ', not needed
                                i++;
                                c = curr();

                                if (c !== '\'') {
                                    string += '\\';
                                }

                                string += c;
                            } else {
                                // regular character
                                string += c;
                            }

                            i++;
                            c = curr();
                        }

                        if (c === endQuote) {
                            string += '"';
                            i++;
                        }

                        return string;
                    } // parse an unquoted key


                    function parseKey() {
                        var specialValues = ['null', 'true', 'false'];
                        var key = '';
                        var c = curr();
                        var regexp = /[a-zA-Z_$\d]/; // letter, number, underscore, dollar character

                        while (regexp.test(c)) {
                            key += c;
                            i++;
                            c = curr();
                        }

                        if (key in pythonConstants) {
                            return pythonConstants[key];
                        } else if (specialValues.indexOf(key) === -1) {
                            return '"' + key + '"';
                        } else {
                            return key;
                        }
                    }

                    function parseValue() {
                        var c = curr();
                        var value = '';

                        while (/\w/.test(c)) {
                            value += c;
                            i++;
                            c = curr();
                        }

                        if (value.length > 0 && c === '(') {
                            // This is an MongoDB data type like in {"_id": ObjectId("123")}
                            var innerValue;
                            i++;
                            c = curr();

                            if (c === '"') {
                                // a data type containing a string, like ISODate("2012-12-19T06:01:17.171Z")
                                innerValue = parseString(c);
                                c = curr();
                            } else {
                                // a data type containing a value, like 'NumberLong(2)'
                                innerValue = '';

                                while (c !== ')' && c !== '') {
                                    innerValue += c;
                                    i++;
                                    c = curr();
                                }
                            }

                            if (c === ')') {
                                // skip the closing bracket at the end
                                i++; // return the value (strip the data type object)

                                return innerValue;
                            } else {
                                // huh? that's unexpected. don't touch it
                                return value + '(' + innerValue + c;
                            }
                        } else if (typeof pythonConstants[value] === 'string') {
                            // it's a python constant like None
                            return pythonConstants[value];
                        } else {
                            // just leave as is
                            return value;
                        }
                    }

                    function isSpecialWhiteSpace(c) {
                        return c === "\xA0" || c >= "\u2000" && c <= "\u200A" || c === "\u202F" || c === "\u205F" || c === "\u3000";
                    }

                    while (i < jsString.length) {
                        var c = curr();

                        if (c === '/' && next() === '*') {
                            skipBlockComment();
                        } else if (c === '/' && next() === '/') {
                            skipComment();
                        } else if (isSpecialWhiteSpace(c)) {
                            // special white spaces (like non breaking space)
                            chars.push(' ');
                            i++;
                        } else if (c === quote) {
                            chars.push(parseString(c));
                        } else if (c === quoteDbl) {
                            chars.push(parseString(quoteDbl));
                        } else if (c === graveAccent) {
                            chars.push(parseString(acuteAccent));
                        } else if (c === quoteLeft) {
                            chars.push(parseString(quoteRight));
                        } else if (c === quoteDblLeft) {
                            chars.push(parseString(quoteDblRight));
                        } else if (c === ',' && [']', '}'].indexOf(nextNonWhiteSpace()) !== -1) {
                            // skip trailing commas
                            i++;
                        } else if (/[a-zA-Z_$]/.test(c) && ['{', ','].indexOf(lastNonWhitespace()) !== -1) {
                            // an unquoted object key (like a in '{a:2}')
                            // FIXME: array values are also parsed via parseKey, work this out properly
                            chars.push(parseKey());
                        } else if (/\w/.test(c)) {
                            chars.push(parseValue());
                        } else {
                            chars.push(c);
                            i++;
                        }
                    }

                    return chars.join('');
                }

                /**
                 * Escape unicode characters.
                 * For example input '\u2661' (length 1) will output '\\u2661' (length 5).
                 * @param {string} text
                 * @return {string}
                 */

                function escapeUnicodeChars( // see https://www.wikiwand.com/en/UTF-16
                    text) {
                    return (// note: we leave surrogate pairs as two individual chars,
                        // as JSON doesn't interpret them as a single unicode char.
                        text.replace(/[\u007F-\uFFFF]/g, function (c) {
                            return "\\u" + ('0000' + c.charCodeAt(0).toString(16)).slice(-4);
                        })
                    );
                }

                /**
                 * Validate a string containing a JSON object
                 * This method uses JSONLint to validate the String. If JSONLint is not
                 * available, the built-in JSON parser of the browser is used.
                 * @param {String} jsonString   String with an (invalid) JSON object
                 * @throws Error
                 */

                function validate(jsonString) {
                    if (typeof _assets_jsonlint_jsonlint__WEBPACK_IMPORTED_MODULE_2___default.a !== 'undefined') {
                        _assets_jsonlint_jsonlint__WEBPACK_IMPORTED_MODULE_2___default.a.parse(jsonString);
                    } else {
                        JSON.parse(jsonString);
                    }
                }

                /**
                 * Extend object a with the properties of object b
                 * @param {Object} a
                 * @param {Object} b
                 * @return {Object} a
                 */

                function extend(a, b) {
                    for (var prop in b) {
                        if (hasOwnProperty(b, prop)) {
                            a[prop] = b[prop];
                        }
                    }

                    return a;
                }

                /**
                 * Remove all properties from object a
                 * @param {Object} a
                 * @return {Object} a
                 */

                function clear(a) {
                    for (var prop in a) {
                        if (hasOwnProperty(a, prop)) {
                            delete a[prop];
                        }
                    }

                    return a;
                }

                /**
                 * Get the type of an object
                 * @param {*} object
                 * @return {String} type
                 */

                function getType(object) {
                    if (object === null) {
                        return 'null';
                    }

                    if (object === undefined) {
                        return 'undefined';
                    }

                    if (object instanceof Number || typeof object === 'number') {
                        return 'number';
                    }

                    if (object instanceof String || typeof object === 'string') {
                        return 'string';
                    }

                    if (object instanceof Boolean || typeof object === 'boolean') {
                        return 'boolean';
                    }

                    if (object instanceof RegExp) {
                        return 'regexp';
                    }

                    if (isArray(object)) {
                        return 'array';
                    }

                    return 'object';
                }

                /**
                 * Test whether a text contains a url (matches when a string starts
                 * with 'http://*' or 'https://*' and has no whitespace characters)
                 * @param {String} text
                 */

                var isUrlRegex = /^https?:\/\/\S+$/;

                function isUrl(text) {
                    return (typeof text === 'string' || text instanceof String) && isUrlRegex.test(text);
                }

                /**
                 * Tes whether given object is an Array
                 * @param {*} obj
                 * @returns {boolean} returns true when obj is an array
                 */

                function isArray(obj) {
                    return Object.prototype.toString.call(obj) === '[object Array]';
                }

                /**
                 * Retrieve the absolute left value of a DOM element
                 * @param {Element} elem    A dom element, for example a div
                 * @return {Number} left    The absolute left position of this element
                 *                          in the browser page.
                 */

                function getAbsoluteLeft(elem) {
                    var rect = elem.getBoundingClientRect();
                    return rect.left + window.pageXOffset || document.scrollLeft || 0;
                }

                /**
                 * Retrieve the absolute top value of a DOM element
                 * @param {Element} elem    A dom element, for example a div
                 * @return {Number} top     The absolute top position of this element
                 *                          in the browser page.
                 */

                function getAbsoluteTop(elem) {
                    var rect = elem.getBoundingClientRect();
                    return rect.top + window.pageYOffset || document.scrollTop || 0;
                }

                /**
                 * add a className to the given elements style
                 * @param {Element} elem
                 * @param {String} className
                 */

                function addClassName(elem, className) {
                    var classes = elem.className.split(' ');

                    if (classes.indexOf(className) === -1) {
                        classes.push(className); // add the class to the array

                        elem.className = classes.join(' ');
                    }
                }

                /**
                 * remove all classes from the given elements style
                 * @param {Element} elem
                 */

                function removeAllClassNames(elem) {
                    elem.className = '';
                }

                /**
                 * add a className to the given elements style
                 * @param {Element} elem
                 * @param {String} className
                 */

                function removeClassName(elem, className) {
                    var classes = elem.className.split(' ');
                    var index = classes.indexOf(className);

                    if (index !== -1) {
                        classes.splice(index, 1); // remove the class from the array

                        elem.className = classes.join(' ');
                    }
                }

                /**
                 * Strip the formatting from the contents of a div
                 * the formatting from the div itself is not stripped, only from its childs.
                 * @param {Element} divElement
                 */

                function stripFormatting(divElement) {
                    var childs = divElement.childNodes;

                    for (var i = 0, iMax = childs.length; i < iMax; i++) {
                        var child = childs[i]; // remove the style

                        if (child.style) {
                            // TODO: test if child.attributes does contain style
                            child.removeAttribute('style');
                        } // remove all attributes


                        var attributes = child.attributes;

                        if (attributes) {
                            for (var j = attributes.length - 1; j >= 0; j--) {
                                var attribute = attributes[j];

                                if (attribute.specified === true) {
                                    child.removeAttribute(attribute.name);
                                }
                            }
                        } // recursively strip childs


                        stripFormatting(child);
                    }
                }

                /**
                 * Set focus to the end of an editable div
                 * code from Nico Burns
                 * http://stackoverflow.com/users/140293/nico-burns
                 * http://stackoverflow.com/questions/1125292/how-to-move-cursor-to-end-of-contenteditable-entity
                 * @param {Element} contentEditableElement   A content editable div
                 */

                function setEndOfContentEditable(contentEditableElement) {
                    var range, selection;

                    if (document.createRange) {
                        range = document.createRange(); // Create a range (a range is a like the selection but invisible)

                        range.selectNodeContents(contentEditableElement); // Select the entire contents of the element with the range

                        range.collapse(false); // collapse the range to the end point. false means collapse to end rather than the start

                        selection = window.getSelection(); // get the selection object (allows you to change selection)

                        selection.removeAllRanges(); // remove any selections already made

                        selection.addRange(range); // make the range you have just created the visible selection
                    }
                }

                /**
                 * Select all text of a content editable div.
                 * http://stackoverflow.com/a/3806004/1262753
                 * @param {Element} contentEditableElement   A content editable div
                 */

                function selectContentEditable(contentEditableElement) {
                    if (!contentEditableElement || contentEditableElement.nodeName !== 'DIV') {
                        return;
                    }

                    var sel, range;

                    if (window.getSelection && document.createRange) {
                        range = document.createRange();
                        range.selectNodeContents(contentEditableElement);
                        sel = window.getSelection();
                        sel.removeAllRanges();
                        sel.addRange(range);
                    }
                }

                /**
                 * Get text selection
                 * http://stackoverflow.com/questions/4687808/contenteditable-selected-text-save-and-restore
                 * @return {Range | TextRange | null} range
                 */

                function getSelection() {
                    if (window.getSelection) {
                        var sel = window.getSelection();

                        if (sel.getRangeAt && sel.rangeCount) {
                            return sel.getRangeAt(0);
                        }
                    }

                    return null;
                }

                /**
                 * Set text selection
                 * http://stackoverflow.com/questions/4687808/contenteditable-selected-text-save-and-restore
                 * @param {Range | TextRange | null} range
                 */

                function setSelection(range) {
                    if (range) {
                        if (window.getSelection) {
                            var sel = window.getSelection();
                            sel.removeAllRanges();
                            sel.addRange(range);
                        }
                    }
                }

                /**
                 * Get selected text range
                 * @return {Object} params  object containing parameters:
                 *                              {Number}  startOffset
                 *                              {Number}  endOffset
                 *                              {Element} container  HTML element holding the
                 *                                                   selected text element
                 *                          Returns null if no text selection is found
                 */

                function getSelectionOffset() {
                    var range = getSelection();

                    if (range && 'startOffset' in range && 'endOffset' in range && range.startContainer && range.startContainer === range.endContainer) {
                        return {
                            startOffset: range.startOffset,
                            endOffset: range.endOffset,
                            container: range.startContainer.parentNode
                        };
                    }

                    return null;
                }

                /**
                 * Set selected text range in given element
                 * @param {Object} params   An object containing:
                 *                              {Element} container
                 *                              {Number} startOffset
                 *                              {Number} endOffset
                 */

                function setSelectionOffset(params) {
                    if (document.createRange && window.getSelection) {
                        var selection = window.getSelection();

                        if (selection) {
                            var range = document.createRange();

                            if (!params.container.firstChild) {
                                params.container.appendChild(document.createTextNode(''));
                            } // TODO: do not suppose that the first child of the container is a textnode,
                            //       but recursively find the textnodes


                            range.setStart(params.container.firstChild, params.startOffset);
                            range.setEnd(params.container.firstChild, params.endOffset);
                            setSelection(range);
                        }
                    }
                }

                /**
                 * Get the inner text of an HTML element (for example a div element)
                 * @param {Element} element
                 * @param {Object} [buffer]
                 * @return {String} innerText
                 */

                function getInnerText(element, buffer) {
                    var first = buffer === undefined;

                    if (first) {
                        buffer = {
                            text: '',
                            flush: function flush() {
                                var text = this.text;
                                this.text = '';
                                return text;
                            },
                            set: function set(text) {
                                this.text = text;
                            }
                        };
                    } // text node


                    if (element.nodeValue) {
                        return buffer.flush() + element.nodeValue;
                    } // divs or other HTML elements


                    if (element.hasChildNodes()) {
                        var childNodes = element.childNodes;
                        var innerText = '';

                        for (var i = 0, iMax = childNodes.length; i < iMax; i++) {
                            var child = childNodes[i];

                            if (child.nodeName === 'DIV' || child.nodeName === 'P') {
                                var prevChild = childNodes[i - 1];
                                var prevName = prevChild ? prevChild.nodeName : undefined;

                                if (prevName && prevName !== 'DIV' && prevName !== 'P' && prevName !== 'BR') {
                                    innerText += '\n';
                                    buffer.flush();
                                }

                                innerText += getInnerText(child, buffer);
                                buffer.set('\n');
                            } else if (child.nodeName === 'BR') {
                                innerText += buffer.flush();
                                buffer.set('\n');
                            } else {
                                innerText += getInnerText(child, buffer);
                            }
                        }

                        return innerText;
                    } else {
                        if (element.nodeName === 'P' && getInternetExplorerVersion() !== -1) {
                            // On Internet Explorer, a <p> with hasChildNodes()==false is
                            // rendered with a new line. Note that a <p> with
                            // hasChildNodes()==true is rendered without a new line
                            // Other browsers always ensure there is a <br> inside the <p>,
                            // and if not, the <p> does not render a new line
                            return buffer.flush();
                        }
                    } // br or unknown


                    return '';
                }

                /**
                 * Test whether an element has the provided parent node somewhere up the node tree.
                 * @param {Element} elem
                 * @param {Element} parent
                 * @return {boolean}
                 */

                function hasParentNode(elem, parent) {
                    var e = elem ? elem.parentNode : undefined;

                    while (e) {
                        if (e === parent) {
                            return true;
                        }

                        e = e.parentNode;
                    }

                    return false;
                }

                /**
                 * Returns the version of Internet Explorer or a -1
                 * (indicating the use of another browser).
                 * Source: http://msdn.microsoft.com/en-us/library/ms537509(v=vs.85).aspx
                 * @return {Number} Internet Explorer version, or -1 in case of an other browser
                 */

                function getInternetExplorerVersion() {
                    if (_ieVersion === -1) {
                        var rv = -1; // Return value assumes failure.

                        if (typeof navigator !== 'undefined' && navigator.appName === 'Microsoft Internet Explorer') {
                            var ua = navigator.userAgent;
                            var re = new RegExp('MSIE ([0-9]+[.0-9]+)');

                            if (re.exec(ua) != null) {
                                rv = parseFloat(RegExp.$1);
                            }
                        }

                        _ieVersion = rv;
                    }

                    return _ieVersion;
                }

                /**
                 * Test whether the current browser is Firefox
                 * @returns {boolean} isFirefox
                 */

                function isFirefox() {
                    return typeof navigator !== 'undefined' && navigator.userAgent.indexOf('Firefox') !== -1;
                }

                /**
                 * cached internet explorer version
                 * @type {Number}
                 * @private
                 */

                var _ieVersion = -1;

                /**
                 * Add and event listener. Works for all browsers
                 * @param {Element}     element    An html element
                 * @param {string}      action     The action, for example "click",
                 *                                 without the prefix "on"
                 * @param {function}    listener   The callback function to be executed
                 * @param {boolean}     [useCapture] false by default
                 * @return {function}   the created event listener
                 */


                function addEventListener(element, action, listener, useCapture) {
                    if (element.addEventListener) {
                        if (useCapture === undefined) {
                            useCapture = false;
                        }

                        if (action === 'mousewheel' && isFirefox()) {
                            action = 'DOMMouseScroll'; // For Firefox
                        }

                        element.addEventListener(action, listener, useCapture);
                        return listener;
                    } else if (element.attachEvent) {
                        // Old IE browsers
                        var f = function f() {
                            return listener.call(element, window.event);
                        };

                        element.attachEvent('on' + action, f);
                        return f;
                    }
                }

                /**
                 * Remove an event listener from an element
                 * @param {Element}  element   An html dom element
                 * @param {string}   action    The name of the event, for example "mousedown"
                 * @param {function} listener  The listener function
                 * @param {boolean}  [useCapture]   false by default
                 */

                function removeEventListener(element, action, listener, useCapture) {
                    if (element.removeEventListener) {
                        if (useCapture === undefined) {
                            useCapture = false;
                        }

                        if (action === 'mousewheel' && isFirefox()) {
                            action = 'DOMMouseScroll'; // For Firefox
                        }

                        element.removeEventListener(action, listener, useCapture);
                    } else if (element.detachEvent) {
                        // Old IE browsers
                        element.detachEvent('on' + action, listener);
                    }
                }

                /**
                 * Test if an element is a child of a parent element.
                 * @param {Element} elem
                 * @param {Element} parent
                 * @return {boolean} returns true if elem is a child of the parent
                 */

                function isChildOf(elem, parent) {
                    var e = elem.parentNode;

                    while (e) {
                        if (e === parent) {
                            return true;
                        }

                        e = e.parentNode;
                    }

                    return false;
                }

                /**
                 * Parse a JSON path like '.items[3].name' into an array
                 * @param {string} jsonPath
                 * @return {Array}
                 */

                function parsePath(jsonPath) {
                    var path = [];
                    var i = 0;

                    function parseProperty() {
                        var prop = '';

                        while (jsonPath[i] !== undefined && /[\w$]/.test(jsonPath[i])) {
                            prop += jsonPath[i];
                            i++;
                        }

                        if (prop === '') {
                            throw new Error('Invalid JSON path: property name expected at index ' + i);
                        }

                        return prop;
                    }

                    function parseIndex(end) {
                        var name = '';

                        while (jsonPath[i] !== undefined && jsonPath[i] !== end) {
                            name += jsonPath[i];
                            i++;
                        }

                        if (jsonPath[i] !== end) {
                            throw new Error('Invalid JSON path: unexpected end, character ' + end + ' expected');
                        }

                        return name;
                    }

                    while (jsonPath[i] !== undefined) {
                        if (jsonPath[i] === '.') {
                            i++;
                            path.push(parseProperty());
                        } else if (jsonPath[i] === '[') {
                            i++;

                            if (jsonPath[i] === '\'' || jsonPath[i] === '"') {
                                var end = jsonPath[i];
                                i++;
                                path.push(parseIndex(end));

                                if (jsonPath[i] !== end) {
                                    throw new Error('Invalid JSON path: closing quote \' expected at index ' + i);
                                }

                                i++;
                            } else {
                                var index = parseIndex(']').trim();

                                if (index.length === 0) {
                                    throw new Error('Invalid JSON path: array value expected at index ' + i);
                                } // Coerce numeric indices to numbers, but ignore star


                                index = index === '*' ? index : JSON.parse(index);
                                path.push(index);
                            }

                            if (jsonPath[i] !== ']') {
                                throw new Error('Invalid JSON path: closing bracket ] expected at index ' + i);
                            }

                            i++;
                        } else {
                            throw new Error('Invalid JSON path: unexpected character "' + jsonPath[i] + '" at index ' + i);
                        }
                    }

                    return path;
                }

                /**
                 * Stringify an array with a path in a JSON path like '.items[3].name'
                 * @param {Array.<string | number>} path
                 * @returns {string}
                 */

                function stringifyPath(path) {
                    return path.map(function (p) {
                        if (typeof p === 'number') {
                            return '[' + p + ']';
                        } else if (typeof p === 'string' && p.match(/^[A-Za-z0-9_$]+$/)) {
                            return '.' + p;
                        } else {
                            return '["' + p + '"]';
                        }
                    }).join('');
                }

                /**
                 * Improve the error message of a JSON schema error
                 * @param {Object} error
                 * @return {Object} The error
                 */

                function improveSchemaError(error) {
                    if (error.keyword === 'enum' && Array.isArray(error.schema)) {
                        var enums = error.schema;

                        if (enums) {
                            enums = enums.map(function (value) {
                                return JSON.stringify(value);
                            });

                            if (enums.length > 5) {
                                var more = ['(' + (enums.length - 5) + ' more...)'];
                                enums = enums.slice(0, 5);
                                enums.push(more);
                            }

                            error.message = 'should be equal to one of: ' + enums.join(', ');
                        }
                    }

                    if (error.keyword === 'additionalProperties') {
                        error.message = 'should NOT have additional property: ' + error.params.additionalProperty;
                    }

                    return error;
                }

                /**
                 * Test whether something is a Promise
                 * @param {*} object
                 * @returns {boolean} Returns true when object is a promise, false otherwise
                 */

                function isPromise(object) {
                    return object && typeof object.then === 'function' && typeof object["catch"] === 'function';
                }

                /**
                 * Test whether a custom validation error has the correct structure
                 * @param {*} validationError The error to be checked.
                 * @returns {boolean} Returns true if the structure is ok, false otherwise
                 */

                function isValidValidationError(validationError) {
                    return _typeof(validationError) === 'object' && Array.isArray(validationError.path) && typeof validationError.message === 'string';
                }

                /**
                 * Test whether the child rect fits completely inside the parent rect.
                 * @param {ClientRect} parent
                 * @param {ClientRect} child
                 * @param {number} margin
                 */

                function insideRect(parent, child, margin) {
                    var _margin = margin !== undefined ? margin : 0;

                    return child.left - _margin >= parent.left && child.right + _margin <= parent.right && child.top - _margin >= parent.top && child.bottom + _margin <= parent.bottom;
                }

                /**
                 * Returns a function, that, as long as it continues to be invoked, will not
                 * be triggered. The function will be called after it stops being called for
                 * N milliseconds.
                 *
                 * Source: https://davidwalsh.name/javascript-debounce-function
                 *
                 * @param {function} func
                 * @param {number} wait                 Number in milliseconds
                 * @param {boolean} [immediate=false]   If `immediate` is passed, trigger the
                 *                                      function on the leading edge, instead
                 *                                      of the trailing.
                 * @return {function} Return the debounced function
                 */

                function debounce(func, wait, immediate) {
                    var timeout;
                    return function () {
                        var context = this;
                        var args = arguments;

                        var later = function later() {
                            timeout = null;
                            if (!immediate) func.apply(context, args);
                        };

                        var callNow = immediate && !timeout;
                        clearTimeout(timeout);
                        timeout = setTimeout(later, wait);
                        if (callNow) func.apply(context, args);
                    };
                }

                /**
                 * Determines the difference between two texts.
                 * Can only detect one removed or inserted block of characters.
                 * @param {string} oldText
                 * @param {string} newText
                 * @return {{start: number, end: number}} Returns the start and end
                 *                                        of the changed part in newText.
                 */

                function textDiff(oldText, newText) {
                    var len = newText.length;
                    var start = 0;
                    var oldEnd = oldText.length;
                    var newEnd = newText.length;

                    while (newText.charAt(start) === oldText.charAt(start) && start < len) {
                        start++;
                    }

                    while (newText.charAt(newEnd - 1) === oldText.charAt(oldEnd - 1) && newEnd > start && oldEnd > 0) {
                        newEnd--;
                        oldEnd--;
                    }

                    return {
                        start: start,
                        end: newEnd
                    };
                }

                /**
                 * Return an object with the selection range or cursor position (if both have the same value)
                 * Support also old browsers (IE8-)
                 * Source: http://ourcodeworld.com/articles/read/282/how-to-get-the-current-cursor-position-and-selection-within-a-text-input-or-textarea-in-javascript
                 * @param {DOMElement} el A dom element of a textarea or input text.
                 * @return {Object} reference Object with 2 properties (start and end) with the identifier of the location of the cursor and selected text.
                 **/

                function getInputSelection(el) {
                    var startIndex = 0;
                    var endIndex = 0;
                    var normalizedValue;
                    var range;
                    var textInputRange;
                    var len;
                    var endRange;

                    if (typeof el.selectionStart === 'number' && typeof el.selectionEnd === 'number') {
                        startIndex = el.selectionStart;
                        endIndex = el.selectionEnd;
                    } else {
                        range = document.selection.createRange();

                        if (range && range.parentElement() === el) {
                            len = el.value.length;
                            normalizedValue = el.value.replace(/\r\n/g, '\n'); // Create a working TextRange that lives only in the input

                            textInputRange = el.createTextRange();
                            textInputRange.moveToBookmark(range.getBookmark()); // Check if the startIndex and endIndex of the selection are at the very end
                            // of the input, since moveStart/moveEnd doesn't return what we want
                            // in those cases

                            endRange = el.createTextRange();
                            endRange.collapse(false);

                            if (textInputRange.compareEndPoints('StartToEnd', endRange) > -1) {
                                startIndex = endIndex = len;
                            } else {
                                startIndex = -textInputRange.moveStart('character', -len);
                                startIndex += normalizedValue.slice(0, startIndex).split('\n').length - 1;

                                if (textInputRange.compareEndPoints('EndToEnd', endRange) > -1) {
                                    endIndex = len;
                                } else {
                                    endIndex = -textInputRange.moveEnd('character', -len);
                                    endIndex += normalizedValue.slice(0, endIndex).split('\n').length - 1;
                                }
                            }
                        }
                    }

                    return {
                        startIndex: startIndex,
                        endIndex: endIndex,
                        start: _positionForIndex(startIndex),
                        end: _positionForIndex(endIndex)
                    };

                    /**
                     * Returns textarea row and column position for certain index
                     * @param {Number} index text index
                     * @returns {{row: Number, column: Number}}
                     */

                    function _positionForIndex(index) {
                        var textTillIndex = el.value.substring(0, index);
                        var row = (textTillIndex.match(/\n/g) || []).length + 1;
                        var col = textTillIndex.length - textTillIndex.lastIndexOf('\n');
                        return {
                            row: row,
                            column: col
                        };
                    }
                }

                /**
                 * Returns the index for certaion position in text element
                 * @param {DOMElement} el A dom element of a textarea or input text.
                 * @param {Number} row row value, > 0, if exceeds rows number - last row will be returned
                 * @param {Number} column column value, > 0, if exceeds column length - end of column will be returned
                 * @returns {Number} index of position in text, -1 if not found
                 */

                function getIndexForPosition(el, row, column) {
                    var text = el.value || '';

                    if (row > 0 && column > 0) {
                        var rows = text.split('\n', row);
                        row = Math.min(rows.length, row);
                        column = Math.min(rows[row - 1].length, column - 1);
                        var columnCount = row === 1 ? column : column + 1; // count new line on multiple rows

                        return rows.slice(0, row - 1).join('\n').length + columnCount;
                    }

                    return -1;
                }

                /**
                 * Returns location of json paths in certain json string
                 * @param {String} text json string
                 * @param {Array<String>} paths array of json paths
                 * @returns {Array<{path: String, line: Number, row: Number}>}
                 */

                function getPositionForPath(text, paths) {
                    var result = [];
                    var jsmap;

                    if (!paths || !paths.length) {
                        return result;
                    }

                    try {
                        jsmap = json_source_map__WEBPACK_IMPORTED_MODULE_3___default.a.parse(text);
                    } catch (err) {
                        return result;
                    }

                    paths.forEach(function (path) {
                        var pathArr = parsePath(path);
                        var pointerName = compileJSONPointer(pathArr);
                        var pointer = jsmap.pointers[pointerName];

                        if (pointer) {
                            result.push({
                                path: path,
                                line: pointer.key ? pointer.key.line : pointer.value ? pointer.value.line : 0,
                                column: pointer.key ? pointer.key.column : pointer.value ? pointer.value.column : 0
                            });
                        }
                    });
                    return result;
                }

                /**
                 * Compile a JSON Pointer
                 * WARNING: this is an incomplete implementation
                 * @param {Array.<string | number>} path
                 * @return {string}
                 */

                function compileJSONPointer(path) {
                    return path.map(function (p) {
                        return '/' + String(p).replace(/~/g, '~0').replace(/\//g, '~1');
                    }).join('');
                }

                /**
                 * Get the applied color given a color name or code
                 * Source: https://stackoverflow.com/questions/6386090/validating-css-color-names/33184805
                 * @param {string} color
                 * @returns {string | null} returns the color if the input is a valid
                 *                   color, and returns null otherwise. Example output:
                 *                   'rgba(255,0,0,0.7)' or 'rgb(255,0,0)'
                 */

                function getColorCSS(color) {
                    var ele = document.createElement('div');
                    ele.style.color = color;
                    return ele.style.color.split(/\s+/).join('').toLowerCase() || null;
                }

                /**
                 * Test if a string contains a valid color name or code.
                 * @param {string} color
                 * @returns {boolean} returns true if a valid color, false otherwise
                 */

                function isValidColor(color) {
                    return !!getColorCSS(color);
                }

                /**
                 * Make a tooltip for a field based on the field's schema.
                 * @param {object} schema JSON schema
                 * @param {string} [locale] Locale code (for example, zh-CN)
                 * @returns {string} Field tooltip, may be empty string if all relevant schema properties are missing
                 */

                function makeFieldTooltip(schema, locale) {
                    if (!schema) {
                        return '';
                    }

                    var tooltip = '';

                    if (schema.title) {
                        tooltip += schema.title;
                    }

                    if (schema.description) {
                        if (tooltip.length > 0) {
                            tooltip += '\n';
                        }

                        tooltip += schema.description;
                    }

                    if (schema["default"]) {
                        if (tooltip.length > 0) {
                            tooltip += '\n\n';
                        }

                        tooltip += Object(_i18n__WEBPACK_IMPORTED_MODULE_4__[/* translate */ "c"])('default', undefined, locale) + '\n';
                        tooltip += JSON.stringify(schema["default"], null, 2);
                    }

                    if (Array.isArray(schema.examples) && schema.examples.length > 0) {
                        if (tooltip.length > 0) {
                            tooltip += '\n\n';
                        }

                        tooltip += Object(_i18n__WEBPACK_IMPORTED_MODULE_4__[/* translate */ "c"])('examples', undefined, locale) + '\n';
                        schema.examples.forEach(function (example, index) {
                            tooltip += JSON.stringify(example, null, 2);

                            if (index !== schema.examples.length - 1) {
                                tooltip += '\n';
                            }
                        });
                    }

                    return tooltip;
                }

                /**
                 * Get a nested property from an object.
                 * Returns undefined when the property does not exist.
                 * @param {Object} object
                 * @param {string[]} path
                 * @return {*}
                 */

                function get(object, path) {
                    var value = object;

                    for (var i = 0; i < path.length && value !== undefined && value !== null; i++) {
                        value = value[path[i]];
                    }

                    return value;
                }

                /**
                 * Find a unique name. Suffix the name with ' (copy)', '(copy 2)', etc
                 * until a unique name is found
                 * @param {string} name
                 * @param {Array} existingPropNames    Array with existing prop names
                 */

                function findUniqueName(name, existingPropNames) {
                    var strippedName = name.replace(/ \(copy( \d+)?\)$/, '');
                    var validName = strippedName;
                    var i = 1;

                    while (existingPropNames.indexOf(validName) !== -1) {
                        var copy = 'copy' + (i > 1 ? ' ' + i : '');
                        validName = strippedName + ' (' + copy + ')';
                        i++;
                    }

                    return validName;
                }

                /**
                 * Get the child paths of an array
                 * @param {JSON} json
                 * @param {boolean} [includeObjects=false] If true, object and array paths are returned as well
                 * @return {string[]}
                 */

                function getChildPaths(json, includeObjects) {
                    var pathsMap = {};

                    function getObjectChildPaths(json, pathsMap, rootPath, includeObjects) {
                        var isValue = !Array.isArray(json) && !isObject(json);

                        if (isValue || includeObjects) {
                            pathsMap[rootPath || ''] = true;
                        }

                        if (isObject(json)) {
                            Object.keys(json).forEach(function (field) {
                                getObjectChildPaths(json[field], pathsMap, rootPath + '.' + field, includeObjects);
                            });
                        }
                    }

                    if (Array.isArray(json)) {
                        var max = Math.min(json.length, MAX_ITEMS_FIELDS_COLLECTION);

                        for (var i = 0; i < max; i++) {
                            var item = json[i];
                            getObjectChildPaths(item, pathsMap, '', includeObjects);
                        }
                    } else {
                        pathsMap[''] = true;
                    }

                    return Object.keys(pathsMap).sort();
                }

                /**
                 * Sort object keys using natural sort
                 * @param {Array} array
                 * @param {String} [path] JSON pointer
                 * @param {'asc' | 'desc'} [direction]
                 */

                function sort(array, path, direction) {
                    var parsedPath = path && path !== '.' ? parsePath(path) : [];
                    var sign = direction === 'desc' ? -1 : 1;
                    var sortedArray = array.slice();
                    sortedArray.sort(function (a, b) {
                        var aValue = get(a, parsedPath);
                        var bValue = get(b, parsedPath);
                        return sign * (aValue > bValue ? 1 : aValue < bValue ? -1 : 0);
                    });
                    return sortedArray;
                }

                /**
                 * Sort object keys using natural sort
                 * @param {Object} object
                 * @param {'asc' | 'desc'} [direction]
                 */

                function sortObjectKeys(object, direction) {
                    var sign = direction === 'desc' ? -1 : 1;
                    var sortedFields = Object.keys(object).sort(function (a, b) {
                        return sign * javascript_natural_sort__WEBPACK_IMPORTED_MODULE_1___default()(a, b);
                    });
                    var sortedObject = {};
                    sortedFields.forEach(function (field) {
                        sortedObject[field] = object[field];
                    });
                    return sortedObject;
                }

                /**
                 * Cast contents of a string to the correct type.
                 * This can be a string, a number, a boolean, etc
                 * @param {String} str
                 * @return {*} castedStr
                 * @private
                 */

                function parseString(str) {
                    if (str === '') {
                        return '';
                    }

                    var lower = str.toLowerCase();

                    if (lower === 'null') {
                        return null;
                    }

                    if (lower === 'true') {
                        return true;
                    }

                    if (lower === 'false') {
                        return false;
                    }

                    var num = Number(str); // will nicely fail with '123ab'

                    var numFloat = parseFloat(str); // will nicely fail with '  '

                    if (!isNaN(num) && !isNaN(numFloat)) {
                        return num;
                    }

                    return str;
                }

                /**
                 * Test whether some field contains a timestamp in milliseconds after the year 2000.
                 * @param {string} field
                 * @param {number} value
                 * @return {boolean}
                 */

                function isTimestamp(field, value) {
                    return typeof value === 'number' && value > YEAR_2000 && isFinite(value) && Math.floor(value) === value && !isNaN(new Date(value).valueOf());
                }

                /**
                 * Return a human readable document size
                 * For example formatSize(7570718) outputs '7.6 MB'
                 * @param {number} size
                 * @return {string} Returns a human readable size
                 */

                function formatSize(size) {
                    if (size < 900) {
                        return size.toFixed() + ' B';
                    }

                    var KB = size / 1000;

                    if (KB < 900) {
                        return KB.toFixed(1) + ' KB';
                    }

                    var MB = KB / 1000;

                    if (MB < 900) {
                        return MB.toFixed(1) + ' MB';
                    }

                    var GB = MB / 1000;

                    if (GB < 900) {
                        return GB.toFixed(1) + ' GB';
                    }

                    var TB = GB / 1000;
                    return TB.toFixed(1) + ' TB';
                }

                /**
                 * Limit text to a maximum number of characters
                 * @param {string} text
                 * @param {number} maxCharacterCount
                 * @return {string} Returns the limited text,
                 *                  ending with '...' if the max was exceeded
                 */

                function limitCharacters(text, maxCharacterCount) {
                    if (text.length <= maxCharacterCount) {
                        return text;
                    }

                    return text.slice(0, maxCharacterCount) + '...';
                }

                /**
                 * Test whether a value is an Object
                 * @param {*} value
                 * @return {boolean}
                 */

                function isObject(value) {
                    return _typeof(value) === 'object' && value !== null && !Array.isArray(value);
                }

                /**
                 * Helper function to test whether an array contains an item
                 * @param {Array} array
                 * @param {*} item
                 * @return {boolean} Returns true if `item` is in `array`, returns false otherwise.
                 */

                function contains(array, item) {
                    return array.indexOf(item) !== -1;
                }

                /**
                 * Checkes if validation has changed from the previous execution
                 * @param {Array} currErr current validation errors
                 * @param {Array} prevErr previous validation errors
                 */

                function isValidationErrorChanged(currErr, prevErr) {
                    if (!prevErr && !currErr) {
                        return false;
                    }

                    if (prevErr && !currErr || !prevErr && currErr) {
                        return true;
                    }

                    if (prevErr.length !== currErr.length) {
                        return true;
                    }

                    var _loop = function _loop(i) {
                        var pErr = void 0;

                        if (currErr[i].type === 'error') {
                            pErr = prevErr.find(function (p) {
                                return p.line === currErr[i].line;
                            });
                        } else {
                            pErr = prevErr.find(function (p) {
                                return p.dataPath === currErr[i].dataPath && p.schemaPath === currErr[i].schemaPath;
                            });
                        }

                        if (!pErr) {
                            return {
                                v: true
                            };
                        }
                    };

                    for (var i = 0; i < currErr.length; ++i) {
                        var _ret = _loop(i);

                        if (_typeof(_ret) === "object") return _ret.v;
                    }

                    return false;
                }

                function hasOwnProperty(object, key) {
                    return Object.prototype.hasOwnProperty.call(object, key);
                }

                /***/
            }),
            /* 1 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return setLanguage;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "b", function () {
                    return setLanguages;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "c", function () {
                    return translate;
                });
                /* harmony import */
                var _polyfills__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(24);
                /* harmony import */
                var _polyfills__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_polyfills__WEBPACK_IMPORTED_MODULE_0__);

                /* eslint-disable no-template-curly-in-string */


                var _locales = ['en', 'pt-BR', 'zh-CN', 'tr', 'ja', 'fr-FR'];
                var _defs = {
                    en: {
                        array: 'Array',
                        auto: 'Auto',
                        appendText: 'Append',
                        appendTitle: 'Append a new field with type \'auto\' after this field (Ctrl+Shift+Ins)',
                        appendSubmenuTitle: 'Select the type of the field to be appended',
                        appendTitleAuto: 'Append a new field with type \'auto\' (Ctrl+Shift+Ins)',
                        ascending: 'Ascending',
                        ascendingTitle: 'Sort the childs of this ${type} in ascending order',
                        actionsMenu: 'Click to open the actions menu (Ctrl+M)',
                        cannotParseFieldError: 'Cannot parse field into JSON',
                        cannotParseValueError: 'Cannot parse value into JSON',
                        collapseAll: 'Collapse all fields',
                        compactTitle: 'Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)',
                        descending: 'Descending',
                        descendingTitle: 'Sort the childs of this ${type} in descending order',
                        drag: 'Drag to move this field (Alt+Shift+Arrows)',
                        duplicateKey: 'duplicate key',
                        duplicateText: 'Duplicate',
                        duplicateTitle: 'Duplicate selected fields (Ctrl+D)',
                        duplicateField: 'Duplicate this field (Ctrl+D)',
                        duplicateFieldError: 'Duplicate field name',
                        empty: 'empty',
                        expandAll: 'Expand all fields',
                        expandTitle: 'Click to expand/collapse this field (Ctrl+E). \n' + 'Ctrl+Click to expand/collapse including all childs.',
                        formatTitle: 'Format JSON data, with proper indentation and line feeds (Ctrl+\\)',
                        insert: 'Insert',
                        insertTitle: 'Insert a new field with type \'auto\' before this field (Ctrl+Ins)',
                        insertSub: 'Select the type of the field to be inserted',
                        object: 'Object',
                        ok: 'Ok',
                        redo: 'Redo (Ctrl+Shift+Z)',
                        removeText: 'Remove',
                        removeTitle: 'Remove selected fields (Ctrl+Del)',
                        removeField: 'Remove this field (Ctrl+Del)',
                        repairTitle: 'Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.',
                        searchTitle: 'Search fields and values',
                        searchNextResultTitle: 'Next result (Enter)',
                        searchPreviousResultTitle: 'Previous result (Shift + Enter)',
                        selectNode: 'Select a node...',
                        showAll: 'show all',
                        showMore: 'show more',
                        showMoreStatus: 'displaying ${visibleChilds} of ${totalChilds} items.',
                        sort: 'Sort',
                        sortTitle: 'Sort the childs of this ${type}',
                        sortTitleShort: 'Sort contents',
                        sortFieldLabel: 'Field:',
                        sortDirectionLabel: 'Direction:',
                        sortFieldTitle: 'Select the nested field by which to sort the array or object',
                        sortAscending: 'Ascending',
                        sortAscendingTitle: 'Sort the selected field in ascending order',
                        sortDescending: 'Descending',
                        sortDescendingTitle: 'Sort the selected field in descending order',
                        string: 'String',
                        transform: 'Transform',
                        transformTitle: 'Filter, sort, or transform the childs of this ${type}',
                        transformTitleShort: 'Filter, sort, or transform contents',
                        extract: 'Extract',
                        extractTitle: 'Extract this ${type}',
                        transformQueryTitle: 'Enter a JMESPath query',
                        transformWizardLabel: 'Wizard',
                        transformWizardFilter: 'Filter',
                        transformWizardSortBy: 'Sort by',
                        transformWizardSelectFields: 'Select fields',
                        transformQueryLabel: 'Query',
                        transformPreviewLabel: 'Preview',
                        type: 'Type',
                        typeTitle: 'Change the type of this field',
                        openUrl: 'Ctrl+Click or Ctrl+Enter to open url in new window',
                        undo: 'Undo last action (Ctrl+Z)',
                        validationCannotMove: 'Cannot move a field into a child of itself',
                        autoType: 'Field type "auto". ' + 'The field type is automatically determined from the value ' + 'and can be a string, number, boolean, or null.',
                        objectType: 'Field type "object". ' + 'An object contains an unordered set of key/value pairs.',
                        arrayType: 'Field type "array". ' + 'An array contains an ordered collection of values.',
                        stringType: 'Field type "string". ' + 'Field type is not determined from the value, ' + 'but always returned as string.',
                        modeEditorTitle: 'Switch Editor Mode',
                        modeCodeText: 'Code',
                        modeCodeTitle: 'Switch to code highlighter',
                        modeFormText: 'Form',
                        modeFormTitle: 'Switch to form editor',
                        modeTextText: 'Text',
                        modeTextTitle: 'Switch to plain text editor',
                        modeTreeText: 'Tree',
                        modeTreeTitle: 'Switch to tree editor',
                        modeViewText: 'View',
                        modeViewTitle: 'Switch to tree view',
                        modePreviewText: 'Preview',
                        modePreviewTitle: 'Switch to preview mode',
                        examples: 'Examples',
                        "default": 'Default'
                    },
                    'zh-CN': {
                        array: '数组',
                        auto: '自动',
                        appendText: '追加',
                        appendTitle: '在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)',
                        appendSubmenuTitle: '选择要追加的字段类型',
                        appendTitleAuto: '追加类型为“auto”的新字段 (Ctrl+Shift+Ins)',
                        ascending: '升序',
                        ascendingTitle: '升序排列${type}的子节点',
                        actionsMenu: '点击打开动作菜单(Ctrl+M)',
                        cannotParseFieldError: '无法将字段解析为JSON',
                        cannotParseValueError: '无法将值解析为JSON',
                        collapseAll: '缩进所有字段',
                        compactTitle: '压缩JSON数据，删除所有空格 (Ctrl+Shift+\\)',
                        descending: '降序',
                        descendingTitle: '降序排列${type}的子节点',
                        drag: '拖拽移动该节点(Alt+Shift+Arrows)',
                        duplicateKey: '重复键',
                        duplicateText: '复制',
                        duplicateTitle: '复制选中字段(Ctrl+D)',
                        duplicateField: '复制该字段(Ctrl+D)',
                        duplicateFieldError: '重复的字段名称',
                        empty: '清空',
                        expandAll: '展开所有字段',
                        expandTitle: '点击 展开/收缩 该字段(Ctrl+E). \n' + 'Ctrl+Click 展开/收缩 包含所有子节点.',
                        formatTitle: '使用适当的缩进和换行符格式化JSON数据 (Ctrl+\\)',
                        insert: '插入',
                        insertTitle: '在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)',
                        insertSub: '选择要插入的字段类型',
                        object: '对象',
                        ok: 'Ok',
                        redo: '重做 (Ctrl+Shift+Z)',
                        removeText: '移除',
                        removeTitle: '移除选中字段 (Ctrl+Del)',
                        removeField: '移除该字段 (Ctrl+Del)',
                        repairTitle: '修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。',
                        selectNode: '选择一个节点...',
                        showAll: '展示全部',
                        showMore: '展示更多',
                        showMoreStatus: '显示${totalChilds}的${visibleChilds}项目.',
                        sort: '排序',
                        sortTitle: '排序${type}的子节点',
                        sortTitleShort: '内容排序',
                        sortFieldLabel: '字段：',
                        sortDirectionLabel: '方向：',
                        sortFieldTitle: '选择用于对数组或对象排序的嵌套字段',
                        sortAscending: '升序排序',
                        sortAscendingTitle: '按照该字段升序排序',
                        sortDescending: '降序排序',
                        sortDescendingTitle: '按照该字段降序排序',
                        string: '字符串',
                        transform: '变换',
                        transformTitle: '筛选，排序，或者转换${type}的子节点',
                        transformTitleShort: '筛选，排序，或者转换内容',
                        extract: '提取',
                        extractTitle: '提取这个 ${type}',
                        transformQueryTitle: '输入JMESPath查询',
                        transformWizardLabel: '向导',
                        transformWizardFilter: '筛选',
                        transformWizardSortBy: '排序',
                        transformWizardSelectFields: '选择字段',
                        transformQueryLabel: '查询',
                        transformPreviewLabel: '预览',
                        type: '类型',
                        typeTitle: '更改字段类型',
                        openUrl: 'Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接',
                        undo: '撤销上次动作 (Ctrl+Z)',
                        validationCannotMove: '无法将字段移入其子节点',
                        autoType: '字段类型 "auto". ' + '字段类型由值自动确定 ' + '可以为 string，number，boolean，或者 null.',
                        objectType: '字段类型 "object". ' + '对象包含一组无序的键/值对.',
                        arrayType: '字段类型 "array". ' + '数组包含值的有序集合.',
                        stringType: '字段类型 "string". ' + '字段类型由值自动确定，' + '但始终作为字符串返回.',
                        modeCodeText: '代码',
                        modeCodeTitle: '切换至代码高亮',
                        modeFormText: '表单',
                        modeFormTitle: '切换至表单编辑',
                        modeTextText: '文本',
                        modeTextTitle: '切换至文本编辑',
                        modeTreeText: '树',
                        modeTreeTitle: '切换至树编辑',
                        modeViewText: '视图',
                        modeViewTitle: '切换至树视图',
                        modePreviewText: '预览',
                        modePreviewTitle: '切换至预览模式',
                        examples: '例子',
                        "default": '缺省'
                    },
                    'pt-BR': {
                        array: 'Lista',
                        auto: 'Automatico',
                        appendText: 'Adicionar',
                        appendTitle: 'Adicionar novo campo com tipo \'auto\' depois deste campo (Ctrl+Shift+Ins)',
                        appendSubmenuTitle: 'Selecione o tipo do campo a ser adicionado',
                        appendTitleAuto: 'Adicionar novo campo com tipo \'auto\' (Ctrl+Shift+Ins)',
                        ascending: 'Ascendente',
                        ascendingTitle: 'Organizar filhor do tipo ${type} em crescente',
                        actionsMenu: 'Clique para abrir o menu de ações (Ctrl+M)',
                        cannotParseFieldError: 'Não é possível analisar o campo no JSON',
                        cannotParseValueError: 'Não é possível analisar o valor em JSON',
                        collapseAll: 'Fechar todos campos',
                        compactTitle: 'Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+\\)',
                        descending: 'Descendente',
                        descendingTitle: 'Organizar o filhos do tipo ${type} em decrescente',
                        duplicateKey: 'chave duplicada',
                        drag: 'Arraste para mover este campo (Alt+Shift+Arrows)',
                        duplicateText: 'Duplicar',
                        duplicateTitle: 'Duplicar campos selecionados (Ctrl+D)',
                        duplicateField: 'Duplicar este campo (Ctrl+D)',
                        duplicateFieldError: 'Nome do campo duplicado',
                        empty: 'vazio',
                        expandAll: 'Expandir todos campos',
                        expandTitle: 'Clique para expandir/encolher este campo (Ctrl+E). \n' + 'Ctrl+Click para expandir/encolher incluindo todos os filhos.',
                        formatTitle: 'Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+\\)',
                        insert: 'Inserir',
                        insertTitle: 'Inserir um novo campo do tipo \'auto\' antes deste campo (Ctrl+Ins)',
                        insertSub: 'Selecionar o tipo de campo a ser inserido',
                        object: 'Objeto',
                        ok: 'Ok',
                        redo: 'Refazer (Ctrl+Shift+Z)',
                        removeText: 'Remover',
                        removeTitle: 'Remover campos selecionados (Ctrl+Del)',
                        removeField: 'Remover este campo (Ctrl+Del)',
                        repairTitle: 'Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.',
                        selectNode: 'Selecione um nódulo...',
                        showAll: 'mostrar todos',
                        showMore: 'mostrar mais',
                        showMoreStatus: 'exibindo ${visibleChilds} de ${totalChilds} itens.',
                        sort: 'Organizar',
                        sortTitle: 'Organizar os filhos deste ${type}',
                        sortTitleShort: 'Organizar os filhos',
                        sortFieldLabel: 'Campo:',
                        sortDirectionLabel: 'Direção:',
                        sortFieldTitle: 'Selecione um campo filho pelo qual ordenar o array ou objeto',
                        sortAscending: 'Ascendente',
                        sortAscendingTitle: 'Ordenar o campo selecionado por ordem ascendente',
                        sortDescending: 'Descendente',
                        sortDescendingTitle: 'Ordenar o campo selecionado por ordem descendente',
                        string: 'Texto',
                        transform: 'Transformar',
                        transformTitle: 'Filtrar, ordenar ou transformar os filhos deste ${type}',
                        transformTitleShort: 'Filtrar, ordenar ou transformar conteúdos',
                        transformQueryTitle: 'Insira uma expressão JMESPath',
                        transformWizardLabel: 'Assistente',
                        transformWizardFilter: 'Filtro',
                        transformWizardSortBy: 'Ordenar por',
                        transformWizardSelectFields: 'Selecionar campos',
                        transformQueryLabel: 'Expressão',
                        transformPreviewLabel: 'Visualizar',
                        type: 'Tipo',
                        typeTitle: 'Mudar o tipo deste campo',
                        openUrl: 'Ctrl+Click ou Ctrl+Enter para abrir link em nova janela',
                        undo: 'Desfazer último ação (Ctrl+Z)',
                        validationCannotMove: 'Não pode mover um campo como filho dele mesmo',
                        autoType: 'Campo do tipo "auto". ' + 'O tipo do campo é determinao automaticamente a partir do seu valor ' + 'e pode ser texto, número, verdade/falso ou nulo.',
                        objectType: 'Campo do tipo "objeto". ' + 'Um objeto contém uma lista de pares com chave e valor.',
                        arrayType: 'Campo do tipo "lista". ' + 'Uma lista contem uma coleção de valores ordenados.',
                        stringType: 'Campo do tipo "string". ' + 'Campo do tipo nao é determinado através do seu valor, ' + 'mas sempre retornara um texto.',
                        examples: 'Exemplos',
                        "default": 'Revelia'
                    },
                    tr: {
                        array: 'Dizin',
                        auto: 'Otomatik',
                        appendText: 'Ekle',
                        appendTitle: 'Bu alanın altına \'otomatik\' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)',
                        appendSubmenuTitle: 'Eklenecek alanın tipini seç',
                        appendTitleAuto: '\'Otomatik\' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)',
                        ascending: 'Artan',
                        ascendingTitle: '${type}\'ın alt tiplerini artan düzende sırala',
                        actionsMenu: 'Aksiyon menüsünü açmak için tıklayın (Ctrl+M)',
                        collapseAll: 'Tüm alanları kapat',
                        descending: 'Azalan',
                        descendingTitle: '${type}\'ın alt tiplerini azalan düzende sırala',
                        drag: 'Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)',
                        duplicateKey: 'Var olan anahtar',
                        duplicateText: 'Aşağıya kopyala',
                        duplicateTitle: 'Seçili alanlardan bir daha oluştur (Ctrl+D)',
                        duplicateField: 'Bu alandan bir daha oluştur (Ctrl+D)',
                        duplicateFieldError: 'Duplicate field name',
                        cannotParseFieldError: 'Alan JSON\'a ayrıştırılamıyor',
                        cannotParseValueError: 'JSON\'a değer ayrıştırılamıyor',
                        empty: 'boş',
                        expandAll: 'Tüm alanları aç',
                        expandTitle: 'Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \n' + 'Alt alanlarda dahil tüm alanları açmak için Ctrl+Click ',
                        insert: 'Ekle',
                        insertTitle: 'Bu alanın üstüne \'otomatik\' tipinde yeni bir alan ekle (Ctrl+Ins)',
                        insertSub: 'Araya eklenecek alanın tipini seç',
                        object: 'Nesne',
                        ok: 'Tamam',
                        redo: 'Yeniden yap (Ctrl+Shift+Z)',
                        removeText: 'Kaldır',
                        removeTitle: 'Seçilen alanları kaldır (Ctrl+Del)',
                        removeField: 'Bu alanı kaldır (Ctrl+Del)',
                        selectNode: 'Bir nesne seç...',
                        showAll: 'tümünü göster',
                        showMore: 'daha fazla göster',
                        showMoreStatus: '${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor',
                        sort: 'Sırala',
                        sortTitle: '${type}\'ın alt alanlarını sırala',
                        sortTitleShort: 'İçerikleri sırala',
                        sortFieldLabel: 'Alan:',
                        sortDirectionLabel: 'Yön:',
                        sortFieldTitle: 'Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin',
                        sortAscending: 'Artan',
                        sortAscendingTitle: 'Seçili alanı artan düzende sırala',
                        sortDescending: 'Azalan',
                        sortDescendingTitle: 'Seçili alanı azalan düzende sırala',
                        string: 'Karakter Dizisi',
                        transform: 'Dönüştür',
                        transformTitle: '${type}\'ın alt alanlarını filtrele, sırala veya dönüştür',
                        transformTitleShort: 'İçerikleri filterele, sırala veya dönüştür',
                        transformQueryTitle: 'JMESPath sorgusu gir',
                        transformWizardLabel: 'Sihirbaz',
                        transformWizardFilter: 'Filtre',
                        transformWizardSortBy: 'Sırala',
                        transformWizardSelectFields: 'Alanları seç',
                        transformQueryLabel: 'Sorgu',
                        transformPreviewLabel: 'Önizleme',
                        type: 'Tip',
                        typeTitle: 'Bu alanın tipini değiştir',
                        openUrl: 'URL\'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter',
                        undo: 'Son değişikliği geri al (Ctrl+Z)',
                        validationCannotMove: 'Alt alan olarak taşınamıyor',
                        autoType: 'Alan tipi "otomatik". ' + 'Alan türü otomatik olarak değerden belirlenir' + 've bir dize, sayı, boolean veya null olabilir.',
                        objectType: 'Alan tipi "nesne". ' + 'Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',
                        arrayType: 'Alan tipi "dizi". ' + 'Bir dizi, düzenli değerler koleksiyonu içerir.',
                        stringType: 'Alan tipi "karakter dizisi". ' + 'Alan türü değerden belirlenmez,' + 'ancak her zaman karakter dizisi olarak döndürülür.',
                        modeCodeText: 'Kod',
                        modeCodeTitle: 'Kod vurgulayıcıya geç',
                        modeFormText: 'Form',
                        modeFormTitle: 'Form düzenleyiciye geç',
                        modeTextText: 'Metin',
                        modeTextTitle: 'Düz metin düzenleyiciye geç',
                        modeTreeText: 'Ağaç',
                        modeTreeTitle: 'Ağaç düzenleyiciye geç',
                        modeViewText: 'Görünüm',
                        modeViewTitle: 'Ağaç görünümüne geç',
                        examples: 'Örnekler',
                        "default": 'Varsayılan'
                    },
                    ja: {
                        array: '配列',
                        auto: 'オート',
                        appendText: '追加',
                        appendTitle: '次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',
                        appendSubmenuTitle: '追加するフィールドの型を選択してください',
                        appendTitleAuto: '"オート"のフィールドを追加 (Ctrl+Shift+Ins)',
                        ascending: '昇順',
                        ascendingTitle: '${type}の子要素を昇順に並べ替え',
                        actionsMenu: 'クリックしてアクションメニューを開く (Ctrl+M)',
                        collapseAll: 'すべてを折りたたむ',
                        descending: '降順',
                        descendingTitle: '${type}の子要素を降順に並べ替え',
                        drag: 'ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)',
                        duplicateKey: '複製キー',
                        duplicateText: '複製',
                        duplicateTitle: '選択中のフィールドを複製 (Ctrl+D)',
                        duplicateField: '選択中のフィールドを複製 (Ctrl+D)',
                        duplicateFieldError: 'フィールド名が重複しています',
                        cannotParseFieldError: 'JSONのフィールドを解析できません',
                        cannotParseValueError: 'JSONの値を解析できません',
                        empty: '空',
                        expandAll: 'すべてを展開',
                        expandTitle: 'クリックしてフィールドを展開/折りたたむ (Ctrl+E). \n' + 'Ctrl+Click ですべての子要素を展開/折りたたむ',
                        insert: '挿入',
                        insertTitle: '選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)',
                        insertSub: '挿入するフィールドの型を選択',
                        object: 'オブジェクト',
                        ok: '実行',
                        redo: 'やり直す (Ctrl+Shift+Z)',
                        removeText: '削除',
                        removeTitle: '選択中のフィールドを削除 (Ctrl+Del)',
                        removeField: '選択中のフィールドを削除 (Ctrl+Del)',
                        selectNode: 'ノードを選択...',
                        showAll: 'すべてを表示',
                        showMore: 'もっと見る',
                        showMoreStatus: '${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。',
                        sort: '並べ替え',
                        sortTitle: '${type}の子要素を並べ替え',
                        sortTitleShort: '並べ替え',
                        sortFieldLabel: 'フィールド:',
                        sortDirectionLabel: '順序:',
                        sortFieldTitle: '配列またはオブジェクトを並び替えるためのフィールドを選択',
                        sortAscending: '昇順',
                        sortAscendingTitle: '選択中のフィールドを昇順に並び替え',
                        sortDescending: '降順',
                        sortDescendingTitle: '選択中のフィールドを降順に並び替え',
                        string: '文字列',
                        transform: '変換',
                        transformTitle: '${type}の子要素をフィルター・並び替え・変換する',
                        transformTitleShort: '内容をフィルター・並び替え・変換する',
                        extract: '抽出',
                        extractTitle: '${type}を抽出',
                        transformQueryTitle: 'JMESPathクエリを入力',
                        transformWizardLabel: 'ウィザード',
                        transformWizardFilter: 'フィルター',
                        transformWizardSortBy: '並び替え',
                        transformWizardSelectFields: 'フィールドを選択',
                        transformQueryLabel: 'クエリ',
                        transformPreviewLabel: 'プレビュー',
                        type: '型',
                        typeTitle: '選択中のフィールドの型を変更',
                        openUrl: 'Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く',
                        undo: '元に戻す (Ctrl+Z)',
                        validationCannotMove: '子要素に移動できません ',
                        autoType: 'オート： ' + 'フィールドの型は値から自動的に決定されます。 ' + '(文字列・数値・ブール・null)',
                        objectType: 'オブジェクト： ' + 'オブジェクトは順序が決まっていないキーと値のペア組み合わせです。',
                        arrayType: '配列： ' + '配列は順序が決まっている値の集合体です。',
                        stringType: '文字列： ' + 'フィールド型は値から決定されませんが、' + '常に文字列として返されます。',
                        modeCodeText: 'コードモード',
                        modeCodeTitle: 'ハイライトモードに切り替え',
                        modeFormText: 'フォームモード',
                        modeFormTitle: 'フォームモードに切り替え',
                        modeTextText: 'テキストモード',
                        modeTextTitle: 'テキストモードに切り替え',
                        modeTreeText: 'ツリーモード',
                        modeTreeTitle: 'ツリーモードに切り替え',
                        modeViewText: 'ビューモード',
                        modeViewTitle: 'ビューモードに切り替え',
                        modePreviewText: 'プレビュー',
                        modePreviewTitle: 'プレビューに切り替え',
                        examples: '例',
                        "default": 'デフォルト'
                    },
                    'fr-FR': {
                        array: 'Liste',
                        auto: 'Auto',
                        appendText: 'Ajouter',
                        appendTitle: 'Ajouter un champ de type \'auto\' après ce champ (Ctrl+Shift+Ins)',
                        appendSubmenuTitle: 'Sélectionner le type du champ à ajouter',
                        appendTitleAuto: 'Ajouter un champ de type \'auto\' (Ctrl+Shift+Ins)',
                        ascending: 'Ascendant',
                        ascendingTitle: 'Trier les enfants de ce ${type} par ordre ascendant',
                        actionsMenu: 'Ouvrir le menu des actions (Ctrl+M)',
                        collapseAll: 'Regrouper',
                        descending: 'Descendant',
                        descendingTitle: 'Trier les enfants de ce ${type} par ordre descendant',
                        drag: 'Déplacer (Alt+Shift+Arrows)',
                        duplicateKey: 'Dupliquer la clé',
                        duplicateText: 'Dupliquer',
                        duplicateTitle: 'Dupliquer les champs sélectionnés (Ctrl+D)',
                        duplicateField: 'Dupliquer ce champ (Ctrl+D)',
                        duplicateFieldError: 'Dupliquer le nom de champ',
                        cannotParseFieldError: 'Champ impossible à parser en JSON',
                        cannotParseValueError: 'Valeur impossible à parser en JSON',
                        empty: 'vide',
                        expandAll: 'Étendre',
                        expandTitle: 'Étendre/regrouper ce champ (Ctrl+E). \n' + 'Ctrl+Click pour étendre/regrouper avec tous les champs.',
                        insert: 'Insérer',
                        insertTitle: 'Insérer un champ de type \'auto\' avant ce champ (Ctrl+Ins)',
                        insertSub: 'Sélectionner le type de champ à insérer',
                        object: 'Objet',
                        ok: 'Ok',
                        redo: 'Rejouer (Ctrl+Shift+Z)',
                        removeText: 'Supprimer',
                        removeTitle: 'Supprimer les champs sélectionnés (Ctrl+Del)',
                        removeField: 'Supprimer ce champ (Ctrl+Del)',
                        searchTitle: 'Rechercher champs et valeurs',
                        searchNextResultTitle: 'Résultat suivant (Enter)',
                        searchPreviousResultTitle: 'Résultat précédent (Shift + Enter)',
                        selectNode: 'Sélectionner un nœud...',
                        showAll: 'voir tout',
                        showMore: 'voir plus',
                        showMoreStatus: '${visibleChilds} éléments affichés de ${totalChilds}.',
                        sort: 'Trier',
                        sortTitle: 'Trier les champs de ce ${type}',
                        sortTitleShort: 'Trier',
                        sortFieldLabel: 'Champ:',
                        sortDirectionLabel: 'Direction:',
                        sortFieldTitle: 'Sélectionner les champs permettant de trier les listes et objet',
                        sortAscending: 'Ascendant',
                        sortAscendingTitle: 'Trier les champs sélectionnés par ordre ascendant',
                        sortDescending: 'Descendant',
                        sortDescendingTitle: 'Trier les champs sélectionnés par ordre descendant',
                        string: 'Chaîne',
                        transform: 'Transformer',
                        transformTitle: 'Filtrer, trier, or transformer les enfants de ce ${type}',
                        transformTitleShort: 'Filtrer, trier ou transformer le contenu',
                        extract: 'Extraire',
                        extractTitle: 'Extraire ce ${type}',
                        transformQueryTitle: 'Saisir une requête JMESPath',
                        transformWizardLabel: 'Assistant',
                        transformWizardFilter: 'Filtrer',
                        transformWizardSortBy: 'Trier par',
                        transformWizardSelectFields: 'Sélectionner les champs',
                        transformQueryLabel: 'Requête',
                        transformPreviewLabel: 'Prévisualisation',
                        type: 'Type',
                        typeTitle: 'Changer le type de ce champ',
                        openUrl: 'Ctrl+Click ou Ctrl+Enter pour ouvrir l\'url dans une autre fenêtre',
                        undo: 'Annuler la dernière action (Ctrl+Z)',
                        validationCannotMove: 'Cannot move a field into a child of itself',
                        autoType: 'Champe de type "auto". ' + 'Ce type de champ est automatiquement déterminé en fonction de la valeur ' + 'et peut être de type "chaîne", "nombre", "booléen" ou null.',
                        objectType: 'Champ de type "objet". ' + 'Un objet contient un ensemble non ordonné de paires clé/valeur.',
                        arrayType: 'Champ de type "liste". ' + 'Une liste contient une collection ordonnée de valeurs.',
                        stringType: 'Champ de type "chaîne". ' + 'Ce type de champ n\'est pas déterminé en fonction de la valeur, ' + 'mais retourne systématiquement une chaîne de caractères.',
                        modeEditorTitle: 'Changer mode d\'édition',
                        modeCodeText: 'Code',
                        modeCodeTitle: 'Activer surlignage code',
                        modeFormText: 'Formulaire',
                        modeFormTitle: 'Activer formulaire',
                        modeTextText: 'Texte',
                        modeTextTitle: 'Activer éditeur texte',
                        modeTreeText: 'Arbre',
                        modeTreeTitle: 'Activer éditeur arbre',
                        modeViewText: 'Lecture seule',
                        modeViewTitle: 'Activer vue arbre',
                        modePreviewText: 'Prévisualisation',
                        modePreviewTitle: 'Activer mode prévisualiser',
                        examples: 'Exemples',
                        "default": 'Défaut'
                    }
                };
                var _defaultLang = 'en';
                var userLang = typeof navigator !== 'undefined' ? navigator.language || navigator.userLanguage : undefined;

                var _lang = _locales.find(function (l) {
                    return l === userLang;
                }) || _defaultLang;

                function setLanguage(lang) {
                    if (!lang) {
                        return;
                    }

                    var langFound = _locales.find(function (l) {
                        return l === lang;
                    });

                    if (langFound) {
                        _lang = langFound;
                    } else {
                        console.error('Language not found');
                    }
                }

                function setLanguages(languages) {
                    if (!languages) {
                        return;
                    }

                    var _loop = function _loop(language) {
                        var langFound = _locales.find(function (l) {
                            return l === language;
                        });

                        if (!langFound) {
                            _locales.push(language);
                        }

                        _defs[language] = Object.assign({}, _defs[_defaultLang], _defs[language], languages[language]);
                    };

                    for (var language in languages) {
                        _loop(language);
                    }
                }

                function translate(key, data, lang) {
                    if (!lang) {
                        lang = _lang;
                    }

                    var text = _defs[lang][key] || _defs[_defaultLang][key] || key;

                    if (data) {
                        for (var dataKey in data) {
                            text = text.replace('${' + dataKey + '}', data[dataKey]);
                        }
                    }

                    return text;
                }

                /***/
            }),
            /* 2 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return DEFAULT_MODAL_ANCHOR;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "d", function () {
                    return SIZE_LARGE;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "b", function () {
                    return MAX_PREVIEW_CHARACTERS;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "c", function () {
                    return PREVIEW_HISTORY_LIMIT;
                });
                var DEFAULT_MODAL_ANCHOR = document.body;
                var SIZE_LARGE = 10 * 1024 * 1024; // 10 MB

                var MAX_PREVIEW_CHARACTERS = 20000;
                var PREVIEW_HISTORY_LIMIT = 2 * 1024 * 1024 * 1024; // 2 GB

                /***/
            }),
            /* 3 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return ContextMenu;
                });
                /* harmony import */
                var _createAbsoluteAnchor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(12);
                /* harmony import */
                var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(0);
                /* harmony import */
                var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1);


                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }


                /**
                 * A context menu
                 * @param {Object[]} items    Array containing the menu structure
                 *                            TODO: describe structure
                 * @param {Object} [options]  Object with options. Available options:
                 *                            {function} close    Callback called when the
                 *                                                context menu is being closed.
                 * @constructor
                 */

                var ContextMenu = /*#__PURE__*/function () {
                    function ContextMenu(items, options) {
                        _classCallCheck(this, ContextMenu);

                        this.dom = {};
                        var me = this;
                        var dom = this.dom;
                        this.anchor = undefined;
                        this.items = items;
                        this.eventListeners = {};
                        this.selection = undefined; // holds the selection before the menu was opened

                        this.onClose = options ? options.close : undefined; // create root element

                        var root = document.createElement('div');
                        root.className = 'jsoneditor-contextmenu-root';
                        dom.root = root; // create a container element

                        var menu = document.createElement('div');
                        menu.className = 'jsoneditor-contextmenu';
                        dom.menu = menu;
                        root.appendChild(menu); // create a list to hold the menu items

                        var list = document.createElement('ul');
                        list.className = 'jsoneditor-menu';
                        menu.appendChild(list);
                        dom.list = list;
                        dom.items = []; // list with all buttons
                        // create a (non-visible) button to set the focus to the menu

                        var focusButton = document.createElement('button');
                        focusButton.type = 'button';
                        dom.focusButton = focusButton;
                        var li = document.createElement('li');
                        li.style.overflow = 'hidden';
                        li.style.height = '0';
                        li.appendChild(focusButton);
                        list.appendChild(li);

                        function createMenuItems(list, domItems, items) {
                            items.forEach(function (item) {
                                if (item.type === 'separator') {
                                    // create a separator
                                    var separator = document.createElement('div');
                                    separator.className = 'jsoneditor-separator';

                                    var _li = document.createElement('li');

                                    _li.appendChild(separator);

                                    list.appendChild(_li);
                                } else {
                                    var domItem = {}; // create a menu item

                                    var _li2 = document.createElement('li');

                                    list.appendChild(_li2); // create a button in the menu item

                                    var button = document.createElement('button');
                                    button.type = 'button';
                                    button.className = item.className;
                                    domItem.button = button;

                                    if (item.title) {
                                        button.title = item.title;
                                    }

                                    if (item.click) {
                                        button.onclick = function (event) {
                                            event.preventDefault();
                                            me.hide();
                                            item.click();
                                        };
                                    }

                                    _li2.appendChild(button); // create the contents of the button


                                    if (item.submenu) {
                                        // add the icon to the button
                                        var divIcon = document.createElement('div');
                                        divIcon.className = 'jsoneditor-icon';
                                        button.appendChild(divIcon);
                                        var divText = document.createElement('div');
                                        divText.className = 'jsoneditor-text' + (item.click ? '' : ' jsoneditor-right-margin');
                                        divText.appendChild(document.createTextNode(item.text));
                                        button.appendChild(divText);
                                        var buttonSubmenu;

                                        if (item.click) {
                                            // submenu and a button with a click handler
                                            button.className += ' jsoneditor-default';
                                            var buttonExpand = document.createElement('button');
                                            buttonExpand.type = 'button';
                                            domItem.buttonExpand = buttonExpand;
                                            buttonExpand.className = 'jsoneditor-expand';
                                            buttonExpand.innerHTML = '<div class="jsoneditor-expand"></div>';

                                            _li2.appendChild(buttonExpand);

                                            if (item.submenuTitle) {
                                                buttonExpand.title = item.submenuTitle;
                                            }

                                            buttonSubmenu = buttonExpand;
                                        } else {
                                            // submenu and a button without a click handler
                                            var divExpand = document.createElement('div');
                                            divExpand.className = 'jsoneditor-expand';
                                            button.appendChild(divExpand);
                                            buttonSubmenu = button;
                                        } // attach a handler to expand/collapse the submenu


                                        buttonSubmenu.onclick = function (event) {
                                            event.preventDefault();

                                            me._onExpandItem(domItem);

                                            buttonSubmenu.focus();
                                        }; // create the submenu


                                        var domSubItems = [];
                                        domItem.subItems = domSubItems;
                                        var ul = document.createElement('ul');
                                        domItem.ul = ul;
                                        ul.className = 'jsoneditor-menu';
                                        ul.style.height = '0';

                                        _li2.appendChild(ul);

                                        createMenuItems(ul, domSubItems, item.submenu);
                                    } else {
                                        // no submenu, just a button with clickhandler
                                        button.innerHTML = '<div class="jsoneditor-icon"></div>' + '<div class="jsoneditor-text">' + Object(_i18n__WEBPACK_IMPORTED_MODULE_2__[/* translate */ "c"])(item.text) + '</div>';
                                    }

                                    domItems.push(domItem);
                                }
                            });
                        }

                        createMenuItems(list, this.dom.items, items); // TODO: when the editor is small, show the submenu on the right instead of inline?
                        // calculate the max height of the menu with one submenu expanded

                        this.maxHeight = 0; // height in pixels

                        items.forEach(function (item) {
                            var height = (items.length + (item.submenu ? item.submenu.length : 0)) * 24;
                            me.maxHeight = Math.max(me.maxHeight, height);
                        });
                    }

                    /**
                     * Get the currently visible buttons
                     * @return {Array.<HTMLElement>} buttons
                     * @private
                     */


                    _createClass(ContextMenu, [{
                        key: "_getVisibleButtons",
                        value: function _getVisibleButtons() {
                            var buttons = [];
                            var me = this;
                            this.dom.items.forEach(function (item) {
                                buttons.push(item.button);

                                if (item.buttonExpand) {
                                    buttons.push(item.buttonExpand);
                                }

                                if (item.subItems && item === me.expandedItem) {
                                    item.subItems.forEach(function (subItem) {
                                        buttons.push(subItem.button);

                                        if (subItem.buttonExpand) {
                                            buttons.push(subItem.buttonExpand);
                                        } // TODO: change to fully recursive method

                                    });
                                }
                            });
                            return buttons;
                        }
                        /**
                         * Attach the menu to an anchor
                         * @param {HTMLElement} anchor    Anchor where the menu will be attached as sibling.
                         * @param {HTMLElement} frame     The root of the JSONEditor window
                         * @param {Boolean=} ignoreParent ignore anchor parent in regard to the calculation of the position, needed when the parent position is absolute
                         */

                    }, {
                        key: "show",
                        value: function show(anchor, frame, ignoreParent) {
                            this.hide(); // determine whether to display the menu below or above the anchor

                            var showBelow = true;
                            var parent = anchor.parentNode;
                            var anchorRect = anchor.getBoundingClientRect();
                            var parentRect = parent.getBoundingClientRect();
                            var frameRect = frame.getBoundingClientRect();
                            var me = this;
                            this.dom.absoluteAnchor = Object(_createAbsoluteAnchor__WEBPACK_IMPORTED_MODULE_0__[/* createAbsoluteAnchor */ "a"])(anchor, frame, function () {
                                me.hide();
                            });

                            if (anchorRect.bottom + this.maxHeight < frameRect.bottom) {// fits below -> show below
                            } else if (anchorRect.top - this.maxHeight > frameRect.top) {
                                // fits above -> show above
                                showBelow = false;
                            } else {// doesn't fit above nor below -> show below
                            }

                            var topGap = ignoreParent ? 0 : anchorRect.top - parentRect.top; // position the menu

                            if (showBelow) {
                                // display the menu below the anchor
                                var anchorHeight = anchor.offsetHeight;
                                this.dom.menu.style.left = '0';
                                this.dom.menu.style.top = topGap + anchorHeight + 'px';
                                this.dom.menu.style.bottom = '';
                            } else {
                                // display the menu above the anchor
                                this.dom.menu.style.left = '0';
                                this.dom.menu.style.top = '';
                                this.dom.menu.style.bottom = '0px';
                            } // attach the menu to the temporary, absolute anchor
                            // parent.insertBefore(this.dom.root, anchor);


                            this.dom.absoluteAnchor.appendChild(this.dom.root); // move focus to the first button in the context menu

                            this.selection = Object(_util__WEBPACK_IMPORTED_MODULE_1__["getSelection"])();
                            this.anchor = anchor;
                            setTimeout(function () {
                                me.dom.focusButton.focus();
                            }, 0);

                            if (ContextMenu.visibleMenu) {
                                ContextMenu.visibleMenu.hide();
                            }

                            ContextMenu.visibleMenu = this;
                        }
                        /**
                         * Hide the context menu if visible
                         */

                    }, {
                        key: "hide",
                        value: function hide() {
                            // remove temporary absolutely positioned anchor
                            if (this.dom.absoluteAnchor) {
                                this.dom.absoluteAnchor.destroy();
                                delete this.dom.absoluteAnchor;
                            } // remove the menu from the DOM


                            if (this.dom.root.parentNode) {
                                this.dom.root.parentNode.removeChild(this.dom.root);

                                if (this.onClose) {
                                    this.onClose();
                                }
                            }

                            if (ContextMenu.visibleMenu === this) {
                                ContextMenu.visibleMenu = undefined;
                            }
                        }
                        /**
                         * Expand a submenu
                         * Any currently expanded submenu will be hided.
                         * @param {Object} domItem
                         * @private
                         */

                    }, {
                        key: "_onExpandItem",
                        value: function _onExpandItem(domItem) {
                            var me = this;
                            var alreadyVisible = domItem === this.expandedItem; // hide the currently visible submenu

                            var expandedItem = this.expandedItem;

                            if (expandedItem) {
                                // var ul = expandedItem.ul;
                                expandedItem.ul.style.height = '0';
                                expandedItem.ul.style.padding = '';
                                setTimeout(function () {
                                    if (me.expandedItem !== expandedItem) {
                                        expandedItem.ul.style.display = '';
                                        Object(_util__WEBPACK_IMPORTED_MODULE_1__["removeClassName"])(expandedItem.ul.parentNode, 'jsoneditor-selected');
                                    }
                                }, 300); // timeout duration must match the css transition duration

                                this.expandedItem = undefined;
                            }

                            if (!alreadyVisible) {
                                var ul = domItem.ul;
                                ul.style.display = 'block'; // eslint-disable-next-line no-unused-expressions

                                ul.clientHeight; // force a reflow in Firefox

                                setTimeout(function () {
                                    if (me.expandedItem === domItem) {
                                        var childsHeight = 0;

                                        for (var i = 0; i < ul.childNodes.length; i++) {
                                            childsHeight += ul.childNodes[i].clientHeight;
                                        }

                                        ul.style.height = childsHeight + 'px';
                                        ul.style.padding = '5px 10px';
                                    }
                                }, 0);
                                Object(_util__WEBPACK_IMPORTED_MODULE_1__["addClassName"])(ul.parentNode, 'jsoneditor-selected');
                                this.expandedItem = domItem;
                            }
                        }
                        /**
                         * Handle onkeydown event
                         * @param {Event} event
                         * @private
                         */

                    }, {
                        key: "_onKeyDown",
                        value: function _onKeyDown(event) {
                            var target = event.target;
                            var keynum = event.which;
                            var handled = false;
                            var buttons, targetIndex, prevButton, nextButton;

                            if (keynum === 27) {
                                // ESC
                                // hide the menu on ESC key
                                // restore previous selection and focus
                                if (this.selection) {
                                    Object(_util__WEBPACK_IMPORTED_MODULE_1__["setSelection"])(this.selection);
                                }

                                if (this.anchor) {
                                    this.anchor.focus();
                                }

                                this.hide();
                                handled = true;
                            } else if (keynum === 9) {
                                // Tab
                                if (!event.shiftKey) {
                                    // Tab
                                    buttons = this._getVisibleButtons();
                                    targetIndex = buttons.indexOf(target);

                                    if (targetIndex === buttons.length - 1) {
                                        // move to first button
                                        buttons[0].focus();
                                        handled = true;
                                    }
                                } else {
                                    // Shift+Tab
                                    buttons = this._getVisibleButtons();
                                    targetIndex = buttons.indexOf(target);

                                    if (targetIndex === 0) {
                                        // move to last button
                                        buttons[buttons.length - 1].focus();
                                        handled = true;
                                    }
                                }
                            } else if (keynum === 37) {
                                // Arrow Left
                                if (target.className === 'jsoneditor-expand') {
                                    buttons = this._getVisibleButtons();
                                    targetIndex = buttons.indexOf(target);
                                    prevButton = buttons[targetIndex - 1];

                                    if (prevButton) {
                                        prevButton.focus();
                                    }
                                }

                                handled = true;
                            } else if (keynum === 38) {
                                // Arrow Up
                                buttons = this._getVisibleButtons();
                                targetIndex = buttons.indexOf(target);
                                prevButton = buttons[targetIndex - 1];

                                if (prevButton && prevButton.className === 'jsoneditor-expand') {
                                    // skip expand button
                                    prevButton = buttons[targetIndex - 2];
                                }

                                if (!prevButton) {
                                    // move to last button
                                    prevButton = buttons[buttons.length - 1];
                                }

                                if (prevButton) {
                                    prevButton.focus();
                                }

                                handled = true;
                            } else if (keynum === 39) {
                                // Arrow Right
                                buttons = this._getVisibleButtons();
                                targetIndex = buttons.indexOf(target);
                                nextButton = buttons[targetIndex + 1];

                                if (nextButton && nextButton.className === 'jsoneditor-expand') {
                                    nextButton.focus();
                                }

                                handled = true;
                            } else if (keynum === 40) {
                                // Arrow Down
                                buttons = this._getVisibleButtons();
                                targetIndex = buttons.indexOf(target);
                                nextButton = buttons[targetIndex + 1];

                                if (nextButton && nextButton.className === 'jsoneditor-expand') {
                                    // skip expand button
                                    nextButton = buttons[targetIndex + 2];
                                }

                                if (!nextButton) {
                                    // move to first button
                                    nextButton = buttons[0];
                                }

                                if (nextButton) {
                                    nextButton.focus();
                                    handled = true;
                                }

                                handled = true;
                            } // TODO: arrow left and right


                            if (handled) {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                        }
                    }]);

                    return ContextMenu;
                }(); // currently displayed context menu, a singleton. We may only have one visible context menu

                ContextMenu.visibleMenu = undefined;
                /* unused harmony default export */
                var _unused_webpack_default_export = (ContextMenu);

                /***/
            }),
            /* 4 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return createQuery;
                });
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "b", function () {
                    return executeQuery;
                });
                /* harmony import */
                var jmespath__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34);
                /* harmony import */
                var jmespath__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jmespath__WEBPACK_IMPORTED_MODULE_0__);
                /* harmony import */
                var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(0);


                /**
                 * Build a JMESPath query based on query options coming from the wizard
                 * @param {JSON} json   The JSON document for which to build the query.
                 *                      Used for context information like determining
                 *                      the type of values (string or number)
                 * @param {QueryOptions} queryOptions
                 * @return {string} Returns a query (as string)
                 */

                function createQuery(json, queryOptions) {
                    var sort = queryOptions.sort,
                        filter = queryOptions.filter,
                        projection = queryOptions.projection;
                    var query = '';

                    if (filter) {
                        var examplePath = filter.field !== '@' ? ['0'].concat(Object(_util__WEBPACK_IMPORTED_MODULE_1__["parsePath"])('.' + filter.field)) : ['0'];
                        var exampleValue = Object(_util__WEBPACK_IMPORTED_MODULE_1__["get"])(json, examplePath);
                        var value1 = typeof exampleValue === 'string' ? filter.value : Object(_util__WEBPACK_IMPORTED_MODULE_1__["parseString"])(filter.value);
                        query += '[? ' + filter.field + ' ' + filter.relation + ' ' + '`' + JSON.stringify(value1) + '`' + ']';
                    } else {
                        query += Array.isArray(json) ? '[*]' : '@';
                    }

                    if (sort) {
                        if (sort.direction === 'desc') {
                            query += ' | reverse(sort_by(@, &' + sort.field + '))';
                        } else {
                            query += ' | sort_by(@, &' + sort.field + ')';
                        }
                    }

                    if (projection) {
                        if (query[query.length - 1] !== ']') {
                            query += ' | [*]';
                        }

                        if (projection.fields.length === 1) {
                            query += '.' + projection.fields[0];
                        } else if (projection.fields.length > 1) {
                            query += '.{' + projection.fields.map(function (value) {
                                var parts = value.split('.');
                                var last = parts[parts.length - 1];
                                return last + ': ' + value;
                            }).join(', ') + '}';
                        } else {// values.length === 0
                            // ignore
                        }
                    }

                    return query;
                }

                /**
                 * Execute a JMESPath query
                 * @param {JSON} json
                 * @param {string} query
                 * @return {JSON} Returns the transformed JSON
                 */

                function executeQuery(json, query) {
                    return jmespath__WEBPACK_IMPORTED_MODULE_0___default.a.search(json, query);
                }

                /***/
            }),
            /* 5 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                __webpack_require__.r(__webpack_exports__);
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "showSortModal", function () {
                    return showSortModal;
                });
                /* harmony import */
                var picomodal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
                /* harmony import */
                var picomodal__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(picomodal__WEBPACK_IMPORTED_MODULE_0__);
                /* harmony import */
                var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
                /* harmony import */
                var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(0);


                /**
                 * Show advanced sorting modal
                 * @param {HTMLElement} container   The container where to center
                 *                                  the modal and create an overlay
                 * @param {JSON} json               The JSON data to be sorted.
                 * @param {function} onSort         Callback function, invoked with
                 *                                  an object containing the selected
                 *                                  path and direction
                 * @param {Object} options
                 *            Available options:
                 *                - {string} path              The selected path
                 *                - {'asc' | 'desc'} direction The selected direction
                 */

                function showSortModal(container, json, onSort, options) {
                    var paths = Array.isArray(json) ? Object(_util__WEBPACK_IMPORTED_MODULE_2__["getChildPaths"])(json) : [''];
                    var selectedPath = options && options.path && Object(_util__WEBPACK_IMPORTED_MODULE_2__["contains"])(paths, options.path) ? options.path : paths[0];
                    var selectedDirection = options && options.direction || 'asc';
                    var content = '<div class="pico-modal-contents">' + '<div class="pico-modal-header">' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sort') + '</div>' + '<form>' + '<table>' + '<tbody>' + '<tr>' + '  <td>' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortFieldLabel') + ' </td>' + '  <td class="jsoneditor-modal-input">' + '  <div class="jsoneditor-select-wrapper">' + '    <select id="field" title="' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortFieldTitle') + '">' + '    </select>' + '  </div>' + '  </td>' + '</tr>' + '<tr>' + '  <td>' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortDirectionLabel') + ' </td>' + '  <td class="jsoneditor-modal-input">' + '  <div id="direction" class="jsoneditor-button-group">' + '<input type="button" ' + 'value="' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortAscending') + '" ' + 'title="' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortAscendingTitle') + '" ' + 'data-value="asc" ' + 'class="jsoneditor-button-first jsoneditor-button-asc"/>' + '<input type="button" ' + 'value="' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortDescending') + '" ' + 'title="' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('sortDescendingTitle') + '" ' + 'data-value="desc" ' + 'class="jsoneditor-button-last jsoneditor-button-desc"/>' + '  </div>' + '  </td>' + '</tr>' + '<tr>' + '<td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">' + '  <input type="submit" id="ok" value="' + Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('ok') + '" />' + '</td>' + '</tr>' + '</tbody>' + '</table>' + '</form>' + '</div>';
                    picomodal__WEBPACK_IMPORTED_MODULE_0___default()({
                        parent: container,
                        content: content,
                        overlayClass: 'jsoneditor-modal-overlay',
                        overlayStyles: {
                            backgroundColor: 'rgb(1,1,1)',
                            opacity: 0.3
                        },
                        modalClass: 'jsoneditor-modal jsoneditor-modal-sort'
                    }).afterCreate(function (modal) {
                        var form = modal.modalElem().querySelector('form');
                        var ok = modal.modalElem().querySelector('#ok');
                        var field = modal.modalElem().querySelector('#field');
                        var direction = modal.modalElem().querySelector('#direction');

                        function preprocessPath(path) {
                            return path === '' ? '@' : path[0] === '.' ? path.slice(1) : path;
                        }

                        paths.forEach(function (path) {
                            var option = document.createElement('option');
                            option.text = preprocessPath(path);
                            option.value = path;
                            field.appendChild(option);
                        });

                        function setDirection(value) {
                            direction.value = value;
                            direction.className = 'jsoneditor-button-group jsoneditor-button-group-value-' + direction.value;
                        }

                        field.value = selectedPath || paths[0];
                        setDirection(selectedDirection || 'asc');

                        direction.onclick = function (event) {
                            setDirection(event.target.getAttribute('data-value'));
                        };

                        ok.onclick = function (event) {
                            event.preventDefault();
                            event.stopPropagation();
                            modal.close();
                            onSort({
                                path: field.value,
                                direction: direction.value
                            });
                        };

                        if (form) {
                            // form is not available when JSONEditor is created inside a form
                            form.onsubmit = ok.onclick;
                        }
                    }).afterClose(function (modal) {
                        modal.destroy();
                    }).show();
                }

                /***/
            }),
            /* 6 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
// ESM COMPAT FLAG
                __webpack_require__.r(__webpack_exports__);

// EXPORTS
                __webpack_require__.d(__webpack_exports__, "showTransformModal", function () {
                    return /* binding */ showTransformModal;
                });

// EXTERNAL MODULE: ./node_modules/picomodal/src/picoModal.js
                var picoModal = __webpack_require__(14);
                var picoModal_default = /*#__PURE__*/__webpack_require__.n(picoModal);

// EXTERNAL MODULE: ./src/js/assets/selectr/selectr.js
                var selectr = __webpack_require__(10);
                var selectr_default = /*#__PURE__*/__webpack_require__.n(selectr);

// EXTERNAL MODULE: ./src/js/i18n.js
                var i18n = __webpack_require__(1);

// CONCATENATED MODULE: ./src/js/jsonUtils.js

                /**
                 * Convert part of a JSON object to a JSON string.
                 * Use case is to stringify a small part of a large JSON object so you can see
                 * a preview.
                 *
                 * @param {*} value
                 * The value to convert to a JSON string.
                 *
                 * @param {number | string | null} [space]
                 * A String or Number object that's used to insert white space into the output
                 * JSON string for readability purposes. If this is a Number, it indicates the
                 * number of space characters to use as white space; this number is capped at 10
                 * if it's larger than that. Values less than 1 indicate that no space should be
                 * used. If this is a String, the string (or the first 10 characters of the string,
                 * if it's longer than that) is used as white space. If this parameter is not
                 * provided (or is null), no white space is used.
                 *
                 * @param {number} [limit] Maximum size of the string output.
                 *
                 * @returns {string | undefined} Returns the string representation of the JSON object.
                 */

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                function stringifyPartial(value, space, limit) {
                    var _space; // undefined by default


                    if (typeof space === 'number') {
                        if (space > 10) {
                            _space = repeat(' ', 10);
                        } else if (space >= 1) {
                            _space = repeat(' ', space);
                        } // else ignore

                    } else if (typeof space === 'string' && space !== '') {
                        _space = space;
                    }

                    var output = stringifyValue(value, _space, '', limit);
                    return output.length > limit ? slice(output, limit) + '...' : output;
                }

                /**
                 * Stringify a value
                 * @param {*} value
                 * @param {string} space
                 * @param {string} indent
                 * @param {number} limit
                 * @return {string | undefined}
                 */

                function stringifyValue(value, space, indent, limit) {
                    // boolean, null, number, string, or date
                    if (typeof value === 'boolean' || value instanceof Boolean || value === null || typeof value === 'number' || value instanceof Number || typeof value === 'string' || value instanceof String || value instanceof Date) {
                        return JSON.stringify(value);
                    } // array


                    if (Array.isArray(value)) {
                        return stringifyArray(value, space, indent, limit);
                    } // object (test lastly!)


                    if (value && _typeof(value) === 'object') {
                        return stringifyObject(value, space, indent, limit);
                    }

                    return undefined;
                }

                /**
                 * Stringify an array
                 * @param {Array} array
                 * @param {string} space
                 * @param {string} indent
                 * @param {number} limit
                 * @return {string}
                 */


                function stringifyArray(array, space, indent, limit) {
                    var childIndent = space ? indent + space : undefined;
                    var str = space ? '[\n' : '[';

                    for (var i = 0; i < array.length; i++) {
                        var item = array[i];

                        if (space) {
                            str += childIndent;
                        }

                        if (typeof item !== 'undefined' && typeof item !== 'function') {
                            str += stringifyValue(item, space, childIndent, limit);
                        } else {
                            str += 'null';
                        }

                        if (i < array.length - 1) {
                            str += space ? ',\n' : ',';
                        } // stop as soon as we're exceeding the limit


                        if (str.length > limit) {
                            return str + '...';
                        }
                    }

                    str += space ? '\n' + indent + ']' : ']';
                    return str;
                }

                /**
                 * Stringify an object
                 * @param {Object} object
                 * @param {string} space
                 * @param {string} indent
                 * @param {number} limit
                 * @return {string}
                 */


                function stringifyObject(object, space, indent, limit) {
                    var childIndent = space ? indent + space : undefined;
                    var first = true;
                    var str = space ? '{\n' : '{';

                    if (typeof object.toJSON === 'function') {
                        return stringifyValue(object.toJSON(), space, indent, limit);
                    }

                    for (var key in object) {
                        if (jsonUtils_hasOwnProperty(object, key)) {
                            var value = object[key];

                            if (first) {
                                first = false;
                            } else {
                                str += space ? ',\n' : ',';
                            }

                            str += space ? childIndent + '"' + key + '": ' : '"' + key + '":';
                            str += stringifyValue(value, space, childIndent, limit); // stop as soon as we're exceeding the limit

                            if (str.length > limit) {
                                return str + '...';
                            }
                        }
                    }

                    str += space ? '\n' + indent + '}' : '}';
                    return str;
                }

                /**
                 * Repeat a string a number of times.
                 * Simple linear solution, we only need up to 10 iterations in practice
                 * @param {string} text
                 * @param {number} times
                 * @return {string}
                 */


                function repeat(text, times) {
                    var res = '';

                    while (times-- > 0) {
                        res += text;
                    }

                    return res;
                }

                /**
                 * Limit the length of text
                 * @param {string} text
                 * @param {number} [limit]
                 * @return {string}
                 */


                function slice(text, limit) {
                    return typeof limit === 'number' ? text.slice(0, limit) : text;
                }

                /**
                 * Test whether some text contains a JSON array, i.e. the first
                 * non-white space character is a [
                 * @param {string} jsonText
                 * @return {boolean}
                 */


                function containsArray(jsonText) {
                    return /^\s*\[/.test(jsonText);
                }

                function jsonUtils_hasOwnProperty(object, key) {
                    return Object.prototype.hasOwnProperty.call(object, key);
                }

// EXTERNAL MODULE: ./src/js/util.js
                var util = __webpack_require__(0);

// EXTERNAL MODULE: ./src/js/constants.js
                var constants = __webpack_require__(2);

// CONCATENATED MODULE: ./src/js/showTransformModal.js


                var DEFAULT_DESCRIPTION = 'Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>' + 'To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';

                /**
                 * Show advanced filter and transform modal using JMESPath
                 * @param {Object} params
                 * @property {HTMLElement} container   The container where to center
                 *                                     the modal and create an overlay
                 * @property {JSON} json               The json data to be transformed
                 * @property {string} [queryDescription] Optional custom description explaining
                 *                                       the transform functionality
                 * @property {function} createQuery    Function called to create a query
                 *                                     from the wizard form
                 * @property {function} executeQuery   Execute a query for the preview pane
                 * @property {function} onTransform    Callback invoked with the created
                 *                                     query as callback
                 */

                function showTransformModal(_ref) {
                    var container = _ref.container,
                        json = _ref.json,
                        _ref$queryDescription = _ref.queryDescription,
                        queryDescription = _ref$queryDescription === void 0 ? DEFAULT_DESCRIPTION : _ref$queryDescription,
                        createQuery = _ref.createQuery,
                        executeQuery = _ref.executeQuery,
                        onTransform = _ref.onTransform;
                    var value = json;
                    var content = '<label class="pico-modal-contents">' + '<div class="pico-modal-header">' + Object(i18n["c" /* translate */])('transform') + '</div>' + '<p>' + queryDescription + '</p>' + '<div class="jsoneditor-jmespath-label">' + Object(i18n["c" /* translate */])('transformWizardLabel') + ' </div>' + '<div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">' + '  <table class="jsoneditor-jmespath-wizard-table">' + '    <tbody>' + '      <tr>' + '        <th>' + Object(i18n["c" /* translate */])('transformWizardFilter') + '</th>' + '        <td class="jsoneditor-jmespath-filter">' + '          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >' + '            <select id="filterField">' + '            </select>' + '          </div>' + '          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >' + '            <select id="filterRelation">' + '              <option value="==">==</option>' + '              <option value="!=">!=</option>' + '              <option value="<">&lt;</option>' + '              <option value="<=">&lt;=</option>' + '              <option value=">">&gt;</option>' + '              <option value=">=">&gt;=</option>' + '            </select>' + '          </div>' + '          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >' + '            <input type="text" class="value" placeholder="value..." id="filterValue" />' + '          </div>' + '        </td>' + '      </tr>' + '      <tr>' + '        <th>' + Object(i18n["c" /* translate */])('transformWizardSortBy') + '</th>' + '        <td class="jsoneditor-jmespath-filter">' + '          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">' + '            <select id="sortField">' + '            </select>' + '          </div>' + '          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >' + '            <select id="sortOrder">' + '              <option value="asc">Ascending</option>' + '              <option value="desc">Descending</option>' + '            </select>' + '          </div>' + '        </td>' + '      </tr>' + '      <tr id="selectFieldsPart">' + '        <th>' + Object(i18n["c" /* translate */])('transformWizardSelectFields') + '</th>' + '        <td class="jsoneditor-jmespath-filter">' + '          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>' + '        </td>' + '      </tr>' + '    </tbody>' + '  </table>' + '</div>' + '<div class="jsoneditor-jmespath-label">' + Object(i18n["c" /* translate */])('transformQueryLabel') + ' </div>' + '<div class="jsoneditor-jmespath-block">' + '  <textarea id="query" ' + '            rows="4" ' + '            autocomplete="off" ' + '            autocorrect="off" ' + '            autocapitalize="off" ' + '            spellcheck="false"' + '            title="' + Object(i18n["c" /* translate */])('transformQueryTitle') + '">[*]</textarea>' + '</div>' + '<div class="jsoneditor-jmespath-label">' + Object(i18n["c" /* translate */])('transformPreviewLabel') + ' </div>' + '<div class="jsoneditor-jmespath-block">' + '  <textarea id="preview" ' + '      class="jsoneditor-transform-preview"' + '      readonly> </textarea>' + '</div>' + '<div class="jsoneditor-jmespath-block jsoneditor-modal-actions">' + '  <input type="submit" id="ok" value="' + Object(i18n["c" /* translate */])('ok') + '" autofocus />' + '</div>' + '</div>';
                    picoModal_default()({
                        parent: container,
                        content: content,
                        overlayClass: 'jsoneditor-modal-overlay',
                        overlayStyles: {
                            backgroundColor: 'rgb(1,1,1)',
                            opacity: 0.3
                        },
                        modalClass: 'jsoneditor-modal jsoneditor-modal-transform',
                        focus: false
                    }).afterCreate(function (modal) {
                        var elem = modal.modalElem();
                        var wizard = elem.querySelector('#wizard');
                        var ok = elem.querySelector('#ok');
                        var filterField = elem.querySelector('#filterField');
                        var filterRelation = elem.querySelector('#filterRelation');
                        var filterValue = elem.querySelector('#filterValue');
                        var sortField = elem.querySelector('#sortField');
                        var sortOrder = elem.querySelector('#sortOrder');
                        var selectFields = elem.querySelector('#selectFields');
                        var query = elem.querySelector('#query');
                        var preview = elem.querySelector('#preview');

                        if (!Array.isArray(value)) {
                            wizard.style.fontStyle = 'italic';
                            wizard.innerHTML = '(wizard not available for objects, only for arrays)';
                        }

                        var sortablePaths = Object(util["getChildPaths"])(json);
                        sortablePaths.forEach(function (path) {
                            var formattedPath = preprocessPath(path);
                            var filterOption = document.createElement('option');
                            filterOption.text = formattedPath;
                            filterOption.value = formattedPath;
                            filterField.appendChild(filterOption);
                            var sortOption = document.createElement('option');
                            sortOption.text = formattedPath;
                            sortOption.value = formattedPath;
                            sortField.appendChild(sortOption);
                        });
                        var selectablePaths = Object(util["getChildPaths"])(json, true).filter(function (path) {
                            return path !== '';
                        });

                        if (selectablePaths.length > 0) {
                            selectablePaths.forEach(function (path) {
                                var formattedPath = preprocessPath(path);
                                var option = document.createElement('option');
                                option.text = formattedPath;
                                option.value = formattedPath;
                                selectFields.appendChild(option);
                            });
                        } else {
                            var selectFieldsPart = elem.querySelector('#selectFieldsPart');

                            if (selectFieldsPart) {
                                selectFieldsPart.style.display = 'none';
                            }
                        }

                        var selectrFilterField = new selectr_default.a(filterField, {
                            defaultSelected: false,
                            clearable: true,
                            allowDeselect: true,
                            placeholder: 'field...'
                        });
                        var selectrFilterRelation = new selectr_default.a(filterRelation, {
                            defaultSelected: false,
                            clearable: true,
                            allowDeselect: true,
                            placeholder: 'compare...'
                        });
                        var selectrSortField = new selectr_default.a(sortField, {
                            defaultSelected: false,
                            clearable: true,
                            allowDeselect: true,
                            placeholder: 'field...'
                        });
                        var selectrSortOrder = new selectr_default.a(sortOrder, {
                            defaultSelected: false,
                            clearable: true,
                            allowDeselect: true,
                            placeholder: 'order...'
                        });
                        var selectrSelectFields = new selectr_default.a(selectFields, {
                            multiple: true,
                            clearable: true,
                            defaultSelected: false,
                            placeholder: 'select fields...'
                        });
                        selectrFilterField.on('selectr.change', generateQueryFromWizard);
                        selectrFilterRelation.on('selectr.change', generateQueryFromWizard);
                        filterValue.oninput = generateQueryFromWizard;
                        selectrSortField.on('selectr.change', generateQueryFromWizard);
                        selectrSortOrder.on('selectr.change', generateQueryFromWizard);
                        selectrSelectFields.on('selectr.change', generateQueryFromWizard);

                        elem.querySelector('.pico-modal-contents').onclick = function (event) {
                            // prevent the first clear button (in any select box) from getting
                            // focus when clicking anywhere in the modal. Only allow clicking links.
                            if (event.target.nodeName !== 'A') {
                                event.preventDefault();
                            }
                        };

                        function preprocessPath(path) {
                            return path === '' ? '@' : path[0] === '.' ? path.slice(1) : path;
                        }

                        function updatePreview() {
                            try {
                                var transformed = executeQuery(value, query.value);
                                preview.className = 'jsoneditor-transform-preview';
                                preview.value = stringifyPartial(transformed, 2, constants["b" /* MAX_PREVIEW_CHARACTERS */]);
                                ok.disabled = false;
                            } catch (err) {
                                preview.className = 'jsoneditor-transform-preview jsoneditor-error';
                                preview.value = err.toString();
                                ok.disabled = true;
                            }
                        }

                        var debouncedUpdatePreview = Object(util["debounce"])(updatePreview, 300);

                        function tryCreateQuery(json, queryOptions) {
                            try {
                                query.value = createQuery(json, queryOptions);
                                ok.disabled = false;
                                debouncedUpdatePreview();
                            } catch (err) {
                                var message = 'Error: an error happened when executing "createQuery": ' + (err.message || err.toString());
                                query.value = '';
                                ok.disabled = true;
                                preview.className = 'jsoneditor-transform-preview jsoneditor-error';
                                preview.value = message;
                            }
                        }

                        function generateQueryFromWizard() {
                            var queryOptions = {};

                            if (filterField.value && filterRelation.value && filterValue.value) {
                                queryOptions.filter = {
                                    field: filterField.value,
                                    relation: filterRelation.value,
                                    value: filterValue.value
                                };
                            }

                            if (sortField.value && sortOrder.value) {
                                queryOptions.sort = {
                                    field: sortField.value,
                                    direction: sortOrder.value
                                };
                            }

                            if (selectFields.value) {
                                var fields = [];

                                for (var i = 0; i < selectFields.options.length; i++) {
                                    if (selectFields.options[i].selected) {
                                        var selectedField = selectFields.options[i].value;
                                        fields.push(selectedField);
                                    }
                                }

                                queryOptions.projection = {
                                    fields: fields
                                };
                            }

                            tryCreateQuery(json, queryOptions);
                        }

                        query.oninput = debouncedUpdatePreview;

                        ok.onclick = function (event) {
                            event.preventDefault();
                            event.stopPropagation();
                            modal.close();
                            onTransform(query.value);
                        }; // initialize with empty query


                        tryCreateQuery(json, {});
                        setTimeout(function () {
                            query.select();
                            query.focus();
                            query.selectionStart = 3;
                            query.selectionEnd = 3;
                        });
                    }).afterClose(function (modal) {
                        modal.destroy();
                    }).show();
                }

                /***/
            }),
            /* 7 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                module.exports = {
                    copy: copy,
                    checkDataType: checkDataType,
                    checkDataTypes: checkDataTypes,
                    coerceToTypes: coerceToTypes,
                    toHash: toHash,
                    getProperty: getProperty,
                    escapeQuotes: escapeQuotes,
                    equal: __webpack_require__(18),
                    ucs2length: __webpack_require__(47),
                    varOccurences: varOccurences,
                    varReplace: varReplace,
                    cleanUpCode: cleanUpCode,
                    finalCleanUpCode: finalCleanUpCode,
                    schemaHasRules: schemaHasRules,
                    schemaHasRulesExcept: schemaHasRulesExcept,
                    schemaUnknownRules: schemaUnknownRules,
                    toQuotedString: toQuotedString,
                    getPathExpr: getPathExpr,
                    getPath: getPath,
                    getData: getData,
                    unescapeFragment: unescapeFragment,
                    unescapeJsonPointer: unescapeJsonPointer,
                    escapeFragment: escapeFragment,
                    escapeJsonPointer: escapeJsonPointer
                };


                function copy(o, to) {
                    to = to || {};
                    for (var key in o) to[key] = o[key];
                    return to;
                }


                function checkDataType(dataType, data, negate) {
                    var EQUAL = negate ? ' !== ' : ' === '
                        , AND = negate ? ' || ' : ' && '
                        , OK = negate ? '!' : ''
                        , NOT = negate ? '' : '!';
                    switch (dataType) {
                        case 'null':
                            return data + EQUAL + 'null';
                        case 'array':
                            return OK + 'Array.isArray(' + data + ')';
                        case 'object':
                            return '(' + OK + data + AND +
                                'typeof ' + data + EQUAL + '"object"' + AND +
                                NOT + 'Array.isArray(' + data + '))';
                        case 'integer':
                            return '(typeof ' + data + EQUAL + '"number"' + AND +
                                NOT + '(' + data + ' % 1)' +
                                AND + data + EQUAL + data + ')';
                        default:
                            return 'typeof ' + data + EQUAL + '"' + dataType + '"';
                    }
                }


                function checkDataTypes(dataTypes, data) {
                    switch (dataTypes.length) {
                        case 1:
                            return checkDataType(dataTypes[0], data, true);
                        default:
                            var code = '';
                            var types = toHash(dataTypes);
                            if (types.array && types.object) {
                                code = types.null ? '(' : '(!' + data + ' || ';
                                code += 'typeof ' + data + ' !== "object")';
                                delete types.null;
                                delete types.array;
                                delete types.object;
                            }
                            if (types.number) delete types.integer;
                            for (var t in types)
                                code += (code ? ' && ' : '') + checkDataType(t, data, true);

                            return code;
                    }
                }


                var COERCE_TO_TYPES = toHash(['string', 'number', 'integer', 'boolean', 'null']);

                function coerceToTypes(optionCoerceTypes, dataTypes) {
                    if (Array.isArray(dataTypes)) {
                        var types = [];
                        for (var i = 0; i < dataTypes.length; i++) {
                            var t = dataTypes[i];
                            if (COERCE_TO_TYPES[t]) types[types.length] = t;
                            else if (optionCoerceTypes === 'array' && t === 'array') types[types.length] = t;
                        }
                        if (types.length) return types;
                    } else if (COERCE_TO_TYPES[dataTypes]) {
                        return [dataTypes];
                    } else if (optionCoerceTypes === 'array' && dataTypes === 'array') {
                        return ['array'];
                    }
                }


                function toHash(arr) {
                    var hash = {};
                    for (var i = 0; i < arr.length; i++) hash[arr[i]] = true;
                    return hash;
                }


                var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
                var SINGLE_QUOTE = /'|\\/g;

                function getProperty(key) {
                    return typeof key == 'number'
                        ? '[' + key + ']'
                        : IDENTIFIER.test(key)
                            ? '.' + key
                            : "['" + escapeQuotes(key) + "']";
                }


                function escapeQuotes(str) {
                    return str.replace(SINGLE_QUOTE, '\\$&')
                        .replace(/\n/g, '\\n')
                        .replace(/\r/g, '\\r')
                        .replace(/\f/g, '\\f')
                        .replace(/\t/g, '\\t');
                }


                function varOccurences(str, dataVar) {
                    dataVar += '[^0-9]';
                    var matches = str.match(new RegExp(dataVar, 'g'));
                    return matches ? matches.length : 0;
                }


                function varReplace(str, dataVar, expr) {
                    dataVar += '([^0-9])';
                    expr = expr.replace(/\$/g, '$$$$');
                    return str.replace(new RegExp(dataVar, 'g'), expr + '$1');
                }


                var EMPTY_ELSE = /else\s*{\s*}/g
                    , EMPTY_IF_NO_ELSE = /if\s*\([^)]+\)\s*\{\s*\}(?!\s*else)/g
                    , EMPTY_IF_WITH_ELSE = /if\s*\(([^)]+)\)\s*\{\s*\}\s*else(?!\s*if)/g;

                function cleanUpCode(out) {
                    return out.replace(EMPTY_ELSE, '')
                        .replace(EMPTY_IF_NO_ELSE, '')
                        .replace(EMPTY_IF_WITH_ELSE, 'if (!($1))');
                }


                var ERRORS_REGEXP = /[^v.]errors/g
                    , REMOVE_ERRORS = /var errors = 0;|var vErrors = null;|validate.errors = vErrors;/g
                    , REMOVE_ERRORS_ASYNC = /var errors = 0;|var vErrors = null;/g
                    , RETURN_VALID = 'return errors === 0;'
                    , RETURN_TRUE = 'validate.errors = null; return true;'
                    , RETURN_ASYNC = /if \(errors === 0\) return data;\s*else throw new ValidationError\(vErrors\);/
                    , RETURN_DATA_ASYNC = 'return data;'
                    , ROOTDATA_REGEXP = /[^A-Za-z_$]rootData[^A-Za-z0-9_$]/g
                    , REMOVE_ROOTDATA = /if \(rootData === undefined\) rootData = data;/;

                function finalCleanUpCode(out, async) {
                    var matches = out.match(ERRORS_REGEXP);
                    if (matches && matches.length == 2) {
                        out = async
                            ? out.replace(REMOVE_ERRORS_ASYNC, '')
                                .replace(RETURN_ASYNC, RETURN_DATA_ASYNC)
                            : out.replace(REMOVE_ERRORS, '')
                                .replace(RETURN_VALID, RETURN_TRUE);
                    }

                    matches = out.match(ROOTDATA_REGEXP);
                    if (!matches || matches.length !== 3) return out;
                    return out.replace(REMOVE_ROOTDATA, '');
                }


                function schemaHasRules(schema, rules) {
                    if (typeof schema == 'boolean') return !schema;
                    for (var key in schema) if (rules[key]) return true;
                }


                function schemaHasRulesExcept(schema, rules, exceptKeyword) {
                    if (typeof schema == 'boolean') return !schema && exceptKeyword != 'not';
                    for (var key in schema) if (key != exceptKeyword && rules[key]) return true;
                }


                function schemaUnknownRules(schema, rules) {
                    if (typeof schema == 'boolean') return;
                    for (var key in schema) if (!rules[key]) return key;
                }


                function toQuotedString(str) {
                    return '\'' + escapeQuotes(str) + '\'';
                }


                function getPathExpr(currentPath, expr, jsonPointers, isNumber) {
                    var path = jsonPointers // false by default
                        ? '\'/\' + ' + expr + (isNumber ? '' : '.replace(/~/g, \'~0\').replace(/\\//g, \'~1\')')
                        : (isNumber ? '\'[\' + ' + expr + ' + \']\'' : '\'[\\\'\' + ' + expr + ' + \'\\\']\'');
                    return joinPaths(currentPath, path);
                }


                function getPath(currentPath, prop, jsonPointers) {
                    var path = jsonPointers // false by default
                        ? toQuotedString('/' + escapeJsonPointer(prop))
                        : toQuotedString(getProperty(prop));
                    return joinPaths(currentPath, path);
                }


                var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
                var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;

                function getData($data, lvl, paths) {
                    var up, jsonPointer, data, matches;
                    if ($data === '') return 'rootData';
                    if ($data[0] == '/') {
                        if (!JSON_POINTER.test($data)) throw new Error('Invalid JSON-pointer: ' + $data);
                        jsonPointer = $data;
                        data = 'rootData';
                    } else {
                        matches = $data.match(RELATIVE_JSON_POINTER);
                        if (!matches) throw new Error('Invalid JSON-pointer: ' + $data);
                        up = +matches[1];
                        jsonPointer = matches[2];
                        if (jsonPointer == '#') {
                            if (up >= lvl) throw new Error('Cannot access property/index ' + up + ' levels up, current level is ' + lvl);
                            return paths[lvl - up];
                        }

                        if (up > lvl) throw new Error('Cannot access data ' + up + ' levels up, current level is ' + lvl);
                        data = 'data' + ((lvl - up) || '');
                        if (!jsonPointer) return data;
                    }

                    var expr = data;
                    var segments = jsonPointer.split('/');
                    for (var i = 0; i < segments.length; i++) {
                        var segment = segments[i];
                        if (segment) {
                            data += getProperty(unescapeJsonPointer(segment));
                            expr += ' && ' + data;
                        }
                    }
                    return expr;
                }


                function joinPaths(a, b) {
                    if (a == '""') return b;
                    return (a + ' + ' + b).replace(/' \+ '/g, '');
                }


                function unescapeFragment(str) {
                    return unescapeJsonPointer(decodeURIComponent(str));
                }


                function escapeFragment(str) {
                    return encodeURIComponent(escapeJsonPointer(str));
                }


                function escapeJsonPointer(str) {
                    return str.replace(/~/g, '~0').replace(/\//g, '~1');
                }


                function unescapeJsonPointer(str) {
                    return str.replace(/~1/g, '/').replace(/~0/g, '~');
                }


                /***/
            }),
            /* 8 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return ModeSwitcher;
                });
                /* harmony import */
                var _ContextMenu__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
                /* harmony import */
                var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);


                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }


                /**
                 * Create a select box to be used in the editor menu's, which allows to switch mode
                 * @param {HTMLElement} container
                 * @param {String[]} modes  Available modes: 'code', 'form', 'text', 'tree', 'view', 'preview'
                 * @param {String} current  Available modes: 'code', 'form', 'text', 'tree', 'view', 'preview'
                 * @param {function(mode: string)} onSwitch  Callback invoked on switch
                 * @constructor
                 */

                var ModeSwitcher = /*#__PURE__*/function () {
                    function ModeSwitcher(container, modes, current, onSwitch) {
                        _classCallCheck(this, ModeSwitcher);

                        // available modes
                        var availableModes = {
                            code: {
                                text: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeCodeText'),
                                title: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeCodeTitle'),
                                click: function click() {
                                    onSwitch('code');
                                }
                            },
                            form: {
                                text: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeFormText'),
                                title: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeFormTitle'),
                                click: function click() {
                                    onSwitch('form');
                                }
                            },
                            text: {
                                text: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeTextText'),
                                title: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeTextTitle'),
                                click: function click() {
                                    onSwitch('text');
                                }
                            },
                            tree: {
                                text: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeTreeText'),
                                title: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeTreeTitle'),
                                click: function click() {
                                    onSwitch('tree');
                                }
                            },
                            view: {
                                text: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeViewText'),
                                title: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeViewTitle'),
                                click: function click() {
                                    onSwitch('view');
                                }
                            },
                            preview: {
                                text: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modePreviewText'),
                                title: Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modePreviewTitle'),
                                click: function click() {
                                    onSwitch('preview');
                                }
                            }
                        }; // list the selected modes

                        var items = [];

                        for (var i = 0; i < modes.length; i++) {
                            var mode = modes[i];
                            var item = availableModes[mode];

                            if (!item) {
                                throw new Error('Unknown mode "' + mode + '"');
                            }

                            item.className = 'jsoneditor-type-modes' + (current === mode ? ' jsoneditor-selected' : '');
                            items.push(item);
                        } // retrieve the title of current mode


                        var currentMode = availableModes[current];

                        if (!currentMode) {
                            throw new Error('Unknown mode "' + current + '"');
                        }

                        var currentTitle = currentMode.text; // create the html element

                        var box = document.createElement('button');
                        box.type = 'button';
                        box.className = 'jsoneditor-modes jsoneditor-separator';
                        box.innerHTML = currentTitle + ' &#x25BE;';
                        box.title = Object(_i18n__WEBPACK_IMPORTED_MODULE_1__[/* translate */ "c"])('modeEditorTitle');

                        box.onclick = function () {
                            var menu = new _ContextMenu__WEBPACK_IMPORTED_MODULE_0__[/* ContextMenu */ "a"](items);
                            menu.show(box, container);
                        };

                        var frame = document.createElement('div');
                        frame.className = 'jsoneditor-modes';
                        frame.style.position = 'relative';
                        frame.appendChild(box);
                        container.appendChild(frame);
                        this.dom = {
                            container: container,
                            box: box,
                            frame: frame
                        };
                    }

                    /**
                     * Set focus to switcher
                     */


                    _createClass(ModeSwitcher, [{
                        key: "focus",
                        value: function focus() {
                            this.dom.box.focus();
                        }
                        /**
                         * Destroy the ModeSwitcher, remove from DOM
                         */

                    }, {
                        key: "destroy",
                        value: function destroy() {
                            if (this.dom && this.dom.frame && this.dom.frame.parentNode) {
                                this.dom.frame.parentNode.removeChild(this.dom.frame);
                            }

                            this.dom = null;
                        }
                    }]);

                    return ModeSwitcher;
                }();

                /***/
            }),
            /* 9 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return FocusTracker;
                });

                /**
                 * @constructor FocusTracker
                 * A custom focus tracker for a DOM element with complex internal DOM structure
                 * @param  {[Object]} config    A set of configurations for the FocusTracker
                 *                {DOM Object} target *    The DOM object to track (required)
                 *                {Function}   onFocus     onFocus callback
                 *                {Function}   onBlur      onBlur callback
                 *
                 * @return
                 */

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                var FocusTracker = /*#__PURE__*/function () {
                    function FocusTracker(config) {
                        _classCallCheck(this, FocusTracker);

                        this.target = config.target || null;

                        if (!this.target) {
                            throw new Error('FocusTracker constructor called without a "target" to track.');
                        }

                        this.onFocus = typeof config.onFocus === 'function' ? config.onFocus : null;
                        this.onBlur = typeof config.onBlur === 'function' ? config.onBlur : null;
                        this._onClick = this._onEvent.bind(this);

                        this._onKeyUp = function (event) {
                            if (event.which === 9 || event.keyCode === 9) {
                                this._onEvent(event);
                            }
                        }.bind(this);

                        this.focusFlag = false;
                        this.firstEventFlag = true;
                        /*
      Adds required (click and keyup) event listeners to the 'document' object
      to track the focus of the given 'target'
     */

                        if (this.onFocus || this.onBlur) {
                            document.addEventListener('click', this._onClick);
                            document.addEventListener('keyup', this._onKeyUp);
                        }
                    }

                    /**
                     * Removes the event listeners on the 'document' object
                     * that were added to track the focus of the given 'target'
                     */


                    _createClass(FocusTracker, [{
                        key: "destroy",
                        value: function destroy() {
                            document.removeEventListener('click', this._onClick);
                            document.removeEventListener('keyup', this._onKeyUp);

                            this._onEvent({
                                target: document.body
                            }); // calling _onEvent with body element in the hope that the FocusTracker is added to an element inside the body tag

                        }
                        /**
                         * Tracks the focus of the target and calls the onFocus and onBlur
                         * event callbacks if available.
                         * @param {Event} [event]  The 'click' or 'keyup' event object,
                         *                          from the respective events set on
                         *              document object
                         * @private
                         */

                    }, {
                        key: "_onEvent",
                        value: function _onEvent(event) {
                            var target = event.target;
                            var focusFlag;

                            if (target === this.target) {
                                focusFlag = true;
                            } else if (this.target.contains(target) || this.target.contains(document.activeElement)) {
                                focusFlag = true;
                            } else {
                                focusFlag = false;
                            }

                            if (focusFlag) {
                                if (!this.focusFlag) {
                                    // trigger the onFocus callback
                                    if (this.onFocus) {
                                        this.onFocus({
                                            type: 'focus',
                                            target: this.target
                                        });
                                    }

                                    this.focusFlag = true;
                                }
                            } else {
                                if (this.focusFlag || this.firstEventFlag) {
                                    // trigger the onBlur callback
                                    if (this.onBlur) {
                                        this.onBlur({
                                            type: 'blur',
                                            target: this.target
                                        });
                                    }

                                    this.focusFlag = false;
                                    /*
            When switching from one mode to another in the editor, the FocusTracker gets recreated.
            At that time, this.focusFlag will be init to 'false' and will fail the above if condition, when blur occurs
            this.firstEventFlag is added to overcome that issue
           */

                                    if (this.firstEventFlag) {
                                        this.firstEventFlag = false;
                                    }
                                }
                            }
                        }
                    }]);

                    return FocusTracker;
                }();

                /***/
            }),
            /* 10 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";
                /*!
 * Selectr 2.4.0
 * https://github.com/Mobius1/Selectr
 *
 * Released under the MIT license
 */

                /**
                 * Default configuration options
                 * @type {Object}
                 */

                var defaultConfig = {
                    /**
                     * Emulates browser behaviour by selecting the first option by default
                     * @type {Boolean}
                     */
                    defaultSelected: true,

                    /**
                     * Sets the width of the container
                     * @type {String}
                     */
                    width: "auto",

                    /**
                     * Enables/ disables the container
                     * @type {Boolean}
                     */
                    disabled: false,

                    /**
                     * Enables / disables the search function
                     * @type {Boolean}
                     */
                    searchable: true,

                    /**
                     * Enable disable the clear button
                     * @type {Boolean}
                     */
                    clearable: false,

                    /**
                     * Sort the tags / multiselect options
                     * @type {Boolean}
                     */
                    sortSelected: false,

                    /**
                     * Allow deselecting of select-one options
                     * @type {Boolean}
                     */
                    allowDeselect: false,

                    /**
                     * Close the dropdown when scrolling (@AlexanderReiswich, #11)
                     * @type {Boolean}
                     */
                    closeOnScroll: false,

                    /**
                     * Allow the use of the native dropdown (@jonnyscholes, #14)
                     * @type {Boolean}
                     */
                    nativeDropdown: false,

                    /**
                     * Set the main placeholder
                     * @type {String}
                     */
                    placeholder: "Select an option...",

                    /**
                     * Allow the tagging feature
                     * @type {Boolean}
                     */
                    taggable: false,

                    /**
                     * Set the tag input placeholder (@labikmartin, #21, #22)
                     * @type {String}
                     */
                    tagPlaceholder: "Enter a tag..."
                };
                /**
                 * Event Emitter
                 */

                var Events = function Events() {
                };
                /**
                 * Event Prototype
                 * @type {Object}
                 */


                Events.prototype = {
                    /**
                     * Add custom event listener
                     * @param  {String} event Event type
                     * @param  {Function} func   Callback
                     * @return {Void}
                     */
                    on: function on(event, func) {
                        this._events = this._events || {};
                        this._events[event] = this._events[event] || [];

                        this._events[event].push(func);
                    },

                    /**
                     * Remove custom event listener
                     * @param  {String} event Event type
                     * @param  {Function} func   Callback
                     * @return {Void}
                     */
                    off: function off(event, func) {
                        this._events = this._events || {};
                        if (event in this._events === false) return;

                        this._events[event].splice(this._events[event].indexOf(func), 1);
                    },

                    /**
                     * Fire a custom event
                     * @param  {String} event Event type
                     * @return {Void}
                     */
                    emit: function emit(event
                                        /* , args... */
                    ) {
                        this._events = this._events || {};
                        if (event in this._events === false) return;

                        for (var i = 0; i < this._events[event].length; i++) {
                            this._events[event][i].apply(this, Array.prototype.slice.call(arguments, 1));
                        }
                    }
                };
                /**
                 * Event mixin
                 * @param  {Object} obj
                 * @return {Object}
                 */

                Events.mixin = function (obj) {
                    var props = ['on', 'off', 'emit'];

                    for (var i = 0; i < props.length; i++) {
                        if (typeof obj === 'function') {
                            obj.prototype[props[i]] = Events.prototype[props[i]];
                        } else {
                            obj[props[i]] = Events.prototype[props[i]];
                        }
                    }

                    return obj;
                };
                /**
                 * Helpers
                 * @type {Object}
                 */


                var util = {
                    extend: function extend(src, props) {
                        props = props || {};
                        var p;

                        for (p in src) {
                            if (src.hasOwnProperty(p)) {
                                if (!props.hasOwnProperty(p)) {
                                    props[p] = src[p];
                                }
                            }
                        }

                        return props;
                    },
                    each: function each(a, b, c) {
                        if ("[object Object]" === Object.prototype.toString.call(a)) {
                            for (var d in a) {
                                if (Object.prototype.hasOwnProperty.call(a, d)) {
                                    b.call(c, d, a[d], a);
                                }
                            }
                        } else {
                            for (var e = 0, f = a.length; e < f; e++) {
                                b.call(c, e, a[e], a);
                            }
                        }
                    },
                    createElement: function createElement(e, a) {
                        var d = document,
                            el = d.createElement(e);

                        if (a && "[object Object]" === Object.prototype.toString.call(a)) {
                            var i;

                            for (i in a) {
                                if (i in el) el[i] = a[i]; else if ("html" === i) el.innerHTML = a[i]; else if ("text" === i) {
                                    var t = d.createTextNode(a[i]);
                                    el.appendChild(t);
                                } else el.setAttribute(i, a[i]);
                            }
                        }

                        return el;
                    },
                    hasClass: function hasClass(a, b) {
                        if (a) return a.classList ? a.classList.contains(b) : !!a.className && !!a.className.match(new RegExp("(\\s|^)" + b + "(\\s|$)"));
                    },
                    addClass: function addClass(a, b) {
                        if (!util.hasClass(a, b)) {
                            if (a.classList) {
                                a.classList.add(b);
                            } else {
                                a.className = a.className.trim() + " " + b;
                            }
                        }
                    },
                    removeClass: function removeClass(a, b) {
                        if (util.hasClass(a, b)) {
                            if (a.classList) {
                                a.classList.remove(b);
                            } else {
                                a.className = a.className.replace(new RegExp("(^|\\s)" + b.split(" ").join("|") + "(\\s|$)", "gi"), " ");
                            }
                        }
                    },
                    closest: function closest(el, fn) {
                        return el && el !== document.body && (fn(el) ? el : util.closest(el.parentNode, fn));
                    },
                    isInt: function isInt(val) {
                        return typeof val === 'number' && isFinite(val) && Math.floor(val) === val;
                    },
                    debounce: function debounce(a, b, c) {
                        var d;
                        return function () {
                            var e = this,
                                f = arguments,
                                g = function g() {
                                    d = null;
                                    if (!c) a.apply(e, f);
                                },
                                h = c && !d;

                            clearTimeout(d);
                            d = setTimeout(g, b);

                            if (h) {
                                a.apply(e, f);
                            }
                        };
                    },
                    rect: function rect(el, abs) {
                        var w = window;
                        var r = el.getBoundingClientRect();
                        var x = abs ? w.pageXOffset : 0;
                        var y = abs ? w.pageYOffset : 0;
                        return {
                            bottom: r.bottom + y,
                            height: r.height,
                            left: r.left + x,
                            right: r.right + x,
                            top: r.top + y,
                            width: r.width
                        };
                    },
                    includes: function includes(a, b) {
                        return a.indexOf(b) > -1;
                    },
                    truncate: function truncate(el) {
                        while (el.firstChild) {
                            el.removeChild(el.firstChild);
                        }
                    }
                };

                function isset(obj, prop) {
                    return obj.hasOwnProperty(prop) && (obj[prop] === true || obj[prop].length);
                }

                /**
                 * Append an item to the list
                 * @param  {Object} item
                 * @param  {Object} custom
                 * @return {Void}
                 */


                function appendItem(item, parent, custom) {
                    if (item.parentNode) {
                        if (!item.parentNode.parentNode) {
                            parent.appendChild(item.parentNode);
                        }
                    } else {
                        parent.appendChild(item);
                    }

                    util.removeClass(item, "excluded");

                    if (!custom) {
                        item.innerHTML = item.textContent;
                    }
                }

                /**
                 * Render the item list
                 * @return {Void}
                 */


                var render = function render() {
                    if (this.items.length) {
                        var f = document.createDocumentFragment();

                        if (this.config.pagination) {
                            var pages = this.pages.slice(0, this.pageIndex);
                            util.each(pages, function (i, items) {
                                util.each(items, function (j, item) {
                                    appendItem(item, f, this.customOption);
                                }, this);
                            }, this);
                        } else {
                            util.each(this.items, function (i, item) {
                                appendItem(item, f, this.customOption);
                            }, this);
                        }

                        if (f.childElementCount) {
                            util.removeClass(this.items[this.navIndex], "active");
                            this.navIndex = f.querySelector(".selectr-option").idx;
                            util.addClass(this.items[this.navIndex], "active");
                        }

                        this.tree.appendChild(f);
                    }
                };
                /**
                 * Dismiss / close the dropdown
                 * @param  {obj} e
                 * @return {void}
                 */


                var dismiss = function dismiss(e) {
                    var target = e.target;

                    if (!this.container.contains(target) && (this.opened || util.hasClass(this.container, "notice"))) {
                        this.close();
                    }
                };
                /**
                 * Build a list item from the HTMLOptionElement
                 * @param  {int} i      HTMLOptionElement index
                 * @param  {HTMLOptionElement} option
                 * @param  {bool} group  Has parent optgroup
                 * @return {void}
                 */


                var createItem = function createItem(option, data) {
                    data = data || option;
                    var content = this.customOption ? this.config.renderOption(data) : option.textContent;
                    var opt = util.createElement("li", {
                        "class": "selectr-option",
                        html: content,
                        role: "treeitem",
                        "aria-selected": false
                    });
                    opt.idx = option.idx;
                    this.items.push(opt);

                    if (option.defaultSelected) {
                        this.defaultSelected.push(option.idx);
                    }

                    if (option.disabled) {
                        opt.disabled = true;
                        util.addClass(opt, "disabled");
                    }

                    return opt;
                };
                /**
                 * Build the container
                 * @return {Void}
                 */


                var build = function build() {
                    this.requiresPagination = this.config.pagination && this.config.pagination > 0; // Set width

                    if (isset(this.config, "width")) {
                        if (util.isInt(this.config.width)) {
                            this.width = this.config.width + "px";
                        } else {
                            if (this.config.width === "auto") {
                                this.width = "100%";
                            } else if (util.includes(this.config.width, "%")) {
                                this.width = this.config.width;
                            }
                        }
                    }

                    this.container = util.createElement("div", {
                        "class": "selectr-container"
                    }); // Custom className

                    if (this.config.customClass) {
                        util.addClass(this.container, this.config.customClass);
                    } // Mobile device


                    if (this.mobileDevice) {
                        util.addClass(this.container, "selectr-mobile");
                    } else {
                        util.addClass(this.container, "selectr-desktop");
                    } // Hide the HTMLSelectElement and prevent focus


                    this.el.tabIndex = -1; // Native dropdown

                    if (this.config.nativeDropdown || this.mobileDevice) {
                        util.addClass(this.el, "selectr-visible");
                    } else {
                        util.addClass(this.el, "selectr-hidden");
                    }

                    this.selected = util.createElement("div", {
                        "class": "selectr-selected",
                        disabled: this.disabled,
                        tabIndex: 1,
                        // enable tabIndex (#9)
                        "aria-expanded": false
                    });
                    this.label = util.createElement(this.el.multiple ? "ul" : "span", {
                        "class": "selectr-label"
                    });
                    var dropdown = util.createElement("div", {
                        "class": "selectr-options-container"
                    });
                    this.tree = util.createElement("ul", {
                        "class": "selectr-options",
                        role: "tree",
                        "aria-hidden": true,
                        "aria-expanded": false
                    });
                    this.notice = util.createElement("div", {
                        "class": "selectr-notice"
                    });
                    this.el.setAttribute("aria-hidden", true);

                    if (this.disabled) {
                        this.el.disabled = true;
                    }

                    if (this.el.multiple) {
                        util.addClass(this.label, "selectr-tags");
                        util.addClass(this.container, "multiple"); // Collection of tags

                        this.tags = []; // Collection of selected values

                        this.selectedValues = this.getSelectedProperties('value'); // Collection of selected indexes

                        this.selectedIndexes = this.getSelectedProperties('idx');
                    }

                    this.selected.appendChild(this.label);

                    if (this.config.clearable) {
                        this.selectClear = util.createElement("button", {
                            "class": "selectr-clear",
                            type: "button"
                        });
                        this.container.appendChild(this.selectClear);
                        util.addClass(this.container, "clearable");
                    }

                    if (this.config.taggable) {
                        var li = util.createElement('li', {
                            "class": 'input-tag'
                        });
                        this.input = util.createElement("input", {
                            "class": "selectr-tag-input",
                            placeholder: this.config.tagPlaceholder,
                            tagIndex: 0,
                            autocomplete: "off",
                            autocorrect: "off",
                            autocapitalize: "off",
                            spellcheck: "false",
                            role: "textbox",
                            type: "search"
                        });
                        li.appendChild(this.input);
                        this.label.appendChild(li);
                        util.addClass(this.container, "taggable");
                        this.tagSeperators = [","];

                        if (this.config.tagSeperators) {
                            this.tagSeperators = this.tagSeperators.concat(this.config.tagSeperators);
                        }
                    }

                    if (this.config.searchable) {
                        this.input = util.createElement("input", {
                            "class": "selectr-input",
                            tagIndex: -1,
                            autocomplete: "off",
                            autocorrect: "off",
                            autocapitalize: "off",
                            spellcheck: "false",
                            role: "textbox",
                            type: "search"
                        });
                        this.inputClear = util.createElement("button", {
                            "class": "selectr-input-clear",
                            type: "button"
                        });
                        this.inputContainer = util.createElement("div", {
                            "class": "selectr-input-container"
                        });
                        this.inputContainer.appendChild(this.input);
                        this.inputContainer.appendChild(this.inputClear);
                        dropdown.appendChild(this.inputContainer);
                    }

                    dropdown.appendChild(this.notice);
                    dropdown.appendChild(this.tree); // List of items for the dropdown

                    this.items = []; // Establish options

                    this.options = []; // Check for options in the element

                    if (this.el.options.length) {
                        this.options = [].slice.call(this.el.options);
                    } // Element may have optgroups so
                    // iterate element.children instead of element.options


                    var group = false,
                        j = 0;

                    if (this.el.children.length) {
                        util.each(this.el.children, function (i, element) {
                            if (element.nodeName === "OPTGROUP") {
                                group = util.createElement("ul", {
                                    "class": "selectr-optgroup",
                                    role: "group",
                                    html: "<li class='selectr-optgroup--label'>" + element.label + "</li>"
                                });
                                util.each(element.children, function (x, el) {
                                    el.idx = j;
                                    group.appendChild(createItem.call(this, el, group));
                                    j++;
                                }, this);
                            } else {
                                element.idx = j;
                                createItem.call(this, element);
                                j++;
                            }
                        }, this);
                    } // Options defined by the data option


                    if (this.config.data && Array.isArray(this.config.data)) {
                        this.data = [];
                        var optgroup = false,
                            option;
                        group = false;
                        j = 0;
                        util.each(this.config.data, function (i, opt) {
                            // Check for group options
                            if (isset(opt, "children")) {
                                optgroup = util.createElement("optgroup", {
                                    label: opt.text
                                });
                                group = util.createElement("ul", {
                                    "class": "selectr-optgroup",
                                    role: "group",
                                    html: "<li class='selectr-optgroup--label'>" + opt.text + "</li>"
                                });
                                util.each(opt.children, function (x, data) {
                                    option = new Option(data.text, data.value, false, data.hasOwnProperty("selected") && data.selected === true);
                                    option.disabled = isset(data, "disabled");
                                    this.options.push(option);
                                    optgroup.appendChild(option);
                                    option.idx = j;
                                    group.appendChild(createItem.call(this, option, data));
                                    this.data[j] = data;
                                    j++;
                                }, this);
                            } else {
                                option = new Option(opt.text, opt.value, false, opt.hasOwnProperty("selected") && opt.selected === true);
                                option.disabled = isset(opt, "disabled");
                                this.options.push(option);
                                option.idx = j;
                                createItem.call(this, option, opt);
                                this.data[j] = opt;
                                j++;
                            }
                        }, this);
                    }

                    this.setSelected(true);
                    var first;
                    this.navIndex = 0;

                    for (var i = 0; i < this.items.length; i++) {
                        first = this.items[i];

                        if (!util.hasClass(first, "disabled")) {
                            util.addClass(first, "active");
                            this.navIndex = i;
                            break;
                        }
                    } // Check for pagination / infinite scroll


                    if (this.requiresPagination) {
                        this.pageIndex = 1; // Create the pages

                        this.paginate();
                    }

                    this.container.appendChild(this.selected);
                    this.container.appendChild(dropdown);
                    this.placeEl = util.createElement("div", {
                        "class": "selectr-placeholder"
                    }); // Set the placeholder

                    this.setPlaceholder();
                    this.selected.appendChild(this.placeEl); // Disable if required

                    if (this.disabled) {
                        this.disable();
                    }

                    this.el.parentNode.insertBefore(this.container, this.el);
                    this.container.appendChild(this.el);
                };
                /**
                 * Navigate through the dropdown
                 * @param  {obj} e
                 * @return {void}
                 */


                var navigate = function navigate(e) {
                    e = e || window.event; // Filter out the keys we don"t want

                    if (!this.items.length || !this.opened || !util.includes([13, 38, 40], e.which)) {
                        this.navigating = false;
                        return;
                    }

                    e.preventDefault();

                    if (e.which === 13) {
                        if (this.config.taggable && this.input.value.length > 0) {
                            return false;
                        }

                        return this.change(this.navIndex);
                    }

                    var direction,
                        prevEl = this.items[this.navIndex];

                    switch (e.which) {
                        case 38:
                            direction = 0;

                            if (this.navIndex > 0) {
                                this.navIndex--;
                            }

                            break;

                        case 40:
                            direction = 1;

                            if (this.navIndex < this.items.length - 1) {
                                this.navIndex++;
                            }

                    }

                    this.navigating = true; // Instead of wasting memory holding a copy of this.items
                    // with disabled / excluded options omitted, skip them instead

                    while (util.hasClass(this.items[this.navIndex], "disabled") || util.hasClass(this.items[this.navIndex], "excluded")) {
                        if (direction) {
                            this.navIndex++;
                        } else {
                            this.navIndex--;
                        }

                        if (this.searching) {
                            if (this.navIndex > this.tree.lastElementChild.idx) {
                                this.navIndex = this.tree.lastElementChild.idx;
                                break;
                            } else if (this.navIndex < this.tree.firstElementChild.idx) {
                                this.navIndex = this.tree.firstElementChild.idx;
                                break;
                            }
                        }
                    } // Autoscroll the dropdown during navigation


                    var r = util.rect(this.items[this.navIndex]);

                    if (!direction) {
                        if (this.navIndex === 0) {
                            this.tree.scrollTop = 0;
                        } else if (r.top - this.optsRect.top < 0) {
                            this.tree.scrollTop = this.tree.scrollTop + (r.top - this.optsRect.top);
                        }
                    } else {
                        if (this.navIndex === 0) {
                            this.tree.scrollTop = 0;
                        } else if (r.top + r.height > this.optsRect.top + this.optsRect.height) {
                            this.tree.scrollTop = this.tree.scrollTop + (r.top + r.height - (this.optsRect.top + this.optsRect.height));
                        } // Load another page if needed


                        if (this.navIndex === this.tree.childElementCount - 1 && this.requiresPagination) {
                            load.call(this);
                        }
                    }

                    if (prevEl) {
                        util.removeClass(prevEl, "active");
                    }

                    util.addClass(this.items[this.navIndex], "active");
                };
                /**
                 * Add a tag
                 * @param  {HTMLElement} item
                 */


                var addTag = function addTag(item) {
                    var that = this,
                        r;
                    var docFrag = document.createDocumentFragment();
                    var option = this.options[item.idx];
                    var data = this.data ? this.data[item.idx] : option;
                    var content = this.customSelected ? this.config.renderSelection(data) : option.textContent;
                    var tag = util.createElement("li", {
                        "class": "selectr-tag",
                        html: content
                    });
                    var btn = util.createElement("button", {
                        "class": "selectr-tag-remove",
                        type: "button"
                    });
                    tag.appendChild(btn); // Set property to check against later

                    tag.idx = item.idx;
                    tag.tag = option.value;
                    this.tags.push(tag);

                    if (this.config.sortSelected) {
                        var tags = this.tags.slice(); // Deal with values that contain numbers

                        r = function r(val, arr) {
                            val.replace(/(\d+)|(\D+)/g, function (that, $1, $2) {
                                arr.push([$1 || Infinity, $2 || ""]);
                            });
                        };

                        tags.sort(function (a, b) {
                            var x = [],
                                y = [],
                                ac,
                                bc;

                            if (that.config.sortSelected === true) {
                                ac = a.tag;
                                bc = b.tag;
                            } else if (that.config.sortSelected === 'text') {
                                ac = a.textContent;
                                bc = b.textContent;
                            }

                            r(ac, x);
                            r(bc, y);

                            while (x.length && y.length) {
                                var ax = x.shift();
                                var by = y.shift();
                                var nn = ax[0] - by[0] || ax[1].localeCompare(by[1]);
                                if (nn) return nn;
                            }

                            return x.length - y.length;
                        });
                        util.each(tags, function (i, tg) {
                            docFrag.appendChild(tg);
                        });
                        this.label.innerHTML = "";
                    } else {
                        docFrag.appendChild(tag);
                    }

                    if (this.config.taggable) {
                        this.label.insertBefore(docFrag, this.input.parentNode);
                    } else {
                        this.label.appendChild(docFrag);
                    }
                };
                /**
                 * Remove a tag
                 * @param  {HTMLElement} item
                 * @return {void}
                 */


                var removeTag = function removeTag(item) {
                    var tag = false;
                    util.each(this.tags, function (i, t) {
                        if (t.idx === item.idx) {
                            tag = t;
                        }
                    }, this);

                    if (tag) {
                        this.label.removeChild(tag);
                        this.tags.splice(this.tags.indexOf(tag), 1);
                    }
                };
                /**
                 * Load the next page of items
                 * @return {void}
                 */


                var load = function load() {
                    var tree = this.tree;
                    var scrollTop = tree.scrollTop;
                    var scrollHeight = tree.scrollHeight;
                    var offsetHeight = tree.offsetHeight;
                    var atBottom = scrollTop >= scrollHeight - offsetHeight;

                    if (atBottom && this.pageIndex < this.pages.length) {
                        var f = document.createDocumentFragment();
                        util.each(this.pages[this.pageIndex], function (i, item) {
                            appendItem(item, f, this.customOption);
                        }, this);
                        tree.appendChild(f);
                        this.pageIndex++;
                        this.emit("selectr.paginate", {
                            items: this.items.length,
                            total: this.data.length,
                            page: this.pageIndex,
                            pages: this.pages.length
                        });
                    }
                };
                /**
                 * Clear a search
                 * @return {void}
                 */


                var clearSearch = function clearSearch() {
                    if (this.config.searchable || this.config.taggable) {
                        this.input.value = null;
                        this.searching = false;

                        if (this.config.searchable) {
                            util.removeClass(this.inputContainer, "active");
                        }

                        if (util.hasClass(this.container, "notice")) {
                            util.removeClass(this.container, "notice");
                            util.addClass(this.container, "open");
                            this.input.focus();
                        }

                        util.each(this.items, function (i, item) {
                            // Items that didn't match need the class
                            // removing to make them visible again
                            util.removeClass(item, "excluded"); // Remove the span element for underlining matched items

                            if (!this.customOption) {
                                item.innerHTML = item.textContent;
                            }
                        }, this);
                    }
                };
                /**
                 * Query matching for searches
                 * @param  {string} query
                 * @param  {HTMLOptionElement} option
                 * @return {bool}
                 */


                var match = function match(query, option) {
                    var result = new RegExp(query, "i").exec(option.textContent);

                    if (result) {
                        return option.textContent.replace(result[0], "<span class='selectr-match'>" + result[0] + "</span>");
                    }

                    return false;
                }; // Main Lib


                var Selectr = function Selectr(el, config) {
                    config = config || {};

                    if (!el) {
                        throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");
                    }

                    this.el = el; // CSS3 selector string

                    if (typeof el === "string") {
                        this.el = document.querySelector(el);
                    }

                    if (this.el === null) {
                        throw new Error("The element you passed to Selectr can not be found.");
                    }

                    if (this.el.nodeName.toLowerCase() !== "select") {
                        throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");
                    }

                    this.render(config);
                };
                /**
                 * Render the instance
                 * @param  {object} config
                 * @return {void}
                 */


                Selectr.prototype.render = function (config) {
                    if (this.rendered) return; // Merge defaults with user set config

                    this.config = util.extend(defaultConfig, config); // Store type

                    this.originalType = this.el.type; // Store tabIndex

                    this.originalIndex = this.el.tabIndex; // Store defaultSelected options for form reset

                    this.defaultSelected = []; // Store the original option count

                    this.originalOptionCount = this.el.options.length;

                    if (this.config.multiple || this.config.taggable) {
                        this.el.multiple = true;
                    } // Disabled?


                    this.disabled = isset(this.config, "disabled");
                    this.opened = false;

                    if (this.config.taggable) {
                        this.config.searchable = false;
                    }

                    this.navigating = false;
                    this.mobileDevice = false;

                    if (/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)) {
                        this.mobileDevice = true;
                    }

                    this.customOption = this.config.hasOwnProperty("renderOption") && typeof this.config.renderOption === "function";
                    this.customSelected = this.config.hasOwnProperty("renderSelection") && typeof this.config.renderSelection === "function"; // Enable event emitter

                    Events.mixin(this);
                    build.call(this);
                    this.bindEvents();
                    this.update();
                    this.optsRect = util.rect(this.tree);
                    this.rendered = true; // Fixes macOS Safari bug #28

                    if (!this.el.multiple) {
                        this.el.selectedIndex = this.selectedIndex;
                    }

                    var that = this;
                    setTimeout(function () {
                        that.emit("selectr.init");
                    }, 20);
                };

                Selectr.prototype.getSelected = function () {
                    var selected = this.el.querySelectorAll('option:checked');
                    return selected;
                };

                Selectr.prototype.getSelectedProperties = function (prop) {
                    var selected = this.getSelected();
                    var values = [].slice.call(selected).map(function (option) {
                        return option[prop];
                    }).filter(function (i) {
                        return i !== null && i !== undefined;
                    });
                    return values;
                };
                /**
                 * Attach the required event listeners
                 */


                Selectr.prototype.bindEvents = function () {
                    var that = this;
                    this.events = {};
                    this.events.dismiss = dismiss.bind(this);
                    this.events.navigate = navigate.bind(this);
                    this.events.reset = this.reset.bind(this);

                    if (this.config.nativeDropdown || this.mobileDevice) {
                        this.container.addEventListener("touchstart", function (e) {
                            if (e.changedTouches[0].target === that.el) {
                                that.toggle();
                            }
                        });

                        if (this.config.nativeDropdown || this.mobileDevice) {
                            this.container.addEventListener("click", function (e) {
                                e.preventDefault(); // Jos: Added to prevent emitting clear directly after select

                                e.stopPropagation(); // Jos: Added to prevent emitting clear directly after select

                                if (e.target === that.el) {
                                    that.toggle();
                                }
                            });
                        }

                        var getChangedOptions = function getChangedOptions(last, current) {
                            var added = [],
                                removed = last.slice(0);
                            var idx;

                            for (var i = 0; i < current.length; i++) {
                                idx = removed.indexOf(current[i]);
                                if (idx > -1) removed.splice(idx, 1); else added.push(current[i]);
                            }

                            return [added, removed];
                        }; // Listen for the change on the native select
                        // and update accordingly


                        this.el.addEventListener("change", function (e) {
                            if (that.el.multiple) {
                                var indexes = that.getSelectedProperties('idx');
                                var changes = getChangedOptions(that.selectedIndexes, indexes);
                                util.each(changes[0], function (i, idx) {
                                    that.select(idx);
                                }, that);
                                util.each(changes[1], function (i, idx) {
                                    that.deselect(idx);
                                }, that);
                            } else {
                                if (that.el.selectedIndex > -1) {
                                    that.select(that.el.selectedIndex);
                                }
                            }
                        });
                    } // Open the dropdown with Enter key if focused


                    if (this.config.nativeDropdown) {
                        this.container.addEventListener("keydown", function (e) {
                            if (e.key === "Enter" && that.selected === document.activeElement) {
                                // Show the native
                                that.toggle(); // Focus on the native multiselect

                                setTimeout(function () {
                                    that.el.focus();
                                }, 200);
                            }
                        });
                    } // Non-native dropdown


                    this.selected.addEventListener("click", function (e) {
                        if (!that.disabled) {
                            that.toggle();
                        }

                        e.preventDefault();
                        e.stopPropagation(); // Jos: Added to prevent emitting clear directly after select
                    }); // Remove tag

                    this.label.addEventListener("click", function (e) {
                        if (util.hasClass(e.target, "selectr-tag-remove")) {
                            that.deselect(e.target.parentNode.idx);
                        }
                    }); // Clear input

                    if (this.selectClear) {
                        this.selectClear.addEventListener("click", this.clear.bind(this));
                    } // Prevent text selection


                    this.tree.addEventListener("mousedown", function (e) {
                        e.preventDefault();
                    }); // Select / deselect items

                    this.tree.addEventListener("click", function (e) {
                        e.preventDefault(); // Jos: Added to prevent emitting clear directly after select

                        e.stopPropagation(); // Jos: Added to prevent emitting clear directly after select

                        var item = util.closest(e.target, function (el) {
                            return el && util.hasClass(el, "selectr-option");
                        });

                        if (item) {
                            if (!util.hasClass(item, "disabled")) {
                                if (util.hasClass(item, "selected")) {
                                    if (that.el.multiple || !that.el.multiple && that.config.allowDeselect) {
                                        that.deselect(item.idx);
                                    }
                                } else {
                                    that.select(item.idx);
                                }

                                if (that.opened && !that.el.multiple) {
                                    that.close();
                                }
                            }
                        }
                    }); // Mouseover list items

                    this.tree.addEventListener("mouseover", function (e) {
                        if (util.hasClass(e.target, "selectr-option")) {
                            if (!util.hasClass(e.target, "disabled")) {
                                util.removeClass(that.items[that.navIndex], "active");
                                util.addClass(e.target, "active");
                                that.navIndex = [].slice.call(that.items).indexOf(e.target);
                            }
                        }
                    }); // Searchable

                    if (this.config.searchable) {
                        // Show / hide the search input clear button
                        this.input.addEventListener("focus", function (e) {
                            that.searching = true;
                        });
                        this.input.addEventListener("blur", function (e) {
                            that.searching = false;
                        });
                        this.input.addEventListener("keyup", function (e) {
                            that.search();

                            if (!that.config.taggable) {
                                // Show / hide the search input clear button
                                if (this.value.length) {
                                    util.addClass(this.parentNode, "active");
                                } else {
                                    util.removeClass(this.parentNode, "active");
                                }
                            }
                        }); // Clear the search input

                        this.inputClear.addEventListener("click", function (e) {
                            that.input.value = null;
                            clearSearch.call(that);

                            if (!that.tree.childElementCount) {
                                render.call(that);
                            }
                        });
                    }

                    if (this.config.taggable) {
                        this.input.addEventListener("keyup", function (e) {
                            that.search();

                            if (that.config.taggable && this.value.length) {
                                var val = this.value.trim();

                                if (e.which === 13 || util.includes(that.tagSeperators, e.key)) {
                                    util.each(that.tagSeperators, function (i, k) {
                                        val = val.replace(k, '');
                                    });
                                    var option = that.add({
                                        value: val,
                                        text: val,
                                        selected: true
                                    }, true);

                                    if (!option) {
                                        this.value = '';
                                        that.setMessage('That tag is already in use.');
                                    } else {
                                        that.close();
                                        clearSearch.call(that);
                                    }
                                }
                            }
                        });
                    }

                    this.update = util.debounce(function () {
                        // Optionally close dropdown on scroll / resize (#11)
                        if (that.opened && that.config.closeOnScroll) {
                            that.close();
                        }

                        if (that.width) {
                            that.container.style.width = that.width;
                        }

                        that.invert();
                    }, 50);

                    if (this.requiresPagination) {
                        this.paginateItems = util.debounce(function () {
                            load.call(this);
                        }, 50);
                        this.tree.addEventListener("scroll", this.paginateItems.bind(this));
                    } // Dismiss when clicking outside the container


                    document.addEventListener("click", this.events.dismiss);
                    window.addEventListener("keydown", this.events.navigate);
                    window.addEventListener("resize", this.update);
                    window.addEventListener("scroll", this.update); // Listen for form.reset() (@ambrooks, #13)

                    if (this.el.form) {
                        this.el.form.addEventListener("reset", this.events.reset);
                    }
                };
                /**
                 * Check for selected options
                 * @param {bool} reset
                 */


                Selectr.prototype.setSelected = function (reset) {
                    // Select first option as with a native select-one element - #21, #24
                    if (!this.config.data && !this.el.multiple && this.el.options.length) {
                        // Browser has selected the first option by default
                        if (this.el.selectedIndex === 0) {
                            if (!this.el.options[0].defaultSelected && !this.config.defaultSelected) {
                                this.el.selectedIndex = -1;
                            }
                        }

                        this.selectedIndex = this.el.selectedIndex;

                        if (this.selectedIndex > -1) {
                            this.select(this.selectedIndex);
                        }
                    } // If we're changing a select-one to select-multiple via the config
                    // and there are no selected options, the first option will be selected by the browser
                    // Let's prevent that here.


                    if (this.config.multiple && this.originalType === "select-one" && !this.config.data) {
                        if (this.el.options[0].selected && !this.el.options[0].defaultSelected) {
                            this.el.options[0].selected = false;
                        }
                    }

                    util.each(this.options, function (i, option) {
                        if (option.selected && option.defaultSelected) {
                            this.select(option.idx);
                        }
                    }, this);

                    if (this.config.selectedValue) {
                        this.setValue(this.config.selectedValue);
                    }

                    if (this.config.data) {
                        if (!this.el.multiple && this.config.defaultSelected && this.el.selectedIndex < 0) {
                            this.select(0);
                        }

                        var j = 0;
                        util.each(this.config.data, function (i, opt) {
                            // Check for group options
                            if (isset(opt, "children")) {
                                util.each(opt.children, function (x, item) {
                                    if (item.hasOwnProperty("selected") && item.selected === true) {
                                        this.select(j);
                                    }

                                    j++;
                                }, this);
                            } else {
                                if (opt.hasOwnProperty("selected") && opt.selected === true) {
                                    this.select(j);
                                }

                                j++;
                            }
                        }, this);
                    }
                };
                /**
                 * Destroy the instance
                 * @return {void}
                 */


                Selectr.prototype.destroy = function () {
                    if (!this.rendered) return;
                    this.emit("selectr.destroy"); // Revert to select-single if programtically set to multiple

                    if (this.originalType === 'select-one') {
                        this.el.multiple = false;
                    }

                    if (this.config.data) {
                        this.el.innerHTML = "";
                    } // Remove the className from select element


                    util.removeClass(this.el, 'selectr-hidden'); // Remove reset listener from parent form

                    if (this.el.form) {
                        util.off(this.el.form, "reset", this.events.reset);
                    } // Remove event listeners attached to doc and win


                    util.off(document, "click", this.events.dismiss);
                    util.off(document, "keydown", this.events.navigate);
                    util.off(window, "resize", this.update);
                    util.off(window, "scroll", this.update); // Replace the container with the original select element

                    this.container.parentNode.replaceChild(this.el, this.container);
                    this.rendered = false;
                };
                /**
                 * Change an options state
                 * @param  {Number} index
                 * @return {void}
                 */


                Selectr.prototype.change = function (index) {
                    var item = this.items[index],
                        option = this.options[index];

                    if (option.disabled) {
                        return;
                    }

                    if (option.selected && util.hasClass(item, "selected")) {
                        this.deselect(index);
                    } else {
                        this.select(index);
                    }

                    if (this.opened && !this.el.multiple) {
                        this.close();
                    }
                };
                /**
                 * Select an option
                 * @param  {Number} index
                 * @return {void}
                 */


                Selectr.prototype.select = function (index) {
                    var item = this.items[index],
                        options = [].slice.call(this.el.options),
                        option = this.options[index];

                    if (this.el.multiple) {
                        if (util.includes(this.selectedIndexes, index)) {
                            return false;
                        }

                        if (this.config.maxSelections && this.tags.length === this.config.maxSelections) {
                            this.setMessage("A maximum of " + this.config.maxSelections + " items can be selected.", true);
                            return false;
                        }

                        this.selectedValues.push(option.value);
                        this.selectedIndexes.push(index);
                        addTag.call(this, item);
                    } else {
                        var data = this.data ? this.data[index] : option;
                        this.label.innerHTML = this.customSelected ? this.config.renderSelection(data) : option.textContent;
                        this.selectedValue = option.value;
                        this.selectedIndex = index;
                        util.each(this.options, function (i, o) {
                            var opt = this.items[i];

                            if (i !== index) {
                                if (opt) {
                                    util.removeClass(opt, "selected");
                                }

                                o.selected = false;
                                o.removeAttribute("selected");
                            }
                        }, this);
                    }

                    if (!util.includes(options, option)) {
                        this.el.add(option);
                    }

                    item.setAttribute("aria-selected", true);
                    util.addClass(item, "selected");
                    util.addClass(this.container, "has-selected");
                    option.selected = true;
                    option.setAttribute("selected", "");
                    this.emit("selectr.change", option);
                    this.emit("selectr.select", option);
                };
                /**
                 * Deselect an option
                 * @param  {Number} index
                 * @return {void}
                 */


                Selectr.prototype.deselect = function (index, force) {
                    var item = this.items[index],
                        option = this.options[index];

                    if (this.el.multiple) {
                        var selIndex = this.selectedIndexes.indexOf(index);
                        this.selectedIndexes.splice(selIndex, 1);
                        var valIndex = this.selectedValues.indexOf(option.value);
                        this.selectedValues.splice(valIndex, 1);
                        removeTag.call(this, item);

                        if (!this.tags.length) {
                            util.removeClass(this.container, "has-selected");
                        }
                    } else {
                        if (!force && !this.config.clearable && !this.config.allowDeselect) {
                            return false;
                        }

                        this.label.innerHTML = "";
                        this.selectedValue = null;
                        this.el.selectedIndex = this.selectedIndex = -1;
                        util.removeClass(this.container, "has-selected");
                    }

                    this.items[index].setAttribute("aria-selected", false);
                    util.removeClass(this.items[index], "selected");
                    option.selected = false;
                    option.removeAttribute("selected");
                    this.emit("selectr.change", null);
                    this.emit("selectr.deselect", option);
                };
                /**
                 * Programmatically set selected values
                 * @param {String|Array} value - A string or an array of strings
                 */


                Selectr.prototype.setValue = function (value) {
                    var isArray = Array.isArray(value);

                    if (!isArray) {
                        value = value.toString().trim();
                    } // Can't pass array to select-one


                    if (!this.el.multiple && isArray) {
                        return false;
                    }

                    util.each(this.options, function (i, option) {
                        if (isArray && util.includes(value.toString(), option.value) || option.value === value) {
                            this.change(option.idx);
                        }
                    }, this);
                };
                /**
                 * Set the selected value(s)
                 * @param  {bool} toObject Return only the raw values or an object
                 * @param  {bool} toJson   Return the object as a JSON string
                 * @return {mixed}         Array or String
                 */


                Selectr.prototype.getValue = function (toObject, toJson) {
                    var value;

                    if (this.el.multiple) {
                        if (toObject) {
                            if (this.selectedIndexes.length) {
                                value = {};
                                value.values = [];
                                util.each(this.selectedIndexes, function (i, index) {
                                    var option = this.options[index];
                                    value.values[i] = {
                                        value: option.value,
                                        text: option.textContent
                                    };
                                }, this);
                            }
                        } else {
                            value = this.selectedValues.slice();
                        }
                    } else {
                        if (toObject) {
                            var option = this.options[this.selectedIndex];
                            value = {
                                value: option.value,
                                text: option.textContent
                            };
                        } else {
                            value = this.selectedValue;
                        }
                    }

                    if (toObject && toJson) {
                        value = JSON.stringify(value);
                    }

                    return value;
                };
                /**
                 * Add a new option or options
                 * @param {object} data
                 */


                Selectr.prototype.add = function (data, checkDuplicate) {
                    if (data) {
                        this.data = this.data || [];
                        this.items = this.items || [];
                        this.options = this.options || [];

                        if (Array.isArray(data)) {
                            // We have an array on items
                            util.each(data, function (i, obj) {
                                this.add(obj, checkDuplicate);
                            }, this);
                        } // User passed a single object to the method
                        // or Selectr passed an object from an array
                        else if ("[object Object]" === Object.prototype.toString.call(data)) {
                            if (checkDuplicate) {
                                var dupe = false;
                                util.each(this.options, function (i, option) {
                                    if (option.value.toLowerCase() === data.value.toLowerCase()) {
                                        dupe = true;
                                    }
                                });

                                if (dupe) {
                                    return false;
                                }
                            }

                            var option = util.createElement('option', data);
                            this.data.push(data); // Add the new option to the list

                            this.options.push(option); // Add the index for later use

                            option.idx = this.options.length > 0 ? this.options.length - 1 : 0; // Create a new item

                            createItem.call(this, option); // Select the item if required

                            if (data.selected) {
                                this.select(option.idx);
                            }

                            return option;
                        } // We may have had an empty select so update
                        // the placeholder to reflect the changes.


                        this.setPlaceholder(); // Recount the pages

                        if (this.config.pagination) {
                            this.paginate();
                        }

                        return true;
                    }
                };
                /**
                 * Remove an option or options
                 * @param  {Mixed} o Array, integer (index) or string (value)
                 * @return {Void}
                 */


                Selectr.prototype.remove = function (o) {
                    var options = [];

                    if (Array.isArray(o)) {
                        util.each(o, function (i, opt) {
                            if (util.isInt(opt)) {
                                options.push(this.getOptionByIndex(opt));
                            } else if (typeof o === "string") {
                                options.push(this.getOptionByValue(opt));
                            }
                        }, this);
                    } else if (util.isInt(o)) {
                        options.push(this.getOptionByIndex(o));
                    } else if (typeof o === "string") {
                        options.push(this.getOptionByValue(o));
                    }

                    if (options.length) {
                        var index;
                        util.each(options, function (i, option) {
                            index = option.idx; // Remove the HTMLOptionElement

                            this.el.remove(option); // Remove the reference from the option array

                            this.options.splice(index, 1); // If the item has a parentNode (group element) it needs to be removed
                            // otherwise the render function will still append it to the dropdown

                            var parentNode = this.items[index].parentNode;

                            if (parentNode) {
                                parentNode.removeChild(this.items[index]);
                            } // Remove reference from the items array


                            this.items.splice(index, 1); // Reset the indexes

                            util.each(this.options, function (i, opt) {
                                opt.idx = i;
                                this.items[i].idx = i;
                            }, this);
                        }, this); // We may have had an empty select now so update
                        // the placeholder to reflect the changes.

                        this.setPlaceholder(); // Recount the pages

                        if (this.config.pagination) {
                            this.paginate();
                        }
                    }
                };
                /**
                 * Remove all options
                 */


                Selectr.prototype.removeAll = function () {
                    // Clear any selected options
                    this.clear(true); // Remove the HTMLOptionElements

                    util.each(this.el.options, function (i, option) {
                        this.el.remove(option);
                    }, this); // Empty the dropdown

                    util.truncate(this.tree); // Reset variables

                    this.items = [];
                    this.options = [];
                    this.data = [];
                    this.navIndex = 0;

                    if (this.requiresPagination) {
                        this.requiresPagination = false;
                        this.pageIndex = 1;
                        this.pages = [];
                    } // Update the placeholder


                    this.setPlaceholder();
                };
                /**
                 * Perform a search
                 * @param  {string} query The query string
                 */


                Selectr.prototype.search = function (string) {
                    if (this.navigating) return;
                    string = string || this.input.value;
                    var f = document.createDocumentFragment(); // Remove message

                    this.removeMessage(); // Clear the dropdown

                    util.truncate(this.tree);

                    if (string.length > 1) {
                        // Check the options for the matching string
                        util.each(this.options, function (i, option) {
                            var item = this.items[option.idx];
                            var includes = util.includes(option.textContent.toLowerCase(), string.toLowerCase());

                            if (includes && !option.disabled) {
                                appendItem(item, f, this.customOption);
                                util.removeClass(item, "excluded"); // Underline the matching results

                                if (!this.customOption) {
                                    item.innerHTML = match(string, option);
                                }
                            } else {
                                util.addClass(item, "excluded");
                            }
                        }, this);

                        if (!f.childElementCount) {
                            if (!this.config.taggable) {
                                this.setMessage("no results.");
                            }
                        } else {
                            // Highlight top result (@binary-koan #26)
                            var prevEl = this.items[this.navIndex];
                            var firstEl = f.firstElementChild;
                            util.removeClass(prevEl, "active");
                            this.navIndex = firstEl.idx;
                            util.addClass(firstEl, "active");
                        }
                    } else {
                        render.call(this);
                    }

                    this.tree.appendChild(f);
                };
                /**
                 * Toggle the dropdown
                 * @return {void}
                 */


                Selectr.prototype.toggle = function () {
                    if (!this.disabled) {
                        if (this.opened) {
                            this.close();
                        } else {
                            this.open();
                        }
                    }
                };
                /**
                 * Open the dropdown
                 * @return {void}
                 */


                Selectr.prototype.open = function () {
                    var that = this;

                    if (!this.options.length) {
                        return false;
                    }

                    if (!this.opened) {
                        this.emit("selectr.open");
                    }

                    this.opened = true;

                    if (this.mobileDevice || this.config.nativeDropdown) {
                        util.addClass(this.container, "native-open");

                        if (this.config.data) {
                            // Dump the options into the select
                            // otherwise the native dropdown will be empty
                            util.each(this.options, function (i, option) {
                                this.el.add(option);
                            }, this);
                        }

                        return;
                    }

                    util.addClass(this.container, "open");
                    render.call(this);
                    this.invert();
                    this.tree.scrollTop = 0;
                    util.removeClass(this.container, "notice");
                    this.selected.setAttribute("aria-expanded", true);
                    this.tree.setAttribute("aria-hidden", false);
                    this.tree.setAttribute("aria-expanded", true);

                    if (this.config.searchable && !this.config.taggable) {
                        setTimeout(function () {
                            that.input.focus(); // Allow tab focus

                            that.input.tabIndex = 0;
                        }, 10);
                    }
                };
                /**
                 * Close the dropdown
                 * @return {void}
                 */


                Selectr.prototype.close = function () {
                    if (this.opened) {
                        this.emit("selectr.close");
                    }

                    this.opened = false;

                    if (this.mobileDevice || this.config.nativeDropdown) {
                        util.removeClass(this.container, "native-open");
                        return;
                    }

                    var notice = util.hasClass(this.container, "notice");

                    if (this.config.searchable && !notice) {
                        this.input.blur(); // Disable tab focus

                        this.input.tabIndex = -1;
                        this.searching = false;
                    }

                    if (notice) {
                        util.removeClass(this.container, "notice");
                        this.notice.textContent = "";
                    }

                    util.removeClass(this.container, "open");
                    util.removeClass(this.container, "native-open");
                    this.selected.setAttribute("aria-expanded", false);
                    this.tree.setAttribute("aria-hidden", true);
                    this.tree.setAttribute("aria-expanded", false);
                    util.truncate(this.tree);
                    clearSearch.call(this);
                };
                /**
                 * Enable the element
                 * @return {void}
                 */


                Selectr.prototype.enable = function () {
                    this.disabled = false;
                    this.el.disabled = false;
                    this.selected.tabIndex = this.originalIndex;

                    if (this.el.multiple) {
                        util.each(this.tags, function (i, t) {
                            t.lastElementChild.tabIndex = 0;
                        });
                    }

                    util.removeClass(this.container, "selectr-disabled");
                };
                /**
                 * Disable the element
                 * @param  {boolean} container Disable the container only (allow value submit with form)
                 * @return {void}
                 */


                Selectr.prototype.disable = function (container) {
                    if (!container) {
                        this.el.disabled = true;
                    }

                    this.selected.tabIndex = -1;

                    if (this.el.multiple) {
                        util.each(this.tags, function (i, t) {
                            t.lastElementChild.tabIndex = -1;
                        });
                    }

                    this.disabled = true;
                    util.addClass(this.container, "selectr-disabled");
                };
                /**
                 * Reset to initial state
                 * @return {void}
                 */


                Selectr.prototype.reset = function () {
                    if (!this.disabled) {
                        this.clear();
                        this.setSelected(true);
                        util.each(this.defaultSelected, function (i, idx) {
                            this.select(idx);
                        }, this);
                        this.emit("selectr.reset");
                    }
                };
                /**
                 * Clear all selections
                 * @return {void}
                 */


                Selectr.prototype.clear = function (force) {
                    if (this.el.multiple) {
                        // Loop over the selectedIndexes so we don't have to loop over all the options
                        // which can be costly if there are a lot of them
                        if (this.selectedIndexes.length) {
                            // Copy the array or we'll get an error
                            var indexes = this.selectedIndexes.slice();
                            util.each(indexes, function (i, idx) {
                                this.deselect(idx);
                            }, this);
                        }
                    } else {
                        if (this.selectedIndex > -1) {
                            this.deselect(this.selectedIndex, force);
                        }
                    }

                    this.emit("selectr.clear");
                };
                /**
                 * Return serialised data
                 * @param  {boolean} toJson
                 * @return {mixed} Returns either an object or JSON string
                 */


                Selectr.prototype.serialise = function (toJson) {
                    var data = [];
                    util.each(this.options, function (i, option) {
                        var obj = {
                            value: option.value,
                            text: option.textContent
                        };

                        if (option.selected) {
                            obj.selected = true;
                        }

                        if (option.disabled) {
                            obj.disabled = true;
                        }

                        data[i] = obj;
                    });
                    return toJson ? JSON.stringify(data) : data;
                };
                /**
                 * Localised version of serialise() method
                 */


                Selectr.prototype.serialize = function (toJson) {
                    return this.serialise(toJson);
                };
                /**
                 * Sets the placeholder
                 * @param {String} placeholder
                 */


                Selectr.prototype.setPlaceholder = function (placeholder) {
                    // Set the placeholder
                    placeholder = placeholder || this.config.placeholder || this.el.getAttribute("placeholder");

                    if (!this.options.length) {
                        placeholder = "No options available";
                    }

                    this.placeEl.innerHTML = placeholder;
                };
                /**
                 * Paginate the option list
                 * @return {Array}
                 */


                Selectr.prototype.paginate = function () {
                    if (this.items.length) {
                        var that = this;
                        this.pages = this.items.map(function (v, i) {
                            return i % that.config.pagination === 0 ? that.items.slice(i, i + that.config.pagination) : null;
                        }).filter(function (pages) {
                            return pages;
                        });
                        return this.pages;
                    }
                };
                /**
                 * Display a message
                 * @param  {String} message The message
                 */


                Selectr.prototype.setMessage = function (message, close) {
                    if (close) {
                        this.close();
                    }

                    util.addClass(this.container, "notice");
                    this.notice.textContent = message;
                };
                /**
                 * Dismiss the current message
                 */


                Selectr.prototype.removeMessage = function () {
                    util.removeClass(this.container, "notice");
                    this.notice.innerHTML = "";
                };
                /**
                 * Keep the dropdown within the window
                 * @return {void}
                 */


                Selectr.prototype.invert = function () {
                    var rt = util.rect(this.selected),
                        oh = this.tree.parentNode.offsetHeight,
                        wh = window.innerHeight,
                        doInvert = rt.top + rt.height + oh > wh;

                    if (doInvert) {
                        util.addClass(this.container, "inverted");
                        this.isInverted = true;
                    } else {
                        util.removeClass(this.container, "inverted");
                        this.isInverted = false;
                    }

                    this.optsRect = util.rect(this.tree);
                };
                /**
                 * Get an option via it's index
                 * @param  {Integer} index The index of the HTMLOptionElement required
                 * @return {HTMLOptionElement}
                 */


                Selectr.prototype.getOptionByIndex = function (index) {
                    return this.options[index];
                };
                /**
                 * Get an option via it's value
                 * @param  {String} value The value of the HTMLOptionElement required
                 * @return {HTMLOptionElement}
                 */


                Selectr.prototype.getOptionByValue = function (value) {
                    var option = false;

                    for (var i = 0, l = this.options.length; i < l; i++) {
                        if (this.options[i].value.trim() === value.toString().trim()) {
                            option = this.options[i];
                            break;
                        }
                    }

                    return option;
                };

                module.exports = Selectr;

                /***/
            }),
            /* 11 */
            /***/ (function (module, exports) {

                /*
 * Natural Sort algorithm for Javascript - Version 0.7 - Released under MIT license
 * Author: Jim Palmer (based on chunking idea from Dave Koelle)
 */
                /*jshint unused:false */
                module.exports = function naturalSort(a, b) {
                    "use strict";
                    var re = /(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,
                        sre = /(^[ ]*|[ ]*$)/g,
                        dre = /(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,
                        hre = /^0x[0-9a-f]+$/i,
                        ore = /^0/,
                        i = function (s) {
                            return naturalSort.insensitive && ('' + s).toLowerCase() || '' + s;
                        },
                        // convert all to strings strip whitespace
                        x = i(a).replace(sre, '') || '',
                        y = i(b).replace(sre, '') || '',
                        // chunk/tokenize
                        xN = x.replace(re, '\0$1\0').replace(/\0$/, '').replace(/^\0/, '').split('\0'),
                        yN = y.replace(re, '\0$1\0').replace(/\0$/, '').replace(/^\0/, '').split('\0'),
                        // numeric, hex or date detection
                        xD = parseInt(x.match(hre), 16) || (xN.length !== 1 && x.match(dre) && Date.parse(x)),
                        yD = parseInt(y.match(hre), 16) || xD && y.match(dre) && Date.parse(y) || null,
                        oFxNcL, oFyNcL;
                    // first try and sort Hex codes or Dates
                    if (yD) {
                        if (xD < yD) {
                            return -1;
                        } else if (xD > yD) {
                            return 1;
                        }
                    }
                    // natural sorting through split numeric strings and default strings
                    for (var cLoc = 0, numS = Math.max(xN.length, yN.length); cLoc < numS; cLoc++) {
                        // find floats not starting with '0', string or 0 if not defined (Clint Priest)
                        oFxNcL = !(xN[cLoc] || '').match(ore) && parseFloat(xN[cLoc]) || xN[cLoc] || 0;
                        oFyNcL = !(yN[cLoc] || '').match(ore) && parseFloat(yN[cLoc]) || yN[cLoc] || 0;
                        // handle numeric vs string comparison - number < string - (Kyle Adams)
                        if (isNaN(oFxNcL) !== isNaN(oFyNcL)) {
                            return (isNaN(oFxNcL)) ? 1 : -1;
                        }
                        // rely on string comparison if different types - i.e. '02' < 2 != '02' < '2'
                        else if (typeof oFxNcL !== typeof oFyNcL) {
                            oFxNcL += '';
                            oFyNcL += '';
                        }
                        if (oFxNcL < oFyNcL) {
                            return -1;
                        }
                        if (oFxNcL > oFyNcL) {
                            return 1;
                        }
                    }
                    return 0;
                };


                /***/
            }),
            /* 12 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return createAbsoluteAnchor;
                });
                /* harmony import */
                var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(0);

                /**
                 * Create an anchor element absolutely positioned in the `parent`
                 * element.
                 * @param {HTMLElement} anchor
                 * @param {HTMLElement} parent
                 * @param {function(HTMLElement)} [onDestroy]  Callback when the anchor is destroyed
                 * @param {boolean} [destroyOnMouseOut=false] If true, anchor will be removed on mouse out
                 * @returns {HTMLElement}
                 */

                function createAbsoluteAnchor(anchor, parent, onDestroy) {
                    var destroyOnMouseOut = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                    var root = getRootNode(anchor);
                    var eventListeners = {};
                    var anchorRect = anchor.getBoundingClientRect();
                    var parentRect = parent.getBoundingClientRect();
                    var absoluteAnchor = document.createElement('div');
                    absoluteAnchor.className = 'jsoneditor-anchor';
                    absoluteAnchor.style.position = 'absolute';
                    absoluteAnchor.style.left = anchorRect.left - parentRect.left + 'px';
                    absoluteAnchor.style.top = anchorRect.top - parentRect.top + 'px';
                    absoluteAnchor.style.width = anchorRect.width - 2 + 'px';
                    absoluteAnchor.style.height = anchorRect.height - 2 + 'px';
                    absoluteAnchor.style.boxSizing = 'border-box';
                    parent.appendChild(absoluteAnchor);

                    function destroy() {
                        // remove temporary absolutely positioned anchor
                        if (absoluteAnchor && absoluteAnchor.parentNode) {
                            absoluteAnchor.parentNode.removeChild(absoluteAnchor); // remove all event listeners
                            // all event listeners are supposed to be attached to document.

                            for (var name in eventListeners) {
                                if (hasOwnProperty(eventListeners, name)) {
                                    var fn = eventListeners[name];

                                    if (fn) {
                                        Object(_util__WEBPACK_IMPORTED_MODULE_0__["removeEventListener"])(root, name, fn);
                                    }

                                    delete eventListeners[name];
                                }
                            }

                            if (typeof onDestroy === 'function') {
                                onDestroy(anchor);
                            }
                        }
                    }

                    function isOutside(target) {
                        return target !== absoluteAnchor && !Object(_util__WEBPACK_IMPORTED_MODULE_0__["isChildOf"])(target, absoluteAnchor);
                    } // create and attach event listeners


                    function destroyIfOutside(event) {
                        if (isOutside(event.target)) {
                            destroy();
                        }
                    }

                    eventListeners.mousedown = Object(_util__WEBPACK_IMPORTED_MODULE_0__["addEventListener"])(root, 'mousedown', destroyIfOutside);
                    eventListeners.mousewheel = Object(_util__WEBPACK_IMPORTED_MODULE_0__["addEventListener"])(root, 'mousewheel', destroyIfOutside);

                    if (destroyOnMouseOut) {
                        var destroyTimer = null;

                        absoluteAnchor.onmouseover = function () {
                            clearTimeout(destroyTimer);
                            destroyTimer = null;
                        };

                        absoluteAnchor.onmouseout = function () {
                            if (!destroyTimer) {
                                destroyTimer = setTimeout(destroy, 200);
                            }
                        };
                    }

                    absoluteAnchor.destroy = destroy;
                    return absoluteAnchor;
                }

                /**
                 * Node.getRootNode shim
                 * @param  {HTMLElement} node node to check
                 * @return {HTMLElement}      node's rootNode or `window` if there is ShadowDOM is not supported.
                 */

                function getRootNode(node) {
                    return typeof node.getRootNode === 'function' ? node.getRootNode() : window;
                }

                function hasOwnProperty(object, key) {
                    return Object.prototype.hasOwnProperty.call(object, key);
                }

                /***/
            }),
            /* 13 */
            /***/ (function (module, exports, __webpack_require__) {

                var VanillaPicker;

                if (window.Picker) {
                    // use the already loaded instance of VanillaPicker
                    VanillaPicker = window.Picker;
                } else {
                    try {
                        // load color picker
                        VanillaPicker = __webpack_require__(41);
                    } catch (err) {// probably running the minimalist bundle
                    }
                }

                module.exports = VanillaPicker;

                /***/
            }),
            /* 14 */
            /***/ (function (module, exports, __webpack_require__) {

                var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
                 * Permission is hereby granted, free of charge, to any person obtaining a copy
                 * of this software and associated documentation files (the "Software"), to deal
                 * in the Software without restriction, including without limitation the rights
                 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
                 * copies of the Software, and to permit persons to whom the Software is
                 * furnished to do so, subject to the following conditions:
                 *
                 * The above copyright notice and this permission notice shall be included in
                 * all copies or substantial portions of the Software.
                 *
                 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
                 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
                 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
                 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
                 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
                 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
                 * SOFTWARE.
                 */

                (function (root, factory) {
                    "use strict";

                    if (true) {
                        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
                            __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
                                (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
                        __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
                    } else {
                    }
                }(this, function () {

                    /**
                     * A self-contained modal library
                     */
                    "use strict";

                    /** Returns whether a value is a dom node */
                    function isNode(value) {
                        if (typeof Node === "object") {
                            return value instanceof Node;
                        } else {
                            return value && typeof value === "object" && typeof value.nodeType === "number";
                        }
                    }

                    /** Returns whether a value is a string */
                    function isString(value) {
                        return typeof value === "string";
                    }

                    /**
                     * Generates observable objects that can be watched and triggered
                     */
                    function observable() {
                        var callbacks = [];
                        return {
                            watch: callbacks.push.bind(callbacks),
                            trigger: function (context, detail) {

                                var unprevented = true;
                                var event = {
                                    detail: detail,
                                    preventDefault: function preventDefault() {
                                        unprevented = false;
                                    }
                                };

                                for (var i = 0; i < callbacks.length; i++) {
                                    callbacks[i](context, event);
                                }

                                return unprevented;
                            }
                        };
                    }


                    /** Whether an element is hidden */
                    function isHidden(elem) {
                        // @see http://stackoverflow.com/questions/19669786
                        return window.getComputedStyle(elem).display === 'none';
                    }


                    /**
                     * A small interface for creating and managing a dom element
                     */
                    function Elem(elem) {
                        this.elem = elem;
                    }

                    /** Creates a new div */
                    Elem.make = function (parent, tag) {
                        if (typeof parent === "string") {
                            parent = document.querySelector(parent);
                        }
                        var elem = document.createElement(tag || 'div');
                        (parent || document.body).appendChild(elem);
                        return new Elem(elem);
                    };

                    Elem.prototype = {

                        /** Creates a child of this node */
                        child: function (tag) {
                            return Elem.make(this.elem, tag);
                        },

                        /** Applies a set of styles to an element */
                        stylize: function (styles) {
                            styles = styles || {};

                            if (typeof styles.opacity !== "undefined") {
                                styles.filter = "alpha(opacity=" + (styles.opacity * 100) + ")";
                            }

                            for (var prop in styles) {
                                if (styles.hasOwnProperty(prop)) {
                                    this.elem.style[prop] = styles[prop];
                                }
                            }

                            return this;
                        },

                        /** Adds a class name */
                        clazz: function (clazz) {
                            this.elem.className += " " + clazz;
                            return this;
                        },

                        /** Sets the HTML */
                        html: function (content) {
                            if (isNode(content)) {
                                this.elem.appendChild(content);
                            } else {
                                this.elem.innerHTML = content;
                            }
                            return this;
                        },

                        /** Adds a click handler to this element */
                        onClick: function (callback) {
                            this.elem.addEventListener('click', callback);
                            return this;
                        },

                        /** Removes this element from the DOM */
                        destroy: function () {
                            this.elem.parentNode.removeChild(this.elem);
                        },

                        /** Hides this element */
                        hide: function () {
                            this.elem.style.display = "none";
                        },

                        /** Shows this element */
                        show: function () {
                            this.elem.style.display = "block";
                        },

                        /** Sets an attribute on this element */
                        attr: function (name, value) {
                            if (value !== undefined) {
                                this.elem.setAttribute(name, value);
                            }
                            return this;
                        },

                        /** Executes a callback on all the ancestors of an element */
                        anyAncestor: function (predicate) {
                            var elem = this.elem;
                            while (elem) {
                                if (predicate(new Elem(elem))) {
                                    return true;
                                } else {
                                    elem = elem.parentNode;
                                }
                            }
                            return false;
                        },

                        /** Whether this element is visible */
                        isVisible: function () {
                            return !isHidden(this.elem);
                        }
                    };


                    /** Generates the grey-out effect */
                    function buildOverlay(getOption, close) {
                        return Elem.make(getOption("parent"))
                            .clazz("pico-overlay")
                            .clazz(getOption("overlayClass", ""))
                            .stylize({
                                display: "none",
                                position: "fixed",
                                top: "0px",
                                left: "0px",
                                height: "100%",
                                width: "100%",
                                zIndex: 10000
                            })
                            .stylize(getOption('overlayStyles', {
                                opacity: 0.5,
                                background: "#000"
                            }))
                            .onClick(function () {
                                if (getOption('overlayClose', true)) {
                                    close();
                                }
                            });
                    }

                    // An auto incrementing ID assigned to each modal
                    var autoinc = 1;

                    /** Builds the content of a modal */
                    function buildModal(getOption, close) {
                        var width = getOption('width', 'auto');
                        if (typeof width === "number") {
                            width = "" + width + "px";
                        }

                        var id = getOption("modalId", "pico-" + autoinc++);

                        var elem = Elem.make(getOption("parent"))
                            .clazz("pico-content")
                            .clazz(getOption("modalClass", ""))
                            .stylize({
                                display: 'none',
                                position: 'fixed',
                                zIndex: 10001,
                                left: "50%",
                                top: "38.1966%",
                                maxHeight: '90%',
                                boxSizing: 'border-box',
                                width: width,
                                '-ms-transform': 'translate(-50%,-38.1966%)',
                                '-moz-transform': 'translate(-50%,-38.1966%)',
                                '-webkit-transform': 'translate(-50%,-38.1966%)',
                                '-o-transform': 'translate(-50%,-38.1966%)',
                                transform: 'translate(-50%,-38.1966%)'
                            })
                            .stylize(getOption('modalStyles', {
                                overflow: 'auto',
                                backgroundColor: "white",
                                padding: "20px",
                                borderRadius: "5px"
                            }))
                            .html(getOption('content'))
                            .attr("id", id)
                            .attr("role", "dialog")
                            .attr("aria-labelledby", getOption("ariaLabelledBy"))
                            .attr("aria-describedby", getOption("ariaDescribedBy", id))
                            .onClick(function (event) {
                                var isCloseClick = new Elem(event.target).anyAncestor(function (elem) {
                                    return /\bpico-close\b/.test(elem.elem.className);
                                });
                                if (isCloseClick) {
                                    close();
                                }
                            });

                        return elem;
                    }

                    /** Builds the close button */
                    function buildClose(elem, getOption) {
                        if (getOption('closeButton', true)) {
                            return elem.child('button')
                                .html(getOption('closeHtml', "&#xD7;"))
                                .clazz("pico-close")
                                .clazz(getOption("closeClass", ""))
                                .stylize(getOption('closeStyles', {
                                    borderRadius: "2px",
                                    border: 0,
                                    padding: 0,
                                    cursor: "pointer",
                                    height: "15px",
                                    width: "15px",
                                    position: "absolute",
                                    top: "5px",
                                    right: "5px",
                                    fontSize: "16px",
                                    textAlign: "center",
                                    lineHeight: "15px",
                                    background: "#CCC"
                                }))
                                .attr("aria-label", getOption("close-label", "Close"));
                        }
                    }

                    /** Builds a method that calls a method and returns an element */
                    function buildElemAccessor(builder) {
                        return function () {
                            return builder().elem;
                        };
                    }


                    // An observable that is triggered whenever the escape key is pressed
                    var escapeKey = observable();

                    // An observable that is triggered when the user hits the tab key
                    var tabKey = observable();

                    /** A global event handler to detect the escape key being pressed */
                    document.documentElement.addEventListener('keydown', function onKeyPress(event) {
                        var keycode = event.which || event.keyCode;

                        // If this is the escape key
                        if (keycode === 27) {
                            escapeKey.trigger();
                        }

                        // If this is the tab key
                        else if (keycode === 9) {
                            tabKey.trigger(event);
                        }
                    });


                    /** Attaches focus management events */
                    function manageFocus(iface, isEnabled) {

                        /** Whether an element matches a selector */
                        function matches(elem, selector) {
                            var fn = elem.msMatchesSelector || elem.webkitMatchesSelector || elem.matches;
                            return fn.call(elem, selector);
                        }

                        /**
                         * Returns whether an element is focusable
                         * @see http://stackoverflow.com/questions/18261595
                         */
                        function canFocus(elem) {
                            if (
                                isHidden(elem) ||
                                matches(elem, ":disabled") ||
                                elem.hasAttribute("contenteditable")
                            ) {
                                return false;
                            } else {
                                return elem.hasAttribute("tabindex") ||
                                    matches(elem, "input,select,textarea,button,a[href],area[href],iframe");
                            }
                        }

                        /** Returns the first descendant that can be focused */
                        function firstFocusable(elem) {
                            var items = elem.getElementsByTagName("*");
                            for (var i = 0; i < items.length; i++) {
                                if (canFocus(items[i])) {
                                    return items[i];
                                }
                            }
                        }

                        /** Returns the last descendant that can be focused */
                        function lastFocusable(elem) {
                            var items = elem.getElementsByTagName("*");
                            for (var i = items.length; i--;) {
                                if (canFocus(items[i])) {
                                    return items[i];
                                }
                            }
                        }

                        // The element focused before the modal opens
                        var focused;

                        // Records the currently focused element so state can be returned
                        // after the modal closes
                        iface.beforeShow(function getActiveFocus() {
                            focused = document.activeElement;
                        });

                        // Shift focus into the modal
                        iface.afterShow(function focusModal() {
                            if (isEnabled()) {
                                var focusable = firstFocusable(iface.modalElem());
                                if (focusable) {
                                    focusable.focus();
                                }
                            }
                        });

                        // Restore the previously focused element when the modal closes
                        iface.afterClose(function returnFocus() {
                            if (isEnabled() && focused) {
                                focused.focus();
                            }
                            focused = null;
                        });

                        // Capture tab key presses and loop them within the modal
                        tabKey.watch(function tabKeyPress(event) {
                            if (isEnabled() && iface.isVisible()) {
                                var first = firstFocusable(iface.modalElem());
                                var last = lastFocusable(iface.modalElem());

                                var from = event.shiftKey ? first : last;
                                if (from === document.activeElement) {
                                    (event.shiftKey ? last : first).focus();
                                    event.preventDefault();
                                }
                            }
                        });
                    }

                    /** Manages setting the 'overflow: hidden' on the body tag */
                    function manageBodyOverflow(iface, isEnabled) {
                        var origOverflow;
                        var body = new Elem(document.body);

                        iface.beforeShow(function () {
                            // Capture the current values so they can be restored
                            origOverflow = body.elem.style.overflow;

                            if (isEnabled()) {
                                body.stylize({overflow: "hidden"});
                            }
                        });

                        iface.afterClose(function () {
                            body.stylize({overflow: origOverflow});
                        });
                    }

                    /**
                     * Displays a modal
                     */
                    return function picoModal(options) {

                        if (isString(options) || isNode(options)) {
                            options = {content: options};
                        }

                        var afterCreateEvent = observable();
                        var beforeShowEvent = observable();
                        var afterShowEvent = observable();
                        var beforeCloseEvent = observable();
                        var afterCloseEvent = observable();

                        /**
                         * Returns a named option if it has been explicitly defined. Otherwise,
                         * it returns the given default value
                         */
                        function getOption(opt, defaultValue) {
                            var value = options[opt];
                            if (typeof value === "function") {
                                value = value(defaultValue);
                            }
                            return value === undefined ? defaultValue : value;
                        }


                        // The various DOM elements that constitute the modal
                        var modalElem = build.bind(window, 'modal');
                        var shadowElem = build.bind(window, 'overlay');
                        var closeElem = build.bind(window, 'close');

                        // This will eventually contain the modal API returned to the user
                        var iface;


                        /** Hides this modal */
                        function forceClose(detail) {
                            shadowElem().hide();
                            modalElem().hide();
                            afterCloseEvent.trigger(iface, detail);
                        }

                        /** Gracefully hides this modal */
                        function close(detail) {
                            if (beforeCloseEvent.trigger(iface, detail)) {
                                forceClose(detail);
                            }
                        }

                        /** Wraps a method so it returns the modal interface */
                        function returnIface(callback) {
                            return function () {
                                callback.apply(this, arguments);
                                return iface;
                            };
                        }


                        // The constructed dom nodes
                        var built;

                        /** Builds a method that calls a method and returns an element */
                        function build(name, detail) {
                            if (!built) {
                                var modal = buildModal(getOption, close);
                                built = {
                                    modal: modal,
                                    overlay: buildOverlay(getOption, close),
                                    close: buildClose(modal, getOption)
                                };
                                afterCreateEvent.trigger(iface, detail);
                            }
                            return built[name];
                        }

                        iface = {

                            /** Returns the wrapping modal element */
                            modalElem: buildElemAccessor(modalElem),

                            /** Returns the close button element */
                            closeElem: buildElemAccessor(closeElem),

                            /** Returns the overlay element */
                            overlayElem: buildElemAccessor(shadowElem),

                            /** Builds the dom without showing the modal */
                            buildDom: returnIface(build.bind(null, null)),

                            /** Returns whether this modal is currently being shown */
                            isVisible: function () {
                                return !!(built && modalElem && modalElem().isVisible());
                            },

                            /** Shows this modal */
                            show: function (detail) {
                                if (beforeShowEvent.trigger(iface, detail)) {
                                    shadowElem().show();
                                    closeElem();
                                    modalElem().show();
                                    afterShowEvent.trigger(iface, detail);
                                }
                                return this;
                            },

                            /** Hides this modal */
                            close: returnIface(close),

                            /**
                             * Force closes this modal. This will not call beforeClose
                             * events and will just immediately hide the modal
                             */
                            forceClose: returnIface(forceClose),

                            /** Destroys this modal */
                            destroy: function () {
                                modalElem().destroy();
                                shadowElem().destroy();
                                shadowElem = modalElem = closeElem = undefined;
                            },

                            /**
                             * Updates the options for this modal. This will only let you
                             * change options that are re-evaluted regularly, such as
                             * `overlayClose`.
                             */
                            options: function (opts) {
                                Object.keys(opts).map(function (key) {
                                    options[key] = opts[key];
                                });
                            },

                            /** Executes after the DOM nodes are created */
                            afterCreate: returnIface(afterCreateEvent.watch),

                            /** Executes a callback before this modal is closed */
                            beforeShow: returnIface(beforeShowEvent.watch),

                            /** Executes a callback after this modal is shown */
                            afterShow: returnIface(afterShowEvent.watch),

                            /** Executes a callback before this modal is closed */
                            beforeClose: returnIface(beforeCloseEvent.watch),

                            /** Executes a callback after this modal is closed */
                            afterClose: returnIface(afterCloseEvent.watch)
                        };

                        manageFocus(iface, getOption.bind(null, "focus", true));

                        manageBodyOverflow(iface, getOption.bind(null, "bodyOverflow", true));

                        // If a user presses the 'escape' key, close the modal.
                        escapeKey.watch(function escapeKeyPress() {
                            if (getOption("escCloses", true) && iface.isVisible()) {
                                iface.close();
                            }
                        });

                        return iface;
                    };

                }));


                /***/
            }),
            /* 15 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
                /* harmony export (binding) */
                __webpack_require__.d(__webpack_exports__, "a", function () {
                    return ErrorTable;
                });

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                /**
                 * Show errors and schema warnings in a clickable table view
                 * @param {Object} config
                 * @property {boolean} errorTableVisible
                 * @property {function (boolean) : void} onToggleVisibility
                 * @property {function (number)} [onFocusLine]
                 * @property {function (number)} onChangeHeight
                 * @constructor
                 */
                var ErrorTable = /*#__PURE__*/function () {
                    function ErrorTable(config) {
                        _classCallCheck(this, ErrorTable);

                        this.errorTableVisible = config.errorTableVisible;
                        this.onToggleVisibility = config.onToggleVisibility;

                        this.onFocusLine = config.onFocusLine || function () {
                        };

                        this.onChangeHeight = config.onChangeHeight;
                        this.dom = {};
                        var validationErrorsContainer = document.createElement('div');
                        validationErrorsContainer.className = 'jsoneditor-validation-errors-container';
                        this.dom.validationErrorsContainer = validationErrorsContainer;
                        var additionalErrorsIndication = document.createElement('div');
                        additionalErrorsIndication.style.display = 'none';
                        additionalErrorsIndication.className = 'jsoneditor-additional-errors fadein';
                        additionalErrorsIndication.innerHTML = 'Scroll for more &#9663;';
                        this.dom.additionalErrorsIndication = additionalErrorsIndication;
                        validationErrorsContainer.appendChild(additionalErrorsIndication);
                        var validationErrorIcon = document.createElement('span');
                        validationErrorIcon.className = 'jsoneditor-validation-error-icon';
                        validationErrorIcon.style.display = 'none';
                        this.dom.validationErrorIcon = validationErrorIcon;
                        var validationErrorCount = document.createElement('span');
                        validationErrorCount.className = 'jsoneditor-validation-error-count';
                        validationErrorCount.style.display = 'none';
                        this.dom.validationErrorCount = validationErrorCount;
                        this.dom.parseErrorIndication = document.createElement('span');
                        this.dom.parseErrorIndication.className = 'jsoneditor-parse-error-icon';
                        this.dom.parseErrorIndication.style.display = 'none';
                    }

                    _createClass(ErrorTable, [{
                        key: "getErrorTable",
                        value: function getErrorTable() {
                            return this.dom.validationErrorsContainer;
                        }
                    }, {
                        key: "getErrorCounter",
                        value: function getErrorCounter() {
                            return this.dom.validationErrorCount;
                        }
                    }, {
                        key: "getWarningIcon",
                        value: function getWarningIcon() {
                            return this.dom.validationErrorIcon;
                        }
                    }, {
                        key: "getErrorIcon",
                        value: function getErrorIcon() {
                            return this.dom.parseErrorIndication;
                        }
                    }, {
                        key: "toggleTableVisibility",
                        value: function toggleTableVisibility() {
                            this.errorTableVisible = !this.errorTableVisible;
                            this.onToggleVisibility(this.errorTableVisible);
                        }
                    }, {
                        key: "setErrors",
                        value: function setErrors(errors, errorLocations) {
                            var _this = this;

                            // clear any previous errors
                            if (this.dom.validationErrors) {
                                this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors);
                                this.dom.validationErrors = null;
                                this.dom.additionalErrorsIndication.style.display = 'none';
                            } // create the table with errors
                            // keep default behavior for parse errors


                            if (this.errorTableVisible && errors.length > 0) {
                                var validationErrors = document.createElement('div');
                                validationErrors.className = 'jsoneditor-validation-errors';
                                validationErrors.innerHTML = '<table class="jsoneditor-text-errors"><tbody></tbody></table>';
                                var tbody = validationErrors.getElementsByTagName('tbody')[0];
                                errors.forEach(function (error) {
                                    var message;

                                    if (typeof error === 'string') {
                                        message = '<td colspan="2"><pre>' + error + '</pre></td>';
                                    } else {
                                        message = '<td>' + (error.dataPath || '') + '</td>' + '<td><pre>' + error.message + '</pre></td>';
                                    }

                                    var line;

                                    if (!isNaN(error.line)) {
                                        line = error.line;
                                    } else if (error.dataPath) {
                                        var errLoc = errorLocations.find(function (loc) {
                                            return loc.path === error.dataPath;
                                        });

                                        if (errLoc) {
                                            line = errLoc.line + 1;
                                        }
                                    }

                                    var trEl = document.createElement('tr');
                                    trEl.className = !isNaN(line) ? 'jump-to-line' : '';

                                    if (error.type === 'error') {
                                        trEl.className += ' parse-error';
                                    } else {
                                        trEl.className += ' validation-error';
                                    }

                                    trEl.innerHTML = '<td><button class="jsoneditor-schema-error"></button></td><td style="white-space:nowrap;">' + (!isNaN(line) ? 'Ln ' + line : '') + '</td>' + message;

                                    trEl.onclick = function () {
                                        _this.onFocusLine(line);
                                    };

                                    tbody.appendChild(trEl);
                                });
                                this.dom.validationErrors = validationErrors;
                                this.dom.validationErrorsContainer.appendChild(validationErrors);
                                this.dom.additionalErrorsIndication.title = errors.length + ' errors total';

                                if (this.dom.validationErrorsContainer.clientHeight < this.dom.validationErrorsContainer.scrollHeight) {
                                    this.dom.additionalErrorsIndication.style.display = 'block';

                                    this.dom.validationErrorsContainer.onscroll = function () {
                                        _this.dom.additionalErrorsIndication.style.display = _this.dom.validationErrorsContainer.clientHeight > 0 && _this.dom.validationErrorsContainer.scrollTop === 0 ? 'block' : 'none';
                                    };
                                } else {
                                    this.dom.validationErrorsContainer.onscroll = undefined;
                                }

                                var height = this.dom.validationErrorsContainer.clientHeight + (this.dom.statusBar ? this.dom.statusBar.clientHeight : 0); // this.content.style.marginBottom = (-height) + 'px';
                                // this.content.style.paddingBottom = height + 'px';

                                this.onChangeHeight(height);
                            } else {
                                this.onChangeHeight(0);
                            } // update the status bar


                            var validationErrorsCount = errors.filter(function (error) {
                                return error.type !== 'error';
                            }).length;

                            if (validationErrorsCount > 0) {
                                this.dom.validationErrorCount.style.display = 'inline';
                                this.dom.validationErrorCount.innerText = validationErrorsCount;
                                this.dom.validationErrorCount.onclick = this.toggleTableVisibility.bind(this);
                                this.dom.validationErrorIcon.style.display = 'inline';
                                this.dom.validationErrorIcon.title = validationErrorsCount + ' schema validation error(s) found';
                                this.dom.validationErrorIcon.onclick = this.toggleTableVisibility.bind(this);
                            } else {
                                this.dom.validationErrorCount.style.display = 'none';
                                this.dom.validationErrorIcon.style.display = 'none';
                            } // update the parse error icon


                            var hasParseErrors = errors.some(function (error) {
                                return error.type === 'error';
                            });

                            if (hasParseErrors) {
                                var line = errors[0].line;
                                this.dom.parseErrorIndication.style.display = 'block';
                                this.dom.parseErrorIndication.title = !isNaN(line) ? 'parse error on line ' + line : 'parse error - check that the json is valid';
                                this.dom.parseErrorIndication.onclick = this.toggleTableVisibility.bind(this);
                            } else {
                                this.dom.parseErrorIndication.style.display = 'none';
                            }
                        }
                    }]);

                    return ErrorTable;
                }();

                /***/
            }),
            /* 16 */
            /***/ (function (module, exports) {

                module.exports = function (module) {
                    if (!module.webpackPolyfill) {
                        module.deprecate = function () {
                        };
                        module.paths = [];
                        // module.parent = undefined by default
                        if (!module.children) module.children = [];
                        Object.defineProperty(module, "loaded", {
                            enumerable: true,
                            get: function () {
                                return module.l;
                            }
                        });
                        Object.defineProperty(module, "id", {
                            enumerable: true,
                            get: function () {
                                return module.i;
                            }
                        });
                        module.webpackPolyfill = 1;
                    }
                    return module;
                };


                /***/
            }),
            /* 17 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                var URI = __webpack_require__(46)
                    , equal = __webpack_require__(18)
                    , util = __webpack_require__(7)
                    , SchemaObject = __webpack_require__(25)
                    , traverse = __webpack_require__(48);

                module.exports = resolve;

                resolve.normalizeId = normalizeId;
                resolve.fullPath = getFullPath;
                resolve.url = resolveUrl;
                resolve.ids = resolveIds;
                resolve.inlineRef = inlineRef;
                resolve.schema = resolveSchema;

                /**
                 * [resolve and compile the references ($ref)]
                 * @this   Ajv
                 * @param  {Function} compile reference to schema compilation funciton (localCompile)
                 * @param  {Object} root object with information about the root schema for the current schema
                 * @param  {String} ref reference to resolve
                 * @return {Object|Function} schema object (if the schema can be inlined) or validation function
                 */
                function resolve(compile, root, ref) {
                    /* jshint validthis: true */
                    var refVal = this._refs[ref];
                    if (typeof refVal == 'string') {
                        if (this._refs[refVal]) refVal = this._refs[refVal];
                        else return resolve.call(this, compile, root, refVal);
                    }

                    refVal = refVal || this._schemas[ref];
                    if (refVal instanceof SchemaObject) {
                        return inlineRef(refVal.schema, this._opts.inlineRefs)
                            ? refVal.schema
                            : refVal.validate || this._compile(refVal);
                    }

                    var res = resolveSchema.call(this, root, ref);
                    var schema, v, baseId;
                    if (res) {
                        schema = res.schema;
                        root = res.root;
                        baseId = res.baseId;
                    }

                    if (schema instanceof SchemaObject) {
                        v = schema.validate || compile.call(this, schema.schema, root, undefined, baseId);
                    } else if (schema !== undefined) {
                        v = inlineRef(schema, this._opts.inlineRefs)
                            ? schema
                            : compile.call(this, schema, root, undefined, baseId);
                    }

                    return v;
                }


                /**
                 * Resolve schema, its root and baseId
                 * @this Ajv
                 * @param  {Object} root root object with properties schema, refVal, refs
                 * @param  {String} ref  reference to resolve
                 * @return {Object} object with properties schema, root, baseId
                 */
                function resolveSchema(root, ref) {
                    /* jshint validthis: true */
                    var p = URI.parse(ref)
                        , refPath = _getFullPath(p)
                        , baseId = getFullPath(this._getId(root.schema));
                    if (Object.keys(root.schema).length === 0 || refPath !== baseId) {
                        var id = normalizeId(refPath);
                        var refVal = this._refs[id];
                        if (typeof refVal == 'string') {
                            return resolveRecursive.call(this, root, refVal, p);
                        } else if (refVal instanceof SchemaObject) {
                            if (!refVal.validate) this._compile(refVal);
                            root = refVal;
                        } else {
                            refVal = this._schemas[id];
                            if (refVal instanceof SchemaObject) {
                                if (!refVal.validate) this._compile(refVal);
                                if (id == normalizeId(ref))
                                    return {schema: refVal, root: root, baseId: baseId};
                                root = refVal;
                            } else {
                                return;
                            }
                        }
                        if (!root.schema) return;
                        baseId = getFullPath(this._getId(root.schema));
                    }
                    return getJsonPointer.call(this, p, baseId, root.schema, root);
                }


                /* @this Ajv */
                function resolveRecursive(root, ref, parsedRef) {
                    /* jshint validthis: true */
                    var res = resolveSchema.call(this, root, ref);
                    if (res) {
                        var schema = res.schema;
                        var baseId = res.baseId;
                        root = res.root;
                        var id = this._getId(schema);
                        if (id) baseId = resolveUrl(baseId, id);
                        return getJsonPointer.call(this, parsedRef, baseId, schema, root);
                    }
                }


                var PREVENT_SCOPE_CHANGE = util.toHash(['properties', 'patternProperties', 'enum', 'dependencies', 'definitions']);

                /* @this Ajv */
                function getJsonPointer(parsedRef, baseId, schema, root) {
                    /* jshint validthis: true */
                    parsedRef.fragment = parsedRef.fragment || '';
                    if (parsedRef.fragment.slice(0, 1) != '/') return;
                    var parts = parsedRef.fragment.split('/');

                    for (var i = 1; i < parts.length; i++) {
                        var part = parts[i];
                        if (part) {
                            part = util.unescapeFragment(part);
                            schema = schema[part];
                            if (schema === undefined) break;
                            var id;
                            if (!PREVENT_SCOPE_CHANGE[part]) {
                                id = this._getId(schema);
                                if (id) baseId = resolveUrl(baseId, id);
                                if (schema.$ref) {
                                    var $ref = resolveUrl(baseId, schema.$ref);
                                    var res = resolveSchema.call(this, root, $ref);
                                    if (res) {
                                        schema = res.schema;
                                        root = res.root;
                                        baseId = res.baseId;
                                    }
                                }
                            }
                        }
                    }
                    if (schema !== undefined && schema !== root.schema)
                        return {schema: schema, root: root, baseId: baseId};
                }


                var SIMPLE_INLINED = util.toHash([
                    'type', 'format', 'pattern',
                    'maxLength', 'minLength',
                    'maxProperties', 'minProperties',
                    'maxItems', 'minItems',
                    'maximum', 'minimum',
                    'uniqueItems', 'multipleOf',
                    'required', 'enum'
                ]);

                function inlineRef(schema, limit) {
                    if (limit === false) return false;
                    if (limit === undefined || limit === true) return checkNoRef(schema);
                    else if (limit) return countKeys(schema) <= limit;
                }


                function checkNoRef(schema) {
                    var item;
                    if (Array.isArray(schema)) {
                        for (var i = 0; i < schema.length; i++) {
                            item = schema[i];
                            if (typeof item == 'object' && !checkNoRef(item)) return false;
                        }
                    } else {
                        for (var key in schema) {
                            if (key == '$ref') return false;
                            item = schema[key];
                            if (typeof item == 'object' && !checkNoRef(item)) return false;
                        }
                    }
                    return true;
                }


                function countKeys(schema) {
                    var count = 0, item;
                    if (Array.isArray(schema)) {
                        for (var i = 0; i < schema.length; i++) {
                            item = schema[i];
                            if (typeof item == 'object') count += countKeys(item);
                            if (count == Infinity) return Infinity;
                        }
                    } else {
                        for (var key in schema) {
                            if (key == '$ref') return Infinity;
                            if (SIMPLE_INLINED[key]) {
                                count++;
                            } else {
                                item = schema[key];
                                if (typeof item == 'object') count += countKeys(item) + 1;
                                if (count == Infinity) return Infinity;
                            }
                        }
                    }
                    return count;
                }


                function getFullPath(id, normalize) {
                    if (normalize !== false) id = normalizeId(id);
                    var p = URI.parse(id);
                    return _getFullPath(p);
                }


                function _getFullPath(p) {
                    return URI.serialize(p).split('#')[0] + '#';
                }


                var TRAILING_SLASH_HASH = /#\/?$/;

                function normalizeId(id) {
                    return id ? id.replace(TRAILING_SLASH_HASH, '') : '';
                }


                function resolveUrl(baseId, id) {
                    id = normalizeId(id);
                    return URI.resolve(baseId, id);
                }


                /* @this Ajv */
                function resolveIds(schema) {
                    var schemaId = normalizeId(this._getId(schema));
                    var baseIds = {'': schemaId};
                    var fullPaths = {'': getFullPath(schemaId, false)};
                    var localRefs = {};
                    var self = this;

                    traverse(schema, {allKeys: true}, function (sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
                        if (jsonPtr === '') return;
                        var id = self._getId(sch);
                        var baseId = baseIds[parentJsonPtr];
                        var fullPath = fullPaths[parentJsonPtr] + '/' + parentKeyword;
                        if (keyIndex !== undefined)
                            fullPath += '/' + (typeof keyIndex == 'number' ? keyIndex : util.escapeFragment(keyIndex));

                        if (typeof id == 'string') {
                            id = baseId = normalizeId(baseId ? URI.resolve(baseId, id) : id);

                            var refVal = self._refs[id];
                            if (typeof refVal == 'string') refVal = self._refs[refVal];
                            if (refVal && refVal.schema) {
                                if (!equal(sch, refVal.schema))
                                    throw new Error('id "' + id + '" resolves to more than one schema');
                            } else if (id != normalizeId(fullPath)) {
                                if (id[0] == '#') {
                                    if (localRefs[id] && !equal(sch, localRefs[id]))
                                        throw new Error('id "' + id + '" resolves to more than one schema');
                                    localRefs[id] = sch;
                                } else {
                                    self._refs[id] = fullPath;
                                }
                            }
                        }
                        baseIds[jsonPtr] = baseId;
                        fullPaths[jsonPtr] = fullPath;
                    });

                    return localRefs;
                }


                /***/
            }),
            /* 18 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


// do not edit .js files directly - edit src/index.jst


                module.exports = function equal(a, b) {
                    if (a === b) return true;

                    if (a && b && typeof a == 'object' && typeof b == 'object') {
                        if (a.constructor !== b.constructor) return false;

                        var length, i, keys;
                        if (Array.isArray(a)) {
                            length = a.length;
                            if (length != b.length) return false;
                            for (i = length; i-- !== 0;)
                                if (!equal(a[i], b[i])) return false;
                            return true;
                        }


                        if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
                        if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
                        if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

                        keys = Object.keys(a);
                        length = keys.length;
                        if (length !== Object.keys(b).length) return false;

                        for (i = length; i-- !== 0;)
                            if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

                        for (i = length; i-- !== 0;) {
                            var key = keys[i];

                            if (!equal(a[key], b[key])) return false;
                        }

                        return true;
                    }

                    // true if both NaN, false otherwise
                    return a !== a && b !== b;
                };


                /***/
            }),
            /* 19 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                var resolve = __webpack_require__(17);

                module.exports = {
                    Validation: errorSubclass(ValidationError),
                    MissingRef: errorSubclass(MissingRefError)
                };


                function ValidationError(errors) {
                    this.message = 'validation failed';
                    this.errors = errors;
                    this.ajv = this.validation = true;
                }


                MissingRefError.message = function (baseId, ref) {
                    return 'can\'t resolve reference ' + ref + ' from id ' + baseId;
                };


                function MissingRefError(baseId, ref, message) {
                    this.message = message || MissingRefError.message(baseId, ref);
                    this.missingRef = resolve.url(baseId, ref);
                    this.missingSchema = resolve.normalizeId(resolve.fullPath(this.missingRef));
                }


                function errorSubclass(Subclass) {
                    Subclass.prototype = Object.create(Error.prototype);
                    Subclass.prototype.constructor = Subclass;
                    return Subclass;
                }


                /***/
            }),
            /* 20 */
            /***/ (function (module, exports, __webpack_require__) {

                var ace;

                if (window.ace) {
                    // use the already loaded instance of Ace
                    ace = window.ace;
                } else {
                    try {
                        // load Ace editor
                        ace = __webpack_require__(37); // load required Ace plugins

                        __webpack_require__(38);

                        __webpack_require__(39); // embed Ace json worker
                        // https://github.com/ajaxorg/ace/issues/3913


                        var jsonWorkerDataUrl = __webpack_require__(40);

                        ace.config.setModuleUrl('ace/mode/json_worker', jsonWorkerDataUrl);
                    } catch (err) {// failed to load Ace (can be minimalist bundle).
                        // No worries, the editor will fall back to plain text if needed.
                    }
                }

                module.exports = ace;

                /***/
            }),
            /* 21 */
            /***/ (function (module, __webpack_exports__, __webpack_require__) {

                "use strict";
// ESM COMPAT FLAG
                __webpack_require__.r(__webpack_exports__);

// EXPORTS
                __webpack_require__.d(__webpack_exports__, "textModeMixins", function () {
                    return /* binding */ textModeMixins;
                });

// EXTERNAL MODULE: ./src/js/ace/index.js
                var ace = __webpack_require__(20);
                var ace_default = /*#__PURE__*/__webpack_require__.n(ace);

// EXTERNAL MODULE: ./src/js/i18n.js
                var i18n = __webpack_require__(1);

// EXTERNAL MODULE: ./src/js/ModeSwitcher.js
                var ModeSwitcher = __webpack_require__(8);

// EXTERNAL MODULE: ./src/js/ErrorTable.js
                var ErrorTable = __webpack_require__(15);

// EXTERNAL MODULE: ./src/js/util.js
                var util = __webpack_require__(0);

// CONCATENATED MODULE: ./src/js/validationUtils.js

                /**
                 * Execute custom validation if configured.
                 *
                 * Returns a promise resolving with the custom errors (or an empty array).
                 */

                function validateCustom(json, onValidate) {
                    if (!onValidate) {
                        return Promise.resolve([]);
                    }

                    try {
                        var customValidateResults = onValidate(json);
                        var resultPromise = Object(util["isPromise"])(customValidateResults) ? customValidateResults : Promise.resolve(customValidateResults);
                        return resultPromise.then(function (customValidationPathErrors) {
                            if (Array.isArray(customValidationPathErrors)) {
                                return customValidationPathErrors.filter(function (error) {
                                    var valid = Object(util["isValidValidationError"])(error);

                                    if (!valid) {
                                        console.warn('Ignoring a custom validation error with invalid structure. ' + 'Expected structure: {path: [...], message: "..."}. ' + 'Actual error:', error);
                                    }

                                    return valid;
                                }).map(function (error) {
                                    return (// change data structure into the structure matching the JSON schema errors
                                        {
                                            dataPath: Object(util["stringifyPath"])(error.path),
                                            message: error.message,
                                            type: 'customValidation'
                                        }
                                    );
                                });
                            } else {
                                return [];
                            }
                        });
                    } catch (err) {
                        return Promise.reject(err);
                    }
                }

// EXTERNAL MODULE: ./src/js/showSortModal.js
                var showSortModal = __webpack_require__(5);

// EXTERNAL MODULE: ./src/js/showTransformModal.js + 1 modules
                var showTransformModal = __webpack_require__(6);

// EXTERNAL MODULE: ./src/js/FocusTracker.js
                var FocusTracker = __webpack_require__(9);

// EXTERNAL MODULE: ./src/js/constants.js
                var constants = __webpack_require__(2);

// EXTERNAL MODULE: ./src/js/tryRequireThemeJsonEditor.js
                var tryRequireThemeJsonEditor = __webpack_require__(35);

// EXTERNAL MODULE: ./src/js/jmespathQuery.js
                var jmespathQuery = __webpack_require__(4);

// CONCATENATED MODULE: ./src/js/textmode.js


                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }


                // create a mixin with the functions for text mode

                var textmode = {};
                var DEFAULT_THEME = 'ace/theme/jsoneditor';
                /**
                 * Create a text editor
                 * @param {Element} container
                 * @param {Object} [options]   Object with options. See docs for details.
                 * @private
                 */

                textmode.create = function (container) {
                    var _this = this;

                    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

                    if (typeof options.statusBar === 'undefined') {
                        options.statusBar = true;
                    } // setting default for textmode


                    options.mainMenuBar = options.mainMenuBar !== false;
                    options.enableSort = options.enableSort !== false;
                    options.enableTransform = options.enableTransform !== false;
                    options.createQuery = options.createQuery || jmespathQuery["a" /* createQuery */];
                    options.executeQuery = options.executeQuery || jmespathQuery["b" /* executeQuery */];
                    this.options = options; // indentation

                    if (typeof options.indentation === 'number') {
                        this.indentation = Number(options.indentation);
                    } else {
                        this.indentation = 2; // number of spaces
                    } // grab ace from options if provided


                    var _ace = options.ace ? options.ace : ace_default.a; // TODO: make the option options.ace deprecated, it's not needed anymore (see #309)
                    // determine mode


                    this.mode = options.mode === 'code' ? 'code' : 'text';

                    if (this.mode === 'code') {
                        // verify whether Ace editor is available and supported
                        if (typeof _ace === 'undefined') {
                            this.mode = 'text';
                            console.warn('Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.');
                        }
                    } // determine theme


                    this.theme = options.theme || DEFAULT_THEME;

                    if (this.theme === DEFAULT_THEME && _ace) {
                        Object(tryRequireThemeJsonEditor["tryRequireThemeJsonEditor"])();
                    }

                    if (options.onTextSelectionChange) {
                        this.onTextSelectionChange(options.onTextSelectionChange);
                    }

                    var me = this;
                    this.container = container;
                    this.dom = {};
                    this.aceEditor = undefined; // ace code editor

                    this.textarea = undefined; // plain text editor (fallback when Ace is not available)

                    this.validateSchema = null;
                    this.annotations = [];
                    this.lastSchemaErrors = undefined; // create a debounced validate function

                    this._debouncedValidate = Object(util["debounce"])(this.validate.bind(this), this.DEBOUNCE_INTERVAL);
                    this.width = container.clientWidth;
                    this.height = container.clientHeight;
                    this.frame = document.createElement('div');
                    this.frame.className = 'jsoneditor jsoneditor-mode-' + this.options.mode;

                    this.frame.onclick = function (event) {
                        // prevent default submit action when the editor is located inside a form
                        event.preventDefault();
                    };

                    this.frame.onkeydown = function (event) {
                        me._onKeyDown(event);
                    }; // setting the FocusTracker on 'this.frame' to track the editor's focus event


                    var focusTrackerConfig = {
                        target: this.frame,
                        onFocus: this.options.onFocus || null,
                        onBlur: this.options.onBlur || null
                    };
                    this.frameFocusTracker = new FocusTracker["a" /* FocusTracker */](focusTrackerConfig);
                    this.content = document.createElement('div');
                    this.content.className = 'jsoneditor-outer';

                    if (this.options.mainMenuBar) {
                        Object(util["addClassName"])(this.content, 'has-main-menu-bar'); // create menu

                        this.menu = document.createElement('div');
                        this.menu.className = 'jsoneditor-menu';
                        this.frame.appendChild(this.menu); // create format button

                        var buttonFormat = document.createElement('button');
                        buttonFormat.type = 'button';
                        buttonFormat.className = 'jsoneditor-format';
                        buttonFormat.title = Object(i18n["c" /* translate */])('formatTitle');
                        this.menu.appendChild(buttonFormat);

                        buttonFormat.onclick = function () {
                            try {
                                me.format();

                                me._onChange();
                            } catch (err) {
                                me._onError(err);
                            }
                        }; // create compact button


                        var buttonCompact = document.createElement('button');
                        buttonCompact.type = 'button';
                        buttonCompact.className = 'jsoneditor-compact';
                        buttonCompact.title = Object(i18n["c" /* translate */])('compactTitle');
                        this.menu.appendChild(buttonCompact);

                        buttonCompact.onclick = function () {
                            try {
                                me.compact();

                                me._onChange();
                            } catch (err) {
                                me._onError(err);
                            }
                        }; // create sort button


                        if (this.options.enableSort) {
                            var _sort = document.createElement('button');

                            _sort.type = 'button';
                            _sort.className = 'jsoneditor-sort';
                            _sort.title = Object(i18n["c" /* translate */])('sortTitleShort');

                            _sort.onclick = function () {
                                me._showSortModal();
                            };

                            this.menu.appendChild(_sort);
                        } // create transform button


                        if (this.options.enableTransform) {
                            var transform = document.createElement('button');
                            transform.type = 'button';
                            transform.title = Object(i18n["c" /* translate */])('transformTitleShort');
                            transform.className = 'jsoneditor-transform';

                            transform.onclick = function () {
                                me._showTransformModal();
                            };

                            this.menu.appendChild(transform);
                        } // create repair button


                        var buttonRepair = document.createElement('button');
                        buttonRepair.type = 'button';
                        buttonRepair.className = 'jsoneditor-repair';
                        buttonRepair.title = Object(i18n["c" /* translate */])('repairTitle');
                        this.menu.appendChild(buttonRepair);

                        buttonRepair.onclick = function () {
                            try {
                                me.repair();

                                me._onChange();
                            } catch (err) {
                                me._onError(err);
                            }
                        }; // create undo/redo buttons


                        if (this.mode === 'code') {
                            // create undo button
                            var undo = document.createElement('button');
                            undo.type = 'button';
                            undo.className = 'jsoneditor-undo jsoneditor-separator';
                            undo.title = Object(i18n["c" /* translate */])('undo');

                            undo.onclick = function () {
                                _this.aceEditor.getSession().getUndoManager().undo();
                            };

                            this.menu.appendChild(undo);
                            this.dom.undo = undo; // create redo button

                            var redo = document.createElement('button');
                            redo.type = 'button';
                            redo.className = 'jsoneditor-redo';
                            redo.title = Object(i18n["c" /* translate */])('redo');

                            redo.onclick = function () {
                                _this.aceEditor.getSession().getUndoManager().redo();
                            };

                            this.menu.appendChild(redo);
                            this.dom.redo = redo;
                        } // create mode box


                        if (this.options && this.options.modes && this.options.modes.length) {
                            this.modeSwitcher = new ModeSwitcher["a" /* ModeSwitcher */](this.menu, this.options.modes, this.options.mode, function onSwitch(mode) {
                                // switch mode and restore focus
                                me.setMode(mode);
                                me.modeSwitcher.focus();
                            });
                        }

                        if (this.mode === 'code') {
                            var poweredBy = document.createElement('a');
                            poweredBy.appendChild(document.createTextNode('powered by ace'));
                            poweredBy.href = 'http://ace.ajax.org';
                            poweredBy.target = '_blank';
                            poweredBy.className = 'jsoneditor-poweredBy';

                            poweredBy.onclick = function () {
                                // TODO: this anchor falls below the margin of the content,
                                // therefore the normal a.href does not work. We use a click event
                                // for now, but this should be fixed.
                                window.open(poweredBy.href, poweredBy.target);
                            };

                            this.menu.appendChild(poweredBy);
                        }
                    }

                    var emptyNode = {};
                    var isReadOnly = this.options.onEditable && _typeof(this.options.onEditable === 'function') && !this.options.onEditable(emptyNode);
                    this.frame.appendChild(this.content);
                    this.container.appendChild(this.frame);

                    if (this.mode === 'code') {
                        this.editorDom = document.createElement('div');
                        this.editorDom.style.height = '100%'; // TODO: move to css

                        this.editorDom.style.width = '100%'; // TODO: move to css

                        this.content.appendChild(this.editorDom);

                        var aceEditor = _ace.edit(this.editorDom);

                        var aceSession = aceEditor.getSession();
                        aceEditor.$blockScrolling = Infinity;
                        aceEditor.setTheme(this.theme);
                        aceEditor.setOptions({
                            readOnly: isReadOnly
                        });
                        aceEditor.setShowPrintMargin(false);
                        aceEditor.setFontSize('13px');
                        aceSession.setMode('ace/mode/json');
                        aceSession.setTabSize(this.indentation);
                        aceSession.setUseSoftTabs(true);
                        aceSession.setUseWrapMode(true); // replace ace setAnnotations with custom function that also covers jsoneditor annotations

                        var originalSetAnnotations = aceSession.setAnnotations;

                        aceSession.setAnnotations = function (annotations) {
                            originalSetAnnotations.call(this, annotations && annotations.length ? annotations : me.annotations);
                        };

                        aceEditor.commands.bindKey('Ctrl-L', null); // disable Ctrl+L (is used by the browser to select the address bar)

                        aceEditor.commands.bindKey('Command-L', null); // disable Ctrl+L (is used by the browser to select the address bar)

                        this.aceEditor = aceEditor; // register onchange event

                        aceEditor.on('change', this._onChange.bind(this));
                        aceEditor.on('changeSelection', this._onSelect.bind(this));
                    } else {
                        // load a plain text textarea
                        var textarea = document.createElement('textarea');
                        textarea.className = 'jsoneditor-text';
                        textarea.spellcheck = false;
                        this.content.appendChild(textarea);
                        this.textarea = textarea;
                        this.textarea.readOnly = isReadOnly; // register onchange event

                        if (this.textarea.oninput === null) {
                            this.textarea.oninput = this._onChange.bind(this);
                        } else {
                            // oninput is undefined. For IE8-
                            this.textarea.onchange = this._onChange.bind(this);
                        }

                        textarea.onselect = this._onSelect.bind(this);
                        textarea.onmousedown = this._onMouseDown.bind(this);
                        textarea.onblur = this._onBlur.bind(this);
                    }

                    this._updateHistoryButtons();

                    this.errorTable = new ErrorTable["a" /* ErrorTable */]({
                        errorTableVisible: this.mode === 'text',
                        onToggleVisibility: function onToggleVisibility() {
                            me.validate();
                        },
                        onFocusLine: function onFocusLine(line) {
                            me.isFocused = true;

                            if (!isNaN(line)) {
                                me.setTextSelection({
                                    row: line,
                                    column: 1
                                }, {
                                    row: line,
                                    column: 1000
                                });
                            }
                        },
                        onChangeHeight: function onChangeHeight(height) {
                            // TODO: change CSS to using flex box, remove setting height using JavaScript
                            var statusBarHeight = me.dom.statusBar ? me.dom.statusBar.clientHeight : 0;
                            var totalHeight = height + statusBarHeight + 1;
                            me.content.style.marginBottom = -totalHeight + 'px';
                            me.content.style.paddingBottom = totalHeight + 'px';
                        }
                    });
                    this.frame.appendChild(this.errorTable.getErrorTable());

                    if (options.statusBar) {
                        Object(util["addClassName"])(this.content, 'has-status-bar');
                        this.curserInfoElements = {};
                        var statusBar = document.createElement('div');
                        this.dom.statusBar = statusBar;
                        statusBar.className = 'jsoneditor-statusbar';
                        this.frame.appendChild(statusBar);
                        var lnLabel = document.createElement('span');
                        lnLabel.className = 'jsoneditor-curserinfo-label';
                        lnLabel.innerText = 'Ln:';
                        var lnVal = document.createElement('span');
                        lnVal.className = 'jsoneditor-curserinfo-val';
                        lnVal.innerText = '1';
                        statusBar.appendChild(lnLabel);
                        statusBar.appendChild(lnVal);
                        var colLabel = document.createElement('span');
                        colLabel.className = 'jsoneditor-curserinfo-label';
                        colLabel.innerText = 'Col:';
                        var colVal = document.createElement('span');
                        colVal.className = 'jsoneditor-curserinfo-val';
                        colVal.innerText = '1';
                        statusBar.appendChild(colLabel);
                        statusBar.appendChild(colVal);
                        this.curserInfoElements.colVal = colVal;
                        this.curserInfoElements.lnVal = lnVal;
                        var countLabel = document.createElement('span');
                        countLabel.className = 'jsoneditor-curserinfo-label';
                        countLabel.innerText = 'characters selected';
                        countLabel.style.display = 'none';
                        var countVal = document.createElement('span');
                        countVal.className = 'jsoneditor-curserinfo-count';
                        countVal.innerText = '0';
                        countVal.style.display = 'none';
                        this.curserInfoElements.countLabel = countLabel;
                        this.curserInfoElements.countVal = countVal;
                        statusBar.appendChild(countVal);
                        statusBar.appendChild(countLabel);
                        statusBar.appendChild(this.errorTable.getErrorCounter());
                        statusBar.appendChild(this.errorTable.getWarningIcon());
                        statusBar.appendChild(this.errorTable.getErrorIcon());
                    }

                    this.setSchema(this.options.schema, this.options.schemaRefs);
                };
                /**
                 * Handle a change:
                 * - Validate JSON schema
                 * - Send a callback to the onChange listener if provided
                 * @private
                 */


                textmode._onChange = function () {
                    var _this2 = this;

                    if (this.onChangeDisabled) {
                        return;
                    } // enable/disable undo/redo buttons


                    setTimeout(function () {
                        return _this2._updateHistoryButtons();
                    }); // validate JSON schema (if configured)

                    this._debouncedValidate(); // trigger the onChange callback


                    if (this.options.onChange) {
                        try {
                            this.options.onChange();
                        } catch (err) {
                            console.error('Error in onChange callback: ', err);
                        }
                    } // trigger the onChangeText callback


                    if (this.options.onChangeText) {
                        try {
                            this.options.onChangeText(this.getText());
                        } catch (err) {
                            console.error('Error in onChangeText callback: ', err);
                        }
                    }
                };

                textmode._updateHistoryButtons = function () {
                    if (this.aceEditor && this.dom.undo && this.dom.redo) {
                        var undoManager = this.aceEditor.getSession().getUndoManager();

                        if (undoManager && undoManager.hasUndo && undoManager.hasRedo) {
                            this.dom.undo.disabled = !undoManager.hasUndo();
                            this.dom.redo.disabled = !undoManager.hasRedo();
                        }
                    }
                };
                /**
                 * Open a sort modal
                 * @private
                 */


                textmode._showSortModal = function () {
                    var me = this;
                    var container = this.options.modalAnchor || constants["a" /* DEFAULT_MODAL_ANCHOR */];
                    var json = this.get();

                    function onSort(sortedBy) {
                        if (Array.isArray(json)) {
                            var sortedJson = Object(util["sort"])(json, sortedBy.path, sortedBy.direction);
                            me.sortedBy = sortedBy;
                            me.update(sortedJson);
                        }

                        if (Object(util["isObject"])(json)) {
                            var _sortedJson = Object(util["sortObjectKeys"])(json, sortedBy.direction);

                            me.sortedBy = sortedBy;
                            me.update(_sortedJson);
                        }
                    }

                    Object(showSortModal["showSortModal"])(container, json, onSort, me.sortedBy);
                };
                /**
                 * Open a transform modal
                 * @private
                 */


                textmode._showTransformModal = function () {
                    var _this3 = this;

                    var _this$options = this.options,
                        modalAnchor = _this$options.modalAnchor,
                        createQuery = _this$options.createQuery,
                        executeQuery = _this$options.executeQuery,
                        queryDescription = _this$options.queryDescription;
                    var json = this.get();
                    Object(showTransformModal["showTransformModal"])({
                        anchor: modalAnchor || constants["a" /* DEFAULT_MODAL_ANCHOR */],
                        json: json,
                        queryDescription: queryDescription,
                        // can be undefined
                        createQuery: createQuery,
                        executeQuery: executeQuery,
                        onTransform: function onTransform(query) {
                            var updatedJson = executeQuery(json, query);

                            _this3.update(updatedJson);
                        }
                    });
                };
                /**
                 * Handle text selection
                 * Calculates the cursor position and selection range and updates menu
                 * @private
                 */


                textmode._onSelect = function () {
                    this._updateCursorInfo();

                    this._emitSelectionChange();
                };
                /**
                 * Event handler for keydown. Handles shortcut keys
                 * @param {Event} event
                 * @private
                 */


                textmode._onKeyDown = function (event) {
                    var keynum = event.which || event.keyCode;
                    var handled = false;

                    if (keynum === 220 && event.ctrlKey) {
                        if (event.shiftKey) {
                            // Ctrl+Shift+\
                            this.compact();

                            this._onChange();
                        } else {
                            // Ctrl+\
                            this.format();

                            this._onChange();
                        }

                        handled = true;
                    }

                    if (handled) {
                        event.preventDefault();
                        event.stopPropagation();
                    }

                    this._updateCursorInfo();

                    this._emitSelectionChange();
                };
                /**
                 * Event handler for mousedown.
                 * @private
                 */


                textmode._onMouseDown = function () {
                    this._updateCursorInfo();

                    this._emitSelectionChange();
                };
                /**
                 * Event handler for blur.
                 * @private
                 */


                textmode._onBlur = function () {
                    var me = this; // this allows to avoid blur when clicking inner elements (like the errors panel)
                    // just make sure to set the isFocused to true on the inner element onclick callback

                    setTimeout(function () {
                        if (!me.isFocused) {
                            me._updateCursorInfo();

                            me._emitSelectionChange();
                        }

                        me.isFocused = false;
                    });
                };
                /**
                 * Update the cursor info and the status bar, if presented
                 */


                textmode._updateCursorInfo = function () {
                    var me = this;
                    var line, col, count;

                    if (this.textarea) {
                        setTimeout(function () {
                            // this to verify we get the most updated textarea cursor selection
                            var selectionRange = Object(util["getInputSelection"])(me.textarea);

                            if (selectionRange.startIndex !== selectionRange.endIndex) {
                                count = selectionRange.endIndex - selectionRange.startIndex;
                            }

                            if (count && me.cursorInfo && me.cursorInfo.line === selectionRange.end.row && me.cursorInfo.column === selectionRange.end.column) {
                                line = selectionRange.start.row;
                                col = selectionRange.start.column;
                            } else {
                                line = selectionRange.end.row;
                                col = selectionRange.end.column;
                            }

                            me.cursorInfo = {
                                line: line,
                                column: col,
                                count: count
                            };

                            if (me.options.statusBar) {
                                updateDisplay();
                            }
                        }, 0);
                    } else if (this.aceEditor && this.curserInfoElements) {
                        var curserPos = this.aceEditor.getCursorPosition();
                        var selectedText = this.aceEditor.getSelectedText();
                        line = curserPos.row + 1;
                        col = curserPos.column + 1;
                        count = selectedText.length;
                        me.cursorInfo = {
                            line: line,
                            column: col,
                            count: count
                        };

                        if (this.options.statusBar) {
                            updateDisplay();
                        }
                    }

                    function updateDisplay() {
                        if (me.curserInfoElements.countVal.innerText !== count) {
                            me.curserInfoElements.countVal.innerText = count;
                            me.curserInfoElements.countVal.style.display = count ? 'inline' : 'none';
                            me.curserInfoElements.countLabel.style.display = count ? 'inline' : 'none';
                        }

                        me.curserInfoElements.lnVal.innerText = line;
                        me.curserInfoElements.colVal.innerText = col;
                    }
                };
                /**
                 * emits selection change callback, if given
                 * @private
                 */


                textmode._emitSelectionChange = function () {
                    if (this._selectionChangedHandler) {
                        var currentSelection = this.getTextSelection();

                        this._selectionChangedHandler(currentSelection.start, currentSelection.end, currentSelection.text);
                    }
                };
                /**
                 * refresh ERROR annotations state
                 * error annotations are handled by the ace json mode (ace/mode/json)
                 * validation annotations are handled by this mode
                 * therefore in order to refresh we send only the annotations of error type in order to maintain its state
                 * @private
                 */


                textmode._refreshAnnotations = function () {
                    var session = this.aceEditor && this.aceEditor.getSession();

                    if (session) {
                        var errEnnotations = session.getAnnotations().filter(function (annotation) {
                            return annotation.type === 'error';
                        });
                        session.setAnnotations(errEnnotations);
                    }
                };
                /**
                 * Destroy the editor. Clean up DOM, event listeners, and web workers.
                 */


                textmode.destroy = function () {
                    // remove old ace editor
                    if (this.aceEditor) {
                        this.aceEditor.destroy();
                        this.aceEditor = null;
                    }

                    if (this.frame && this.container && this.frame.parentNode === this.container) {
                        this.container.removeChild(this.frame);
                    }

                    if (this.modeSwitcher) {
                        this.modeSwitcher.destroy();
                        this.modeSwitcher = null;
                    }

                    this.textarea = null;
                    this._debouncedValidate = null; // Removing the FocusTracker set to track the editor's focus event

                    this.frameFocusTracker.destroy();
                };
                /**
                 * Compact the code in the text editor
                 */


                textmode.compact = function () {
                    var json = this.get();
                    var text = JSON.stringify(json);
                    this.updateText(text);
                };
                /**
                 * Format the code in the text editor
                 */


                textmode.format = function () {
                    var json = this.get();
                    var text = JSON.stringify(json, null, this.indentation);
                    this.updateText(text);
                };
                /**
                 * Repair the code in the text editor
                 */


                textmode.repair = function () {
                    var text = this.getText();
                    var repairedText = Object(util["repair"])(text);
                    this.updateText(repairedText);
                };
                /**
                 * Set focus to the formatter
                 */


                textmode.focus = function () {
                    if (this.textarea) {
                        this.textarea.focus();
                    }

                    if (this.aceEditor) {
                        this.aceEditor.focus();
                    }
                };
                /**
                 * Resize the formatter
                 */


                textmode.resize = function () {
                    if (this.aceEditor) {
                        var force = false;
                        this.aceEditor.resize(force);
                    }
                };
                /**
                 * Set json data in the formatter
                 * @param {*} json
                 */


                textmode.set = function (json) {
                    this.setText(JSON.stringify(json, null, this.indentation));
                };
                /**
                 * Update data. Same as calling `set` in text/code mode.
                 * @param {*} json
                 */


                textmode.update = function (json) {
                    this.updateText(JSON.stringify(json, null, this.indentation));
                };
                /**
                 * Get json data from the formatter
                 * @return {*} json
                 */


                textmode.get = function () {
                    var text = this.getText();
                    return Object(util["parse"])(text); // this can throw an error
                };
                /**
                 * Get the text contents of the editor
                 * @return {String} jsonText
                 */


                textmode.getText = function () {
                    if (this.textarea) {
                        return this.textarea.value;
                    }

                    if (this.aceEditor) {
                        return this.aceEditor.getValue();
                    }

                    return '';
                };
                /**
                 * Set the text contents of the editor and optionally clear the history
                 * @param {String} jsonText
                 * @param {boolean} clearHistory   Only applicable for mode 'code'
                 * @private
                 */


                textmode._setText = function (jsonText, clearHistory) {
                    var _this4 = this;

                    var text = this.options.escapeUnicode === true ? Object(util["escapeUnicodeChars"])(jsonText) : jsonText;

                    if (this.textarea) {
                        this.textarea.value = text;
                    }

                    if (this.aceEditor) {
                        // prevent emitting onChange events while setting new text
                        this.onChangeDisabled = true;
                        this.aceEditor.setValue(text, -1);
                        this.onChangeDisabled = false;

                        if (clearHistory) {
                            // prevent initial undo action clearing the initial contents
                            var me = this;
                            setTimeout(function () {
                                if (me.aceEditor) {
                                    me.aceEditor.session.getUndoManager().reset();
                                }
                            });
                        }

                        setTimeout(function () {
                            return _this4._updateHistoryButtons();
                        });
                    } // validate JSON schema


                    this._debouncedValidate();
                };
                /**
                 * Set the text contents of the editor
                 * @param {String} jsonText
                 */


                textmode.setText = function (jsonText) {
                    this._setText(jsonText, true);
                };
                /**
                 * Update the text contents
                 * @param {string} jsonText
                 */


                textmode.updateText = function (jsonText) {
                    // don't update if there are no changes
                    if (this.getText() === jsonText) {
                        return;
                    }

                    this._setText(jsonText, false);
                };
                /**
                 * Validate current JSON object against the configured JSON schema
                 * Throws an exception when no JSON schema is configured
                 */


                textmode.validate = function () {
                    var _this5 = this;

                    var schemaErrors = [];
                    var parseErrors = [];
                    var json;

                    try {
                        json = this.get(); // this can fail when there is no valid json
                        // execute JSON schema validation (ajv)

                        if (this.validateSchema) {
                            var valid = this.validateSchema(json);

                            if (!valid) {
                                schemaErrors = this.validateSchema.errors.map(function (error) {
                                    error.type = 'validation';
                                    return Object(util["improveSchemaError"])(error);
                                });
                            }
                        } // execute custom validation and after than merge and render all errors
                        // TODO: implement a better mechanism for only using the last validation action


                        this.validationSequence = (this.validationSequence || 0) + 1;
                        var me = this;
                        var seq = this.validationSequence;
                        validateCustom(json, this.options.onValidate).then(function (customValidationErrors) {
                            // only apply when there was no other validation started whilst resolving async results
                            if (seq === me.validationSequence) {
                                var errors = schemaErrors.concat(parseErrors).concat(customValidationErrors);

                                me._renderErrors(errors);

                                if (typeof _this5.options.onValidationError === 'function') {
                                    if (Object(util["isValidationErrorChanged"])(errors, _this5.lastSchemaErrors)) {
                                        _this5.options.onValidationError.call(_this5, errors);
                                    }

                                    _this5.lastSchemaErrors = errors;
                                }
                            }
                        })["catch"](function (err) {
                            console.error('Custom validation function did throw an error', err);
                        });
                    } catch (err) {
                        if (this.getText()) {
                            // try to extract the line number from the jsonlint error message
                            var match = /\w*line\s*(\d+)\w*/g.exec(err.message);
                            var line;

                            if (match) {
                                line = +match[1];
                            }

                            parseErrors = [{
                                type: 'error',
                                message: err.message.replace(/\n/g, '<br>'),
                                line: line
                            }];
                        }

                        this._renderErrors(parseErrors);

                        if (typeof this.options.onValidationError === 'function') {
                            if (Object(util["isValidationErrorChanged"])(parseErrors, this.lastSchemaErrors)) {
                                this.options.onValidationError.call(this, parseErrors);
                            }

                            this.lastSchemaErrors = parseErrors;
                        }
                    }
                };

                textmode._renderErrors = function (errors) {
                    var jsonText = this.getText();
                    var errorPaths = [];
                    errors.reduce(function (acc, curr) {
                        if (typeof curr.dataPath === 'string' && acc.indexOf(curr.dataPath) === -1) {
                            acc.push(curr.dataPath);
                        }

                        return acc;
                    }, errorPaths);
                    var errorLocations = Object(util["getPositionForPath"])(jsonText, errorPaths); // render annotations in Ace Editor (if any)

                    if (this.aceEditor) {
                        this.annotations = errorLocations.map(function (errLoc) {
                            var validationErrors = errors.filter(function (err) {
                                return err.dataPath === errLoc.path;
                            });
                            var message = validationErrors.map(function (err) {
                                return err.message;
                            }).join('\n');

                            if (message) {
                                return {
                                    row: errLoc.line,
                                    column: errLoc.column,
                                    text: 'Schema validation error' + (validationErrors.length !== 1 ? 's' : '') + ': \n' + message,
                                    type: 'warning',
                                    source: 'jsoneditor'
                                };
                            }

                            return {};
                        });

                        this._refreshAnnotations();
                    } // render errors in the errors table (if any)


                    this.errorTable.setErrors(errors, errorLocations); // update the height of the ace editor

                    if (this.aceEditor) {
                        var force = false;
                        this.aceEditor.resize(force);
                    }
                };
                /**
                 * Get the selection details
                 * @returns {{start:{row:Number, column:Number},end:{row:Number, column:Number},text:String}}
                 */


                textmode.getTextSelection = function () {
                    var selection = {};

                    if (this.textarea) {
                        var selectionRange = Object(util["getInputSelection"])(this.textarea);

                        if (this.cursorInfo && this.cursorInfo.line === selectionRange.end.row && this.cursorInfo.column === selectionRange.end.column) {
                            // selection direction is bottom => up
                            selection.start = selectionRange.end;
                            selection.end = selectionRange.start;
                        } else {
                            selection = selectionRange;
                        }

                        return {
                            start: selection.start,
                            end: selection.end,
                            text: this.textarea.value.substring(selectionRange.startIndex, selectionRange.endIndex)
                        };
                    }

                    if (this.aceEditor) {
                        var aceSelection = this.aceEditor.getSelection();
                        var selectedText = this.aceEditor.getSelectedText();
                        var range = aceSelection.getRange();
                        var lead = aceSelection.getSelectionLead();

                        if (lead.row === range.end.row && lead.column === range.end.column) {
                            selection = range;
                        } else {
                            // selection direction is bottom => up
                            selection.start = range.end;
                            selection.end = range.start;
                        }

                        return {
                            start: {
                                row: selection.start.row + 1,
                                column: selection.start.column + 1
                            },
                            end: {
                                row: selection.end.row + 1,
                                column: selection.end.column + 1
                            },
                            text: selectedText
                        };
                    }
                };
                /**
                 * Callback registration for selection change
                 * @param {selectionCallback} callback
                 *
                 * @callback selectionCallback
                 */


                textmode.onTextSelectionChange = function (callback) {
                    if (typeof callback === 'function') {
                        this._selectionChangedHandler = Object(util["debounce"])(callback, this.DEBOUNCE_INTERVAL);
                    }
                };
                /**
                 * Set selection on editor's text
                 * @param {{row:Number, column:Number}} startPos selection start position
                 * @param {{row:Number, column:Number}} endPos selected end position
                 */


                textmode.setTextSelection = function (startPos, endPos) {
                    if (!startPos || !endPos) return;

                    if (this.textarea) {
                        var startIndex = Object(util["getIndexForPosition"])(this.textarea, startPos.row, startPos.column);
                        var endIndex = Object(util["getIndexForPosition"])(this.textarea, endPos.row, endPos.column);

                        if (startIndex > -1 && endIndex > -1) {
                            if (this.textarea.setSelectionRange) {
                                this.textarea.focus();
                                this.textarea.setSelectionRange(startIndex, endIndex);
                            } else if (this.textarea.createTextRange) {
                                // IE < 9
                                var range = this.textarea.createTextRange();
                                range.collapse(true);
                                range.moveEnd('character', endIndex);
                                range.moveStart('character', startIndex);
                                range.select();
                            }

                            var rows = (this.textarea.value.match(/\n/g) || []).length + 1;
                            var lineHeight = this.textarea.scrollHeight / rows;
                            var selectionScrollPos = startPos.row * lineHeight;
                            this.textarea.scrollTop = selectionScrollPos > this.textarea.clientHeight ? selectionScrollPos - this.textarea.clientHeight / 2 : 0;
                        }
                    } else if (this.aceEditor) {
                        var _range = {
                            start: {
                                row: startPos.row - 1,
                                column: startPos.column - 1
                            },
                            end: {
                                row: endPos.row - 1,
                                column: endPos.column - 1
                            }
                        };
                        this.aceEditor.selection.setRange(_range);
                        this.aceEditor.scrollToLine(startPos.row - 1, true);
                    }
                };

                function load() {
                    try {
                        this.format();
                    } catch (err) {// in case of an error, just move on, failing formatting is not a big deal
                    }
                } // define modes


                var textModeMixins = [{
                    mode: 'text',
                    mixin: textmode,
                    data: 'text',
                    load: load
                }, {
                    mode: 'code',
                    mixin: textmode,
                    data: 'text',
                    load: load
                }];

                /***/
            }),
            /* 22 */
            /***/ (function (module, exports, __webpack_require__) {

                /* Jison generated parser */
                var jsonlint = function () {
                    var parser = {
                        trace: function trace() {
                        },
                        yy: {},
                        symbols_: {
                            "error": 2,
                            "JSONString": 3,
                            "STRING": 4,
                            "JSONNumber": 5,
                            "NUMBER": 6,
                            "JSONNullLiteral": 7,
                            "NULL": 8,
                            "JSONBooleanLiteral": 9,
                            "TRUE": 10,
                            "FALSE": 11,
                            "JSONText": 12,
                            "JSONValue": 13,
                            "EOF": 14,
                            "JSONObject": 15,
                            "JSONArray": 16,
                            "{": 17,
                            "}": 18,
                            "JSONMemberList": 19,
                            "JSONMember": 20,
                            ":": 21,
                            ",": 22,
                            "[": 23,
                            "]": 24,
                            "JSONElementList": 25,
                            "$accept": 0,
                            "$end": 1
                        },
                        terminals_: {
                            2: "error",
                            4: "STRING",
                            6: "NUMBER",
                            8: "NULL",
                            10: "TRUE",
                            11: "FALSE",
                            14: "EOF",
                            17: "{",
                            18: "}",
                            21: ":",
                            22: ",",
                            23: "[",
                            24: "]"
                        },
                        productions_: [0, [3, 1], [5, 1], [7, 1], [9, 1], [9, 1], [12, 2], [13, 1], [13, 1], [13, 1], [13, 1], [13, 1], [13, 1], [15, 2], [15, 3], [20, 3], [19, 1], [19, 3], [16, 2], [16, 3], [25, 1], [25, 3]],
                        performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
                            var $0 = $$.length - 1;

                            switch (yystate) {
                                case 1:
                                    // replace escaped characters with actual character
                                    this.$ = yytext.replace(/\\(\\|")/g, "$" + "1").replace(/\\n/g, '\n').replace(/\\r/g, '\r').replace(/\\t/g, '\t').replace(/\\v/g, '\v').replace(/\\f/g, '\f').replace(/\\b/g, '\b');
                                    break;

                                case 2:
                                    this.$ = Number(yytext);
                                    break;

                                case 3:
                                    this.$ = null;
                                    break;

                                case 4:
                                    this.$ = true;
                                    break;

                                case 5:
                                    this.$ = false;
                                    break;

                                case 6:
                                    return this.$ = $$[$0 - 1];
                                    break;

                                case 13:
                                    this.$ = {};
                                    break;

                                case 14:
                                    this.$ = $$[$0 - 1];
                                    break;

                                case 15:
                                    this.$ = [$$[$0 - 2], $$[$0]];
                                    break;

                                case 16:
                                    this.$ = {};
                                    this.$[$$[$0][0]] = $$[$0][1];
                                    break;

                                case 17:
                                    this.$ = $$[$0 - 2];
                                    $$[$0 - 2][$$[$0][0]] = $$[$0][1];
                                    break;

                                case 18:
                                    this.$ = [];
                                    break;

                                case 19:
                                    this.$ = $$[$0 - 1];
                                    break;

                                case 20:
                                    this.$ = [$$[$0]];
                                    break;

                                case 21:
                                    this.$ = $$[$0 - 2];
                                    $$[$0 - 2].push($$[$0]);
                                    break;
                            }
                        },
                        table: [{
                            3: 5,
                            4: [1, 12],
                            5: 6,
                            6: [1, 13],
                            7: 3,
                            8: [1, 9],
                            9: 4,
                            10: [1, 10],
                            11: [1, 11],
                            12: 1,
                            13: 2,
                            15: 7,
                            16: 8,
                            17: [1, 14],
                            23: [1, 15]
                        }, {
                            1: [3]
                        }, {
                            14: [1, 16]
                        }, {
                            14: [2, 7],
                            18: [2, 7],
                            22: [2, 7],
                            24: [2, 7]
                        }, {
                            14: [2, 8],
                            18: [2, 8],
                            22: [2, 8],
                            24: [2, 8]
                        }, {
                            14: [2, 9],
                            18: [2, 9],
                            22: [2, 9],
                            24: [2, 9]
                        }, {
                            14: [2, 10],
                            18: [2, 10],
                            22: [2, 10],
                            24: [2, 10]
                        }, {
                            14: [2, 11],
                            18: [2, 11],
                            22: [2, 11],
                            24: [2, 11]
                        }, {
                            14: [2, 12],
                            18: [2, 12],
                            22: [2, 12],
                            24: [2, 12]
                        }, {
                            14: [2, 3],
                            18: [2, 3],
                            22: [2, 3],
                            24: [2, 3]
                        }, {
                            14: [2, 4],
                            18: [2, 4],
                            22: [2, 4],
                            24: [2, 4]
                        }, {
                            14: [2, 5],
                            18: [2, 5],
                            22: [2, 5],
                            24: [2, 5]
                        }, {
                            14: [2, 1],
                            18: [2, 1],
                            21: [2, 1],
                            22: [2, 1],
                            24: [2, 1]
                        }, {
                            14: [2, 2],
                            18: [2, 2],
                            22: [2, 2],
                            24: [2, 2]
                        }, {
                            3: 20,
                            4: [1, 12],
                            18: [1, 17],
                            19: 18,
                            20: 19
                        }, {
                            3: 5,
                            4: [1, 12],
                            5: 6,
                            6: [1, 13],
                            7: 3,
                            8: [1, 9],
                            9: 4,
                            10: [1, 10],
                            11: [1, 11],
                            13: 23,
                            15: 7,
                            16: 8,
                            17: [1, 14],
                            23: [1, 15],
                            24: [1, 21],
                            25: 22
                        }, {
                            1: [2, 6]
                        }, {
                            14: [2, 13],
                            18: [2, 13],
                            22: [2, 13],
                            24: [2, 13]
                        }, {
                            18: [1, 24],
                            22: [1, 25]
                        }, {
                            18: [2, 16],
                            22: [2, 16]
                        }, {
                            21: [1, 26]
                        }, {
                            14: [2, 18],
                            18: [2, 18],
                            22: [2, 18],
                            24: [2, 18]
                        }, {
                            22: [1, 28],
                            24: [1, 27]
                        }, {
                            22: [2, 20],
                            24: [2, 20]
                        }, {
                            14: [2, 14],
                            18: [2, 14],
                            22: [2, 14],
                            24: [2, 14]
                        }, {
                            3: 20,
                            4: [1, 12],
                            20: 29
                        }, {
                            3: 5,
                            4: [1, 12],
                            5: 6,
                            6: [1, 13],
                            7: 3,
                            8: [1, 9],
                            9: 4,
                            10: [1, 10],
                            11: [1, 11],
                            13: 30,
                            15: 7,
                            16: 8,
                            17: [1, 14],
                            23: [1, 15]
                        }, {
                            14: [2, 19],
                            18: [2, 19],
                            22: [2, 19],
                            24: [2, 19]
                        }, {
                            3: 5,
                            4: [1, 12],
                            5: 6,
                            6: [1, 13],
                            7: 3,
                            8: [1, 9],
                            9: 4,
                            10: [1, 10],
                            11: [1, 11],
                            13: 31,
                            15: 7,
                            16: 8,
                            17: [1, 14],
                            23: [1, 15]
                        }, {
                            18: [2, 17],
                            22: [2, 17]
                        }, {
                            18: [2, 15],
                            22: [2, 15]
                        }, {
                            22: [2, 21],
                            24: [2, 21]
                        }],
                        defaultActions: {
                            16: [2, 6]
                        },
                        parseError: function parseError(str, hash) {
                            throw new Error(str);
                        },
                        parse: function parse(input) {
                            var self = this,
                                stack = [0],
                                vstack = [null],
                                // semantic value stack
                                lstack = [],
                                // location stack
                                table = this.table,
                                yytext = '',
                                yylineno = 0,
                                yyleng = 0,
                                recovering = 0,
                                TERROR = 2,
                                EOF = 1; //this.reductionCount = this.shiftCount = 0;

                            this.lexer.setInput(input);
                            this.lexer.yy = this.yy;
                            this.yy.lexer = this.lexer;
                            if (typeof this.lexer.yylloc == 'undefined') this.lexer.yylloc = {};
                            var yyloc = this.lexer.yylloc;
                            lstack.push(yyloc);
                            if (typeof this.yy.parseError === 'function') this.parseError = this.yy.parseError;

                            function popStack(n) {
                                stack.length = stack.length - 2 * n;
                                vstack.length = vstack.length - n;
                                lstack.length = lstack.length - n;
                            }

                            function lex() {
                                var token;
                                token = self.lexer.lex() || 1; // $end = 1
                                // if token isn't its numeric value, convert

                                if (typeof token !== 'number') {
                                    token = self.symbols_[token] || token;
                                }

                                return token;
                            }

                            var symbol,
                                preErrorSymbol,
                                state,
                                action,
                                a,
                                r,
                                yyval = {},
                                p,
                                len,
                                newState,
                                expected;

                            while (true) {
                                // retreive state number from top of stack
                                state = stack[stack.length - 1]; // use default actions if available

                                if (this.defaultActions[state]) {
                                    action = this.defaultActions[state];
                                } else {
                                    if (symbol == null) symbol = lex(); // read action for current state and first input

                                    action = table[state] && table[state][symbol];
                                } // handle parse error


                                _handle_error: if (typeof action === 'undefined' || !action.length || !action[0]) {
                                    if (!recovering) {
                                        // Report error
                                        expected = [];

                                        for (p in table[state]) {
                                            if (this.terminals_[p] && p > 2) {
                                                expected.push("'" + this.terminals_[p] + "'");
                                            }
                                        }

                                        var errStr = '';

                                        if (this.lexer.showPosition) {
                                            errStr = 'Parse error on line ' + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(', ') + ", got '" + this.terminals_[symbol] + "'";
                                        } else {
                                            errStr = 'Parse error on line ' + (yylineno + 1) + ": Unexpected " + (symbol == 1
                                                /*EOF*/
                                                ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
                                        }

                                        this.parseError(errStr, {
                                            text: this.lexer.match,
                                            token: this.terminals_[symbol] || symbol,
                                            line: this.lexer.yylineno,
                                            loc: yyloc,
                                            expected: expected
                                        });
                                    } // just recovered from another error


                                    if (recovering == 3) {
                                        if (symbol == EOF) {
                                            throw new Error(errStr || 'Parsing halted.');
                                        } // discard current lookahead and grab another


                                        yyleng = this.lexer.yyleng;
                                        yytext = this.lexer.yytext;
                                        yylineno = this.lexer.yylineno;
                                        yyloc = this.lexer.yylloc;
                                        symbol = lex();
                                    } // try to recover from error


                                    while (1) {
                                        // check for error recovery rule in this state
                                        if (TERROR.toString() in table[state]) {
                                            break;
                                        }

                                        if (state == 0) {
                                            throw new Error(errStr || 'Parsing halted.');
                                        }

                                        popStack(1);
                                        state = stack[stack.length - 1];
                                    }

                                    preErrorSymbol = symbol; // save the lookahead token

                                    symbol = TERROR; // insert generic error symbol as new lookahead

                                    state = stack[stack.length - 1];
                                    action = table[state] && table[state][TERROR];
                                    recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
                                } // this shouldn't happen, unless resolve defaults are off


                                if (action[0] instanceof Array && action.length > 1) {
                                    throw new Error('Parse Error: multiple actions possible at state: ' + state + ', token: ' + symbol);
                                }

                                switch (action[0]) {
                                    case 1:
                                        // shift
                                        //this.shiftCount++;
                                        stack.push(symbol);
                                        vstack.push(this.lexer.yytext);
                                        lstack.push(this.lexer.yylloc);
                                        stack.push(action[1]); // push state

                                        symbol = null;

                                        if (!preErrorSymbol) {
                                            // normal execution/no error
                                            yyleng = this.lexer.yyleng;
                                            yytext = this.lexer.yytext;
                                            yylineno = this.lexer.yylineno;
                                            yyloc = this.lexer.yylloc;
                                            if (recovering > 0) recovering--;
                                        } else {
                                            // error just occurred, resume old lookahead f/ before error
                                            symbol = preErrorSymbol;
                                            preErrorSymbol = null;
                                        }

                                        break;

                                    case 2:
                                        // reduce
                                        //this.reductionCount++;
                                        len = this.productions_[action[1]][1]; // perform semantic action

                                        yyval.$ = vstack[vstack.length - len]; // default to $$ = $1
                                        // default location, uses first token for firsts, last for lasts

                                        yyval._$ = {
                                            first_line: lstack[lstack.length - (len || 1)].first_line,
                                            last_line: lstack[lstack.length - 1].last_line,
                                            first_column: lstack[lstack.length - (len || 1)].first_column,
                                            last_column: lstack[lstack.length - 1].last_column
                                        };
                                        r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                                        if (typeof r !== 'undefined') {
                                            return r;
                                        } // pop off stack


                                        if (len) {
                                            stack = stack.slice(0, -1 * len * 2);
                                            vstack = vstack.slice(0, -1 * len);
                                            lstack = lstack.slice(0, -1 * len);
                                        }

                                        stack.push(this.productions_[action[1]][0]); // push nonterminal (reduce)

                                        vstack.push(yyval.$);
                                        lstack.push(yyval._$); // goto new state = table[STATE][NONTERMINAL]

                                        newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
                                        stack.push(newState);
                                        break;

                                    case 3:
                                        // accept
                                        return true;
                                }
                            }

                            return true;
                        }
                    };
                    /* Jison generated lexer */

                    var lexer = function () {
                        var lexer = {
                            EOF: 1,
                            parseError: function parseError(str, hash) {
                                if (this.yy.parseError) {
                                    this.yy.parseError(str, hash);
                                } else {
                                    throw new Error(str);
                                }
                            },
                            setInput: function setInput(input) {
                                this._input = input;
                                this._more = this._less = this.done = false;
                                this.yylineno = this.yyleng = 0;
                                this.yytext = this.matched = this.match = '';
                                this.conditionStack = ['INITIAL'];
                                this.yylloc = {
                                    first_line: 1,
                                    first_column: 0,
                                    last_line: 1,
                                    last_column: 0
                                };
                                return this;
                            },
                            input: function input() {
                                var ch = this._input[0];
                                this.yytext += ch;
                                this.yyleng++;
                                this.match += ch;
                                this.matched += ch;
                                var lines = ch.match(/\n/);
                                if (lines) this.yylineno++;
                                this._input = this._input.slice(1);
                                return ch;
                            },
                            unput: function unput(ch) {
                                this._input = ch + this._input;
                                return this;
                            },
                            more: function more() {
                                this._more = true;
                                return this;
                            },
                            less: function less(n) {
                                this._input = this.match.slice(n) + this._input;
                            },
                            pastInput: function pastInput() {
                                var past = this.matched.substr(0, this.matched.length - this.match.length);
                                return (past.length > 20 ? '...' : '') + past.substr(-20).replace(/\n/g, "");
                            },
                            upcomingInput: function upcomingInput() {
                                var next = this.match;

                                if (next.length < 20) {
                                    next += this._input.substr(0, 20 - next.length);
                                }

                                return (next.substr(0, 20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
                            },
                            showPosition: function showPosition() {
                                var pre = this.pastInput();
                                var c = new Array(pre.length + 1).join("-");
                                return pre + this.upcomingInput() + "\n" + c + "^";
                            },
                            next: function next() {
                                if (this.done) {
                                    return this.EOF;
                                }

                                if (!this._input) this.done = true;
                                var token, match, tempMatch, index, col, lines;

                                if (!this._more) {
                                    this.yytext = '';
                                    this.match = '';
                                }

                                var rules = this._currentRules();

                                for (var i = 0; i < rules.length; i++) {
                                    tempMatch = this._input.match(this.rules[rules[i]]);

                                    if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                                        match = tempMatch;
                                        index = i;
                                        if (!this.options.flex) break;
                                    }
                                }

                                if (match) {
                                    lines = match[0].match(/\n.*/g);
                                    if (lines) this.yylineno += lines.length;
                                    this.yylloc = {
                                        first_line: this.yylloc.last_line,
                                        last_line: this.yylineno + 1,
                                        first_column: this.yylloc.last_column,
                                        last_column: lines ? lines[lines.length - 1].length - 1 : this.yylloc.last_column + match[0].length
                                    };
                                    this.yytext += match[0];
                                    this.match += match[0];
                                    this.yyleng = this.yytext.length;
                                    this._more = false;
                                    this._input = this._input.slice(match[0].length);
                                    this.matched += match[0];
                                    token = this.performAction.call(this, this.yy, this, rules[index], this.conditionStack[this.conditionStack.length - 1]);
                                    if (this.done && this._input) this.done = false;
                                    if (token) return token; else return;
                                }

                                if (this._input === "") {
                                    return this.EOF;
                                } else {
                                    this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                                        text: "",
                                        token: null,
                                        line: this.yylineno
                                    });
                                }
                            },
                            lex: function lex() {
                                var r = this.next();

                                if (typeof r !== 'undefined') {
                                    return r;
                                } else {
                                    return this.lex();
                                }
                            },
                            begin: function begin(condition) {
                                this.conditionStack.push(condition);
                            },
                            popState: function popState() {
                                return this.conditionStack.pop();
                            },
                            _currentRules: function _currentRules() {
                                return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
                            },
                            topState: function topState() {
                                return this.conditionStack[this.conditionStack.length - 2];
                            },
                            pushState: function begin(condition) {
                                this.begin(condition);
                            }
                        };
                        lexer.options = {};

                        lexer.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
                            var YYSTATE = YY_START;

                            switch ($avoiding_name_collisions) {
                                case 0:
                                    /* skip whitespace */
                                    break;

                                case 1:
                                    return 6;
                                    break;

                                case 2:
                                    yy_.yytext = yy_.yytext.substr(1, yy_.yyleng - 2);
                                    return 4;
                                    break;

                                case 3:
                                    return 17;
                                    break;

                                case 4:
                                    return 18;
                                    break;

                                case 5:
                                    return 23;
                                    break;

                                case 6:
                                    return 24;
                                    break;

                                case 7:
                                    return 22;
                                    break;

                                case 8:
                                    return 21;
                                    break;

                                case 9:
                                    return 10;
                                    break;

                                case 10:
                                    return 11;
                                    break;

                                case 11:
                                    return 8;
                                    break;

                                case 12:
                                    return 14;
                                    break;

                                case 13:
                                    return 'INVALID';
                                    break;
                            }
                        };

                        lexer.rules = [/^(?:\s+)/, /^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/, /^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/, /^(?:\{)/, /^(?:\})/, /^(?:\[)/, /^(?:\])/, /^(?:,)/, /^(?::)/, /^(?:true\b)/, /^(?:false\b)/, /^(?:null\b)/, /^(?:$)/, /^(?:.)/];
                        lexer.conditions = {
                            "INITIAL": {
                                "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13],
                                "inclusive": true
                            }
                        };
                        ;
                        return lexer;
                    }();

                    parser.lexer = lexer;
                    return parser;
                }();

                if (true) {
                    exports.parser = jsonlint;
                    exports.parse = jsonlint.parse.bind(jsonlint);
                }

                /***/
            }),
            /* 23 */
            /***/ (function (module, exports) {

                module.exports = function () {
                    throw new Error("define cannot be used indirect");
                };


                /***/
            }),
            /* 24 */
            /***/ (function (module, exports) {

                if (typeof Element !== 'undefined') {
                    // Polyfill for array remove
                    (function () {
                        function polyfill(item) {
                            if ('remove' in item) {
                                return;
                            }

                            Object.defineProperty(item, 'remove', {
                                configurable: true,
                                enumerable: true,
                                writable: true,
                                value: function remove() {
                                    if (this.parentNode !== undefined) {
                                        this.parentNode.removeChild(this);
                                    }
                                }
                            });
                        }

                        if (typeof window.Element !== 'undefined') {
                            polyfill(window.Element.prototype);
                        }

                        if (typeof window.CharacterData !== 'undefined') {
                            polyfill(window.CharacterData.prototype);
                        }

                        if (typeof window.DocumentType !== 'undefined') {
                            polyfill(window.DocumentType.prototype);
                        }
                    })();
                } // simple polyfill for Array.findIndex


                if (!Array.prototype.findIndex) {
                    // eslint-disable-next-line no-extend-native
                    Array.prototype.findIndex = function (predicate) {
                        for (var i = 0; i < this.length; i++) {
                            var element = this[i];

                            if (predicate.call(this, element, i, this)) {
                                return i;
                            }
                        }

                        return -1;
                    };
                } // Polyfill for Array.find


                if (!Array.prototype.find) {
                    // eslint-disable-next-line no-extend-native
                    Array.prototype.find = function (predicate) {
                        var i = this.findIndex(predicate);
                        return this[i];
                    };
                } // Polyfill for String.trim


                if (!String.prototype.trim) {
                    // eslint-disable-next-line no-extend-native
                    String.prototype.trim = function () {
                        return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
                    };
                }

                /***/
            }),
            /* 25 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                var util = __webpack_require__(7);

                module.exports = SchemaObject;

                function SchemaObject(obj) {
                    util.copy(obj, this);
                }


                /***/
            }),
            /* 26 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                module.exports = function (data, opts) {
                    if (!opts) opts = {};
                    if (typeof opts === 'function') opts = {cmp: opts};
                    var cycles = (typeof opts.cycles === 'boolean') ? opts.cycles : false;

                    var cmp = opts.cmp && (function (f) {
                        return function (node) {
                            return function (a, b) {
                                var aobj = {key: a, value: node[a]};
                                var bobj = {key: b, value: node[b]};
                                return f(aobj, bobj);
                            };
                        };
                    })(opts.cmp);

                    var seen = [];
                    return (function stringify(node) {
                        if (node && node.toJSON && typeof node.toJSON === 'function') {
                            node = node.toJSON();
                        }

                        if (node === undefined) return;
                        if (typeof node == 'number') return isFinite(node) ? '' + node : 'null';
                        if (typeof node !== 'object') return JSON.stringify(node);

                        var i, out;
                        if (Array.isArray(node)) {
                            out = '[';
                            for (i = 0; i < node.length; i++) {
                                if (i) out += ',';
                                out += stringify(node[i]) || 'null';
                            }
                            return out + ']';
                        }

                        if (node === null) return 'null';

                        if (seen.indexOf(node) !== -1) {
                            if (cycles) return JSON.stringify('__cycle__');
                            throw new TypeError('Converting circular structure to JSON');
                        }

                        var seenIndex = seen.push(node) - 1;
                        var keys = Object.keys(node).sort(cmp && cmp(node));
                        out = '';
                        for (i = 0; i < keys.length; i++) {
                            var key = keys[i];
                            var value = stringify(node[key]);

                            if (!value) continue;
                            if (out) out += ',';
                            out += JSON.stringify(key) + ':' + value;
                        }
                        seen.splice(seenIndex, 1);
                        return '{' + out + '}';
                    })(data);
                };


                /***/
            }),
            /* 27 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";

                module.exports = function generate_validate(it, $keyword, $ruleType) {
                    var out = '';
                    var $async = it.schema.$async === true,
                        $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, '$ref'),
                        $id = it.self._getId(it.schema);
                    if (it.opts.strictKeywords) {
                        var $unknownKwd = it.util.schemaUnknownRules(it.schema, it.RULES.keywords);
                        if ($unknownKwd) {
                            var $keywordsMsg = 'unknown keyword: ' + $unknownKwd;
                            if (it.opts.strictKeywords === 'log') it.logger.warn($keywordsMsg);
                            else throw new Error($keywordsMsg);
                        }
                    }
                    if (it.isTop) {
                        out += ' var validate = ';
                        if ($async) {
                            it.async = true;
                            out += 'async ';
                        }
                        out += 'function(data, dataPath, parentData, parentDataProperty, rootData) { \'use strict\'; ';
                        if ($id && (it.opts.sourceCode || it.opts.processCode)) {
                            out += ' ' + ('/\*# sourceURL=' + $id + ' */') + ' ';
                        }
                    }
                    if (typeof it.schema == 'boolean' || !($refKeywords || it.schema.$ref)) {
                        var $keyword = 'false schema';
                        var $lvl = it.level;
                        var $dataLvl = it.dataLevel;
                        var $schema = it.schema[$keyword];
                        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
                        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
                        var $breakOnError = !it.opts.allErrors;
                        var $errorKeyword;
                        var $data = 'data' + ($dataLvl || '');
                        var $valid = 'valid' + $lvl;
                        if (it.schema === false) {
                            if (it.isTop) {
                                $breakOnError = true;
                            } else {
                                out += ' var ' + ($valid) + ' = false; ';
                            }
                            var $$outStack = $$outStack || [];
                            $$outStack.push(out);
                            out = ''; /* istanbul ignore else */
                            if (it.createErrors !== false) {
                                out += ' { keyword: \'' + ($errorKeyword || 'false schema') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                                if (it.opts.messages !== false) {
                                    out += ' , message: \'boolean schema is false\' ';
                                }
                                if (it.opts.verbose) {
                                    out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                }
                                out += ' } ';
                            } else {
                                out += ' {} ';
                            }
                            var __err = out;
                            out = $$outStack.pop();
                            if (!it.compositeRule && $breakOnError) {
                                /* istanbul ignore if */
                                if (it.async) {
                                    out += ' throw new ValidationError([' + (__err) + ']); ';
                                } else {
                                    out += ' validate.errors = [' + (__err) + ']; return false; ';
                                }
                            } else {
                                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                            }
                        } else {
                            if (it.isTop) {
                                if ($async) {
                                    out += ' return data; ';
                                } else {
                                    out += ' validate.errors = null; return true; ';
                                }
                            } else {
                                out += ' var ' + ($valid) + ' = true; ';
                            }
                        }
                        if (it.isTop) {
                            out += ' }; return validate; ';
                        }
                        return out;
                    }
                    if (it.isTop) {
                        var $top = it.isTop,
                            $lvl = it.level = 0,
                            $dataLvl = it.dataLevel = 0,
                            $data = 'data';
                        it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
                        it.baseId = it.baseId || it.rootId;
                        delete it.isTop;
                        it.dataPathArr = [undefined];
                        if (it.schema.default !== undefined && it.opts.useDefaults && it.opts.strictDefaults) {
                            var $defaultMsg = 'default is ignored in the schema root';
                            if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                            else throw new Error($defaultMsg);
                        }
                        out += ' var vErrors = null; ';
                        out += ' var errors = 0;     ';
                        out += ' if (rootData === undefined) rootData = data; ';
                    } else {
                        var $lvl = it.level,
                            $dataLvl = it.dataLevel,
                            $data = 'data' + ($dataLvl || '');
                        if ($id) it.baseId = it.resolve.url(it.baseId, $id);
                        if ($async && !it.async) throw new Error('async schema in sync schema');
                        out += ' var errs_' + ($lvl) + ' = errors;';
                    }
                    var $valid = 'valid' + $lvl,
                        $breakOnError = !it.opts.allErrors,
                        $closingBraces1 = '',
                        $closingBraces2 = '';
                    var $errorKeyword;
                    var $typeSchema = it.schema.type,
                        $typeIsArray = Array.isArray($typeSchema);
                    if ($typeSchema && it.opts.nullable && it.schema.nullable === true) {
                        if ($typeIsArray) {
                            if ($typeSchema.indexOf('null') == -1) $typeSchema = $typeSchema.concat('null');
                        } else if ($typeSchema != 'null') {
                            $typeSchema = [$typeSchema, 'null'];
                            $typeIsArray = true;
                        }
                    }
                    if ($typeIsArray && $typeSchema.length == 1) {
                        $typeSchema = $typeSchema[0];
                        $typeIsArray = false;
                    }
                    if (it.schema.$ref && $refKeywords) {
                        if (it.opts.extendRefs == 'fail') {
                            throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
                        } else if (it.opts.extendRefs !== true) {
                            $refKeywords = false;
                            it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
                        }
                    }
                    if (it.schema.$comment && it.opts.$comment) {
                        out += ' ' + (it.RULES.all.$comment.code(it, '$comment'));
                    }
                    if ($typeSchema) {
                        if (it.opts.coerceTypes) {
                            var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
                        }
                        var $rulesGroup = it.RULES.types[$typeSchema];
                        if ($coerceToTypes || $typeIsArray || $rulesGroup === true || ($rulesGroup && !$shouldUseGroup($rulesGroup))) {
                            var $schemaPath = it.schemaPath + '.type',
                                $errSchemaPath = it.errSchemaPath + '/type';
                            var $schemaPath = it.schemaPath + '.type',
                                $errSchemaPath = it.errSchemaPath + '/type',
                                $method = $typeIsArray ? 'checkDataTypes' : 'checkDataType';
                            out += ' if (' + (it.util[$method]($typeSchema, $data, true)) + ') { ';
                            if ($coerceToTypes) {
                                var $dataType = 'dataType' + $lvl,
                                    $coerced = 'coerced' + $lvl;
                                out += ' var ' + ($dataType) + ' = typeof ' + ($data) + '; ';
                                if (it.opts.coerceTypes == 'array') {
                                    out += ' if (' + ($dataType) + ' == \'object\' && Array.isArray(' + ($data) + ')) ' + ($dataType) + ' = \'array\'; ';
                                }
                                out += ' var ' + ($coerced) + ' = undefined; ';
                                var $bracesCoercion = '';
                                var arr1 = $coerceToTypes;
                                if (arr1) {
                                    var $type, $i = -1,
                                        l1 = arr1.length - 1;
                                    while ($i < l1) {
                                        $type = arr1[$i += 1];
                                        if ($i) {
                                            out += ' if (' + ($coerced) + ' === undefined) { ';
                                            $bracesCoercion += '}';
                                        }
                                        if (it.opts.coerceTypes == 'array' && $type != 'array') {
                                            out += ' if (' + ($dataType) + ' == \'array\' && ' + ($data) + '.length == 1) { ' + ($coerced) + ' = ' + ($data) + ' = ' + ($data) + '[0]; ' + ($dataType) + ' = typeof ' + ($data) + ';  } ';
                                        }
                                        if ($type == 'string') {
                                            out += ' if (' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\') ' + ($coerced) + ' = \'\' + ' + ($data) + '; else if (' + ($data) + ' === null) ' + ($coerced) + ' = \'\'; ';
                                        } else if ($type == 'number' || $type == 'integer') {
                                            out += ' if (' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' === null || (' + ($dataType) + ' == \'string\' && ' + ($data) + ' && ' + ($data) + ' == +' + ($data) + ' ';
                                            if ($type == 'integer') {
                                                out += ' && !(' + ($data) + ' % 1)';
                                            }
                                            out += ')) ' + ($coerced) + ' = +' + ($data) + '; ';
                                        } else if ($type == 'boolean') {
                                            out += ' if (' + ($data) + ' === \'false\' || ' + ($data) + ' === 0 || ' + ($data) + ' === null) ' + ($coerced) + ' = false; else if (' + ($data) + ' === \'true\' || ' + ($data) + ' === 1) ' + ($coerced) + ' = true; ';
                                        } else if ($type == 'null') {
                                            out += ' if (' + ($data) + ' === \'\' || ' + ($data) + ' === 0 || ' + ($data) + ' === false) ' + ($coerced) + ' = null; ';
                                        } else if (it.opts.coerceTypes == 'array' && $type == 'array') {
                                            out += ' if (' + ($dataType) + ' == \'string\' || ' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' == null) ' + ($coerced) + ' = [' + ($data) + ']; ';
                                        }
                                    }
                                }
                                out += ' ' + ($bracesCoercion) + ' if (' + ($coerced) + ' === undefined) {   ';
                                var $$outStack = $$outStack || [];
                                $$outStack.push(out);
                                out = ''; /* istanbul ignore else */
                                if (it.createErrors !== false) {
                                    out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                                    if ($typeIsArray) {
                                        out += '' + ($typeSchema.join(","));
                                    } else {
                                        out += '' + ($typeSchema);
                                    }
                                    out += '\' } ';
                                    if (it.opts.messages !== false) {
                                        out += ' , message: \'should be ';
                                        if ($typeIsArray) {
                                            out += '' + ($typeSchema.join(","));
                                        } else {
                                            out += '' + ($typeSchema);
                                        }
                                        out += '\' ';
                                    }
                                    if (it.opts.verbose) {
                                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                    }
                                    out += ' } ';
                                } else {
                                    out += ' {} ';
                                }
                                var __err = out;
                                out = $$outStack.pop();
                                if (!it.compositeRule && $breakOnError) {
                                    /* istanbul ignore if */
                                    if (it.async) {
                                        out += ' throw new ValidationError([' + (__err) + ']); ';
                                    } else {
                                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                                    }
                                } else {
                                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                }
                                out += ' } else {  ';
                                var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
                                    $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
                                out += ' ' + ($data) + ' = ' + ($coerced) + '; ';
                                if (!$dataLvl) {
                                    out += 'if (' + ($parentData) + ' !== undefined)';
                                }
                                out += ' ' + ($parentData) + '[' + ($parentDataProperty) + '] = ' + ($coerced) + '; } ';
                            } else {
                                var $$outStack = $$outStack || [];
                                $$outStack.push(out);
                                out = ''; /* istanbul ignore else */
                                if (it.createErrors !== false) {
                                    out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                                    if ($typeIsArray) {
                                        out += '' + ($typeSchema.join(","));
                                    } else {
                                        out += '' + ($typeSchema);
                                    }
                                    out += '\' } ';
                                    if (it.opts.messages !== false) {
                                        out += ' , message: \'should be ';
                                        if ($typeIsArray) {
                                            out += '' + ($typeSchema.join(","));
                                        } else {
                                            out += '' + ($typeSchema);
                                        }
                                        out += '\' ';
                                    }
                                    if (it.opts.verbose) {
                                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                    }
                                    out += ' } ';
                                } else {
                                    out += ' {} ';
                                }
                                var __err = out;
                                out = $$outStack.pop();
                                if (!it.compositeRule && $breakOnError) {
                                    /* istanbul ignore if */
                                    if (it.async) {
                                        out += ' throw new ValidationError([' + (__err) + ']); ';
                                    } else {
                                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                                    }
                                } else {
                                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                }
                            }
                            out += ' } ';
                        }
                    }
                    if (it.schema.$ref && !$refKeywords) {
                        out += ' ' + (it.RULES.all.$ref.code(it, '$ref')) + ' ';
                        if ($breakOnError) {
                            out += ' } if (errors === ';
                            if ($top) {
                                out += '0';
                            } else {
                                out += 'errs_' + ($lvl);
                            }
                            out += ') { ';
                            $closingBraces2 += '}';
                        }
                    } else {
                        var arr2 = it.RULES;
                        if (arr2) {
                            var $rulesGroup, i2 = -1,
                                l2 = arr2.length - 1;
                            while (i2 < l2) {
                                $rulesGroup = arr2[i2 += 1];
                                if ($shouldUseGroup($rulesGroup)) {
                                    if ($rulesGroup.type) {
                                        out += ' if (' + (it.util.checkDataType($rulesGroup.type, $data)) + ') { ';
                                    }
                                    if (it.opts.useDefaults) {
                                        if ($rulesGroup.type == 'object' && it.schema.properties) {
                                            var $schema = it.schema.properties,
                                                $schemaKeys = Object.keys($schema);
                                            var arr3 = $schemaKeys;
                                            if (arr3) {
                                                var $propertyKey, i3 = -1,
                                                    l3 = arr3.length - 1;
                                                while (i3 < l3) {
                                                    $propertyKey = arr3[i3 += 1];
                                                    var $sch = $schema[$propertyKey];
                                                    if ($sch.default !== undefined) {
                                                        var $passData = $data + it.util.getProperty($propertyKey);
                                                        if (it.compositeRule) {
                                                            if (it.opts.strictDefaults) {
                                                                var $defaultMsg = 'default is ignored for: ' + $passData;
                                                                if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                                                                else throw new Error($defaultMsg);
                                                            }
                                                        } else {
                                                            out += ' if (' + ($passData) + ' === undefined ';
                                                            if (it.opts.useDefaults == 'empty') {
                                                                out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
                                                            }
                                                            out += ' ) ' + ($passData) + ' = ';
                                                            if (it.opts.useDefaults == 'shared') {
                                                                out += ' ' + (it.useDefault($sch.default)) + ' ';
                                                            } else {
                                                                out += ' ' + (JSON.stringify($sch.default)) + ' ';
                                                            }
                                                            out += '; ';
                                                        }
                                                    }
                                                }
                                            }
                                        } else if ($rulesGroup.type == 'array' && Array.isArray(it.schema.items)) {
                                            var arr4 = it.schema.items;
                                            if (arr4) {
                                                var $sch, $i = -1,
                                                    l4 = arr4.length - 1;
                                                while ($i < l4) {
                                                    $sch = arr4[$i += 1];
                                                    if ($sch.default !== undefined) {
                                                        var $passData = $data + '[' + $i + ']';
                                                        if (it.compositeRule) {
                                                            if (it.opts.strictDefaults) {
                                                                var $defaultMsg = 'default is ignored for: ' + $passData;
                                                                if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                                                                else throw new Error($defaultMsg);
                                                            }
                                                        } else {
                                                            out += ' if (' + ($passData) + ' === undefined ';
                                                            if (it.opts.useDefaults == 'empty') {
                                                                out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
                                                            }
                                                            out += ' ) ' + ($passData) + ' = ';
                                                            if (it.opts.useDefaults == 'shared') {
                                                                out += ' ' + (it.useDefault($sch.default)) + ' ';
                                                            } else {
                                                                out += ' ' + (JSON.stringify($sch.default)) + ' ';
                                                            }
                                                            out += '; ';
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    var arr5 = $rulesGroup.rules;
                                    if (arr5) {
                                        var $rule, i5 = -1,
                                            l5 = arr5.length - 1;
                                        while (i5 < l5) {
                                            $rule = arr5[i5 += 1];
                                            if ($shouldUseRule($rule)) {
                                                var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
                                                if ($code) {
                                                    out += ' ' + ($code) + ' ';
                                                    if ($breakOnError) {
                                                        $closingBraces1 += '}';
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if ($breakOnError) {
                                        out += ' ' + ($closingBraces1) + ' ';
                                        $closingBraces1 = '';
                                    }
                                    if ($rulesGroup.type) {
                                        out += ' } ';
                                        if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
                                            out += ' else { ';
                                            var $schemaPath = it.schemaPath + '.type',
                                                $errSchemaPath = it.errSchemaPath + '/type';
                                            var $$outStack = $$outStack || [];
                                            $$outStack.push(out);
                                            out = ''; /* istanbul ignore else */
                                            if (it.createErrors !== false) {
                                                out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                                                if ($typeIsArray) {
                                                    out += '' + ($typeSchema.join(","));
                                                } else {
                                                    out += '' + ($typeSchema);
                                                }
                                                out += '\' } ';
                                                if (it.opts.messages !== false) {
                                                    out += ' , message: \'should be ';
                                                    if ($typeIsArray) {
                                                        out += '' + ($typeSchema.join(","));
                                                    } else {
                                                        out += '' + ($typeSchema);
                                                    }
                                                    out += '\' ';
                                                }
                                                if (it.opts.verbose) {
                                                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                                }
                                                out += ' } ';
                                            } else {
                                                out += ' {} ';
                                            }
                                            var __err = out;
                                            out = $$outStack.pop();
                                            if (!it.compositeRule && $breakOnError) {
                                                /* istanbul ignore if */
                                                if (it.async) {
                                                    out += ' throw new ValidationError([' + (__err) + ']); ';
                                                } else {
                                                    out += ' validate.errors = [' + (__err) + ']; return false; ';
                                                }
                                            } else {
                                                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                            }
                                            out += ' } ';
                                        }
                                    }
                                    if ($breakOnError) {
                                        out += ' if (errors === ';
                                        if ($top) {
                                            out += '0';
                                        } else {
                                            out += 'errs_' + ($lvl);
                                        }
                                        out += ') { ';
                                        $closingBraces2 += '}';
                                    }
                                }
                            }
                        }
                    }
                    if ($breakOnError) {
                        out += ' ' + ($closingBraces2) + ' ';
                    }
                    if ($top) {
                        if ($async) {
                            out += ' if (errors === 0) return data;           ';
                            out += ' else throw new ValidationError(vErrors); ';
                        } else {
                            out += ' validate.errors = vErrors; ';
                            out += ' return errors === 0;       ';
                        }
                        out += ' }; return validate;';
                    } else {
                        out += ' var ' + ($valid) + ' = errors === errs_' + ($lvl) + ';';
                    }
                    out = it.util.cleanUpCode(out);
                    if ($top) {
                        out = it.util.finalCleanUpCode(out, $async);
                    }

                    function $shouldUseGroup($rulesGroup) {
                        var rules = $rulesGroup.rules;
                        for (var i = 0; i < rules.length; i++)
                            if ($shouldUseRule(rules[i])) return true;
                    }

                    function $shouldUseRule($rule) {
                        return it.schema[$rule.keyword] !== undefined || ($rule.implements && $ruleImplementsSomeKeyword($rule));
                    }

                    function $ruleImplementsSomeKeyword($rule) {
                        var impl = $rule.implements;
                        for (var i = 0; i < impl.length; i++)
                            if (it.schema[impl[i]] !== undefined) return true;
                    }

                    return out;
                }


                /***/
            }),
            /* 28 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";

                module.exports = function generate__limit(it, $keyword, $ruleType) {
                    var out = ' ';
                    var $lvl = it.level;
                    var $dataLvl = it.dataLevel;
                    var $schema = it.schema[$keyword];
                    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
                    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
                    var $breakOnError = !it.opts.allErrors;
                    var $errorKeyword;
                    var $data = 'data' + ($dataLvl || '');
                    var $isData = it.opts.$data && $schema && $schema.$data,
                        $schemaValue;
                    if ($isData) {
                        out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
                        $schemaValue = 'schema' + $lvl;
                    } else {
                        $schemaValue = $schema;
                    }
                    var $isMax = $keyword == 'maximum',
                        $exclusiveKeyword = $isMax ? 'exclusiveMaximum' : 'exclusiveMinimum',
                        $schemaExcl = it.schema[$exclusiveKeyword],
                        $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data,
                        $op = $isMax ? '<' : '>',
                        $notOp = $isMax ? '>' : '<',
                        $errorKeyword = undefined;
                    if ($isDataExcl) {
                        var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr),
                            $exclusive = 'exclusive' + $lvl,
                            $exclType = 'exclType' + $lvl,
                            $exclIsNumber = 'exclIsNumber' + $lvl,
                            $opExpr = 'op' + $lvl,
                            $opStr = '\' + ' + $opExpr + ' + \'';
                        out += ' var schemaExcl' + ($lvl) + ' = ' + ($schemaValueExcl) + '; ';
                        $schemaValueExcl = 'schemaExcl' + $lvl;
                        out += ' var ' + ($exclusive) + '; var ' + ($exclType) + ' = typeof ' + ($schemaValueExcl) + '; if (' + ($exclType) + ' != \'boolean\' && ' + ($exclType) + ' != \'undefined\' && ' + ($exclType) + ' != \'number\') { ';
                        var $errorKeyword = $exclusiveKeyword;
                        var $$outStack = $$outStack || [];
                        $$outStack.push(out);
                        out = ''; /* istanbul ignore else */
                        if (it.createErrors !== false) {
                            out += ' { keyword: \'' + ($errorKeyword || '_exclusiveLimit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                            if (it.opts.messages !== false) {
                                out += ' , message: \'' + ($exclusiveKeyword) + ' should be boolean\' ';
                            }
                            if (it.opts.verbose) {
                                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                            }
                            out += ' } ';
                        } else {
                            out += ' {} ';
                        }
                        var __err = out;
                        out = $$outStack.pop();
                        if (!it.compositeRule && $breakOnError) {
                            /* istanbul ignore if */
                            if (it.async) {
                                out += ' throw new ValidationError([' + (__err) + ']); ';
                            } else {
                                out += ' validate.errors = [' + (__err) + ']; return false; ';
                            }
                        } else {
                            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                        }
                        out += ' } else if ( ';
                        if ($isData) {
                            out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                        }
                        out += ' ' + ($exclType) + ' == \'number\' ? ( (' + ($exclusive) + ' = ' + ($schemaValue) + ' === undefined || ' + ($schemaValueExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ') ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValueExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) : ( (' + ($exclusive) + ' = ' + ($schemaValueExcl) + ' === true) ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValue) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { var op' + ($lvl) + ' = ' + ($exclusive) + ' ? \'' + ($op) + '\' : \'' + ($op) + '=\'; ';
                        if ($schema === undefined) {
                            $errorKeyword = $exclusiveKeyword;
                            $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
                            $schemaValue = $schemaValueExcl;
                            $isData = $isDataExcl;
                        }
                    } else {
                        var $exclIsNumber = typeof $schemaExcl == 'number',
                            $opStr = $op;
                        if ($exclIsNumber && $isData) {
                            var $opExpr = '\'' + $opStr + '\'';
                            out += ' if ( ';
                            if ($isData) {
                                out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                            }
                            out += ' ( ' + ($schemaValue) + ' === undefined || ' + ($schemaExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ' ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { ';
                        } else {
                            if ($exclIsNumber && $schema === undefined) {
                                $exclusive = true;
                                $errorKeyword = $exclusiveKeyword;
                                $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
                                $schemaValue = $schemaExcl;
                                $notOp += '=';
                            } else {
                                if ($exclIsNumber) $schemaValue = Math[$isMax ? 'min' : 'max']($schemaExcl, $schema);
                                if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
                                    $exclusive = true;
                                    $errorKeyword = $exclusiveKeyword;
                                    $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
                                    $notOp += '=';
                                } else {
                                    $exclusive = false;
                                    $opStr += '=';
                                }
                            }
                            var $opExpr = '\'' + $opStr + '\'';
                            out += ' if ( ';
                            if ($isData) {
                                out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                            }
                            out += ' ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' || ' + ($data) + ' !== ' + ($data) + ') { ';
                        }
                    }
                    $errorKeyword = $errorKeyword || $keyword;
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ($errorKeyword || '_limit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { comparison: ' + ($opExpr) + ', limit: ' + ($schemaValue) + ', exclusive: ' + ($exclusive) + ' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should be ' + ($opStr) + ' ';
                            if ($isData) {
                                out += '\' + ' + ($schemaValue);
                            } else {
                                out += '' + ($schemaValue) + '\'';
                            }
                        }
                        if (it.opts.verbose) {
                            out += ' , schema:  ';
                            if ($isData) {
                                out += 'validate.schema' + ($schemaPath);
                            } else {
                                out += '' + ($schema);
                            }
                            out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    } else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) {
                        /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        } else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    } else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += ' } ';
                    if ($breakOnError) {
                        out += ' else { ';
                    }
                    return out;
                }


                /***/
            }),
            /* 29 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";

                module.exports = function generate__limitItems(it, $keyword, $ruleType) {
                    var out = ' ';
                    var $lvl = it.level;
                    var $dataLvl = it.dataLevel;
                    var $schema = it.schema[$keyword];
                    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
                    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
                    var $breakOnError = !it.opts.allErrors;
                    var $errorKeyword;
                    var $data = 'data' + ($dataLvl || '');
                    var $isData = it.opts.$data && $schema && $schema.$data,
                        $schemaValue;
                    if ($isData) {
                        out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
                        $schemaValue = 'schema' + $lvl;
                    } else {
                        $schemaValue = $schema;
                    }
                    var $op = $keyword == 'maxItems' ? '>' : '<';
                    out += 'if ( ';
                    if ($isData) {
                        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                    }
                    out += ' ' + ($data) + '.length ' + ($op) + ' ' + ($schemaValue) + ') { ';
                    var $errorKeyword = $keyword;
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ($errorKeyword || '_limitItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should NOT have ';
                            if ($keyword == 'maxItems') {
                                out += 'more';
                            } else {
                                out += 'fewer';
                            }
                            out += ' than ';
                            if ($isData) {
                                out += '\' + ' + ($schemaValue) + ' + \'';
                            } else {
                                out += '' + ($schema);
                            }
                            out += ' items\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema:  ';
                            if ($isData) {
                                out += 'validate.schema' + ($schemaPath);
                            } else {
                                out += '' + ($schema);
                            }
                            out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    } else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) {
                        /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        } else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    } else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += '} ';
                    if ($breakOnError) {
                        out += ' else { ';
                    }
                    return out;
                }


                /***/
            }),
            /* 30 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";

                module.exports = function generate__limitLength(it, $keyword, $ruleType) {
                    var out = ' ';
                    var $lvl = it.level;
                    var $dataLvl = it.dataLevel;
                    var $schema = it.schema[$keyword];
                    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
                    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
                    var $breakOnError = !it.opts.allErrors;
                    var $errorKeyword;
                    var $data = 'data' + ($dataLvl || '');
                    var $isData = it.opts.$data && $schema && $schema.$data,
                        $schemaValue;
                    if ($isData) {
                        out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
                        $schemaValue = 'schema' + $lvl;
                    } else {
                        $schemaValue = $schema;
                    }
                    var $op = $keyword == 'maxLength' ? '>' : '<';
                    out += 'if ( ';
                    if ($isData) {
                        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                    }
                    if (it.opts.unicode === false) {
                        out += ' ' + ($data) + '.length ';
                    } else {
                        out += ' ucs2length(' + ($data) + ') ';
                    }
                    out += ' ' + ($op) + ' ' + ($schemaValue) + ') { ';
                    var $errorKeyword = $keyword;
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ($errorKeyword || '_limitLength') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should NOT be ';
                            if ($keyword == 'maxLength') {
                                out += 'longer';
                            } else {
                                out += 'shorter';
                            }
                            out += ' than ';
                            if ($isData) {
                                out += '\' + ' + ($schemaValue) + ' + \'';
                            } else {
                                out += '' + ($schema);
                            }
                            out += ' characters\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema:  ';
                            if ($isData) {
                                out += 'validate.schema' + ($schemaPath);
                            } else {
                                out += '' + ($schema);
                            }
                            out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    } else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) {
                        /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        } else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    } else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += '} ';
                    if ($breakOnError) {
                        out += ' else { ';
                    }
                    return out;
                }


                /***/
            }),
            /* 31 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";

                module.exports = function generate__limitProperties(it, $keyword, $ruleType) {
                    var out = ' ';
                    var $lvl = it.level;
                    var $dataLvl = it.dataLevel;
                    var $schema = it.schema[$keyword];
                    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
                    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
                    var $breakOnError = !it.opts.allErrors;
                    var $errorKeyword;
                    var $data = 'data' + ($dataLvl || '');
                    var $isData = it.opts.$data && $schema && $schema.$data,
                        $schemaValue;
                    if ($isData) {
                        out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
                        $schemaValue = 'schema' + $lvl;
                    } else {
                        $schemaValue = $schema;
                    }
                    var $op = $keyword == 'maxProperties' ? '>' : '<';
                    out += 'if ( ';
                    if ($isData) {
                        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                    }
                    out += ' Object.keys(' + ($data) + ').length ' + ($op) + ' ' + ($schemaValue) + ') { ';
                    var $errorKeyword = $keyword;
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ($errorKeyword || '_limitProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should NOT have ';
                            if ($keyword == 'maxProperties') {
                                out += 'more';
                            } else {
                                out += 'fewer';
                            }
                            out += ' than ';
                            if ($isData) {
                                out += '\' + ' + ($schemaValue) + ' + \'';
                            } else {
                                out += '' + ($schema);
                            }
                            out += ' properties\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema:  ';
                            if ($isData) {
                                out += 'validate.schema' + ($schemaPath);
                            } else {
                                out += '' + ($schema);
                            }
                            out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    } else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) {
                        /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        } else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    } else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += '} ';
                    if ($breakOnError) {
                        out += ' else { ';
                    }
                    return out;
                }


                /***/
            }),
            /* 32 */
            /***/ (function (module) {

                module.exports = JSON.parse("{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"$id\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Core schema meta-schema\",\"definitions\":{\"schemaArray\":{\"type\":\"array\",\"minItems\":1,\"items\":{\"$ref\":\"#\"}},\"nonNegativeInteger\":{\"type\":\"integer\",\"minimum\":0},\"nonNegativeIntegerDefault0\":{\"allOf\":[{\"$ref\":\"#/definitions/nonNegativeInteger\"},{\"default\":0}]},\"simpleTypes\":{\"enum\":[\"array\",\"boolean\",\"integer\",\"null\",\"number\",\"object\",\"string\"]},\"stringArray\":{\"type\":\"array\",\"items\":{\"type\":\"string\"},\"uniqueItems\":true,\"default\":[]}},\"type\":[\"object\",\"boolean\"],\"properties\":{\"$id\":{\"type\":\"string\",\"format\":\"uri-reference\"},\"$schema\":{\"type\":\"string\",\"format\":\"uri\"},\"$ref\":{\"type\":\"string\",\"format\":\"uri-reference\"},\"$comment\":{\"type\":\"string\"},\"title\":{\"type\":\"string\"},\"description\":{\"type\":\"string\"},\"default\":true,\"readOnly\":{\"type\":\"boolean\",\"default\":false},\"examples\":{\"type\":\"array\",\"items\":true},\"multipleOf\":{\"type\":\"number\",\"exclusiveMinimum\":0},\"maximum\":{\"type\":\"number\"},\"exclusiveMaximum\":{\"type\":\"number\"},\"minimum\":{\"type\":\"number\"},\"exclusiveMinimum\":{\"type\":\"number\"},\"maxLength\":{\"$ref\":\"#/definitions/nonNegativeInteger\"},\"minLength\":{\"$ref\":\"#/definitions/nonNegativeIntegerDefault0\"},\"pattern\":{\"type\":\"string\",\"format\":\"regex\"},\"additionalItems\":{\"$ref\":\"#\"},\"items\":{\"anyOf\":[{\"$ref\":\"#\"},{\"$ref\":\"#/definitions/schemaArray\"}],\"default\":true},\"maxItems\":{\"$ref\":\"#/definitions/nonNegativeInteger\"},\"minItems\":{\"$ref\":\"#/definitions/nonNegativeIntegerDefault0\"},\"uniqueItems\":{\"type\":\"boolean\",\"default\":false},\"contains\":{\"$ref\":\"#\"},\"maxProperties\":{\"$ref\":\"#/definitions/nonNegativeInteger\"},\"minProperties\":{\"$ref\":\"#/definitions/nonNegativeIntegerDefault0\"},\"required\":{\"$ref\":\"#/definitions/stringArray\"},\"additionalProperties\":{\"$ref\":\"#\"},\"definitions\":{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#\"},\"default\":{}},\"properties\":{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#\"},\"default\":{}},\"patternProperties\":{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#\"},\"propertyNames\":{\"format\":\"regex\"},\"default\":{}},\"dependencies\":{\"type\":\"object\",\"additionalProperties\":{\"anyOf\":[{\"$ref\":\"#\"},{\"$ref\":\"#/definitions/stringArray\"}]}},\"propertyNames\":{\"$ref\":\"#\"},\"const\":true,\"enum\":{\"type\":\"array\",\"items\":true,\"minItems\":1,\"uniqueItems\":true},\"type\":{\"anyOf\":[{\"$ref\":\"#/definitions/simpleTypes\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/simpleTypes\"},\"minItems\":1,\"uniqueItems\":true}]},\"format\":{\"type\":\"string\"},\"contentMediaType\":{\"type\":\"string\"},\"contentEncoding\":{\"type\":\"string\"},\"if\":{\"$ref\":\"#\"},\"then\":{\"$ref\":\"#\"},\"else\":{\"$ref\":\"#\"},\"allOf\":{\"$ref\":\"#/definitions/schemaArray\"},\"anyOf\":{\"$ref\":\"#/definitions/schemaArray\"},\"oneOf\":{\"$ref\":\"#/definitions/schemaArray\"},\"not\":{\"$ref\":\"#\"}},\"default\":true}");

                /***/
            }),
            /* 33 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                var escapedChars = {
                    'b': '\b',
                    'f': '\f',
                    'n': '\n',
                    'r': '\r',
                    't': '\t',
                    '"': '"',
                    '/': '/',
                    '\\': '\\'
                };

                var A_CODE = 'a'.charCodeAt();


                exports.parse = function (source, _, options) {
                    var pointers = {};
                    var line = 0;
                    var column = 0;
                    var pos = 0;
                    var bigint = options && options.bigint && typeof BigInt != 'undefined';
                    return {
                        data: _parse('', true),
                        pointers: pointers
                    };

                    function _parse(ptr, topLevel) {
                        whitespace();
                        var data;
                        map(ptr, 'value');
                        var char = getChar();
                        switch (char) {
                            case 't':
                                read('rue');
                                data = true;
                                break;
                            case 'f':
                                read('alse');
                                data = false;
                                break;
                            case 'n':
                                read('ull');
                                data = null;
                                break;
                            case '"':
                                data = parseString();
                                break;
                            case '[':
                                data = parseArray(ptr);
                                break;
                            case '{':
                                data = parseObject(ptr);
                                break;
                            default:
                                backChar();
                                if ('-0123456789'.indexOf(char) >= 0)
                                    data = parseNumber();
                                else
                                    unexpectedToken();
                        }
                        map(ptr, 'valueEnd');
                        whitespace();
                        if (topLevel && pos < source.length) unexpectedToken();
                        return data;
                    }

                    function whitespace() {
                        loop:
                            while (pos < source.length) {
                                switch (source[pos]) {
                                    case ' ':
                                        column++;
                                        break;
                                    case '\t':
                                        column += 4;
                                        break;
                                    case '\r':
                                        column = 0;
                                        break;
                                    case '\n':
                                        column = 0;
                                        line++;
                                        break;
                                    default:
                                        break loop;
                                }
                                pos++;
                            }
                    }

                    function parseString() {
                        var str = '';
                        var char;
                        while (true) {
                            char = getChar();
                            if (char == '"') {
                                break;
                            } else if (char == '\\') {
                                char = getChar();
                                if (char in escapedChars)
                                    str += escapedChars[char];
                                else if (char == 'u')
                                    str += getCharCode();
                                else
                                    wasUnexpectedToken();
                            } else {
                                str += char;
                            }
                        }
                        return str;
                    }

                    function parseNumber() {
                        var numStr = '';
                        var integer = true;
                        if (source[pos] == '-') numStr += getChar();

                        numStr += source[pos] == '0'
                            ? getChar()
                            : getDigits();

                        if (source[pos] == '.') {
                            numStr += getChar() + getDigits();
                            integer = false;
                        }

                        if (source[pos] == 'e' || source[pos] == 'E') {
                            numStr += getChar();
                            if (source[pos] == '+' || source[pos] == '-') numStr += getChar();
                            numStr += getDigits();
                            integer = false;
                        }

                        var result = +numStr;
                        return bigint && integer && (result > Number.MAX_SAFE_INTEGER || result < Number.MIN_SAFE_INTEGER)
                            ? BigInt(numStr)
                            : result;
                    }

                    function parseArray(ptr) {
                        whitespace();
                        var arr = [];
                        var i = 0;
                        if (getChar() == ']') return arr;
                        backChar();

                        while (true) {
                            var itemPtr = ptr + '/' + i;
                            arr.push(_parse(itemPtr));
                            whitespace();
                            var char = getChar();
                            if (char == ']') break;
                            if (char != ',') wasUnexpectedToken();
                            whitespace();
                            i++;
                        }
                        return arr;
                    }

                    function parseObject(ptr) {
                        whitespace();
                        var obj = {};
                        if (getChar() == '}') return obj;
                        backChar();

                        while (true) {
                            var loc = getLoc();
                            if (getChar() != '"') wasUnexpectedToken();
                            var key = parseString();
                            var propPtr = ptr + '/' + escapeJsonPointer(key);
                            mapLoc(propPtr, 'key', loc);
                            map(propPtr, 'keyEnd');
                            whitespace();
                            if (getChar() != ':') wasUnexpectedToken();
                            whitespace();
                            obj[key] = _parse(propPtr);
                            whitespace();
                            var char = getChar();
                            if (char == '}') break;
                            if (char != ',') wasUnexpectedToken();
                            whitespace();
                        }
                        return obj;
                    }

                    function read(str) {
                        for (var i = 0; i < str.length; i++)
                            if (getChar() !== str[i]) wasUnexpectedToken();
                    }

                    function getChar() {
                        checkUnexpectedEnd();
                        var char = source[pos];
                        pos++;
                        column++; // new line?
                        return char;
                    }

                    function backChar() {
                        pos--;
                        column--;
                    }

                    function getCharCode() {
                        var count = 4;
                        var code = 0;
                        while (count--) {
                            code <<= 4;
                            var char = getChar().toLowerCase();
                            if (char >= 'a' && char <= 'f')
                                code += char.charCodeAt() - A_CODE + 10;
                            else if (char >= '0' && char <= '9')
                                code += +char;
                            else
                                wasUnexpectedToken();
                        }
                        return String.fromCharCode(code);
                    }

                    function getDigits() {
                        var digits = '';
                        while (source[pos] >= '0' && source[pos] <= '9')
                            digits += getChar();

                        if (digits.length) return digits;
                        checkUnexpectedEnd();
                        unexpectedToken();
                    }

                    function map(ptr, prop) {
                        mapLoc(ptr, prop, getLoc());
                    }

                    function mapLoc(ptr, prop, loc) {
                        pointers[ptr] = pointers[ptr] || {};
                        pointers[ptr][prop] = loc;
                    }

                    function getLoc() {
                        return {
                            line: line,
                            column: column,
                            pos: pos
                        };
                    }

                    function unexpectedToken() {
                        throw new SyntaxError('Unexpected token ' + source[pos] + ' in JSON at position ' + pos);
                    }

                    function wasUnexpectedToken() {
                        backChar();
                        unexpectedToken();
                    }

                    function checkUnexpectedEnd() {
                        if (pos >= source.length)
                            throw new SyntaxError('Unexpected end of JSON input');
                    }
                };


                exports.stringify = function (data, _, options) {
                    if (!validType(data)) return;
                    var wsLine = 0;
                    var wsPos, wsColumn;
                    var whitespace = typeof options == 'object'
                        ? options.space
                        : options;
                    switch (typeof whitespace) {
                        case 'number':
                            var len = whitespace > 10
                                ? 10
                                : whitespace < 0
                                    ? 0
                                    : Math.floor(whitespace);
                            whitespace = len && repeat(len, ' ');
                            wsPos = len;
                            wsColumn = len;
                            break;
                        case 'string':
                            whitespace = whitespace.slice(0, 10);
                            wsPos = 0;
                            wsColumn = 0;
                            for (var j = 0; j < whitespace.length; j++) {
                                var char = whitespace[j];
                                switch (char) {
                                    case ' ':
                                        wsColumn++;
                                        break;
                                    case '\t':
                                        wsColumn += 4;
                                        break;
                                    case '\r':
                                        wsColumn = 0;
                                        break;
                                    case '\n':
                                        wsColumn = 0;
                                        wsLine++;
                                        break;
                                    default:
                                        throw new Error('whitespace characters not allowed in JSON');
                                }
                                wsPos++;
                            }
                            break;
                        default:
                            whitespace = undefined;
                    }

                    var json = '';
                    var pointers = {};
                    var line = 0;
                    var column = 0;
                    var pos = 0;
                    var es6 = options && options.es6 && typeof Map == 'function';
                    _stringify(data, 0, '');
                    return {
                        json: json,
                        pointers: pointers
                    };

                    function _stringify(_data, lvl, ptr) {
                        map(ptr, 'value');
                        switch (typeof _data) {
                            case 'number':
                            case 'bigint':
                            case 'boolean':
                                out('' + _data);
                                break;
                            case 'string':
                                out(quoted(_data));
                                break;
                            case 'object':
                                if (_data === null) {
                                    out('null');
                                } else if (typeof _data.toJSON == 'function') {
                                    out(quoted(_data.toJSON()));
                                } else if (Array.isArray(_data)) {
                                    stringifyArray();
                                } else if (es6) {
                                    if (_data.constructor.BYTES_PER_ELEMENT)
                                        stringifyArray();
                                    else if (_data instanceof Map)
                                        stringifyMapSet();
                                    else if (_data instanceof Set)
                                        stringifyMapSet(true);
                                    else
                                        stringifyObject();
                                } else {
                                    stringifyObject();
                                }
                        }
                        map(ptr, 'valueEnd');

                        function stringifyArray() {
                            if (_data.length) {
                                out('[');
                                var itemLvl = lvl + 1;
                                for (var i = 0; i < _data.length; i++) {
                                    if (i) out(',');
                                    indent(itemLvl);
                                    var item = validType(_data[i]) ? _data[i] : null;
                                    var itemPtr = ptr + '/' + i;
                                    _stringify(item, itemLvl, itemPtr);
                                }
                                indent(lvl);
                                out(']');
                            } else {
                                out('[]');
                            }
                        }

                        function stringifyObject() {
                            var keys = Object.keys(_data);
                            if (keys.length) {
                                out('{');
                                var propLvl = lvl + 1;
                                for (var i = 0; i < keys.length; i++) {
                                    var key = keys[i];
                                    var value = _data[key];
                                    if (validType(value)) {
                                        if (i) out(',');
                                        var propPtr = ptr + '/' + escapeJsonPointer(key);
                                        indent(propLvl);
                                        map(propPtr, 'key');
                                        out(quoted(key));
                                        map(propPtr, 'keyEnd');
                                        out(':');
                                        if (whitespace) out(' ');
                                        _stringify(value, propLvl, propPtr);
                                    }
                                }
                                indent(lvl);
                                out('}');
                            } else {
                                out('{}');
                            }
                        }

                        function stringifyMapSet(isSet) {
                            if (_data.size) {
                                out('{');
                                var propLvl = lvl + 1;
                                var first = true;
                                var entries = _data.entries();
                                var entry = entries.next();
                                while (!entry.done) {
                                    var item = entry.value;
                                    var key = item[0];
                                    var value = isSet ? true : item[1];
                                    if (validType(value)) {
                                        if (!first) out(',');
                                        first = false;
                                        var propPtr = ptr + '/' + escapeJsonPointer(key);
                                        indent(propLvl);
                                        map(propPtr, 'key');
                                        out(quoted(key));
                                        map(propPtr, 'keyEnd');
                                        out(':');
                                        if (whitespace) out(' ');
                                        _stringify(value, propLvl, propPtr);
                                    }
                                    entry = entries.next();
                                }
                                indent(lvl);
                                out('}');
                            } else {
                                out('{}');
                            }
                        }
                    }

                    function out(str) {
                        column += str.length;
                        pos += str.length;
                        json += str;
                    }

                    function indent(lvl) {
                        if (whitespace) {
                            json += '\n' + repeat(lvl, whitespace);
                            line++;
                            column = 0;
                            while (lvl--) {
                                if (wsLine) {
                                    line += wsLine;
                                    column = wsColumn;
                                } else {
                                    column += wsColumn;
                                }
                                pos += wsPos;
                            }
                            pos += 1; // \n character
                        }
                    }

                    function map(ptr, prop) {
                        pointers[ptr] = pointers[ptr] || {};
                        pointers[ptr][prop] = {
                            line: line,
                            column: column,
                            pos: pos
                        };
                    }

                    function repeat(n, str) {
                        return Array(n + 1).join(str);
                    }
                };


                var VALID_TYPES = ['number', 'bigint', 'boolean', 'string', 'object'];

                function validType(data) {
                    return VALID_TYPES.indexOf(typeof data) >= 0;
                }


                var ESC_QUOTE = /"|\\/g;
                var ESC_B = /[\b]/g;
                var ESC_F = /\f/g;
                var ESC_N = /\n/g;
                var ESC_R = /\r/g;
                var ESC_T = /\t/g;

                function quoted(str) {
                    str = str.replace(ESC_QUOTE, '\\$&')
                        .replace(ESC_F, '\\f')
                        .replace(ESC_B, '\\b')
                        .replace(ESC_N, '\\n')
                        .replace(ESC_R, '\\r')
                        .replace(ESC_T, '\\t');
                    return '"' + str + '"';
                }


                var ESC_0 = /~/g;
                var ESC_1 = /\//g;

                function escapeJsonPointer(str) {
                    return str.replace(ESC_0, '~0')
                        .replace(ESC_1, '~1');
                }


                /***/
            }),
            /* 34 */
            /***/ (function (module, exports, __webpack_require__) {

                (function (exports) {
                    "use strict";

                    function isArray(obj) {
                        if (obj !== null) {
                            return Object.prototype.toString.call(obj) === "[object Array]";
                        } else {
                            return false;
                        }
                    }

                    function isObject(obj) {
                        if (obj !== null) {
                            return Object.prototype.toString.call(obj) === "[object Object]";
                        } else {
                            return false;
                        }
                    }

                    function strictDeepEqual(first, second) {
                        // Check the scalar case first.
                        if (first === second) {
                            return true;
                        }

                        // Check if they are the same type.
                        var firstType = Object.prototype.toString.call(first);
                        if (firstType !== Object.prototype.toString.call(second)) {
                            return false;
                        }
                        // We know that first and second have the same type so we can just check the
                        // first type from now on.
                        if (isArray(first) === true) {
                            // Short circuit if they're not the same length;
                            if (first.length !== second.length) {
                                return false;
                            }
                            for (var i = 0; i < first.length; i++) {
                                if (strictDeepEqual(first[i], second[i]) === false) {
                                    return false;
                                }
                            }
                            return true;
                        }
                        if (isObject(first) === true) {
                            // An object is equal if it has the same key/value pairs.
                            var keysSeen = {};
                            for (var key in first) {
                                if (hasOwnProperty.call(first, key)) {
                                    if (strictDeepEqual(first[key], second[key]) === false) {
                                        return false;
                                    }
                                    keysSeen[key] = true;
                                }
                            }
                            // Now check that there aren't any keys in second that weren't
                            // in first.
                            for (var key2 in second) {
                                if (hasOwnProperty.call(second, key2)) {
                                    if (keysSeen[key2] !== true) {
                                        return false;
                                    }
                                }
                            }
                            return true;
                        }
                        return false;
                    }

                    function isFalse(obj) {
                        // From the spec:
                        // A false value corresponds to the following values:
                        // Empty list
                        // Empty object
                        // Empty string
                        // False boolean
                        // null value

                        // First check the scalar values.
                        if (obj === "" || obj === false || obj === null) {
                            return true;
                        } else if (isArray(obj) && obj.length === 0) {
                            // Check for an empty array.
                            return true;
                        } else if (isObject(obj)) {
                            // Check for an empty object.
                            for (var key in obj) {
                                // If there are any keys, then
                                // the object is not empty so the object
                                // is not false.
                                if (obj.hasOwnProperty(key)) {
                                    return false;
                                }
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }

                    function objValues(obj) {
                        var keys = Object.keys(obj);
                        var values = [];
                        for (var i = 0; i < keys.length; i++) {
                            values.push(obj[keys[i]]);
                        }
                        return values;
                    }

                    function merge(a, b) {
                        var merged = {};
                        for (var key in a) {
                            merged[key] = a[key];
                        }
                        for (var key2 in b) {
                            merged[key2] = b[key2];
                        }
                        return merged;
                    }

                    var trimLeft;
                    if (typeof String.prototype.trimLeft === "function") {
                        trimLeft = function (str) {
                            return str.trimLeft();
                        };
                    } else {
                        trimLeft = function (str) {
                            return str.match(/^\s*(.*)/)[1];
                        };
                    }

                    // Type constants used to define functions.
                    var TYPE_NUMBER = 0;
                    var TYPE_ANY = 1;
                    var TYPE_STRING = 2;
                    var TYPE_ARRAY = 3;
                    var TYPE_OBJECT = 4;
                    var TYPE_BOOLEAN = 5;
                    var TYPE_EXPREF = 6;
                    var TYPE_NULL = 7;
                    var TYPE_ARRAY_NUMBER = 8;
                    var TYPE_ARRAY_STRING = 9;

                    var TOK_EOF = "EOF";
                    var TOK_UNQUOTEDIDENTIFIER = "UnquotedIdentifier";
                    var TOK_QUOTEDIDENTIFIER = "QuotedIdentifier";
                    var TOK_RBRACKET = "Rbracket";
                    var TOK_RPAREN = "Rparen";
                    var TOK_COMMA = "Comma";
                    var TOK_COLON = "Colon";
                    var TOK_RBRACE = "Rbrace";
                    var TOK_NUMBER = "Number";
                    var TOK_CURRENT = "Current";
                    var TOK_EXPREF = "Expref";
                    var TOK_PIPE = "Pipe";
                    var TOK_OR = "Or";
                    var TOK_AND = "And";
                    var TOK_EQ = "EQ";
                    var TOK_GT = "GT";
                    var TOK_LT = "LT";
                    var TOK_GTE = "GTE";
                    var TOK_LTE = "LTE";
                    var TOK_NE = "NE";
                    var TOK_FLATTEN = "Flatten";
                    var TOK_STAR = "Star";
                    var TOK_FILTER = "Filter";
                    var TOK_DOT = "Dot";
                    var TOK_NOT = "Not";
                    var TOK_LBRACE = "Lbrace";
                    var TOK_LBRACKET = "Lbracket";
                    var TOK_LPAREN = "Lparen";
                    var TOK_LITERAL = "Literal";

                    // The "&", "[", "<", ">" tokens
                    // are not in basicToken because
                    // there are two token variants
                    // ("&&", "[?", "<=", ">=").  This is specially handled
                    // below.

                    var basicTokens = {
                        ".": TOK_DOT,
                        "*": TOK_STAR,
                        ",": TOK_COMMA,
                        ":": TOK_COLON,
                        "{": TOK_LBRACE,
                        "}": TOK_RBRACE,
                        "]": TOK_RBRACKET,
                        "(": TOK_LPAREN,
                        ")": TOK_RPAREN,
                        "@": TOK_CURRENT
                    };

                    var operatorStartToken = {
                        "<": true,
                        ">": true,
                        "=": true,
                        "!": true
                    };

                    var skipChars = {
                        " ": true,
                        "\t": true,
                        "\n": true
                    };


                    function isAlpha(ch) {
                        return (ch >= "a" && ch <= "z") ||
                            (ch >= "A" && ch <= "Z") ||
                            ch === "_";
                    }

                    function isNum(ch) {
                        return (ch >= "0" && ch <= "9") ||
                            ch === "-";
                    }

                    function isAlphaNum(ch) {
                        return (ch >= "a" && ch <= "z") ||
                            (ch >= "A" && ch <= "Z") ||
                            (ch >= "0" && ch <= "9") ||
                            ch === "_";
                    }

                    function Lexer() {
                    }

                    Lexer.prototype = {
                        tokenize: function (stream) {
                            var tokens = [];
                            this._current = 0;
                            var start;
                            var identifier;
                            var token;
                            while (this._current < stream.length) {
                                if (isAlpha(stream[this._current])) {
                                    start = this._current;
                                    identifier = this._consumeUnquotedIdentifier(stream);
                                    tokens.push({
                                        type: TOK_UNQUOTEDIDENTIFIER,
                                        value: identifier,
                                        start: start
                                    });
                                } else if (basicTokens[stream[this._current]] !== undefined) {
                                    tokens.push({
                                        type: basicTokens[stream[this._current]],
                                        value: stream[this._current],
                                        start: this._current
                                    });
                                    this._current++;
                                } else if (isNum(stream[this._current])) {
                                    token = this._consumeNumber(stream);
                                    tokens.push(token);
                                } else if (stream[this._current] === "[") {
                                    // No need to increment this._current.  This happens
                                    // in _consumeLBracket
                                    token = this._consumeLBracket(stream);
                                    tokens.push(token);
                                } else if (stream[this._current] === "\"") {
                                    start = this._current;
                                    identifier = this._consumeQuotedIdentifier(stream);
                                    tokens.push({
                                        type: TOK_QUOTEDIDENTIFIER,
                                        value: identifier,
                                        start: start
                                    });
                                } else if (stream[this._current] === "'") {
                                    start = this._current;
                                    identifier = this._consumeRawStringLiteral(stream);
                                    tokens.push({
                                        type: TOK_LITERAL,
                                        value: identifier,
                                        start: start
                                    });
                                } else if (stream[this._current] === "`") {
                                    start = this._current;
                                    var literal = this._consumeLiteral(stream);
                                    tokens.push({
                                        type: TOK_LITERAL,
                                        value: literal,
                                        start: start
                                    });
                                } else if (operatorStartToken[stream[this._current]] !== undefined) {
                                    tokens.push(this._consumeOperator(stream));
                                } else if (skipChars[stream[this._current]] !== undefined) {
                                    // Ignore whitespace.
                                    this._current++;
                                } else if (stream[this._current] === "&") {
                                    start = this._current;
                                    this._current++;
                                    if (stream[this._current] === "&") {
                                        this._current++;
                                        tokens.push({type: TOK_AND, value: "&&", start: start});
                                    } else {
                                        tokens.push({type: TOK_EXPREF, value: "&", start: start});
                                    }
                                } else if (stream[this._current] === "|") {
                                    start = this._current;
                                    this._current++;
                                    if (stream[this._current] === "|") {
                                        this._current++;
                                        tokens.push({type: TOK_OR, value: "||", start: start});
                                    } else {
                                        tokens.push({type: TOK_PIPE, value: "|", start: start});
                                    }
                                } else {
                                    var error = new Error("Unknown character:" + stream[this._current]);
                                    error.name = "LexerError";
                                    throw error;
                                }
                            }
                            return tokens;
                        },

                        _consumeUnquotedIdentifier: function (stream) {
                            var start = this._current;
                            this._current++;
                            while (this._current < stream.length && isAlphaNum(stream[this._current])) {
                                this._current++;
                            }
                            return stream.slice(start, this._current);
                        },

                        _consumeQuotedIdentifier: function (stream) {
                            var start = this._current;
                            this._current++;
                            var maxLength = stream.length;
                            while (stream[this._current] !== "\"" && this._current < maxLength) {
                                // You can escape a double quote and you can escape an escape.
                                var current = this._current;
                                if (stream[current] === "\\" && (stream[current + 1] === "\\" ||
                                    stream[current + 1] === "\"")) {
                                    current += 2;
                                } else {
                                    current++;
                                }
                                this._current = current;
                            }
                            this._current++;
                            return JSON.parse(stream.slice(start, this._current));
                        },

                        _consumeRawStringLiteral: function (stream) {
                            var start = this._current;
                            this._current++;
                            var maxLength = stream.length;
                            while (stream[this._current] !== "'" && this._current < maxLength) {
                                // You can escape a single quote and you can escape an escape.
                                var current = this._current;
                                if (stream[current] === "\\" && (stream[current + 1] === "\\" ||
                                    stream[current + 1] === "'")) {
                                    current += 2;
                                } else {
                                    current++;
                                }
                                this._current = current;
                            }
                            this._current++;
                            var literal = stream.slice(start + 1, this._current - 1);
                            return literal.replace("\\'", "'");
                        },

                        _consumeNumber: function (stream) {
                            var start = this._current;
                            this._current++;
                            var maxLength = stream.length;
                            while (isNum(stream[this._current]) && this._current < maxLength) {
                                this._current++;
                            }
                            var value = parseInt(stream.slice(start, this._current));
                            return {type: TOK_NUMBER, value: value, start: start};
                        },

                        _consumeLBracket: function (stream) {
                            var start = this._current;
                            this._current++;
                            if (stream[this._current] === "?") {
                                this._current++;
                                return {type: TOK_FILTER, value: "[?", start: start};
                            } else if (stream[this._current] === "]") {
                                this._current++;
                                return {type: TOK_FLATTEN, value: "[]", start: start};
                            } else {
                                return {type: TOK_LBRACKET, value: "[", start: start};
                            }
                        },

                        _consumeOperator: function (stream) {
                            var start = this._current;
                            var startingChar = stream[start];
                            this._current++;
                            if (startingChar === "!") {
                                if (stream[this._current] === "=") {
                                    this._current++;
                                    return {type: TOK_NE, value: "!=", start: start};
                                } else {
                                    return {type: TOK_NOT, value: "!", start: start};
                                }
                            } else if (startingChar === "<") {
                                if (stream[this._current] === "=") {
                                    this._current++;
                                    return {type: TOK_LTE, value: "<=", start: start};
                                } else {
                                    return {type: TOK_LT, value: "<", start: start};
                                }
                            } else if (startingChar === ">") {
                                if (stream[this._current] === "=") {
                                    this._current++;
                                    return {type: TOK_GTE, value: ">=", start: start};
                                } else {
                                    return {type: TOK_GT, value: ">", start: start};
                                }
                            } else if (startingChar === "=") {
                                if (stream[this._current] === "=") {
                                    this._current++;
                                    return {type: TOK_EQ, value: "==", start: start};
                                }
                            }
                        },

                        _consumeLiteral: function (stream) {
                            this._current++;
                            var start = this._current;
                            var maxLength = stream.length;
                            var literal;
                            while (stream[this._current] !== "`" && this._current < maxLength) {
                                // You can escape a literal char or you can escape the escape.
                                var current = this._current;
                                if (stream[current] === "\\" && (stream[current + 1] === "\\" ||
                                    stream[current + 1] === "`")) {
                                    current += 2;
                                } else {
                                    current++;
                                }
                                this._current = current;
                            }
                            var literalString = trimLeft(stream.slice(start, this._current));
                            literalString = literalString.replace("\\`", "`");
                            if (this._looksLikeJSON(literalString)) {
                                literal = JSON.parse(literalString);
                            } else {
                                // Try to JSON parse it as "<literal>"
                                literal = JSON.parse("\"" + literalString + "\"");
                            }
                            // +1 gets us to the ending "`", +1 to move on to the next char.
                            this._current++;
                            return literal;
                        },

                        _looksLikeJSON: function (literalString) {
                            var startingChars = "[{\"";
                            var jsonLiterals = ["true", "false", "null"];
                            var numberLooking = "-0123456789";

                            if (literalString === "") {
                                return false;
                            } else if (startingChars.indexOf(literalString[0]) >= 0) {
                                return true;
                            } else if (jsonLiterals.indexOf(literalString) >= 0) {
                                return true;
                            } else if (numberLooking.indexOf(literalString[0]) >= 0) {
                                try {
                                    JSON.parse(literalString);
                                    return true;
                                } catch (ex) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        }
                    };

                    var bindingPower = {};
                    bindingPower[TOK_EOF] = 0;
                    bindingPower[TOK_UNQUOTEDIDENTIFIER] = 0;
                    bindingPower[TOK_QUOTEDIDENTIFIER] = 0;
                    bindingPower[TOK_RBRACKET] = 0;
                    bindingPower[TOK_RPAREN] = 0;
                    bindingPower[TOK_COMMA] = 0;
                    bindingPower[TOK_RBRACE] = 0;
                    bindingPower[TOK_NUMBER] = 0;
                    bindingPower[TOK_CURRENT] = 0;
                    bindingPower[TOK_EXPREF] = 0;
                    bindingPower[TOK_PIPE] = 1;
                    bindingPower[TOK_OR] = 2;
                    bindingPower[TOK_AND] = 3;
                    bindingPower[TOK_EQ] = 5;
                    bindingPower[TOK_GT] = 5;
                    bindingPower[TOK_LT] = 5;
                    bindingPower[TOK_GTE] = 5;
                    bindingPower[TOK_LTE] = 5;
                    bindingPower[TOK_NE] = 5;
                    bindingPower[TOK_FLATTEN] = 9;
                    bindingPower[TOK_STAR] = 20;
                    bindingPower[TOK_FILTER] = 21;
                    bindingPower[TOK_DOT] = 40;
                    bindingPower[TOK_NOT] = 45;
                    bindingPower[TOK_LBRACE] = 50;
                    bindingPower[TOK_LBRACKET] = 55;
                    bindingPower[TOK_LPAREN] = 60;

                    function Parser() {
                    }

                    Parser.prototype = {
                        parse: function (expression) {
                            this._loadTokens(expression);
                            this.index = 0;
                            var ast = this.expression(0);
                            if (this._lookahead(0) !== TOK_EOF) {
                                var t = this._lookaheadToken(0);
                                var error = new Error(
                                    "Unexpected token type: " + t.type + ", value: " + t.value);
                                error.name = "ParserError";
                                throw error;
                            }
                            return ast;
                        },

                        _loadTokens: function (expression) {
                            var lexer = new Lexer();
                            var tokens = lexer.tokenize(expression);
                            tokens.push({type: TOK_EOF, value: "", start: expression.length});
                            this.tokens = tokens;
                        },

                        expression: function (rbp) {
                            var leftToken = this._lookaheadToken(0);
                            this._advance();
                            var left = this.nud(leftToken);
                            var currentToken = this._lookahead(0);
                            while (rbp < bindingPower[currentToken]) {
                                this._advance();
                                left = this.led(currentToken, left);
                                currentToken = this._lookahead(0);
                            }
                            return left;
                        },

                        _lookahead: function (number) {
                            return this.tokens[this.index + number].type;
                        },

                        _lookaheadToken: function (number) {
                            return this.tokens[this.index + number];
                        },

                        _advance: function () {
                            this.index++;
                        },

                        nud: function (token) {
                            var left;
                            var right;
                            var expression;
                            switch (token.type) {
                                case TOK_LITERAL:
                                    return {type: "Literal", value: token.value};
                                case TOK_UNQUOTEDIDENTIFIER:
                                    return {type: "Field", name: token.value};
                                case TOK_QUOTEDIDENTIFIER:
                                    var node = {type: "Field", name: token.value};
                                    if (this._lookahead(0) === TOK_LPAREN) {
                                        throw new Error("Quoted identifier not allowed for function names.");
                                    } else {
                                        return node;
                                    }
                                    break;
                                case TOK_NOT:
                                    right = this.expression(bindingPower.Not);
                                    return {type: "NotExpression", children: [right]};
                                case TOK_STAR:
                                    left = {type: "Identity"};
                                    right = null;
                                    if (this._lookahead(0) === TOK_RBRACKET) {
                                        // This can happen in a multiselect,
                                        // [a, b, *]
                                        right = {type: "Identity"};
                                    } else {
                                        right = this._parseProjectionRHS(bindingPower.Star);
                                    }
                                    return {type: "ValueProjection", children: [left, right]};
                                case TOK_FILTER:
                                    return this.led(token.type, {type: "Identity"});
                                case TOK_LBRACE:
                                    return this._parseMultiselectHash();
                                case TOK_FLATTEN:
                                    left = {type: TOK_FLATTEN, children: [{type: "Identity"}]};
                                    right = this._parseProjectionRHS(bindingPower.Flatten);
                                    return {type: "Projection", children: [left, right]};
                                case TOK_LBRACKET:
                                    if (this._lookahead(0) === TOK_NUMBER || this._lookahead(0) === TOK_COLON) {
                                        right = this._parseIndexExpression();
                                        return this._projectIfSlice({type: "Identity"}, right);
                                    } else if (this._lookahead(0) === TOK_STAR &&
                                        this._lookahead(1) === TOK_RBRACKET) {
                                        this._advance();
                                        this._advance();
                                        right = this._parseProjectionRHS(bindingPower.Star);
                                        return {
                                            type: "Projection",
                                            children: [{type: "Identity"}, right]
                                        };
                                    } else {
                                        return this._parseMultiselectList();
                                    }
                                    break;
                                case TOK_CURRENT:
                                    return {type: TOK_CURRENT};
                                case TOK_EXPREF:
                                    expression = this.expression(bindingPower.Expref);
                                    return {type: "ExpressionReference", children: [expression]};
                                case TOK_LPAREN:
                                    var args = [];
                                    while (this._lookahead(0) !== TOK_RPAREN) {
                                        if (this._lookahead(0) === TOK_CURRENT) {
                                            expression = {type: TOK_CURRENT};
                                            this._advance();
                                        } else {
                                            expression = this.expression(0);
                                        }
                                        args.push(expression);
                                    }
                                    this._match(TOK_RPAREN);
                                    return args[0];
                                default:
                                    this._errorToken(token);
                            }
                        },

                        led: function (tokenName, left) {
                            var right;
                            switch (tokenName) {
                                case TOK_DOT:
                                    var rbp = bindingPower.Dot;
                                    if (this._lookahead(0) !== TOK_STAR) {
                                        right = this._parseDotRHS(rbp);
                                        return {type: "Subexpression", children: [left, right]};
                                    } else {
                                        // Creating a projection.
                                        this._advance();
                                        right = this._parseProjectionRHS(rbp);
                                        return {type: "ValueProjection", children: [left, right]};
                                    }
                                    break;
                                case TOK_PIPE:
                                    right = this.expression(bindingPower.Pipe);
                                    return {type: TOK_PIPE, children: [left, right]};
                                case TOK_OR:
                                    right = this.expression(bindingPower.Or);
                                    return {type: "OrExpression", children: [left, right]};
                                case TOK_AND:
                                    right = this.expression(bindingPower.And);
                                    return {type: "AndExpression", children: [left, right]};
                                case TOK_LPAREN:
                                    var name = left.name;
                                    var args = [];
                                    var expression, node;
                                    while (this._lookahead(0) !== TOK_RPAREN) {
                                        if (this._lookahead(0) === TOK_CURRENT) {
                                            expression = {type: TOK_CURRENT};
                                            this._advance();
                                        } else {
                                            expression = this.expression(0);
                                        }
                                        if (this._lookahead(0) === TOK_COMMA) {
                                            this._match(TOK_COMMA);
                                        }
                                        args.push(expression);
                                    }
                                    this._match(TOK_RPAREN);
                                    node = {type: "Function", name: name, children: args};
                                    return node;
                                case TOK_FILTER:
                                    var condition = this.expression(0);
                                    this._match(TOK_RBRACKET);
                                    if (this._lookahead(0) === TOK_FLATTEN) {
                                        right = {type: "Identity"};
                                    } else {
                                        right = this._parseProjectionRHS(bindingPower.Filter);
                                    }
                                    return {type: "FilterProjection", children: [left, right, condition]};
                                case TOK_FLATTEN:
                                    var leftNode = {type: TOK_FLATTEN, children: [left]};
                                    var rightNode = this._parseProjectionRHS(bindingPower.Flatten);
                                    return {type: "Projection", children: [leftNode, rightNode]};
                                case TOK_EQ:
                                case TOK_NE:
                                case TOK_GT:
                                case TOK_GTE:
                                case TOK_LT:
                                case TOK_LTE:
                                    return this._parseComparator(left, tokenName);
                                case TOK_LBRACKET:
                                    var token = this._lookaheadToken(0);
                                    if (token.type === TOK_NUMBER || token.type === TOK_COLON) {
                                        right = this._parseIndexExpression();
                                        return this._projectIfSlice(left, right);
                                    } else {
                                        this._match(TOK_STAR);
                                        this._match(TOK_RBRACKET);
                                        right = this._parseProjectionRHS(bindingPower.Star);
                                        return {type: "Projection", children: [left, right]};
                                    }
                                    break;
                                default:
                                    this._errorToken(this._lookaheadToken(0));
                            }
                        },

                        _match: function (tokenType) {
                            if (this._lookahead(0) === tokenType) {
                                this._advance();
                            } else {
                                var t = this._lookaheadToken(0);
                                var error = new Error("Expected " + tokenType + ", got: " + t.type);
                                error.name = "ParserError";
                                throw error;
                            }
                        },

                        _errorToken: function (token) {
                            var error = new Error("Invalid token (" +
                                token.type + "): \"" +
                                token.value + "\"");
                            error.name = "ParserError";
                            throw error;
                        },


                        _parseIndexExpression: function () {
                            if (this._lookahead(0) === TOK_COLON || this._lookahead(1) === TOK_COLON) {
                                return this._parseSliceExpression();
                            } else {
                                var node = {
                                    type: "Index",
                                    value: this._lookaheadToken(0).value
                                };
                                this._advance();
                                this._match(TOK_RBRACKET);
                                return node;
                            }
                        },

                        _projectIfSlice: function (left, right) {
                            var indexExpr = {type: "IndexExpression", children: [left, right]};
                            if (right.type === "Slice") {
                                return {
                                    type: "Projection",
                                    children: [indexExpr, this._parseProjectionRHS(bindingPower.Star)]
                                };
                            } else {
                                return indexExpr;
                            }
                        },

                        _parseSliceExpression: function () {
                            // [start:end:step] where each part is optional, as well as the last
                            // colon.
                            var parts = [null, null, null];
                            var index = 0;
                            var currentToken = this._lookahead(0);
                            while (currentToken !== TOK_RBRACKET && index < 3) {
                                if (currentToken === TOK_COLON) {
                                    index++;
                                    this._advance();
                                } else if (currentToken === TOK_NUMBER) {
                                    parts[index] = this._lookaheadToken(0).value;
                                    this._advance();
                                } else {
                                    var t = this._lookahead(0);
                                    var error = new Error("Syntax error, unexpected token: " +
                                        t.value + "(" + t.type + ")");
                                    error.name = "Parsererror";
                                    throw error;
                                }
                                currentToken = this._lookahead(0);
                            }
                            this._match(TOK_RBRACKET);
                            return {
                                type: "Slice",
                                children: parts
                            };
                        },

                        _parseComparator: function (left, comparator) {
                            var right = this.expression(bindingPower[comparator]);
                            return {type: "Comparator", name: comparator, children: [left, right]};
                        },

                        _parseDotRHS: function (rbp) {
                            var lookahead = this._lookahead(0);
                            var exprTokens = [TOK_UNQUOTEDIDENTIFIER, TOK_QUOTEDIDENTIFIER, TOK_STAR];
                            if (exprTokens.indexOf(lookahead) >= 0) {
                                return this.expression(rbp);
                            } else if (lookahead === TOK_LBRACKET) {
                                this._match(TOK_LBRACKET);
                                return this._parseMultiselectList();
                            } else if (lookahead === TOK_LBRACE) {
                                this._match(TOK_LBRACE);
                                return this._parseMultiselectHash();
                            }
                        },

                        _parseProjectionRHS: function (rbp) {
                            var right;
                            if (bindingPower[this._lookahead(0)] < 10) {
                                right = {type: "Identity"};
                            } else if (this._lookahead(0) === TOK_LBRACKET) {
                                right = this.expression(rbp);
                            } else if (this._lookahead(0) === TOK_FILTER) {
                                right = this.expression(rbp);
                            } else if (this._lookahead(0) === TOK_DOT) {
                                this._match(TOK_DOT);
                                right = this._parseDotRHS(rbp);
                            } else {
                                var t = this._lookaheadToken(0);
                                var error = new Error("Sytanx error, unexpected token: " +
                                    t.value + "(" + t.type + ")");
                                error.name = "ParserError";
                                throw error;
                            }
                            return right;
                        },

                        _parseMultiselectList: function () {
                            var expressions = [];
                            while (this._lookahead(0) !== TOK_RBRACKET) {
                                var expression = this.expression(0);
                                expressions.push(expression);
                                if (this._lookahead(0) === TOK_COMMA) {
                                    this._match(TOK_COMMA);
                                    if (this._lookahead(0) === TOK_RBRACKET) {
                                        throw new Error("Unexpected token Rbracket");
                                    }
                                }
                            }
                            this._match(TOK_RBRACKET);
                            return {type: "MultiSelectList", children: expressions};
                        },

                        _parseMultiselectHash: function () {
                            var pairs = [];
                            var identifierTypes = [TOK_UNQUOTEDIDENTIFIER, TOK_QUOTEDIDENTIFIER];
                            var keyToken, keyName, value, node;
                            for (; ;) {
                                keyToken = this._lookaheadToken(0);
                                if (identifierTypes.indexOf(keyToken.type) < 0) {
                                    throw new Error("Expecting an identifier token, got: " +
                                        keyToken.type);
                                }
                                keyName = keyToken.value;
                                this._advance();
                                this._match(TOK_COLON);
                                value = this.expression(0);
                                node = {type: "KeyValuePair", name: keyName, value: value};
                                pairs.push(node);
                                if (this._lookahead(0) === TOK_COMMA) {
                                    this._match(TOK_COMMA);
                                } else if (this._lookahead(0) === TOK_RBRACE) {
                                    this._match(TOK_RBRACE);
                                    break;
                                }
                            }
                            return {type: "MultiSelectHash", children: pairs};
                        }
                    };


                    function TreeInterpreter(runtime) {
                        this.runtime = runtime;
                    }

                    TreeInterpreter.prototype = {
                        search: function (node, value) {
                            return this.visit(node, value);
                        },

                        visit: function (node, value) {
                            var matched, current, result, first, second, field, left, right, collected, i;
                            switch (node.type) {
                                case "Field":
                                    if (value === null) {
                                        return null;
                                    } else if (isObject(value)) {
                                        field = value[node.name];
                                        if (field === undefined) {
                                            return null;
                                        } else {
                                            return field;
                                        }
                                    } else {
                                        return null;
                                    }
                                    break;
                                case "Subexpression":
                                    result = this.visit(node.children[0], value);
                                    for (i = 1; i < node.children.length; i++) {
                                        result = this.visit(node.children[1], result);
                                        if (result === null) {
                                            return null;
                                        }
                                    }
                                    return result;
                                case "IndexExpression":
                                    left = this.visit(node.children[0], value);
                                    right = this.visit(node.children[1], left);
                                    return right;
                                case "Index":
                                    if (!isArray(value)) {
                                        return null;
                                    }
                                    var index = node.value;
                                    if (index < 0) {
                                        index = value.length + index;
                                    }
                                    result = value[index];
                                    if (result === undefined) {
                                        result = null;
                                    }
                                    return result;
                                case "Slice":
                                    if (!isArray(value)) {
                                        return null;
                                    }
                                    var sliceParams = node.children.slice(0);
                                    var computed = this.computeSliceParams(value.length, sliceParams);
                                    var start = computed[0];
                                    var stop = computed[1];
                                    var step = computed[2];
                                    result = [];
                                    if (step > 0) {
                                        for (i = start; i < stop; i += step) {
                                            result.push(value[i]);
                                        }
                                    } else {
                                        for (i = start; i > stop; i += step) {
                                            result.push(value[i]);
                                        }
                                    }
                                    return result;
                                case "Projection":
                                    // Evaluate left child.
                                    var base = this.visit(node.children[0], value);
                                    if (!isArray(base)) {
                                        return null;
                                    }
                                    collected = [];
                                    for (i = 0; i < base.length; i++) {
                                        current = this.visit(node.children[1], base[i]);
                                        if (current !== null) {
                                            collected.push(current);
                                        }
                                    }
                                    return collected;
                                case "ValueProjection":
                                    // Evaluate left child.
                                    base = this.visit(node.children[0], value);
                                    if (!isObject(base)) {
                                        return null;
                                    }
                                    collected = [];
                                    var values = objValues(base);
                                    for (i = 0; i < values.length; i++) {
                                        current = this.visit(node.children[1], values[i]);
                                        if (current !== null) {
                                            collected.push(current);
                                        }
                                    }
                                    return collected;
                                case "FilterProjection":
                                    base = this.visit(node.children[0], value);
                                    if (!isArray(base)) {
                                        return null;
                                    }
                                    var filtered = [];
                                    var finalResults = [];
                                    for (i = 0; i < base.length; i++) {
                                        matched = this.visit(node.children[2], base[i]);
                                        if (!isFalse(matched)) {
                                            filtered.push(base[i]);
                                        }
                                    }
                                    for (var j = 0; j < filtered.length; j++) {
                                        current = this.visit(node.children[1], filtered[j]);
                                        if (current !== null) {
                                            finalResults.push(current);
                                        }
                                    }
                                    return finalResults;
                                case "Comparator":
                                    first = this.visit(node.children[0], value);
                                    second = this.visit(node.children[1], value);
                                    switch (node.name) {
                                        case TOK_EQ:
                                            result = strictDeepEqual(first, second);
                                            break;
                                        case TOK_NE:
                                            result = !strictDeepEqual(first, second);
                                            break;
                                        case TOK_GT:
                                            result = first > second;
                                            break;
                                        case TOK_GTE:
                                            result = first >= second;
                                            break;
                                        case TOK_LT:
                                            result = first < second;
                                            break;
                                        case TOK_LTE:
                                            result = first <= second;
                                            break;
                                        default:
                                            throw new Error("Unknown comparator: " + node.name);
                                    }
                                    return result;
                                case TOK_FLATTEN:
                                    var original = this.visit(node.children[0], value);
                                    if (!isArray(original)) {
                                        return null;
                                    }
                                    var merged = [];
                                    for (i = 0; i < original.length; i++) {
                                        current = original[i];
                                        if (isArray(current)) {
                                            merged.push.apply(merged, current);
                                        } else {
                                            merged.push(current);
                                        }
                                    }
                                    return merged;
                                case "Identity":
                                    return value;
                                case "MultiSelectList":
                                    if (value === null) {
                                        return null;
                                    }
                                    collected = [];
                                    for (i = 0; i < node.children.length; i++) {
                                        collected.push(this.visit(node.children[i], value));
                                    }
                                    return collected;
                                case "MultiSelectHash":
                                    if (value === null) {
                                        return null;
                                    }
                                    collected = {};
                                    var child;
                                    for (i = 0; i < node.children.length; i++) {
                                        child = node.children[i];
                                        collected[child.name] = this.visit(child.value, value);
                                    }
                                    return collected;
                                case "OrExpression":
                                    matched = this.visit(node.children[0], value);
                                    if (isFalse(matched)) {
                                        matched = this.visit(node.children[1], value);
                                    }
                                    return matched;
                                case "AndExpression":
                                    first = this.visit(node.children[0], value);

                                    if (isFalse(first) === true) {
                                        return first;
                                    }
                                    return this.visit(node.children[1], value);
                                case "NotExpression":
                                    first = this.visit(node.children[0], value);
                                    return isFalse(first);
                                case "Literal":
                                    return node.value;
                                case TOK_PIPE:
                                    left = this.visit(node.children[0], value);
                                    return this.visit(node.children[1], left);
                                case TOK_CURRENT:
                                    return value;
                                case "Function":
                                    var resolvedArgs = [];
                                    for (i = 0; i < node.children.length; i++) {
                                        resolvedArgs.push(this.visit(node.children[i], value));
                                    }
                                    return this.runtime.callFunction(node.name, resolvedArgs);
                                case "ExpressionReference":
                                    var refNode = node.children[0];
                                    // Tag the node with a specific attribute so the type
                                    // checker verify the type.
                                    refNode.jmespathType = TOK_EXPREF;
                                    return refNode;
                                default:
                                    throw new Error("Unknown node type: " + node.type);
                            }
                        },

                        computeSliceParams: function (arrayLength, sliceParams) {
                            var start = sliceParams[0];
                            var stop = sliceParams[1];
                            var step = sliceParams[2];
                            var computed = [null, null, null];
                            if (step === null) {
                                step = 1;
                            } else if (step === 0) {
                                var error = new Error("Invalid slice, step cannot be 0");
                                error.name = "RuntimeError";
                                throw error;
                            }
                            var stepValueNegative = step < 0 ? true : false;

                            if (start === null) {
                                start = stepValueNegative ? arrayLength - 1 : 0;
                            } else {
                                start = this.capSliceRange(arrayLength, start, step);
                            }

                            if (stop === null) {
                                stop = stepValueNegative ? -1 : arrayLength;
                            } else {
                                stop = this.capSliceRange(arrayLength, stop, step);
                            }
                            computed[0] = start;
                            computed[1] = stop;
                            computed[2] = step;
                            return computed;
                        },

                        capSliceRange: function (arrayLength, actualValue, step) {
                            if (actualValue < 0) {
                                actualValue += arrayLength;
                                if (actualValue < 0) {
                                    actualValue = step < 0 ? -1 : 0;
                                }
                            } else if (actualValue >= arrayLength) {
                                actualValue = step < 0 ? arrayLength - 1 : arrayLength;
                            }
                            return actualValue;
                        }

                    };

                    function Runtime(interpreter) {
                        this._interpreter = interpreter;
                        this.functionTable = {
                            // name: [function, <signature>]
                            // The <signature> can be:
                            //
                            // {
                            //   args: [[type1, type2], [type1, type2]],
                            //   variadic: true|false
                            // }
                            //
                            // Each arg in the arg list is a list of valid types
                            // (if the function is overloaded and supports multiple
                            // types.  If the type is "any" then no type checking
                            // occurs on the argument.  Variadic is optional
                            // and if not provided is assumed to be false.
                            abs: {_func: this._functionAbs, _signature: [{types: [TYPE_NUMBER]}]},
                            avg: {_func: this._functionAvg, _signature: [{types: [TYPE_ARRAY_NUMBER]}]},
                            ceil: {_func: this._functionCeil, _signature: [{types: [TYPE_NUMBER]}]},
                            contains: {
                                _func: this._functionContains,
                                _signature: [{types: [TYPE_STRING, TYPE_ARRAY]},
                                    {types: [TYPE_ANY]}]
                            },
                            "ends_with": {
                                _func: this._functionEndsWith,
                                _signature: [{types: [TYPE_STRING]}, {types: [TYPE_STRING]}]
                            },
                            floor: {_func: this._functionFloor, _signature: [{types: [TYPE_NUMBER]}]},
                            length: {
                                _func: this._functionLength,
                                _signature: [{types: [TYPE_STRING, TYPE_ARRAY, TYPE_OBJECT]}]
                            },
                            map: {
                                _func: this._functionMap,
                                _signature: [{types: [TYPE_EXPREF]}, {types: [TYPE_ARRAY]}]
                            },
                            max: {
                                _func: this._functionMax,
                                _signature: [{types: [TYPE_ARRAY_NUMBER, TYPE_ARRAY_STRING]}]
                            },
                            "merge": {
                                _func: this._functionMerge,
                                _signature: [{types: [TYPE_OBJECT], variadic: true}]
                            },
                            "max_by": {
                                _func: this._functionMaxBy,
                                _signature: [{types: [TYPE_ARRAY]}, {types: [TYPE_EXPREF]}]
                            },
                            sum: {_func: this._functionSum, _signature: [{types: [TYPE_ARRAY_NUMBER]}]},
                            "starts_with": {
                                _func: this._functionStartsWith,
                                _signature: [{types: [TYPE_STRING]}, {types: [TYPE_STRING]}]
                            },
                            min: {
                                _func: this._functionMin,
                                _signature: [{types: [TYPE_ARRAY_NUMBER, TYPE_ARRAY_STRING]}]
                            },
                            "min_by": {
                                _func: this._functionMinBy,
                                _signature: [{types: [TYPE_ARRAY]}, {types: [TYPE_EXPREF]}]
                            },
                            type: {_func: this._functionType, _signature: [{types: [TYPE_ANY]}]},
                            keys: {_func: this._functionKeys, _signature: [{types: [TYPE_OBJECT]}]},
                            values: {_func: this._functionValues, _signature: [{types: [TYPE_OBJECT]}]},
                            sort: {
                                _func: this._functionSort,
                                _signature: [{types: [TYPE_ARRAY_STRING, TYPE_ARRAY_NUMBER]}]
                            },
                            "sort_by": {
                                _func: this._functionSortBy,
                                _signature: [{types: [TYPE_ARRAY]}, {types: [TYPE_EXPREF]}]
                            },
                            join: {
                                _func: this._functionJoin,
                                _signature: [
                                    {types: [TYPE_STRING]},
                                    {types: [TYPE_ARRAY_STRING]}
                                ]
                            },
                            reverse: {
                                _func: this._functionReverse,
                                _signature: [{types: [TYPE_STRING, TYPE_ARRAY]}]
                            },
                            "to_array": {_func: this._functionToArray, _signature: [{types: [TYPE_ANY]}]},
                            "to_string": {_func: this._functionToString, _signature: [{types: [TYPE_ANY]}]},
                            "to_number": {_func: this._functionToNumber, _signature: [{types: [TYPE_ANY]}]},
                            "not_null": {
                                _func: this._functionNotNull,
                                _signature: [{types: [TYPE_ANY], variadic: true}]
                            }
                        };
                    }

                    Runtime.prototype = {
                        callFunction: function (name, resolvedArgs) {
                            var functionEntry = this.functionTable[name];
                            if (functionEntry === undefined) {
                                throw new Error("Unknown function: " + name + "()");
                            }
                            this._validateArgs(name, resolvedArgs, functionEntry._signature);
                            return functionEntry._func.call(this, resolvedArgs);
                        },

                        _validateArgs: function (name, args, signature) {
                            // Validating the args requires validating
                            // the correct arity and the correct type of each arg.
                            // If the last argument is declared as variadic, then we need
                            // a minimum number of args to be required.  Otherwise it has to
                            // be an exact amount.
                            var pluralized;
                            if (signature[signature.length - 1].variadic) {
                                if (args.length < signature.length) {
                                    pluralized = signature.length === 1 ? " argument" : " arguments";
                                    throw new Error("ArgumentError: " + name + "() " +
                                        "takes at least" + signature.length + pluralized +
                                        " but received " + args.length);
                                }
                            } else if (args.length !== signature.length) {
                                pluralized = signature.length === 1 ? " argument" : " arguments";
                                throw new Error("ArgumentError: " + name + "() " +
                                    "takes " + signature.length + pluralized +
                                    " but received " + args.length);
                            }
                            var currentSpec;
                            var actualType;
                            var typeMatched;
                            for (var i = 0; i < signature.length; i++) {
                                typeMatched = false;
                                currentSpec = signature[i].types;
                                actualType = this._getTypeName(args[i]);
                                for (var j = 0; j < currentSpec.length; j++) {
                                    if (this._typeMatches(actualType, currentSpec[j], args[i])) {
                                        typeMatched = true;
                                        break;
                                    }
                                }
                                if (!typeMatched) {
                                    throw new Error("TypeError: " + name + "() " +
                                        "expected argument " + (i + 1) +
                                        " to be type " + currentSpec +
                                        " but received type " + actualType +
                                        " instead.");
                                }
                            }
                        },

                        _typeMatches: function (actual, expected, argValue) {
                            if (expected === TYPE_ANY) {
                                return true;
                            }
                            if (expected === TYPE_ARRAY_STRING ||
                                expected === TYPE_ARRAY_NUMBER ||
                                expected === TYPE_ARRAY) {
                                // The expected type can either just be array,
                                // or it can require a specific subtype (array of numbers).
                                //
                                // The simplest case is if "array" with no subtype is specified.
                                if (expected === TYPE_ARRAY) {
                                    return actual === TYPE_ARRAY;
                                } else if (actual === TYPE_ARRAY) {
                                    // Otherwise we need to check subtypes.
                                    // I think this has potential to be improved.
                                    var subtype;
                                    if (expected === TYPE_ARRAY_NUMBER) {
                                        subtype = TYPE_NUMBER;
                                    } else if (expected === TYPE_ARRAY_STRING) {
                                        subtype = TYPE_STRING;
                                    }
                                    for (var i = 0; i < argValue.length; i++) {
                                        if (!this._typeMatches(
                                            this._getTypeName(argValue[i]), subtype,
                                            argValue[i])) {
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            } else {
                                return actual === expected;
                            }
                        },
                        _getTypeName: function (obj) {
                            switch (Object.prototype.toString.call(obj)) {
                                case "[object String]":
                                    return TYPE_STRING;
                                case "[object Number]":
                                    return TYPE_NUMBER;
                                case "[object Array]":
                                    return TYPE_ARRAY;
                                case "[object Boolean]":
                                    return TYPE_BOOLEAN;
                                case "[object Null]":
                                    return TYPE_NULL;
                                case "[object Object]":
                                    // Check if it's an expref.  If it has, it's been
                                    // tagged with a jmespathType attr of 'Expref';
                                    if (obj.jmespathType === TOK_EXPREF) {
                                        return TYPE_EXPREF;
                                    } else {
                                        return TYPE_OBJECT;
                                    }
                            }
                        },

                        _functionStartsWith: function (resolvedArgs) {
                            return resolvedArgs[0].lastIndexOf(resolvedArgs[1]) === 0;
                        },

                        _functionEndsWith: function (resolvedArgs) {
                            var searchStr = resolvedArgs[0];
                            var suffix = resolvedArgs[1];
                            return searchStr.indexOf(suffix, searchStr.length - suffix.length) !== -1;
                        },

                        _functionReverse: function (resolvedArgs) {
                            var typeName = this._getTypeName(resolvedArgs[0]);
                            if (typeName === TYPE_STRING) {
                                var originalStr = resolvedArgs[0];
                                var reversedStr = "";
                                for (var i = originalStr.length - 1; i >= 0; i--) {
                                    reversedStr += originalStr[i];
                                }
                                return reversedStr;
                            } else {
                                var reversedArray = resolvedArgs[0].slice(0);
                                reversedArray.reverse();
                                return reversedArray;
                            }
                        },

                        _functionAbs: function (resolvedArgs) {
                            return Math.abs(resolvedArgs[0]);
                        },

                        _functionCeil: function (resolvedArgs) {
                            return Math.ceil(resolvedArgs[0]);
                        },

                        _functionAvg: function (resolvedArgs) {
                            var sum = 0;
                            var inputArray = resolvedArgs[0];
                            for (var i = 0; i < inputArray.length; i++) {
                                sum += inputArray[i];
                            }
                            return sum / inputArray.length;
                        },

                        _functionContains: function (resolvedArgs) {
                            return resolvedArgs[0].indexOf(resolvedArgs[1]) >= 0;
                        },

                        _functionFloor: function (resolvedArgs) {
                            return Math.floor(resolvedArgs[0]);
                        },

                        _functionLength: function (resolvedArgs) {
                            if (!isObject(resolvedArgs[0])) {
                                return resolvedArgs[0].length;
                            } else {
                                // As far as I can tell, there's no way to get the length
                                // of an object without O(n) iteration through the object.
                                return Object.keys(resolvedArgs[0]).length;
                            }
                        },

                        _functionMap: function (resolvedArgs) {
                            var mapped = [];
                            var interpreter = this._interpreter;
                            var exprefNode = resolvedArgs[0];
                            var elements = resolvedArgs[1];
                            for (var i = 0; i < elements.length; i++) {
                                mapped.push(interpreter.visit(exprefNode, elements[i]));
                            }
                            return mapped;
                        },

                        _functionMerge: function (resolvedArgs) {
                            var merged = {};
                            for (var i = 0; i < resolvedArgs.length; i++) {
                                var current = resolvedArgs[i];
                                for (var key in current) {
                                    merged[key] = current[key];
                                }
                            }
                            return merged;
                        },

                        _functionMax: function (resolvedArgs) {
                            if (resolvedArgs[0].length > 0) {
                                var typeName = this._getTypeName(resolvedArgs[0][0]);
                                if (typeName === TYPE_NUMBER) {
                                    return Math.max.apply(Math, resolvedArgs[0]);
                                } else {
                                    var elements = resolvedArgs[0];
                                    var maxElement = elements[0];
                                    for (var i = 1; i < elements.length; i++) {
                                        if (maxElement.localeCompare(elements[i]) < 0) {
                                            maxElement = elements[i];
                                        }
                                    }
                                    return maxElement;
                                }
                            } else {
                                return null;
                            }
                        },

                        _functionMin: function (resolvedArgs) {
                            if (resolvedArgs[0].length > 0) {
                                var typeName = this._getTypeName(resolvedArgs[0][0]);
                                if (typeName === TYPE_NUMBER) {
                                    return Math.min.apply(Math, resolvedArgs[0]);
                                } else {
                                    var elements = resolvedArgs[0];
                                    var minElement = elements[0];
                                    for (var i = 1; i < elements.length; i++) {
                                        if (elements[i].localeCompare(minElement) < 0) {
                                            minElement = elements[i];
                                        }
                                    }
                                    return minElement;
                                }
                            } else {
                                return null;
                            }
                        },

                        _functionSum: function (resolvedArgs) {
                            var sum = 0;
                            var listToSum = resolvedArgs[0];
                            for (var i = 0; i < listToSum.length; i++) {
                                sum += listToSum[i];
                            }
                            return sum;
                        },

                        _functionType: function (resolvedArgs) {
                            switch (this._getTypeName(resolvedArgs[0])) {
                                case TYPE_NUMBER:
                                    return "number";
                                case TYPE_STRING:
                                    return "string";
                                case TYPE_ARRAY:
                                    return "array";
                                case TYPE_OBJECT:
                                    return "object";
                                case TYPE_BOOLEAN:
                                    return "boolean";
                                case TYPE_EXPREF:
                                    return "expref";
                                case TYPE_NULL:
                                    return "null";
                            }
                        },

                        _functionKeys: function (resolvedArgs) {
                            return Object.keys(resolvedArgs[0]);
                        },

                        _functionValues: function (resolvedArgs) {
                            var obj = resolvedArgs[0];
                            var keys = Object.keys(obj);
                            var values = [];
                            for (var i = 0; i < keys.length; i++) {
                                values.push(obj[keys[i]]);
                            }
                            return values;
                        },

                        _functionJoin: function (resolvedArgs) {
                            var joinChar = resolvedArgs[0];
                            var listJoin = resolvedArgs[1];
                            return listJoin.join(joinChar);
                        },

                        _functionToArray: function (resolvedArgs) {
                            if (this._getTypeName(resolvedArgs[0]) === TYPE_ARRAY) {
                                return resolvedArgs[0];
                            } else {
                                return [resolvedArgs[0]];
                            }
                        },

                        _functionToString: function (resolvedArgs) {
                            if (this._getTypeName(resolvedArgs[0]) === TYPE_STRING) {
                                return resolvedArgs[0];
                            } else {
                                return JSON.stringify(resolvedArgs[0]);
                            }
                        },

                        _functionToNumber: function (resolvedArgs) {
                            var typeName = this._getTypeName(resolvedArgs[0]);
                            var convertedValue;
                            if (typeName === TYPE_NUMBER) {
                                return resolvedArgs[0];
                            } else if (typeName === TYPE_STRING) {
                                convertedValue = +resolvedArgs[0];
                                if (!isNaN(convertedValue)) {
                                    return convertedValue;
                                }
                            }
                            return null;
                        },

                        _functionNotNull: function (resolvedArgs) {
                            for (var i = 0; i < resolvedArgs.length; i++) {
                                if (this._getTypeName(resolvedArgs[i]) !== TYPE_NULL) {
                                    return resolvedArgs[i];
                                }
                            }
                            return null;
                        },

                        _functionSort: function (resolvedArgs) {
                            var sortedArray = resolvedArgs[0].slice(0);
                            sortedArray.sort();
                            return sortedArray;
                        },

                        _functionSortBy: function (resolvedArgs) {
                            var sortedArray = resolvedArgs[0].slice(0);
                            if (sortedArray.length === 0) {
                                return sortedArray;
                            }
                            var interpreter = this._interpreter;
                            var exprefNode = resolvedArgs[1];
                            var requiredType = this._getTypeName(
                                interpreter.visit(exprefNode, sortedArray[0]));
                            if ([TYPE_NUMBER, TYPE_STRING].indexOf(requiredType) < 0) {
                                throw new Error("TypeError");
                            }
                            var that = this;
                            // In order to get a stable sort out of an unstable
                            // sort algorithm, we decorate/sort/undecorate (DSU)
                            // by creating a new list of [index, element] pairs.
                            // In the cmp function, if the evaluated elements are
                            // equal, then the index will be used as the tiebreaker.
                            // After the decorated list has been sorted, it will be
                            // undecorated to extract the original elements.
                            var decorated = [];
                            for (var i = 0; i < sortedArray.length; i++) {
                                decorated.push([i, sortedArray[i]]);
                            }
                            decorated.sort(function (a, b) {
                                var exprA = interpreter.visit(exprefNode, a[1]);
                                var exprB = interpreter.visit(exprefNode, b[1]);
                                if (that._getTypeName(exprA) !== requiredType) {
                                    throw new Error(
                                        "TypeError: expected " + requiredType + ", received " +
                                        that._getTypeName(exprA));
                                } else if (that._getTypeName(exprB) !== requiredType) {
                                    throw new Error(
                                        "TypeError: expected " + requiredType + ", received " +
                                        that._getTypeName(exprB));
                                }
                                if (exprA > exprB) {
                                    return 1;
                                } else if (exprA < exprB) {
                                    return -1;
                                } else {
                                    // If they're equal compare the items by their
                                    // order to maintain relative order of equal keys
                                    // (i.e. to get a stable sort).
                                    return a[0] - b[0];
                                }
                            });
                            // Undecorate: extract out the original list elements.
                            for (var j = 0; j < decorated.length; j++) {
                                sortedArray[j] = decorated[j][1];
                            }
                            return sortedArray;
                        },

                        _functionMaxBy: function (resolvedArgs) {
                            var exprefNode = resolvedArgs[1];
                            var resolvedArray = resolvedArgs[0];
                            var keyFunction = this.createKeyFunction(exprefNode, [TYPE_NUMBER, TYPE_STRING]);
                            var maxNumber = -Infinity;
                            var maxRecord;
                            var current;
                            for (var i = 0; i < resolvedArray.length; i++) {
                                current = keyFunction(resolvedArray[i]);
                                if (current > maxNumber) {
                                    maxNumber = current;
                                    maxRecord = resolvedArray[i];
                                }
                            }
                            return maxRecord;
                        },

                        _functionMinBy: function (resolvedArgs) {
                            var exprefNode = resolvedArgs[1];
                            var resolvedArray = resolvedArgs[0];
                            var keyFunction = this.createKeyFunction(exprefNode, [TYPE_NUMBER, TYPE_STRING]);
                            var minNumber = Infinity;
                            var minRecord;
                            var current;
                            for (var i = 0; i < resolvedArray.length; i++) {
                                current = keyFunction(resolvedArray[i]);
                                if (current < minNumber) {
                                    minNumber = current;
                                    minRecord = resolvedArray[i];
                                }
                            }
                            return minRecord;
                        },

                        createKeyFunction: function (exprefNode, allowedTypes) {
                            var that = this;
                            var interpreter = this._interpreter;
                            var keyFunc = function (x) {
                                var current = interpreter.visit(exprefNode, x);
                                if (allowedTypes.indexOf(that._getTypeName(current)) < 0) {
                                    var msg = "TypeError: expected one of " + allowedTypes +
                                        ", received " + that._getTypeName(current);
                                    throw new Error(msg);
                                }
                                return current;
                            };
                            return keyFunc;
                        }

                    };

                    function compile(stream) {
                        var parser = new Parser();
                        var ast = parser.parse(stream);
                        return ast;
                    }

                    function tokenize(stream) {
                        var lexer = new Lexer();
                        return lexer.tokenize(stream);
                    }

                    function search(data, expression) {
                        var parser = new Parser();
                        // This needs to be improved.  Both the interpreter and runtime depend on
                        // each other.  The runtime needs the interpreter to support exprefs.
                        // There's likely a clean way to avoid the cyclic dependency.
                        var runtime = new Runtime();
                        var interpreter = new TreeInterpreter(runtime);
                        runtime._interpreter = interpreter;
                        var node = parser.parse(expression);
                        return interpreter.search(node, data);
                    }

                    exports.tokenize = tokenize;
                    exports.compile = compile;
                    exports.search = search;
                    exports.strictDeepEqual = strictDeepEqual;
                })(false ? undefined : exports);


                /***/
            }),
            /* 35 */
            /***/ (function (module, exports, __webpack_require__) {

                exports.tryRequireThemeJsonEditor = function () {
                    try {
                        __webpack_require__(42);
                    } catch (err) {
                        console.error(err);
                    }
                };

                /***/
            }),
            /* 36 */
            /***/ (function (module, exports, __webpack_require__) {

                "use strict";


                var ace = __webpack_require__(20); // may be undefined in case of minimalist bundle


                var VanillaPicker = __webpack_require__(13); // may be undefined in case of minimalist bundle


                var _require = __webpack_require__(80),
                    treeModeMixins = _require.treeModeMixins;

                var _require2 = __webpack_require__(21),
                    textModeMixins = _require2.textModeMixins;

                var _require3 = __webpack_require__(81),
                    previewModeMixins = _require3.previewModeMixins;

                var _require4 = __webpack_require__(0),
                    clear = _require4.clear,
                    extend = _require4.extend,
                    getInternetExplorerVersion = _require4.getInternetExplorerVersion,
                    parse = _require4.parse;

                var _require5 = __webpack_require__(43),
                    tryRequireAjv = _require5.tryRequireAjv;

                var _require6 = __webpack_require__(6),
                    showTransformModal = _require6.showTransformModal;

                var _require7 = __webpack_require__(5),
                    showSortModal = _require7.showSortModal;

                var Ajv = tryRequireAjv();

                if (typeof Promise === 'undefined') {
                    console.error('Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor');
                }

                /**
                 * @constructor JSONEditor
                 * @param {Element} container    Container element
                 * @param {Object}  [options]    Object with options. available options:
                 *                               {String} mode        Editor mode. Available values:
                 *                                                    'tree' (default), 'view',
                 *                                                    'form', 'text', and 'code'.
                 *                               {function} onChange  Callback method, triggered
                 *                                                    on change of contents.
                 *                                                    Does not pass the contents itself.
                 *                                                    See also `onChangeJSON` and
                 *                                                    `onChangeText`.
                 *                               {function} onChangeJSON  Callback method, triggered
                 *                                                        in modes on change of contents,
                 *                                                        passing the changed contents
                 *                                                        as JSON.
                 *                                                        Only applicable for modes
                 *                                                        'tree', 'view', and 'form'.
                 *                               {function} onChangeText  Callback method, triggered
                 *                                                        in modes on change of contents,
                 *                                                        passing the changed contents
                 *                                                        as stringified JSON.
                 *                               {function} onError   Callback method, triggered
                 *                                                    when an error occurs
                 *                               {Boolean} search     Enable search box.
                 *                                                    True by default
                 *                                                    Only applicable for modes
                 *                                                    'tree', 'view', and 'form'
                 *                               {Boolean} history    Enable history (undo/redo).
                 *                                                    True by default
                 *                                                    Only applicable for modes
                 *                                                    'tree', 'view', and 'form'
                 *                               {String} name        Field name for the root node.
                 *                                                    Only applicable for modes
                 *                                                    'tree', 'view', and 'form'
                 *                               {Number} indentation     Number of indentation
                 *                                                        spaces. 4 by default.
                 *                                                        Only applicable for
                 *                                                        modes 'text' and 'code'
                 *                               {boolean} escapeUnicode  If true, unicode
                 *                                                        characters are escaped.
                 *                                                        false by default.
                 *                               {boolean} sortObjectKeys If true, object keys are
                 *                                                        sorted before display.
                 *                                                        false by default.
                 *                               {function} onSelectionChange Callback method,
                 *                                                            triggered on node selection change
                 *                                                            Only applicable for modes
                 *                                                            'tree', 'view', and 'form'
                 *                               {function} onTextSelectionChange Callback method,
                 *                                                                triggered on text selection change
                 *                                                                Only applicable for modes
                 *                               {HTMLElement} modalAnchor        The anchor element to apply an
                 *                                                                overlay and display the modals in a
                 *                                                                centered location.
                 *                                                                Defaults to document.body
                 *                                                                'text' and 'code'
                 *                               {function} onEvent Callback method, triggered
                 *                                                  when an event occurs in
                 *                                                  a JSON field or value.
                 *                                                  Only applicable for
                 *                                                  modes 'form', 'tree' and
                 *                                                  'view'
                 *                               {function} onFocus  Callback method, triggered
                 *                                                   when the editor comes into focus,
                 *                                                   passing an object {type, target},
                 *                                                   Applicable for all modes
                 *                               {function} onBlur   Callback method, triggered
                 *                                                   when the editor goes out of focus,
                 *                                                   passing an object {type, target},
                 *                                                   Applicable for all modes
                 *                               {function} onClassName Callback method, triggered
                 *                                                  when a Node DOM is rendered. Function returns
                 *                                                  a css class name to be set on a node.
                 *                                                  Only applicable for
                 *                                                  modes 'form', 'tree' and
                 *                                                  'view'
                 *                               {Number} maxVisibleChilds Number of children allowed for a node
                 *                                                         in 'tree', 'view', or 'form' mode before
                 *                                                         the "show more/show all" buttons appear.
                 *                                                         100 by default.
                 *
                 * @param {Object | undefined} json JSON object
                 */


                function JSONEditor(container, options, json) {
                    if (!(this instanceof JSONEditor)) {
                        throw new Error('JSONEditor constructor called without "new".');
                    } // check for unsupported browser (IE8 and older)


                    var ieVersion = getInternetExplorerVersion();

                    if (ieVersion !== -1 && ieVersion < 9) {
                        throw new Error('Unsupported browser, IE9 or newer required. ' + 'Please install the newest version of your browser.');
                    }

                    if (options) {
                        // check for deprecated options
                        if (options.error) {
                            console.warn('Option "error" has been renamed to "onError"');
                            options.onError = options.error;
                            delete options.error;
                        }

                        if (options.change) {
                            console.warn('Option "change" has been renamed to "onChange"');
                            options.onChange = options.change;
                            delete options.change;
                        }

                        if (options.editable) {
                            console.warn('Option "editable" has been renamed to "onEditable"');
                            options.onEditable = options.editable;
                            delete options.editable;
                        } // warn if onChangeJSON is used when mode can be `text` or `code`


                        if (options.onChangeJSON) {
                            if (options.mode === 'text' || options.mode === 'code' || options.modes && (options.modes.indexOf('text') !== -1 || options.modes.indexOf('code') !== -1)) {
                                console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". ' + 'Use "onChangeText" or "onChange" instead.');
                            }
                        } // validate options


                        if (options) {
                            Object.keys(options).forEach(function (option) {
                                if (JSONEditor.VALID_OPTIONS.indexOf(option) === -1) {
                                    console.warn('Unknown option "' + option + '". This option will be ignored');
                                }
                            });
                        }
                    }

                    if (arguments.length) {
                        this._create(container, options, json);
                    }
                }

                /**
                 * Configuration for all registered modes. Example:
                 * {
                 *     tree: {
                 *         mixin: TreeEditor,
                 *         data: 'json'
                 *     },
                 *     text: {
                 *         mixin: TextEditor,
                 *         data: 'text'
                 *     }
                 * }
                 *
                 * @type { Object.<String, {mixin: Object, data: String} > }
                 */


                JSONEditor.modes = {}; // debounce interval for JSON schema vaidation in milliseconds

                JSONEditor.prototype.DEBOUNCE_INTERVAL = 150;
                JSONEditor.VALID_OPTIONS = ['ajv', 'schema', 'schemaRefs', 'templates', 'ace', 'theme', 'autocomplete', 'onChange', 'onChangeJSON', 'onChangeText', 'onEditable', 'onError', 'onEvent', 'onModeChange', 'onNodeName', 'onValidate', 'onCreateMenu', 'onSelectionChange', 'onTextSelectionChange', 'onClassName', 'onFocus', 'onBlur', 'colorPicker', 'onColorPicker', 'timestampTag', 'timestampFormat', 'escapeUnicode', 'history', 'search', 'mode', 'modes', 'name', 'indentation', 'sortObjectKeys', 'navigationBar', 'statusBar', 'mainMenuBar', 'languages', 'language', 'enableSort', 'enableTransform', 'maxVisibleChilds', 'onValidationError', 'modalAnchor', 'popupAnchor', 'createQuery', 'executeQuery', 'queryDescription'];
                /**
                 * Create the JSONEditor
                 * @param {Element} container    Container element
                 * @param {Object}  [options]    See description in constructor
                 * @param {Object | undefined} json JSON object
                 * @private
                 */

                JSONEditor.prototype._create = function (container, options, json) {
                    this.container = container;
                    this.options = options || {};
                    this.json = json || {};
                    var mode = this.options.mode || this.options.modes && this.options.modes[0] || 'tree';
                    this.setMode(mode);
                };
                /**
                 * Destroy the editor. Clean up DOM, event listeners, and web workers.
                 */


                JSONEditor.prototype.destroy = function () {
                };
                /**
                 * Set JSON object in editor
                 * @param {Object | undefined} json      JSON data
                 */


                JSONEditor.prototype.set = function (json) {
                    this.json = json;
                };
                /**
                 * Get JSON from the editor
                 * @returns {Object} json
                 */


                JSONEditor.prototype.get = function () {
                    return this.json;
                };
                /**
                 * Set string containing JSON for the editor
                 * @param {String | undefined} jsonText
                 */


                JSONEditor.prototype.setText = function (jsonText) {
                    this.json = parse(jsonText);
                };
                /**
                 * Get stringified JSON contents from the editor
                 * @returns {String} jsonText
                 */


                JSONEditor.prototype.getText = function () {
                    return JSON.stringify(this.json);
                };
                /**
                 * Set a field name for the root node.
                 * @param {String | undefined} name
                 */


                JSONEditor.prototype.setName = function (name) {
                    if (!this.options) {
                        this.options = {};
                    }

                    this.options.name = name;
                };
                /**
                 * Get the field name for the root node.
                 * @return {String | undefined} name
                 */


                JSONEditor.prototype.getName = function () {
                    return this.options && this.options.name;
                };
                /**
                 * Change the mode of the editor.
                 * JSONEditor will be extended with all methods needed for the chosen mode.
                 * @param {String} mode     Available modes: 'tree' (default), 'view', 'form',
                 *                          'text', and 'code'.
                 */


                JSONEditor.prototype.setMode = function (mode) {
                    // if the mode is the same as current mode (and it's not the first time), do nothing.
                    if (mode === this.options.mode && this.create) {
                        return;
                    }

                    var container = this.container;
                    var options = extend({}, this.options);
                    var oldMode = options.mode;
                    var data;
                    var name;
                    options.mode = mode;
                    var config = JSONEditor.modes[mode];

                    if (config) {
                        try {
                            var asText = config.data === 'text';
                            name = this.getName();
                            data = this[asText ? 'getText' : 'get'](); // get text or json

                            this.destroy();
                            clear(this);
                            extend(this, config.mixin);
                            this.create(container, options);
                            this.setName(name);
                            this[asText ? 'setText' : 'set'](data); // set text or json

                            if (typeof config.load === 'function') {
                                try {
                                    config.load.call(this);
                                } catch (err) {
                                    console.error(err);
                                }
                            }

                            if (typeof options.onModeChange === 'function' && mode !== oldMode) {
                                try {
                                    options.onModeChange(mode, oldMode);
                                } catch (err) {
                                    console.error(err);
                                }
                            }
                        } catch (err) {
                            this._onError(err);
                        }
                    } else {
                        throw new Error('Unknown mode "' + options.mode + '"');
                    }
                };
                /**
                 * Get the current mode
                 * @return {string}
                 */


                JSONEditor.prototype.getMode = function () {
                    return this.options.mode;
                };
                /**
                 * Throw an error. If an error callback is configured in options.error, this
                 * callback will be invoked. Else, a regular error is thrown.
                 * @param {Error} err
                 * @private
                 */


                JSONEditor.prototype._onError = function (err) {
                    if (this.options && typeof this.options.onError === 'function') {
                        this.options.onError(err);
                    } else {
                        throw err;
                    }
                };
                /**
                 * Set a JSON schema for validation of the JSON object.
                 * To remove the schema, call JSONEditor.setSchema(null)
                 * @param {Object | null} schema
                 * @param {Object.<string, Object>=} schemaRefs Schemas that are referenced using the `$ref` property from the JSON schema that are set in the `schema` option,
                 +  the object structure in the form of `{reference_key: schemaObject}`
                 */


                JSONEditor.prototype.setSchema = function (schema, schemaRefs) {
                    // compile a JSON schema validator if a JSON schema is provided
                    if (schema) {
                        var ajv;

                        try {
                            // grab ajv from options if provided, else create a new instance
                            if (this.options.ajv) {
                                ajv = this.options.ajv;
                            } else {
                                ajv = Ajv({
                                    allErrors: true,
                                    verbose: true,
                                    schemaId: 'auto',
                                    $data: true
                                }); // support both draft-04 and draft-06 alongside the latest draft-07

                                ajv.addMetaSchema(__webpack_require__(78));
                                ajv.addMetaSchema(__webpack_require__(79));
                            }
                        } catch (err) {
                            console.warn('Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.');
                        }

                        if (ajv) {
                            if (schemaRefs) {
                                for (var ref in schemaRefs) {
                                    ajv.removeSchema(ref); // When updating a schema - old refs has to be removed first

                                    if (schemaRefs[ref]) {
                                        ajv.addSchema(schemaRefs[ref], ref);
                                    }
                                }

                                this.options.schemaRefs = schemaRefs;
                            }

                            this.validateSchema = ajv.compile(schema); // add schema to the options, so that when switching to an other mode,
                            // the set schema is not lost

                            this.options.schema = schema; // validate now

                            this.validate();
                        }

                        this.refresh(); // update DOM
                    } else {
                        // remove current schema
                        this.validateSchema = null;
                        this.options.schema = null;
                        this.options.schemaRefs = null;
                        this.validate(); // to clear current error messages

                        this.refresh(); // update DOM
                    }
                };
                /**
                 * Validate current JSON object against the configured JSON schema
                 * Throws an exception when no JSON schema is configured
                 */


                JSONEditor.prototype.validate = function () {
                } // must be implemented by treemode and textmode

                /**
                 * Refresh the rendered contents
                 */
                ;

                JSONEditor.prototype.refresh = function () {
                } // can be implemented by treemode and textmode

                /**
                 * Register a plugin with one ore multiple modes for the JSON Editor.
                 *
                 * A mode is described as an object with properties:
                 *
                 * - `mode: String`           The name of the mode.
                 * - `mixin: Object`          An object containing the mixin functions which
                 *                            will be added to the JSONEditor. Must contain functions
                 *                            create, get, getText, set, and setText. May have
                 *                            additional functions.
                 *                            When the JSONEditor switches to a mixin, all mixin
                 *                            functions are added to the JSONEditor, and then
                 *                            the function `create(container, options)` is executed.
                 * - `data: 'text' | 'json'`  The type of data that will be used to load the mixin.
                 * - `[load: function]`       An optional function called after the mixin
                 *                            has been loaded.
                 *
                 * @param {Object | Array} mode  A mode object or an array with multiple mode objects.
                 */
                ;

                JSONEditor.registerMode = function (mode) {
                    var i, prop;

                    if (Array.isArray(mode)) {
                        // multiple modes
                        for (i = 0; i < mode.length; i++) {
                            JSONEditor.registerMode(mode[i]);
                        }
                    } else {
                        // validate the new mode
                        if (!('mode' in mode)) throw new Error('Property "mode" missing');
                        if (!('mixin' in mode)) throw new Error('Property "mixin" missing');
                        if (!('data' in mode)) throw new Error('Property "data" missing');
                        var name = mode.mode;

                        if (name in JSONEditor.modes) {
                            throw new Error('Mode "' + name + '" already registered');
                        } // validate the mixin


                        if (typeof mode.mixin.create !== 'function') {
                            throw new Error('Required function "create" missing on mixin');
                        }

                        var reserved = ['setMode', 'registerMode', 'modes'];

                        for (i = 0; i < reserved.length; i++) {
                            prop = reserved[i];

                            if (prop in mode.mixin) {
                                throw new Error('Reserved property "' + prop + '" not allowed in mixin');
                            }
                        }

                        JSONEditor.modes[name] = mode;
                    }
                }; // register tree, text, and preview modes


                JSONEditor.registerMode(treeModeMixins);
                JSONEditor.registerMode(textModeMixins);
                JSONEditor.registerMode(previewModeMixins); // expose some of the libraries that can be used customized

                JSONEditor.ace = ace;
                JSONEditor.Ajv = Ajv;
                JSONEditor.VanillaPicker = VanillaPicker; // expose some utils (this is undocumented, unofficial)

                JSONEditor.showTransformModal = showTransformModal;
                JSONEditor.showSortModal = showSortModal; // default export for TypeScript ES6 projects

                JSONEditor["default"] = JSONEditor;
                module.exports = JSONEditor;

                /***/
            }),
            /* 37 */
            /***/ (function (module, exports, __webpack_require__) {

                /* WEBPACK VAR INJECTION */
                (function (module) {/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

                    /**
                     * Define a module along with a payload
                     * @param module a name for the payload
                     * @param payload a function to call with (require, exports, module) params
                     */

                    (function () {

                        var ACE_NAMESPACE = "ace";

                        var global = (function () {
                            return this;
                        })();
                        if (!global && typeof window != "undefined") global = window; // strict mode


                        if (!ACE_NAMESPACE && typeof requirejs !== "undefined")
                            return;


                        var define = function (module, deps, payload) {
                            if (typeof module !== "string") {
                                if (define.original)
                                    define.original.apply(this, arguments);
                                else {
                                    console.error("dropping module because define wasn\'t a string.");
                                    console.trace();
                                }
                                return;
                            }
                            if (arguments.length == 2)
                                payload = deps;
                            if (!define.modules[module]) {
                                define.payloads[module] = payload;
                                define.modules[module] = null;
                            }
                        };

                        define.modules = {};
                        define.payloads = {};

                        /**
                         * Get at functionality define()ed using the function above
                         */
                        var _require = function (parentId, module, callback) {
                            if (typeof module === "string") {
                                var payload = lookup(parentId, module);
                                if (payload != undefined) {
                                    callback && callback();
                                    return payload;
                                }
                            } else if (Object.prototype.toString.call(module) === "[object Array]") {
                                var params = [];
                                for (var i = 0, l = module.length; i < l; ++i) {
                                    var dep = lookup(parentId, module[i]);
                                    if (dep == undefined && require.original)
                                        return;
                                    params.push(dep);
                                }
                                return callback && callback.apply(null, params) || true;
                            }
                        };

                        var require = function (module, callback) {
                            var packagedModule = _require("", module, callback);
                            if (packagedModule == undefined && require.original)
                                return require.original.apply(this, arguments);
                            return packagedModule;
                        };

                        var normalizeModule = function (parentId, moduleName) {
                            // normalize plugin requires
                            if (moduleName.indexOf("!") !== -1) {
                                var chunks = moduleName.split("!");
                                return normalizeModule(parentId, chunks[0]) + "!" + normalizeModule(parentId, chunks[1]);
                            }
                            // normalize relative requires
                            if (moduleName.charAt(0) == ".") {
                                var base = parentId.split("/").slice(0, -1).join("/");
                                moduleName = base + "/" + moduleName;

                                while (moduleName.indexOf(".") !== -1 && previous != moduleName) {
                                    var previous = moduleName;
                                    moduleName = moduleName.replace(/\/\.\//, "/").replace(/[^\/]+\/\.\.\//, "");
                                }
                            }
                            return moduleName;
                        };

                        /**
                         * Internal function to lookup moduleNames and resolve them by calling the
                         * definition function if needed.
                         */
                        var lookup = function (parentId, moduleName) {
                            moduleName = normalizeModule(parentId, moduleName);

                            var module = define.modules[moduleName];
                            if (!module) {
                                module = define.payloads[moduleName];
                                if (typeof module === 'function') {
                                    var exports = {};
                                    var mod = {
                                        id: moduleName,
                                        uri: '',
                                        exports: exports,
                                        packaged: true
                                    };

                                    var req = function (module, callback) {
                                        return _require(moduleName, module, callback);
                                    };

                                    var returnValue = module(req, exports, mod);
                                    exports = returnValue || mod.exports;
                                    define.modules[moduleName] = exports;
                                    delete define.payloads[moduleName];
                                }
                                module = define.modules[moduleName] = exports || module;
                            }
                            return module;
                        };

                        function exportAce(ns) {
                            var root = global;
                            if (ns) {
                                if (!global[ns])
                                    global[ns] = {};
                                root = global[ns];
                            }

                            if (!root.define || !root.define.packaged) {
                                define.original = root.define;
                                root.define = define;
                                root.define.packaged = true;
                            }

                            if (!root.require || !root.require.packaged) {
                                require.original = root.require;
                                root.require = require;
                                root.require.packaged = true;
                            }
                        }

                        exportAce(ACE_NAMESPACE);

                    })();

                    ace.define("ace/lib/regexp", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";

                        var real = {
                                exec: RegExp.prototype.exec,
                                test: RegExp.prototype.test,
                                match: String.prototype.match,
                                replace: String.prototype.replace,
                                split: String.prototype.split
                            },
                            compliantExecNpcg = real.exec.call(/()??/, "")[1] === undefined, // check `exec` handling of nonparticipating capturing groups
                            compliantLastIndexIncrement = function () {
                                var x = /^/g;
                                real.test.call(x, "");
                                return !x.lastIndex;
                            }();

                        if (compliantLastIndexIncrement && compliantExecNpcg)
                            return;
                        RegExp.prototype.exec = function (str) {
                            var match = real.exec.apply(this, arguments),
                                name, r2;
                            if (typeof (str) == 'string' && match) {
                                if (!compliantExecNpcg && match.length > 1 && indexOf(match, "") > -1) {
                                    r2 = RegExp(this.source, real.replace.call(getNativeFlags(this), "g", ""));
                                    real.replace.call(str.slice(match.index), r2, function () {
                                        for (var i = 1; i < arguments.length - 2; i++) {
                                            if (arguments[i] === undefined)
                                                match[i] = undefined;
                                        }
                                    });
                                }
                                if (this._xregexp && this._xregexp.captureNames) {
                                    for (var i = 1; i < match.length; i++) {
                                        name = this._xregexp.captureNames[i - 1];
                                        if (name)
                                            match[name] = match[i];
                                    }
                                }
                                if (!compliantLastIndexIncrement && this.global && !match[0].length && (this.lastIndex > match.index))
                                    this.lastIndex--;
                            }
                            return match;
                        };
                        if (!compliantLastIndexIncrement) {
                            RegExp.prototype.test = function (str) {
                                var match = real.exec.call(this, str);
                                if (match && this.global && !match[0].length && (this.lastIndex > match.index))
                                    this.lastIndex--;
                                return !!match;
                            };
                        }

                        function getNativeFlags(regex) {
                            return (regex.global ? "g" : "") +
                                (regex.ignoreCase ? "i" : "") +
                                (regex.multiline ? "m" : "") +
                                (regex.extended ? "x" : "") + // Proposed for ES4; included in AS3
                                (regex.sticky ? "y" : "");
                        }

                        function indexOf(array, item, from) {
                            if (Array.prototype.indexOf) // Use the native array method if available
                                return array.indexOf(item, from);
                            for (var i = from || 0; i < array.length; i++) {
                                if (array[i] === item)
                                    return i;
                            }
                            return -1;
                        }

                    });

                    ace.define("ace/lib/es5-shim", ["require", "exports", "module"], function (require, exports, module) {

                        function Empty() {
                        }

                        if (!Function.prototype.bind) {
                            Function.prototype.bind = function bind(that) { // .length is 1
                                var target = this;
                                if (typeof target != "function") {
                                    throw new TypeError("Function.prototype.bind called on incompatible " + target);
                                }
                                var args = slice.call(arguments, 1); // for normal call
                                var bound = function () {

                                    if (this instanceof bound) {

                                        var result = target.apply(
                                            this,
                                            args.concat(slice.call(arguments))
                                        );
                                        if (Object(result) === result) {
                                            return result;
                                        }
                                        return this;

                                    } else {
                                        return target.apply(
                                            that,
                                            args.concat(slice.call(arguments))
                                        );

                                    }

                                };
                                if (target.prototype) {
                                    Empty.prototype = target.prototype;
                                    bound.prototype = new Empty();
                                    Empty.prototype = null;
                                }
                                return bound;
                            };
                        }
                        var call = Function.prototype.call;
                        var prototypeOfArray = Array.prototype;
                        var prototypeOfObject = Object.prototype;
                        var slice = prototypeOfArray.slice;
                        var _toString = call.bind(prototypeOfObject.toString);
                        var owns = call.bind(prototypeOfObject.hasOwnProperty);
                        var defineGetter;
                        var defineSetter;
                        var lookupGetter;
                        var lookupSetter;
                        var supportsAccessors;
                        if ((supportsAccessors = owns(prototypeOfObject, "__defineGetter__"))) {
                            defineGetter = call.bind(prototypeOfObject.__defineGetter__);
                            defineSetter = call.bind(prototypeOfObject.__defineSetter__);
                            lookupGetter = call.bind(prototypeOfObject.__lookupGetter__);
                            lookupSetter = call.bind(prototypeOfObject.__lookupSetter__);
                        }
                        if ([1, 2].splice(0).length != 2) {
                            if (function () { // test IE < 9 to splice bug - see issue #138
                                function makeArray(l) {
                                    var a = new Array(l + 2);
                                    a[0] = a[1] = 0;
                                    return a;
                                }

                                var array = [], lengthBefore;

                                array.splice.apply(array, makeArray(20));
                                array.splice.apply(array, makeArray(26));

                                lengthBefore = array.length; //46
                                array.splice(5, 0, "XXX"); // add one element

                                lengthBefore + 1 == array.length

                                if (lengthBefore + 1 == array.length) {
                                    return true;// has right splice implementation without bugs
                                }
                            }()) {//IE 6/7
                                var array_splice = Array.prototype.splice;
                                Array.prototype.splice = function (start, deleteCount) {
                                    if (!arguments.length) {
                                        return [];
                                    } else {
                                        return array_splice.apply(this, [
                                            start === void 0 ? 0 : start,
                                            deleteCount === void 0 ? (this.length - start) : deleteCount
                                        ].concat(slice.call(arguments, 2)))
                                    }
                                };
                            } else {//IE8
                                Array.prototype.splice = function (pos, removeCount) {
                                    var length = this.length;
                                    if (pos > 0) {
                                        if (pos > length)
                                            pos = length;
                                    } else if (pos == void 0) {
                                        pos = 0;
                                    } else if (pos < 0) {
                                        pos = Math.max(length + pos, 0);
                                    }

                                    if (!(pos + removeCount < length))
                                        removeCount = length - pos;

                                    var removed = this.slice(pos, pos + removeCount);
                                    var insert = slice.call(arguments, 2);
                                    var add = insert.length;
                                    if (pos === length) {
                                        if (add) {
                                            this.push.apply(this, insert);
                                        }
                                    } else {
                                        var remove = Math.min(removeCount, length - pos);
                                        var tailOldPos = pos + remove;
                                        var tailNewPos = tailOldPos + add - remove;
                                        var tailCount = length - tailOldPos;
                                        var lengthAfterRemove = length - remove;

                                        if (tailNewPos < tailOldPos) { // case A
                                            for (var i = 0; i < tailCount; ++i) {
                                                this[tailNewPos + i] = this[tailOldPos + i];
                                            }
                                        } else if (tailNewPos > tailOldPos) { // case B
                                            for (i = tailCount; i--;) {
                                                this[tailNewPos + i] = this[tailOldPos + i];
                                            }
                                        } // else, add == remove (nothing to do)

                                        if (add && pos === lengthAfterRemove) {
                                            this.length = lengthAfterRemove; // truncate array
                                            this.push.apply(this, insert);
                                        } else {
                                            this.length = lengthAfterRemove + add; // reserves space
                                            for (i = 0; i < add; ++i) {
                                                this[pos + i] = insert[i];
                                            }
                                        }
                                    }
                                    return removed;
                                };
                            }
                        }
                        if (!Array.isArray) {
                            Array.isArray = function isArray(obj) {
                                return _toString(obj) == "[object Array]";
                            };
                        }
                        var boxedString = Object("a"),
                            splitString = boxedString[0] != "a" || !(0 in boxedString);

                        if (!Array.prototype.forEach) {
                            Array.prototype.forEach = function forEach(fun /*, thisp*/) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    thisp = arguments[1],
                                    i = -1,
                                    length = self.length >>> 0;
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(); // TODO message
                                }

                                while (++i < length) {
                                    if (i in self) {
                                        fun.call(thisp, self[i], i, object);
                                    }
                                }
                            };
                        }
                        if (!Array.prototype.map) {
                            Array.prototype.map = function map(fun /*, thisp*/) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    length = self.length >>> 0,
                                    result = Array(length),
                                    thisp = arguments[1];
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(fun + " is not a function");
                                }

                                for (var i = 0; i < length; i++) {
                                    if (i in self)
                                        result[i] = fun.call(thisp, self[i], i, object);
                                }
                                return result;
                            };
                        }
                        if (!Array.prototype.filter) {
                            Array.prototype.filter = function filter(fun /*, thisp */) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    length = self.length >>> 0,
                                    result = [],
                                    value,
                                    thisp = arguments[1];
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(fun + " is not a function");
                                }

                                for (var i = 0; i < length; i++) {
                                    if (i in self) {
                                        value = self[i];
                                        if (fun.call(thisp, value, i, object)) {
                                            result.push(value);
                                        }
                                    }
                                }
                                return result;
                            };
                        }
                        if (!Array.prototype.every) {
                            Array.prototype.every = function every(fun /*, thisp */) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    length = self.length >>> 0,
                                    thisp = arguments[1];
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(fun + " is not a function");
                                }

                                for (var i = 0; i < length; i++) {
                                    if (i in self && !fun.call(thisp, self[i], i, object)) {
                                        return false;
                                    }
                                }
                                return true;
                            };
                        }
                        if (!Array.prototype.some) {
                            Array.prototype.some = function some(fun /*, thisp */) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    length = self.length >>> 0,
                                    thisp = arguments[1];
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(fun + " is not a function");
                                }

                                for (var i = 0; i < length; i++) {
                                    if (i in self && fun.call(thisp, self[i], i, object)) {
                                        return true;
                                    }
                                }
                                return false;
                            };
                        }
                        if (!Array.prototype.reduce) {
                            Array.prototype.reduce = function reduce(fun /*, initial*/) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    length = self.length >>> 0;
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(fun + " is not a function");
                                }
                                if (!length && arguments.length == 1) {
                                    throw new TypeError("reduce of empty array with no initial value");
                                }

                                var i = 0;
                                var result;
                                if (arguments.length >= 2) {
                                    result = arguments[1];
                                } else {
                                    do {
                                        if (i in self) {
                                            result = self[i++];
                                            break;
                                        }
                                        if (++i >= length) {
                                            throw new TypeError("reduce of empty array with no initial value");
                                        }
                                    } while (true);
                                }

                                for (; i < length; i++) {
                                    if (i in self) {
                                        result = fun.call(void 0, result, self[i], i, object);
                                    }
                                }

                                return result;
                            };
                        }
                        if (!Array.prototype.reduceRight) {
                            Array.prototype.reduceRight = function reduceRight(fun /*, initial*/) {
                                var object = toObject(this),
                                    self = splitString && _toString(this) == "[object String]" ?
                                        this.split("") :
                                        object,
                                    length = self.length >>> 0;
                                if (_toString(fun) != "[object Function]") {
                                    throw new TypeError(fun + " is not a function");
                                }
                                if (!length && arguments.length == 1) {
                                    throw new TypeError("reduceRight of empty array with no initial value");
                                }

                                var result, i = length - 1;
                                if (arguments.length >= 2) {
                                    result = arguments[1];
                                } else {
                                    do {
                                        if (i in self) {
                                            result = self[i--];
                                            break;
                                        }
                                        if (--i < 0) {
                                            throw new TypeError("reduceRight of empty array with no initial value");
                                        }
                                    } while (true);
                                }

                                do {
                                    if (i in this) {
                                        result = fun.call(void 0, result, self[i], i, object);
                                    }
                                } while (i--);

                                return result;
                            };
                        }
                        if (!Array.prototype.indexOf || ([0, 1].indexOf(1, 2) != -1)) {
                            Array.prototype.indexOf = function indexOf(sought /*, fromIndex */) {
                                var self = splitString && _toString(this) == "[object String]" ?
                                    this.split("") :
                                    toObject(this),
                                    length = self.length >>> 0;

                                if (!length) {
                                    return -1;
                                }

                                var i = 0;
                                if (arguments.length > 1) {
                                    i = toInteger(arguments[1]);
                                }
                                i = i >= 0 ? i : Math.max(0, length + i);
                                for (; i < length; i++) {
                                    if (i in self && self[i] === sought) {
                                        return i;
                                    }
                                }
                                return -1;
                            };
                        }
                        if (!Array.prototype.lastIndexOf || ([0, 1].lastIndexOf(0, -3) != -1)) {
                            Array.prototype.lastIndexOf = function lastIndexOf(sought /*, fromIndex */) {
                                var self = splitString && _toString(this) == "[object String]" ?
                                    this.split("") :
                                    toObject(this),
                                    length = self.length >>> 0;

                                if (!length) {
                                    return -1;
                                }
                                var i = length - 1;
                                if (arguments.length > 1) {
                                    i = Math.min(i, toInteger(arguments[1]));
                                }
                                i = i >= 0 ? i : length - Math.abs(i);
                                for (; i >= 0; i--) {
                                    if (i in self && sought === self[i]) {
                                        return i;
                                    }
                                }
                                return -1;
                            };
                        }
                        if (!Object.getPrototypeOf) {
                            Object.getPrototypeOf = function getPrototypeOf(object) {
                                return object.__proto__ || (
                                    object.constructor ?
                                        object.constructor.prototype :
                                        prototypeOfObject
                                );
                            };
                        }
                        if (!Object.getOwnPropertyDescriptor) {
                            var ERR_NON_OBJECT = "Object.getOwnPropertyDescriptor called on a " +
                                "non-object: ";
                            Object.getOwnPropertyDescriptor = function getOwnPropertyDescriptor(object, property) {
                                if ((typeof object != "object" && typeof object != "function") || object === null)
                                    throw new TypeError(ERR_NON_OBJECT + object);
                                if (!owns(object, property))
                                    return;

                                var descriptor, getter, setter;
                                descriptor = {enumerable: true, configurable: true};
                                if (supportsAccessors) {
                                    var prototype = object.__proto__;
                                    object.__proto__ = prototypeOfObject;

                                    var getter = lookupGetter(object, property);
                                    var setter = lookupSetter(object, property);
                                    object.__proto__ = prototype;

                                    if (getter || setter) {
                                        if (getter) descriptor.get = getter;
                                        if (setter) descriptor.set = setter;
                                        return descriptor;
                                    }
                                }
                                descriptor.value = object[property];
                                return descriptor;
                            };
                        }
                        if (!Object.getOwnPropertyNames) {
                            Object.getOwnPropertyNames = function getOwnPropertyNames(object) {
                                return Object.keys(object);
                            };
                        }
                        if (!Object.create) {
                            var createEmpty;
                            if (Object.prototype.__proto__ === null) {
                                createEmpty = function () {
                                    return {"__proto__": null};
                                };
                            } else {
                                createEmpty = function () {
                                    var empty = {};
                                    for (var i in empty)
                                        empty[i] = null;
                                    empty.constructor =
                                        empty.hasOwnProperty =
                                            empty.propertyIsEnumerable =
                                                empty.isPrototypeOf =
                                                    empty.toLocaleString =
                                                        empty.toString =
                                                            empty.valueOf =
                                                                empty.__proto__ = null;
                                    return empty;
                                }
                            }

                            Object.create = function create(prototype, properties) {
                                var object;
                                if (prototype === null) {
                                    object = createEmpty();
                                } else {
                                    if (typeof prototype != "object")
                                        throw new TypeError("typeof prototype[" + (typeof prototype) + "] != 'object'");
                                    var Type = function () {
                                    };
                                    Type.prototype = prototype;
                                    object = new Type();
                                    object.__proto__ = prototype;
                                }
                                if (properties !== void 0)
                                    Object.defineProperties(object, properties);
                                return object;
                            };
                        }

                        function doesDefinePropertyWork(object) {
                            try {
                                Object.defineProperty(object, "sentinel", {});
                                return "sentinel" in object;
                            } catch (exception) {
                            }
                        }

                        if (Object.defineProperty) {
                            var definePropertyWorksOnObject = doesDefinePropertyWork({});
                            var definePropertyWorksOnDom = typeof document == "undefined" ||
                                doesDefinePropertyWork(document.createElement("div"));
                            if (!definePropertyWorksOnObject || !definePropertyWorksOnDom) {
                                var definePropertyFallback = Object.defineProperty;
                            }
                        }

                        if (!Object.defineProperty || definePropertyFallback) {
                            var ERR_NON_OBJECT_DESCRIPTOR = "Property description must be an object: ";
                            var ERR_NON_OBJECT_TARGET = "Object.defineProperty called on non-object: "
                            var ERR_ACCESSORS_NOT_SUPPORTED = "getters & setters can not be defined " +
                                "on this javascript engine";

                            Object.defineProperty = function defineProperty(object, property, descriptor) {
                                if ((typeof object != "object" && typeof object != "function") || object === null)
                                    throw new TypeError(ERR_NON_OBJECT_TARGET + object);
                                if ((typeof descriptor != "object" && typeof descriptor != "function") || descriptor === null)
                                    throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR + descriptor);
                                if (definePropertyFallback) {
                                    try {
                                        return definePropertyFallback.call(Object, object, property, descriptor);
                                    } catch (exception) {
                                    }
                                }
                                if (owns(descriptor, "value")) {

                                    if (supportsAccessors && (lookupGetter(object, property) ||
                                        lookupSetter(object, property))) {
                                        var prototype = object.__proto__;
                                        object.__proto__ = prototypeOfObject;
                                        delete object[property];
                                        object[property] = descriptor.value;
                                        object.__proto__ = prototype;
                                    } else {
                                        object[property] = descriptor.value;
                                    }
                                } else {
                                    if (!supportsAccessors)
                                        throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);
                                    if (owns(descriptor, "get"))
                                        defineGetter(object, property, descriptor.get);
                                    if (owns(descriptor, "set"))
                                        defineSetter(object, property, descriptor.set);
                                }

                                return object;
                            };
                        }
                        if (!Object.defineProperties) {
                            Object.defineProperties = function defineProperties(object, properties) {
                                for (var property in properties) {
                                    if (owns(properties, property))
                                        Object.defineProperty(object, property, properties[property]);
                                }
                                return object;
                            };
                        }
                        if (!Object.seal) {
                            Object.seal = function seal(object) {
                                return object;
                            };
                        }
                        if (!Object.freeze) {
                            Object.freeze = function freeze(object) {
                                return object;
                            };
                        }
                        try {
                            Object.freeze(function () {
                            });
                        } catch (exception) {
                            Object.freeze = (function freeze(freezeObject) {
                                return function freeze(object) {
                                    if (typeof object == "function") {
                                        return object;
                                    } else {
                                        return freezeObject(object);
                                    }
                                };
                            })(Object.freeze);
                        }
                        if (!Object.preventExtensions) {
                            Object.preventExtensions = function preventExtensions(object) {
                                return object;
                            };
                        }
                        if (!Object.isSealed) {
                            Object.isSealed = function isSealed(object) {
                                return false;
                            };
                        }
                        if (!Object.isFrozen) {
                            Object.isFrozen = function isFrozen(object) {
                                return false;
                            };
                        }
                        if (!Object.isExtensible) {
                            Object.isExtensible = function isExtensible(object) {
                                if (Object(object) === object) {
                                    throw new TypeError(); // TODO message
                                }
                                var name = '';
                                while (owns(object, name)) {
                                    name += '?';
                                }
                                object[name] = true;
                                var returnValue = owns(object, name);
                                delete object[name];
                                return returnValue;
                            };
                        }
                        if (!Object.keys) {
                            var hasDontEnumBug = true,
                                dontEnums = [
                                    "toString",
                                    "toLocaleString",
                                    "valueOf",
                                    "hasOwnProperty",
                                    "isPrototypeOf",
                                    "propertyIsEnumerable",
                                    "constructor"
                                ],
                                dontEnumsLength = dontEnums.length;

                            for (var key in {"toString": null}) {
                                hasDontEnumBug = false;
                            }

                            Object.keys = function keys(object) {

                                if (
                                    (typeof object != "object" && typeof object != "function") ||
                                    object === null
                                ) {
                                    throw new TypeError("Object.keys called on a non-object");
                                }

                                var keys = [];
                                for (var name in object) {
                                    if (owns(object, name)) {
                                        keys.push(name);
                                    }
                                }

                                if (hasDontEnumBug) {
                                    for (var i = 0, ii = dontEnumsLength; i < ii; i++) {
                                        var dontEnum = dontEnums[i];
                                        if (owns(object, dontEnum)) {
                                            keys.push(dontEnum);
                                        }
                                    }
                                }
                                return keys;
                            };

                        }
                        if (!Date.now) {
                            Date.now = function now() {
                                return new Date().getTime();
                            };
                        }
                        var ws = "\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u2000\u2001\u2002\u2003" +
                            "\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028" +
                            "\u2029\uFEFF";
                        if (!String.prototype.trim) {
                            ws = "[" + ws + "]";
                            var trimBeginRegexp = new RegExp("^" + ws + ws + "*"),
                                trimEndRegexp = new RegExp(ws + ws + "*$");
                            String.prototype.trim = function trim() {
                                return String(this).replace(trimBeginRegexp, "").replace(trimEndRegexp, "");
                            };
                        }

                        function toInteger(n) {
                            n = +n;
                            if (n !== n) { // isNaN
                                n = 0;
                            } else if (n !== 0 && n !== (1 / 0) && n !== -(1 / 0)) {
                                n = (n > 0 || -1) * Math.floor(Math.abs(n));
                            }
                            return n;
                        }

                        function isPrimitive(input) {
                            var type = typeof input;
                            return (
                                input === null ||
                                type === "undefined" ||
                                type === "boolean" ||
                                type === "number" ||
                                type === "string"
                            );
                        }

                        function toPrimitive(input) {
                            var val, valueOf, toString;
                            if (isPrimitive(input)) {
                                return input;
                            }
                            valueOf = input.valueOf;
                            if (typeof valueOf === "function") {
                                val = valueOf.call(input);
                                if (isPrimitive(val)) {
                                    return val;
                                }
                            }
                            toString = input.toString;
                            if (typeof toString === "function") {
                                val = toString.call(input);
                                if (isPrimitive(val)) {
                                    return val;
                                }
                            }
                            throw new TypeError();
                        }

                        var toObject = function (o) {
                            if (o == null) { // this matches both null and undefined
                                throw new TypeError("can't convert " + o + " to object");
                            }
                            return Object(o);
                        };

                    });

                    ace.define("ace/lib/fixoldbrowsers", ["require", "exports", "module", "ace/lib/regexp", "ace/lib/es5-shim"], function (require, exports, module) {
                        "use strict";

                        require("./regexp");
                        require("./es5-shim");
                        if (typeof Element != "undefined" && !Element.prototype.remove) {
                            Object.defineProperty(Element.prototype, "remove", {
                                enumerable: false,
                                writable: true,
                                configurable: true,
                                value: function () {
                                    this.parentNode && this.parentNode.removeChild(this);
                                }
                            });
                        }


                    });

                    ace.define("ace/lib/useragent", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";
                        exports.OS = {
                            LINUX: "LINUX",
                            MAC: "MAC",
                            WINDOWS: "WINDOWS"
                        };
                        exports.getOS = function () {
                            if (exports.isMac) {
                                return exports.OS.MAC;
                            } else if (exports.isLinux) {
                                return exports.OS.LINUX;
                            } else {
                                return exports.OS.WINDOWS;
                            }
                        };
                        var _navigator = typeof navigator == "object" ? navigator : {};

                        var os = (/mac|win|linux/i.exec(_navigator.platform) || ["other"])[0].toLowerCase();
                        var ua = _navigator.userAgent || "";
                        var appName = _navigator.appName || "";
                        exports.isWin = (os == "win");
                        exports.isMac = (os == "mac");
                        exports.isLinux = (os == "linux");
                        exports.isIE =
                            (appName == "Microsoft Internet Explorer" || appName.indexOf("MSAppHost") >= 0)
                                ? parseFloat((ua.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/) || [])[1])
                                : parseFloat((ua.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/) || [])[1]); // for ie

                        exports.isOldIE = exports.isIE && exports.isIE < 9;
                        exports.isGecko = exports.isMozilla = ua.match(/ Gecko\/\d+/);
                        exports.isOpera = typeof opera == "object" && Object.prototype.toString.call(window.opera) == "[object Opera]";
                        exports.isWebKit = parseFloat(ua.split("WebKit/")[1]) || undefined;

                        exports.isChrome = parseFloat(ua.split(" Chrome/")[1]) || undefined;

                        exports.isEdge = parseFloat(ua.split(" Edge/")[1]) || undefined;

                        exports.isAIR = ua.indexOf("AdobeAIR") >= 0;

                        exports.isAndroid = ua.indexOf("Android") >= 0;

                        exports.isChromeOS = ua.indexOf(" CrOS ") >= 0;

                        exports.isIOS = /iPad|iPhone|iPod/.test(ua) && !window.MSStream;

                        if (exports.isIOS) exports.isMac = true;

                        exports.isMobile = exports.isIOS || exports.isAndroid;

                    });

                    ace.define("ace/lib/dom", ["require", "exports", "module", "ace/lib/useragent"], function (require, exports, module) {
                        "use strict";

                        var useragent = require("./useragent");
                        var XHTML_NS = "http://www.w3.org/1999/xhtml";

                        exports.buildDom = function buildDom(arr, parent, refs) {
                            if (typeof arr == "string" && arr) {
                                var txt = document.createTextNode(arr);
                                if (parent)
                                    parent.appendChild(txt);
                                return txt;
                            }

                            if (!Array.isArray(arr))
                                return arr;
                            if (typeof arr[0] != "string" || !arr[0]) {
                                var els = [];
                                for (var i = 0; i < arr.length; i++) {
                                    var ch = buildDom(arr[i], parent, refs);
                                    ch && els.push(ch);
                                }
                                return els;
                            }

                            var el = document.createElement(arr[0]);
                            var options = arr[1];
                            var childIndex = 1;
                            if (options && typeof options == "object" && !Array.isArray(options))
                                childIndex = 2;
                            for (var i = childIndex; i < arr.length; i++)
                                buildDom(arr[i], el, refs);
                            if (childIndex == 2) {
                                Object.keys(options).forEach(function (n) {
                                    var val = options[n];
                                    if (n === "class") {
                                        el.className = Array.isArray(val) ? val.join(" ") : val;
                                    } else if (typeof val == "function" || n == "value") {
                                        el[n] = val;
                                    } else if (n === "ref") {
                                        if (refs) refs[val] = el;
                                    } else if (val != null) {
                                        el.setAttribute(n, val);
                                    }
                                });
                            }
                            if (parent)
                                parent.appendChild(el);
                            return el;
                        };

                        exports.getDocumentHead = function (doc) {
                            if (!doc)
                                doc = document;
                            return doc.head || doc.getElementsByTagName("head")[0] || doc.documentElement;
                        };

                        exports.createElement = function (tag, ns) {
                            return document.createElementNS ?
                                document.createElementNS(ns || XHTML_NS, tag) :
                                document.createElement(tag);
                        };

                        exports.removeChildren = function (element) {
                            element.innerHTML = "";
                        };

                        exports.createTextNode = function (textContent, element) {
                            var doc = element ? element.ownerDocument : document;
                            return doc.createTextNode(textContent);
                        };

                        exports.createFragment = function (element) {
                            var doc = element ? element.ownerDocument : document;
                            return doc.createDocumentFragment();
                        };

                        exports.hasCssClass = function (el, name) {
                            var classes = (el.className + "").split(/\s+/g);
                            return classes.indexOf(name) !== -1;
                        };
                        exports.addCssClass = function (el, name) {
                            if (!exports.hasCssClass(el, name)) {
                                el.className += " " + name;
                            }
                        };
                        exports.removeCssClass = function (el, name) {
                            var classes = el.className.split(/\s+/g);
                            while (true) {
                                var index = classes.indexOf(name);
                                if (index == -1) {
                                    break;
                                }
                                classes.splice(index, 1);
                            }
                            el.className = classes.join(" ");
                        };

                        exports.toggleCssClass = function (el, name) {
                            var classes = el.className.split(/\s+/g), add = true;
                            while (true) {
                                var index = classes.indexOf(name);
                                if (index == -1) {
                                    break;
                                }
                                add = false;
                                classes.splice(index, 1);
                            }
                            if (add)
                                classes.push(name);

                            el.className = classes.join(" ");
                            return add;
                        };
                        exports.setCssClass = function (node, className, include) {
                            if (include) {
                                exports.addCssClass(node, className);
                            } else {
                                exports.removeCssClass(node, className);
                            }
                        };

                        exports.hasCssString = function (id, doc) {
                            var index = 0, sheets;
                            doc = doc || document;
                            if ((sheets = doc.querySelectorAll("style"))) {
                                while (index < sheets.length)
                                    if (sheets[index++].id === id)
                                        return true;
                            }
                        };

                        exports.importCssString = function importCssString(cssText, id, target) {
                            var container = target;
                            if (!target || !target.getRootNode) {
                                container = document;
                            } else {
                                container = target.getRootNode();
                                if (!container || container == target)
                                    container = document;
                            }

                            var doc = container.ownerDocument || container;
                            if (id && exports.hasCssString(id, container))
                                return null;

                            if (id)
                                cssText += "\n/*# sourceURL=ace/css/" + id + " */";

                            var style = exports.createElement("style");
                            style.appendChild(doc.createTextNode(cssText));
                            if (id)
                                style.id = id;

                            if (container == doc)
                                container = exports.getDocumentHead(doc);
                            container.insertBefore(style, container.firstChild);
                        };

                        exports.importCssStylsheet = function (uri, doc) {
                            exports.buildDom(["link", {rel: "stylesheet", href: uri}], exports.getDocumentHead(doc));
                        };
                        exports.scrollbarWidth = function (document) {
                            var inner = exports.createElement("ace_inner");
                            inner.style.width = "100%";
                            inner.style.minWidth = "0px";
                            inner.style.height = "200px";
                            inner.style.display = "block";

                            var outer = exports.createElement("ace_outer");
                            var style = outer.style;

                            style.position = "absolute";
                            style.left = "-10000px";
                            style.overflow = "hidden";
                            style.width = "200px";
                            style.minWidth = "0px";
                            style.height = "150px";
                            style.display = "block";

                            outer.appendChild(inner);

                            var body = document.documentElement;
                            body.appendChild(outer);

                            var noScrollbar = inner.offsetWidth;

                            style.overflow = "scroll";
                            var withScrollbar = inner.offsetWidth;

                            if (noScrollbar == withScrollbar) {
                                withScrollbar = outer.clientWidth;
                            }

                            body.removeChild(outer);

                            return noScrollbar - withScrollbar;
                        };

                        if (typeof document == "undefined") {
                            exports.importCssString = function () {
                            };
                        }

                        exports.computedStyle = function (element, style) {
                            return window.getComputedStyle(element, "") || {};
                        };

                        exports.setStyle = function (styles, property, value) {
                            if (styles[property] !== value) {
                                styles[property] = value;
                            }
                        };

                        exports.HAS_CSS_ANIMATION = false;
                        exports.HAS_CSS_TRANSFORMS = false;
                        exports.HI_DPI = useragent.isWin
                            ? typeof window !== "undefined" && window.devicePixelRatio >= 1.5
                            : true;

                        if (typeof document !== "undefined") {
                            var div = document.createElement("div");
                            if (exports.HI_DPI && div.style.transform !== undefined)
                                exports.HAS_CSS_TRANSFORMS = true;
                            if (!useragent.isEdge && typeof div.style.animationName !== "undefined")
                                exports.HAS_CSS_ANIMATION = true;
                            div = null;
                        }

                        if (exports.HAS_CSS_TRANSFORMS) {
                            exports.translate = function (element, tx, ty) {
                                element.style.transform = "translate(" + Math.round(tx) + "px, " + Math.round(ty) + "px)";
                            };
                        } else {
                            exports.translate = function (element, tx, ty) {
                                element.style.top = Math.round(ty) + "px";
                                element.style.left = Math.round(tx) + "px";
                            };
                        }

                    });

                    ace.define("ace/lib/oop", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";

                        exports.inherits = function (ctor, superCtor) {
                            ctor.super_ = superCtor;
                            ctor.prototype = Object.create(superCtor.prototype, {
                                constructor: {
                                    value: ctor,
                                    enumerable: false,
                                    writable: true,
                                    configurable: true
                                }
                            });
                        };

                        exports.mixin = function (obj, mixin) {
                            for (var key in mixin) {
                                obj[key] = mixin[key];
                            }
                            return obj;
                        };

                        exports.implement = function (proto, mixin) {
                            exports.mixin(proto, mixin);
                        };

                    });

                    ace.define("ace/lib/keys", ["require", "exports", "module", "ace/lib/oop"], function (require, exports, module) {
                        "use strict";

                        var oop = require("./oop");
                        var Keys = (function () {
                            var ret = {
                                MODIFIER_KEYS: {
                                    16: 'Shift', 17: 'Ctrl', 18: 'Alt', 224: 'Meta',
                                    91: 'MetaLeft', 92: 'MetaRight', 93: 'ContextMenu'
                                },

                                KEY_MODS: {
                                    "ctrl": 1, "alt": 2, "option": 2, "shift": 4,
                                    "super": 8, "meta": 8, "command": 8, "cmd": 8
                                },

                                FUNCTION_KEYS: {
                                    8: "Backspace",
                                    9: "Tab",
                                    13: "Return",
                                    19: "Pause",
                                    27: "Esc",
                                    32: "Space",
                                    33: "PageUp",
                                    34: "PageDown",
                                    35: "End",
                                    36: "Home",
                                    37: "Left",
                                    38: "Up",
                                    39: "Right",
                                    40: "Down",
                                    44: "Print",
                                    45: "Insert",
                                    46: "Delete",
                                    96: "Numpad0",
                                    97: "Numpad1",
                                    98: "Numpad2",
                                    99: "Numpad3",
                                    100: "Numpad4",
                                    101: "Numpad5",
                                    102: "Numpad6",
                                    103: "Numpad7",
                                    104: "Numpad8",
                                    105: "Numpad9",
                                    '-13': "NumpadEnter",
                                    112: "F1",
                                    113: "F2",
                                    114: "F3",
                                    115: "F4",
                                    116: "F5",
                                    117: "F6",
                                    118: "F7",
                                    119: "F8",
                                    120: "F9",
                                    121: "F10",
                                    122: "F11",
                                    123: "F12",
                                    144: "Numlock",
                                    145: "Scrolllock"
                                },

                                PRINTABLE_KEYS: {
                                    32: ' ', 48: '0', 49: '1', 50: '2', 51: '3', 52: '4', 53: '5',
                                    54: '6', 55: '7', 56: '8', 57: '9', 59: ';', 61: '=', 65: 'a',
                                    66: 'b', 67: 'c', 68: 'd', 69: 'e', 70: 'f', 71: 'g', 72: 'h',
                                    73: 'i', 74: 'j', 75: 'k', 76: 'l', 77: 'm', 78: 'n', 79: 'o',
                                    80: 'p', 81: 'q', 82: 'r', 83: 's', 84: 't', 85: 'u', 86: 'v',
                                    87: 'w', 88: 'x', 89: 'y', 90: 'z', 107: '+', 109: '-', 110: '.',
                                    186: ';', 187: '=', 188: ',', 189: '-', 190: '.', 191: '/', 192: '`',
                                    219: '[', 220: '\\', 221: ']', 222: "'", 111: '/', 106: '*'
                                }
                            };
                            var name, i;
                            for (i in ret.FUNCTION_KEYS) {
                                name = ret.FUNCTION_KEYS[i].toLowerCase();
                                ret[name] = parseInt(i, 10);
                            }
                            for (i in ret.PRINTABLE_KEYS) {
                                name = ret.PRINTABLE_KEYS[i].toLowerCase();
                                ret[name] = parseInt(i, 10);
                            }
                            oop.mixin(ret, ret.MODIFIER_KEYS);
                            oop.mixin(ret, ret.PRINTABLE_KEYS);
                            oop.mixin(ret, ret.FUNCTION_KEYS);
                            ret.enter = ret["return"];
                            ret.escape = ret.esc;
                            ret.del = ret["delete"];
                            ret[173] = '-';

                            (function () {
                                var mods = ["cmd", "ctrl", "alt", "shift"];
                                for (var i = Math.pow(2, mods.length); i--;) {
                                    ret.KEY_MODS[i] = mods.filter(function (x) {
                                        return i & ret.KEY_MODS[x];
                                    }).join("-") + "-";
                                }
                            })();

                            ret.KEY_MODS[0] = "";
                            ret.KEY_MODS[-1] = "input-";

                            return ret;
                        })();
                        oop.mixin(exports, Keys);

                        exports.keyCodeToString = function (keyCode) {
                            var keyString = Keys[keyCode];
                            if (typeof keyString != "string")
                                keyString = String.fromCharCode(keyCode);
                            return keyString.toLowerCase();
                        };

                    });

                    ace.define("ace/lib/event", ["require", "exports", "module", "ace/lib/keys", "ace/lib/useragent"], function (require, exports, module) {
                        "use strict";

                        var keys = require("./keys");
                        var useragent = require("./useragent");

                        var pressedKeys = null;
                        var ts = 0;

                        var activeListenerOptions;

                        function detectListenerOptionsSupport() {
                            activeListenerOptions = false;
                            try {
                                document.createComment("").addEventListener("test", function () {
                                }, {
                                    get passive() {
                                        activeListenerOptions = {passive: false};
                                    }
                                });
                            } catch (e) {
                            }
                        }

                        function getListenerOptions() {
                            if (activeListenerOptions == undefined)
                                detectListenerOptionsSupport();
                            return activeListenerOptions;
                        }

                        exports.addListener = function (elem, type, callback) {
                            return elem.addEventListener(type, callback, getListenerOptions());
                        };

                        exports.removeListener = function (elem, type, callback) {
                            return elem.removeEventListener(type, callback, getListenerOptions());
                        };
                        exports.stopEvent = function (e) {
                            exports.stopPropagation(e);
                            exports.preventDefault(e);
                            return false;
                        };

                        exports.stopPropagation = function (e) {
                            if (e.stopPropagation)
                                e.stopPropagation();
                        };

                        exports.preventDefault = function (e) {
                            if (e.preventDefault)
                                e.preventDefault();
                        };
                        exports.getButton = function (e) {
                            if (e.type == "dblclick")
                                return 0;
                            if (e.type == "contextmenu" || (useragent.isMac && (e.ctrlKey && !e.altKey && !e.shiftKey)))
                                return 2;
                            return e.button;
                        };

                        exports.capture = function (el, eventHandler, releaseCaptureHandler) {
                            function onMouseUp(e) {
                                eventHandler && eventHandler(e);
                                releaseCaptureHandler && releaseCaptureHandler(e);

                                exports.removeListener(document, "mousemove", eventHandler, true);
                                exports.removeListener(document, "mouseup", onMouseUp, true);
                                exports.removeListener(document, "dragstart", onMouseUp, true);
                            }

                            exports.addListener(document, "mousemove", eventHandler, true);
                            exports.addListener(document, "mouseup", onMouseUp, true);
                            exports.addListener(document, "dragstart", onMouseUp, true);

                            return onMouseUp;
                        };

                        exports.addMouseWheelListener = function (el, callback) {
                            if ("onmousewheel" in el) {
                                exports.addListener(el, "mousewheel", function (e) {
                                    var factor = 8;
                                    if (e.wheelDeltaX !== undefined) {
                                        e.wheelX = -e.wheelDeltaX / factor;
                                        e.wheelY = -e.wheelDeltaY / factor;
                                    } else {
                                        e.wheelX = 0;
                                        e.wheelY = -e.wheelDelta / factor;
                                    }
                                    callback(e);
                                });
                            } else if ("onwheel" in el) {
                                exports.addListener(el, "wheel", function (e) {
                                    var factor = 0.35;
                                    switch (e.deltaMode) {
                                        case e.DOM_DELTA_PIXEL:
                                            e.wheelX = e.deltaX * factor || 0;
                                            e.wheelY = e.deltaY * factor || 0;
                                            break;
                                        case e.DOM_DELTA_LINE:
                                        case e.DOM_DELTA_PAGE:
                                            e.wheelX = (e.deltaX || 0) * 5;
                                            e.wheelY = (e.deltaY || 0) * 5;
                                            break;
                                    }

                                    callback(e);
                                });
                            } else {
                                exports.addListener(el, "DOMMouseScroll", function (e) {
                                    if (e.axis && e.axis == e.HORIZONTAL_AXIS) {
                                        e.wheelX = (e.detail || 0) * 5;
                                        e.wheelY = 0;
                                    } else {
                                        e.wheelX = 0;
                                        e.wheelY = (e.detail || 0) * 5;
                                    }
                                    callback(e);
                                });
                            }
                        };

                        exports.addMultiMouseDownListener = function (elements, timeouts, eventHandler, callbackName) {
                            var clicks = 0;
                            var startX, startY, timer;
                            var eventNames = {
                                2: "dblclick",
                                3: "tripleclick",
                                4: "quadclick"
                            };

                            function onMousedown(e) {
                                if (exports.getButton(e) !== 0) {
                                    clicks = 0;
                                } else if (e.detail > 1) {
                                    clicks++;
                                    if (clicks > 4)
                                        clicks = 1;
                                } else {
                                    clicks = 1;
                                }
                                if (useragent.isIE) {
                                    var isNewClick = Math.abs(e.clientX - startX) > 5 || Math.abs(e.clientY - startY) > 5;
                                    if (!timer || isNewClick)
                                        clicks = 1;
                                    if (timer)
                                        clearTimeout(timer);
                                    timer = setTimeout(function () {
                                        timer = null;
                                    }, timeouts[clicks - 1] || 600);

                                    if (clicks == 1) {
                                        startX = e.clientX;
                                        startY = e.clientY;
                                    }
                                }

                                e._clicks = clicks;

                                eventHandler[callbackName]("mousedown", e);

                                if (clicks > 4)
                                    clicks = 0;
                                else if (clicks > 1)
                                    return eventHandler[callbackName](eventNames[clicks], e);
                            }

                            if (!Array.isArray(elements))
                                elements = [elements];
                            elements.forEach(function (el) {
                                exports.addListener(el, "mousedown", onMousedown);
                            });
                        };

                        var getModifierHash = function (e) {
                            return 0 | (e.ctrlKey ? 1 : 0) | (e.altKey ? 2 : 0) | (e.shiftKey ? 4 : 0) | (e.metaKey ? 8 : 0);
                        };

                        exports.getModifierString = function (e) {
                            return keys.KEY_MODS[getModifierHash(e)];
                        };

                        function normalizeCommandKeys(callback, e, keyCode) {
                            var hashId = getModifierHash(e);

                            if (!useragent.isMac && pressedKeys) {
                                if (e.getModifierState && (e.getModifierState("OS") || e.getModifierState("Win")))
                                    hashId |= 8;
                                if (pressedKeys.altGr) {
                                    if ((3 & hashId) != 3)
                                        pressedKeys.altGr = 0;
                                    else
                                        return;
                                }
                                if (keyCode === 18 || keyCode === 17) {
                                    var location = "location" in e ? e.location : e.keyLocation;
                                    if (keyCode === 17 && location === 1) {
                                        if (pressedKeys[keyCode] == 1)
                                            ts = e.timeStamp;
                                    } else if (keyCode === 18 && hashId === 3 && location === 2) {
                                        var dt = e.timeStamp - ts;
                                        if (dt < 50)
                                            pressedKeys.altGr = true;
                                    }
                                }
                            }

                            if (keyCode in keys.MODIFIER_KEYS) {
                                keyCode = -1;
                            }

                            if (!hashId && keyCode === 13) {
                                var location = "location" in e ? e.location : e.keyLocation;
                                if (location === 3) {
                                    callback(e, hashId, -keyCode);
                                    if (e.defaultPrevented)
                                        return;
                                }
                            }

                            if (useragent.isChromeOS && hashId & 8) {
                                callback(e, hashId, keyCode);
                                if (e.defaultPrevented)
                                    return;
                                else
                                    hashId &= ~8;
                            }
                            if (!hashId && !(keyCode in keys.FUNCTION_KEYS) && !(keyCode in keys.PRINTABLE_KEYS)) {
                                return false;
                            }

                            return callback(e, hashId, keyCode);
                        }


                        exports.addCommandKeyListener = function (el, callback) {
                            var addListener = exports.addListener;
                            if (useragent.isOldGecko || (useragent.isOpera && !("KeyboardEvent" in window))) {
                                var lastKeyDownKeyCode = null;
                                addListener(el, "keydown", function (e) {
                                    lastKeyDownKeyCode = e.keyCode;
                                });
                                addListener(el, "keypress", function (e) {
                                    return normalizeCommandKeys(callback, e, lastKeyDownKeyCode);
                                });
                            } else {
                                var lastDefaultPrevented = null;

                                addListener(el, "keydown", function (e) {
                                    pressedKeys[e.keyCode] = (pressedKeys[e.keyCode] || 0) + 1;
                                    var result = normalizeCommandKeys(callback, e, e.keyCode);
                                    lastDefaultPrevented = e.defaultPrevented;
                                    return result;
                                });

                                addListener(el, "keypress", function (e) {
                                    if (lastDefaultPrevented && (e.ctrlKey || e.altKey || e.shiftKey || e.metaKey)) {
                                        exports.stopEvent(e);
                                        lastDefaultPrevented = null;
                                    }
                                });

                                addListener(el, "keyup", function (e) {
                                    pressedKeys[e.keyCode] = null;
                                });

                                if (!pressedKeys) {
                                    resetPressedKeys();
                                    addListener(window, "focus", resetPressedKeys);
                                }
                            }
                        };

                        function resetPressedKeys() {
                            pressedKeys = Object.create(null);
                        }

                        if (typeof window == "object" && window.postMessage && !useragent.isOldIE) {
                            var postMessageId = 1;
                            exports.nextTick = function (callback, win) {
                                win = win || window;
                                var messageName = "zero-timeout-message-" + (postMessageId++);

                                var listener = function (e) {
                                    if (e.data == messageName) {
                                        exports.stopPropagation(e);
                                        exports.removeListener(win, "message", listener);
                                        callback();
                                    }
                                };

                                exports.addListener(win, "message", listener);
                                win.postMessage(messageName, "*");
                            };
                        }

                        exports.$idleBlocked = false;
                        exports.onIdle = function (cb, timeout) {
                            return setTimeout(function handler() {
                                if (!exports.$idleBlocked) {
                                    cb();
                                } else {
                                    setTimeout(handler, 100);
                                }
                            }, timeout);
                        };

                        exports.$idleBlockId = null;
                        exports.blockIdle = function (delay) {
                            if (exports.$idleBlockId)
                                clearTimeout(exports.$idleBlockId);

                            exports.$idleBlocked = true;
                            exports.$idleBlockId = setTimeout(function () {
                                exports.$idleBlocked = false;
                            }, delay || 100);
                        };

                        exports.nextFrame = typeof window == "object" && (window.requestAnimationFrame
                            || window.mozRequestAnimationFrame
                            || window.webkitRequestAnimationFrame
                            || window.msRequestAnimationFrame
                            || window.oRequestAnimationFrame);

                        if (exports.nextFrame)
                            exports.nextFrame = exports.nextFrame.bind(window);
                        else
                            exports.nextFrame = function (callback) {
                                setTimeout(callback, 17);
                            };
                    });

                    ace.define("ace/range", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";
                        var comparePoints = function (p1, p2) {
                            return p1.row - p2.row || p1.column - p2.column;
                        };
                        var Range = function (startRow, startColumn, endRow, endColumn) {
                            this.start = {
                                row: startRow,
                                column: startColumn
                            };

                            this.end = {
                                row: endRow,
                                column: endColumn
                            };
                        };

                        (function () {
                            this.isEqual = function (range) {
                                return this.start.row === range.start.row &&
                                    this.end.row === range.end.row &&
                                    this.start.column === range.start.column &&
                                    this.end.column === range.end.column;
                            };
                            this.toString = function () {
                                return ("Range: [" + this.start.row + "/" + this.start.column +
                                    "] -> [" + this.end.row + "/" + this.end.column + "]");
                            };

                            this.contains = function (row, column) {
                                return this.compare(row, column) == 0;
                            };
                            this.compareRange = function (range) {
                                var cmp,
                                    end = range.end,
                                    start = range.start;

                                cmp = this.compare(end.row, end.column);
                                if (cmp == 1) {
                                    cmp = this.compare(start.row, start.column);
                                    if (cmp == 1) {
                                        return 2;
                                    } else if (cmp == 0) {
                                        return 1;
                                    } else {
                                        return 0;
                                    }
                                } else if (cmp == -1) {
                                    return -2;
                                } else {
                                    cmp = this.compare(start.row, start.column);
                                    if (cmp == -1) {
                                        return -1;
                                    } else if (cmp == 1) {
                                        return 42;
                                    } else {
                                        return 0;
                                    }
                                }
                            };
                            this.comparePoint = function (p) {
                                return this.compare(p.row, p.column);
                            };
                            this.containsRange = function (range) {
                                return this.comparePoint(range.start) == 0 && this.comparePoint(range.end) == 0;
                            };
                            this.intersects = function (range) {
                                var cmp = this.compareRange(range);
                                return (cmp == -1 || cmp == 0 || cmp == 1);
                            };
                            this.isEnd = function (row, column) {
                                return this.end.row == row && this.end.column == column;
                            };
                            this.isStart = function (row, column) {
                                return this.start.row == row && this.start.column == column;
                            };
                            this.setStart = function (row, column) {
                                if (typeof row == "object") {
                                    this.start.column = row.column;
                                    this.start.row = row.row;
                                } else {
                                    this.start.row = row;
                                    this.start.column = column;
                                }
                            };
                            this.setEnd = function (row, column) {
                                if (typeof row == "object") {
                                    this.end.column = row.column;
                                    this.end.row = row.row;
                                } else {
                                    this.end.row = row;
                                    this.end.column = column;
                                }
                            };
                            this.inside = function (row, column) {
                                if (this.compare(row, column) == 0) {
                                    if (this.isEnd(row, column) || this.isStart(row, column)) {
                                        return false;
                                    } else {
                                        return true;
                                    }
                                }
                                return false;
                            };
                            this.insideStart = function (row, column) {
                                if (this.compare(row, column) == 0) {
                                    if (this.isEnd(row, column)) {
                                        return false;
                                    } else {
                                        return true;
                                    }
                                }
                                return false;
                            };
                            this.insideEnd = function (row, column) {
                                if (this.compare(row, column) == 0) {
                                    if (this.isStart(row, column)) {
                                        return false;
                                    } else {
                                        return true;
                                    }
                                }
                                return false;
                            };
                            this.compare = function (row, column) {
                                if (!this.isMultiLine()) {
                                    if (row === this.start.row) {
                                        return column < this.start.column ? -1 : (column > this.end.column ? 1 : 0);
                                    }
                                }

                                if (row < this.start.row)
                                    return -1;

                                if (row > this.end.row)
                                    return 1;

                                if (this.start.row === row)
                                    return column >= this.start.column ? 0 : -1;

                                if (this.end.row === row)
                                    return column <= this.end.column ? 0 : 1;

                                return 0;
                            };
                            this.compareStart = function (row, column) {
                                if (this.start.row == row && this.start.column == column) {
                                    return -1;
                                } else {
                                    return this.compare(row, column);
                                }
                            };
                            this.compareEnd = function (row, column) {
                                if (this.end.row == row && this.end.column == column) {
                                    return 1;
                                } else {
                                    return this.compare(row, column);
                                }
                            };
                            this.compareInside = function (row, column) {
                                if (this.end.row == row && this.end.column == column) {
                                    return 1;
                                } else if (this.start.row == row && this.start.column == column) {
                                    return -1;
                                } else {
                                    return this.compare(row, column);
                                }
                            };
                            this.clipRows = function (firstRow, lastRow) {
                                if (this.end.row > lastRow)
                                    var end = {row: lastRow + 1, column: 0};
                                else if (this.end.row < firstRow)
                                    var end = {row: firstRow, column: 0};

                                if (this.start.row > lastRow)
                                    var start = {row: lastRow + 1, column: 0};
                                else if (this.start.row < firstRow)
                                    var start = {row: firstRow, column: 0};

                                return Range.fromPoints(start || this.start, end || this.end);
                            };
                            this.extend = function (row, column) {
                                var cmp = this.compare(row, column);

                                if (cmp == 0)
                                    return this;
                                else if (cmp == -1)
                                    var start = {row: row, column: column};
                                else
                                    var end = {row: row, column: column};

                                return Range.fromPoints(start || this.start, end || this.end);
                            };

                            this.isEmpty = function () {
                                return (this.start.row === this.end.row && this.start.column === this.end.column);
                            };
                            this.isMultiLine = function () {
                                return (this.start.row !== this.end.row);
                            };
                            this.clone = function () {
                                return Range.fromPoints(this.start, this.end);
                            };
                            this.collapseRows = function () {
                                if (this.end.column == 0)
                                    return new Range(this.start.row, 0, Math.max(this.start.row, this.end.row - 1), 0);
                                else
                                    return new Range(this.start.row, 0, this.end.row, 0);
                            };
                            this.toScreenRange = function (session) {
                                var screenPosStart = session.documentToScreenPosition(this.start);
                                var screenPosEnd = session.documentToScreenPosition(this.end);

                                return new Range(
                                    screenPosStart.row, screenPosStart.column,
                                    screenPosEnd.row, screenPosEnd.column
                                );
                            };
                            this.moveBy = function (row, column) {
                                this.start.row += row;
                                this.start.column += column;
                                this.end.row += row;
                                this.end.column += column;
                            };

                        }).call(Range.prototype);
                        Range.fromPoints = function (start, end) {
                            return new Range(start.row, start.column, end.row, end.column);
                        };
                        Range.comparePoints = comparePoints;

                        Range.comparePoints = function (p1, p2) {
                            return p1.row - p2.row || p1.column - p2.column;
                        };


                        exports.Range = Range;
                    });

                    ace.define("ace/lib/lang", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";

                        exports.last = function (a) {
                            return a[a.length - 1];
                        };

                        exports.stringReverse = function (string) {
                            return string.split("").reverse().join("");
                        };

                        exports.stringRepeat = function (string, count) {
                            var result = '';
                            while (count > 0) {
                                if (count & 1)
                                    result += string;

                                if (count >>= 1)
                                    string += string;
                            }
                            return result;
                        };

                        var trimBeginRegexp = /^\s\s*/;
                        var trimEndRegexp = /\s\s*$/;

                        exports.stringTrimLeft = function (string) {
                            return string.replace(trimBeginRegexp, '');
                        };

                        exports.stringTrimRight = function (string) {
                            return string.replace(trimEndRegexp, '');
                        };

                        exports.copyObject = function (obj) {
                            var copy = {};
                            for (var key in obj) {
                                copy[key] = obj[key];
                            }
                            return copy;
                        };

                        exports.copyArray = function (array) {
                            var copy = [];
                            for (var i = 0, l = array.length; i < l; i++) {
                                if (array[i] && typeof array[i] == "object")
                                    copy[i] = this.copyObject(array[i]);
                                else
                                    copy[i] = array[i];
                            }
                            return copy;
                        };

                        exports.deepCopy = function deepCopy(obj) {
                            if (typeof obj !== "object" || !obj)
                                return obj;
                            var copy;
                            if (Array.isArray(obj)) {
                                copy = [];
                                for (var key = 0; key < obj.length; key++) {
                                    copy[key] = deepCopy(obj[key]);
                                }
                                return copy;
                            }
                            if (Object.prototype.toString.call(obj) !== "[object Object]")
                                return obj;

                            copy = {};
                            for (var key in obj)
                                copy[key] = deepCopy(obj[key]);
                            return copy;
                        };

                        exports.arrayToMap = function (arr) {
                            var map = {};
                            for (var i = 0; i < arr.length; i++) {
                                map[arr[i]] = 1;
                            }
                            return map;

                        };

                        exports.createMap = function (props) {
                            var map = Object.create(null);
                            for (var i in props) {
                                map[i] = props[i];
                            }
                            return map;
                        };
                        exports.arrayRemove = function (array, value) {
                            for (var i = 0; i <= array.length; i++) {
                                if (value === array[i]) {
                                    array.splice(i, 1);
                                }
                            }
                        };

                        exports.escapeRegExp = function (str) {
                            return str.replace(/([.*+?^${}()|[\]\/\\])/g, '\\$1');
                        };

                        exports.escapeHTML = function (str) {
                            return ("" + str).replace(/&/g, "&#38;").replace(/"/g, "&#34;").replace(/'/g, "&#39;").replace(/</g, "&#60;");
                        };

                        exports.getMatchOffsets = function (string, regExp) {
                            var matches = [];

                            string.replace(regExp, function (str) {
                                matches.push({
                                    offset: arguments[arguments.length - 2],
                                    length: str.length
                                });
                            });

                            return matches;
                        };
                        exports.deferredCall = function (fcn) {
                            var timer = null;
                            var callback = function () {
                                timer = null;
                                fcn();
                            };

                            var deferred = function (timeout) {
                                deferred.cancel();
                                timer = setTimeout(callback, timeout || 0);
                                return deferred;
                            };

                            deferred.schedule = deferred;

                            deferred.call = function () {
                                this.cancel();
                                fcn();
                                return deferred;
                            };

                            deferred.cancel = function () {
                                clearTimeout(timer);
                                timer = null;
                                return deferred;
                            };

                            deferred.isPending = function () {
                                return timer;
                            };

                            return deferred;
                        };


                        exports.delayedCall = function (fcn, defaultTimeout) {
                            var timer = null;
                            var callback = function () {
                                timer = null;
                                fcn();
                            };

                            var _self = function (timeout) {
                                if (timer == null)
                                    timer = setTimeout(callback, timeout || defaultTimeout);
                            };

                            _self.delay = function (timeout) {
                                timer && clearTimeout(timer);
                                timer = setTimeout(callback, timeout || defaultTimeout);
                            };
                            _self.schedule = _self;

                            _self.call = function () {
                                this.cancel();
                                fcn();
                            };

                            _self.cancel = function () {
                                timer && clearTimeout(timer);
                                timer = null;
                            };

                            _self.isPending = function () {
                                return timer;
                            };

                            return _self;
                        };
                    });

                    ace.define("ace/clipboard", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";

                        var $cancelT;
                        module.exports = {
                            lineMode: false,
                            pasteCancelled: function () {
                                if ($cancelT && $cancelT > Date.now() - 50)
                                    return true;
                                return $cancelT = false;
                            },
                            cancel: function () {
                                $cancelT = Date.now();
                            }
                        };

                    });

                    ace.define("ace/keyboard/textinput", ["require", "exports", "module", "ace/lib/event", "ace/lib/useragent", "ace/lib/dom", "ace/lib/lang", "ace/clipboard", "ace/lib/keys"], function (require, exports, module) {
                        "use strict";

                        var event = require("../lib/event");
                        var useragent = require("../lib/useragent");
                        var dom = require("../lib/dom");
                        var lang = require("../lib/lang");
                        var clipboard = require("../clipboard");
                        var BROKEN_SETDATA = useragent.isChrome < 18;
                        var USE_IE_MIME_TYPE = useragent.isIE;
                        var HAS_FOCUS_ARGS = useragent.isChrome > 63;
                        var MAX_LINE_LENGTH = 400;

                        var KEYS = require("../lib/keys");
                        var MODS = KEYS.KEY_MODS;
                        var isIOS = useragent.isIOS;
                        var valueResetRegex = isIOS ? /\s/ : /\n/;

                        var TextInput = function (parentNode, host) {
                            var text = dom.createElement("textarea");
                            text.className = "ace_text-input";

                            text.setAttribute("wrap", "off");
                            text.setAttribute("autocorrect", "off");
                            text.setAttribute("autocapitalize", "off");
                            text.setAttribute("spellcheck", false);

                            text.style.opacity = "0";
                            parentNode.insertBefore(text, parentNode.firstChild);

                            var copied = false;
                            var pasted = false;
                            var inComposition = false;
                            var sendingText = false;
                            var tempStyle = '';

                            if (!useragent.isMobile)
                                text.style.fontSize = "1px";

                            var commandMode = false;
                            var ignoreFocusEvents = false;

                            var lastValue = "";
                            var lastSelectionStart = 0;
                            var lastSelectionEnd = 0;
                            var lastRestoreEnd = 0;
                            try {
                                var isFocused = document.activeElement === text;
                            } catch (e) {
                            }

                            event.addListener(text, "blur", function (e) {
                                if (ignoreFocusEvents) return;
                                host.onBlur(e);
                                isFocused = false;
                            });
                            event.addListener(text, "focus", function (e) {
                                if (ignoreFocusEvents) return;
                                isFocused = true;
                                if (useragent.isEdge) {
                                    try {
                                        if (!document.hasFocus())
                                            return;
                                    } catch (e) {
                                    }
                                }
                                host.onFocus(e);
                                if (useragent.isEdge)
                                    setTimeout(resetSelection);
                                else
                                    resetSelection();
                            });
                            this.$focusScroll = false;
                            this.focus = function () {
                                if (tempStyle || HAS_FOCUS_ARGS || this.$focusScroll == "browser")
                                    return text.focus({preventScroll: true});

                                var top = text.style.top;
                                text.style.position = "fixed";
                                text.style.top = "0px";
                                try {
                                    var isTransformed = text.getBoundingClientRect().top != 0;
                                } catch (e) {
                                    return;
                                }
                                var ancestors = [];
                                if (isTransformed) {
                                    var t = text.parentElement;
                                    while (t && t.nodeType == 1) {
                                        ancestors.push(t);
                                        t.setAttribute("ace_nocontext", true);
                                        if (!t.parentElement && t.getRootNode)
                                            t = t.getRootNode().host;
                                        else
                                            t = t.parentElement;
                                    }
                                }
                                text.focus({preventScroll: true});
                                if (isTransformed) {
                                    ancestors.forEach(function (p) {
                                        p.removeAttribute("ace_nocontext");
                                    });
                                }
                                setTimeout(function () {
                                    text.style.position = "";
                                    if (text.style.top == "0px")
                                        text.style.top = top;
                                }, 0);
                            };
                            this.blur = function () {
                                text.blur();
                            };
                            this.isFocused = function () {
                                return isFocused;
                            };

                            host.on("beforeEndOperation", function () {
                                if (host.curOp && host.curOp.command.name == "insertstring")
                                    return;
                                if (inComposition) {
                                    lastValue = text.value = "";
                                    onCompositionEnd();
                                }
                                resetSelection();
                            });

                            var resetSelection = isIOS
                                ? function (value) {
                                    if (!isFocused || (copied && !value) || sendingText) return;
                                    if (!value)
                                        value = "";
                                    var newValue = "\n ab" + value + "cde fg\n";
                                    if (newValue != text.value)
                                        text.value = lastValue = newValue;

                                    var selectionStart = 4;
                                    var selectionEnd = 4 + (value.length || (host.selection.isEmpty() ? 0 : 1));

                                    if (lastSelectionStart != selectionStart || lastSelectionEnd != selectionEnd) {
                                        text.setSelectionRange(selectionStart, selectionEnd);
                                    }
                                    lastSelectionStart = selectionStart;
                                    lastSelectionEnd = selectionEnd;
                                }
                                : function () {
                                    if (inComposition || sendingText)
                                        return;
                                    if (!isFocused && !afterContextMenu)
                                        return;
                                    inComposition = true;

                                    var selection = host.selection;
                                    var range = selection.getRange();
                                    var row = selection.cursor.row;
                                    var selectionStart = range.start.column;
                                    var selectionEnd = range.end.column;
                                    var line = host.session.getLine(row);

                                    if (range.start.row != row) {
                                        var prevLine = host.session.getLine(row - 1);
                                        selectionStart = range.start.row < row - 1 ? 0 : selectionStart;
                                        selectionEnd += prevLine.length + 1;
                                        line = prevLine + "\n" + line;
                                    } else if (range.end.row != row) {
                                        var nextLine = host.session.getLine(row + 1);
                                        selectionEnd = range.end.row > row + 1 ? nextLine.length : selectionEnd;
                                        selectionEnd += line.length + 1;
                                        line = line + "\n" + nextLine;
                                    }

                                    if (line.length > MAX_LINE_LENGTH) {
                                        if (selectionStart < MAX_LINE_LENGTH && selectionEnd < MAX_LINE_LENGTH) {
                                            line = line.slice(0, MAX_LINE_LENGTH);
                                        } else {
                                            line = "\n";
                                            selectionStart = 0;
                                            selectionEnd = 1;
                                        }
                                    }

                                    var newValue = line + "\n\n";
                                    if (newValue != lastValue) {
                                        text.value = lastValue = newValue;
                                        lastSelectionStart = lastSelectionEnd = newValue.length;
                                    }
                                    if (afterContextMenu) {
                                        lastSelectionStart = text.selectionStart;
                                        lastSelectionEnd = text.selectionEnd;
                                    }
                                    if (
                                        lastSelectionEnd != selectionEnd
                                        || lastSelectionStart != selectionStart
                                        || text.selectionEnd != lastSelectionEnd // on ie edge selectionEnd changes silently after the initialization
                                    ) {
                                        try {
                                            text.setSelectionRange(selectionStart, selectionEnd);
                                            lastSelectionStart = selectionStart;
                                            lastSelectionEnd = selectionEnd;
                                        } catch (e) {
                                        }
                                    }
                                    inComposition = false;
                                };

                            if (isFocused)
                                host.onFocus();


                            var isAllSelected = function (text) {
                                return text.selectionStart === 0 && text.selectionEnd >= lastValue.length
                                    && text.value === lastValue && lastValue
                                    && text.selectionEnd !== lastSelectionEnd;
                            };

                            var onSelect = function (e) {
                                if (inComposition)
                                    return;
                                if (copied) {
                                    copied = false;
                                } else if (isAllSelected(text)) {
                                    host.selectAll();
                                    resetSelection();
                                }
                            };

                            var inputHandler = null;
                            this.setInputHandler = function (cb) {
                                inputHandler = cb;
                            };
                            this.getInputHandler = function () {
                                return inputHandler;
                            };
                            var afterContextMenu = false;

                            var sendText = function (value, fromInput) {
                                if (afterContextMenu)
                                    afterContextMenu = false;
                                if (pasted) {
                                    resetSelection();
                                    if (value)
                                        host.onPaste(value);
                                    pasted = false;
                                    return "";
                                } else {
                                    var selectionStart = text.selectionStart;
                                    var selectionEnd = text.selectionEnd;

                                    var extendLeft = lastSelectionStart;
                                    var extendRight = lastValue.length - lastSelectionEnd;

                                    var inserted = value;
                                    var restoreStart = value.length - selectionStart;
                                    var restoreEnd = value.length - selectionEnd;

                                    var i = 0;
                                    while (extendLeft > 0 && lastValue[i] == value[i]) {
                                        i++;
                                        extendLeft--;
                                    }
                                    inserted = inserted.slice(i);
                                    i = 1;
                                    while (extendRight > 0 && lastValue.length - i > lastSelectionStart - 1 && lastValue[lastValue.length - i] == value[value.length - i]) {
                                        i++;
                                        extendRight--;
                                    }
                                    restoreStart -= i - 1;
                                    restoreEnd -= i - 1;
                                    var endIndex = inserted.length - i + 1;
                                    if (endIndex < 0) {
                                        extendLeft = -endIndex;
                                        endIndex = 0;
                                    }
                                    inserted = inserted.slice(0, endIndex);
                                    if (!fromInput && !inserted && !restoreStart && !extendLeft && !extendRight && !restoreEnd)
                                        return "";
                                    sendingText = true;
                                    if (inserted && !extendLeft && !extendRight && !restoreStart && !restoreEnd || commandMode) {
                                        host.onTextInput(inserted);
                                    } else {
                                        host.onTextInput(inserted, {
                                            extendLeft: extendLeft,
                                            extendRight: extendRight,
                                            restoreStart: restoreStart,
                                            restoreEnd: restoreEnd
                                        });
                                    }
                                    sendingText = false;

                                    lastValue = value;
                                    lastSelectionStart = selectionStart;
                                    lastSelectionEnd = selectionEnd;
                                    lastRestoreEnd = restoreEnd;
                                    return inserted;
                                }
                            };
                            var onInput = function (e) {
                                if (inComposition)
                                    return onCompositionUpdate();
                                if (e && e.inputType) {
                                    if (e.inputType == "historyUndo") return host.execCommand("undo");
                                    if (e.inputType == "historyRedo") return host.execCommand("redo");
                                }
                                var data = text.value;
                                var inserted = sendText(data, true);
                                if (data.length > MAX_LINE_LENGTH + 100 || valueResetRegex.test(inserted))
                                    resetSelection();
                            };

                            var handleClipboardData = function (e, data, forceIEMime) {
                                var clipboardData = e.clipboardData || window.clipboardData;
                                if (!clipboardData || BROKEN_SETDATA)
                                    return;
                                var mime = USE_IE_MIME_TYPE || forceIEMime ? "Text" : "text/plain";
                                try {
                                    if (data) {
                                        return clipboardData.setData(mime, data) !== false;
                                    } else {
                                        return clipboardData.getData(mime);
                                    }
                                } catch (e) {
                                    if (!forceIEMime)
                                        return handleClipboardData(e, data, true);
                                }
                            };

                            var doCopy = function (e, isCut) {
                                var data = host.getCopyText();
                                if (!data)
                                    return event.preventDefault(e);

                                if (handleClipboardData(e, data)) {
                                    if (isIOS) {
                                        resetSelection(data);
                                        copied = data;
                                        setTimeout(function () {
                                            copied = false;
                                        }, 10);
                                    }
                                    isCut ? host.onCut() : host.onCopy();
                                    event.preventDefault(e);
                                } else {
                                    copied = true;
                                    text.value = data;
                                    text.select();
                                    setTimeout(function () {
                                        copied = false;
                                        resetSelection();
                                        isCut ? host.onCut() : host.onCopy();
                                    });
                                }
                            };

                            var onCut = function (e) {
                                doCopy(e, true);
                            };

                            var onCopy = function (e) {
                                doCopy(e, false);
                            };

                            var onPaste = function (e) {
                                var data = handleClipboardData(e);
                                if (clipboard.pasteCancelled())
                                    return;
                                if (typeof data == "string") {
                                    if (data)
                                        host.onPaste(data, e);
                                    if (useragent.isIE)
                                        setTimeout(resetSelection);
                                    event.preventDefault(e);
                                } else {
                                    text.value = "";
                                    pasted = true;
                                }
                            };

                            event.addCommandKeyListener(text, host.onCommandKey.bind(host));

                            event.addListener(text, "select", onSelect);
                            event.addListener(text, "input", onInput);

                            event.addListener(text, "cut", onCut);
                            event.addListener(text, "copy", onCopy);
                            event.addListener(text, "paste", onPaste);
                            if (!('oncut' in text) || !('oncopy' in text) || !('onpaste' in text)) {
                                event.addListener(parentNode, "keydown", function (e) {
                                    if ((useragent.isMac && !e.metaKey) || !e.ctrlKey)
                                        return;

                                    switch (e.keyCode) {
                                        case 67:
                                            onCopy(e);
                                            break;
                                        case 86:
                                            onPaste(e);
                                            break;
                                        case 88:
                                            onCut(e);
                                            break;
                                    }
                                });
                            }
                            var onCompositionStart = function (e) {
                                if (inComposition || !host.onCompositionStart || host.$readOnly)
                                    return;

                                inComposition = {};

                                if (commandMode)
                                    return;

                                setTimeout(onCompositionUpdate, 0);
                                host.on("mousedown", cancelComposition);

                                var range = host.getSelectionRange();
                                range.end.row = range.start.row;
                                range.end.column = range.start.column;
                                inComposition.markerRange = range;
                                inComposition.selectionStart = lastSelectionStart;
                                host.onCompositionStart(inComposition);

                                if (inComposition.useTextareaForIME) {
                                    text.value = "";
                                    lastValue = "";
                                    lastSelectionStart = 0;
                                    lastSelectionEnd = 0;
                                } else {
                                    if (text.msGetInputContext)
                                        inComposition.context = text.msGetInputContext();
                                    if (text.getInputContext)
                                        inComposition.context = text.getInputContext();
                                }
                            };

                            var onCompositionUpdate = function () {
                                if (!inComposition || !host.onCompositionUpdate || host.$readOnly)
                                    return;
                                if (commandMode)
                                    return cancelComposition();

                                if (inComposition.useTextareaForIME) {
                                    host.onCompositionUpdate(text.value);
                                } else {
                                    var data = text.value;
                                    sendText(data);
                                    if (inComposition.markerRange) {
                                        if (inComposition.context) {
                                            inComposition.markerRange.start.column = inComposition.selectionStart
                                                = inComposition.context.compositionStartOffset;
                                        }
                                        inComposition.markerRange.end.column = inComposition.markerRange.start.column
                                            + lastSelectionEnd - inComposition.selectionStart + lastRestoreEnd;
                                    }
                                }
                            };

                            var onCompositionEnd = function (e) {
                                if (!host.onCompositionEnd || host.$readOnly) return;
                                inComposition = false;
                                host.onCompositionEnd();
                                host.off("mousedown", cancelComposition);
                                if (e) onInput();
                            };


                            function cancelComposition() {
                                ignoreFocusEvents = true;
                                text.blur();
                                text.focus();
                                ignoreFocusEvents = false;
                            }

                            var syncComposition = lang.delayedCall(onCompositionUpdate, 50).schedule.bind(null, null);

                            function onKeyup(e) {
                                if (e.keyCode == 27 && text.value.length < text.selectionStart) {
                                    if (!inComposition)
                                        lastValue = text.value;
                                    lastSelectionStart = lastSelectionEnd = -1;
                                    resetSelection();
                                }
                                syncComposition();
                            }

                            event.addListener(text, "compositionstart", onCompositionStart);
                            event.addListener(text, "compositionupdate", onCompositionUpdate);
                            event.addListener(text, "keyup", onKeyup);
                            event.addListener(text, "keydown", syncComposition);
                            event.addListener(text, "compositionend", onCompositionEnd);

                            this.getElement = function () {
                                return text;
                            };
                            this.setCommandMode = function (value) {
                                commandMode = value;
                                text.readOnly = false;
                            };

                            this.setReadOnly = function (readOnly) {
                                if (!commandMode)
                                    text.readOnly = readOnly;
                            };

                            this.setCopyWithEmptySelection = function (value) {
                            };

                            this.onContextMenu = function (e) {
                                afterContextMenu = true;
                                resetSelection();
                                host._emit("nativecontextmenu", {target: host, domEvent: e});
                                this.moveToMouse(e, true);
                            };

                            this.moveToMouse = function (e, bringToFront) {
                                if (!tempStyle)
                                    tempStyle = text.style.cssText;
                                text.style.cssText = (bringToFront ? "z-index:100000;" : "")
                                    + (useragent.isIE ? "opacity:0.1;" : "")
                                    + "text-indent: -" + (lastSelectionStart + lastSelectionEnd) * host.renderer.characterWidth * 0.5 + "px;";

                                var rect = host.container.getBoundingClientRect();
                                var style = dom.computedStyle(host.container);
                                var top = rect.top + (parseInt(style.borderTopWidth) || 0);
                                var left = rect.left + (parseInt(rect.borderLeftWidth) || 0);
                                var maxTop = rect.bottom - top - text.clientHeight - 2;
                                var move = function (e) {
                                    dom.translate(text, e.clientX - left - 2, Math.min(e.clientY - top - 2, maxTop));
                                };
                                move(e);

                                if (e.type != "mousedown")
                                    return;

                                host.renderer.$isMousePressed = true;

                                clearTimeout(closeTimeout);
                                if (useragent.isWin)
                                    event.capture(host.container, move, onContextMenuClose);
                            };

                            this.onContextMenuClose = onContextMenuClose;
                            var closeTimeout;

                            function onContextMenuClose() {
                                clearTimeout(closeTimeout);
                                closeTimeout = setTimeout(function () {
                                    if (tempStyle) {
                                        text.style.cssText = tempStyle;
                                        tempStyle = '';
                                    }
                                    host.renderer.$isMousePressed = false;
                                    if (host.renderer.$keepTextAreaAtCursor)
                                        host.renderer.$moveTextAreaToCursor();
                                }, 0);
                            }

                            var onContextMenu = function (e) {
                                host.textInput.onContextMenu(e);
                                onContextMenuClose();
                            };
                            event.addListener(text, "mouseup", onContextMenu);
                            event.addListener(text, "mousedown", function (e) {
                                e.preventDefault();
                                onContextMenuClose();
                            });
                            event.addListener(host.renderer.scroller, "contextmenu", onContextMenu);
                            event.addListener(text, "contextmenu", onContextMenu);

                            if (isIOS)
                                addIosSelectionHandler(parentNode, host, text);

                            function addIosSelectionHandler(parentNode, host, text) {
                                var typingResetTimeout = null;
                                var typing = false;

                                text.addEventListener("keydown", function (e) {
                                    if (typingResetTimeout) clearTimeout(typingResetTimeout);
                                    typing = true;
                                }, true);

                                text.addEventListener("keyup", function (e) {
                                    typingResetTimeout = setTimeout(function () {
                                        typing = false;
                                    }, 100);
                                }, true);
                                var detectArrowKeys = function (e) {
                                    if (document.activeElement !== text) return;
                                    if (typing || inComposition || host.$mouseHandler.isMousePressed) return;

                                    if (copied) {
                                        return;
                                    }
                                    var selectionStart = text.selectionStart;
                                    var selectionEnd = text.selectionEnd;

                                    var key = null;
                                    var modifier = 0;
                                    if (selectionStart == 0) {
                                        key = KEYS.up;
                                    } else if (selectionStart == 1) {
                                        key = KEYS.home;
                                    } else if (selectionEnd > lastSelectionEnd && lastValue[selectionEnd] == "\n") {
                                        key = KEYS.end;
                                    } else if (selectionStart < lastSelectionStart && lastValue[selectionStart - 1] == " ") {
                                        key = KEYS.left;
                                        modifier = MODS.option;
                                    } else if (
                                        selectionStart < lastSelectionStart
                                        || (
                                            selectionStart == lastSelectionStart
                                            && lastSelectionEnd != lastSelectionStart
                                            && selectionStart == selectionEnd
                                        )
                                    ) {
                                        key = KEYS.left;
                                    } else if (selectionEnd > lastSelectionEnd && lastValue.slice(0, selectionEnd).split("\n").length > 2) {
                                        key = KEYS.down;
                                    } else if (selectionEnd > lastSelectionEnd && lastValue[selectionEnd - 1] == " ") {
                                        key = KEYS.right;
                                        modifier = MODS.option;
                                    } else if (
                                        selectionEnd > lastSelectionEnd
                                        || (
                                            selectionEnd == lastSelectionEnd
                                            && lastSelectionEnd != lastSelectionStart
                                            && selectionStart == selectionEnd
                                        )
                                    ) {
                                        key = KEYS.right;
                                    }

                                    if (selectionStart !== selectionEnd)
                                        modifier |= MODS.shift;

                                    if (key) {
                                        var result = host.onCommandKey({}, modifier, key);
                                        if (!result && host.commands) {
                                            key = KEYS.keyCodeToString(key);
                                            var command = host.commands.findKeyCommand(modifier, key);
                                            if (command)
                                                host.execCommand(command);
                                        }
                                        lastSelectionStart = selectionStart;
                                        lastSelectionEnd = selectionEnd;
                                        resetSelection("");
                                    }
                                };
                                document.addEventListener("selectionchange", detectArrowKeys);
                                host.on("destroy", function () {
                                    document.removeEventListener("selectionchange", detectArrowKeys);
                                });
                            }

                        };

                        exports.TextInput = TextInput;
                    });

                    ace.define("ace/mouse/default_handlers", ["require", "exports", "module", "ace/lib/useragent"], function (require, exports, module) {
                        "use strict";

                        var useragent = require("../lib/useragent");

                        var DRAG_OFFSET = 0; // pixels
                        var SCROLL_COOLDOWN_T = 550; // milliseconds

                        function DefaultHandlers(mouseHandler) {
                            mouseHandler.$clickSelection = null;

                            var editor = mouseHandler.editor;
                            editor.setDefaultHandler("mousedown", this.onMouseDown.bind(mouseHandler));
                            editor.setDefaultHandler("dblclick", this.onDoubleClick.bind(mouseHandler));
                            editor.setDefaultHandler("tripleclick", this.onTripleClick.bind(mouseHandler));
                            editor.setDefaultHandler("quadclick", this.onQuadClick.bind(mouseHandler));
                            editor.setDefaultHandler("mousewheel", this.onMouseWheel.bind(mouseHandler));

                            var exports = ["select", "startSelect", "selectEnd", "selectAllEnd", "selectByWordsEnd",
                                "selectByLinesEnd", "dragWait", "dragWaitEnd", "focusWait"];

                            exports.forEach(function (x) {
                                mouseHandler[x] = this[x];
                            }, this);

                            mouseHandler.selectByLines = this.extendSelectionBy.bind(mouseHandler, "getLineRange");
                            mouseHandler.selectByWords = this.extendSelectionBy.bind(mouseHandler, "getWordRange");
                        }

                        (function () {

                            this.onMouseDown = function (ev) {
                                var inSelection = ev.inSelection();
                                var pos = ev.getDocumentPosition();
                                this.mousedownEvent = ev;
                                var editor = this.editor;

                                var button = ev.getButton();
                                if (button !== 0) {
                                    var selectionRange = editor.getSelectionRange();
                                    var selectionEmpty = selectionRange.isEmpty();
                                    if (selectionEmpty || button == 1)
                                        editor.selection.moveToPosition(pos);
                                    if (button == 2) {
                                        editor.textInput.onContextMenu(ev.domEvent);
                                        if (!useragent.isMozilla)
                                            ev.preventDefault();
                                    }
                                    return;
                                }

                                this.mousedownEvent.time = Date.now();
                                if (inSelection && !editor.isFocused()) {
                                    editor.focus();
                                    if (this.$focusTimeout && !this.$clickSelection && !editor.inMultiSelectMode) {
                                        this.setState("focusWait");
                                        this.captureMouse(ev);
                                        return;
                                    }
                                }

                                this.captureMouse(ev);
                                this.startSelect(pos, ev.domEvent._clicks > 1);
                                return ev.preventDefault();
                            };

                            this.startSelect = function (pos, waitForClickSelection) {
                                pos = pos || this.editor.renderer.screenToTextCoordinates(this.x, this.y);
                                var editor = this.editor;
                                if (!this.mousedownEvent) return;
                                if (this.mousedownEvent.getShiftKey())
                                    editor.selection.selectToPosition(pos);
                                else if (!waitForClickSelection)
                                    editor.selection.moveToPosition(pos);
                                if (!waitForClickSelection)
                                    this.select();
                                if (editor.renderer.scroller.setCapture) {
                                    editor.renderer.scroller.setCapture();
                                }
                                editor.setStyle("ace_selecting");
                                this.setState("select");
                            };

                            this.select = function () {
                                var anchor, editor = this.editor;
                                var cursor = editor.renderer.screenToTextCoordinates(this.x, this.y);
                                if (this.$clickSelection) {
                                    var cmp = this.$clickSelection.comparePoint(cursor);

                                    if (cmp == -1) {
                                        anchor = this.$clickSelection.end;
                                    } else if (cmp == 1) {
                                        anchor = this.$clickSelection.start;
                                    } else {
                                        var orientedRange = calcRangeOrientation(this.$clickSelection, cursor);
                                        cursor = orientedRange.cursor;
                                        anchor = orientedRange.anchor;
                                    }
                                    editor.selection.setSelectionAnchor(anchor.row, anchor.column);
                                }
                                editor.selection.selectToPosition(cursor);
                                editor.renderer.scrollCursorIntoView();
                            };

                            this.extendSelectionBy = function (unitName) {
                                var anchor, editor = this.editor;
                                var cursor = editor.renderer.screenToTextCoordinates(this.x, this.y);
                                var range = editor.selection[unitName](cursor.row, cursor.column);
                                if (this.$clickSelection) {
                                    var cmpStart = this.$clickSelection.comparePoint(range.start);
                                    var cmpEnd = this.$clickSelection.comparePoint(range.end);

                                    if (cmpStart == -1 && cmpEnd <= 0) {
                                        anchor = this.$clickSelection.end;
                                        if (range.end.row != cursor.row || range.end.column != cursor.column)
                                            cursor = range.start;
                                    } else if (cmpEnd == 1 && cmpStart >= 0) {
                                        anchor = this.$clickSelection.start;
                                        if (range.start.row != cursor.row || range.start.column != cursor.column)
                                            cursor = range.end;
                                    } else if (cmpStart == -1 && cmpEnd == 1) {
                                        cursor = range.end;
                                        anchor = range.start;
                                    } else {
                                        var orientedRange = calcRangeOrientation(this.$clickSelection, cursor);
                                        cursor = orientedRange.cursor;
                                        anchor = orientedRange.anchor;
                                    }
                                    editor.selection.setSelectionAnchor(anchor.row, anchor.column);
                                }
                                editor.selection.selectToPosition(cursor);
                                editor.renderer.scrollCursorIntoView();
                            };

                            this.selectEnd =
                                this.selectAllEnd =
                                    this.selectByWordsEnd =
                                        this.selectByLinesEnd = function () {
                                            this.$clickSelection = null;
                                            this.editor.unsetStyle("ace_selecting");
                                            if (this.editor.renderer.scroller.releaseCapture) {
                                                this.editor.renderer.scroller.releaseCapture();
                                            }
                                        };

                            this.focusWait = function () {
                                var distance = calcDistance(this.mousedownEvent.x, this.mousedownEvent.y, this.x, this.y);
                                var time = Date.now();

                                if (distance > DRAG_OFFSET || time - this.mousedownEvent.time > this.$focusTimeout)
                                    this.startSelect(this.mousedownEvent.getDocumentPosition());
                            };

                            this.onDoubleClick = function (ev) {
                                var pos = ev.getDocumentPosition();
                                var editor = this.editor;
                                var session = editor.session;

                                var range = session.getBracketRange(pos);
                                if (range) {
                                    if (range.isEmpty()) {
                                        range.start.column--;
                                        range.end.column++;
                                    }
                                    this.setState("select");
                                } else {
                                    range = editor.selection.getWordRange(pos.row, pos.column);
                                    this.setState("selectByWords");
                                }
                                this.$clickSelection = range;
                                this.select();
                            };

                            this.onTripleClick = function (ev) {
                                var pos = ev.getDocumentPosition();
                                var editor = this.editor;

                                this.setState("selectByLines");
                                var range = editor.getSelectionRange();
                                if (range.isMultiLine() && range.contains(pos.row, pos.column)) {
                                    this.$clickSelection = editor.selection.getLineRange(range.start.row);
                                    this.$clickSelection.end = editor.selection.getLineRange(range.end.row).end;
                                } else {
                                    this.$clickSelection = editor.selection.getLineRange(pos.row);
                                }
                                this.select();
                            };

                            this.onQuadClick = function (ev) {
                                var editor = this.editor;

                                editor.selectAll();
                                this.$clickSelection = editor.getSelectionRange();
                                this.setState("selectAll");
                            };

                            this.onMouseWheel = function (ev) {
                                if (ev.getAccelKey())
                                    return;
                                if (ev.getShiftKey() && ev.wheelY && !ev.wheelX) {
                                    ev.wheelX = ev.wheelY;
                                    ev.wheelY = 0;
                                }

                                var editor = this.editor;

                                if (!this.$lastScroll)
                                    this.$lastScroll = {t: 0, vx: 0, vy: 0, allowed: 0};

                                var prevScroll = this.$lastScroll;
                                var t = ev.domEvent.timeStamp;
                                var dt = t - prevScroll.t;
                                var vx = dt ? ev.wheelX / dt : prevScroll.vx;
                                var vy = dt ? ev.wheelY / dt : prevScroll.vy;
                                if (dt < SCROLL_COOLDOWN_T) {
                                    vx = (vx + prevScroll.vx) / 2;
                                    vy = (vy + prevScroll.vy) / 2;
                                }

                                var direction = Math.abs(vx / vy);

                                var canScroll = false;
                                if (direction >= 1 && editor.renderer.isScrollableBy(ev.wheelX * ev.speed, 0))
                                    canScroll = true;
                                if (direction <= 1 && editor.renderer.isScrollableBy(0, ev.wheelY * ev.speed))
                                    canScroll = true;

                                if (canScroll) {
                                    prevScroll.allowed = t;
                                } else if (t - prevScroll.allowed < SCROLL_COOLDOWN_T) {
                                    var isSlower = Math.abs(vx) <= 1.5 * Math.abs(prevScroll.vx)
                                        && Math.abs(vy) <= 1.5 * Math.abs(prevScroll.vy);
                                    if (isSlower) {
                                        canScroll = true;
                                        prevScroll.allowed = t;
                                    } else {
                                        prevScroll.allowed = 0;
                                    }
                                }

                                prevScroll.t = t;
                                prevScroll.vx = vx;
                                prevScroll.vy = vy;

                                if (canScroll) {
                                    editor.renderer.scrollBy(ev.wheelX * ev.speed, ev.wheelY * ev.speed);
                                    return ev.stop();
                                }
                            };

                        }).call(DefaultHandlers.prototype);

                        exports.DefaultHandlers = DefaultHandlers;

                        function calcDistance(ax, ay, bx, by) {
                            return Math.sqrt(Math.pow(bx - ax, 2) + Math.pow(by - ay, 2));
                        }

                        function calcRangeOrientation(range, cursor) {
                            if (range.start.row == range.end.row)
                                var cmp = 2 * cursor.column - range.start.column - range.end.column;
                            else if (range.start.row == range.end.row - 1 && !range.start.column && !range.end.column)
                                var cmp = cursor.column - 4;
                            else
                                var cmp = 2 * cursor.row - range.start.row - range.end.row;

                            if (cmp < 0)
                                return {cursor: range.start, anchor: range.end};
                            else
                                return {cursor: range.end, anchor: range.start};
                        }

                    });

                    ace.define("ace/tooltip", ["require", "exports", "module", "ace/lib/oop", "ace/lib/dom"], function (require, exports, module) {
                        "use strict";

                        var oop = require("./lib/oop");
                        var dom = require("./lib/dom");

                        function Tooltip(parentNode) {
                            this.isOpen = false;
                            this.$element = null;
                            this.$parentNode = parentNode;
                        }

                        (function () {
                            this.$init = function () {
                                this.$element = dom.createElement("div");
                                this.$element.className = "ace_tooltip";
                                this.$element.style.display = "none";
                                this.$parentNode.appendChild(this.$element);
                                return this.$element;
                            };
                            this.getElement = function () {
                                return this.$element || this.$init();
                            };
                            this.setText = function (text) {
                                this.getElement().textContent = text;
                            };
                            this.setHtml = function (html) {
                                this.getElement().innerHTML = html;
                            };
                            this.setPosition = function (x, y) {
                                this.getElement().style.left = x + "px";
                                this.getElement().style.top = y + "px";
                            };
                            this.setClassName = function (className) {
                                dom.addCssClass(this.getElement(), className);
                            };
                            this.show = function (text, x, y) {
                                if (text != null)
                                    this.setText(text);
                                if (x != null && y != null)
                                    this.setPosition(x, y);
                                if (!this.isOpen) {
                                    this.getElement().style.display = "block";
                                    this.isOpen = true;
                                }
                            };

                            this.hide = function () {
                                if (this.isOpen) {
                                    this.getElement().style.display = "none";
                                    this.isOpen = false;
                                }
                            };
                            this.getHeight = function () {
                                return this.getElement().offsetHeight;
                            };
                            this.getWidth = function () {
                                return this.getElement().offsetWidth;
                            };

                            this.destroy = function () {
                                this.isOpen = false;
                                if (this.$element && this.$element.parentNode) {
                                    this.$element.parentNode.removeChild(this.$element);
                                }
                            };

                        }).call(Tooltip.prototype);

                        exports.Tooltip = Tooltip;
                    });

                    ace.define("ace/mouse/default_gutter_handler", ["require", "exports", "module", "ace/lib/dom", "ace/lib/oop", "ace/lib/event", "ace/tooltip"], function (require, exports, module) {
                        "use strict";
                        var dom = require("../lib/dom");
                        var oop = require("../lib/oop");
                        var event = require("../lib/event");
                        var Tooltip = require("../tooltip").Tooltip;

                        function GutterHandler(mouseHandler) {
                            var editor = mouseHandler.editor;
                            var gutter = editor.renderer.$gutterLayer;
                            var tooltip = new GutterTooltip(editor.container);

                            mouseHandler.editor.setDefaultHandler("guttermousedown", function (e) {
                                if (!editor.isFocused() || e.getButton() != 0)
                                    return;
                                var gutterRegion = gutter.getRegion(e);

                                if (gutterRegion == "foldWidgets")
                                    return;

                                var row = e.getDocumentPosition().row;
                                var selection = editor.session.selection;

                                if (e.getShiftKey())
                                    selection.selectTo(row, 0);
                                else {
                                    if (e.domEvent.detail == 2) {
                                        editor.selectAll();
                                        return e.preventDefault();
                                    }
                                    mouseHandler.$clickSelection = editor.selection.getLineRange(row);
                                }
                                mouseHandler.setState("selectByLines");
                                mouseHandler.captureMouse(e);
                                return e.preventDefault();
                            });


                            var tooltipTimeout, mouseEvent, tooltipAnnotation;

                            function showTooltip() {
                                var row = mouseEvent.getDocumentPosition().row;
                                var annotation = gutter.$annotations[row];
                                if (!annotation)
                                    return hideTooltip();

                                var maxRow = editor.session.getLength();
                                if (row == maxRow) {
                                    var screenRow = editor.renderer.pixelToScreenCoordinates(0, mouseEvent.y).row;
                                    var pos = mouseEvent.$pos;
                                    if (screenRow > editor.session.documentToScreenRow(pos.row, pos.column))
                                        return hideTooltip();
                                }

                                if (tooltipAnnotation == annotation)
                                    return;
                                tooltipAnnotation = annotation.text.join("<br/>");

                                tooltip.setHtml(tooltipAnnotation);
                                tooltip.show();
                                editor._signal("showGutterTooltip", tooltip);
                                editor.on("mousewheel", hideTooltip);

                                if (mouseHandler.$tooltipFollowsMouse) {
                                    moveTooltip(mouseEvent);
                                } else {
                                    var gutterElement = mouseEvent.domEvent.target;
                                    var rect = gutterElement.getBoundingClientRect();
                                    var style = tooltip.getElement().style;
                                    style.left = rect.right + "px";
                                    style.top = rect.bottom + "px";
                                }
                            }

                            function hideTooltip() {
                                if (tooltipTimeout)
                                    tooltipTimeout = clearTimeout(tooltipTimeout);
                                if (tooltipAnnotation) {
                                    tooltip.hide();
                                    tooltipAnnotation = null;
                                    editor._signal("hideGutterTooltip", tooltip);
                                    editor.removeEventListener("mousewheel", hideTooltip);
                                }
                            }

                            function moveTooltip(e) {
                                tooltip.setPosition(e.x, e.y);
                            }

                            mouseHandler.editor.setDefaultHandler("guttermousemove", function (e) {
                                var target = e.domEvent.target || e.domEvent.srcElement;
                                if (dom.hasCssClass(target, "ace_fold-widget"))
                                    return hideTooltip();

                                if (tooltipAnnotation && mouseHandler.$tooltipFollowsMouse)
                                    moveTooltip(e);

                                mouseEvent = e;
                                if (tooltipTimeout)
                                    return;
                                tooltipTimeout = setTimeout(function () {
                                    tooltipTimeout = null;
                                    if (mouseEvent && !mouseHandler.isMousePressed)
                                        showTooltip();
                                    else
                                        hideTooltip();
                                }, 50);
                            });

                            event.addListener(editor.renderer.$gutter, "mouseout", function (e) {
                                mouseEvent = null;
                                if (!tooltipAnnotation || tooltipTimeout)
                                    return;

                                tooltipTimeout = setTimeout(function () {
                                    tooltipTimeout = null;
                                    hideTooltip();
                                }, 50);
                            });

                            editor.on("changeSession", hideTooltip);
                        }

                        function GutterTooltip(parentNode) {
                            Tooltip.call(this, parentNode);
                        }

                        oop.inherits(GutterTooltip, Tooltip);

                        (function () {
                            this.setPosition = function (x, y) {
                                var windowWidth = window.innerWidth || document.documentElement.clientWidth;
                                var windowHeight = window.innerHeight || document.documentElement.clientHeight;
                                var width = this.getWidth();
                                var height = this.getHeight();
                                x += 15;
                                y += 15;
                                if (x + width > windowWidth) {
                                    x -= (x + width) - windowWidth;
                                }
                                if (y + height > windowHeight) {
                                    y -= 20 + height;
                                }
                                Tooltip.prototype.setPosition.call(this, x, y);
                            };

                        }).call(GutterTooltip.prototype);


                        exports.GutterHandler = GutterHandler;

                    });

                    ace.define("ace/mouse/mouse_event", ["require", "exports", "module", "ace/lib/event", "ace/lib/useragent"], function (require, exports, module) {
                        "use strict";

                        var event = require("../lib/event");
                        var useragent = require("../lib/useragent");
                        var MouseEvent = exports.MouseEvent = function (domEvent, editor) {
                            this.domEvent = domEvent;
                            this.editor = editor;

                            this.x = this.clientX = domEvent.clientX;
                            this.y = this.clientY = domEvent.clientY;

                            this.$pos = null;
                            this.$inSelection = null;

                            this.propagationStopped = false;
                            this.defaultPrevented = false;
                        };

                        (function () {

                            this.stopPropagation = function () {
                                event.stopPropagation(this.domEvent);
                                this.propagationStopped = true;
                            };

                            this.preventDefault = function () {
                                event.preventDefault(this.domEvent);
                                this.defaultPrevented = true;
                            };

                            this.stop = function () {
                                this.stopPropagation();
                                this.preventDefault();
                            };
                            this.getDocumentPosition = function () {
                                if (this.$pos)
                                    return this.$pos;

                                this.$pos = this.editor.renderer.screenToTextCoordinates(this.clientX, this.clientY);
                                return this.$pos;
                            };
                            this.inSelection = function () {
                                if (this.$inSelection !== null)
                                    return this.$inSelection;

                                var editor = this.editor;


                                var selectionRange = editor.getSelectionRange();
                                if (selectionRange.isEmpty())
                                    this.$inSelection = false;
                                else {
                                    var pos = this.getDocumentPosition();
                                    this.$inSelection = selectionRange.contains(pos.row, pos.column);
                                }

                                return this.$inSelection;
                            };
                            this.getButton = function () {
                                return event.getButton(this.domEvent);
                            };
                            this.getShiftKey = function () {
                                return this.domEvent.shiftKey;
                            };

                            this.getAccelKey = useragent.isMac
                                ? function () {
                                    return this.domEvent.metaKey;
                                }
                                : function () {
                                    return this.domEvent.ctrlKey;
                                };

                        }).call(MouseEvent.prototype);

                    });

                    ace.define("ace/mouse/dragdrop_handler", ["require", "exports", "module", "ace/lib/dom", "ace/lib/event", "ace/lib/useragent"], function (require, exports, module) {
                        "use strict";

                        var dom = require("../lib/dom");
                        var event = require("../lib/event");
                        var useragent = require("../lib/useragent");

                        var AUTOSCROLL_DELAY = 200;
                        var SCROLL_CURSOR_DELAY = 200;
                        var SCROLL_CURSOR_HYSTERESIS = 5;

                        function DragdropHandler(mouseHandler) {

                            var editor = mouseHandler.editor;

                            var blankImage = dom.createElement("img");
                            blankImage.src = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
                            if (useragent.isOpera)
                                blankImage.style.cssText = "width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;";

                            var exports = ["dragWait", "dragWaitEnd", "startDrag", "dragReadyEnd", "onMouseDrag"];

                            exports.forEach(function (x) {
                                mouseHandler[x] = this[x];
                            }, this);
                            editor.addEventListener("mousedown", this.onMouseDown.bind(mouseHandler));


                            var mouseTarget = editor.container;
                            var dragSelectionMarker, x, y;
                            var timerId, range;
                            var dragCursor, counter = 0;
                            var dragOperation;
                            var isInternal;
                            var autoScrollStartTime;
                            var cursorMovedTime;
                            var cursorPointOnCaretMoved;

                            this.onDragStart = function (e) {
                                if (this.cancelDrag || !mouseTarget.draggable) {
                                    var self = this;
                                    setTimeout(function () {
                                        self.startSelect();
                                        self.captureMouse(e);
                                    }, 0);
                                    return e.preventDefault();
                                }
                                range = editor.getSelectionRange();

                                var dataTransfer = e.dataTransfer;
                                dataTransfer.effectAllowed = editor.getReadOnly() ? "copy" : "copyMove";
                                if (useragent.isOpera) {
                                    editor.container.appendChild(blankImage);
                                    blankImage.scrollTop = 0;
                                }
                                dataTransfer.setDragImage && dataTransfer.setDragImage(blankImage, 0, 0);
                                if (useragent.isOpera) {
                                    editor.container.removeChild(blankImage);
                                }
                                dataTransfer.clearData();
                                dataTransfer.setData("Text", editor.session.getTextRange());

                                isInternal = true;
                                this.setState("drag");
                            };

                            this.onDragEnd = function (e) {
                                mouseTarget.draggable = false;
                                isInternal = false;
                                this.setState(null);
                                if (!editor.getReadOnly()) {
                                    var dropEffect = e.dataTransfer.dropEffect;
                                    if (!dragOperation && dropEffect == "move")
                                        editor.session.remove(editor.getSelectionRange());
                                    editor.$resetCursorStyle();
                                }
                                this.editor.unsetStyle("ace_dragging");
                                this.editor.renderer.setCursorStyle("");
                            };

                            this.onDragEnter = function (e) {
                                if (editor.getReadOnly() || !canAccept(e.dataTransfer))
                                    return;
                                x = e.clientX;
                                y = e.clientY;
                                if (!dragSelectionMarker)
                                    addDragMarker();
                                counter++;
                                e.dataTransfer.dropEffect = dragOperation = getDropEffect(e);
                                return event.preventDefault(e);
                            };

                            this.onDragOver = function (e) {
                                if (editor.getReadOnly() || !canAccept(e.dataTransfer))
                                    return;
                                x = e.clientX;
                                y = e.clientY;
                                if (!dragSelectionMarker) {
                                    addDragMarker();
                                    counter++;
                                }
                                if (onMouseMoveTimer !== null)
                                    onMouseMoveTimer = null;

                                e.dataTransfer.dropEffect = dragOperation = getDropEffect(e);
                                return event.preventDefault(e);
                            };

                            this.onDragLeave = function (e) {
                                counter--;
                                if (counter <= 0 && dragSelectionMarker) {
                                    clearDragMarker();
                                    dragOperation = null;
                                    return event.preventDefault(e);
                                }
                            };

                            this.onDrop = function (e) {
                                if (!dragCursor)
                                    return;
                                var dataTransfer = e.dataTransfer;
                                if (isInternal) {
                                    switch (dragOperation) {
                                        case "move":
                                            if (range.contains(dragCursor.row, dragCursor.column)) {
                                                range = {
                                                    start: dragCursor,
                                                    end: dragCursor
                                                };
                                            } else {
                                                range = editor.moveText(range, dragCursor);
                                            }
                                            break;
                                        case "copy":
                                            range = editor.moveText(range, dragCursor, true);
                                            break;
                                    }
                                } else {
                                    var dropData = dataTransfer.getData('Text');
                                    range = {
                                        start: dragCursor,
                                        end: editor.session.insert(dragCursor, dropData)
                                    };
                                    editor.focus();
                                    dragOperation = null;
                                }
                                clearDragMarker();
                                return event.preventDefault(e);
                            };

                            event.addListener(mouseTarget, "dragstart", this.onDragStart.bind(mouseHandler));
                            event.addListener(mouseTarget, "dragend", this.onDragEnd.bind(mouseHandler));
                            event.addListener(mouseTarget, "dragenter", this.onDragEnter.bind(mouseHandler));
                            event.addListener(mouseTarget, "dragover", this.onDragOver.bind(mouseHandler));
                            event.addListener(mouseTarget, "dragleave", this.onDragLeave.bind(mouseHandler));
                            event.addListener(mouseTarget, "drop", this.onDrop.bind(mouseHandler));

                            function scrollCursorIntoView(cursor, prevCursor) {
                                var now = Date.now();
                                var vMovement = !prevCursor || cursor.row != prevCursor.row;
                                var hMovement = !prevCursor || cursor.column != prevCursor.column;
                                if (!cursorMovedTime || vMovement || hMovement) {
                                    editor.moveCursorToPosition(cursor);
                                    cursorMovedTime = now;
                                    cursorPointOnCaretMoved = {x: x, y: y};
                                } else {
                                    var distance = calcDistance(cursorPointOnCaretMoved.x, cursorPointOnCaretMoved.y, x, y);
                                    if (distance > SCROLL_CURSOR_HYSTERESIS) {
                                        cursorMovedTime = null;
                                    } else if (now - cursorMovedTime >= SCROLL_CURSOR_DELAY) {
                                        editor.renderer.scrollCursorIntoView();
                                        cursorMovedTime = null;
                                    }
                                }
                            }

                            function autoScroll(cursor, prevCursor) {
                                var now = Date.now();
                                var lineHeight = editor.renderer.layerConfig.lineHeight;
                                var characterWidth = editor.renderer.layerConfig.characterWidth;
                                var editorRect = editor.renderer.scroller.getBoundingClientRect();
                                var offsets = {
                                    x: {
                                        left: x - editorRect.left,
                                        right: editorRect.right - x
                                    },
                                    y: {
                                        top: y - editorRect.top,
                                        bottom: editorRect.bottom - y
                                    }
                                };
                                var nearestXOffset = Math.min(offsets.x.left, offsets.x.right);
                                var nearestYOffset = Math.min(offsets.y.top, offsets.y.bottom);
                                var scrollCursor = {row: cursor.row, column: cursor.column};
                                if (nearestXOffset / characterWidth <= 2) {
                                    scrollCursor.column += (offsets.x.left < offsets.x.right ? -3 : +2);
                                }
                                if (nearestYOffset / lineHeight <= 1) {
                                    scrollCursor.row += (offsets.y.top < offsets.y.bottom ? -1 : +1);
                                }
                                var vScroll = cursor.row != scrollCursor.row;
                                var hScroll = cursor.column != scrollCursor.column;
                                var vMovement = !prevCursor || cursor.row != prevCursor.row;
                                if (vScroll || (hScroll && !vMovement)) {
                                    if (!autoScrollStartTime)
                                        autoScrollStartTime = now;
                                    else if (now - autoScrollStartTime >= AUTOSCROLL_DELAY)
                                        editor.renderer.scrollCursorIntoView(scrollCursor);
                                } else {
                                    autoScrollStartTime = null;
                                }
                            }

                            function onDragInterval() {
                                var prevCursor = dragCursor;
                                dragCursor = editor.renderer.screenToTextCoordinates(x, y);
                                scrollCursorIntoView(dragCursor, prevCursor);
                                autoScroll(dragCursor, prevCursor);
                            }

                            function addDragMarker() {
                                range = editor.selection.toOrientedRange();
                                dragSelectionMarker = editor.session.addMarker(range, "ace_selection", editor.getSelectionStyle());
                                editor.clearSelection();
                                if (editor.isFocused())
                                    editor.renderer.$cursorLayer.setBlinking(false);
                                clearInterval(timerId);
                                onDragInterval();
                                timerId = setInterval(onDragInterval, 20);
                                counter = 0;
                                event.addListener(document, "mousemove", onMouseMove);
                            }

                            function clearDragMarker() {
                                clearInterval(timerId);
                                editor.session.removeMarker(dragSelectionMarker);
                                dragSelectionMarker = null;
                                editor.selection.fromOrientedRange(range);
                                if (editor.isFocused() && !isInternal)
                                    editor.$resetCursorStyle();
                                range = null;
                                dragCursor = null;
                                counter = 0;
                                autoScrollStartTime = null;
                                cursorMovedTime = null;
                                event.removeListener(document, "mousemove", onMouseMove);
                            }

                            var onMouseMoveTimer = null;

                            function onMouseMove() {
                                if (onMouseMoveTimer == null) {
                                    onMouseMoveTimer = setTimeout(function () {
                                        if (onMouseMoveTimer != null && dragSelectionMarker)
                                            clearDragMarker();
                                    }, 20);
                                }
                            }

                            function canAccept(dataTransfer) {
                                var types = dataTransfer.types;
                                return !types || Array.prototype.some.call(types, function (type) {
                                    return type == 'text/plain' || type == 'Text';
                                });
                            }

                            function getDropEffect(e) {
                                var copyAllowed = ['copy', 'copymove', 'all', 'uninitialized'];
                                var moveAllowed = ['move', 'copymove', 'linkmove', 'all', 'uninitialized'];

                                var copyModifierState = useragent.isMac ? e.altKey : e.ctrlKey;
                                var effectAllowed = "uninitialized";
                                try {
                                    effectAllowed = e.dataTransfer.effectAllowed.toLowerCase();
                                } catch (e) {
                                }
                                var dropEffect = "none";

                                if (copyModifierState && copyAllowed.indexOf(effectAllowed) >= 0)
                                    dropEffect = "copy";
                                else if (moveAllowed.indexOf(effectAllowed) >= 0)
                                    dropEffect = "move";
                                else if (copyAllowed.indexOf(effectAllowed) >= 0)
                                    dropEffect = "copy";

                                return dropEffect;
                            }
                        }

                        (function () {

                            this.dragWait = function () {
                                var interval = Date.now() - this.mousedownEvent.time;
                                if (interval > this.editor.getDragDelay())
                                    this.startDrag();
                            };

                            this.dragWaitEnd = function () {
                                var target = this.editor.container;
                                target.draggable = false;
                                this.startSelect(this.mousedownEvent.getDocumentPosition());
                                this.selectEnd();
                            };

                            this.dragReadyEnd = function (e) {
                                this.editor.$resetCursorStyle();
                                this.editor.unsetStyle("ace_dragging");
                                this.editor.renderer.setCursorStyle("");
                                this.dragWaitEnd();
                            };

                            this.startDrag = function () {
                                this.cancelDrag = false;
                                var editor = this.editor;
                                var target = editor.container;
                                target.draggable = true;
                                editor.renderer.$cursorLayer.setBlinking(false);
                                editor.setStyle("ace_dragging");
                                var cursorStyle = useragent.isWin ? "default" : "move";
                                editor.renderer.setCursorStyle(cursorStyle);
                                this.setState("dragReady");
                            };

                            this.onMouseDrag = function (e) {
                                var target = this.editor.container;
                                if (useragent.isIE && this.state == "dragReady") {
                                    var distance = calcDistance(this.mousedownEvent.x, this.mousedownEvent.y, this.x, this.y);
                                    if (distance > 3)
                                        target.dragDrop();
                                }
                                if (this.state === "dragWait") {
                                    var distance = calcDistance(this.mousedownEvent.x, this.mousedownEvent.y, this.x, this.y);
                                    if (distance > 0) {
                                        target.draggable = false;
                                        this.startSelect(this.mousedownEvent.getDocumentPosition());
                                    }
                                }
                            };

                            this.onMouseDown = function (e) {
                                if (!this.$dragEnabled)
                                    return;
                                this.mousedownEvent = e;
                                var editor = this.editor;

                                var inSelection = e.inSelection();
                                var button = e.getButton();
                                var clickCount = e.domEvent.detail || 1;
                                if (clickCount === 1 && button === 0 && inSelection) {
                                    if (e.editor.inMultiSelectMode && (e.getAccelKey() || e.getShiftKey()))
                                        return;
                                    this.mousedownEvent.time = Date.now();
                                    var eventTarget = e.domEvent.target || e.domEvent.srcElement;
                                    if ("unselectable" in eventTarget)
                                        eventTarget.unselectable = "on";
                                    if (editor.getDragDelay()) {
                                        if (useragent.isWebKit) {
                                            this.cancelDrag = true;
                                            var mouseTarget = editor.container;
                                            mouseTarget.draggable = true;
                                        }
                                        this.setState("dragWait");
                                    } else {
                                        this.startDrag();
                                    }
                                    this.captureMouse(e, this.onMouseDrag.bind(this));
                                    e.defaultPrevented = true;
                                }
                            };

                        }).call(DragdropHandler.prototype);


                        function calcDistance(ax, ay, bx, by) {
                            return Math.sqrt(Math.pow(bx - ax, 2) + Math.pow(by - ay, 2));
                        }

                        exports.DragdropHandler = DragdropHandler;

                    });

                    ace.define("ace/mouse/touch_handler", ["require", "exports", "module", "ace/mouse/mouse_event", "ace/lib/event", "ace/lib/dom"], function (require, exports, module) {
                        "use strict";

                        var MouseEvent = require("./mouse_event").MouseEvent;
                        var event = require("../lib/event");
                        var dom = require("../lib/dom");

                        exports.addTouchListeners = function (el, editor) {
                            var mode = "scroll";
                            var startX;
                            var startY;
                            var touchStartT;
                            var lastT;
                            var longTouchTimer;
                            var animationTimer;
                            var animationSteps = 0;
                            var pos;
                            var clickCount = 0;
                            var vX = 0;
                            var vY = 0;
                            var pressed;
                            var contextMenu;

                            function createContextMenu() {
                                var clipboard = window.navigator && window.navigator.clipboard;
                                var isOpen = false;
                                var updateMenu = function () {
                                    var selected = editor.getCopyText();
                                    var hasUndo = editor.session.getUndoManager().hasUndo();
                                    contextMenu.replaceChild(
                                        dom.buildDom(isOpen ? ["span",
                                            !selected && ["span", {
                                                class: "ace_mobile-button",
                                                action: "selectall"
                                            }, "Select All"],
                                            selected && ["span", {class: "ace_mobile-button", action: "copy"}, "Copy"],
                                            selected && ["span", {class: "ace_mobile-button", action: "cut"}, "Cut"],
                                            clipboard && ["span", {
                                                class: "ace_mobile-button",
                                                action: "paste"
                                            }, "Paste"],
                                            hasUndo && ["span", {class: "ace_mobile-button", action: "undo"}, "Undo"],
                                            ["span", {class: "ace_mobile-button", action: "find"}, "Find"],
                                            ["span", {
                                                class: "ace_mobile-button",
                                                action: "openCommandPallete"
                                            }, "Pallete"]
                                        ] : ["span"]),
                                        contextMenu.firstChild
                                    );
                                };
                                var handleClick = function (e) {
                                    var action = e.target.getAttribute("action");

                                    if (action == "more" || !isOpen) {
                                        isOpen = !isOpen;
                                        return updateMenu();
                                    }
                                    if (action == "paste") {
                                        clipboard.readText().then(function (text) {
                                            editor.execCommand(action, text);
                                        });
                                    } else if (action) {
                                        if (action == "cut" || action == "copy") {
                                            if (clipboard)
                                                clipboard.writeText(editor.getCopyText());
                                            else
                                                document.execCommand("copy");
                                        }
                                        editor.execCommand(action);
                                    }
                                    contextMenu.firstChild.style.display = "none";
                                    isOpen = false;
                                    if (action != "openCommandPallete")
                                        editor.focus();
                                };
                                contextMenu = dom.buildDom(["div",
                                    {
                                        class: "ace_mobile-menu",
                                        ontouchstart: function (e) {
                                            mode = "menu";
                                            e.stopPropagation();
                                            e.preventDefault();
                                            editor.textInput.focus();
                                        },
                                        ontouchend: function (e) {
                                            e.stopPropagation();
                                            e.preventDefault();
                                            handleClick(e);
                                        },
                                        onclick: handleClick
                                    },
                                    ["span"],
                                    ["span", {class: "ace_mobile-button", action: "more"}, "..."]
                                ], editor.container);
                            }

                            function showContextMenu() {
                                if (!contextMenu) createContextMenu();
                                var cursor = editor.selection.cursor;
                                var pagePos = editor.renderer.textToScreenCoordinates(cursor.row, cursor.column);
                                var rect = editor.container.getBoundingClientRect();
                                contextMenu.style.top = pagePos.pageY - rect.top - 3 + "px";
                                contextMenu.style.right = "10px";
                                contextMenu.style.display = "";
                                contextMenu.firstChild.style.display = "none";
                                editor.on("input", hideContextMenu);
                            }

                            function hideContextMenu(e) {
                                if (contextMenu)
                                    contextMenu.style.display = "none";
                                editor.off("input", hideContextMenu);
                            }

                            function handleLongTap() {
                                longTouchTimer = null;
                                clearTimeout(longTouchTimer);
                                var range = editor.selection.getRange();
                                var inSelection = range.contains(pos.row, pos.column);
                                if (range.isEmpty() || !inSelection) {
                                    editor.selection.moveToPosition(pos);
                                    editor.selection.selectWord();
                                }
                                mode = "wait";
                                showContextMenu();
                            }

                            function switchToSelectionMode() {
                                longTouchTimer = null;
                                clearTimeout(longTouchTimer);
                                editor.selection.moveToPosition(pos);
                                var range = clickCount >= 2
                                    ? editor.selection.getLineRange(pos.row)
                                    : editor.session.getBracketRange(pos);
                                if (range && !range.isEmpty()) {
                                    editor.selection.setRange(range);
                                } else {
                                    editor.selection.selectWord();
                                }
                                mode = "wait";
                            }

                            event.addListener(el, "contextmenu", function (e) {
                                if (!pressed) return;
                                var textarea = editor.textInput.getElement();
                                textarea.focus();
                            });
                            event.addListener(el, "touchstart", function (e) {
                                var touches = e.touches;
                                if (longTouchTimer || touches.length > 1) {
                                    clearTimeout(longTouchTimer);
                                    longTouchTimer = null;
                                    touchStartT = -1;
                                    mode = "zoom";
                                    return;
                                }

                                pressed = editor.$mouseHandler.isMousePressed = true;
                                var h = editor.renderer.layerConfig.lineHeight;
                                var w = editor.renderer.layerConfig.lineHeight;
                                var t = e.timeStamp;
                                lastT = t;
                                var touchObj = touches[0];
                                var x = touchObj.clientX;
                                var y = touchObj.clientY;
                                if (Math.abs(startX - x) + Math.abs(startY - y) > h)
                                    touchStartT = -1;

                                startX = e.clientX = x;
                                startY = e.clientY = y;
                                vX = vY = 0;

                                var ev = new MouseEvent(e, editor);
                                pos = ev.getDocumentPosition();

                                if (t - touchStartT < 500 && touches.length == 1 && !animationSteps) {
                                    clickCount++;
                                    e.preventDefault();
                                    e.button = 0;
                                    switchToSelectionMode();
                                } else {
                                    clickCount = 0;
                                    var cursor = editor.selection.cursor;
                                    var anchor = editor.selection.isEmpty() ? cursor : editor.selection.anchor;

                                    var cursorPos = editor.renderer.$cursorLayer.getPixelPosition(cursor, true);
                                    var anchorPos = editor.renderer.$cursorLayer.getPixelPosition(anchor, true);
                                    var rect = editor.renderer.scroller.getBoundingClientRect();
                                    var weightedDistance = function (x, y) {
                                        x = x / w;
                                        y = y / h - 0.75;
                                        return x * x + y * y;
                                    };

                                    if (e.clientX < rect.left) {
                                        mode = "zoom";
                                        return;
                                    }

                                    var diff1 = weightedDistance(
                                        e.clientX - rect.left - cursorPos.left,
                                        e.clientY - rect.top - cursorPos.top
                                    );
                                    var diff2 = weightedDistance(
                                        e.clientX - rect.left - anchorPos.left,
                                        e.clientY - rect.top - anchorPos.top
                                    );
                                    if (diff1 < 3.5 && diff2 < 3.5)
                                        mode = diff1 > diff2 ? "cursor" : "anchor";

                                    if (diff2 < 3.5)
                                        mode = "anchor";
                                    else if (diff1 < 3.5)
                                        mode = "cursor";
                                    else
                                        mode = "scroll";
                                    longTouchTimer = setTimeout(handleLongTap, 450);
                                }
                                touchStartT = t;
                            });

                            event.addListener(el, "touchend", function (e) {
                                pressed = editor.$mouseHandler.isMousePressed = false;
                                if (animationTimer) clearInterval(animationTimer);
                                if (mode == "zoom") {
                                    mode = "";
                                    animationSteps = 0;
                                } else if (longTouchTimer) {
                                    editor.selection.moveToPosition(pos);
                                    animationSteps = 0;
                                    showContextMenu();
                                } else if (mode == "scroll") {
                                    animate();
                                    e.preventDefault();
                                    hideContextMenu();
                                } else {
                                    showContextMenu();
                                }
                                clearTimeout(longTouchTimer);
                                longTouchTimer = null;
                            });
                            event.addListener(el, "touchmove", function (e) {
                                if (longTouchTimer) {
                                    clearTimeout(longTouchTimer);
                                    longTouchTimer = null;
                                }
                                var touches = e.touches;
                                if (touches.length > 1 || mode == "zoom") return;

                                var touchObj = touches[0];

                                var wheelX = startX - touchObj.clientX;
                                var wheelY = startY - touchObj.clientY;

                                if (mode == "wait") {
                                    if (wheelX * wheelX + wheelY * wheelY > 4)
                                        mode = "cursor";
                                    else
                                        return e.preventDefault();
                                }

                                startX = touchObj.clientX;
                                startY = touchObj.clientY;

                                e.clientX = touchObj.clientX;
                                e.clientY = touchObj.clientY;

                                var t = e.timeStamp;
                                var dt = t - lastT;
                                lastT = t;
                                if (mode == "scroll") {
                                    var mouseEvent = new MouseEvent(e, editor);
                                    mouseEvent.speed = 1;
                                    mouseEvent.wheelX = wheelX;
                                    mouseEvent.wheelY = wheelY;
                                    if (10 * Math.abs(wheelX) < Math.abs(wheelY)) wheelX = 0;
                                    if (10 * Math.abs(wheelY) < Math.abs(wheelX)) wheelY = 0;
                                    if (dt != 0) {
                                        vX = wheelX / dt;
                                        vY = wheelY / dt;
                                    }
                                    editor._emit("mousewheel", mouseEvent);
                                    if (!mouseEvent.propagationStopped) {
                                        vX = vY = 0;
                                    }
                                } else {
                                    var ev = new MouseEvent(e, editor);
                                    var pos = ev.getDocumentPosition();
                                    if (mode == "cursor")
                                        editor.selection.moveCursorToPosition(pos);
                                    else if (mode == "anchor")
                                        editor.selection.setSelectionAnchor(pos.row, pos.column);
                                    editor.renderer.scrollCursorIntoView(pos);
                                    e.preventDefault();
                                }
                            });

                            function animate() {
                                animationSteps += 60;
                                animationTimer = setInterval(function () {
                                    if (animationSteps-- <= 0) {
                                        clearInterval(animationTimer);
                                        animationTimer = null;
                                    }
                                    if (Math.abs(vX) < 0.01) vX = 0;
                                    if (Math.abs(vY) < 0.01) vY = 0;
                                    if (animationSteps < 20) vX = 0.9 * vX;
                                    if (animationSteps < 20) vY = 0.9 * vY;
                                    var oldScrollTop = editor.session.getScrollTop();
                                    editor.renderer.scrollBy(10 * vX, 10 * vY);
                                    if (oldScrollTop == editor.session.getScrollTop())
                                        animationSteps = 0;
                                }, 10);
                            }
                        };

                    });

                    ace.define("ace/lib/net", ["require", "exports", "module", "ace/lib/dom"], function (require, exports, module) {
                        "use strict";
                        var dom = require("./dom");

                        exports.get = function (url, callback) {
                            var xhr = new XMLHttpRequest();
                            xhr.open('GET', url, true);
                            xhr.onreadystatechange = function () {
                                if (xhr.readyState === 4) {
                                    callback(xhr.responseText);
                                }
                            };
                            xhr.send(null);
                        };

                        exports.loadScript = function (path, callback) {
                            var head = dom.getDocumentHead();
                            var s = document.createElement('script');

                            s.src = path;
                            head.appendChild(s);

                            s.onload = s.onreadystatechange = function (_, isAbort) {
                                if (isAbort || !s.readyState || s.readyState == "loaded" || s.readyState == "complete") {
                                    s = s.onload = s.onreadystatechange = null;
                                    if (!isAbort)
                                        callback();
                                }
                            };
                        };
                        exports.qualifyURL = function (url) {
                            var a = document.createElement('a');
                            a.href = url;
                            return a.href;
                        };

                    });

                    ace.define("ace/lib/event_emitter", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";

                        var EventEmitter = {};
                        var stopPropagation = function () {
                            this.propagationStopped = true;
                        };
                        var preventDefault = function () {
                            this.defaultPrevented = true;
                        };

                        EventEmitter._emit =
                            EventEmitter._dispatchEvent = function (eventName, e) {
                                this._eventRegistry || (this._eventRegistry = {});
                                this._defaultHandlers || (this._defaultHandlers = {});

                                var listeners = this._eventRegistry[eventName] || [];
                                var defaultHandler = this._defaultHandlers[eventName];
                                if (!listeners.length && !defaultHandler)
                                    return;

                                if (typeof e != "object" || !e)
                                    e = {};

                                if (!e.type)
                                    e.type = eventName;
                                if (!e.stopPropagation)
                                    e.stopPropagation = stopPropagation;
                                if (!e.preventDefault)
                                    e.preventDefault = preventDefault;

                                listeners = listeners.slice();
                                for (var i = 0; i < listeners.length; i++) {
                                    listeners[i](e, this);
                                    if (e.propagationStopped)
                                        break;
                                }

                                if (defaultHandler && !e.defaultPrevented)
                                    return defaultHandler(e, this);
                            };


                        EventEmitter._signal = function (eventName, e) {
                            var listeners = (this._eventRegistry || {})[eventName];
                            if (!listeners)
                                return;
                            listeners = listeners.slice();
                            for (var i = 0; i < listeners.length; i++)
                                listeners[i](e, this);
                        };

                        EventEmitter.once = function (eventName, callback) {
                            var _self = this;
                            this.addEventListener(eventName, function newCallback() {
                                _self.removeEventListener(eventName, newCallback);
                                callback.apply(null, arguments);
                            });
                            if (!callback) {
                                return new Promise(function (resolve) {
                                    callback = resolve;
                                });
                            }
                        };


                        EventEmitter.setDefaultHandler = function (eventName, callback) {
                            var handlers = this._defaultHandlers;
                            if (!handlers)
                                handlers = this._defaultHandlers = {_disabled_: {}};

                            if (handlers[eventName]) {
                                var old = handlers[eventName];
                                var disabled = handlers._disabled_[eventName];
                                if (!disabled)
                                    handlers._disabled_[eventName] = disabled = [];
                                disabled.push(old);
                                var i = disabled.indexOf(callback);
                                if (i != -1)
                                    disabled.splice(i, 1);
                            }
                            handlers[eventName] = callback;
                        };
                        EventEmitter.removeDefaultHandler = function (eventName, callback) {
                            var handlers = this._defaultHandlers;
                            if (!handlers)
                                return;
                            var disabled = handlers._disabled_[eventName];

                            if (handlers[eventName] == callback) {
                                if (disabled)
                                    this.setDefaultHandler(eventName, disabled.pop());
                            } else if (disabled) {
                                var i = disabled.indexOf(callback);
                                if (i != -1)
                                    disabled.splice(i, 1);
                            }
                        };

                        EventEmitter.on =
                            EventEmitter.addEventListener = function (eventName, callback, capturing) {
                                this._eventRegistry = this._eventRegistry || {};

                                var listeners = this._eventRegistry[eventName];
                                if (!listeners)
                                    listeners = this._eventRegistry[eventName] = [];

                                if (listeners.indexOf(callback) == -1)
                                    listeners[capturing ? "unshift" : "push"](callback);
                                return callback;
                            };

                        EventEmitter.off =
                            EventEmitter.removeListener =
                                EventEmitter.removeEventListener = function (eventName, callback) {
                                    this._eventRegistry = this._eventRegistry || {};

                                    var listeners = this._eventRegistry[eventName];
                                    if (!listeners)
                                        return;

                                    var index = listeners.indexOf(callback);
                                    if (index !== -1)
                                        listeners.splice(index, 1);
                                };

                        EventEmitter.removeAllListeners = function (eventName) {
                            if (this._eventRegistry) this._eventRegistry[eventName] = [];
                        };

                        exports.EventEmitter = EventEmitter;

                    });

                    ace.define("ace/lib/app_config", ["require", "exports", "module", "ace/lib/oop", "ace/lib/event_emitter"], function (require, exports, module) {
                        "no use strict";

                        var oop = require("./oop");
                        var EventEmitter = require("./event_emitter").EventEmitter;

                        var optionsProvider = {
                            setOptions: function (optList) {
                                Object.keys(optList).forEach(function (key) {
                                    this.setOption(key, optList[key]);
                                }, this);
                            },
                            getOptions: function (optionNames) {
                                var result = {};
                                if (!optionNames) {
                                    var options = this.$options;
                                    optionNames = Object.keys(options).filter(function (key) {
                                        return !options[key].hidden;
                                    });
                                } else if (!Array.isArray(optionNames)) {
                                    result = optionNames;
                                    optionNames = Object.keys(result);
                                }
                                optionNames.forEach(function (key) {
                                    result[key] = this.getOption(key);
                                }, this);
                                return result;
                            },
                            setOption: function (name, value) {
                                if (this["$" + name] === value)
                                    return;
                                var opt = this.$options[name];
                                if (!opt) {
                                    return warn('misspelled option "' + name + '"');
                                }
                                if (opt.forwardTo)
                                    return this[opt.forwardTo] && this[opt.forwardTo].setOption(name, value);

                                if (!opt.handlesSet)
                                    this["$" + name] = value;
                                if (opt && opt.set)
                                    opt.set.call(this, value);
                            },
                            getOption: function (name) {
                                var opt = this.$options[name];
                                if (!opt) {
                                    return warn('misspelled option "' + name + '"');
                                }
                                if (opt.forwardTo)
                                    return this[opt.forwardTo] && this[opt.forwardTo].getOption(name);
                                return opt && opt.get ? opt.get.call(this) : this["$" + name];
                            }
                        };

                        function warn(message) {
                            if (typeof console != "undefined" && console.warn)
                                console.warn.apply(console, arguments);
                        }

                        function reportError(msg, data) {
                            var e = new Error(msg);
                            e.data = data;
                            if (typeof console == "object" && console.error)
                                console.error(e);
                            setTimeout(function () {
                                throw e;
                            });
                        }

                        var AppConfig = function () {
                            this.$defaultOptions = {};
                        };

                        (function () {
                            oop.implement(this, EventEmitter);
                            this.defineOptions = function (obj, path, options) {
                                if (!obj.$options)
                                    this.$defaultOptions[path] = obj.$options = {};

                                Object.keys(options).forEach(function (key) {
                                    var opt = options[key];
                                    if (typeof opt == "string")
                                        opt = {forwardTo: opt};

                                    opt.name || (opt.name = key);
                                    obj.$options[opt.name] = opt;
                                    if ("initialValue" in opt)
                                        obj["$" + opt.name] = opt.initialValue;
                                });
                                oop.implement(obj, optionsProvider);

                                return this;
                            };

                            this.resetOptions = function (obj) {
                                Object.keys(obj.$options).forEach(function (key) {
                                    var opt = obj.$options[key];
                                    if ("value" in opt)
                                        obj.setOption(key, opt.value);
                                });
                            };

                            this.setDefaultValue = function (path, name, value) {
                                if (!path) {
                                    for (path in this.$defaultOptions)
                                        if (this.$defaultOptions[path][name])
                                            break;
                                    if (!this.$defaultOptions[path][name])
                                        return false;
                                }
                                var opts = this.$defaultOptions[path] || (this.$defaultOptions[path] = {});
                                if (opts[name]) {
                                    if (opts.forwardTo)
                                        this.setDefaultValue(opts.forwardTo, name, value);
                                    else
                                        opts[name].value = value;
                                }
                            };

                            this.setDefaultValues = function (path, optionHash) {
                                Object.keys(optionHash).forEach(function (key) {
                                    this.setDefaultValue(path, key, optionHash[key]);
                                }, this);
                            };

                            this.warn = warn;
                            this.reportError = reportError;

                        }).call(AppConfig.prototype);

                        exports.AppConfig = AppConfig;

                    });

                    ace.define("ace/config", ["require", "exports", "module", "ace/lib/lang", "ace/lib/oop", "ace/lib/net", "ace/lib/app_config"], function (require, exports, module) {
                        "no use strict";

                        var lang = require("./lib/lang");
                        var oop = require("./lib/oop");
                        var net = require("./lib/net");
                        var AppConfig = require("./lib/app_config").AppConfig;

                        module.exports = exports = new AppConfig();

                        var global = (function () {
                            return this || typeof window != "undefined" && window;
                        })();

                        var options = {
                            packaged: false,
                            workerPath: null,
                            modePath: null,
                            themePath: null,
                            basePath: "",
                            suffix: ".js",
                            $moduleUrls: {},
                            loadWorkerFromBlob: true,
                            sharedPopups: false
                        };

                        exports.get = function (key) {
                            if (!options.hasOwnProperty(key))
                                throw new Error("Unknown config key: " + key);

                            return options[key];
                        };

                        exports.set = function (key, value) {
                            if (options.hasOwnProperty(key))
                                options[key] = value;
                            else if (this.setDefaultValue("", key, value) == false)
                                throw new Error("Unknown config key: " + key);
                        };

                        exports.all = function () {
                            return lang.copyObject(options);
                        };

                        exports.$modes = {};
                        exports.moduleUrl = function (name, component) {
                            if (options.$moduleUrls[name])
                                return options.$moduleUrls[name];

                            var parts = name.split("/");
                            component = component || parts[parts.length - 2] || "";
                            var sep = component == "snippets" ? "/" : "-";
                            var base = parts[parts.length - 1];
                            if (component == "worker" && sep == "-") {
                                var re = new RegExp("^" + component + "[\\-_]|[\\-_]" + component + "$", "g");
                                base = base.replace(re, "");
                            }

                            if ((!base || base == component) && parts.length > 1)
                                base = parts[parts.length - 2];
                            var path = options[component + "Path"];
                            if (path == null) {
                                path = options.basePath;
                            } else if (sep == "/") {
                                component = sep = "";
                            }
                            if (path && path.slice(-1) != "/")
                                path += "/";
                            return path + component + sep + base + this.get("suffix");
                        };

                        exports.setModuleUrl = function (name, subst) {
                            return options.$moduleUrls[name] = subst;
                        };

                        exports.$loading = {};
                        exports.loadModule = function (moduleName, onLoad) {
                            var module, moduleType;
                            if (Array.isArray(moduleName)) {
                                moduleType = moduleName[0];
                                moduleName = moduleName[1];
                            }

                            try {
                                module = require(moduleName);
                            } catch (e) {
                            }
                            if (module && !exports.$loading[moduleName])
                                return onLoad && onLoad(module);

                            if (!exports.$loading[moduleName])
                                exports.$loading[moduleName] = [];

                            exports.$loading[moduleName].push(onLoad);

                            if (exports.$loading[moduleName].length > 1)
                                return;

                            var afterLoad = function () {
                                require([moduleName], function (module) {
                                    exports._emit("load.module", {name: moduleName, module: module});
                                    var listeners = exports.$loading[moduleName];
                                    exports.$loading[moduleName] = null;
                                    listeners.forEach(function (onLoad) {
                                        onLoad && onLoad(module);
                                    });
                                });
                            };

                            if (!exports.get("packaged"))
                                return afterLoad();

                            net.loadScript(exports.moduleUrl(moduleName, moduleType), afterLoad);
                            reportErrorIfPathIsNotConfigured();
                        };

                        var reportErrorIfPathIsNotConfigured = function () {
                            if (
                                !options.basePath && !options.workerPath
                                && !options.modePath && !options.themePath
                                && !Object.keys(options.$moduleUrls).length
                            ) {
                                console.error(
                                    "Unable to infer path to ace from script src,",
                                    "use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes",
                                    "or with webpack use ace/webpack-resolver"
                                );
                                reportErrorIfPathIsNotConfigured = function () {
                                };
                            }
                        };
                        init(true);

                        function init(packaged) {

                            if (!global || !global.document)
                                return;

                            options.packaged = packaged || require.packaged || module.packaged || (global.define && __webpack_require__(23).packaged);

                            var scriptOptions = {};
                            var scriptUrl = "";
                            var currentScript = (document.currentScript || document._currentScript); // native or polyfill
                            var currentDocument = currentScript && currentScript.ownerDocument || document;

                            var scripts = currentDocument.getElementsByTagName("script");
                            for (var i = 0; i < scripts.length; i++) {
                                var script = scripts[i];

                                var src = script.src || script.getAttribute("src");
                                if (!src)
                                    continue;

                                var attributes = script.attributes;
                                for (var j = 0, l = attributes.length; j < l; j++) {
                                    var attr = attributes[j];
                                    if (attr.name.indexOf("data-ace-") === 0) {
                                        scriptOptions[deHyphenate(attr.name.replace(/^data-ace-/, ""))] = attr.value;
                                    }
                                }

                                var m = src.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);
                                if (m)
                                    scriptUrl = m[1];
                            }

                            if (scriptUrl) {
                                scriptOptions.base = scriptOptions.base || scriptUrl;
                                scriptOptions.packaged = true;
                            }

                            scriptOptions.basePath = scriptOptions.base;
                            scriptOptions.workerPath = scriptOptions.workerPath || scriptOptions.base;
                            scriptOptions.modePath = scriptOptions.modePath || scriptOptions.base;
                            scriptOptions.themePath = scriptOptions.themePath || scriptOptions.base;
                            delete scriptOptions.base;

                            for (var key in scriptOptions)
                                if (typeof scriptOptions[key] !== "undefined")
                                    exports.set(key, scriptOptions[key]);
                        }

                        exports.init = init;

                        function deHyphenate(str) {
                            return str.replace(/-(.)/g, function (m, m1) {
                                return m1.toUpperCase();
                            });
                        }

                        exports.version = "1.4.8";

                    });

                    ace.define("ace/mouse/mouse_handler", ["require", "exports", "module", "ace/lib/event", "ace/lib/useragent", "ace/mouse/default_handlers", "ace/mouse/default_gutter_handler", "ace/mouse/mouse_event", "ace/mouse/dragdrop_handler", "ace/mouse/touch_handler", "ace/config"], function (require, exports, module) {
                        "use strict";

                        var event = require("../lib/event");
                        var useragent = require("../lib/useragent");
                        var DefaultHandlers = require("./default_handlers").DefaultHandlers;
                        var DefaultGutterHandler = require("./default_gutter_handler").GutterHandler;
                        var MouseEvent = require("./mouse_event").MouseEvent;
                        var DragdropHandler = require("./dragdrop_handler").DragdropHandler;
                        var addTouchListeners = require("./touch_handler").addTouchListeners;
                        var config = require("../config");

                        var MouseHandler = function (editor) {
                            var _self = this;
                            this.editor = editor;

                            new DefaultHandlers(this);
                            new DefaultGutterHandler(this);
                            new DragdropHandler(this);

                            var focusEditor = function (e) {
                                var windowBlurred = !document.hasFocus || !document.hasFocus()
                                    || !editor.isFocused() && document.activeElement == (editor.textInput && editor.textInput.getElement());
                                if (windowBlurred)
                                    window.focus();
                                editor.focus();
                            };

                            var mouseTarget = editor.renderer.getMouseEventTarget();
                            event.addListener(mouseTarget, "click", this.onMouseEvent.bind(this, "click"));
                            event.addListener(mouseTarget, "mousemove", this.onMouseMove.bind(this, "mousemove"));
                            event.addMultiMouseDownListener([
                                mouseTarget,
                                editor.renderer.scrollBarV && editor.renderer.scrollBarV.inner,
                                editor.renderer.scrollBarH && editor.renderer.scrollBarH.inner,
                                editor.textInput && editor.textInput.getElement()
                            ].filter(Boolean), [400, 300, 250], this, "onMouseEvent");
                            event.addMouseWheelListener(editor.container, this.onMouseWheel.bind(this, "mousewheel"));
                            addTouchListeners(editor.container, editor);

                            var gutterEl = editor.renderer.$gutter;
                            event.addListener(gutterEl, "mousedown", this.onMouseEvent.bind(this, "guttermousedown"));
                            event.addListener(gutterEl, "click", this.onMouseEvent.bind(this, "gutterclick"));
                            event.addListener(gutterEl, "dblclick", this.onMouseEvent.bind(this, "gutterdblclick"));
                            event.addListener(gutterEl, "mousemove", this.onMouseEvent.bind(this, "guttermousemove"));

                            event.addListener(mouseTarget, "mousedown", focusEditor);
                            event.addListener(gutterEl, "mousedown", focusEditor);
                            if (useragent.isIE && editor.renderer.scrollBarV) {
                                event.addListener(editor.renderer.scrollBarV.element, "mousedown", focusEditor);
                                event.addListener(editor.renderer.scrollBarH.element, "mousedown", focusEditor);
                            }

                            editor.on("mousemove", function (e) {
                                if (_self.state || _self.$dragDelay || !_self.$dragEnabled)
                                    return;

                                var character = editor.renderer.screenToTextCoordinates(e.x, e.y);
                                var range = editor.session.selection.getRange();
                                var renderer = editor.renderer;

                                if (!range.isEmpty() && range.insideStart(character.row, character.column)) {
                                    renderer.setCursorStyle("default");
                                } else {
                                    renderer.setCursorStyle("");
                                }
                            });
                        };

                        (function () {
                            this.onMouseEvent = function (name, e) {
                                this.editor._emit(name, new MouseEvent(e, this.editor));
                            };

                            this.onMouseMove = function (name, e) {
                                var listeners = this.editor._eventRegistry && this.editor._eventRegistry.mousemove;
                                if (!listeners || !listeners.length)
                                    return;

                                this.editor._emit(name, new MouseEvent(e, this.editor));
                            };

                            this.onMouseWheel = function (name, e) {
                                var mouseEvent = new MouseEvent(e, this.editor);
                                mouseEvent.speed = this.$scrollSpeed * 2;
                                mouseEvent.wheelX = e.wheelX;
                                mouseEvent.wheelY = e.wheelY;

                                this.editor._emit(name, mouseEvent);
                            };

                            this.setState = function (state) {
                                this.state = state;
                            };

                            this.captureMouse = function (ev, mouseMoveHandler) {
                                this.x = ev.x;
                                this.y = ev.y;

                                this.isMousePressed = true;
                                var editor = this.editor;
                                var renderer = this.editor.renderer;
                                renderer.$isMousePressed = true;

                                var self = this;
                                var onMouseMove = function (e) {
                                    if (!e) return;
                                    if (useragent.isWebKit && !e.which && self.releaseMouse)
                                        return self.releaseMouse();

                                    self.x = e.clientX;
                                    self.y = e.clientY;
                                    mouseMoveHandler && mouseMoveHandler(e);
                                    self.mouseEvent = new MouseEvent(e, self.editor);
                                    self.$mouseMoved = true;
                                };

                                var onCaptureEnd = function (e) {
                                    editor.off("beforeEndOperation", onOperationEnd);
                                    clearInterval(timerId);
                                    onCaptureInterval();
                                    self[self.state + "End"] && self[self.state + "End"](e);
                                    self.state = "";
                                    self.isMousePressed = renderer.$isMousePressed = false;
                                    if (renderer.$keepTextAreaAtCursor)
                                        renderer.$moveTextAreaToCursor();
                                    self.$onCaptureMouseMove = self.releaseMouse = null;
                                    e && self.onMouseEvent("mouseup", e);
                                    editor.endOperation();
                                };

                                var onCaptureInterval = function () {
                                    self[self.state] && self[self.state]();
                                    self.$mouseMoved = false;
                                };

                                if (useragent.isOldIE && ev.domEvent.type == "dblclick") {
                                    return setTimeout(function () {
                                        onCaptureEnd(ev);
                                    });
                                }

                                var onOperationEnd = function (e) {
                                    if (!self.releaseMouse) return;
                                    if (editor.curOp.command.name && editor.curOp.selectionChanged) {
                                        self[self.state + "End"] && self[self.state + "End"]();
                                        self.state = "";
                                        self.releaseMouse();
                                    }
                                };

                                editor.on("beforeEndOperation", onOperationEnd);
                                editor.startOperation({command: {name: "mouse"}});

                                self.$onCaptureMouseMove = onMouseMove;
                                self.releaseMouse = event.capture(this.editor.container, onMouseMove, onCaptureEnd);
                                var timerId = setInterval(onCaptureInterval, 20);
                            };
                            this.releaseMouse = null;
                            this.cancelContextMenu = function () {
                                var stop = function (e) {
                                    if (e && e.domEvent && e.domEvent.type != "contextmenu")
                                        return;
                                    this.editor.off("nativecontextmenu", stop);
                                    if (e && e.domEvent)
                                        event.stopEvent(e.domEvent);
                                }.bind(this);
                                setTimeout(stop, 10);
                                this.editor.on("nativecontextmenu", stop);
                            };
                        }).call(MouseHandler.prototype);

                        config.defineOptions(MouseHandler.prototype, "mouseHandler", {
                            scrollSpeed: {initialValue: 2},
                            dragDelay: {initialValue: (useragent.isMac ? 150 : 0)},
                            dragEnabled: {initialValue: true},
                            focusTimeout: {initialValue: 0},
                            tooltipFollowsMouse: {initialValue: true}
                        });


                        exports.MouseHandler = MouseHandler;
                    });

                    ace.define("ace/mouse/fold_handler", ["require", "exports", "module", "ace/lib/dom"], function (require, exports, module) {
                        "use strict";
                        var dom = require("../lib/dom");

                        function FoldHandler(editor) {

                            editor.on("click", function (e) {
                                var position = e.getDocumentPosition();
                                var session = editor.session;
                                var fold = session.getFoldAt(position.row, position.column, 1);
                                if (fold) {
                                    if (e.getAccelKey())
                                        session.removeFold(fold);
                                    else
                                        session.expandFold(fold);

                                    e.stop();
                                }

                                var target = e.domEvent && e.domEvent.target;
                                if (target && dom.hasCssClass(target, "ace_inline_button")) {
                                    if (dom.hasCssClass(target, "ace_toggle_wrap")) {
                                        session.setOption("wrap", !session.getUseWrapMode());
                                        editor.renderer.scrollCursorIntoView();
                                    }
                                }
                            });

                            editor.on("gutterclick", function (e) {
                                var gutterRegion = editor.renderer.$gutterLayer.getRegion(e);

                                if (gutterRegion == "foldWidgets") {
                                    var row = e.getDocumentPosition().row;
                                    var session = editor.session;
                                    if (session.foldWidgets && session.foldWidgets[row])
                                        editor.session.onFoldWidgetClick(row, e);
                                    if (!editor.isFocused())
                                        editor.focus();
                                    e.stop();
                                }
                            });

                            editor.on("gutterdblclick", function (e) {
                                var gutterRegion = editor.renderer.$gutterLayer.getRegion(e);

                                if (gutterRegion == "foldWidgets") {
                                    var row = e.getDocumentPosition().row;
                                    var session = editor.session;
                                    var data = session.getParentFoldRangeData(row, true);
                                    var range = data.range || data.firstRange;

                                    if (range) {
                                        row = range.start.row;
                                        var fold = session.getFoldAt(row, session.getLine(row).length, 1);

                                        if (fold) {
                                            session.removeFold(fold);
                                        } else {
                                            session.addFold("...", range);
                                            editor.renderer.scrollCursorIntoView({row: range.start.row, column: 0});
                                        }
                                    }
                                    e.stop();
                                }
                            });
                        }

                        exports.FoldHandler = FoldHandler;

                    });

                    ace.define("ace/keyboard/keybinding", ["require", "exports", "module", "ace/lib/keys", "ace/lib/event"], function (require, exports, module) {
                        "use strict";

                        var keyUtil = require("../lib/keys");
                        var event = require("../lib/event");

                        var KeyBinding = function (editor) {
                            this.$editor = editor;
                            this.$data = {editor: editor};
                            this.$handlers = [];
                            this.setDefaultHandler(editor.commands);
                        };

                        (function () {
                            this.setDefaultHandler = function (kb) {
                                this.removeKeyboardHandler(this.$defaultHandler);
                                this.$defaultHandler = kb;
                                this.addKeyboardHandler(kb, 0);
                            };

                            this.setKeyboardHandler = function (kb) {
                                var h = this.$handlers;
                                if (h[h.length - 1] == kb)
                                    return;

                                while (h[h.length - 1] && h[h.length - 1] != this.$defaultHandler)
                                    this.removeKeyboardHandler(h[h.length - 1]);

                                this.addKeyboardHandler(kb, 1);
                            };

                            this.addKeyboardHandler = function (kb, pos) {
                                if (!kb)
                                    return;
                                if (typeof kb == "function" && !kb.handleKeyboard)
                                    kb.handleKeyboard = kb;
                                var i = this.$handlers.indexOf(kb);
                                if (i != -1)
                                    this.$handlers.splice(i, 1);

                                if (pos == undefined)
                                    this.$handlers.push(kb);
                                else
                                    this.$handlers.splice(pos, 0, kb);

                                if (i == -1 && kb.attach)
                                    kb.attach(this.$editor);
                            };

                            this.removeKeyboardHandler = function (kb) {
                                var i = this.$handlers.indexOf(kb);
                                if (i == -1)
                                    return false;
                                this.$handlers.splice(i, 1);
                                kb.detach && kb.detach(this.$editor);
                                return true;
                            };

                            this.getKeyboardHandler = function () {
                                return this.$handlers[this.$handlers.length - 1];
                            };

                            this.getStatusText = function () {
                                var data = this.$data;
                                var editor = data.editor;
                                return this.$handlers.map(function (h) {
                                    return h.getStatusText && h.getStatusText(editor, data) || "";
                                }).filter(Boolean).join(" ");
                            };

                            this.$callKeyboardHandlers = function (hashId, keyString, keyCode, e) {
                                var toExecute;
                                var success = false;
                                var commands = this.$editor.commands;

                                for (var i = this.$handlers.length; i--;) {
                                    toExecute = this.$handlers[i].handleKeyboard(
                                        this.$data, hashId, keyString, keyCode, e
                                    );
                                    if (!toExecute || !toExecute.command)
                                        continue;
                                    if (toExecute.command == "null") {
                                        success = true;
                                    } else {
                                        success = commands.exec(toExecute.command, this.$editor, toExecute.args, e);
                                    }
                                    if (success && e && hashId != -1 &&
                                        toExecute.passEvent != true && toExecute.command.passEvent != true
                                    ) {
                                        event.stopEvent(e);
                                    }
                                    if (success)
                                        break;
                                }

                                if (!success && hashId == -1) {
                                    toExecute = {command: "insertstring"};
                                    success = commands.exec("insertstring", this.$editor, keyString);
                                }

                                if (success && this.$editor._signal)
                                    this.$editor._signal("keyboardActivity", toExecute);

                                return success;
                            };

                            this.onCommandKey = function (e, hashId, keyCode) {
                                var keyString = keyUtil.keyCodeToString(keyCode);
                                return this.$callKeyboardHandlers(hashId, keyString, keyCode, e);
                            };

                            this.onTextInput = function (text) {
                                return this.$callKeyboardHandlers(-1, text);
                            };

                        }).call(KeyBinding.prototype);

                        exports.KeyBinding = KeyBinding;
                    });

                    ace.define("ace/lib/bidiutil", ["require", "exports", "module"], function (require, exports, module) {
                        "use strict";

                        var ArabicAlefBetIntervalsBegine = ['\u0621', '\u0641'];
                        var ArabicAlefBetIntervalsEnd = ['\u063A', '\u064a'];
                        var dir = 0, hiLevel = 0;
                        var lastArabic = false, hasUBAT_AL = false, hasUBAT_B = false, hasUBAT_S = false,
                            hasBlockSep = false, hasSegSep = false;

                        var impTab_LTR = [[0, 3, 0, 1, 0, 0, 0], [0, 3, 0, 1, 2, 2, 0], [0, 3, 0, 0x11, 2, 0, 1], [0, 3, 5, 5, 4, 1, 0], [0, 3, 0x15, 0x15, 4, 0, 1], [0, 3, 5, 5, 4, 2, 0]
                        ];

                        var impTab_RTL = [[2, 0, 1, 1, 0, 1, 0], [2, 0, 1, 1, 0, 2, 0], [2, 0, 2, 1, 3, 2, 0], [2, 0, 2, 0x21, 3, 1, 1]
                        ];

                        var LTR = 0, RTL = 1;

                        var L = 0;
                        var R = 1;
                        var EN = 2;
                        var AN = 3;
                        var ON = 4;
                        var B = 5;
                        var S = 6;
                        var AL = 7;
                        var WS = 8;
                        var CS = 9;
                        var ES = 10;
                        var ET = 11;
                        var NSM = 12;
                        var LRE = 13;
                        var RLE = 14;
                        var PDF = 15;
                        var LRO = 16;
                        var RLO = 17;
                        var BN = 18;

                        var UnicodeTBL00 = [
                            BN, BN, BN, BN, BN, BN, BN, BN, BN, S, B, S, WS, B, BN, BN,
                            BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, B, B, B, S,
                            WS, ON, ON, ET, ET, ET, ON, ON, ON, ON, ON, ES, CS, ES, CS, CS,
                            EN, EN, EN, EN, EN, EN, EN, EN, EN, EN, CS, ON, ON, ON, ON, ON,
                            ON, L, L, L, L, L, L, L, L, L, L, L, L, L, L, L,
                            L, L, L, L, L, L, L, L, L, L, L, ON, ON, ON, ON, ON,
                            ON, L, L, L, L, L, L, L, L, L, L, L, L, L, L, L,
                            L, L, L, L, L, L, L, L, L, L, L, ON, ON, ON, ON, BN,
                            BN, BN, BN, BN, BN, B, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
                            BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
                            CS, ON, ET, ET, ET, ET, ON, ON, ON, ON, L, ON, ON, BN, ON, ON,
                            ET, ET, EN, EN, ON, L, ON, ON, ON, EN, L, ON, ON, ON, ON, ON
                        ];

                        var UnicodeTBL20 = [
                            WS, WS, WS, WS, WS, WS, WS, WS, WS, WS, WS, BN, BN, BN, L, R,
                            ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
                            ON, ON, ON, ON, ON, ON, ON, ON, WS, B, LRE, RLE, PDF, LRO, RLO, CS,
                            ET, ET, ET, ET, ET, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
                            ON, ON, ON, ON, CS, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
                            ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, ON, WS
                        ];

                        function _computeLevels(chars, levels, len, charTypes) {
                            var impTab = dir ? impTab_RTL : impTab_LTR
                                , prevState = null, newClass = null, newLevel = null, newState = 0
                                , action = null, cond = null, condPos = -1, i = null, ix = null, classes = [];

                            if (!charTypes) {
                                for (i = 0, charTypes = []; i < len; i++) {
                                    charTypes[i] = _getCharacterType(chars[i]);
                                }
                            }
                            hiLevel = dir;
                            lastArabic = false;
                            hasUBAT_AL = false;
                            hasUBAT_B = false;
                            hasUBAT_S = false;
                            for (ix = 0; ix < len; ix++) {
                                prevState = newState;
                                classes[ix] = newClass = _getCharClass(chars, charTypes, classes, ix);
                                newState = impTab[prevState][newClass];
                                action = newState & 0xF0;
                                newState &= 0x0F;
                                levels[ix] = newLevel = impTab[newState][5];
                                if (action > 0) {
                                    if (action == 0x10) {
                                        for (i = condPos; i < ix; i++) {
                                            levels[i] = 1;
                                        }
                                        condPos = -1;
                                    } else {
                                        condPos = -1;
                                    }
                                }
                                cond = impTab[newState][6];
                                if (cond) {
                                    if (condPos == -1) {
                                        condPos = ix;
                                    }
                                } else {
                                    if (condPos > -1) {
                                        for (i = condPos; i < ix; i++) {
                                            levels[i] = newLevel;
                                        }
                                        condPos = -1;
                                    }
                                }
                                if (charTypes[ix] == B) {
                                    levels[ix] = 0;
                                }
                                hiLevel |= newLevel;
                            }
                            if (hasUBAT_S) {
                                for (i = 0; i < len; i++) {
                                    if (charTypes[i] == S) {
                                        levels[i] = dir;
                                        for (var j = i - 1; j >= 0; j--) {
                                            if (charTypes[j] == WS) {
                                                levels[j] = dir;
                                            } else {
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        function _invertLevel(lev, levels, _array) {
                            if (hiLevel < lev) {
                                return;
                            }
                            if (lev == 1 && dir == RTL && !hasUBAT_B) {
                                _array.reverse();
                                return;
                            }
                            var len = _array.length, start = 0, end, lo, hi, tmp;
                            while (start < len) {
                                if (levels[start] >= lev) {
                                    end = start + 1;
                                    while (end < len && levels[end] >= lev) {
                                        end++;
                                    }
                                    for (lo = start, hi = end - 1; lo < hi; lo++, hi--) {
                                        tmp = _array[lo];
                                        _array[lo] = _array[hi];
                                        _array[hi] = tmp;
                                    }
                                    start = end;
                                }
                                start++;
                            }
                        }

                        function _getCharClass(chars, types, classes, ix) {
                            var cType = types[ix], wType, nType, len, i;
                            switch (cType) {
                                case L:
                                case R:
                                    lastArabic = false;
                                case ON:
                                case AN:
                                    return cType;
                                case EN:
                                    return lastArabic ? AN : EN;
                                case AL:
                                    lastArabic = true;
                                    hasUBAT_AL = true;
                                    return R;
                                case WS:
                                    return ON;
                                case CS:
                                    if (ix < 1 || (ix + 1) >= types.length ||
                                        ((wType = classes[ix - 1]) != EN && wType != AN) ||
                                        ((nType = types[ix + 1]) != EN && nType != AN)) {
                                        return ON;
                                    }
                                    if (lastArabic) {
                                        nType = AN;
                                    }
                                    return nType == wType ? nType : ON;
                                case ES:
                                    wType = ix > 0 ? classes[ix - 1] : B;
                                    if (wType == EN && (ix + 1) < types.length && types[ix + 1] == EN) {
                                        return EN;
                                    }
                                    return ON;
                                case ET:
                                    if (ix > 0 && classes[ix - 1] == EN) {
                                        return EN;
                                    }
                                    if (lastArabic) {
                                        return ON;
                                    }
                                    i = ix + 1;
                                    len = types.length;
                                    while (i < len && types[i] == ET) {
                                        i++;
                                    }
                                    if (i < len && types[i] == EN) {
                                        return EN;
                                    }
                                    return ON;
                                case NSM:
                                    len = types.length;
                                    i = ix + 1;
                                    while (i < len && types[i] == NSM) {
                                        i++;
                                    }
                                    if (i < len) {
                                        var c = chars[ix], rtlCandidate = (c >= 0x0591 && c <= 0x08FF) || c == 0xFB1E;

                                        wType = types[i];
                                        if (rtlCandidate && (wType == R || wType == AL)) {
                                            return R;
                                        }
                                    }

                                    if (ix < 1 || (wType = types[ix - 1]) == B) {
                                        return ON;
                                    }
                                    return classes[ix - 1];
                                case B:
                                    lastArabic = false;
                                    hasUBAT_B = true;
                                    return dir;
                                case S:
                                    hasUBAT_S = true;
                                    return ON;
                                case LRE:
                                case RLE:
                                case LRO:
                                case RLO:
                                case PDF:
                                    lastArabic = false;
                                case BN:
                                    return ON;
                            }
                        }

                        function _getCharacterType(ch) {
                            var uc = ch.charCodeAt(0), hi = uc >> 8;

                            if (hi == 0) {
                                return ((uc > 0x00BF) ? L : UnicodeTBL00[uc]);
                            } else if (hi == 5) {
                                return (/[\u0591-\u05f4]/.test(ch) ? R : L);
                            } else if (hi == 6) {
                                if (/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(ch))
                                    return NSM;
                                else if (/[\u0660-\u0669\u066b-\u066c]/.test(ch))
                                    return AN;
                                else if (uc == 0x066A)
                                    return ET;
                                else if (/[\u06f0-\u06f9]/.test(ch))
                                    return EN;
                                else
                                    return AL;
                            } else if (hi == 0x20 && uc <= 0x205F) {
                                return UnicodeTBL20[uc & 0xFF];
                            } else if (hi == 0xFE) {
                                return (uc >= 0xFE70 ? AL : ON);
                            }
                            return ON;
                        }

                        function _isArabicDiacritics(ch) {
                            return (ch >= '\u064b' && ch <= '\u0655');
                        }

                        exports.L = L;
                        exports.R = R;
                        exports.EN = EN;
                        exports.ON_R = 3;
                        exports.AN = 4;
                        exports.R_H = 5;
                        exports.B = 6;
                        exports.RLE = 7;

                        exports.DOT = "\xB7";
                        exports.doBidiReorder = function (text, textCharTypes, isRtl) {
                            if (text.length < 2)
                                return {};

                            var chars = text.split(""), logicalFromVisual = new Array(chars.length),
                                bidiLevels = new Array(chars.length), levels = [];

                            dir = isRtl ? RTL : LTR;

                            _computeLevels(chars, levels, chars.length, textCharTypes);

                            for (var i = 0; i < logicalFromVisual.length; logicalFromVisual[i] = i, i++) ;

                            _invertLevel(2, levels, logicalFromVisual);
                            _invertLevel(1, levels, logicalFromVisual);

                            for (var i = 0; i < logicalFromVisual.length - 1; i++) { //fix levels to reflect character width
                                if (textCharTypes[i] === AN) {
                                    levels[i] = exports.AN;
                                } else if (levels[i] === R && ((textCharTypes[i] > AL && textCharTypes[i] < LRE)
                                    || textCharTypes[i] === ON || textCharTypes[i] === BN)) {
                                    levels[i] = exports.ON_R;
                                } else if ((i > 0 && chars[i - 1] === '\u0644') && /\u0622|\u0623|\u0625|\u0627/.test(chars[i])) {
                                    levels[i - 1] = levels[i] = exports.R_H;
                                    i++;
                                }
                            }
                            if (chars[chars.length - 1] === exports.DOT)
                                levels[chars.length - 1] = exports.B;

                            if (chars[0] === '\u202B')
                                levels[0] = exports.RLE;

                            for (var i = 0; i < logicalFromVisual.length; i++) {
                                bidiLevels[i] = levels[logicalFromVisual[i]];
                            }

                            return {'logicalFromVisual': logicalFromVisual, 'bidiLevels': bidiLevels};
                        };
                        exports.hasBidiCharacters = function (text, textCharTypes) {
                            var ret = false;
                            for (var i = 0; i < text.length; i++) {
                                textCharTypes[i] = _getCharacterType(text.charAt(i));
                                if (!ret && (textCharTypes[i] == R || textCharTypes[i] == AL || textCharTypes[i] == AN))
                                    ret = true;
                            }
                            return ret;
                        };
                        exports.getVisualFromLogicalIdx = function (logIdx, rowMap) {
                            for (var i = 0; i < rowMap.logicalFromVisual.length; i++) {
                                if (rowMap.logicalFromVisual[i] == logIdx)
                                    return i;
                            }
                            return 0;
                        };

                    });

                    ace.define("ace/bidihandler", ["require", "exports", "module", "ace/lib/bidiutil", "ace/lib/lang"], function (require, exports, module) {
                        "use strict";

                        var bidiUtil = require("./lib/bidiutil");
                        var lang = require("./lib/lang");
                        var bidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;
                        var BidiHandler = function (session) {
                            this.session = session;
                            this.bidiMap = {};
                            this.currentRow = null;
                            this.bidiUtil = bidiUtil;
                            this.charWidths = [];
                            this.EOL = "\xAC";
                            this.showInvisibles = true;
                            this.isRtlDir = false;
                            this.$isRtl = false;
                            this.line = "";
                            this.wrapIndent = 0;
                            this.EOF = "\xB6";
                            this.RLE = "\u202B";
                            this.contentWidth = 0;
                            this.fontMetrics = null;
                            this.rtlLineOffset = 0;
                            this.wrapOffset = 0;
                            this.isMoveLeftOperation = false;
                            this.seenBidi = bidiRE.test(session.getValue());
                        };

                        (function () {
                            this.isBidiRow = function (screenRow, docRow, splitIndex) {
                                if (!this.seenBidi)
                                    return false;
                                if (screenRow !== this.currentRow) {
                                    this.currentRow = screenRow;
                                    this.updateRowLine(docRow, splitIndex);
                                    this.updateBidiMap();
                                }
                                return this.bidiMap.bidiLevels;
                            };

                            this.onChange = function (delta) {
                                if (!this.seenBidi) {
                                    if (delta.action == "insert" && bidiRE.test(delta.lines.join("\n"))) {
                                        this.seenBidi = true;
                                        this.currentRow = null;
                                    }
                                } else {
                                    this.currentRow = null;
                                }
                            };

                            this.getDocumentRow = function () {
                                var docRow = 0;
                                var rowCache = this.session.$screenRowCache;
                                if (rowCache.length) {
                                    var index = this.session.$getRowCacheIndex(rowCache, this.currentRow);
                                    if (index >= 0)
                                        docRow = this.session.$docRowCache[index];
                                }

                                return docRow;
                            };

                            this.getSplitIndex = function () {
                                var splitIndex = 0;
                                var rowCache = this.session.$screenRowCache;
                                if (rowCache.length) {
                                    var currentIndex,
                                        prevIndex = this.session.$getRowCacheIndex(rowCache, this.currentRow);
                                    while (this.currentRow - splitIndex > 0) {
                                        currentIndex = this.session.$getRowCacheIndex(rowCache, this.currentRow - splitIndex - 1);
                                        if (currentIndex !== prevIndex)
                                            break;

                                        prevIndex = currentIndex;
                                        splitIndex++;
                                    }
                                } else {
                                    splitIndex = this.currentRow;
                                }

                                return splitIndex;
                            };

                            this.updateRowLine = function (docRow, splitIndex) {
                                if (docRow === undefined)
                                    docRow = this.getDocumentRow();

                                var isLastRow = (docRow === this.session.getLength() - 1),
                                    endOfLine = isLastRow ? this.EOF : this.EOL;

                                this.wrapIndent = 0;
                                this.line = this.session.getLine(docRow);
                                this.isRtlDir = this.$isRtl || this.line.charAt(0) === this.RLE;
                                if (this.session.$useWrapMode) {
                                    var splits = this.session.$wrapData[docRow];
                                    if (splits) {
                                        if (splitIndex === undefined)
                                            splitIndex = this.getSplitIndex();

                                        if (splitIndex > 0 && splits.length) {
                                            this.wrapIndent = splits.indent;
                                            this.wrapOffset = this.wrapIndent * this.charWidths[bidiUtil.L];
                                            this.line = (splitIndex < splits.length) ?
                                                this.line.substring(splits[splitIndex - 1], splits[splitIndex]) :
                                                this.line.substring(splits[splits.length - 1]);
                                        } else {
                                            this.line = this.line.substring(0, splits[splitIndex]);
                                        }
                                    }
                                    if (splitIndex == splits.length)
                                        this.line += (this.showInvisibles) ? endOfLine : bidiUtil.DOT;
                                } else {
                                    this.line += this.showInvisibles ? endOfLine : bidiUtil.DOT;
                                }
                                var session = this.session, shift = 0, size;
                                this.line = this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g, function (ch, i) {
                                    if (ch === '\t' || session.isFullWidth(ch.charCodeAt(0))) {
                                        size = (ch === '\t') ? session.getScreenTabSize(i + shift) : 2;
                                        shift += size - 1;
                                        return lang.stringRepeat(bidiUtil.DOT, size);
                                    }
                                    return ch;
                                });

                                if (this.isRtlDir) {
                                    this.fontMetrics.$main.textContent = (this.line.charAt(this.line.length - 1) == bidiUtil.DOT) ? this.line.substr(0, this.line.length - 1) : this.line;
                                    this.rtlLineOffset = this.contentWidth - this.fontMetrics.$main.getBoundingClientRect().width;
                                }
                            };

                            this.updateBidiMap = function () {
                                var textCharTypes = [];
                                if (bidiUtil.hasBidiCharacters(this.line, textCharTypes) || this.isRtlDir) {
                                    this.bidiMap = bidiUtil.doBidiReorder(this.line, textCharTypes, this.isRtlDir);
                                } else {
                                    this.bidiMap = {};
                                }
                            };
                            this.markAsDirty = function () {
                                this.currentRow = null;
                            };
                            this.updateCharacterWidths = function (fontMetrics) {
                                if (this.characterWidth === fontMetrics.$characterSize.width)
                                    return;

                                this.fontMetrics = fontMetrics;
                                var characterWidth = this.characterWidth = fontMetrics.$characterSize.width;
                                var bidiCharWidth = fontMetrics.$measureCharWidth("\u05d4");

                                this.charWidths[bidiUtil.L] = this.charWidths[bidiUtil.EN] = this.charWidths[bidiUtil.ON_R] = characterWidth;
                                this.charWidths[bidiUtil.R] = this.charWidths[bidiUtil.AN] = bidiCharWidth;
                                this.charWidths[bidiUtil.R_H] = bidiCharWidth * 0.45;
                                this.charWidths[bidiUtil.B] = this.charWidths[bidiUtil.RLE] = 0;

                                this.currentRow = null;
                            };

                            this.setShowInvisibles = function (showInvisibles) {
                                this.showInvisibles = showInvisibles;
                                this.currentRow = null;
                            };

                            this.setEolChar = function (eolChar) {
                                this.EOL = eolChar;
                            };

                            this.setContentWidth = function (width) {
                                this.contentWidth = width;
                            };

                            this.isRtlLine = function (row) {
                                if (this.$isRtl) return true;
                                if (row != undefined)
                                    return (this.session.getLine(row).charAt(0) == this.RLE);
                                else
                                    return this.isRtlDir;
                            };

                            this.setRtlDirection = function (editor, isRtlDir) {
                                var cursor = editor.getCursorPosition();
                                for (var row = editor.selection.getSelectionAnchor().row; row <= cursor.row; row++) {
                                    if (!isRtlDir && editor.session.getLine(row).charAt(0) === editor.session.$bidiHandler.RLE)
                                        editor.session.doc.removeInLine(row, 0, 1);
                                    else if (isRtlDir && editor.session.getLine(row).charAt(0) !== editor.session.$bidiHandler.RLE)
                                        editor.session.doc.insert({
                                            column: 0,
                                            row: row
                                        }, editor.session.$bidiHandler.RLE);
                                }
                            };
                            this.getPosLeft = function (col) {
                                col -= this.wrapIndent;
                                var leftBoundary = (this.line.charAt(0) === this.RLE) ? 1 : 0;
                                var logicalIdx = (col > leftBoundary) ? (this.session.getOverwrite() ? col : col - 1) : leftBoundary;
                                var visualIdx = bidiUtil.getVisualFromLogicalIdx(logicalIdx, this.bidiMap),
                                    levels = this.bidiMap.bidiLevels, left = 0;

                                if (!this.session.getOverwrite() && col <= leftBoundary && levels[visualIdx] % 2 !== 0)
                                    visualIdx++;

                                for (var i = 0; i < visualIdx; i++) {
                                    left += this.charWidths[levels[i]];
                                }

                                if (!this.session.getOverwrite() && (col > leftBoundary) && (levels[visualIdx] % 2 === 0))
                                    left += this.charWidths[levels[visualIdx]];

                                if (this.wrapIndent)
                                    left += this.isRtlDir ? (-1 * this.wrapOffset) : this.wrapOffset;

                                if (this.isRtlDir)
                                    left += this.rtlLineOffset;

                                return left;
                            };
                            this.getSelections = function (startCol, endCol) {
                                var map = this.bidiMap, levels = map.bidiLevels, level, selections = [], offset = 0,
                                    selColMin = Math.min(startCol, endCol) - this.wrapIndent,
                                    selColMax = Math.max(startCol, endCol) - this.wrapIndent,
                                    isSelected = false, isSelectedPrev = false, selectionStart = 0;

                                if (this.wrapIndent)
                                    offset += this.isRtlDir ? (-1 * this.wrapOffset) : this.wrapOffset;

                                for (var logIdx, visIdx = 0; visIdx < levels.length; visIdx++) {
                                    logIdx = map.logicalFromVisual[visIdx];
                                    level = levels[visIdx];
                                    isSelected = (logIdx >= selColMin) && (logIdx < selColMax);
                                    if (isSelected && !isSelectedPrev) {
                                        selectionStart = offset;
                                    } else if (!isSelected && isSelectedPrev) {
                                        selections.push({left: selectionStart, width: offset - selectionStart});
                                    }
                                    offset += this.charWidths[level];
                                    isSelectedPrev = isSelected;
                                }

                                if (isSelected && (visIdx === levels.length)) {
                                    selections.push({left: selectionStart, width: offset - selectionStart});
                                }

                                if (this.isRtlDir) {
                                    for (var i = 0; i < selections.length; i++) {
                                        selections[i].left += this.rtlLineOffset;
                                    }
                                }
                                return selections;
                            };
                            this.offsetToCol = function (posX) {
                                if (this.isRtlDir)
                                    posX -= this.rtlLineOffset;

                                var logicalIdx = 0, posX = Math.max(posX, 0),
                                    offset = 0, visualIdx = 0, levels = this.bidiMap.bidiLevels,
                                    charWidth = this.charWidths[levels[visualIdx]];

                                if (this.wrapIndent)
                                    posX -= this.isRtlDir ? (-1 * this.wrapOffset) : this.wrapOffset;

                                while (posX > offset + charWidth / 2) {
                                    offset += charWidth;
                                    if (visualIdx === levels.length - 1) {
                                        charWidth = 0;
                                        break;
                                    }
                                    charWidth = this.charWidths[levels[++visualIdx]];
                                }

                                if (visualIdx > 0 && (levels[visualIdx - 1] % 2 !== 0) && (levels[visualIdx] % 2 === 0)) {
                                    if (posX < offset)
                                        visualIdx--;
                                    logicalIdx = this.bidiMap.logicalFromVisual[visualIdx];

                                } else if (visualIdx > 0 && (levels[visualIdx - 1] % 2 === 0) && (levels[visualIdx] % 2 !== 0)) {
                                    logicalIdx = 1 + ((posX > offset) ? this.bidiMap.logicalFromVisual[visualIdx]
                                        : this.bidiMap.logicalFromVisual[visualIdx - 1]);

                                } else if ((this.isRtlDir && visualIdx === levels.length - 1 && charWidth === 0 && (levels[visualIdx - 1] % 2 === 0))
                                    || (!this.isRtlDir && visualIdx === 0 && (levels[visualIdx] % 2 !== 0))) {
                                    logicalIdx = 1 + this.bidiMap.logicalFromVisual[visualIdx];
                                } else {
                                    if (visualIdx > 0 && (levels[visualIdx - 1] % 2 !== 0) && charWidth !== 0)
                                        visualIdx--;
                                    logicalIdx = this.bidiMap.logicalFromVisual[visualIdx];
                                }

                                if (logicalIdx === 0 && this.isRtlDir)
                                    logicalIdx++;

                                return (logicalIdx + this.wrapIndent);
                            };

                        }).call(BidiHandler.prototype);

                        exports.BidiHandler = BidiHandler;
                    });

                    ace.define("ace/selection", ["require", "exports", "module", "ace/lib/oop", "ace/lib/lang", "ace/lib/event_emitter", "ace/range"], function (require, exports, module) {
                        "use strict";

                        var oop = require("./lib/oop");
                        var lang = require("./lib/lang");
                        var EventEmitter = require("./lib/event_emitter").EventEmitter;
                        var Range = require("./range").Range;
                        var Selection = function (session) {
                            this.session = session;
                            this.doc = session.getDocument();

                            this.clearSelection();
                            this.cursor = this.lead = this.doc.createAnchor(0, 0);
                            this.anchor = this.doc.createAnchor(0, 0);
                            this.$silent = false;

                            var self = this;
                            this.cursor.on("change", function (e) {
                                self.$cursorChanged = true;
                                if (!self.$silent)
                                    self._emit("changeCursor");
                                if (!self.$isEmpty && !self.$silent)
                                    self._emit("changeSelection");
                                if (!self.$keepDesiredColumnOnChange && e.old.column != e.value.column)
                                    self.$desiredColumn = null;
                            });

                            this.anchor.on("change", function () {
                                self.$anchorChanged = true;
                                if (!self.$isEmpty && !self.$silent)
                                    self._emit("changeSelection");
                            });
                        };

                        (function () {

                            oop.implement(this, EventEmitter);
                            this.isEmpty = function () {
                                return this.$isEmpty || (
                                    this.anchor.row == this.lead.row &&
                                    this.anchor.column == this.lead.column
                                );
                            };
                            this.isMultiLine = function () {
                                return !this.$isEmpty && this.anchor.row != this.cursor.row;
                            };
                            this.getCursor = function () {
                                return this.lead.getPosition();
                            };
                            this.setSelectionAnchor = function (row, column) {
                                this.$isEmpty = false;
                                this.anchor.setPosition(row, column);
                            };
                            this.getAnchor =
                                this.getSelectionAnchor = function () {
                                    if (this.$isEmpty)
                                        return this.getSelectionLead();

                                    return this.anchor.getPosition();
                                };
                            this.getSelectionLead = function () {
                                return this.lead.getPosition();
                            };
                            this.isBackwards = function () {
                                var anchor = this.anchor;
                                var lead = this.lead;
                                return (anchor.row > lead.row || (anchor.row == lead.row && anchor.column > lead.column));
                            };
                            this.getRange = function () {
                                var anchor = this.anchor;
                                var lead = this.lead;

                                if (this.$isEmpty)
                                    return Range.fromPoints(lead, lead);

                                return this.isBackwards()
                                    ? Range.fromPoints(lead, anchor)
                                    : Range.fromPoints(anchor, lead);
                            };
                            this.clearSelection = function () {
                                if (!this.$isEmpty) {
                                    this.$isEmpty = true;
                                    this._emit("changeSelection");
                                }
                            };
                            this.selectAll = function () {
                                this.$setSelection(0, 0, Number.MAX_VALUE, Number.MAX_VALUE);
                            };
                            this.setRange =
                                this.setSelectionRange = function (range, reverse) {
                                    var start = reverse ? range.end : range.start;
                                    var end = reverse ? range.start : range.end;
                                    this.$setSelection(start.row, start.column, end.row, end.column);
                                };

                            this.$setSelection = function (anchorRow, anchorColumn, cursorRow, cursorColumn) {
                                if (this.$silent)
                                    return;
                                var wasEmpty = this.$isEmpty;
                                var wasMultiselect = this.inMultiSelectMode;
                                this.$silent = true;
                                this.$cursorChanged = this.$anchorChanged = false;
                                this.anchor.setPosition(anchorRow, anchorColumn);
                                this.cursor.setPosition(cursorRow, cursorColumn);
                                this.$isEmpty = !Range.comparePoints(this.anchor, this.cursor);
                                this.$silent = false;
                                if (this.$cursorChanged)
                                    this._emit("changeCursor");
                                if (this.$cursorChanged || this.$anchorChanged || wasEmpty != this.$isEmpty || wasMultiselect)
                                    this._emit("changeSelection");
                            };

                            this.$moveSelection = function (mover) {
                                var lead = this.lead;
                                if (this.$isEmpty)
                                    this.setSelectionAnchor(lead.row, lead.column);

                                mover.call(this);
                            };
                            this.selectTo = function (row, column) {
                                this.$moveSelection(function () {
                                    this.moveCursorTo(row, column);
                                });
                            };
                            this.selectToPosition = function (pos) {
                                this.$moveSelection(function () {
                                    this.moveCursorToPosition(pos);
                                });
                            };
                            this.moveTo = function (row, column) {
                                this.clearSelection();
                                this.moveCursorTo(row, column);
                            };
                            this.moveToPosition = function (pos) {
                                this.clearSelection();
                                this.moveCursorToPosition(pos);
                            };
                            this.selectUp = function () {
                                this.$moveSelection(this.moveCursorUp);
                            };
                            this.selectDown = function () {
                                this.$moveSelection(this.moveCursorDown);
                            };
                            this.selectRight = function () {
                                this.$moveSelection(this.moveCursorRight);
                            };
                            this.selectLeft = function () {
                                this.$moveSelection(this.moveCursorLeft);
                            };
                            this.selectLineStart = function () {
                                this.$moveSelection(this.moveCursorLineStart);
                            };
                            this.selectLineEnd = function () {
                                this.$moveSelection(this.moveCursorLineEnd);
                            };
                            this.selectFileEnd = function () {
                                this.$moveSelection(this.moveCursorFileEnd);
                            };
                            this.selectFileStart = function () {
                                this.$moveSelection(this.moveCursorFileStart);
                            };
                            this.selectWordRight = function () {
                                this.$moveSelection(this.moveCursorWordRight);
                            };
                            this.selectWordLeft = function () {
                                this.$moveSelection(this.moveCursorWordLeft);
                            };
                            this.getWordRange = function (row, column) {
                                if (typeof column == "undefined") {
                                    var cursor = row || this.lead;
                                    row = cursor.row;
                                    column = cursor.column;
                                }
                                return this.session.getWordRange(row, column);
                            };
                            this.selectWord = function () {
                                this.setSelectionRange(this.getWordRange());
                            };
                            this.selectAWord = function () {
                                var cursor = this.getCursor();
                                var range = this.session.getAWordRange(cursor.row, cursor.column);
                                this.setSelectionRange(range);
                            };

                            this.getLineRange = function (row, excludeLastChar) {
                                var rowStart = typeof row == "number" ? row : this.lead.row;
                                var rowEnd;

                                var foldLine = this.session.getFoldLine(rowStart);
                                if (foldLine) {
                                    rowStart = foldLine.start.row;
                                    rowEnd = foldLine.end.row;
                                } else {
                                    rowEnd = rowStart;
                                }
                                if (excludeLastChar === true)
                                    return new Range(rowStart, 0, rowEnd, this.session.getLine(rowEnd).length);
                                else
                                    return new Range(rowStart, 0, rowEnd + 1, 0);
                            };
                            this.selectLine = function () {
                                this.setSelectionRange(this.getLineRange());
                            };
                            this.moveCursorUp = function () {
                                this.moveCursorBy(-1, 0);
                            };
                            this.moveCursorDown = function () {
                                this.moveCursorBy(1, 0);
                            };
                            this.wouldMoveIntoSoftTab = function (cursor, tabSize, direction) {
                                var start = cursor.column;
                                var end = cursor.column + tabSize;

                                if (direction < 0) {
                                    start = cursor.column - tabSize;
                                    end = cursor.column;
                                }
                                return this.session.isTabStop(cursor) && this.doc.getLine(cursor.row).slice(start, end).split(" ").length - 1 == tabSize;
                            };
                            this.moveCursorLeft = function () {
                                var cursor = this.lead.getPosition(),
                                    fold;

                                if (fold = this.session.getFoldAt(cursor.row, cursor.column, -1)) {
                                    this.moveCursorTo(fold.start.row, fold.start.column);
                                } else if (cursor.column === 0) {
                                    if (cursor.row > 0) {
                                        this.moveCursorTo(cursor.row - 1, this.doc.getLine(cursor.row - 1).length);
                                    }
                                } else {
                                    var tabSize = this.session.getTabSize();
                                    if (this.wouldMoveIntoSoftTab(cursor, tabSize, -1) && !this.session.getNavigateWithinSoftTabs()) {
                                        this.moveCursorBy(0, -tabSize);
                                    } else {
                                        this.moveCursorBy(0, -1);
                                    }
                                }
                            };
                            this.moveCursorRight = function () {
                                var cursor = this.lead.getPosition(),
                                    fold;
                                if (fold = this.session.getFoldAt(cursor.row, cursor.column, 1)) {
                                    this.moveCursorTo(fold.end.row, fold.end.column);
                                } else if (this.lead.column == this.doc.getLine(this.lead.row).length) {
                                    if (this.lead.row < this.doc.getLength() - 1) {
                                        this.moveCursorTo(this.lead.row + 1, 0);
                                    }
                                } else {
                                    var tabSize = this.session.getTabSize();
                                    var cursor = this.lead;
                                    if (this.wouldMoveIntoSoftTab(cursor, tabSize, 1) && !this.session.getNavigateWithinSoftTabs()) {
                                        this.moveCursorBy(0, tabSize);
                                    } else {
                                        this.moveCursorBy(0, 1);
                                    }
                                }
                            };
                            this.moveCursorLineStart = function () {
                                var row = this.lead.row;
                                var column = this.lead.column;
                                var screenRow = this.session.documentToScreenRow(row, column);
                                var firstColumnPosition = this.session.screenToDocumentPosition(screenRow, 0);
                                var beforeCursor = this.session.getDisplayLine(
                                    row, null, firstColumnPosition.row,
                                    firstColumnPosition.column
                                );

                                var leadingSpace = beforeCursor.match(/^\s*/);
                                if (leadingSpace[0].length != column && !this.session.$useEmacsStyleLineStart)
                                    firstColumnPosition.column += leadingSpace[0].length;
                                this.moveCursorToPosition(firstColumnPosition);
                            };
                            this.moveCursorLineEnd = function () {
                                var lead = this.lead;
                                var lineEnd = this.session.getDocumentLastRowColumnPosition(lead.row, lead.column);
                                if (this.lead.column == lineEnd.column) {
                                    var line = this.session.getLine(lineEnd.row);
                                    if (lineEnd.column == line.length) {
                                        var textEnd = line.search(/\s+$/);
                                        if (textEnd > 0)
                                            lineEnd.column = textEnd;
                                    }
                                }

                                this.moveCursorTo(lineEnd.row, lineEnd.column);
                            };
                            this.moveCursorFileEnd = function () {
                                var row = this.doc.getLength() - 1;
                                var column = this.doc.getLine(row).length;
                                this.moveCursorTo(row, column);
                            };
                            this.moveCursorFileStart = function () {
                                this.moveCursorTo(0, 0);
                            };
                            this.moveCursorLongWordRight = function () {
                                var row = this.lead.row;
                                var column = this.lead.column;
                                var line = this.doc.getLine(row);
                                var rightOfCursor = line.substring(column);

                                this.session.nonTokenRe.lastIndex = 0;
                                this.session.tokenRe.lastIndex = 0;
                                var fold = this.session.getFoldAt(row, column, 1);
                                if (fold) {
                                    this.moveCursorTo(fold.end.row, fold.end.column);
                                    return;
                                }
                                if (this.session.nonTokenRe.exec(rightOfCursor)) {
                                    column += this.session.nonTokenRe.lastIndex;
                                    this.session.nonTokenRe.lastIndex = 0;
                                    rightOfCursor = line.substring(column);
                                }
                                if (column >= line.length) {
                                    this.moveCursorTo(row, line.length);
                                    this.moveCursorRight();
                                    if (row < this.doc.getLength() - 1)
                                        this.moveCursorWordRight();
                                    return;
                                }
                                if (this.session.tokenRe.exec(rightOfCursor)) {
                                    column += this.session.tokenRe.lastIndex;
                                    this.session.tokenRe.lastIndex = 0;
                                }

                                this.moveCursorTo(row, column);
                            };
                            this.moveCursorLongWordLeft = function () {
                                var row = this.lead.row;
                                var column = this.lead.column;
                                var fold;
                                if (fold = this.session.getFoldAt(row, column, -1)) {
                                    this.moveCursorTo(fold.start.row, fold.start.column);
                                    return;
                                }

                                var str = this.session.getFoldStringAt(row, column, -1);
                                if (str == null) {
                                    str = this.doc.getLine(row).substring(0, column);
                                }

                                var leftOfCursor = lang.stringReverse(str);
                                this.session.nonTokenRe.lastIndex = 0;
                                this.session.tokenRe.lastIndex = 0;
                                if (this.session.nonTokenRe.exec(leftOfCursor)) {
                                    column -= this.session.nonTokenRe.lastIndex;
                                    leftOfCursor = leftOfCursor.slice(this.session.nonTokenRe.lastIndex);
                                    this.session.nonTokenRe.lastIndex = 0;
                                }
                                if (column <= 0) {
                                    this.moveCursorTo(row, 0);
                                    this.moveCursorLeft();
                                    if (row > 0)
                                        this.moveCursorWordLeft();
                                    return;
                                }
                                if (this.session.tokenRe.exec(leftOfCursor)) {
                                    column -= this.session.tokenRe.lastIndex;
                                    this.session.tokenRe.lastIndex = 0;
                                }

                                this.moveCursorTo(row, column);
                            };

                            this.$shortWordEndIndex = function (rightOfCursor) {
                                var index = 0, ch;
                                var whitespaceRe = /\s/;
                                var tokenRe = this.session.tokenRe;

                                tokenRe.lastIndex = 0;
                                if (this.session.tokenRe.exec(rightOfCursor)) {
                                    index = this.session.tokenRe.lastIndex;
                                } else {
                                    while ((ch = rightOfCursor[index]) && whitespaceRe.test(ch))
                                        index++;

                                    if (index < 1) {
                                        tokenRe.lastIndex = 0;
                                        while ((ch = rightOfCursor[index]) && !tokenRe.test(ch)) {
                                            tokenRe.lastIndex = 0;
                                            index++;
                                            if (whitespaceRe.test(ch)) {
                                                if (index > 2) {
                                                    index--;
                                                    break;
                                                } else {
                                                    while ((ch = rightOfCursor[index]) && whitespaceRe.test(ch))
                                                        index++;
                                                    if (index > 2)
                                                        break;
                                                }
                                            }
                                        }
                                    }
                                }
                                tokenRe.lastIndex = 0;

                                return index;
                            };

                            this.moveCursorShortWordRight = function () {
                                var row = this.lead.row;
                                var column = this.lead.column;
                                var line = this.doc.getLine(row);
                                var rightOfCursor = line.substring(column);

                                var fold = this.session.getFoldAt(row, column, 1);
                                if (fold)
                                    return this.moveCursorTo(fold.end.row, fold.end.column);

                                if (column == line.length) {
                                    var l = this.doc.getLength();
                                    do {
                                        row++;
                                        rightOfCursor = this.doc.getLine(row);
                                    } while (row < l && /^\s*$/.test(rightOfCursor));

                                    if (!/^\s+/.test(rightOfCursor))
                                        rightOfCursor = "";
                                    column = 0;
                                }

                                var index = this.$shortWordEndIndex(rightOfCursor);

                                this.moveCursorTo(row, column + index);
                            };

                            this.moveCursorShortWordLeft = function () {
                                var row = this.lead.row;
                                var column = this.lead.column;

                                var fold;
                                if (fold = this.session.getFoldAt(row, column, -1))
                                    return this.moveCursorTo(fold.start.row, fold.start.column);

                                var line = this.session.getLine(row).substring(0, column);
                                if (column === 0) {
                                    do {
                                        row--;
                                        line = this.doc.getLine(row);
                                    } while (row > 0 && /^\s*$/.test(line));

                                    column = line.length;
                                    if (!/\s+$/.test(line))
                                        line = "";
                                }

                                var leftOfCursor = lang.stringReverse(line);
                                var index = this.$shortWordEndIndex(leftOfCursor);

                                return this.moveCursorTo(row, column - index);
                            };

                            this.moveCursorWordRight = function () {
                                if (this.session.$selectLongWords)
                                    this.moveCursorLongWordRight();
                                else
                                    this.moveCursorShortWordRight();
                            };

                            this.moveCursorWordLeft = function () {
                                if (this.session.$selectLongWords)
                                    this.moveCursorLongWordLeft();
                                else
                                    this.moveCursorShortWordLeft();
                            };
                            this.moveCursorBy = function (rows, chars) {
                                var screenPos = this.session.documentToScreenPosition(
                                    this.lead.row,
                                    this.lead.column
                                );

                                var offsetX;

                                if (chars === 0) {
                                    if (rows !== 0) {
                                        if (this.session.$bidiHandler.isBidiRow(screenPos.row, this.lead.row)) {
                                            offsetX = this.session.$bidiHandler.getPosLeft(screenPos.column);
                                            screenPos.column = Math.round(offsetX / this.session.$bidiHandler.charWidths[0]);
                                        } else {
                                            offsetX = screenPos.column * this.session.$bidiHandler.charWidths[0];
                                        }
                                    }

                                    if (this.$desiredColumn)
                                        screenPos.column = this.$desiredColumn;
                                    else
                                        this.$desiredColumn = screenPos.column;
                                }

                                if (rows != 0 && this.session.lineWidgets && this.session.lineWidgets[this.lead.row]) {
                                    var widget = this.session.lineWidgets[this.lead.row];
                                    if (rows < 0)
                                        rows -= widget.rowsAbove || 0;
                                    else if (rows > 0)
                                        rows += widget.rowCount - (widget.rowsAbove || 0);
                                }

                                var docPos = this.session.screenToDocumentPosition(screenPos.row + rows, screenPos.column, offsetX);

                                if (rows !== 0 && chars === 0 && docPos.row === this.lead.row && docPos.column === this.lead.column) {

                                }
                                this.moveCursorTo(docPos.row, docPos.column + chars, chars === 0);
                            };
                            this.moveCursorToPosition = function (position) {
                                this.moveCursorTo(position.row, position.column);
                            };
                            this.moveCursorTo = function (row, column, keepDesiredColumn) {
                                var fold = this.session.getFoldAt(row, column, 1);
                                if (fold) {
                                    row = fold.start.row;
                                    column = fold.start.column;
                                }

                                this.$keepDesiredColumnOnChange = true;
                                var line = this.session.getLine(row);
                                if (/[\uDC00-\uDFFF]/.test(line.charAt(column)) && line.charAt(column - 1)) {
                                    if (this.lead.row == row && this.lead.column == column + 1)
                                        column = column - 1;
                                    else
                                        column = column + 1;
                                }
                                this.lead.setPosition(row, column);
                                this.$keepDesiredColumnOnChange = false;

                                if (!keepDesiredColumn)
                                    this.$desiredColumn = null;
                            };
                            this.moveCursorToScreen = function (row, column, keepDesiredColumn) {
                                var pos = this.session.screenToDocumentPosition(row, column);
                                this.moveCursorTo(pos.row, pos.column, keepDesiredColumn);
                            };
                            this.detach = function () {
                                this.lead.detach();
                                this.anchor.detach();
                                this.session = this.doc = null;
                            };

                            this.fromOrientedRange = function (range) {
                                this.setSelectionRange(range, range.cursor == range.start);
                                this.$desiredColumn = range.desiredColumn || this.$desiredColumn;
                            };

                            this.toOrientedRange = function (range) {
                                var r = this.getRange();
                                if (range) {
                                    range.start.column = r.start.column;
                                    range.start.row = r.start.row;
                                    range.end.column = r.end.column;
                                    range.end.row = r.end.row;
                                } else {
                                    range = r;
                                }

                                range.cursor = this.isBackwards() ? range.start : range.end;
                                range.desiredColumn = this.$desiredColumn;
                                return range;
                            };
                            this.getRangeOfMovements = function (func) {
                                var start = this.getCursor();
                                try {
                                    func(this);
                                    var end = this.getCursor();
                                    return Range.fromPoints(start, end);
                                } catch (e) {
                                    return Range.fromPoints(start, start);
                                } finally {
                                    this.moveCursorToPosition(start);
                                }
                            };

                            this.toJSON = function () {
                                if (this.rangeCount) {
                                    var data = this.ranges.map(function (r) {
                                        var r1 = r.clone();
                                        r1.isBackwards = r.cursor == r.start;
                                        return r1;
                                    });
                                } else {
                                    var data = this.getRange();
                                    data.isBackwards = this.isBackwards();
                                }
                                return data;
                            };

                            this.fromJSON = function (data) {
                                if (data.start == undefined) {
                                    if (this.rangeList && data.length > 1) {
                                        this.toSingleRange(data[0]);
                                        for (var i = data.length; i--;) {
                                            var r = Range.fromPoints(data[i].start, data[i].end);
                                            if (data[i].isBackwards)
                                                r.cursor = r.start;
                                            this.addRange(r, true);
                                        }
                                        return;
                                    } else {
                                        data = data[0];
                                    }
                                }
                                if (this.rangeList)
                                    this.toSingleRange(data);
                                this.setSelectionRange(data, data.isBackwards);
                            };

                            this.isEqual = function (data) {
                                if ((data.length || this.rangeCount) && data.length != this.rangeCount)
                                    return false;
                                if (!data.length || !this.ranges)
                                    return this.getRange().isEqual(data);

                                for (var i = this.ranges.length; i--;) {
                                    if (!this.ranges[i].isEqual(data[i]))
                                        return false;
                                }
                                return true;
                            };

                        }).call(Selection.prototype);

                        exports.Selection = Selection;
                    });

                    ace.define("ace/tokenizer", ["require", "exports", "module", "ace/config"], function (require, exports, module) {
                        "use strict";

                        var config = require("./config");
                        var MAX_TOKEN_COUNT = 2000;
                        var Tokenizer = function (rules) {
                            this.states = rules;

                            this.regExps = {};
                            this.matchMappings = {};
                            for (var key in this.states) {
                                var state = this.states[key];
                                var ruleRegExps = [];
                                var matchTotal = 0;
                                var mapping = this.matchMappings[key] = {defaultToken: "text"};
                                var flag = "g";

                                var splitterRurles = [];
                                for (var i = 0; i < state.length; i++) {
                                    var rule = state[i];
                                    if (rule.defaultToken)
                                        mapping.defaultToken = rule.defaultToken;
                                    if (rule.caseInsensitive)
                                        flag = "gi";
                                    if (rule.regex == null)
                                        continue;

                                    if (rule.regex instanceof RegExp)
                                        rule.regex = rule.regex.toString().slice(1, -1);
                                    var adjustedregex = rule.regex;
                                    var matchcount = new RegExp("(?:(" + adjustedregex + ")|(.))").exec("a").length - 2;
                                    if (Array.isArray(rule.token)) {
                                        if (rule.token.length == 1 || matchcount == 1) {
                                            rule.token = rule.token[0];
                                        } else if (matchcount - 1 != rule.token.length) {
                                            this.reportError("number of classes and regexp groups doesn't match", {
                                                rule: rule,
                                                groupCount: matchcount - 1
                                            });
                                            rule.token = rule.token[0];
                                        } else {
                                            rule.tokenArray = rule.token;
                                            rule.token = null;
                                            rule.onMatch = this.$arrayTokens;
                                        }
                                    } else if (typeof rule.token == "function" && !rule.onMatch) {
                                        if (matchcount > 1)
                                            rule.onMatch = this.$applyToken;
                                        else
                                            rule.onMatch = rule.token;
                                    }

                                    if (matchcount > 1) {
                                        if (/\\\d/.test(rule.regex)) {
                                            adjustedregex = rule.regex.replace(/\\([0-9]+)/g, function (match, digit) {
                                                return "\\" + (parseInt(digit, 10) + matchTotal + 1);
                                            });
                                        } else {
                                            matchcount = 1;
                                            adjustedregex = this.removeCapturingGroups(rule.regex);
                                        }
                                        if (!rule.splitRegex && typeof rule.token != "string")
                                            splitterRurles.push(rule); // flag will be known only at the very end
                                    }

                                    mapping[matchTotal] = i;
                                    matchTotal += matchcount;

                                    ruleRegExps.push(adjustedregex);
                                    if (!rule.onMatch)
                                        rule.onMatch = null;
                                }

                                if (!ruleRegExps.length) {
                                    mapping[0] = 0;
                                    ruleRegExps.push("$");
                                }

                                splitterRurles.forEach(function (rule) {
                                    rule.splitRegex = this.createSplitterRegexp(rule.regex, flag);
                                }, this);

                                this.regExps[key] = new RegExp("(" + ruleRegExps.join(")|(") + ")|($)", flag);
                            }
                        };

                        (function () {
                            this.$setMaxTokenCount = function (m) {
                                MAX_TOKEN_COUNT = m | 0;
                            };

                            this.$applyToken = function (str) {
                                var values = this.splitRegex.exec(str).slice(1);
                                var types = this.token.apply(this, values);
                                if (typeof types === "string")
                                    return [{type: types, value: str}];

                                var tokens = [];
                                for (var i = 0, l = types.length; i < l; i++) {
                                    if (values[i])
                                        tokens[tokens.length] = {
                                            type: types[i],
                                            value: values[i]
                                        };
                                }
                                return tokens;
                            };

                            this.$arrayTokens = function (str) {
                                if (!str)
                                    return [];
                                var values = this.splitRegex.exec(str);
                                if (!values)
                                    return "text";
                                var tokens = [];
                                var types = this.tokenArray;
                                for (var i = 0, l = types.length; i < l; i++) {
                                    if (values[i + 1])
                                        tokens[tokens.length] = {
                                            type: types[i],
                                            value: values[i + 1]
                                        };
                                }
                                return tokens;
                            };

                            this.removeCapturingGroups = function (src) {
                                var r = src.replace(
                                    /\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!]|(\()/g,
                                    function (x, y) {
                                        return y ? "(?:" : x;
                                    }
                                );
                                return r;
                            };

                            this.createSplitterRegexp = function (src, flag) {
                                if (src.indexOf("(?=") != -1) {
                                    var stack = 0;
                                    var inChClass = false;
                                    var lastCapture = {};
                                    src.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g, function (
                                        m, esc, parenOpen, parenClose, square, index
                                    ) {
                                        if (inChClass) {
                                            inChClass = square != "]";
                                        } else if (square) {
                                            inChClass = true;
                                        } else if (parenClose) {
                                            if (stack == lastCapture.stack) {
                                                lastCapture.end = index + 1;
                                                lastCapture.stack = -1;
                                            }
                                            stack--;
                                        } else if (parenOpen) {
                                            stack++;
                                            if (parenOpen.length != 1) {
                                                lastCapture.stack = stack;
                                                lastCapture.start = index;
                                            }
                                        }
                                        return m;
                                    });

                                    if (lastCapture.end != null && /^\)*$/.test(src.substr(lastCapture.end)))
                                        src = src.substring(0, lastCapture.start) + src.substr(lastCapture.end);
                                }
                                if (src.charAt(0) != "^") src = "^" + src;
                                if (src.charAt(src.length - 1) != "$") src += "$";

                                return new RegExp(src, (flag || "").replace("g", ""));
                            };
                            this.getLineTokens = function (line, startState) {
                                if (startState && typeof startState != "string") {
                                    var stack = startState.slice(0);
                                    startState = stack[0];
                                    if (startState === "#tmp") {
                                        stack.shift();
                                        startState = stack.shift();
                                    }
                                } else
                                    var stack = [];

                                var currentState = startState || "start";
                                var state = this.states[currentState];
                                if (!state) {
                                    currentState = "start";
                                    state = this.states[currentState];
                                }
                                var mapping = this.matchMappings[currentState];
                                var re = this.regExps[currentState];
                                re.lastIndex = 0;

                                var match, tokens = [];
                                var lastIndex = 0;
                                var matchAttempts = 0;

                                var token = {type: null, value: ""};

                                while (match = re.exec(line)) {
                                    var type = mapping.defaultToken;
                                    var rule = null;
                                    var value = match[0];
                                    var index = re.lastIndex;

                                    if (index - value.length > lastIndex) {
                                        var skipped = line.substring(lastIndex, index - value.length);
                                        if (token.type == type) {
                                            token.value += skipped;
                                        } else {
                                            if (token.type)
                                                tokens.push(token);
                                            token = {type: type, value: skipped};
                                        }
                                    }

                                    for (var i = 0; i < match.length - 2; i++) {
                                        if (match[i + 1] === undefined)
                                            continue;

                                        rule = state[mapping[i]];

                                        if (rule.onMatch)
                                            type = rule.onMatch(value, currentState, stack, line);
                                        else
                                            type = rule.token;

                                        if (rule.next) {
                                            if (typeof rule.next == "string") {
                                                currentState = rule.next;
                                            } else {
                                                currentState = rule.next(currentState, stack);
                                            }

                                            state = this.states[currentState];
                                            if (!state) {
                                                this.reportError("state doesn't exist", currentState);
                                                currentState = "start";
                                                state = this.states[currentState];
                                            }
                                            mapping = this.matchMappings[currentState];
                                            lastIndex = index;
                                            re = this.regExps[currentState];
                                            re.lastIndex = index;
                                        }
                                        if (rule.consumeLineEnd)
                                            lastIndex = index;
                                        break;
                                    }

                                    if (value) {
                                        if (typeof type === "string") {
                                            if ((!rule || rule.merge !== false) && token.type === type) {
                                                token.value += value;
                                            } else {
                                                if (token.type)
                                                    token