/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import jep.JepException;
import jep.LibraryLocator;
import jep.PyConfig;

public final class MainInterpreter
implements AutoCloseable {
    private static MainInterpreter instance = null;
    private static PyConfig pyConfig = null;
    private static String[] sharedModulesArgv = null;
    private static String jepLibraryPath = null;
    private Thread thread;
    private BlockingQueue<String> importQueue = new SynchronousQueue<String>();
    private BlockingQueue<Object> importResults = new SynchronousQueue<Object>();
    private Throwable error;

    private MainInterpreter() {
    }

    protected static synchronized MainInterpreter getMainInterpreter() throws Error {
        if (null == instance) {
            try {
                instance = new MainInterpreter();
                instance.initialize();
            }
            catch (Error error) {
                instance.close();
                MainInterpreter.instance.error = error;
                throw error;
            }
        } else if (null != MainInterpreter.instance.error) {
            throw new Error("The main Python interpreter previously failed to initialize.", MainInterpreter.instance.error);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws Error {
        block12: {
            if (jepLibraryPath != null) {
                System.load(jepLibraryPath);
            } else {
                try {
                    System.loadLibrary("jep");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (LibraryLocator.findJepLibrary(pyConfig)) break block12;
                    throw unsatisfiedLinkError;
                }
            }
        }
        if (pyConfig == null) {
            pyConfig = PyConfig.python();
        }
        if (sharedModulesArgv != null) {
            pyConfig.setArgv(sharedModulesArgv);
            pyConfig.setParseArgv(false);
        }
        this.thread = new Thread("JepMainInterpreter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                try {
                    MainInterpreter.initializePython(pyConfig.isolated, pyConfig.argv, pyConfig.hashSeed, pyConfig.useHashSeed, pyConfig.home, pyConfig.optimizationLevel, pyConfig.parseArgv, pyConfig.programName, pyConfig.siteImport, pyConfig.useEnvironment, pyConfig.userSiteDirectory, pyConfig.verbose, pyConfig.writeBytecode);
                }
                catch (Throwable throwable) {
                    MainInterpreter.this.error = throwable;
                }
                finally {
                    object = MainInterpreter.this;
                    synchronized (object) {
                        MainInterpreter.this.notify();
                    }
                }
                try {
                    while (true) {
                        Object object2 = object = (String)MainInterpreter.this.importQueue.take();
                        try {
                            MainInterpreter.sharedImportInternal((String)object);
                        }
                        catch (JepException jepException) {
                            object2 = jepException;
                        }
                        MainInterpreter.this.importResults.put(object2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        this.thread.setDaemon(true);
        MainInterpreter mainInterpreter = this;
        synchronized (mainInterpreter) {
            block13: {
                this.thread.start();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (this.error == null) break block13;
                    this.error = interruptedException;
                }
            }
        }
        if (this.error != null) {
            throw new Error(this.error);
        }
    }

    public void sharedImport(String string) throws JepException {
        try {
            this.importQueue.put(string);
            Object object = this.importResults.take();
            if (object instanceof JepException) {
                throw new JepException("Error importing shared module " + string, (JepException)object);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new JepException(interruptedException);
        }
    }

    @Override
    public void close() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public static void setInitParams(PyConfig pyConfig) throws IllegalStateException {
        if (null != instance) {
            throw new IllegalStateException("Jep.setInitParams(PyConfig) called after initializing python interpreter.");
        }
        MainInterpreter.pyConfig = pyConfig;
    }

    @Deprecated
    public static void setSharedModulesArgv(String ... stringArray) throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("Jep.setSharedModulesArgv(...) called after initializing python interpreter.");
        }
        sharedModulesArgv = stringArray;
    }

    public static void setJepLibraryPath(String string) throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("Jep.setJepLibraryPath(...) called after initializing python interpreter.");
        }
        jepLibraryPath = string;
    }

    private static native void initializePython(boolean var0, String[] var1, int var2, int var3, String var4, int var5, int var6, String var7, int var8, int var9, int var10, int var11, int var12);

    private static native void sharedImportInternal(String var0) throws JepException;
}

