/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington;

public class SubSequence
implements CharSequence {
    private final CharSequence seq;
    private final int offset;
    private final int length;

    public SubSequence(CharSequence seq, int offset) {
        this(seq, offset, seq.length() - offset);
    }

    private static void outOfBounds(String message) {
        throw new IndexOutOfBoundsException(message);
    }

    public SubSequence(CharSequence seq, int offset, int length) {
        if (offset < 0) {
            SubSequence.outOfBounds("Offset " + offset + " < 0");
        }
        if (offset > seq.length()) {
            SubSequence.outOfBounds("Offset " + offset + " > " + seq.length());
        }
        if (length < 0) {
            SubSequence.outOfBounds("Length " + length + " < 0");
        }
        if (offset + length > seq.length()) {
            SubSequence.outOfBounds("Offset " + offset + " + length " + length + " > " + seq.length());
        }
        this.seq = seq;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.seq.charAt(this.offset + index);
    }

    @Override
    public SubSequence subSequence(int start, int end) {
        return new SubSequence(this.seq, this.offset + start, end - start);
    }

    @Override
    public String toString() {
        return this.seq.subSequence(this.offset, this.offset + this.length).toString();
    }
}

