/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.io.IOException;
import net.algart.matrices.tiff.TiffWriter;

public enum TiffCreateMode {
    NO_ACTIONS(false, false, false){

        @Override
        public void configureWriter(TiffWriter writer) {
        }
    }
    ,
    CREATE(true, false, false),
    CREATE_BIG(true, true, false),
    CREATE_LE(true, false, true),
    CREATE_LE_BIG(true, true, true),
    APPEND(false, false, false),
    APPEND_BIG(false, true, false),
    APPEND_LE(false, false, true),
    APPEND_LE_BIG(false, true, true),
    OPEN_EXISTING(false, false, false){

        @Override
        boolean createIfNotExist() {
            return false;
        }
    };

    private final boolean forceCreateNewFile;
    private final boolean bigTiff;
    private final boolean littleEndian;

    private TiffCreateMode(boolean forceCreateNewFile, boolean bigTiff, boolean littleEndian) {
        this.forceCreateNewFile = forceCreateNewFile;
        this.bigTiff = bigTiff;
        this.littleEndian = littleEndian;
    }

    public boolean isForceCreateNewFile() {
        return this.forceCreateNewFile;
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public static TiffCreateMode ofCreateOptions(boolean bigTiff, boolean littleEndian) {
        return bigTiff ? (littleEndian ? CREATE_LE_BIG : CREATE_BIG) : (littleEndian ? CREATE_LE : CREATE);
    }

    public static TiffCreateMode ofAppendOptions(boolean bigTiff, boolean littleEndian) {
        return bigTiff ? (littleEndian ? APPEND_LE_BIG : APPEND_BIG) : (littleEndian ? APPEND_LE : APPEND);
    }

    void configureWriter(TiffWriter writer) throws IOException {
        if (this.bigTiff) {
            writer.setBigTiff(true);
        }
        if (this.littleEndian) {
            writer.setLittleEndian(true);
        }
        if (this.forceCreateNewFile) {
            writer.create();
        } else {
            writer.open(this.createIfNotExist());
        }
    }

    boolean createIfNotExist() {
        return true;
    }
}

