/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.app;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatablePArray;
import net.algart.io.MatrixIO;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.tiles.TiffReadMap;

public class ConvertFromTiff {
    public static void main(String[] args) throws IOException {
        ConvertFromTiff.doMain(args, true);
    }

    static boolean doMain(String[] args, boolean printUsage) throws IOException {
        List<Matrix<UpdatablePArray>> image;
        if (args.length < 3) {
            if (printUsage) {
                System.out.println("Usage:");
                System.out.printf("    %s source.tiff target.jpg/png/bmp IFDIndex%n", ConvertFromTiff.class.getName());
            }
            return false;
        }
        Path sourceFile = Paths.get(args[0], new String[0]);
        Path targetFile = Paths.get(args[1], new String[0]);
        int ifdIndex = Integer.parseInt(args[2]);
        System.out.printf("Reading TIFF %s...%n", sourceFile);
        long t1 = System.nanoTime();
        try (TiffReader reader = new TiffReader(sourceFile);){
            TiffReadMap map = reader.map(ifdIndex);
            image = map.readChannels();
        }
        long t2 = System.nanoTime();
        System.out.printf("Writing %s...%n", targetFile);
        MatrixIO.writeImage((Path)targetFile, image);
        long t3 = System.nanoTime();
        System.out.printf(Locale.US, "Conversion from TIFF finished: %.3f seconds reading TIFF, %.3f seconds writing.%n", (double)(t2 - t1) * 1.0E-9, (double)(t3 - t2) * 1.0E-9);
        return true;
    }
}

