/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffOpenMode;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.pyramids.TiffPyramidMetadata;

public class TiffInfo {
    private TiffIFD.StringFormat stringFormat = TiffIFD.StringFormat.NORMAL;
    private int firstIFDIndex = 0;
    private int lastIFDIndex = Integer.MAX_VALUE;
    private boolean disableAppendingForStrictFormats = false;
    private final List<String> ifdInfo = new ArrayList<String>();
    private TiffPyramidMetadata metadata;
    private boolean tiff;
    private String prefixInfo;
    private String summaryInfo;
    private String svsInfo;

    public static void main(String[] args) {
        TiffInfo info = new TiffInfo();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-detailed")) {
            info.stringFormat = TiffIFD.StringFormat.DETAILED;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-json")) {
            info.stringFormat = TiffIFD.StringFormat.JSON;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.println("Usage:");
            System.out.println("    " + TiffInfo.class.getSimpleName() + " [-strict] [-detailed|-json] some_tiff_file.tiff [firstIFDIndex lastIFDIndex]");
            return;
        }
        String fileName = args[startArgIndex];
        if (args.length > startArgIndex + 1) {
            info.firstIFDIndex = Integer.parseInt(args[startArgIndex + 1]);
        }
        if (args.length > startArgIndex + 2) {
            info.lastIFDIndex = Integer.parseInt(args[startArgIndex + 2]);
        }
        if (fileName.equals(".")) {
            Object[] files = new File(".").listFiles(TiffInfo::isPossiblyTIFF);
            assert (files != null);
            Arrays.sort(files);
            System.out.printf("Testing %d files%n", files.length);
            for (Object f : files) {
                info.showTiffInfoAndPrintException(((File)f).toPath());
            }
        } else {
            info.showTiffInfoAndPrintException(Paths.get(fileName, new String[0]));
        }
    }

    public TiffIFD.StringFormat getStringFormat() {
        return this.stringFormat;
    }

    public TiffInfo setStringFormat(TiffIFD.StringFormat stringFormat) {
        this.stringFormat = stringFormat;
        return this;
    }

    public int getFirstIFDIndex() {
        return this.firstIFDIndex;
    }

    public TiffInfo setFirstIFDIndex(int firstIFDIndex) {
        this.firstIFDIndex = firstIFDIndex;
        return this;
    }

    public int getLastIFDIndex() {
        return this.lastIFDIndex;
    }

    public TiffInfo setLastIFDIndex(int lastIFDIndex) {
        this.lastIFDIndex = lastIFDIndex;
        return this;
    }

    public boolean isDisableAppendingForStrictFormats() {
        return this.disableAppendingForStrictFormats;
    }

    public TiffInfo setDisableAppendingForStrictFormats(boolean disableAppendingForStrictFormats) {
        this.disableAppendingForStrictFormats = disableAppendingForStrictFormats;
        return this;
    }

    public boolean isTiff() {
        return this.tiff;
    }

    public TiffPyramidMetadata metadata() {
        return this.metadata;
    }

    public int numberOfImages() {
        return this.ifdInfo.size();
    }

    public String ifdInformation(int ifdIndex) {
        return this.ifdInfo.get(ifdIndex);
    }

    public String prefixInfo() {
        return this.prefixInfo;
    }

    public String summaryInfo() {
        return this.summaryInfo;
    }

    public String svsInfo() {
        return this.svsInfo;
    }

    public void collectTiffInfo(Path tiffFile) throws IOException {
        block12: {
            this.ifdInfo.clear();
            this.prefixInfo = "";
            this.summaryInfo = "";
            this.svsInfo = "";
            try (TiffReader reader = new TiffReader(tiffFile, TiffOpenMode.ALLOW_NON_TIFF);){
                List<TiffIFD> allIFDs;
                if (reader.isTiff() != reader.isValidTiff()) {
                    throw new AssertionError();
                }
                this.tiff = reader.isTiff();
                this.metadata = TiffPyramidMetadata.empty();
                if (!this.tiff) {
                    Exception e = reader.openingException();
                    this.prefixInfo = "%nFile %s: not TIFF%s".formatted(tiffFile, e instanceof TiffException ? "" : "%n  (%s)".formatted(e == null ? "??" : e.getMessage()));
                    break block12;
                }
                try {
                    allIFDs = reader.allIFDs();
                }
                catch (IOException e) {
                    this.summaryInfo = "File %s (%s, %s-endian) cannot be loaded correctly".formatted(tiffFile, reader.isBigTiff() ? "BigTIFF" : "not BigTIFF", reader.isLittleEndian() ? "little" : "big");
                    throw e;
                }
                this.metadata = TiffPyramidMetadata.ofIFDs(allIFDs);
                int ifdCount = reader.numberOfImages();
                int mainCount = reader.numberOfMainIFDs();
                int firstIndex = Math.max(this.firstIFDIndex, 0);
                int lastIndex = Math.min(this.lastIFDIndex, ifdCount - 1);
                Object[] objectArray = new Object[7];
                objectArray[0] = tiffFile;
                objectArray[1] = ifdCount;
                objectArray[2] = ifdCount == mainCount ? "" : " (%d main + %d sub-IFDs)".formatted(mainCount, ifdCount - mainCount);
                objectArray[3] = reader.isBigTiff() ? "BigTIFF" : "not BigTIFF";
                Object object = objectArray[4] = reader.isLittleEndian() ? "little" : "big";
                objectArray[5] = this.metadata.isSvs() ? "SVS" : (this.metadata.isSvsCompatible() ? "SVS-compatible" : "non-SVS");
                objectArray[6] = this.metadata.isPyramid() ? " pyramid (" + this.metadata.numberOfLayers() + " layers, " + this.metadata.numberOfImages() + " images)" : "";
                this.prefixInfo = "File %s: %d images%s, %s, %s-endian, %s%s".formatted(objectArray);
                AtomicLong totalSize = new AtomicLong(reader.sizeOfHeader());
                long tiffFileLength = reader.stream().length();
                for (int k = firstIndex; k <= lastIndex; ++k) {
                    TiffIFD ifd = allIFDs.get(k);
                    this.ifdInfo.add(this.ifdInformation(reader, ifd, k, totalSize));
                    if (!ifd.containsKey(279) && !ifd.containsKey(325)) {
                        System.err.printf("WARNING! Invalid IFD #%d in %s: no StripByteCounts/TileByteCounts tag%n", k, tiffFile);
                    }
                    if (ifd.containsKey(273) || ifd.containsKey(324)) continue;
                    System.err.printf("WARNING! Invalid IFD #%d in %s: no StripOffsets/TileOffsets tag%n", k, tiffFile);
                }
                this.summaryInfo = totalSize.get() == tiffFileLength ? "Total file length %d bytes, it is fully used".formatted(tiffFileLength) : (totalSize.get() > tiffFileLength ? "%d bytes in file used, but the file length is only %d bytes, %d \"extra\" bytes: probably TIFF is not valid?".formatted(totalSize.get(), tiffFileLength, totalSize.get() - tiffFileLength) : "%d bytes in file used, %d bytes lost/unknown, the file length %d bytes".formatted(totalSize.get(), tiffFileLength - totalSize.get(), tiffFileLength));
                if (this.metadata.isNonTrivial()) {
                    this.svsInfo = (this.metadata.isSvs() ? "%s%n".formatted(this.metadata.svsDescription()) : "") + String.valueOf(this.metadata);
                }
            }
        }
    }

    public String ifdInformation(TiffReader reader, TiffIFD ifd, int ifdIndex) throws IOException {
        return this.ifdInformation(reader, ifd, ifdIndex, null);
    }

    private String ifdInformation(TiffReader reader, TiffIFD ifd, int ifdIndex, AtomicLong totalSize) throws IOException {
        if (this.disableAppendingForStrictFormats && this.stringFormat.isStrict()) {
            return ifd.toString(this.stringFormat);
        }
        int ifdCount = reader.numberOfImages();
        StringBuilder sb = new StringBuilder();
        sb.append("IFD #%d/%d:%s%s%n".formatted(ifdIndex, ifdCount, this.stringFormat.isJson() ? "%n".formatted(new Object[0]) : " ", ifd.toString(this.stringFormat)));
        long tiffFileLength = reader.stream().length();
        OptionalLong sizeOfIFDOptional = ifd.sizeOfIFD(tiffFileLength);
        AtomicBoolean imageDataAligned = new AtomicBoolean(false);
        if (sizeOfIFDOptional.isPresent()) {
            long sizeOfIFD = sizeOfIFDOptional.getAsLong();
            if (totalSize != null) {
                totalSize.addAndGet(sizeOfIFD);
            }
            long sizeOfData = -1L;
            try {
                sizeOfData = ifd.sizeOfImageData(tiffFileLength, imageDataAligned);
                long sizeOfIFDTable = ifd.sizeOfIFDTable();
                if (ifd.isMainIFD() && sizeOfIFDTable != (ifd.isBigTiff() ? 16L + 20L * (long)ifd.numberOfEntries() : 6L + 12L * (long)ifd.numberOfEntries())) {
                    throw new AssertionError((Object)"Invalid sizeOfIFDTable");
                }
                sb.append("%d bytes in the file occupied: %d metadata (%d table + %d external) + %d image data%s".formatted(sizeOfIFD + sizeOfData, sizeOfIFD, sizeOfIFDTable, sizeOfIFD - sizeOfIFDTable, sizeOfData, imageDataAligned.get() ? " (" + (sizeOfData - 1L) + " unaligned)" : ""));
                if (totalSize != null) {
                    totalSize.addAndGet(sizeOfData);
                }
            }
            catch (TiffException e) {
                sb.append("%d bytes in the file occupied by metadata, ".formatted(sizeOfIFD)).append("but cannot detect the size occupied by image data: ").append(e.getMessage());
            }
        }
        return sb.toString();
    }

    private void showTiffInfoAndPrintException(Path tiffFile) {
        try {
            this.showTiffInfo(tiffFile);
        }
        catch (IOException e) {
            System.err.printf("%nFile %s is invalid:%n  %s%n", tiffFile, e.getMessage());
        }
    }

    private void showTiffInfo(Path tiffFile) throws IOException {
        this.collectTiffInfo(tiffFile);
        System.out.println(this.prefixInfo);
        for (String ifdInfoLine : this.ifdInfo) {
            System.out.println(ifdInfoLine);
        }
        if (!this.summaryInfo.isEmpty()) {
            System.out.println(this.summaryInfo);
        }
        if (!this.svsInfo.isEmpty()) {
            System.out.println(this.svsInfo);
        }
        System.out.println();
    }

    private static boolean isPossiblyTIFF(File file) {
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName().toLowerCase();
        return name.contains(".") && !name.endsWith(".txt");
    }
}

