/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.IOException;
import java.util.Arrays;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.codecs.StreamTiffCodec;
import net.algart.matrices.tiff.codecs.TiffCodec;
import org.scijava.io.handle.DataHandle;

public class LZWCodec
extends StreamTiffCodec {
    private static final int HASH_SIZE = 7349;
    private static final int HASH_STEP = 257;
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int FIRST_CODE = 258;
    private static final int[] COMPR_MASKS = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private static final int[] DECOMPR_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127};

    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) throws TiffException {
        int tiffK;
        if (data == null || data.length == 0) {
            return data;
        }
        long bufferSize = (long)data.length * 141L / 100L + 3L;
        if (bufferSize > Integer.MAX_VALUE) {
            throw new TiffException("Output buffer is greater than 2 GB");
        }
        byte[] output = new byte[(int)bufferSize];
        int outSize = 0;
        output[outSize++] = -128;
        int currOutByte = 0;
        int freeBits = 7;
        int[] htKeys = new int[7349];
        int[] htValues = new int[7349];
        Arrays.fill(htKeys, -1);
        int nextCode = 258;
        int currCodeLength = 9;
        int tiffOmega = tiffK = data[0] & 0xFF;
        block11: for (int currInPos = 1; currInPos < data.length; ++currInPos) {
            int shift;
            tiffK = data[currInPos] & 0xFF;
            int hashKey = tiffOmega << 8 | tiffK;
            int hashCode = hashKey % 7349;
            while (true) {
                if (htKeys[hashCode] == hashKey) {
                    tiffOmega = htValues[hashCode];
                    break;
                }
                if (htKeys[hashCode] < 0) {
                    htKeys[hashCode] = hashKey;
                    htValues[hashCode] = nextCode++;
                    shift = currCodeLength - freeBits;
                    output[outSize++] = (byte)(currOutByte << freeBits | tiffOmega >> shift);
                    if (shift > 8) {
                        output[outSize++] = (byte)(tiffOmega >> shift - 8);
                        shift -= 8;
                    }
                    freeBits = 8 - shift;
                    currOutByte = tiffOmega & COMPR_MASKS[freeBits];
                    tiffOmega = tiffK;
                    break;
                }
                hashCode = (hashCode + 257) % 7349;
            }
            switch (nextCode) {
                case 512: {
                    currCodeLength = 10;
                    continue block11;
                }
                case 1024: {
                    currCodeLength = 11;
                    continue block11;
                }
                case 2048: {
                    currCodeLength = 12;
                    continue block11;
                }
                case 4096: {
                    shift = currCodeLength - freeBits;
                    output[outSize++] = (byte)(currOutByte << freeBits | 256 >> shift);
                    if (shift > 8) {
                        output[outSize++] = (byte)(256 >> shift - 8);
                        shift -= 8;
                    }
                    freeBits = 8 - shift;
                    currOutByte = 0x100 & COMPR_MASKS[freeBits];
                    Arrays.fill(htKeys, -1);
                    nextCode = 258;
                    currCodeLength = 9;
                }
            }
        }
        int shift = currCodeLength - freeBits;
        output[outSize++] = (byte)(currOutByte << freeBits | tiffOmega >> shift);
        if (shift > 8) {
            output[outSize++] = (byte)(tiffOmega >> shift - 8);
            shift -= 8;
        }
        freeBits = 8 - shift;
        currOutByte = tiffOmega & COMPR_MASKS[freeBits];
        currCodeLength = switch (nextCode) {
            case 511 -> 10;
            case 1023 -> 11;
            case 2047 -> 12;
            default -> currCodeLength;
        };
        shift = currCodeLength - freeBits;
        output[outSize++] = (byte)(currOutByte << freeBits | 257 >> shift);
        if (shift > 8) {
            output[outSize++] = (byte)(257 >> shift - 8);
            shift -= 8;
        }
        freeBits = 8 - shift;
        currOutByte = 0x101 & COMPR_MASKS[freeBits];
        output[outSize++] = (byte)(currOutByte << freeBits);
        byte[] result = new byte[outSize];
        System.arraycopy(output, 0, result, 0, outSize);
        return result;
    }

    @Override
    public byte[] decompress(DataHandle<?> in, TiffCodec.Options options) throws IOException {
        if (in == null || in.length() == 0L) {
            return null;
        }
        if (options == null) {
            options = new TiffCodec.Options();
        }
        byte[] output = new byte[options.maxSizeInBytes];
        int currOutPos = 0;
        int[] anotherCodes = new int[4096];
        byte[] newBytes = new byte[4096];
        int[] lengths = new int[4096];
        for (int i = 0; i < 256; ++i) {
            newBytes[i] = (byte)i;
            lengths[i] = 1;
        }
        int currCodeLength = 9;
        int nextCode = 258;
        int currRead = 0;
        int bitsRead = 0;
        int oldCode = 0;
        boolean startDecoding = true;
        try {
            do {
                int bitsLeft = currCodeLength - bitsRead;
                int firstByte = -1;
                if (bitsLeft > 8) {
                    firstByte = in.read() & 0xFF;
                    currRead = currRead << 8 | firstByte;
                    bitsLeft -= 8;
                }
                bitsRead = 8 - bitsLeft;
                int nextByte = in.read() & 0xFF;
                if (startDecoding && firstByte == 0 && nextByte == 1) {
                    throw new TiffException("TIFF 5.0-style LZW compression (very old format) is not supported");
                }
                int currCode = currRead << bitsLeft | nextByte >> bitsRead;
                currRead = nextByte & DECOMPR_MASKS[bitsRead];
                startDecoding = false;
                if (currCode == 257) break;
                if (currCode == 256) {
                    nextCode = 258;
                    currCodeLength = 9;
                    bitsLeft = currCodeLength - bitsRead;
                    if (bitsLeft > 8) {
                        currRead = currRead << 8 | in.read() & 0xFF;
                        bitsLeft -= 8;
                    }
                    bitsRead = 8 - bitsLeft;
                    int nextByte2 = in.read() & 0xFF;
                    currCode = currRead << bitsLeft | nextByte2 >> bitsRead;
                    currRead = nextByte2 & DECOMPR_MASKS[bitsRead];
                    if (currCode == 257 || currOutPos >= output.length - 1) break;
                    output[currOutPos++] = newBytes[currCode];
                    oldCode = currCode;
                } else if (currCode < nextCode) {
                    outLength = lengths[currCode];
                    i = currOutPos + outLength;
                    tablePos = currCode;
                    if (i > output.length) break;
                    while (i > currOutPos) {
                        output[--i] = newBytes[tablePos];
                        tablePos = anotherCodes[tablePos];
                    }
                    currOutPos += outLength;
                    if (nextCode >= anotherCodes.length) break;
                    anotherCodes[nextCode] = oldCode;
                    newBytes[nextCode] = output[i];
                    lengths[nextCode] = lengths[oldCode] + 1;
                    oldCode = currCode;
                    ++nextCode;
                } else {
                    outLength = lengths[oldCode];
                    i = currOutPos + outLength;
                    tablePos = oldCode;
                    if (i > output.length) break;
                    while (i > currOutPos) {
                        output[--i] = newBytes[tablePos];
                        tablePos = anotherCodes[tablePos];
                    }
                    if ((currOutPos += outLength) >= output.length) break;
                    output[currOutPos++] = output[i];
                    anotherCodes[nextCode] = oldCode;
                    newBytes[nextCode] = output[i];
                    lengths[nextCode] = outLength + 1;
                    oldCode = currCode;
                    ++nextCode;
                }
                switch (nextCode) {
                    case 511: {
                        int n = 10;
                        break;
                    }
                    case 1023: {
                        int n = 11;
                        break;
                    }
                    case 2047: {
                        int n = 12;
                        break;
                    }
                    default: {
                        int n = currCodeLength = currCodeLength;
                    }
                }
            } while (currOutPos < output.length && in.offset() < in.length());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new TiffException("Invalid LZW data", e);
        }
        return output;
    }
}

