/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.codecs.CCITTFaxCodec;
import net.algart.matrices.tiff.codecs.DeflateCodec;
import net.algart.matrices.tiff.codecs.JPEG2000Codec;
import net.algart.matrices.tiff.codecs.JPEGCodec;
import net.algart.matrices.tiff.codecs.LZWCodec;
import net.algart.matrices.tiff.codecs.PackBitsCodec;
import net.algart.matrices.tiff.codecs.TiffCodec;
import net.algart.matrices.tiff.codecs.UncompressedCodec;
import net.algart.matrices.tiff.tags.TagPhotometricInterpretation;
import net.algart.matrices.tiff.tiles.TiffTile;

public enum TagCompression {
    NONE(1, "Uncompressed", UncompressedCodec::new),
    CCITT_MODIFIED_HUFFMAN_RLE(2, "CCITT Modified Huffman RLE compression", CCITTFaxCodec::new),
    CCITT_T4(3, "CCITT T.4/Group 3 Fax compression", CCITTFaxCodec::new),
    CCITT_T6(4, "CCITT T.6/Group 4 Fax compression", CCITTFaxCodec::new),
    LZW(5, "LZW", LZWCodec::new),
    OLD_JPEG(6, "Old-style JPEG", null),
    JPEG(7, "JPEG", JPEGCodec::new),
    JPEG_RGB(7, "JPEG (RGB)", JPEGCodec::new),
    DEFLATE(8, "ZLib-Deflate", DeflateCodec::new),
    DEFLATE_PROPRIETARY(32946, "ZLib-Deflate (32946)", DeflateCodec::new),
    PACK_BITS(32773, "PackBits", PackBitsCodec::new),
    JPEG_2000(34712, "JPEG-2000", JPEG2000Codec::new, false),
    JPEG_2000_LOSSLESS(34712, "JPEG-2000 lossless", JPEG2000Codec::new, true),
    JPEG_2000_APERIO_33003(33003, "JPEG-2000 Aperio proprietary 33003", JPEG2000Codec::new, false, false),
    JPEG_2000_APERIO_33004(33004, "JPEG-2000 Aperio 33004 lossless", JPEG2000Codec::new, true, false),
    JPEG_2000_APERIO(33005, "JPEG-2000 Aperio 33005", JPEG2000Codec::new, false);

    private static final Map<Integer, TagCompression> LOOKUP;
    private static final boolean ALWAYS_ALLOW_WRITING = false;
    private final int code;
    private final String name;
    private final Supplier<TiffCodec> codec;
    private final Boolean jpeg2000Lossless;
    private final boolean writingSupported;

    private TagCompression(int code, String name, Supplier<TiffCodec> codec) {
        this(code, name, codec, null);
    }

    private TagCompression(int code, String name, Supplier<TiffCodec> codec, Boolean jpeg2000Lossless) {
        this(code, name, codec, jpeg2000Lossless, true);
    }

    private TagCompression(int code, String name, Supplier<TiffCodec> codec, Boolean jpeg2000Lossless, boolean writingSupported) {
        this.code = code;
        this.name = Objects.requireNonNull(name);
        this.codec = codec;
        this.jpeg2000Lossless = jpeg2000Lossless;
        this.writingSupported = writingSupported;
    }

    public static Optional<TagCompression> fromName(String name) {
        for (TagCompression value : TagCompression.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static Optional<TagCompression> fromCode(int code) {
        return Optional.ofNullable(LOOKUP.get(code));
    }

    public static Optional<TagCompression> fromCode(String codeString) {
        int code;
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return TagCompression.fromCode(code);
    }

    public static String toPrettyString(int code) {
        Optional<TagCompression> compression = TagCompression.fromCode(code);
        return "type " + code + (String)(compression.isEmpty() ? "" : ": \"" + compression.get().prettyName() + "\"");
    }

    public int code() {
        return this.code;
    }

    public String prettyName() {
        return this.name;
    }

    public TiffCodec codec() {
        return this.codec == null ? null : this.codec.get();
    }

    public boolean isStandardJpeg() {
        return this.code == 7;
    }

    public boolean isJpegOrOldJpeg() {
        return this.isStandardJpeg() || this == OLD_JPEG;
    }

    public boolean isPreferRGB() {
        return this == JPEG_RGB;
    }

    public boolean isJpeg2000() {
        return this.jpeg2000Lossless != null;
    }

    public boolean isJpeg2000Lossy() {
        return this.jpeg2000Lossless != null && this.jpeg2000Lossless == false;
    }

    public boolean isWritingSupported() {
        return this.writingSupported;
    }

    public boolean isStandard() {
        return this.code <= 10 || this == PACK_BITS;
    }

    public boolean canUseByteOrderForByteData() {
        return false;
    }

    public TiffCodec.Options customizeReading(TiffTile tile, TiffCodec.Options options) throws TiffException {
        if (this.isStandardJpeg()) {
            return TagCompression.customizeReadingJpeg(tile, options);
        }
        return options;
    }

    public TiffCodec.Options customizeWriting(TiffTile tile, TiffCodec.Options options) throws TiffException {
        if (this.isStandardJpeg()) {
            return TagCompression.customizeWritingJpeg(tile, options);
        }
        if (this.isJpeg2000()) {
            return TagCompression.customizeWritingJpeg2000(tile, options, !this.isJpeg2000Lossy(), this.isWritingSupported());
        }
        return options;
    }

    private static TiffCodec.Options customizeReadingJpeg(TiffTile tile, TiffCodec.Options options) throws TiffException {
        TiffIFD ifd = tile.ifd();
        return new JPEGCodec.JPEGOptions().setPhotometricInterpretation(ifd.getPhotometricInterpretation()).setYCbCrSubsampling(ifd.getYCbCrSubsampling()).setInterleaved(false);
    }

    private static TiffCodec.Options customizeWritingJpeg(TiffTile tile, TiffCodec.Options options) throws TiffException {
        JPEGCodec.JPEGOptions result = new JPEGCodec.JPEGOptions().setTo(options);
        if (tile.ifd().optInt(262, -1) == TagPhotometricInterpretation.RGB.code()) {
            result.setPhotometricInterpretation(TagPhotometricInterpretation.RGB);
        }
        return result;
    }

    private static JPEG2000Codec.JPEG2000Options customizeWritingJpeg2000(TiffTile tile, TiffCodec.Options defaultOptions, boolean lossless, boolean writingSupported) {
        return new JPEG2000Codec.JPEG2000Options().setTo(defaultOptions, lossless).setWritingSupported(writingSupported);
    }

    static {
        HashMap<Integer, TagCompression> map = new HashMap<Integer, TagCompression>();
        for (TagCompression v : TagCompression.values()) {
            map.putIfAbsent(v.code(), v);
        }
        LOOKUP = map;
    }
}

