/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public enum TagPredictor {
    NONE(1, "none"),
    HORIZONTAL(2, "horizontal differencing"),
    HORIZONTAL_FLOATING_POINT(3, "floating-point horizontal differencing"),
    UNKNOWN(-1, "unknown");

    private static final Map<Integer, TagPredictor> LOOKUP;
    private final int code;
    private final String name;

    private TagPredictor(int code, String name) {
        this.code = code;
        this.name = Objects.requireNonNull(name);
    }

    public static TagPredictor fromCodeOrUnknown(int code) {
        return LOOKUP.getOrDefault(code, UNKNOWN);
    }

    public int code() {
        return this.code;
    }

    public String prettyName() {
        return this.name;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        LOOKUP = Arrays.stream(TagPredictor.values()).filter(v -> v.code >= 0).collect(Collectors.toMap(TagPredictor::code, v -> v));
    }
}

