/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tiles;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffIO;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.tiles.TiffMap;
import net.algart.matrices.tiff.tiles.TiffReadMap;
import net.algart.matrices.tiff.tiles.TiffTile;
import net.algart.matrices.tiff.tiles.TiffTileIndex;
import net.algart.matrices.tiff.tiles.TiffWriteMap;

public abstract sealed class TiffIOMap
extends TiffMap
permits TiffReadMap, TiffWriteMap {
    public TiffIOMap(TiffIFD ifd, boolean resizable) {
        super(ifd, resizable);
    }

    public abstract TiffReader reader();

    public abstract TiffIO owner();

    public abstract boolean isExisting();

    public TileSupplier simpleTileSupplier() {
        return this.reader()::readTile;
    }

    public TileSupplier cachedTileSupplier() {
        return this.reader()::readCachedTile;
    }

    public long fileLength() {
        return this.owner().fileLength();
    }

    public byte[] loadSampleBytes(int fromX, int fromY, int sizeX, int sizeY, TiffReader.UnusualPrecisions unusualPrecisions, boolean storeTilesInMap) throws IOException {
        return this.loadSampleBytes(fromX, fromY, sizeX, sizeY, unusualPrecisions, storeTilesInMap, this.cachedTileSupplier());
    }

    public byte[] loadSampleBytes(int fromX, int fromY, int sizeX, int sizeY, TiffReader.UnusualPrecisions unusualPrecisions, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        Objects.requireNonNull(unusualPrecisions, "Null unusualPrecisions");
        Objects.requireNonNull(tileSupplier, "Null tileSupplier");
        TiffIOMap.checkRequestedArea(fromX, fromY, sizeX, sizeY);
        int sizeInBytes = this.sizeOfRegionWithPossibleNonStandardPrecisions(sizeX, sizeY);
        long sizeInPixels = (long)sizeX * (long)sizeY;
        if (!this.isExisting()) {
            throw new IllegalStateException("Image data can only be read from a TIFF map for an existing IFD, not for a newly created map for writing new image");
        }
        unusualPrecisions.throwIfDisabled(this);
        assert (unusualPrecisions == TiffReader.UnusualPrecisions.NONE || unusualPrecisions == TiffReader.UnusualPrecisions.UNPACK);
        byte[] samples = new byte[sizeInBytes];
        TiffReader reader = this.reader();
        boolean scaleUnsignedInt24 = reader.isAutoScaleWhenIncreasingBitDepth();
        byte byteFiller = reader.getByteFiller();
        if (byteFiller != 0) {
            Arrays.fill(samples, 0, sizeInBytes, byteFiller);
        }
        if (sizeX == 0 || sizeY == 0) {
            return samples;
        }
        int mapTileSizeX = this.tileSizeX();
        int mapTileSizeY = this.tileSizeY();
        long bitsPerSample = this.alignedBitsPerSample();
        int numberOfSeparatedPlanes = this.numberOfSeparatedPlanes();
        int samplesPerPixel = this.tileSamplesPerPixel();
        boolean cropTilesToImageBoundaries = reader.isCropTilesToImageBoundaries();
        int toX = Math.min(fromX + sizeX, cropTilesToImageBoundaries ? this.dimX() : Integer.MAX_VALUE);
        int toY = Math.min(fromY + sizeY, cropTilesToImageBoundaries ? this.dimY() : Integer.MAX_VALUE);
        int minXIndex = Math.max(0, TiffIOMap.divFloor(fromX, mapTileSizeX));
        int minYIndex = Math.max(0, TiffIOMap.divFloor(fromY, mapTileSizeY));
        if (minXIndex >= this.gridCountX() || minYIndex >= this.gridCountY() || toX < fromX || toY < fromY) {
            return unusualPrecisions.unpackIfNecessary(this, samples, sizeInPixels, scaleUnsignedInt24);
        }
        int maxXIndex = Math.min(this.gridCountX() - 1, TiffIOMap.divFloor(toX - 1, mapTileSizeX));
        int maxYIndex = Math.min(this.gridCountY() - 1, TiffIOMap.divFloor(toY - 1, mapTileSizeY));
        if (minYIndex > maxYIndex || minXIndex > maxXIndex) {
            return unusualPrecisions.unpackIfNecessary(this, samples, sizeInPixels, scaleUnsignedInt24);
        }
        long tileOneChannelRowSizeInBits = (long)mapTileSizeX * bitsPerSample;
        long samplesOneChannelRowSizeInBits = (long)sizeX * bitsPerSample;
        for (int p = 0; p < numberOfSeparatedPlanes; ++p) {
            for (int yIndex = minYIndex; yIndex <= maxYIndex; ++yIndex) {
                int tileStartY = Math.max(yIndex * mapTileSizeY, fromY);
                int fromYInTile = tileStartY % mapTileSizeY;
                int yDiff = tileStartY - fromY;
                for (int xIndex = minXIndex; xIndex <= maxXIndex; ++xIndex) {
                    int tileStartX = Math.max(xIndex * mapTileSizeX, fromX);
                    int fromXInTile = tileStartX % mapTileSizeX;
                    int xDiff = tileStartX - fromX;
                    TiffTileIndex tileIndex = this.index(xIndex, yIndex, p);
                    TiffTile tile = tileSupplier.getTile(tileIndex);
                    if (storeTilesInMap) {
                        this.put(tile);
                    }
                    if (tile.isEmpty()) continue;
                    if (!tile.isSeparated()) {
                        throw new AssertionError((Object)"Illegal behavior of readTile: it returned interleaved tile!");
                    }
                    byte[] data = tile.getDecodedData();
                    int tileSizeX = tile.getSizeX();
                    int tileSizeY = tile.getSizeY();
                    int sizeXInTile = Math.min(toX - tileStartX, tileSizeX - fromXInTile);
                    assert (sizeXInTile > 0) : "sizeXInTile=" + sizeXInTile;
                    int sizeYInTile = Math.min(toY - tileStartY, tileSizeY - fromYInTile);
                    assert (sizeYInTile > 0) : "sizeYInTile=" + sizeYInTile;
                    long partSizeXInBits = (long)sizeXInTile * bitsPerSample;
                    for (int s = 0; s < samplesPerPixel; ++s) {
                        long tOffset = (((long)s * (long)tileSizeY + (long)fromYInTile) * (long)tileSizeX + (long)fromXInTile) * bitsPerSample;
                        long sOffset = (((long)(p + s) * (long)sizeY + (long)yDiff) * (long)sizeX + (long)xDiff) * bitsPerSample;
                        for (int i = 0; i < sizeYInTile; ++i) {
                            assert (sOffset >= 0L && tOffset >= 0L) : "possibly int instead of long";
                            PackedBitArraysPer8.copyBitsNoSync((byte[])samples, (long)sOffset, (byte[])data, (long)tOffset, (long)partSizeXInBits);
                            tOffset += tileOneChannelRowSizeInBits;
                            sOffset += samplesOneChannelRowSizeInBits;
                        }
                    }
                }
            }
        }
        return unusualPrecisions.unpackIfNecessary(this, samples, sizeInPixels, scaleUnsignedInt24);
    }

    public byte[] readSampleBytes(int fromX, int fromY, int sizeX, int sizeY, TiffReader.UnusualPrecisions autoUnpackUnusualPrecisions, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        TiffReader reader = this.reader();
        return reader.readSampleBytes(this, fromX, fromY, sizeX, sizeY, autoUnpackUnusualPrecisions, storeTilesInMap, tileSupplier);
    }

    public Object readJavaArray(int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        TiffReader reader = this.reader();
        return reader.readJavaArray(this, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
    }

    public Matrix<UpdatablePArray> readMatrix(int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        TiffReader reader = this.reader();
        return reader.readMatrix(this, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix(int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        TiffReader reader = this.reader();
        return reader.readInterleavedMatrix(this, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
    }

    public List<Matrix<UpdatablePArray>> readChannels(int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        TiffReader reader = this.reader();
        return reader.readChannels(this, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
    }

    public BufferedImage readBufferedImage(int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TileSupplier tileSupplier) throws IOException {
        TiffReader reader = this.reader();
        return reader.readBufferedImage(this, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
    }

    static int divFloor(int a, int b) {
        assert (b > 0);
        return a >= 0 ? a / b : (a - b + 1) / b;
    }

    @FunctionalInterface
    public static interface TileSupplier {
        public TiffTile getTile(TiffTileIndex var1) throws IOException;
    }
}

