/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tiles;

import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRectangularArea;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffSampleType;
import net.algart.matrices.tiff.data.TiffUnusualPrecisions;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tiles.TiffMap;
import net.algart.matrices.tiff.tiles.TiffTileIndex;

public final class TiffTile {
    private static final boolean DISABLE_CROPPING = false;
    private final TiffMap map;
    private final int samplesPerPixel;
    private final int bitsPerSample;
    private final int bitsPerPixel;
    private final TiffTileIndex index;
    private int sizeX;
    private int sizeY;
    private int sizeInPixels;
    private int sizeInBytes;
    private int sizeInBits;
    private int lineSizeInBytesInsideTIFF;
    private boolean interleaved = false;
    private boolean encoded = false;
    private byte[] data = null;
    private long storedInFileDataOffset = -1L;
    private int storedInFileDataLength = 0;
    private int storedInFileDataCapacity = 0;
    private int estimatedNumberOfPixels = 0;
    private Queue<IRectangularArea> unsetArea = null;
    private boolean frozen = false;

    public TiffTile(TiffTileIndex index) {
        this.index = Objects.requireNonNull(index, "Null tile index");
        this.map = index.map();
        assert (this.map != null) : "Null map for tile index " + String.valueOf(index);
        this.samplesPerPixel = this.map.tileSamplesPerPixel();
        this.bitsPerSample = this.map.alignedBitsPerSample();
        this.bitsPerPixel = this.map.tileAlignedBitsPerPixel();
        assert (this.bitsPerPixel == this.samplesPerPixel * this.bitsPerSample);
        assert (index.ifd() == this.map.ifd()) : "index retrieved ifd from its tile map!";
        this.setSizes(this.map.tileSizeX(), this.map.tileSizeY());
    }

    public TiffMap map() {
        return this.map;
    }

    public TiffIFD ifd() {
        return this.map.ifd();
    }

    public TiffTileIndex index() {
        return this.index;
    }

    public boolean isPlanarSeparated() {
        return this.map.isPlanarSeparated();
    }

    public int samplesPerPixel() {
        return this.samplesPerPixel;
    }

    public boolean isBinary() {
        return this.map.isBinary();
    }

    public boolean isWholeBytes() {
        return this.map.isWholeBytes();
    }

    public int bitsPerSample() {
        return this.bitsPerSample;
    }

    public OptionalInt bytesPerSample() {
        return this.map.bytesPerSample();
    }

    public int bitsPerPixel() {
        return this.bitsPerPixel;
    }

    public OptionalInt bytesPerPixel() {
        OptionalInt opt = this.bytesPerSample();
        return opt.isPresent() ? OptionalInt.of(opt.getAsInt() * this.samplesPerPixel) : OptionalInt.empty();
    }

    public TiffSampleType sampleType() {
        return this.map.sampleType();
    }

    public Class<?> elementType() {
        return this.map.elementType();
    }

    public ByteOrder byteOrder() {
        return this.map.byteOrder();
    }

    public int compressionCode() {
        return this.map.compressionCode();
    }

    public Optional<TagCompression> compression() {
        return this.map.compression();
    }

    public int fromX() {
        return this.index.fromX();
    }

    public int fromY() {
        return this.index.fromY();
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public TiffTile setSizeX(int sizeX) {
        return this.setSizes(sizeX, this.sizeY);
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public TiffTile setSizeY(int sizeY) {
        return this.setSizes(this.sizeX, sizeY);
    }

    public TiffTile setSizes(int sizeX, int sizeY) {
        if (sizeX <= 0) {
            throw new IllegalArgumentException("Zero or negative tile x-size: " + sizeX);
        }
        if (sizeY <= 0) {
            throw new IllegalArgumentException("Zero or negative tile y-size: " + sizeY);
        }
        long alignedSizeX = (long)sizeX + 7L & 0xFFFFFFFFFFFFFFF8L;
        assert (alignedSizeX >= (long)sizeX && alignedSizeX >> 3 == (long)(sizeX + 7 >>> 3));
        Supplier<String> alignedMsg = () -> alignedSizeX == (long)sizeX ? "" : " (after aligning " + sizeX + " to slightly larger width " + alignedSizeX + ", divisible by 8)";
        if (alignedSizeX * (long)sizeY > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Very large TIFF tile " + sizeX + "x" + sizeY + " >= 2^31 pixels is not supported" + alignedMsg.get());
        }
        if (alignedSizeX * (long)sizeY * (long)this.bitsPerPixel > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Very large TIFF tile " + sizeX + "x" + sizeY + ", " + this.samplesPerPixel + " channels per " + this.bitsPerSample + " bits >= 2^31 bits (256 MB) is not supported" + alignedMsg.get());
        }
        int sizeInPixels = sizeX * sizeY;
        assert (alignedSizeX * (long)this.bitsPerPixel <= Integer.MAX_VALUE) : "impossible because " + sizeY + " > 0";
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeInPixels = sizeInPixels;
        this.sizeInBits = sizeInPixels * this.bitsPerPixel;
        this.sizeInBytes = this.sizeInBits + 7 >>> 3;
        this.lineSizeInBytesInsideTIFF = sizeX * this.bitsPerPixel + 7 >>> 3;
        assert ((long)this.lineSizeInBytesInsideTIFF * (long)sizeY <= Integer.MAX_VALUE) : "too large " + this.lineSizeInBytesInsideTIFF + "*" + sizeY;
        return this;
    }

    public TiffTile setEqualSizes(TiffTile other) {
        Objects.requireNonNull(other, "Null other tile");
        return this.setSizes(other.sizeX, other.sizeY);
    }

    public boolean equalSizes(TiffTile other) {
        return other != null && this.sizeX == other.sizeX && this.sizeY == other.sizeY;
    }

    public int getSizeInPixels() {
        return this.sizeInPixels;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getLineSizeInBytesInsideTIFF() {
        return this.lineSizeInBytesInsideTIFF;
    }

    public int getSizeInBytesInsideTIFF() {
        return this.lineSizeInBytesInsideTIFF * this.sizeY;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public IRectangularArea actualRectangle() {
        int sizeXInTile = this.map.isResizable() ? this.sizeX : Math.min(this.sizeX, this.map.dimX() - this.fromX());
        int sizeYInTile = this.map.isResizable() ? this.sizeY : Math.min(this.sizeY, this.map.dimY() - this.fromY());
        return this.rectangleInTile(0, 0, sizeXInTile, sizeYInTile);
    }

    public IRectangularArea rectangleInTile(int fromXInTile, int fromYInTile, int sizeXInTile, int sizeYInTile) {
        if (sizeXInTile <= 0) {
            throw new IllegalArgumentException("Zero or negative sizeXInTile = " + sizeXInTile);
        }
        if (sizeYInTile <= 0) {
            throw new IllegalArgumentException("Zero or negative sizeYInTile = " + sizeYInTile);
        }
        long minX = (long)this.index.fromX() + (long)fromXInTile;
        long minY = (long)this.index.fromY() + (long)fromYInTile;
        long maxX = minX + (long)sizeXInTile - 1L;
        long maxY = minY + (long)sizeYInTile - 1L;
        return IRectangularArea.of((long)minX, (long)minY, (long)maxX, (long)maxY);
    }

    public boolean isFullyInsideMap() {
        return this.index.fromX() + this.sizeX <= this.map.dimX() && this.index.fromY() + this.sizeY <= this.map.dimY();
    }

    public TiffTile cropStripToMap() {
        return this.cropToMap(true);
    }

    public TiffTile cropToMap(boolean strippedOnly) {
        this.checkOutsideMap();
        if (strippedOnly && this.map.tilingMode().isTileGrid()) {
            return this;
        }
        return this.setSizes(Math.min(this.sizeX, this.map.dimX() - this.index.fromX()), Math.min(this.sizeY, this.map.dimY() - this.index.fromY()));
    }

    public Collection<IRectangularArea> getUnsetArea() {
        return this.unsetArea == null ? List.of(this.actualRectangle()) : Collections.unmodifiableCollection(this.unsetArea);
    }

    public TiffTile markWholeTileAsUnset() {
        this.unsetArea = null;
        return this;
    }

    public TiffTile markWholeTileAsSet() {
        this.unsetArea = new LinkedList<IRectangularArea>();
        return this;
    }

    public TiffTile markNewAreaAsSet(IRectangularArea ... newlyFilledArea) {
        Objects.requireNonNull(newlyFilledArea, "Null newlyFilledArea");
        this.initializeEmptyArea();
        IRectangularArea.subtractCollection(this.unsetArea, (IRectangularArea[])newlyFilledArea);
        return this;
    }

    public TiffTile markNewRectangleAsSet(int fromXInTile, int fromYInTile, int sizeXInTile, int sizeYInTile) {
        if (sizeXInTile > 0 && sizeYInTile > 0) {
            this.markNewAreaAsSet(this.rectangleInTile(fromXInTile, fromYInTile, sizeXInTile, sizeYInTile));
        }
        return this;
    }

    public TiffTile cropUnsetAreaToMap() {
        this.checkOutsideMap();
        if (!this.isFullyInsideMap()) {
            long minX = this.map.dimX();
            long minY = this.map.dimY();
            this.markNewAreaAsSet(IRectangularArea.of((long)0L, (long)minY, (long)Integer.MAX_VALUE, (long)Integer.MAX_VALUE), IRectangularArea.of((long)minX, (long)0L, (long)Integer.MAX_VALUE, (long)Integer.MAX_VALUE));
        }
        return this;
    }

    public boolean isCompleted() {
        return !this.hasUnsetArea();
    }

    public boolean isCompletelyUnset() {
        return this.unsetArea == null;
    }

    public boolean hasUnsetArea() {
        return this.unsetArea == null || !this.unsetArea.isEmpty();
    }

    public boolean isInterleaved() {
        return this.interleaved;
    }

    public boolean isSeparated() {
        return !this.interleaved;
    }

    public TiffTile setInterleaved(boolean interleaved) {
        this.interleaved = interleaved;
        return this;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public void checkReadyForNewDecodedData(Boolean requiredInterleavedState) {
        if (this.encoded) {
            throw new IllegalStateException("TIFF tile is not ready to store new decoded data, because it is encoded (probably contains encoded data): " + String.valueOf(this));
        }
        if (requiredInterleavedState != null && requiredInterleavedState != this.interleaved) {
            String status = this.interleaved ? "interleaved" : "separated";
            throw new IllegalStateException("TIFF tile is not ready to store new decoded data, because it is " + status + " (probably contains decoded, but already " + status + " data): " + String.valueOf(this));
        }
    }

    public void checkEncodedData() {
        this.checkEmpty();
        if (!this.isEncoded()) {
            throw new IllegalStateException("TIFF tile is not encoded: " + String.valueOf(this));
        }
    }

    public byte[] getEncodedData() {
        this.checkEncodedData();
        return this.data;
    }

    public int getEncodedDataLength() {
        this.checkEncodedData();
        return this.data.length;
    }

    public TiffTile setEncodedData(byte[] data) {
        return this.setEncodedData(data, false);
    }

    public TiffTile setEncodedData(byte[] data, boolean unfreeze) {
        return this.setData(data, true, false, unfreeze);
    }

    public void checkDecodedData() {
        this.checkEmpty();
        if (this.isEncoded()) {
            throw new IllegalStateException("TIFF tile data are not decoded and cannot be retrieved: " + String.valueOf(this));
        }
    }

    public byte[] getDecodedData() {
        this.checkDecodedData();
        return this.data;
    }

    public int getDecodedDataLength() {
        this.checkDecodedData();
        return this.data.length;
    }

    public TiffTile setDecodedData(byte[] data) {
        return this.setDecodedData(data, false);
    }

    public TiffTile setDecodedData(byte[] data, boolean unfreeze) {
        return this.setData(data, false, true, unfreeze);
    }

    public TiffTile setPartiallyDecodedData(byte[] data) {
        return this.setData(data, false, false, false);
    }

    public TiffTile fillWhenEmpty() {
        return this.fillWhenEmpty(null);
    }

    public TiffTile fillWhenEmpty(Consumer<TiffTile> initializer) {
        this.checkFrozen();
        if (this.isEmpty()) {
            this.setDecodedData(new byte[this.sizeInBytes]);
            if (initializer != null) {
                initializer.accept(this);
            }
        }
        return this;
    }

    public byte[] getUnpackedSampleBytes(boolean autoScaleWhenIncreasingBitDepth) {
        byte[] samples = this.getDecodedData();
        try {
            samples = TiffUnusualPrecisions.unpackUnusualPrecisions(samples, this.ifd(), this.samplesPerPixel, this.sizeInPixels, autoScaleWhenIncreasingBitDepth);
        }
        catch (TiffException e) {
            throw new IllegalStateException("Illegal IFD inside the tile map", e);
        }
        return samples;
    }

    public Object getUnpackedJavaArray(boolean autoScaleWhenIncreasingBitDepth) {
        byte[] samples = this.getUnpackedSampleBytes(autoScaleWhenIncreasingBitDepth);
        return this.sampleType().javaArray(samples, this.byteOrder());
    }

    public TiffTile setUnpackedJavaArray(Object samplesArray) {
        Objects.requireNonNull(samplesArray, "Null samplesArray");
        Class<?> elementType = samplesArray.getClass().getComponentType();
        if (elementType == null) {
            throw new IllegalArgumentException("The specified samplesArray is not actual an array: it is " + String.valueOf(samplesArray.getClass()));
        }
        if (elementType != this.elementType()) {
            throw new IllegalArgumentException("Invalid element type of samples array: " + String.valueOf(elementType) + ", but the specified TIFF tile stores " + String.valueOf(this.elementType()) + " elements");
        }
        int length = Array.getLength(samplesArray);
        byte[] samples = TiffSampleType.bytes(samplesArray, length, this.byteOrder());
        return this.setDecodedData(samples);
    }

    public Matrix<UpdatablePArray> getUnpackedMatrix() {
        return this.getUnpackedMatrix(true);
    }

    public Matrix<UpdatablePArray> getUnpackedMatrix(boolean autoScaleWhenIncreasingBitDepth) {
        return TiffSampleType.asMatrix(this.getUnpackedJavaArray(autoScaleWhenIncreasingBitDepth), this.sizeX, this.sizeY, this.samplesPerPixel, this.interleaved);
    }

    public TiffTile copyData(TiffTile source, boolean cloneData) {
        Objects.requireNonNull(source, "Null source tile");
        if (source.isEmpty()) {
            this.freeData();
        } else {
            byte[] data = cloneData ? (byte[])source.data.clone() : source.data;
            this.setData(data, source.encoded, false, true);
        }
        this.frozen = source.frozen;
        return this;
    }

    public TiffTile copyUnpackedSamples(TiffTile source, boolean autoScaleWhenIncreasingBitDepth) {
        Objects.requireNonNull(source, "Null source tile");
        if (this.sampleType() != source.sampleType()) {
            throw new IllegalArgumentException("The specified source tile has incompatible sample type (" + source.elementType().getSimpleName() + ") than this tile: " + String.valueOf(this));
        }
        if (this.samplesPerPixel != source.samplesPerPixel) {
            throw new IllegalArgumentException("The specified source tile has incompatible samples per pixel (" + source.samplesPerPixel + ") than this tile: " + String.valueOf(this));
        }
        if (source.isEmpty()) {
            this.freeData();
            this.frozen = source.frozen;
            return this;
        }
        source.checkDecodedData();
        if (this.map.isByteOrderCompatible(source.byteOrder())) {
            byte[] decodedData = source.getUnpackedSampleBytes(autoScaleWhenIncreasingBitDepth);
            this.setDecodedData(decodedData, true);
        } else {
            assert (this.byteOrder() != source.byteOrder());
            assert (this.elementType() != Boolean.TYPE);
            byte[] decodedData = source.getUnpackedSampleBytes(autoScaleWhenIncreasingBitDepth);
            byte[] swapped = JArrays.copyAndSwapByteOrder((byte[])decodedData, this.elementType());
            this.setDecodedData(swapped, true);
        }
        this.frozen = source.frozen;
        return this;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeData() {
        this.data = null;
        this.interleaved = false;
        this.encoded = false;
    }

    public void freeAndFreeze() {
        this.freeData();
        this.frozen = true;
    }

    public void unfreeze() {
        this.frozen = false;
    }

    public long getStoredInFileDataOffset() {
        this.checkStoredFileOffset();
        return this.storedInFileDataOffset;
    }

    public int getStoredInFileDataLength() {
        return this.storedInFileDataLength;
    }

    public boolean isStoredInFile() {
        return this.storedInFileDataOffset >= 0L;
    }

    public TiffTile clearStoredInFile() {
        this.storedInFileDataOffset = -1L;
        return this;
    }

    public TiffTile setStoredInFileDataRange(long storedInFileDataOffset, int storedInFileDataLength, boolean resetCapacity) {
        if (storedInFileDataOffset < 0L) {
            throw new IllegalArgumentException("Negative storedInFileDataOffset = " + storedInFileDataOffset);
        }
        if (storedInFileDataLength < 0) {
            throw new IllegalArgumentException("Negative storedInFileDataLength = " + storedInFileDataLength);
        }
        this.storedInFileDataOffset = storedInFileDataOffset;
        this.storedInFileDataLength = storedInFileDataLength;
        if (resetCapacity) {
            this.resetStoredInFileDataCapacity();
        }
        return this;
    }

    public int getStoredInFileDataCapacity() {
        return this.storedInFileDataCapacity;
    }

    public TiffTile resetStoredInFileDataCapacity() {
        this.storedInFileDataCapacity = this.storedInFileDataLength;
        return this;
    }

    public TiffTile expandStoredInFileDataCapacity(int newStoredInFileDataCapacity) {
        if (newStoredInFileDataCapacity >= this.storedInFileDataLength) {
            this.storedInFileDataCapacity = Math.max(this.storedInFileDataCapacity, newStoredInFileDataCapacity);
        }
        return this;
    }

    public TiffTile copyStoredInFileDataRange(TiffTile other) {
        Objects.requireNonNull(other, "Null other tile");
        this.storedInFileDataOffset = other.storedInFileDataOffset;
        this.storedInFileDataLength = other.storedInFileDataLength;
        this.storedInFileDataCapacity = other.storedInFileDataCapacity;
        return this;
    }

    public int getEstimatedNumberOfPixels() {
        if (this.isEncoded()) {
            throw new IllegalStateException("TIFF tile data are not decoded, number of pixels is unknown: " + String.valueOf(this));
        }
        return this.estimatedNumberOfPixels;
    }

    public void checkDataLengthAlignment() {
        this.checkEmpty();
        int estimatedNumberOfPixels = this.getEstimatedNumberOfPixels();
        assert (!this.encoded);
        int expectedNumberOfBytes = estimatedNumberOfPixels * this.bitsPerPixel + 7 >>> 3;
        if (expectedNumberOfBytes != this.data.length) {
            assert (this.bitsPerPixel != 1) : "unaligned estimatedNumberOfPixels cannot appear for 1 bit/pixel";
            throw new IllegalStateException("Unaligned length of decoded data " + this.data.length + ": it is not equal to ceil(number of pixels * bits per pixel / 8) = ceil(" + estimatedNumberOfPixels + " * " + this.bitsPerPixel + " / 8) = " + expectedNumberOfBytes + ", as if the last pixel is stored \"partially\"");
        }
    }

    public TiffTile checkStoredNumberOfPixels() {
        this.checkEmpty();
        int estimatedNumberOfPixels = this.getEstimatedNumberOfPixels();
        assert (!this.encoded);
        if (this.data.length != this.sizeInBytes) {
            throw new IllegalStateException("Number of stored pixels " + estimatedNumberOfPixels + " does not match tile sizes " + this.sizeX + "x" + this.sizeY + " = " + this.sizeInPixels);
        }
        int dataLength = estimatedNumberOfPixels * this.bitsPerPixel + 7 >>> 3;
        if (dataLength != this.data.length) {
            throw new AssertionError((Object)("Invalid estimatedNumberOfPixels " + estimatedNumberOfPixels + ": does not match data.length = " + this.data.length));
        }
        return this;
    }

    public TiffTile adjustNumberOfPixels(boolean allowDecreasing) {
        return this.changeNumberOfPixels(this.sizeInPixels, allowDecreasing);
    }

    public TiffTile changeNumberOfPixels(long newNumberOfPixels, boolean allowDecreasing) {
        byte[] newData;
        if (newNumberOfPixels < 0L) {
            throw new IllegalArgumentException("Negative new number of pixels = " + newNumberOfPixels);
        }
        long newNumberOfBits = newNumberOfPixels * (long)this.bitsPerPixel;
        if (newNumberOfPixels > Integer.MAX_VALUE || newNumberOfBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large requested number of pixels in tile: " + newNumberOfPixels + " pixels * " + this.samplesPerPixel + " samples/pixel * " + this.bitsPerSample + " bits/sample >= 2^31 bits (256 MB), such large tiles are not supported");
        }
        int newLength = (int)(newNumberOfBits + 7L >>> 3);
        byte[] data = this.getDecodedData();
        if (newLength == data.length) {
            return this;
        }
        if (newLength < data.length && !allowDecreasing) {
            throw new IllegalArgumentException("The new number of pixels " + newNumberOfPixels + " is less than actually stored; this is not allowed: data may be lost");
        }
        if (this.interleaved || this.samplesPerPixel == 1) {
            newData = Arrays.copyOf(data, newLength);
        } else {
            if ((this.bitsPerPixel & 7) != 0) {
                throw new AssertionError((Object)("Unsupported bits per pixel " + this.bitsPerPixel + " for " + this.samplesPerPixel + " channel (more than one)"));
            }
            newData = new byte[newLength];
            long size = (long)this.getEstimatedNumberOfPixels() * (long)this.bitsPerSample;
            long newSize = newNumberOfPixels * (long)this.bitsPerSample;
            long sizeToCopy = Math.min(size, newSize);
            long s = 0L;
            long disp = 0L;
            long newDisp = 0L;
            while (s < (long)this.samplesPerPixel) {
                PackedBitArraysPer8.copyBitsNoSync((byte[])newData, (long)newDisp, (byte[])data, (long)disp, (long)sizeToCopy);
                ++s;
                disp += size;
                newDisp += newSize;
            }
        }
        return this.setDecodedData(newData);
    }

    public TiffTile interleaveSamplesIfNecessary() {
        this.checkEmpty();
        if (!this.isInterleaved()) {
            this.interleaveSamples();
        }
        return this;
    }

    public TiffTile separateSamplesIfNecessary() {
        this.checkEmpty();
        if (this.isInterleaved()) {
            this.separateSamples();
        }
        return this;
    }

    public TiffTile interleaveSamples() {
        byte[] data = this.getDecodedData();
        if (this.isInterleaved()) {
            throw new IllegalStateException("TIFF tile is already interleaved: " + String.valueOf(this));
        }
        data = this.map.toInterleavedSamples(data, this.samplesPerPixel, this.getEstimatedNumberOfPixels());
        this.setInterleaved(true);
        this.setDecodedData(data);
        return this;
    }

    public TiffTile separateSamples() {
        byte[] data = this.getDecodedData();
        if (!this.isInterleaved()) {
            throw new IllegalStateException("TIFF tile is already separated: " + String.valueOf(this));
        }
        data = this.map.toSeparatedSamples(data, this.samplesPerPixel, this.getEstimatedNumberOfPixels());
        this.setInterleaved(false);
        this.setDecodedData(data);
        return this;
    }

    public String toString() {
        byte[] data = this.data;
        return "TIFF " + (this.frozen ? "(FROZEN) " : (this.isEmpty() ? "(empty) " : "")) + (this.encoded ? "encoded" : "non-encoded") + (this.interleaved ? " interleaved" : " separated") + " tile, " + this.elementType().getSimpleName() + "[" + this.sizeX + "x" + this.sizeY + "x" + this.samplesPerPixel + "]" + (String)(data == null ? "" : " (" + data.length + " bytes)") + (this.isCompleted() ? ", completed" : (this.isCompletelyUnset() ? ", completely unset " : ", partial")) + ", " + this.bitsPerSample + " bits/sample, index " + String.valueOf(this.index) + (String)(this.isStoredInFile() ? " at file region " + this.storedInFileDataOffset + ".." + this.storedInFileDataOffset + "+" + (this.storedInFileDataLength - 1) + "/" + (this.storedInFileDataCapacity - 1) : ", no file position");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiffTile tiffTile = (TiffTile)o;
        return this.sizeX == tiffTile.sizeX && this.sizeY == tiffTile.sizeY && this.interleaved == tiffTile.interleaved && this.encoded == tiffTile.encoded && this.samplesPerPixel == tiffTile.samplesPerPixel && this.bitsPerSample == tiffTile.bitsPerSample && this.storedInFileDataOffset == tiffTile.storedInFileDataOffset && this.storedInFileDataLength == tiffTile.storedInFileDataLength && this.storedInFileDataCapacity == tiffTile.storedInFileDataCapacity && Objects.equals(this.index, tiffTile.index) && Arrays.equals(this.data, tiffTile.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.index, this.sizeX, this.sizeY, this.interleaved, this.encoded, this.storedInFileDataOffset, this.storedInFileDataLength, this.storedInFileDataCapacity);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    private TiffTile setData(byte[] data, boolean encoded, boolean checkAligned, boolean unfreeze) {
        Objects.requireNonNull(data, "Null " + (encoded ? "encoded" : "decoded") + " data");
        if (!unfreeze) {
            this.checkFrozen();
        }
        long numberOfBits = 8L * (long)data.length;
        long numberOfPixels = numberOfBits / (long)this.bitsPerPixel;
        if (this.bitsPerPixel > 1) {
            if ((this.bitsPerPixel & 7) != 0) {
                throw new AssertionError((Object)("Unsupported bits per pixel " + this.bitsPerPixel));
            }
            int bytesPerPixel = this.bitsPerPixel >>> 3;
            assert (numberOfPixels == (long)(data.length / bytesPerPixel));
            if (checkAligned && !encoded && numberOfPixels * (long)bytesPerPixel != (long)data.length) {
                throw new IllegalArgumentException("Invalid length of decoded data " + data.length + " bytes, or " + numberOfBits + " bits: not a multiple of the bits-per-pixel " + this.bitsPerPixel + " = " + this.samplesPerPixel + " * " + this.bitsPerSample + " (channels per pixel * bits per channel sample), as if the last pixel is stored \"partially\"");
            }
        } else {
            assert (this.bitsPerPixel == 1) : "zero or negative bitsPerPixel = " + this.bitsPerPixel;
            long expectedNumberOfBytes = numberOfPixels + 7L >>> 3;
            assert (expectedNumberOfBytes == (long)data.length);
        }
        if (numberOfPixels > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot store " + numberOfPixels + " pixels: very large TIFF tiles >= 2^31 pixels are not supported");
        }
        this.data = data;
        this.estimatedNumberOfPixels = (int)numberOfPixels;
        this.encoded = encoded;
        if (unfreeze) {
            this.frozen = false;
        }
        return this;
    }

    private void initializeEmptyArea() {
        if (this.unsetArea == null) {
            this.unsetArea = new LinkedList<IRectangularArea>();
            this.unsetArea.add(this.actualRectangle());
        }
    }

    private void checkEmpty() {
        if (this.data == null) {
            this.checkFrozen();
            throw new IllegalStateException("TIFF tile is still not filled by any data: " + String.valueOf(this));
        }
    }

    private void checkFrozen() {
        if (this.frozen) {
            assert (this.isEmpty()) : "frozen tile must be empty";
            throw new IllegalStateException("TIFF tile is frozen, access to its data is prohibited: " + String.valueOf(this));
        }
    }

    private void checkOutsideMap() {
        if (this.index.fromX() >= this.map.dimX() || this.index.fromY() >= this.map.dimY()) {
            throw new IllegalStateException("Tile is fully outside the map dimensions " + this.map.dimX() + "x" + this.map.dimY() + ": " + String.valueOf(this));
        }
    }

    private void checkStoredFileOffset() {
        if (this.storedInFileDataOffset < 0L) {
            throw new IllegalStateException("File offset of the TIFF tile is not set yet: " + String.valueOf(this));
        }
    }
}

