/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tiles;

import java.io.IOException;
import java.util.Objects;
import net.algart.matrices.tiff.tiles.TiffTile;
import org.scijava.io.handle.DataHandle;

public class TiffTileIO {
    private static final boolean SMART_WRITING_TO_FILE_END = true;

    private TiffTileIO() {
    }

    public static void readAt(TiffTile tile, DataHandle<?> inputStream, long fileOffset, int dataLength) throws IOException {
        Objects.requireNonNull(tile, "Null tile");
        Objects.requireNonNull(inputStream, "Null input stream");
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("Negative file position to read data: " + fileOffset);
        }
        if (fileOffset == 0L) {
            throw new IllegalArgumentException("Zero file position to read data is not allowed for TIFF format");
        }
        if (dataLength < 0) {
            throw new IllegalArgumentException("Negative length of data to read: " + dataLength);
        }
        byte[] data = new byte[dataLength];
        inputStream.seek(fileOffset);
        int result = inputStream.read(data);
        if (result < data.length) {
            throw new IOException("File exhausted at " + fileOffset + ": loaded " + result + " bytes instead of " + data.length + " (" + String.valueOf(inputStream.get()) + ")");
        }
        tile.setStoredInFileDataRange(fileOffset, data.length, true);
        tile.setEncodedData(data, true);
        tile.markWholeTileAsSet();
    }

    public static void write(TiffTile tile, DataHandle<?> outputStream, boolean alwaysWriteToFileEnd, boolean strictlyRequire32Bit) throws IOException {
        Objects.requireNonNull(tile, "Null tile");
        if (alwaysWriteToFileEnd || !TiffTileIO.tryToWriteInPlace(tile, outputStream)) {
            TiffTileIO.writeAtEnd(tile, outputStream, strictlyRequire32Bit);
        }
    }

    public static void writeAtEnd(TiffTile tile, DataHandle<?> outputStream, boolean strictlyRequire32Bit) throws IOException {
        long fileOffset = TiffTileIO.offsetAtEnd(tile, outputStream, strictlyRequire32Bit);
        TiffTileIO.writeAt(tile, outputStream, fileOffset, true);
    }

    public static void writeAt(TiffTile tile, DataHandle<?> outputStream, long fileOffset, boolean resetCapacity) throws IOException {
        Objects.requireNonNull(tile, "Null tile");
        Objects.requireNonNull(outputStream, "Null output stream");
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("Negative file position to write data: " + fileOffset);
        }
        if (fileOffset == 0L) {
            throw new IllegalArgumentException("Zero file position to write data is not allowed in TIFF format");
        }
        byte[] encodedData = tile.getEncodedData();
        outputStream.seek(fileOffset);
        outputStream.write(encodedData);
        tile.setStoredInFileDataRange(fileOffset, encodedData.length, resetCapacity);
    }

    private static boolean tryToWriteInPlace(TiffTile tile, DataHandle<?> outputStream) throws IOException {
        if (!tile.isStoredInFile()) {
            return false;
        }
        long fileOffset = tile.getStoredInFileDataOffset();
        if (fileOffset + (long)tile.getStoredInFileDataLength() == outputStream.length()) {
            TiffTileIO.writeAt(tile, outputStream, fileOffset, true);
            outputStream.setLength(outputStream.offset());
            return true;
        }
        if (tile.getEncodedDataLength() <= tile.getStoredInFileDataCapacity()) {
            TiffTileIO.writeAt(tile, outputStream, fileOffset, false);
            return true;
        }
        return false;
    }

    private static long offsetAtEnd(TiffTile tile, DataHandle<?> outputStream, boolean strictlyRequire32Bit) throws IOException {
        Objects.requireNonNull(tile, "Null tile");
        Objects.requireNonNull(outputStream, "Null output stream");
        long length = outputStream.length();
        if (strictlyRequire32Bit && length > 0xFFFFFFF0L - (long)tile.getEncodedData().length) {
            throw new IOException("Attempt to write TIFF tile outside maximal allowed 32-bit file length 2^32-16 = 4294967280; such large files should be written in BigTIFF mode");
        }
        return length;
    }
}

