/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.function.Consumer;

public final class BytecodeSupport {
    private BytecodeSupport() {
    }

    public static final class CloneReferenceList<T> {
        private WeakReference<T>[] references = new WeakReference[4];
        private int size;

        public void add(T reference) {
            if (this.size >= this.references.length) {
                this.resize();
            }
            this.references[this.size++] = new WeakReference<T>(reference);
        }

        private void resize() {
            this.cleanup();
            if (this.size >= this.references.length) {
                this.references = Arrays.copyOf(this.references, this.references.length * 2);
            }
        }

        public void forEach(Consumer<T> forEach) {
            boolean needsCleanup = false;
            for (int index = 0; index < this.size; ++index) {
                Object ref = this.references[index].get();
                if (ref != null) {
                    forEach.accept(ref);
                    continue;
                }
                needsCleanup = true;
            }
            if (needsCleanup) {
                this.cleanup();
            }
        }

        private void cleanup() {
            Object[] refs = this.references;
            int newIndex = 0;
            int oldSize = this.size;
            for (int oldIndex = 0; oldIndex < oldSize; ++oldIndex) {
                WeakReference<T> ref = refs[oldIndex];
                Object referent = ref.get();
                if (referent == null) continue;
                if (newIndex != oldIndex) {
                    refs[newIndex] = ref;
                }
                ++newIndex;
            }
            Arrays.fill(refs, newIndex, oldSize, null);
            this.size = newIndex;
        }
    }
}

