/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;

public abstract class AbstractUpdatableBitArray
extends AbstractBitArray
implements UpdatableBitArray {
    protected AbstractUpdatableBitArray(long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(initialCapacity, initialLength, underlyingArraysAreParallel, underlyingArrays);
    }

    protected AbstractUpdatableBitArray(long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public UpdatableBitArray subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractUpdatableBitArray parent = this;
        final long offset = fromIndex;
        return new AbstractUpdatableBitArray(this, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public boolean getBit(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.getBit(offset + index);
            }

            @Override
            public void setBit(long index, boolean value) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                parent.setBit(offset + index, value);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, boolean value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
                if (count < 0L) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - count) {
                    throw this.rangeException(arrayPos + count - 1L);
                }
                parent.getBits(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public UpdatableBitArray setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
                if (count < 0L) {
                    throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - count) {
                    throw this.rangeException(arrayPos + count - 1L);
                }
                parent.setBits(offset + arrayPos, srcArray, srcArrayOffset, count);
                return this;
            }

            @Override
            public long nextQuickPosition(long from) {
                long p;
                long qp;
                if (from >= this.length) {
                    return -1L;
                }
                if (from < 0L) {
                    from = 0L;
                }
                if ((qp = parent.nextQuickPosition(p = offset + from)) == -1L) {
                    return -1L;
                }
                assert (qp >= p) : "illegal nextQuickPosition implementation in " + String.valueOf(parent);
                long result = from + (qp - p);
                return result >= this.length ? -1L : result;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.setData(offset + arrayPos, srcArray, srcArrayOffset, count);
                return this;
            }

            @Override
            public UpdatableBitArray fill(long position, long count, boolean value) {
                this.checkSubArrArguments(position, count);
                parent.fill(offset + position, count, value);
                return this;
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableBitArray subArr(long position, long count) {
        return this.subArray(position, position + count);
    }

    @Override
    public void setDouble(long index, double value) {
        this.setBit(index, value != 0.0);
    }

    @Override
    public void setLong(long index, long value) {
        this.setBit(index, value != 0L);
    }

    @Override
    public void setInt(long index, int value) {
        this.setBit(index, value != 0);
    }

    @Override
    public abstract void setBit(long var1, boolean var3);

    @Override
    public final UpdatableBitArray fill(double value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableBitArray fill(long position, long count, double value) {
        return this.fill(position, count, value != 0.0);
    }

    @Override
    public final UpdatableBitArray fill(long value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableBitArray fill(long position, long count, long value) {
        return this.fill(position, count, value != 0L);
    }

    @Override
    public final UpdatableBitArray fill(boolean value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableBitArray fill(long position, long count, boolean value) {
        UpdatableBitArray a = position == 0L && count == this.length() ? this : this.subArr(position, count);
        a.copy(Arrays.nBitCopies(count, value));
        return this;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public BitArray asImmutable() {
        final AbstractUpdatableBitArray parent = this;
        return new AbstractBitArray(this, this.length, false, this.underlyingArrays){

            @Override
            public boolean getBit(long index) {
                return parent.getBit(index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, boolean value) {
                return parent.indexOf(lowIndex, highIndex, value);
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
                return parent.lastIndexOf(lowIndex, highIndex, value);
            }

            @Override
            public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
                if (count < 0L) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - count) {
                    throw this.rangeException(arrayPos + count - 1L);
                }
                parent.getBits(arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public long nextQuickPosition(long from) {
                return parent.nextQuickPosition(from);
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                parent.getData(arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public void getData(long arrayPos, Object destArray) {
                parent.getData(arrayPos, destArray);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, fromIndex, toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableArray shallowClone() {
        return (UpdatableArray)super.shallowClone();
    }

    @Override
    public void setElement(long index, Object value) {
        this.setBit(index, (Boolean)value);
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        boolean[] a = (boolean[])srcArray;
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            this.setBit(arrayPos, a[srcArrayOffset]);
            ++arrayPos;
            ++srcArrayOffset;
        }
        return this;
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((boolean[])srcArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.setData(arrayPos, srcArray, 0, count);
        return this;
    }

    @Override
    public void copy(long destIndex, long srcIndex) {
        this.setBit(destIndex, this.getBit(srcIndex));
    }

    @Override
    public void copy(long destIndex, long srcIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        if (srcIndex <= destIndex && srcIndex + count > destIndex) {
            srcIndex += count;
            destIndex += count;
            for (long k = 0L; k < count; ++k) {
                this.copy(--destIndex, --srcIndex);
            }
        } else {
            for (long k = 0L; k < count; ++k) {
                this.copy(destIndex++, srcIndex++);
            }
        }
    }

    @Override
    public void swap(long firstIndex, long secondIndex) {
        boolean temp = this.getBit(firstIndex);
        this.setBit(firstIndex, this.getBit(secondIndex));
        this.setBit(secondIndex, temp);
    }

    @Override
    public void swap(long firstIndex, long secondIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        for (long k = 0L; k < count; ++k) {
            this.swap(firstIndex++, secondIndex++);
        }
    }

    @Override
    public UpdatableArray copy(Array src) {
        AbstractUpdatableBitArray.defaultCopy(this, src);
        return this;
    }

    @Override
    public UpdatableArray swap(UpdatableArray another) {
        AbstractUpdatableBitArray.defaultSwap(this, another);
        return this;
    }

    @Override
    public void setNonNew() {
        this.setNewStatus(false);
    }

    @Override
    public UpdatableArray asCopyOnNextWrite() {
        return this.updatableClone(Arrays.SMM);
    }

    @Override
    public UpdatableBitArray asUnresizable() {
        return this;
    }

    @Override
    public String toString() {
        return "unresizable AlgART array boolean[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }

    @Override
    public void setBit(long index) {
        this.setBit(index, true);
    }

    @Override
    public void clearBit(long index) {
        this.setBit(index, false);
    }

    @Override
    public void setBitNoSync(long index, boolean value) {
        this.setBit(index, value);
    }

    @Override
    public void setBitNoSync(long index) {
        this.setBitNoSync(index, true);
    }

    @Override
    public void clearBitNoSync(long index) {
        this.setBitNoSync(index, false);
    }

    @Override
    public UpdatableBitArray setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        if (count < 0L) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractUpdatableBitArray.rangeException(arrayPos, this.length, this.getClass());
        }
        if (arrayPos > this.length - count) {
            throw AbstractUpdatableBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
        }
        long arrayPosMax = arrayPos + count;
        while (arrayPos < arrayPosMax) {
            this.setBit(arrayPos, PackedBitArrays.getBit(srcArray, srcArrayOffset));
            ++arrayPos;
            ++srcArrayOffset;
        }
        return this;
    }
}

