/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.EmptyStackException;
import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.CopiesArraysImpl;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.DataObjectBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.MutableShortArray;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

class SimpleArraysImpl {
    private static final int MIN_COUNT_FOR_USING_DEFAULT_SWAP = 100;

    SimpleArraysImpl() {
    }

    static long[] cloneBitSubArray(long[] array, long fromIndex, long toIndex) {
        Objects.requireNonNull(array, "Null array argument in cloneBitSubArray method");
        if (fromIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: initial index = " + fromIndex);
        }
        if (toIndex > (long)array.length << 6) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: end index = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        long[] result = new long[(int)(toIndex - fromIndex + 63L >>> 6)];
        PackedBitArrays.copyBits(result, 0L, array, fromIndex, toIndex - fromIndex);
        return result;
    }

    static final class MutableJABitSubArray
    extends UpdatableJABitSubArray
    implements MutableBitArray {
        MutableJABitSubArray(long[] initialArray, long initialCapacity, long initialLength, long initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJABitSubArray(long[] initialArray, long initialCapacityAndLength, long initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJABitSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nBitCopies(toIndex - fromIndex, false), true);
        }

        @Override
        public MutableBitArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableBitArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableBitArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableBitArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popBit();
        }

        @Override
        public void pushElement(Object value) {
            this.pushBit((Boolean)value);
        }

        @Override
        public double popDouble() {
            return this.popBit() ? 1.0 : 0.0;
        }

        @Override
        public long popLong() {
            return this.popBit() ? 1L : 0L;
        }

        @Override
        public int popInt() {
            return this.popBit() ? 1 : 0;
        }

        @Override
        public void addDouble(double value) {
            this.pushBit(value != 0.0);
        }

        @Override
        public void addLong(long value) {
            this.pushBit(value != 0L);
        }

        @Override
        public void addInt(int value) {
            this.pushBit(value != 0);
        }

        @Override
        public boolean popBit() {
            long i = this.length - 1L;
            if (i < 0L) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            boolean result = (this.bitArray[(int)(this.offset + i >>> 6)] & 1L << ((int)(this.offset + i) & 0x3F)) != 0L;
            this.length = i;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushBit(boolean value) {
            long i = this.length;
            if (i >= this.capacity()) {
                this.ensureCapacityImpl(i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1L;
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if (value) {
                    int n = (int)(this.offset + i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)(this.offset + i) & 0x3F);
                } else {
                    int n = (int)(this.offset + i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)(this.offset + i) & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void removeTop() {
            long i = this.length - 1L;
            if (i < 0L) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableBitArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableBitArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableBitArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableBitArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableBitArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJABitSubArray result = new MutableJABitSubArray(this.bitArray, this.capacity(), this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableBitArray asUnresizable() {
            UpdatableJABitSubArray result = new UpdatableJABitSubArray(this.bitArray, this.capacity(), this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableBitArray shallowClone() {
            return (MutableBitArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray bit[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.bitArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJABitArray
    extends UpdatableJABitArray
    implements MutableBitArray {
        MutableJABitArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJABitArray(long[] initialArray, long initialCapacity, long initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJABitArray(long[] initialArray, long initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJABitArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nBitCopies(toIndex - fromIndex, false), true);
        }

        @Override
        public MutableBitArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableBitArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableBitArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableBitArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popBit();
        }

        @Override
        public void pushElement(Object value) {
            this.pushBit((Boolean)value);
        }

        @Override
        public double popDouble() {
            return this.popBit() ? 1.0 : 0.0;
        }

        @Override
        public long popLong() {
            return this.popBit() ? 1L : 0L;
        }

        @Override
        public int popInt() {
            return this.popBit() ? 1 : 0;
        }

        @Override
        public void addDouble(double value) {
            this.pushBit(value != 0.0);
        }

        @Override
        public void addLong(long value) {
            this.pushBit(value != 0L);
        }

        @Override
        public void addInt(int value) {
            this.pushBit(value != 0);
        }

        @Override
        public boolean popBit() {
            long i = this.length - 1L;
            if (i < 0L) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            boolean result = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
            this.length = i;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushBit(boolean value) {
            long i = this.length;
            if (i >= this.capacity()) {
                this.ensureCapacityImpl(i + 1L);
            }
            this.length = i + 1L;
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if (value) {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void removeTop() {
            long i = this.length - 1L;
            if (i < 0L) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableBitArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableBitArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableBitArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableBitArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableBitArray asCopyOnNextWrite() {
            MutableJABitSubArray result = new MutableJABitSubArray(this.bitArray, this.capacity(), this.length(), 0L);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableBitArray asUnresizable() {
            return new UpdatableJABitArray(this.bitArray, this.capacity(), this.length());
        }

        @Override
        public MutableBitArray shallowClone() {
            return (MutableBitArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array bit[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.bitArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJABitSubArray
    extends JABitSubArray
    implements UpdatableBitArray {
        UpdatableJABitSubArray(long[] initialArray, long initialCapacity, long initialLength, long initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJABitSubArray(long[] initialArray, long initialCapacityAndLength, long initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setBit(index, (Boolean)value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if ((this.bitArray[(int)(this.offset + srcIndex >>> 6)] & 1L << ((int)(this.offset + srcIndex) & 0x3F)) != 0L) {
                    int n = (int)(this.offset + destIndex >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)(this.offset + destIndex) & 0x3F);
                } else {
                    int n = (int)(this.offset + destIndex >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)(this.offset + destIndex) & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            PackedBitArrays.copyBits(this.bitArray, this.offset + destIndex, this.bitArray, this.offset + srcIndex, count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long i = this.offset + firstIndex;
            long j = this.offset + secondIndex;
            boolean temp = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if ((this.bitArray[(int)(j >>> 6)] & 1L << ((int)j & 0x3F)) != 0L) {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var10_6] (shouldn't be in output)
                lArray = this.bitArray;
                synchronized (this.bitArray) {
                    if (temp) {
                        int n = (int)(j >>> 6);
                        this.bitArray[n] = this.bitArray[n] | 1L << ((int)j & 0x3F);
                    } else {
                        int n = (int)(j >>> 6);
                        this.bitArray[n] = this.bitArray[n] & (1L << ((int)j & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    // ** MonitorExit[var10_6] (shouldn't be in output)
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long i = this.offset + firstIndex;
            long j = this.offset + secondIndex;
            long iMax = i + count;
            while (i < iMax) {
                boolean temp = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
                long[] lArray = this.bitArray;
                // MONITORENTER : this.bitArray
                if ((this.bitArray[(int)(j >>> 6)] & 1L << ((int)j & 0x3F)) != 0L) {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // MONITOREXIT : lArray
                lArray = this.bitArray;
                // MONITORENTER : this.bitArray
                if (temp) {
                    int n = (int)(j >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)j & 0x3F);
                } else {
                    int n = (int)(j >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)j & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // MONITOREXIT : lArray
                ++i;
                ++j;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UpdatableArray copy(Array src) {
            BitArray a;
            if (src instanceof JABitSubArray) {
                a = (JABitSubArray)src;
                long count = Math.min(a.length, this.length);
                if (count == 1L) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    long[] lArray = this.bitArray;
                    synchronized (this.bitArray) {
                        if ((a.bitArray[(int)(a.offset >>> 6)] & 1L << ((int)a.offset & 0x3F)) != 0L) {
                            int n = (int)(this.offset >>> 6);
                            this.bitArray[n] = this.bitArray[n] | 1L << ((int)this.offset & 0x3F);
                        } else {
                            int n = (int)(this.offset >>> 6);
                            this.bitArray[n] = this.bitArray[n] & (1L << ((int)this.offset & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                        }
                        // ** MonitorExit[var6_5] (shouldn't be in output)
                        return this;
                    }
                }
                if (count > 0L) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    PackedBitArrays.copyBits(this.bitArray, this.offset, a.bitArray, a.offset, count);
                    return this;
                }
            } else if (src instanceof JABitArray) {
                JABitArray a2 = (JABitArray)src;
                long count = Math.min(a2.length, this.length);
                if (count == 1L) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    long[] lArray = this.bitArray;
                    synchronized (this.bitArray) {
                        if ((a2.bitArray[0] & 1L) != 0L) {
                            int n = (int)(this.offset >>> 6);
                            this.bitArray[n] = this.bitArray[n] | 1L << ((int)this.offset & 0x3F);
                        } else {
                            int n = (int)(this.offset >>> 6);
                            this.bitArray[n] = this.bitArray[n] & (1L << ((int)this.offset & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                        }
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return this;
                    }
                }
                if (count > 0L) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    PackedBitArrays.copyBits(this.bitArray, this.offset, a2.bitArray, 0L, count);
                    return this;
                }
            }
            if (src instanceof CopiesArraysImpl.CopiesBitArray) {
                a = (CopiesArraysImpl.CopiesBitArray)src;
                long count = Math.min(((CopiesArraysImpl.CopiesBitArray)a).length, this.length);
                PackedBitArrays.fillBits(this.bitArray, this.longJavaArrayOffsetInternal(), count, ((CopiesArraysImpl.CopiesBitArray)a).element);
            } else {
                UpdatableJABitSubArray.defaultCopy(this, src);
            }
            return this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public UpdatableArray swap(UpdatableArray another) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setBit(index, value != 0.0);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setBit(index, value != 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if (value != 0) {
                    int n = (int)(this.offset + index >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)(this.offset + index) & 0x3F);
                } else {
                    int n = (int)(this.offset + index >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)(this.offset + index) & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setBit(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if (value) {
                    int n = (int)(this.offset + index >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)(this.offset + index) & 0x3F);
                } else {
                    int n = (int)(this.offset + index >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)(this.offset + index) & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                int n = (int)(this.offset + index >>> 6);
                this.bitArray[n] = this.bitArray[n] | 1L << (int)(this.offset + index & 0x3FL);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clearBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                int n = (int)(this.offset + index >>> 6);
                this.bitArray[n] = this.bitArray[n] & (1L << (int)(this.offset + index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        @Override
        public final void setBitNoSync(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            if (value) {
                int n = (int)(this.offset + index >>> 6);
                this.bitArray[n] = this.bitArray[n] | 1L << ((int)(this.offset + index) & 0x3F);
            } else {
                int n = (int)(this.offset + index >>> 6);
                this.bitArray[n] = this.bitArray[n] & (1L << ((int)(this.offset + index) & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        @Override
        public final void setBitNoSync(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int n = (int)(this.offset + index >>> 6);
            this.bitArray[n] = this.bitArray[n] | 1L << (int)(this.offset + index & 0x3FL);
        }

        @Override
        public final void clearBitNoSync(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int n = (int)(this.offset + index >>> 6);
            this.bitArray[n] = this.bitArray[n] & (1L << (int)(this.offset + index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBits64(long arrayPos, long bits, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                PackedBitArrays.setBits64Impl(this.bitArray, this.offset + arrayPos, bits, count);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void setBits64NoSync(long arrayPos, long bits, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            PackedBitArrays.setBits64Impl(this.bitArray, this.offset + arrayPos, bits, count);
        }

        @Override
        public UpdatableBitArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, double value) {
            return this.fill(position, count, value != 0.0);
        }

        @Override
        public UpdatableBitArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, long value) {
            return this.fill(position, count, value != 0L);
        }

        @Override
        public UpdatableBitArray fill(boolean value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, boolean value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            PackedBitArrays.fillBits(this.bitArray, this.offset + position, count, value);
            return this;
        }

        @Override
        public UpdatableBitArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJABitArray(this.bitArray, toIndex - fromIndex);
            }
            UpdatableJABitSubArray result = new UpdatableJABitSubArray(this.bitArray, toIndex - fromIndex, this.offset + fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableBitArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJABitArray(this.bitArray, count);
            }
            UpdatableJABitSubArray result = new UpdatableJABitSubArray(this.bitArray, count, this.offset + position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final BitArray asImmutable() {
            return new JABitSubArray(this.bitArray, this.capacity(), this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final BitArray asTrustedImmutable() {
            JABitSubArray result = new JABitSubArray(this.bitArray, this.capacity(), this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJABitSubArray result = new UpdatableJABitSubArray(this.bitArray, this.capacity(), this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableBitArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public boolean isPackedBitArrayWrapper() {
            return this.offset == 0L && this.length + 63L >>> 6 == (long)this.bitArray.length;
        }

        @Override
        public long[] jaBit() {
            if (this.isPackedBitArrayWrapper()) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.bitArray;
            }
            return this.toBit();
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray bit[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.bitArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJABitArray
    extends JABitArray
    implements UpdatableBitArray {
        UpdatableJABitArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJABitArray(long[] initialArray, long initialCapacity, long initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJABitArray(long[] initialArray, long initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setBit(index, (Boolean)value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if ((this.bitArray[(int)(srcIndex >>> 6)] & 1L << ((int)srcIndex & 0x3F)) != 0L) {
                    int n = (int)(destIndex >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)destIndex & 0x3F);
                } else {
                    int n = (int)(destIndex >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)destIndex & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            PackedBitArrays.copyBits(this.bitArray, destIndex, this.bitArray, srcIndex, count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            long i = firstIndex;
            long j = secondIndex;
            boolean temp = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if ((this.bitArray[(int)(j >>> 6)] & 1L << ((int)j & 0x3F)) != 0L) {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var10_6] (shouldn't be in output)
                lArray = this.bitArray;
                synchronized (this.bitArray) {
                    if (temp) {
                        int n = (int)(j >>> 6);
                        this.bitArray[n] = this.bitArray[n] | 1L << ((int)j & 0x3F);
                    } else {
                        int n = (int)(j >>> 6);
                        this.bitArray[n] = this.bitArray[n] & (1L << ((int)j & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    // ** MonitorExit[var10_6] (shouldn't be in output)
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            long i = firstIndex;
            long j = secondIndex;
            long iMax = i + count;
            while (i < iMax) {
                boolean temp = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
                long[] lArray = this.bitArray;
                // MONITORENTER : this.bitArray
                if ((this.bitArray[(int)(j >>> 6)] & 1L << ((int)j & 0x3F)) != 0L) {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // MONITOREXIT : lArray
                lArray = this.bitArray;
                // MONITORENTER : this.bitArray
                if (temp) {
                    int n = (int)(j >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)j & 0x3F);
                } else {
                    int n = (int)(j >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)j & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // MONITOREXIT : lArray
                ++i;
                ++j;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UpdatableArray copy(Array src) {
            BitArray a;
            if (src instanceof JABitSubArray) {
                a = (JABitSubArray)src;
                long count = Math.min(a.length, this.length);
                if (count == 1L) {
                    long[] lArray = this.bitArray;
                    synchronized (this.bitArray) {
                        this.bitArray[0] = (a.bitArray[(int)(a.offset >>> 6)] & 1L << ((int)a.offset & 0x3F)) != 0L ? this.bitArray[0] | 1L : this.bitArray[0] & 0xFFFFFFFFFFFFFFFEL;
                        // ** MonitorExit[var6_5] (shouldn't be in output)
                        return this;
                    }
                }
                if (count > 0L) {
                    PackedBitArrays.copyBits(this.bitArray, 0L, a.bitArray, a.offset, count);
                    return this;
                }
            } else if (src instanceof JABitArray) {
                JABitArray a2 = (JABitArray)src;
                long count = Math.min(a2.length, this.length);
                if (count > 0L) {
                    PackedBitArrays.copyBits(this.bitArray, 0L, a2.bitArray, 0L, count);
                }
                return this;
            }
            if (src instanceof CopiesArraysImpl.CopiesBitArray) {
                a = (CopiesArraysImpl.CopiesBitArray)src;
                long count = Math.min(((CopiesArraysImpl.CopiesBitArray)a).length, this.length);
                PackedBitArrays.fillBits(this.bitArray, this.longJavaArrayOffsetInternal(), count, ((CopiesArraysImpl.CopiesBitArray)a).element);
            } else {
                UpdatableJABitArray.defaultCopy(this, src);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public UpdatableArray swap(UpdatableArray another) {
            long count;
            UpdatableJABitArray a;
            block23: {
                long count2;
                UpdatableJABitSubArray a2;
                block22: {
                    block21: {
                        block20: {
                            if (!(another instanceof UpdatableJABitSubArray)) break block20;
                            a2 = (UpdatableJABitSubArray)another;
                            count2 = Math.min(a2.length, this.length);
                            if (count2 >= 100L) break block21;
                            break block22;
                        }
                        if (!(another instanceof UpdatableJABitArray)) break block21;
                        a = (UpdatableJABitArray)another;
                        count = Math.min(a.length, this.length);
                        if (count < 100L) break block23;
                    }
                    UpdatableJABitArray.defaultSwap(this, another);
                    return this;
                }
                long j = a2.offset;
                long i = 0L;
                while (i < count2) {
                    boolean temp = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
                    long[] lArray = this.bitArray;
                    // MONITORENTER : this.bitArray
                    if ((a2.bitArray[(int)(j >>> 6)] & 1L << ((int)j & 0x3F)) != 0L) {
                        int n = (int)(i >>> 6);
                        this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                    } else {
                        int n = (int)(i >>> 6);
                        this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    // MONITOREXIT : lArray
                    lArray = a2.bitArray;
                    // MONITORENTER : a2.bitArray
                    if (temp) {
                        int n = (int)(j >>> 6);
                        a2.bitArray[n] = a2.bitArray[n] | 1L << ((int)j & 0x3F);
                    } else {
                        int n = (int)(j >>> 6);
                        a2.bitArray[n] = a2.bitArray[n] & (1L << ((int)j & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    // MONITOREXIT : lArray
                    ++i;
                    ++j;
                }
                return this;
            }
            long i = 0L;
            while (i < count) {
                boolean temp = (this.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L;
                long[] lArray = this.bitArray;
                // MONITORENTER : this.bitArray
                if ((a.bitArray[(int)(i >>> 6)] & 1L << ((int)i & 0x3F)) != 0L) {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // MONITOREXIT : lArray
                lArray = a.bitArray;
                // MONITORENTER : a.bitArray
                if (temp) {
                    int n = (int)(i >>> 6);
                    a.bitArray[n] = a.bitArray[n] | 1L << ((int)i & 0x3F);
                } else {
                    int n = (int)(i >>> 6);
                    a.bitArray[n] = a.bitArray[n] & (1L << ((int)i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // MONITOREXIT : lArray
                ++i;
            }
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setBit(index, value != 0.0);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setBit(index, value != 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if (value != 0) {
                    int n = (int)(index >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)index & 0x3F);
                } else {
                    int n = (int)(index >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setBit(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                if (value) {
                    int n = (int)(index >>> 6);
                    this.bitArray[n] = this.bitArray[n] | 1L << ((int)index & 0x3F);
                } else {
                    int n = (int)(index >>> 6);
                    this.bitArray[n] = this.bitArray[n] & (1L << ((int)index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                int n = (int)(index >>> 6);
                this.bitArray[n] = this.bitArray[n] | 1L << (int)(index & 0x3FL);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clearBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                int n = (int)(index >>> 6);
                this.bitArray[n] = this.bitArray[n] & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        @Override
        public final void setBitNoSync(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (value) {
                int n = (int)(index >>> 6);
                this.bitArray[n] = this.bitArray[n] | 1L << ((int)index & 0x3F);
            } else {
                int n = (int)(index >>> 6);
                this.bitArray[n] = this.bitArray[n] & (1L << ((int)index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        @Override
        public final void setBitNoSync(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int n = (int)(index >>> 6);
            this.bitArray[n] = this.bitArray[n] | 1L << (int)(index & 0x3FL);
        }

        @Override
        public final void clearBitNoSync(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int n = (int)(index >>> 6);
            this.bitArray[n] = this.bitArray[n] & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBits64(long arrayPos, long bits, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            long[] lArray = this.bitArray;
            synchronized (this.bitArray) {
                PackedBitArrays.setBits64Impl(this.bitArray, arrayPos, bits, count);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void setBits64NoSync(long arrayPos, long bits, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            PackedBitArrays.setBits64Impl(this.bitArray, arrayPos, bits, count);
        }

        @Override
        public UpdatableBitArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, double value) {
            return this.fill(position, count, value != 0.0);
        }

        @Override
        public UpdatableBitArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, long value) {
            return this.fill(position, count, value != 0L);
        }

        @Override
        public UpdatableBitArray fill(boolean value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, boolean value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            PackedBitArrays.fillBits(this.bitArray, position, count, value);
            return this;
        }

        @Override
        public UpdatableBitArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJABitArray(this.bitArray, toIndex - fromIndex);
            }
            return new UpdatableJABitSubArray(this.bitArray, toIndex - fromIndex, fromIndex);
        }

        @Override
        public UpdatableBitArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJABitArray(this.bitArray, count);
            }
            return new UpdatableJABitSubArray(this.bitArray, count, position);
        }

        @Override
        public final BitArray asImmutable() {
            return new JABitArray(this.bitArray, this.capacity(), this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final BitArray asTrustedImmutable() {
            return new JABitArray(this.bitArray, this.capacity(), this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJABitSubArray result = new UpdatableJABitSubArray(this.bitArray, this.capacity(), this.length(), 0L);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableBitArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public boolean isPackedBitArrayWrapper() {
            return this.length + 63L >>> 6 == (long)this.bitArray.length;
        }

        @Override
        public long[] jaBit() {
            if (this.isPackedBitArrayWrapper()) {
                return this.bitArray;
            }
            return this.toBit();
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array bit[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.bitArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JABitSubArray
    extends AbstractJAArray
    implements BitArray {
        long[] bitArray;
        long offset;

        JABitSubArray(long[] initialArray, long initialCapacity, long initialLength, long initialOffset) {
            super(initialArray, initialCapacity, initialLength);
            this.bitArray = initialArray;
            this.offset = initialOffset;
        }

        JABitSubArray(long[] initialArray, long initialCapacityAndLength, long initialOffset) {
            super(initialArray, initialCapacityAndLength);
            this.bitArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.bitArray = (long[])this.array;
            this.offset = 0L;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            throw new AssertionError((Object)"Internal error in package implementation: unallowed accessing javaArrayOffsetInternal() for bit array");
        }

        @Override
        public final Class<?> elementType() {
            return Boolean.TYPE;
        }

        @Override
        public Class<? extends BitArray> type() {
            return BitArray.class;
        }

        @Override
        public Class<? extends UpdatableBitArray> updatableType() {
            return UpdatableBitArray.class;
        }

        @Override
        public Class<? extends MutableBitArray> mutableType() {
            return MutableBitArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getBit(index);
        }

        @Override
        public final long bitsPerElement() {
            return 1L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 1L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(this.offset + index >>> 6)] & 1L << ((int)(this.offset + index) & 0x3F)) != 0L ? 1.0 : 0.0;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.indexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.lastIndexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(this.offset + index >>> 6)] & 1L << ((int)(this.offset + index) & 0x3F)) != 0L ? 1L : 0L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(this.offset + index >>> 6)] & 1L << ((int)(this.offset + index) & 0x3F)) != 0L ? 1 : 0;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.indexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.lastIndexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public final boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(this.offset + index >>> 6)] & 1L << ((int)(this.offset + index) & 0x3F)) != 0L;
        }

        @Override
        public final long getBits64(long arrayPos, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            return PackedBitArrays.getBits64Impl(this.bitArray, this.offset + arrayPos, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = PackedBitArrays.indexOfBit(this.bitArray, this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = PackedBitArrays.lastIndexOfBit(this.bitArray, this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (this.offset + fromIndex == 0L) {
                return new JABitArray(this.bitArray, toIndex - fromIndex);
            }
            return new JABitSubArray(this.bitArray, toIndex - fromIndex, this.offset + fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.offset + position == 0L) {
                return new JABitArray(this.bitArray, count);
            }
            return new JABitSubArray(this.bitArray, count, this.offset + position);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataBitBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataBitBuffer)super.buffer(mode);
        }

        @Override
        public DataBitBuffer buffer(long capacity) {
            return (DataBitBuffer)super.buffer(capacity);
        }

        @Override
        public DataBitBuffer buffer() {
            return (DataBitBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public BitArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public BitArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableBitArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableBitArray)new MutableJABitArray(SimpleArraysImpl.cloneBitSubArray(this.bitArray, this.offset, this.offset + this.length), this.length).setNewStatus();
            }
            return (MutableBitArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableBitArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableBitArray)new UpdatableJABitArray(SimpleArraysImpl.cloneBitSubArray(this.bitArray, this.offset, this.offset + this.length), this.length).setNewStatus();
            }
            return (UpdatableBitArray)super.updatableClone(memoryModel);
        }

        @Override
        public boolean[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray bit[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.bitArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JABitArray
    extends AbstractJAArray
    implements BitArray {
        long[] bitArray;

        JABitArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.bitArray = (long[])this.array;
        }

        JABitArray(long[] initialArray, long initialCapacity, long initialLength) {
            super(initialArray, initialCapacity, initialLength);
            this.bitArray = initialArray;
        }

        JABitArray(long[] initialArray, long initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            this.bitArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.bitArray = (long[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            throw new AssertionError((Object)"Internal error in package implementation: unallowed accessing javaArrayOffsetInternal() for bit array");
        }

        @Override
        public final Class<?> elementType() {
            return Boolean.TYPE;
        }

        @Override
        public Class<? extends BitArray> type() {
            return BitArray.class;
        }

        @Override
        public Class<? extends UpdatableBitArray> updatableType() {
            return UpdatableBitArray.class;
        }

        @Override
        public Class<? extends MutableBitArray> mutableType() {
            return MutableBitArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getBit(index);
        }

        @Override
        public final long bitsPerElement() {
            return 1L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 1L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(index >>> 6)] & 1L << ((int)index & 0x3F)) != 0L ? 1.0 : 0.0;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.indexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.lastIndexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(index >>> 6)] & 1L << ((int)index & 0x3F)) != 0L ? 1L : 0L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(index >>> 6)] & 1L << ((int)index & 0x3F)) != 0L ? 1 : 0;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.indexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.lastIndexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public final boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (this.bitArray[(int)(index >>> 6)] & 1L << ((int)index & 0x3F)) != 0L;
        }

        @Override
        public final long getBits64(long arrayPos, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            return PackedBitArrays.getBits64Impl(this.bitArray, arrayPos, count);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return PackedBitArrays.indexOfBit(this.bitArray, lowIndex, highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return PackedBitArrays.lastIndexOfBit(this.bitArray, lowIndex, highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JABitArray(this.bitArray, toIndex - fromIndex);
            }
            return new JABitSubArray(this.bitArray, toIndex - fromIndex, fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JABitArray(this.bitArray, count);
            }
            return new JABitSubArray(this.bitArray, count, position);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataBitBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataBitBuffer)super.buffer(mode);
        }

        @Override
        public DataBitBuffer buffer(long capacity) {
            return (DataBitBuffer)super.buffer(capacity);
        }

        @Override
        public DataBitBuffer buffer() {
            return (DataBitBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public BitArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public BitArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableBitArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableBitArray)new MutableJABitArray(SimpleArraysImpl.cloneBitSubArray(this.bitArray, 0L, this.length), this.length).setNewStatus();
            }
            return (MutableBitArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableBitArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableBitArray)new UpdatableJABitArray(SimpleArraysImpl.cloneBitSubArray(this.bitArray, 0L, this.length), this.length).setNewStatus();
            }
            return (UpdatableBitArray)super.updatableClone(memoryModel);
        }

        @Override
        public boolean[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array bit[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.bitArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAObjectSubArray
    extends UpdatableJAObjectSubArray
    implements MutableObjectArray {
        MutableJAObjectSubArray(Object[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJAObjectSubArray(Object[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAObjectSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nObjectCopies(toIndex - fromIndex, null), true);
        }

        @Override
        public MutableObjectArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableObjectArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableObjectArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableObjectArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            Object result = this.objectArray[this.offset + i];
            this.length = i;
            this.objectArray[this.offset + i] = null;
            return result;
        }

        @Override
        public void pushElement(Object value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.objectArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            this.popElement();
        }

        @Override
        public MutableObjectArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableObjectArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableObjectArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableObjectArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableObjectArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJAObjectSubArray result = new MutableJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public MutableObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableObjectArray asUnresizable() {
            UpdatableJAObjectSubArray result = new UpdatableJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableObjectArray shallowClone() {
            return (MutableObjectArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAObjectArray
    extends UpdatableJAObjectArray
    implements MutableObjectArray {
        MutableJAObjectArray(Class<?> elementType, long initialCapacity, long initialLength) {
            super(elementType, initialCapacity, initialLength);
        }

        MutableJAObjectArray(Object[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJAObjectArray(Object[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAObjectArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nObjectCopies(toIndex - fromIndex, null), true);
        }

        @Override
        public MutableObjectArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableObjectArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableObjectArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableObjectArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            Object result = this.objectArray[i];
            this.length = i;
            this.objectArray[i] = null;
            return result;
        }

        @Override
        public void pushElement(Object value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.objectArray[i] = value;
        }

        @Override
        public void removeTop() {
            this.popElement();
        }

        @Override
        public MutableObjectArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableObjectArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableObjectArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableObjectArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableObjectArray asCopyOnNextWrite() {
            MutableJAObjectSubArray result = new MutableJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public MutableObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableObjectArray asUnresizable() {
            return new UpdatableJAObjectArray(this.objectArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableObjectArray shallowClone() {
            return (MutableObjectArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAObjectSubArray
    extends TrustedJAObjectSubArray
    implements UpdatableObjectArray {
        UpdatableJAObjectSubArray(Object[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJAObjectSubArray(Object[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.objectArray[this.offset + (int)destIndex] = this.objectArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.objectArray, this.offset + (int)srcIndex, this.objectArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            Object temp = this.objectArray[i];
            this.objectArray[i] = this.objectArray[j];
            this.objectArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                Object temp = this.objectArray[i];
                this.objectArray[i] = this.objectArray[j];
                this.objectArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAObjectSubArray) {
                JAObjectSubArray a = (JAObjectSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.objectArray[this.offset] = a.objectArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.objectArray, a.offset, this.objectArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JAObjectArray) {
                JAObjectArray a = (JAObjectArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.objectArray[this.offset] = a.objectArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.objectArray, 0, this.objectArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJAObjectSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAObjectSubArray) {
                UpdatableJAObjectSubArray a = (UpdatableJAObjectSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        Object temp = this.objectArray[i];
                        this.objectArray[i] = a.objectArray[j];
                        a.objectArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAObjectArray) {
                UpdatableJAObjectArray a = (UpdatableJAObjectArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        Object temp = this.objectArray[i];
                        this.objectArray[i] = a.objectArray[j];
                        a.objectArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJAObjectSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setElement(long index, Object value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.objectArray[this.offset + (int)index] = value;
        }

        public UpdatableObjectArray fill(Object value) {
            return this.fill(0L, this.length, value);
        }

        public UpdatableObjectArray fill(long position, long count, Object value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillObjectArray(this.objectArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableObjectArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJAObjectArray(this.objectArray, (int)(toIndex - fromIndex));
            }
            UpdatableJAObjectSubArray result = new UpdatableJAObjectSubArray(this.objectArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableObjectArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJAObjectArray(this.objectArray, (int)count);
            }
            UpdatableJAObjectSubArray result = new UpdatableJAObjectSubArray(this.objectArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final ObjectArray asImmutable() {
            return new JAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final ObjectArray asTrustedImmutable() {
            TrustedJAObjectSubArray result = new TrustedJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJAObjectSubArray result = new UpdatableJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public UpdatableObjectArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAObjectArray
    extends TrustedJAObjectArray
    implements UpdatableObjectArray {
        UpdatableJAObjectArray(Class<?> elementType, long initialCapacity, long initialLength) {
            super(elementType, initialCapacity, initialLength);
        }

        UpdatableJAObjectArray(Object[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJAObjectArray(Object[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.objectArray[(int)destIndex] = this.objectArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.objectArray, (int)srcIndex, this.objectArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            Object temp = this.objectArray[i];
            this.objectArray[i] = this.objectArray[j];
            this.objectArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                Object temp = this.objectArray[i];
                this.objectArray[i] = this.objectArray[j];
                this.objectArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAObjectSubArray) {
                JAObjectSubArray a = (JAObjectSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.objectArray[0] = a.objectArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.objectArray, a.offset, this.objectArray, 0, count);
                    return this;
                }
            } else if (src instanceof JAObjectArray) {
                JAObjectArray a = (JAObjectArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.objectArray, 0, this.objectArray, 0, count);
                }
                return this;
            }
            UpdatableJAObjectArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAObjectSubArray) {
                UpdatableJAObjectSubArray a = (UpdatableJAObjectSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        Object temp = this.objectArray[i];
                        this.objectArray[i] = a.objectArray[j];
                        a.objectArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAObjectArray) {
                UpdatableJAObjectArray a = (UpdatableJAObjectArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        Object temp = this.objectArray[i];
                        this.objectArray[i] = a.objectArray[i];
                        a.objectArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJAObjectArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setElement(long index, Object value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.objectArray[(int)index] = value;
        }

        public UpdatableObjectArray fill(Object value) {
            return this.fill(0L, this.length, value);
        }

        public UpdatableObjectArray fill(long position, long count, Object value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillObjectArray(this.objectArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableObjectArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJAObjectArray(this.objectArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJAObjectSubArray(this.objectArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableObjectArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJAObjectArray(this.objectArray, (int)count);
            }
            return new UpdatableJAObjectSubArray(this.objectArray, (int)count, (int)position);
        }

        @Override
        public final ObjectArray asImmutable() {
            return new JAObjectArray(this.objectArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final ObjectArray asTrustedImmutable() {
            return new TrustedJAObjectArray(this.objectArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJAObjectSubArray result = new UpdatableJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public UpdatableObjectArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAObjectSubArray
    extends JAObjectSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAObjectSubArray(Object[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAObjectSubArray(Object[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.objectArray.length;
        }

        @Override
        public Object[] ja() {
            if (this.offset == 0 && this.length == (long)this.objectArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.objectArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJAObjectArray(this.objectArray, (int)(toIndex - fromIndex));
            }
            TrustedJAObjectSubArray result = new TrustedJAObjectSubArray(this.objectArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJAObjectArray(this.objectArray, (int)count);
            }
            TrustedJAObjectSubArray result = new TrustedJAObjectSubArray(this.objectArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public ObjectArray asImmutable() {
            return new JAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJAObjectSubArray result = new TrustedJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public ObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAObjectArray
    extends JAObjectArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAObjectArray(Class<?> elementType, long initialCapacity, long initialLength) {
            super(elementType, initialCapacity, initialLength);
        }

        TrustedJAObjectArray(Object[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAObjectArray(Object[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.objectArray.length;
        }

        @Override
        public Object[] ja() {
            if (this.length == (long)this.objectArray.length) {
                return this.objectArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJAObjectArray(this.objectArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJAObjectSubArray(this.objectArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJAObjectArray(this.objectArray, (int)count);
            }
            return new TrustedJAObjectSubArray(this.objectArray, (int)count, (int)position);
        }

        @Override
        public ObjectArray asImmutable() {
            return new JAObjectArray(this.objectArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJAObjectSubArray result = new TrustedJAObjectSubArray(this.objectArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public ObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAObjectSubArray
    extends AbstractJAArray
    implements ObjectArray {
        Object[] objectArray;
        final Class<?> elementType;
        int offset;

        JAObjectSubArray(Object[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.objectArray = initialArray;
            this.offset = initialOffset;
            this.elementType = initialArray.getClass().getComponentType();
        }

        JAObjectSubArray(Object[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.objectArray = initialArray;
            this.offset = initialOffset;
            this.elementType = initialArray.getClass().getComponentType();
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.objectArray = (Object[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return this.elementType;
        }

        public Class<? extends ObjectArray> type() {
            return ObjectArray.class;
        }

        public Class<? extends UpdatableObjectArray> updatableType() {
            return UpdatableObjectArray.class;
        }

        public Class<? extends MutableObjectArray> mutableType() {
            return MutableObjectArray.class;
        }

        public final long bitsPerElement() {
            return -1L;
        }

        public double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public long minPossibleValue() {
            return -157777L;
        }

        public long maxPossibleValue() {
            return 157778L;
        }

        @Override
        public final Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.objectArray[this.offset + (int)index];
        }

        public long indexOf(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfObject(this.objectArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        public long lastIndexOf(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfObject(this.objectArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JAObjectArray(this.objectArray, (int)(toIndex - fromIndex));
            }
            return new JAObjectSubArray(this.objectArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JAObjectArray(this.objectArray, (int)count);
            }
            return new JAObjectSubArray(this.objectArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataObjectBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataObjectBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataObjectBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataObjectBuffer)super.buffer(mode);
        }

        @Override
        public DataObjectBuffer buffer(long capacity) {
            return (DataObjectBuffer)super.buffer(capacity);
        }

        @Override
        public DataObjectBuffer buffer() {
            return (DataObjectBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ObjectArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public ObjectArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        public ObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public final MutableObjectArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableObjectArray)new MutableJAObjectArray((Object[])JArrays.copyOfRange(this.objectArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableObjectArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableObjectArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableObjectArray)new UpdatableJAObjectArray((Object[])JArrays.copyOfRange(this.objectArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableObjectArray)super.updatableClone(memoryModel);
        }

        public Object[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray " + this.elementType.getName() + "[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAObjectArray
    extends AbstractJAArray
    implements ObjectArray {
        Object[] objectArray;
        final Class<?> elementType;

        JAObjectArray(Class<?> elementType, long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.elementType = elementType;
            this.array = this.allocateArray(initialCapacity);
            this.objectArray = (Object[])this.array;
        }

        JAObjectArray(Object[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.objectArray = initialArray;
            this.elementType = initialArray.getClass().getComponentType();
        }

        JAObjectArray(Object[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.objectArray = initialArray;
            this.elementType = initialArray.getClass().getComponentType();
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.objectArray = (Object[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return this.elementType;
        }

        public Class<? extends ObjectArray> type() {
            return ObjectArray.class;
        }

        public Class<? extends UpdatableObjectArray> updatableType() {
            return UpdatableObjectArray.class;
        }

        public Class<? extends MutableObjectArray> mutableType() {
            return MutableObjectArray.class;
        }

        public final long bitsPerElement() {
            return -1L;
        }

        public final double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public final double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public final long minPossibleValue() {
            return -157777L;
        }

        public final long maxPossibleValue() {
            return 157778L;
        }

        @Override
        public final Object getElement(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.objectArray[(int)index];
        }

        public final long indexOf(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfObject(this.objectArray, (int)lowIndex, (int)highIndex, value);
        }

        public final long lastIndexOf(long lowIndex, long highIndex, Object value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfObject(this.objectArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JAObjectArray(this.objectArray, (int)(toIndex - fromIndex));
            }
            return new JAObjectSubArray(this.objectArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JAObjectArray(this.objectArray, (int)count);
            }
            return new JAObjectSubArray(this.objectArray, (int)count, (int)position);
        }

        @Override
        public DataObjectBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataObjectBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataObjectBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataObjectBuffer)super.buffer(mode);
        }

        @Override
        public DataObjectBuffer buffer(long capacity) {
            return (DataObjectBuffer)super.buffer(capacity);
        }

        @Override
        public DataObjectBuffer buffer() {
            return (DataObjectBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ObjectArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public ObjectArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        public ObjectArray cast(Class elementType) {
            Class desiredType = (Class)InternalUtils.cast(elementType);
            if (!desiredType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return this;
        }

        @Override
        public final MutableObjectArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableObjectArray)new MutableJAObjectArray((Object[])JArrays.copyOfRange(this.objectArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableObjectArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableObjectArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableObjectArray)new UpdatableJAObjectArray((Object[])JArrays.copyOfRange(this.objectArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableObjectArray)super.updatableClone(memoryModel);
        }

        public Object[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array " + this.elementType.getName() + "[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.objectArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJADoubleSubArray
    extends UpdatableJADoubleSubArray
    implements MutableDoubleArray {
        MutableJADoubleSubArray(double[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJADoubleSubArray(double[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJADoubleSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nDoubleCopies(toIndex - fromIndex, 0.0), true);
        }

        @Override
        public MutableDoubleArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableDoubleArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableDoubleArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableDoubleArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popDouble();
        }

        @Override
        public void pushElement(Object value) {
            this.pushDouble((Double)value);
        }

        public long popLong() {
            return (long)this.popDouble();
        }

        public int popInt() {
            return (int)this.popDouble();
        }

        @Override
        public void addDouble(double value) {
            this.pushDouble(value);
        }

        @Override
        public void addLong(long value) {
            this.pushDouble(value);
        }

        @Override
        public void addInt(int value) {
            this.pushDouble(value);
        }

        @Override
        public double popDouble() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            double result = this.doubleArray[this.offset + i];
            this.length = i;
            this.doubleArray[this.offset + i] = 0.0;
            return result;
        }

        @Override
        public void pushDouble(double value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.doubleArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableDoubleArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableDoubleArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableDoubleArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableDoubleArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableDoubleArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJADoubleSubArray result = new MutableJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableDoubleArray asUnresizable() {
            UpdatableJADoubleSubArray result = new UpdatableJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableDoubleArray shallowClone() {
            return (MutableDoubleArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJADoubleArray
    extends UpdatableJADoubleArray
    implements MutableDoubleArray {
        MutableJADoubleArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJADoubleArray(double[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJADoubleArray(double[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJADoubleArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nDoubleCopies(toIndex - fromIndex, 0.0), true);
        }

        @Override
        public MutableDoubleArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableDoubleArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableDoubleArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableDoubleArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popDouble();
        }

        @Override
        public void pushElement(Object value) {
            this.pushDouble((Double)value);
        }

        public long popLong() {
            return (long)this.popDouble();
        }

        public int popInt() {
            return (int)this.popDouble();
        }

        @Override
        public void addDouble(double value) {
            this.pushDouble(value);
        }

        @Override
        public void addLong(long value) {
            this.pushDouble(value);
        }

        @Override
        public void addInt(int value) {
            this.pushDouble(value);
        }

        @Override
        public double popDouble() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            double result = this.doubleArray[i];
            this.length = i;
            this.doubleArray[i] = 0.0;
            return result;
        }

        @Override
        public void pushDouble(double value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.doubleArray[i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableDoubleArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableDoubleArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableDoubleArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableDoubleArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableDoubleArray asCopyOnNextWrite() {
            MutableJADoubleSubArray result = new MutableJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableDoubleArray asUnresizable() {
            return new UpdatableJADoubleArray(this.doubleArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableDoubleArray shallowClone() {
            return (MutableDoubleArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJADoubleSubArray
    extends TrustedJADoubleSubArray
    implements UpdatableDoubleArray {
        UpdatableJADoubleSubArray(double[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJADoubleSubArray(double[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setDouble(index, (Double)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.doubleArray[this.offset + (int)destIndex] = this.doubleArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.doubleArray, this.offset + (int)srcIndex, this.doubleArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            double temp = this.doubleArray[i];
            this.doubleArray[i] = this.doubleArray[j];
            this.doubleArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                double temp = this.doubleArray[i];
                this.doubleArray[i] = this.doubleArray[j];
                this.doubleArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JADoubleSubArray) {
                JADoubleSubArray a = (JADoubleSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.doubleArray[this.offset] = a.doubleArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.doubleArray, a.offset, this.doubleArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JADoubleArray) {
                JADoubleArray a = (JADoubleArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.doubleArray[this.offset] = a.doubleArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.doubleArray, 0, this.doubleArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJADoubleSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJADoubleSubArray) {
                UpdatableJADoubleSubArray a = (UpdatableJADoubleSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        double temp = this.doubleArray[i];
                        this.doubleArray[i] = a.doubleArray[j];
                        a.doubleArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJADoubleArray) {
                UpdatableJADoubleArray a = (UpdatableJADoubleArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        double temp = this.doubleArray[i];
                        this.doubleArray[i] = a.doubleArray[j];
                        a.doubleArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJADoubleSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setLong(long index, long value) {
            this.setDouble(index, value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.doubleArray[this.offset + (int)index] = value;
        }

        @Override
        public final void setDouble(long index, double value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.doubleArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableDoubleArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, long value) {
            return this.fill(position, count, (double)value);
        }

        @Override
        public UpdatableDoubleArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, double value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillDoubleArray(this.doubleArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableDoubleArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJADoubleArray(this.doubleArray, (int)(toIndex - fromIndex));
            }
            UpdatableJADoubleSubArray result = new UpdatableJADoubleSubArray(this.doubleArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableDoubleArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJADoubleArray(this.doubleArray, (int)count);
            }
            UpdatableJADoubleSubArray result = new UpdatableJADoubleSubArray(this.doubleArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final DoubleArray asImmutable() {
            return new JADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final DoubleArray asTrustedImmutable() {
            TrustedJADoubleSubArray result = new TrustedJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJADoubleSubArray result = new UpdatableJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableDoubleArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJADoubleArray
    extends TrustedJADoubleArray
    implements UpdatableDoubleArray {
        UpdatableJADoubleArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJADoubleArray(double[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJADoubleArray(double[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setDouble(index, (Double)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.doubleArray[(int)destIndex] = this.doubleArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.doubleArray, (int)srcIndex, this.doubleArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            double temp = this.doubleArray[i];
            this.doubleArray[i] = this.doubleArray[j];
            this.doubleArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                double temp = this.doubleArray[i];
                this.doubleArray[i] = this.doubleArray[j];
                this.doubleArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JADoubleSubArray) {
                JADoubleSubArray a = (JADoubleSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.doubleArray[0] = a.doubleArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.doubleArray, a.offset, this.doubleArray, 0, count);
                    return this;
                }
            } else if (src instanceof JADoubleArray) {
                JADoubleArray a = (JADoubleArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.doubleArray, 0, this.doubleArray, 0, count);
                }
                return this;
            }
            UpdatableJADoubleArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJADoubleSubArray) {
                UpdatableJADoubleSubArray a = (UpdatableJADoubleSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        double temp = this.doubleArray[i];
                        this.doubleArray[i] = a.doubleArray[j];
                        a.doubleArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJADoubleArray) {
                UpdatableJADoubleArray a = (UpdatableJADoubleArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        double temp = this.doubleArray[i];
                        this.doubleArray[i] = a.doubleArray[i];
                        a.doubleArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJADoubleArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setLong(long index, long value) {
            this.setDouble(index, value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.doubleArray[(int)index] = value;
        }

        @Override
        public final void setDouble(long index, double value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.doubleArray[(int)index] = value;
        }

        @Override
        public UpdatableDoubleArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, long value) {
            return this.fill(position, count, (double)value);
        }

        @Override
        public UpdatableDoubleArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, double value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillDoubleArray(this.doubleArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableDoubleArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJADoubleArray(this.doubleArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJADoubleSubArray(this.doubleArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableDoubleArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJADoubleArray(this.doubleArray, (int)count);
            }
            return new UpdatableJADoubleSubArray(this.doubleArray, (int)count, (int)position);
        }

        @Override
        public final DoubleArray asImmutable() {
            return new JADoubleArray(this.doubleArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final DoubleArray asTrustedImmutable() {
            return new TrustedJADoubleArray(this.doubleArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJADoubleSubArray result = new UpdatableJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableDoubleArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJADoubleSubArray
    extends JADoubleSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJADoubleSubArray(double[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJADoubleSubArray(double[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.doubleArray.length;
        }

        @Override
        public double[] ja() {
            if (this.offset == 0 && this.length == (long)this.doubleArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.doubleArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJADoubleArray(this.doubleArray, (int)(toIndex - fromIndex));
            }
            TrustedJADoubleSubArray result = new TrustedJADoubleSubArray(this.doubleArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJADoubleArray(this.doubleArray, (int)count);
            }
            TrustedJADoubleSubArray result = new TrustedJADoubleSubArray(this.doubleArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public DoubleArray asImmutable() {
            return new JADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJADoubleSubArray result = new TrustedJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJADoubleArray
    extends JADoubleArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJADoubleArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJADoubleArray(double[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJADoubleArray(double[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.doubleArray.length;
        }

        @Override
        public double[] ja() {
            if (this.length == (long)this.doubleArray.length) {
                return this.doubleArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJADoubleArray(this.doubleArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJADoubleSubArray(this.doubleArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJADoubleArray(this.doubleArray, (int)count);
            }
            return new TrustedJADoubleSubArray(this.doubleArray, (int)count, (int)position);
        }

        @Override
        public DoubleArray asImmutable() {
            return new JADoubleArray(this.doubleArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJADoubleSubArray result = new TrustedJADoubleSubArray(this.doubleArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JADoubleSubArray
    extends AbstractJAArray
    implements DoubleArray {
        double[] doubleArray;
        int offset;

        JADoubleSubArray(double[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.doubleArray = initialArray;
            this.offset = initialOffset;
        }

        JADoubleSubArray(double[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.doubleArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.doubleArray = (double[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Double.TYPE;
        }

        @Override
        public Class<? extends DoubleArray> type() {
            return DoubleArray.class;
        }

        @Override
        public Class<? extends UpdatableDoubleArray> updatableType() {
            return UpdatableDoubleArray.class;
        }

        @Override
        public Class<? extends MutableDoubleArray> mutableType() {
            return MutableDoubleArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getDouble(index);
        }

        @Override
        public final long bitsPerElement() {
            return 64L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public long minPossibleValue() {
            return -157777L;
        }

        public long maxPossibleValue() {
            return 157778L;
        }

        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (long)this.doubleArray[this.offset + (int)index];
        }

        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (int)this.doubleArray[this.offset + (int)index];
        }

        public final long indexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.indexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.lastIndexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.doubleArray[this.offset + (int)index];
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfDouble(this.doubleArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfDouble(this.doubleArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JADoubleArray(this.doubleArray, (int)(toIndex - fromIndex));
            }
            return new JADoubleSubArray(this.doubleArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JADoubleArray(this.doubleArray, (int)count);
            }
            return new JADoubleSubArray(this.doubleArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataDoubleBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataDoubleBuffer)super.buffer(mode);
        }

        @Override
        public DataDoubleBuffer buffer(long capacity) {
            return (DataDoubleBuffer)super.buffer(capacity);
        }

        @Override
        public DataDoubleBuffer buffer() {
            return (DataDoubleBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public DoubleArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public DoubleArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableDoubleArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableDoubleArray)new MutableJADoubleArray(JArrays.copyOfRange(this.doubleArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableDoubleArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableDoubleArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableDoubleArray)new UpdatableJADoubleArray(JArrays.copyOfRange(this.doubleArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableDoubleArray)super.updatableClone(memoryModel);
        }

        @Override
        public double[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray double[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JADoubleArray
    extends AbstractJAArray
    implements DoubleArray {
        double[] doubleArray;

        JADoubleArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.doubleArray = (double[])this.array;
        }

        JADoubleArray(double[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.doubleArray = initialArray;
        }

        JADoubleArray(double[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.doubleArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.doubleArray = (double[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Double.TYPE;
        }

        @Override
        public Class<? extends DoubleArray> type() {
            return DoubleArray.class;
        }

        @Override
        public Class<? extends UpdatableDoubleArray> updatableType() {
            return UpdatableDoubleArray.class;
        }

        @Override
        public Class<? extends MutableDoubleArray> mutableType() {
            return MutableDoubleArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getDouble(index);
        }

        @Override
        public final long bitsPerElement() {
            return 64L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public final long minPossibleValue() {
            return -157777L;
        }

        public final long maxPossibleValue() {
            return 157778L;
        }

        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (long)this.doubleArray[(int)index];
        }

        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (int)this.doubleArray[(int)index];
        }

        public final long indexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.indexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.lastIndexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.doubleArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfDouble(this.doubleArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfDouble(this.doubleArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JADoubleArray(this.doubleArray, (int)(toIndex - fromIndex));
            }
            return new JADoubleSubArray(this.doubleArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JADoubleArray(this.doubleArray, (int)count);
            }
            return new JADoubleSubArray(this.doubleArray, (int)count, (int)position);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataDoubleBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataDoubleBuffer)super.buffer(mode);
        }

        @Override
        public DataDoubleBuffer buffer(long capacity) {
            return (DataDoubleBuffer)super.buffer(capacity);
        }

        @Override
        public DataDoubleBuffer buffer() {
            return (DataDoubleBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public DoubleArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public DoubleArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableDoubleArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableDoubleArray)new MutableJADoubleArray(JArrays.copyOfRange(this.doubleArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableDoubleArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableDoubleArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableDoubleArray)new UpdatableJADoubleArray(JArrays.copyOfRange(this.doubleArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableDoubleArray)super.updatableClone(memoryModel);
        }

        @Override
        public double[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array double[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.doubleArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJALongSubArray
    extends UpdatableJALongSubArray
    implements MutableLongArray {
        MutableJALongSubArray(long[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJALongSubArray(long[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJALongSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nLongCopies(toIndex - fromIndex, 0L), true);
        }

        @Override
        public MutableLongArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableLongArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableLongArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableLongArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popLong();
        }

        @Override
        public void pushElement(Object value) {
            this.pushLong((Long)value);
        }

        @Override
        public double popDouble() {
            return this.popLong();
        }

        @Override
        public int popInt() {
            return Arrays.truncateLongToInt(this.popLong());
        }

        @Override
        public void addDouble(double value) {
            this.pushLong((long)value);
        }

        @Override
        public void addLong(long value) {
            this.pushLong(value);
        }

        @Override
        public void addInt(int value) {
            this.pushLong(value);
        }

        @Override
        public long popLong() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long result = this.longArray[this.offset + i];
            this.length = i;
            this.longArray[this.offset + i] = 0L;
            return result;
        }

        @Override
        public void pushLong(long value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.longArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableLongArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableLongArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableLongArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableLongArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableLongArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJALongSubArray result = new MutableJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableLongArray asUnresizable() {
            UpdatableJALongSubArray result = new UpdatableJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableLongArray shallowClone() {
            return (MutableLongArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJALongArray
    extends UpdatableJALongArray
    implements MutableLongArray {
        MutableJALongArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJALongArray(long[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJALongArray(long[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJALongArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nLongCopies(toIndex - fromIndex, 0L), true);
        }

        @Override
        public MutableLongArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableLongArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableLongArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableLongArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popLong();
        }

        @Override
        public void pushElement(Object value) {
            this.pushLong((Long)value);
        }

        @Override
        public double popDouble() {
            return this.popLong();
        }

        @Override
        public int popInt() {
            return Arrays.truncateLongToInt(this.popLong());
        }

        @Override
        public void addDouble(double value) {
            this.pushLong((long)value);
        }

        @Override
        public void addLong(long value) {
            this.pushLong(value);
        }

        @Override
        public void addInt(int value) {
            this.pushLong(value);
        }

        @Override
        public long popLong() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            long result = this.longArray[i];
            this.length = i;
            this.longArray[i] = 0L;
            return result;
        }

        @Override
        public void pushLong(long value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.longArray[i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableLongArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableLongArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableLongArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableLongArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableLongArray asCopyOnNextWrite() {
            MutableJALongSubArray result = new MutableJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableLongArray asUnresizable() {
            return new UpdatableJALongArray(this.longArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableLongArray shallowClone() {
            return (MutableLongArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJALongSubArray
    extends TrustedJALongSubArray
    implements UpdatableLongArray {
        UpdatableJALongSubArray(long[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJALongSubArray(long[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setLong(index, (Long)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.longArray[this.offset + (int)destIndex] = this.longArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.longArray, this.offset + (int)srcIndex, this.longArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            long temp = this.longArray[i];
            this.longArray[i] = this.longArray[j];
            this.longArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                long temp = this.longArray[i];
                this.longArray[i] = this.longArray[j];
                this.longArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JALongSubArray) {
                JALongSubArray a = (JALongSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.longArray[this.offset] = a.longArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.longArray, a.offset, this.longArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JALongArray) {
                JALongArray a = (JALongArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.longArray[this.offset] = a.longArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.longArray, 0, this.longArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJALongSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJALongSubArray) {
                UpdatableJALongSubArray a = (UpdatableJALongSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        long temp = this.longArray[i];
                        this.longArray[i] = a.longArray[j];
                        a.longArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJALongArray) {
                UpdatableJALongArray a = (UpdatableJALongArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        long temp = this.longArray[i];
                        this.longArray[i] = a.longArray[j];
                        a.longArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJALongSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setLong(index, (long)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.longArray[this.offset + (int)index] = value;
        }

        @Override
        public final void setLong(long index, long value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.longArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableLongArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, double value) {
            return this.fill(position, count, (long)value);
        }

        @Override
        public UpdatableLongArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, long value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillLongArray(this.longArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableLongArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJALongArray(this.longArray, (int)(toIndex - fromIndex));
            }
            UpdatableJALongSubArray result = new UpdatableJALongSubArray(this.longArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableLongArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJALongArray(this.longArray, (int)count);
            }
            UpdatableJALongSubArray result = new UpdatableJALongSubArray(this.longArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final LongArray asImmutable() {
            return new JALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final LongArray asTrustedImmutable() {
            TrustedJALongSubArray result = new TrustedJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJALongSubArray result = new UpdatableJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableLongArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJALongArray
    extends TrustedJALongArray
    implements UpdatableLongArray {
        UpdatableJALongArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJALongArray(long[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJALongArray(long[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setLong(index, (Long)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.longArray[(int)destIndex] = this.longArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.longArray, (int)srcIndex, this.longArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            long temp = this.longArray[i];
            this.longArray[i] = this.longArray[j];
            this.longArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                long temp = this.longArray[i];
                this.longArray[i] = this.longArray[j];
                this.longArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JALongSubArray) {
                JALongSubArray a = (JALongSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.longArray[0] = a.longArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.longArray, a.offset, this.longArray, 0, count);
                    return this;
                }
            } else if (src instanceof JALongArray) {
                JALongArray a = (JALongArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.longArray, 0, this.longArray, 0, count);
                }
                return this;
            }
            UpdatableJALongArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJALongSubArray) {
                UpdatableJALongSubArray a = (UpdatableJALongSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        long temp = this.longArray[i];
                        this.longArray[i] = a.longArray[j];
                        a.longArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJALongArray) {
                UpdatableJALongArray a = (UpdatableJALongArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        long temp = this.longArray[i];
                        this.longArray[i] = a.longArray[i];
                        a.longArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJALongArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setLong(index, (long)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.longArray[(int)index] = value;
        }

        @Override
        public final void setLong(long index, long value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.longArray[(int)index] = value;
        }

        @Override
        public UpdatableLongArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, double value) {
            return this.fill(position, count, (long)value);
        }

        @Override
        public UpdatableLongArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, long value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillLongArray(this.longArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableLongArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJALongArray(this.longArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJALongSubArray(this.longArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableLongArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJALongArray(this.longArray, (int)count);
            }
            return new UpdatableJALongSubArray(this.longArray, (int)count, (int)position);
        }

        @Override
        public final LongArray asImmutable() {
            return new JALongArray(this.longArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final LongArray asTrustedImmutable() {
            return new TrustedJALongArray(this.longArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJALongSubArray result = new UpdatableJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableLongArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJALongSubArray
    extends JALongSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJALongSubArray(long[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJALongSubArray(long[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.longArray.length;
        }

        @Override
        public long[] ja() {
            if (this.offset == 0 && this.length == (long)this.longArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.longArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJALongArray(this.longArray, (int)(toIndex - fromIndex));
            }
            TrustedJALongSubArray result = new TrustedJALongSubArray(this.longArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJALongArray(this.longArray, (int)count);
            }
            TrustedJALongSubArray result = new TrustedJALongSubArray(this.longArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public LongArray asImmutable() {
            return new JALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJALongSubArray result = new TrustedJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJALongArray
    extends JALongArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJALongArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJALongArray(long[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJALongArray(long[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.longArray.length;
        }

        @Override
        public long[] ja() {
            if (this.length == (long)this.longArray.length) {
                return this.longArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJALongArray(this.longArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJALongSubArray(this.longArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJALongArray(this.longArray, (int)count);
            }
            return new TrustedJALongSubArray(this.longArray, (int)count, (int)position);
        }

        @Override
        public LongArray asImmutable() {
            return new JALongArray(this.longArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJALongSubArray result = new TrustedJALongSubArray(this.longArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JALongSubArray
    extends AbstractJAArray
    implements LongArray {
        long[] longArray;
        int offset;

        JALongSubArray(long[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.longArray = initialArray;
            this.offset = initialOffset;
        }

        JALongSubArray(long[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.longArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.longArray = (long[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Long.TYPE;
        }

        @Override
        public Class<? extends LongArray> type() {
            return LongArray.class;
        }

        @Override
        public Class<? extends UpdatableLongArray> updatableType() {
            return UpdatableLongArray.class;
        }

        @Override
        public Class<? extends MutableLongArray> mutableType() {
            return MutableLongArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getLong(index);
        }

        @Override
        public final long bitsPerElement() {
            return 64L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public long maxPossibleValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.longArray[this.offset + (int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.indexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.lastIndexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return Arrays.truncateLongToInt(this.longArray[this.offset + (int)index]);
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.longArray[this.offset + (int)index];
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfLong(this.longArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfLong(this.longArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JALongArray(this.longArray, (int)(toIndex - fromIndex));
            }
            return new JALongSubArray(this.longArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JALongArray(this.longArray, (int)count);
            }
            return new JALongSubArray(this.longArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataLongBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataLongBuffer)super.buffer(mode);
        }

        @Override
        public DataLongBuffer buffer(long capacity) {
            return (DataLongBuffer)super.buffer(capacity);
        }

        @Override
        public DataLongBuffer buffer() {
            return (DataLongBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public LongArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public LongArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableLongArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableLongArray)new MutableJALongArray(JArrays.copyOfRange(this.longArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableLongArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableLongArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableLongArray)new UpdatableJALongArray(JArrays.copyOfRange(this.longArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableLongArray)super.updatableClone(memoryModel);
        }

        @Override
        public long[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray long[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JALongArray
    extends AbstractJAArray
    implements LongArray {
        long[] longArray;

        JALongArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.longArray = (long[])this.array;
        }

        JALongArray(long[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.longArray = initialArray;
        }

        JALongArray(long[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.longArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.longArray = (long[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Long.TYPE;
        }

        @Override
        public Class<? extends LongArray> type() {
            return LongArray.class;
        }

        @Override
        public Class<? extends UpdatableLongArray> updatableType() {
            return UpdatableLongArray.class;
        }

        @Override
        public Class<? extends MutableLongArray> mutableType() {
            return MutableLongArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getLong(index);
        }

        @Override
        public final long bitsPerElement() {
            return 64L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public final long maxPossibleValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.longArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.indexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.lastIndexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return Arrays.truncateLongToInt(this.longArray[(int)index]);
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.longArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfLong(this.longArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfLong(this.longArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JALongArray(this.longArray, (int)(toIndex - fromIndex));
            }
            return new JALongSubArray(this.longArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JALongArray(this.longArray, (int)count);
            }
            return new JALongSubArray(this.longArray, (int)count, (int)position);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataLongBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataLongBuffer)super.buffer(mode);
        }

        @Override
        public DataLongBuffer buffer(long capacity) {
            return (DataLongBuffer)super.buffer(capacity);
        }

        @Override
        public DataLongBuffer buffer() {
            return (DataLongBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public LongArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public LongArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableLongArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableLongArray)new MutableJALongArray(JArrays.copyOfRange(this.longArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableLongArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableLongArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableLongArray)new UpdatableJALongArray(JArrays.copyOfRange(this.longArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableLongArray)super.updatableClone(memoryModel);
        }

        @Override
        public long[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array long[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.longArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAIntSubArray
    extends UpdatableJAIntSubArray
    implements MutableIntArray {
        MutableJAIntSubArray(int[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJAIntSubArray(int[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAIntSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nIntCopies(toIndex - fromIndex, 0), true);
        }

        @Override
        public MutableIntArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableIntArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableIntArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableIntArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popInt();
        }

        @Override
        public void pushElement(Object value) {
            this.pushInt((Integer)value);
        }

        @Override
        public double popDouble() {
            return this.popInt();
        }

        @Override
        public long popLong() {
            return this.popInt();
        }

        @Override
        public void addDouble(double value) {
            this.pushInt((int)value);
        }

        @Override
        public void addLong(long value) {
            this.pushInt((int)value);
        }

        @Override
        public void addInt(int value) {
            this.pushInt(value);
        }

        @Override
        public int popInt() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int result = this.intArray[this.offset + i];
            this.length = i;
            this.intArray[this.offset + i] = 0;
            return result;
        }

        @Override
        public void pushInt(int value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.intArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableIntArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableIntArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableIntArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableIntArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableIntArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJAIntSubArray result = new MutableJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableIntArray asUnresizable() {
            UpdatableJAIntSubArray result = new UpdatableJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableIntArray shallowClone() {
            return (MutableIntArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAIntArray
    extends UpdatableJAIntArray
    implements MutableIntArray {
        MutableJAIntArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJAIntArray(int[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJAIntArray(int[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAIntArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nIntCopies(toIndex - fromIndex, 0), true);
        }

        @Override
        public MutableIntArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableIntArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableIntArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableIntArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popInt();
        }

        @Override
        public void pushElement(Object value) {
            this.pushInt((Integer)value);
        }

        @Override
        public double popDouble() {
            return this.popInt();
        }

        @Override
        public long popLong() {
            return this.popInt();
        }

        @Override
        public void addDouble(double value) {
            this.pushInt((int)value);
        }

        @Override
        public void addLong(long value) {
            this.pushInt((int)value);
        }

        @Override
        public void addInt(int value) {
            this.pushInt(value);
        }

        @Override
        public int popInt() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int result = this.intArray[i];
            this.length = i;
            this.intArray[i] = 0;
            return result;
        }

        @Override
        public void pushInt(int value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.intArray[i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableIntArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableIntArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableIntArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableIntArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableIntArray asCopyOnNextWrite() {
            MutableJAIntSubArray result = new MutableJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableIntArray asUnresizable() {
            return new UpdatableJAIntArray(this.intArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableIntArray shallowClone() {
            return (MutableIntArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAIntSubArray
    extends TrustedJAIntSubArray
    implements UpdatableIntArray {
        UpdatableJAIntSubArray(int[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJAIntSubArray(int[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setInt(index, (Integer)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.intArray[this.offset + (int)destIndex] = this.intArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.intArray, this.offset + (int)srcIndex, this.intArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int temp = this.intArray[i];
            this.intArray[i] = this.intArray[j];
            this.intArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                int temp = this.intArray[i];
                this.intArray[i] = this.intArray[j];
                this.intArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAIntSubArray) {
                JAIntSubArray a = (JAIntSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.intArray[this.offset] = a.intArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.intArray, a.offset, this.intArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JAIntArray) {
                JAIntArray a = (JAIntArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.intArray[this.offset] = a.intArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.intArray, 0, this.intArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJAIntSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAIntSubArray) {
                UpdatableJAIntSubArray a = (UpdatableJAIntSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        int temp = this.intArray[i];
                        this.intArray[i] = a.intArray[j];
                        a.intArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAIntArray) {
                UpdatableJAIntArray a = (UpdatableJAIntArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        int temp = this.intArray[i];
                        this.intArray[i] = a.intArray[j];
                        a.intArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJAIntSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setInt(index, (int)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setInt(index, (int)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.intArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableIntArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, double value) {
            return this.fill(position, count, (int)value);
        }

        @Override
        public UpdatableIntArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, long value) {
            return this.fill(position, count, (int)value);
        }

        @Override
        public UpdatableIntArray fill(int value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, int value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillIntArray(this.intArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableIntArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJAIntArray(this.intArray, (int)(toIndex - fromIndex));
            }
            UpdatableJAIntSubArray result = new UpdatableJAIntSubArray(this.intArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableIntArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJAIntArray(this.intArray, (int)count);
            }
            UpdatableJAIntSubArray result = new UpdatableJAIntSubArray(this.intArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final IntArray asImmutable() {
            return new JAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final IntArray asTrustedImmutable() {
            TrustedJAIntSubArray result = new TrustedJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJAIntSubArray result = new UpdatableJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableIntArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAIntArray
    extends TrustedJAIntArray
    implements UpdatableIntArray {
        UpdatableJAIntArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJAIntArray(int[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJAIntArray(int[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setInt(index, (Integer)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.intArray[(int)destIndex] = this.intArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.intArray, (int)srcIndex, this.intArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int temp = this.intArray[i];
            this.intArray[i] = this.intArray[j];
            this.intArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                int temp = this.intArray[i];
                this.intArray[i] = this.intArray[j];
                this.intArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAIntSubArray) {
                JAIntSubArray a = (JAIntSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.intArray[0] = a.intArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.intArray, a.offset, this.intArray, 0, count);
                    return this;
                }
            } else if (src instanceof JAIntArray) {
                JAIntArray a = (JAIntArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.intArray, 0, this.intArray, 0, count);
                }
                return this;
            }
            UpdatableJAIntArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAIntSubArray) {
                UpdatableJAIntSubArray a = (UpdatableJAIntSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        int temp = this.intArray[i];
                        this.intArray[i] = a.intArray[j];
                        a.intArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAIntArray) {
                UpdatableJAIntArray a = (UpdatableJAIntArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        int temp = this.intArray[i];
                        this.intArray[i] = a.intArray[i];
                        a.intArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJAIntArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setInt(index, (int)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setInt(index, (int)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.intArray[(int)index] = value;
        }

        @Override
        public UpdatableIntArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, double value) {
            return this.fill(position, count, (int)value);
        }

        @Override
        public UpdatableIntArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, long value) {
            return this.fill(position, count, (int)value);
        }

        @Override
        public UpdatableIntArray fill(int value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, int value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillIntArray(this.intArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableIntArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJAIntArray(this.intArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJAIntSubArray(this.intArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableIntArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJAIntArray(this.intArray, (int)count);
            }
            return new UpdatableJAIntSubArray(this.intArray, (int)count, (int)position);
        }

        @Override
        public final IntArray asImmutable() {
            return new JAIntArray(this.intArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final IntArray asTrustedImmutable() {
            return new TrustedJAIntArray(this.intArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJAIntSubArray result = new UpdatableJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableIntArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAIntSubArray
    extends JAIntSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAIntSubArray(int[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAIntSubArray(int[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.intArray.length;
        }

        @Override
        public int[] ja() {
            if (this.offset == 0 && this.length == (long)this.intArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.intArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJAIntArray(this.intArray, (int)(toIndex - fromIndex));
            }
            TrustedJAIntSubArray result = new TrustedJAIntSubArray(this.intArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJAIntArray(this.intArray, (int)count);
            }
            TrustedJAIntSubArray result = new TrustedJAIntSubArray(this.intArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public IntArray asImmutable() {
            return new JAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJAIntSubArray result = new TrustedJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAIntArray
    extends JAIntArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAIntArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJAIntArray(int[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAIntArray(int[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.intArray.length;
        }

        @Override
        public int[] ja() {
            if (this.length == (long)this.intArray.length) {
                return this.intArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJAIntArray(this.intArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJAIntSubArray(this.intArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJAIntArray(this.intArray, (int)count);
            }
            return new TrustedJAIntSubArray(this.intArray, (int)count, (int)position);
        }

        @Override
        public IntArray asImmutable() {
            return new JAIntArray(this.intArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJAIntSubArray result = new TrustedJAIntSubArray(this.intArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAIntSubArray
    extends AbstractJAArray
    implements IntArray {
        int[] intArray;
        int offset;

        JAIntSubArray(int[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.intArray = initialArray;
            this.offset = initialOffset;
        }

        JAIntSubArray(int[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.intArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.intArray = (int[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Integer.TYPE;
        }

        @Override
        public Class<? extends IntArray> type() {
            return IntArray.class;
        }

        @Override
        public Class<? extends UpdatableIntArray> updatableType() {
            return UpdatableIntArray.class;
        }

        @Override
        public Class<? extends MutableIntArray> mutableType() {
            return MutableIntArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getInt(index);
        }

        @Override
        public final long bitsPerElement() {
            return 32L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public long maxPossibleValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.intArray[this.offset + (int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.intArray[this.offset + (int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.intArray[this.offset + (int)index];
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfInt(this.intArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfInt(this.intArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JAIntArray(this.intArray, (int)(toIndex - fromIndex));
            }
            return new JAIntSubArray(this.intArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JAIntArray(this.intArray, (int)count);
            }
            return new JAIntSubArray(this.intArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataIntBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataIntBuffer)super.buffer(mode);
        }

        @Override
        public DataIntBuffer buffer(long capacity) {
            return (DataIntBuffer)super.buffer(capacity);
        }

        @Override
        public DataIntBuffer buffer() {
            return (DataIntBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public IntArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public IntArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableIntArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableIntArray)new MutableJAIntArray(JArrays.copyOfRange(this.intArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableIntArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableIntArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableIntArray)new UpdatableJAIntArray(JArrays.copyOfRange(this.intArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableIntArray)super.updatableClone(memoryModel);
        }

        @Override
        public int[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray int[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAIntArray
    extends AbstractJAArray
    implements IntArray {
        int[] intArray;

        JAIntArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.intArray = (int[])this.array;
        }

        JAIntArray(int[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.intArray = initialArray;
        }

        JAIntArray(int[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.intArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.intArray = (int[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Integer.TYPE;
        }

        @Override
        public Class<? extends IntArray> type() {
            return IntArray.class;
        }

        @Override
        public Class<? extends UpdatableIntArray> updatableType() {
            return UpdatableIntArray.class;
        }

        @Override
        public Class<? extends MutableIntArray> mutableType() {
            return MutableIntArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getInt(index);
        }

        @Override
        public final long bitsPerElement() {
            return 32L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public final long maxPossibleValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.intArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.intArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.intArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfInt(this.intArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfInt(this.intArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JAIntArray(this.intArray, (int)(toIndex - fromIndex));
            }
            return new JAIntSubArray(this.intArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JAIntArray(this.intArray, (int)count);
            }
            return new JAIntSubArray(this.intArray, (int)count, (int)position);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataIntBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataIntBuffer)super.buffer(mode);
        }

        @Override
        public DataIntBuffer buffer(long capacity) {
            return (DataIntBuffer)super.buffer(capacity);
        }

        @Override
        public DataIntBuffer buffer() {
            return (DataIntBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public IntArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public IntArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableIntArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableIntArray)new MutableJAIntArray(JArrays.copyOfRange(this.intArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableIntArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableIntArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableIntArray)new UpdatableJAIntArray(JArrays.copyOfRange(this.intArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableIntArray)super.updatableClone(memoryModel);
        }

        @Override
        public int[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array int[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.intArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAShortSubArray
    extends UpdatableJAShortSubArray
    implements MutableShortArray {
        MutableJAShortSubArray(short[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJAShortSubArray(short[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAShortSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nShortCopies(toIndex - fromIndex, (short)0), true);
        }

        @Override
        public MutableShortArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableShortArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableShortArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableShortArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popShort();
        }

        @Override
        public void pushElement(Object value) {
            this.pushShort((Short)value);
        }

        @Override
        public double popDouble() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public long popLong() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public int popInt() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public void addDouble(double value) {
            this.pushShort((short)value);
        }

        @Override
        public void addLong(long value) {
            this.pushShort((short)value);
        }

        @Override
        public void addInt(int value) {
            this.pushShort((short)value);
        }

        @Override
        public short popShort() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            short result = this.shortArray[this.offset + i];
            this.length = i;
            this.shortArray[this.offset + i] = 0;
            return result;
        }

        @Override
        public void pushShort(short value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.shortArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableShortArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableShortArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableShortArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableShortArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableShortArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJAShortSubArray result = new MutableJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableShortArray asUnresizable() {
            UpdatableJAShortSubArray result = new UpdatableJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableShortArray shallowClone() {
            return (MutableShortArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAShortArray
    extends UpdatableJAShortArray
    implements MutableShortArray {
        MutableJAShortArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJAShortArray(short[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJAShortArray(short[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAShortArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nShortCopies(toIndex - fromIndex, (short)0), true);
        }

        @Override
        public MutableShortArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableShortArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableShortArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableShortArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popShort();
        }

        @Override
        public void pushElement(Object value) {
            this.pushShort((Short)value);
        }

        @Override
        public double popDouble() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public long popLong() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public int popInt() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public void addDouble(double value) {
            this.pushShort((short)value);
        }

        @Override
        public void addLong(long value) {
            this.pushShort((short)value);
        }

        @Override
        public void addInt(int value) {
            this.pushShort((short)value);
        }

        @Override
        public short popShort() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            short result = this.shortArray[i];
            this.length = i;
            this.shortArray[i] = 0;
            return result;
        }

        @Override
        public void pushShort(short value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.shortArray[i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableShortArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableShortArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableShortArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableShortArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableShortArray asCopyOnNextWrite() {
            MutableJAShortSubArray result = new MutableJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableShortArray asUnresizable() {
            return new UpdatableJAShortArray(this.shortArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableShortArray shallowClone() {
            return (MutableShortArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAShortSubArray
    extends TrustedJAShortSubArray
    implements UpdatableShortArray {
        UpdatableJAShortSubArray(short[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJAShortSubArray(short[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setShort(index, (Short)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.shortArray[this.offset + (int)destIndex] = this.shortArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.shortArray, this.offset + (int)srcIndex, this.shortArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            short temp = this.shortArray[i];
            this.shortArray[i] = this.shortArray[j];
            this.shortArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                short temp = this.shortArray[i];
                this.shortArray[i] = this.shortArray[j];
                this.shortArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAShortSubArray) {
                JAShortSubArray a = (JAShortSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.shortArray[this.offset] = a.shortArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.shortArray, a.offset, this.shortArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JAShortArray) {
                JAShortArray a = (JAShortArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.shortArray[this.offset] = a.shortArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.shortArray, 0, this.shortArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJAShortSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAShortSubArray) {
                UpdatableJAShortSubArray a = (UpdatableJAShortSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        short temp = this.shortArray[i];
                        this.shortArray[i] = a.shortArray[j];
                        a.shortArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAShortArray) {
                UpdatableJAShortArray a = (UpdatableJAShortArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        short temp = this.shortArray[i];
                        this.shortArray[i] = a.shortArray[j];
                        a.shortArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJAShortSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setShort(index, (short)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setShort(index, (short)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.shortArray[this.offset + (int)index] = (short)value;
        }

        @Override
        public final void setShort(long index, short value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.shortArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableShortArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, double value) {
            return this.fill(position, count, (short)value);
        }

        @Override
        public UpdatableShortArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, long value) {
            return this.fill(position, count, (short)value);
        }

        @Override
        public UpdatableShortArray fill(short value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, short value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillShortArray(this.shortArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableShortArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJAShortArray(this.shortArray, (int)(toIndex - fromIndex));
            }
            UpdatableJAShortSubArray result = new UpdatableJAShortSubArray(this.shortArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableShortArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJAShortArray(this.shortArray, (int)count);
            }
            UpdatableJAShortSubArray result = new UpdatableJAShortSubArray(this.shortArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final ShortArray asImmutable() {
            return new JAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final ShortArray asTrustedImmutable() {
            TrustedJAShortSubArray result = new TrustedJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJAShortSubArray result = new UpdatableJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableShortArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAShortArray
    extends TrustedJAShortArray
    implements UpdatableShortArray {
        UpdatableJAShortArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJAShortArray(short[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJAShortArray(short[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setShort(index, (Short)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.shortArray[(int)destIndex] = this.shortArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.shortArray, (int)srcIndex, this.shortArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            short temp = this.shortArray[i];
            this.shortArray[i] = this.shortArray[j];
            this.shortArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                short temp = this.shortArray[i];
                this.shortArray[i] = this.shortArray[j];
                this.shortArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAShortSubArray) {
                JAShortSubArray a = (JAShortSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.shortArray[0] = a.shortArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.shortArray, a.offset, this.shortArray, 0, count);
                    return this;
                }
            } else if (src instanceof JAShortArray) {
                JAShortArray a = (JAShortArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.shortArray, 0, this.shortArray, 0, count);
                }
                return this;
            }
            UpdatableJAShortArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAShortSubArray) {
                UpdatableJAShortSubArray a = (UpdatableJAShortSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        short temp = this.shortArray[i];
                        this.shortArray[i] = a.shortArray[j];
                        a.shortArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAShortArray) {
                UpdatableJAShortArray a = (UpdatableJAShortArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        short temp = this.shortArray[i];
                        this.shortArray[i] = a.shortArray[i];
                        a.shortArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJAShortArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setShort(index, (short)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setShort(index, (short)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.shortArray[(int)index] = (short)value;
        }

        @Override
        public final void setShort(long index, short value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.shortArray[(int)index] = value;
        }

        @Override
        public UpdatableShortArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, double value) {
            return this.fill(position, count, (short)value);
        }

        @Override
        public UpdatableShortArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, long value) {
            return this.fill(position, count, (short)value);
        }

        @Override
        public UpdatableShortArray fill(short value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, short value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillShortArray(this.shortArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableShortArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJAShortArray(this.shortArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJAShortSubArray(this.shortArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableShortArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJAShortArray(this.shortArray, (int)count);
            }
            return new UpdatableJAShortSubArray(this.shortArray, (int)count, (int)position);
        }

        @Override
        public final ShortArray asImmutable() {
            return new JAShortArray(this.shortArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final ShortArray asTrustedImmutable() {
            return new TrustedJAShortArray(this.shortArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJAShortSubArray result = new UpdatableJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableShortArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAShortSubArray
    extends JAShortSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAShortSubArray(short[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAShortSubArray(short[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.shortArray.length;
        }

        @Override
        public short[] ja() {
            if (this.offset == 0 && this.length == (long)this.shortArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.shortArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJAShortArray(this.shortArray, (int)(toIndex - fromIndex));
            }
            TrustedJAShortSubArray result = new TrustedJAShortSubArray(this.shortArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJAShortArray(this.shortArray, (int)count);
            }
            TrustedJAShortSubArray result = new TrustedJAShortSubArray(this.shortArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public ShortArray asImmutable() {
            return new JAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJAShortSubArray result = new TrustedJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAShortArray
    extends JAShortArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAShortArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJAShortArray(short[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAShortArray(short[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.shortArray.length;
        }

        @Override
        public short[] ja() {
            if (this.length == (long)this.shortArray.length) {
                return this.shortArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJAShortArray(this.shortArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJAShortSubArray(this.shortArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJAShortArray(this.shortArray, (int)count);
            }
            return new TrustedJAShortSubArray(this.shortArray, (int)count, (int)position);
        }

        @Override
        public ShortArray asImmutable() {
            return new JAShortArray(this.shortArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJAShortSubArray result = new TrustedJAShortSubArray(this.shortArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAShortSubArray
    extends AbstractJAArray
    implements ShortArray {
        short[] shortArray;
        int offset;

        JAShortSubArray(short[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.shortArray = initialArray;
            this.offset = initialOffset;
        }

        JAShortSubArray(short[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.shortArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.shortArray = (short[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Short.TYPE;
        }

        @Override
        public Class<? extends ShortArray> type() {
            return ShortArray.class;
        }

        @Override
        public Class<? extends UpdatableShortArray> updatableType() {
            return UpdatableShortArray.class;
        }

        @Override
        public Class<? extends MutableShortArray> mutableType() {
            return MutableShortArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return (short)this.getShort(index);
        }

        @Override
        public final long bitsPerElement() {
            return 16L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 65535L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[this.offset + (int)index] & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[this.offset + (int)index] & 0xFFFF;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[this.offset + (int)index] & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[this.offset + (int)index] & 0xFFFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfShort(this.shortArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfShort(this.shortArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JAShortArray(this.shortArray, (int)(toIndex - fromIndex));
            }
            return new JAShortSubArray(this.shortArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JAShortArray(this.shortArray, (int)count);
            }
            return new JAShortSubArray(this.shortArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataShortBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataShortBuffer)super.buffer(mode);
        }

        @Override
        public DataShortBuffer buffer(long capacity) {
            return (DataShortBuffer)super.buffer(capacity);
        }

        @Override
        public DataShortBuffer buffer() {
            return (DataShortBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ShortArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public ShortArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableShortArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableShortArray)new MutableJAShortArray(JArrays.copyOfRange(this.shortArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableShortArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableShortArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableShortArray)new UpdatableJAShortArray(JArrays.copyOfRange(this.shortArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableShortArray)super.updatableClone(memoryModel);
        }

        @Override
        public short[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray short[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAShortArray
    extends AbstractJAArray
    implements ShortArray {
        short[] shortArray;

        JAShortArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.shortArray = (short[])this.array;
        }

        JAShortArray(short[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.shortArray = initialArray;
        }

        JAShortArray(short[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.shortArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.shortArray = (short[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Short.TYPE;
        }

        @Override
        public Class<? extends ShortArray> type() {
            return ShortArray.class;
        }

        @Override
        public Class<? extends UpdatableShortArray> updatableType() {
            return UpdatableShortArray.class;
        }

        @Override
        public Class<? extends MutableShortArray> mutableType() {
            return MutableShortArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return (short)this.getShort(index);
        }

        @Override
        public final long bitsPerElement() {
            return 16L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 65535L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[(int)index] & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[(int)index] & 0xFFFF;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[(int)index] & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.shortArray[(int)index] & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfShort(this.shortArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfShort(this.shortArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JAShortArray(this.shortArray, (int)(toIndex - fromIndex));
            }
            return new JAShortSubArray(this.shortArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JAShortArray(this.shortArray, (int)count);
            }
            return new JAShortSubArray(this.shortArray, (int)count, (int)position);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataShortBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataShortBuffer)super.buffer(mode);
        }

        @Override
        public DataShortBuffer buffer(long capacity) {
            return (DataShortBuffer)super.buffer(capacity);
        }

        @Override
        public DataShortBuffer buffer() {
            return (DataShortBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ShortArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public ShortArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableShortArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableShortArray)new MutableJAShortArray(JArrays.copyOfRange(this.shortArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableShortArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableShortArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableShortArray)new UpdatableJAShortArray(JArrays.copyOfRange(this.shortArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableShortArray)super.updatableClone(memoryModel);
        }

        @Override
        public short[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array short[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.shortArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAByteSubArray
    extends UpdatableJAByteSubArray
    implements MutableByteArray {
        MutableJAByteSubArray(byte[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJAByteSubArray(byte[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAByteSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nByteCopies(toIndex - fromIndex, (byte)0), true);
        }

        @Override
        public MutableByteArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableByteArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableByteArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableByteArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popByte();
        }

        @Override
        public void pushElement(Object value) {
            this.pushByte((Byte)value);
        }

        @Override
        public double popDouble() {
            return this.popByte() & 0xFF;
        }

        @Override
        public long popLong() {
            return this.popByte() & 0xFF;
        }

        @Override
        public int popInt() {
            return this.popByte() & 0xFF;
        }

        @Override
        public void addDouble(double value) {
            this.pushByte((byte)value);
        }

        @Override
        public void addLong(long value) {
            this.pushByte((byte)value);
        }

        @Override
        public void addInt(int value) {
            this.pushByte((byte)value);
        }

        @Override
        public byte popByte() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            byte result = this.byteArray[this.offset + i];
            this.length = i;
            this.byteArray[this.offset + i] = 0;
            return result;
        }

        @Override
        public void pushByte(byte value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.byteArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableByteArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableByteArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableByteArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableByteArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableByteArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJAByteSubArray result = new MutableJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableByteArray asUnresizable() {
            UpdatableJAByteSubArray result = new UpdatableJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableByteArray shallowClone() {
            return (MutableByteArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAByteArray
    extends UpdatableJAByteArray
    implements MutableByteArray {
        MutableJAByteArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJAByteArray(byte[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJAByteArray(byte[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAByteArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nByteCopies(toIndex - fromIndex, (byte)0), true);
        }

        @Override
        public MutableByteArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableByteArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableByteArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableByteArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popByte();
        }

        @Override
        public void pushElement(Object value) {
            this.pushByte((Byte)value);
        }

        @Override
        public double popDouble() {
            return this.popByte() & 0xFF;
        }

        @Override
        public long popLong() {
            return this.popByte() & 0xFF;
        }

        @Override
        public int popInt() {
            return this.popByte() & 0xFF;
        }

        @Override
        public void addDouble(double value) {
            this.pushByte((byte)value);
        }

        @Override
        public void addLong(long value) {
            this.pushByte((byte)value);
        }

        @Override
        public void addInt(int value) {
            this.pushByte((byte)value);
        }

        @Override
        public byte popByte() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            byte result = this.byteArray[i];
            this.length = i;
            this.byteArray[i] = 0;
            return result;
        }

        @Override
        public void pushByte(byte value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.byteArray[i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableByteArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableByteArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableByteArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableByteArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableByteArray asCopyOnNextWrite() {
            MutableJAByteSubArray result = new MutableJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableByteArray asUnresizable() {
            return new UpdatableJAByteArray(this.byteArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableByteArray shallowClone() {
            return (MutableByteArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAByteSubArray
    extends TrustedJAByteSubArray
    implements UpdatableByteArray {
        UpdatableJAByteSubArray(byte[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJAByteSubArray(byte[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setByte(index, (Byte)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.byteArray[this.offset + (int)destIndex] = this.byteArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.byteArray, this.offset + (int)srcIndex, this.byteArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            byte temp = this.byteArray[i];
            this.byteArray[i] = this.byteArray[j];
            this.byteArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                byte temp = this.byteArray[i];
                this.byteArray[i] = this.byteArray[j];
                this.byteArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAByteSubArray) {
                JAByteSubArray a = (JAByteSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.byteArray[this.offset] = a.byteArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.byteArray, a.offset, this.byteArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JAByteArray) {
                JAByteArray a = (JAByteArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.byteArray[this.offset] = a.byteArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.byteArray, 0, this.byteArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJAByteSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAByteSubArray) {
                UpdatableJAByteSubArray a = (UpdatableJAByteSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        byte temp = this.byteArray[i];
                        this.byteArray[i] = a.byteArray[j];
                        a.byteArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAByteArray) {
                UpdatableJAByteArray a = (UpdatableJAByteArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        byte temp = this.byteArray[i];
                        this.byteArray[i] = a.byteArray[j];
                        a.byteArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJAByteSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setByte(index, (byte)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setByte(index, (byte)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.byteArray[this.offset + (int)index] = (byte)value;
        }

        @Override
        public final void setByte(long index, byte value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.byteArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableByteArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, double value) {
            return this.fill(position, count, (byte)value);
        }

        @Override
        public UpdatableByteArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, long value) {
            return this.fill(position, count, (byte)value);
        }

        @Override
        public UpdatableByteArray fill(byte value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, byte value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillByteArray(this.byteArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableByteArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJAByteArray(this.byteArray, (int)(toIndex - fromIndex));
            }
            UpdatableJAByteSubArray result = new UpdatableJAByteSubArray(this.byteArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableByteArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJAByteArray(this.byteArray, (int)count);
            }
            UpdatableJAByteSubArray result = new UpdatableJAByteSubArray(this.byteArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final ByteArray asImmutable() {
            return new JAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final ByteArray asTrustedImmutable() {
            TrustedJAByteSubArray result = new TrustedJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJAByteSubArray result = new UpdatableJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableByteArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAByteArray
    extends TrustedJAByteArray
    implements UpdatableByteArray {
        UpdatableJAByteArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJAByteArray(byte[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJAByteArray(byte[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setByte(index, (Byte)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.byteArray[(int)destIndex] = this.byteArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.byteArray, (int)srcIndex, this.byteArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            byte temp = this.byteArray[i];
            this.byteArray[i] = this.byteArray[j];
            this.byteArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                byte temp = this.byteArray[i];
                this.byteArray[i] = this.byteArray[j];
                this.byteArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAByteSubArray) {
                JAByteSubArray a = (JAByteSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.byteArray[0] = a.byteArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.byteArray, a.offset, this.byteArray, 0, count);
                    return this;
                }
            } else if (src instanceof JAByteArray) {
                JAByteArray a = (JAByteArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.byteArray, 0, this.byteArray, 0, count);
                }
                return this;
            }
            UpdatableJAByteArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAByteSubArray) {
                UpdatableJAByteSubArray a = (UpdatableJAByteSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        byte temp = this.byteArray[i];
                        this.byteArray[i] = a.byteArray[j];
                        a.byteArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAByteArray) {
                UpdatableJAByteArray a = (UpdatableJAByteArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        byte temp = this.byteArray[i];
                        this.byteArray[i] = a.byteArray[i];
                        a.byteArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJAByteArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setByte(index, (byte)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setByte(index, (byte)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.byteArray[(int)index] = (byte)value;
        }

        @Override
        public final void setByte(long index, byte value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.byteArray[(int)index] = value;
        }

        @Override
        public UpdatableByteArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, double value) {
            return this.fill(position, count, (byte)value);
        }

        @Override
        public UpdatableByteArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, long value) {
            return this.fill(position, count, (byte)value);
        }

        @Override
        public UpdatableByteArray fill(byte value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, byte value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillByteArray(this.byteArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableByteArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJAByteArray(this.byteArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJAByteSubArray(this.byteArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableByteArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJAByteArray(this.byteArray, (int)count);
            }
            return new UpdatableJAByteSubArray(this.byteArray, (int)count, (int)position);
        }

        @Override
        public final ByteArray asImmutable() {
            return new JAByteArray(this.byteArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final ByteArray asTrustedImmutable() {
            return new TrustedJAByteArray(this.byteArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJAByteSubArray result = new UpdatableJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableByteArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAByteSubArray
    extends JAByteSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAByteSubArray(byte[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAByteSubArray(byte[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.byteArray.length;
        }

        @Override
        public byte[] ja() {
            if (this.offset == 0 && this.length == (long)this.byteArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.byteArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJAByteArray(this.byteArray, (int)(toIndex - fromIndex));
            }
            TrustedJAByteSubArray result = new TrustedJAByteSubArray(this.byteArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJAByteArray(this.byteArray, (int)count);
            }
            TrustedJAByteSubArray result = new TrustedJAByteSubArray(this.byteArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public ByteArray asImmutable() {
            return new JAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJAByteSubArray result = new TrustedJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAByteArray
    extends JAByteArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAByteArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJAByteArray(byte[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAByteArray(byte[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.byteArray.length;
        }

        @Override
        public byte[] ja() {
            if (this.length == (long)this.byteArray.length) {
                return this.byteArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJAByteArray(this.byteArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJAByteSubArray(this.byteArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJAByteArray(this.byteArray, (int)count);
            }
            return new TrustedJAByteSubArray(this.byteArray, (int)count, (int)position);
        }

        @Override
        public ByteArray asImmutable() {
            return new JAByteArray(this.byteArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJAByteSubArray result = new TrustedJAByteSubArray(this.byteArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAByteSubArray
    extends AbstractJAArray
    implements ByteArray {
        byte[] byteArray;
        int offset;

        JAByteSubArray(byte[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.byteArray = initialArray;
            this.offset = initialOffset;
        }

        JAByteSubArray(byte[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.byteArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.byteArray = (byte[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Byte.TYPE;
        }

        @Override
        public Class<? extends ByteArray> type() {
            return ByteArray.class;
        }

        @Override
        public Class<? extends UpdatableByteArray> updatableType() {
            return UpdatableByteArray.class;
        }

        @Override
        public Class<? extends MutableByteArray> mutableType() {
            return MutableByteArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return (byte)this.getByte(index);
        }

        @Override
        public final long bitsPerElement() {
            return 8L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 255L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[this.offset + (int)index] & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[this.offset + (int)index] & 0xFF;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[this.offset + (int)index] & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[this.offset + (int)index] & 0xFF;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfByte(this.byteArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfByte(this.byteArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JAByteArray(this.byteArray, (int)(toIndex - fromIndex));
            }
            return new JAByteSubArray(this.byteArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JAByteArray(this.byteArray, (int)count);
            }
            return new JAByteSubArray(this.byteArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataByteBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataByteBuffer)super.buffer(mode);
        }

        @Override
        public DataByteBuffer buffer(long capacity) {
            return (DataByteBuffer)super.buffer(capacity);
        }

        @Override
        public DataByteBuffer buffer() {
            return (DataByteBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ByteArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public ByteArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableByteArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableByteArray)new MutableJAByteArray(JArrays.copyOfRange(this.byteArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableByteArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableByteArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableByteArray)new UpdatableJAByteArray(JArrays.copyOfRange(this.byteArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableByteArray)super.updatableClone(memoryModel);
        }

        @Override
        public byte[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray byte[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAByteArray
    extends AbstractJAArray
    implements ByteArray {
        byte[] byteArray;

        JAByteArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.byteArray = (byte[])this.array;
        }

        JAByteArray(byte[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.byteArray = initialArray;
        }

        JAByteArray(byte[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.byteArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.byteArray = (byte[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Byte.TYPE;
        }

        @Override
        public Class<? extends ByteArray> type() {
            return ByteArray.class;
        }

        @Override
        public Class<? extends UpdatableByteArray> updatableType() {
            return UpdatableByteArray.class;
        }

        @Override
        public Class<? extends MutableByteArray> mutableType() {
            return MutableByteArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return (byte)this.getByte(index);
        }

        @Override
        public final long bitsPerElement() {
            return 8L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 255L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[(int)index] & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[(int)index] & 0xFF;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[(int)index] & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.byteArray[(int)index] & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfByte(this.byteArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfByte(this.byteArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JAByteArray(this.byteArray, (int)(toIndex - fromIndex));
            }
            return new JAByteSubArray(this.byteArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JAByteArray(this.byteArray, (int)count);
            }
            return new JAByteSubArray(this.byteArray, (int)count, (int)position);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataByteBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataByteBuffer)super.buffer(mode);
        }

        @Override
        public DataByteBuffer buffer(long capacity) {
            return (DataByteBuffer)super.buffer(capacity);
        }

        @Override
        public DataByteBuffer buffer() {
            return (DataByteBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ByteArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public ByteArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableByteArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableByteArray)new MutableJAByteArray(JArrays.copyOfRange(this.byteArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableByteArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableByteArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableByteArray)new UpdatableJAByteArray(JArrays.copyOfRange(this.byteArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableByteArray)super.updatableClone(memoryModel);
        }

        @Override
        public byte[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array byte[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.byteArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJACharSubArray
    extends UpdatableJACharSubArray
    implements MutableCharArray {
        MutableJACharSubArray(char[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJACharSubArray(char[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJACharSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nCharCopies(toIndex - fromIndex, '\u0000'), true);
        }

        @Override
        public MutableCharArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableCharArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableCharArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableCharArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return Character.valueOf(this.popChar());
        }

        @Override
        public void pushElement(Object value) {
            this.pushChar(((Character)value).charValue());
        }

        @Override
        public double popDouble() {
            return this.popChar();
        }

        @Override
        public long popLong() {
            return this.popChar();
        }

        @Override
        public int popInt() {
            return this.popChar();
        }

        @Override
        public void addDouble(double value) {
            this.pushChar((char)value);
        }

        @Override
        public void addLong(long value) {
            this.pushChar((char)value);
        }

        @Override
        public void addInt(int value) {
            this.pushChar((char)value);
        }

        @Override
        public char popChar() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            char result = this.charArray[this.offset + i];
            this.length = i;
            this.charArray[this.offset + i] = '\u0000';
            return result;
        }

        @Override
        public void pushChar(char value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.charArray[this.offset + i] = value;
        }

        @Override
        public MutableCharArray append(String value) {
            long index = this.length;
            int count = value.length();
            if (count > 0) {
                Arrays.lengthUnsigned(this, index + (long)count);
                value.getChars(0, count, this.charArray, this.javaArrayOffset() + (int)index);
            }
            return this;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableCharArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableCharArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableCharArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableCharArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableCharArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJACharSubArray result = new MutableJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableCharArray asUnresizable() {
            UpdatableJACharSubArray result = new UpdatableJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableCharArray shallowClone() {
            return (MutableCharArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJACharArray
    extends UpdatableJACharArray
    implements MutableCharArray {
        MutableJACharArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJACharArray(char[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJACharArray(char[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJACharArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nCharCopies(toIndex - fromIndex, '\u0000'), true);
        }

        @Override
        public MutableCharArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableCharArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableCharArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableCharArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return Character.valueOf(this.popChar());
        }

        @Override
        public void pushElement(Object value) {
            this.pushChar(((Character)value).charValue());
        }

        @Override
        public double popDouble() {
            return this.popChar();
        }

        @Override
        public long popLong() {
            return this.popChar();
        }

        @Override
        public int popInt() {
            return this.popChar();
        }

        @Override
        public void addDouble(double value) {
            this.pushChar((char)value);
        }

        @Override
        public void addLong(long value) {
            this.pushChar((char)value);
        }

        @Override
        public void addInt(int value) {
            this.pushChar((char)value);
        }

        @Override
        public char popChar() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            char result = this.charArray[i];
            this.length = i;
            this.charArray[i] = '\u0000';
            return result;
        }

        @Override
        public void pushChar(char value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.charArray[i] = value;
        }

        @Override
        public MutableCharArray append(String value) {
            long index = this.length;
            int count = value.length();
            if (count > 0) {
                Arrays.lengthUnsigned(this, index + (long)count);
                value.getChars(0, count, this.charArray, this.javaArrayOffset() + (int)index);
            }
            return this;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableCharArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableCharArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableCharArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableCharArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableCharArray asCopyOnNextWrite() {
            MutableJACharSubArray result = new MutableJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableCharArray asUnresizable() {
            return new UpdatableJACharArray(this.charArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableCharArray shallowClone() {
            return (MutableCharArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJACharSubArray
    extends TrustedJACharSubArray
    implements UpdatableCharArray {
        UpdatableJACharSubArray(char[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJACharSubArray(char[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setChar(index, ((Character)value).charValue());
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.charArray[this.offset + (int)destIndex] = this.charArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.charArray, this.offset + (int)srcIndex, this.charArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            char temp = this.charArray[i];
            this.charArray[i] = this.charArray[j];
            this.charArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                char temp = this.charArray[i];
                this.charArray[i] = this.charArray[j];
                this.charArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JACharSubArray) {
                JACharSubArray a = (JACharSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.charArray[this.offset] = a.charArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.charArray, a.offset, this.charArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JACharArray) {
                JACharArray a = (JACharArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.charArray[this.offset] = a.charArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.charArray, 0, this.charArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJACharSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJACharSubArray) {
                UpdatableJACharSubArray a = (UpdatableJACharSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        char temp = this.charArray[i];
                        this.charArray[i] = a.charArray[j];
                        a.charArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJACharArray) {
                UpdatableJACharArray a = (UpdatableJACharArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        char temp = this.charArray[i];
                        this.charArray[i] = a.charArray[j];
                        a.charArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJACharSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setChar(index, (char)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setChar(index, (char)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.charArray[this.offset + (int)index] = (char)value;
        }

        @Override
        public final void setChar(long index, char value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.charArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableCharArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, double value) {
            return this.fill(position, count, (char)value);
        }

        @Override
        public UpdatableCharArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, long value) {
            return this.fill(position, count, (char)value);
        }

        @Override
        public UpdatableCharArray fill(char value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, char value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillCharArray(this.charArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableCharArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJACharArray(this.charArray, (int)(toIndex - fromIndex));
            }
            UpdatableJACharSubArray result = new UpdatableJACharSubArray(this.charArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableCharArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJACharArray(this.charArray, (int)count);
            }
            UpdatableJACharSubArray result = new UpdatableJACharSubArray(this.charArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final CharArray asImmutable() {
            return new JACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final CharArray asTrustedImmutable() {
            TrustedJACharSubArray result = new TrustedJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJACharSubArray result = new UpdatableJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableCharArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJACharArray
    extends TrustedJACharArray
    implements UpdatableCharArray {
        UpdatableJACharArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJACharArray(char[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJACharArray(char[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setChar(index, ((Character)value).charValue());
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.charArray[(int)destIndex] = this.charArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.charArray, (int)srcIndex, this.charArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            char temp = this.charArray[i];
            this.charArray[i] = this.charArray[j];
            this.charArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                char temp = this.charArray[i];
                this.charArray[i] = this.charArray[j];
                this.charArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JACharSubArray) {
                JACharSubArray a = (JACharSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.charArray[0] = a.charArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.charArray, a.offset, this.charArray, 0, count);
                    return this;
                }
            } else if (src instanceof JACharArray) {
                JACharArray a = (JACharArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.charArray, 0, this.charArray, 0, count);
                }
                return this;
            }
            UpdatableJACharArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJACharSubArray) {
                UpdatableJACharSubArray a = (UpdatableJACharSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        char temp = this.charArray[i];
                        this.charArray[i] = a.charArray[j];
                        a.charArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJACharArray) {
                UpdatableJACharArray a = (UpdatableJACharArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        char temp = this.charArray[i];
                        this.charArray[i] = a.charArray[i];
                        a.charArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJACharArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setChar(index, (char)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setChar(index, (char)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.charArray[(int)index] = (char)value;
        }

        @Override
        public final void setChar(long index, char value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.charArray[(int)index] = value;
        }

        @Override
        public UpdatableCharArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, double value) {
            return this.fill(position, count, (char)value);
        }

        @Override
        public UpdatableCharArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, long value) {
            return this.fill(position, count, (char)value);
        }

        @Override
        public UpdatableCharArray fill(char value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, char value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillCharArray(this.charArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableCharArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJACharArray(this.charArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJACharSubArray(this.charArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableCharArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJACharArray(this.charArray, (int)count);
            }
            return new UpdatableJACharSubArray(this.charArray, (int)count, (int)position);
        }

        @Override
        public final CharArray asImmutable() {
            return new JACharArray(this.charArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final CharArray asTrustedImmutable() {
            return new TrustedJACharArray(this.charArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJACharSubArray result = new UpdatableJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableCharArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJACharSubArray
    extends JACharSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJACharSubArray(char[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJACharSubArray(char[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.charArray.length;
        }

        @Override
        public char[] ja() {
            if (this.offset == 0 && this.length == (long)this.charArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.charArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJACharArray(this.charArray, (int)(toIndex - fromIndex));
            }
            TrustedJACharSubArray result = new TrustedJACharSubArray(this.charArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJACharArray(this.charArray, (int)count);
            }
            TrustedJACharSubArray result = new TrustedJACharSubArray(this.charArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public CharArray asImmutable() {
            return new JACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJACharSubArray result = new TrustedJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJACharArray
    extends JACharArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJACharArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJACharArray(char[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJACharArray(char[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.charArray.length;
        }

        @Override
        public char[] ja() {
            if (this.length == (long)this.charArray.length) {
                return this.charArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJACharArray(this.charArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJACharSubArray(this.charArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJACharArray(this.charArray, (int)count);
            }
            return new TrustedJACharSubArray(this.charArray, (int)count, (int)position);
        }

        @Override
        public CharArray asImmutable() {
            return new JACharArray(this.charArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJACharSubArray result = new TrustedJACharSubArray(this.charArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JACharSubArray
    extends AbstractJAArray
    implements CharArray {
        char[] charArray;
        int offset;

        JACharSubArray(char[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.charArray = initialArray;
            this.offset = initialOffset;
        }

        JACharSubArray(char[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.charArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.charArray = (char[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Character.TYPE;
        }

        @Override
        public Class<? extends CharArray> type() {
            return CharArray.class;
        }

        @Override
        public Class<? extends UpdatableCharArray> updatableType() {
            return UpdatableCharArray.class;
        }

        @Override
        public Class<? extends MutableCharArray> mutableType() {
            return MutableCharArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return Character.valueOf(this.getChar(index));
        }

        @Override
        public final long bitsPerElement() {
            return 16L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 65535L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[this.offset + (int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[this.offset + (int)index];
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[this.offset + (int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[this.offset + (int)index];
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfChar(this.charArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfChar(this.charArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JACharArray(this.charArray, (int)(toIndex - fromIndex));
            }
            return new JACharSubArray(this.charArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JACharArray(this.charArray, (int)count);
            }
            return new JACharSubArray(this.charArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataCharBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataCharBuffer)super.buffer(mode);
        }

        @Override
        public DataCharBuffer buffer(long capacity) {
            return (DataCharBuffer)super.buffer(capacity);
        }

        @Override
        public DataCharBuffer buffer() {
            return (DataCharBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public CharArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public CharArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableCharArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableCharArray)new MutableJACharArray(JArrays.copyOfRange(this.charArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableCharArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableCharArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableCharArray)new UpdatableJACharArray(JArrays.copyOfRange(this.charArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableCharArray)super.updatableClone(memoryModel);
        }

        @Override
        public char[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray char[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JACharArray
    extends AbstractJAArray
    implements CharArray {
        char[] charArray;

        JACharArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.charArray = (char[])this.array;
        }

        JACharArray(char[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.charArray = initialArray;
        }

        JACharArray(char[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.charArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.charArray = (char[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Character.TYPE;
        }

        @Override
        public Class<? extends CharArray> type() {
            return CharArray.class;
        }

        @Override
        public Class<? extends UpdatableCharArray> updatableType() {
            return UpdatableCharArray.class;
        }

        @Override
        public Class<? extends MutableCharArray> mutableType() {
            return MutableCharArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return Character.valueOf(this.getChar(index));
        }

        @Override
        public final long bitsPerElement() {
            return 16L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 65535L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[(int)index];
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.charArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfChar(this.charArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfChar(this.charArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JACharArray(this.charArray, (int)(toIndex - fromIndex));
            }
            return new JACharSubArray(this.charArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JACharArray(this.charArray, (int)count);
            }
            return new JACharSubArray(this.charArray, (int)count, (int)position);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataCharBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataCharBuffer)super.buffer(mode);
        }

        @Override
        public DataCharBuffer buffer(long capacity) {
            return (DataCharBuffer)super.buffer(capacity);
        }

        @Override
        public DataCharBuffer buffer() {
            return (DataCharBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public CharArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public CharArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableCharArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableCharArray)new MutableJACharArray(JArrays.copyOfRange(this.charArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableCharArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableCharArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableCharArray)new UpdatableJACharArray(JArrays.copyOfRange(this.charArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableCharArray)super.updatableClone(memoryModel);
        }

        @Override
        public char[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array char[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.charArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAFloatSubArray
    extends UpdatableJAFloatSubArray
    implements MutableFloatArray {
        MutableJAFloatSubArray(float[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        MutableJAFloatSubArray(float[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAFloatSubArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nFloatCopies(toIndex - fromIndex, 0.0f), true);
        }

        @Override
        public MutableFloatArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableFloatArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableFloatArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableFloatArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return Float.valueOf(this.popFloat());
        }

        @Override
        public void pushElement(Object value) {
            this.pushFloat(((Float)value).floatValue());
        }

        @Override
        public double popDouble() {
            return this.popFloat();
        }

        public long popLong() {
            return (long)this.popFloat();
        }

        public int popInt() {
            return (int)this.popFloat();
        }

        @Override
        public void addDouble(double value) {
            this.pushFloat((float)value);
        }

        @Override
        public void addLong(long value) {
            this.pushFloat(value);
        }

        @Override
        public void addInt(int value) {
            this.pushFloat(value);
        }

        @Override
        public float popFloat() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            float result = this.floatArray[this.offset + i];
            this.length = i;
            this.floatArray[this.offset + i] = 0.0f;
            return result;
        }

        @Override
        public void pushFloat(float value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i + 1;
            this.floatArray[this.offset + i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableFloatArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableFloatArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableFloatArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableFloatArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableFloatArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableJAFloatSubArray result = new MutableJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableFloatArray asUnresizable() {
            UpdatableJAFloatSubArray result = new UpdatableJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public MutableFloatArray shallowClone() {
            return (MutableFloatArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART subarray float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static final class MutableJAFloatArray
    extends UpdatableJAFloatArray
    implements MutableFloatArray {
        MutableJAFloatArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        MutableJAFloatArray(float[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        MutableJAFloatArray(float[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        void clearElements(long fromIndex, long toIndex) {
            MutableJAFloatArray.defaultCopy(this.subArray(fromIndex, toIndex), Arrays.nFloatCopies(toIndex - fromIndex, 0.0f), true);
        }

        @Override
        public MutableFloatArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableFloatArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableFloatArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableFloatArray append(Array appendedArray) {
            this.appendImpl(appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return Float.valueOf(this.popFloat());
        }

        @Override
        public void pushElement(Object value) {
            this.pushFloat(((Float)value).floatValue());
        }

        @Override
        public double popDouble() {
            return this.popFloat();
        }

        public long popLong() {
            return (long)this.popFloat();
        }

        public int popInt() {
            return (int)this.popFloat();
        }

        @Override
        public void addDouble(double value) {
            this.pushFloat((float)value);
        }

        @Override
        public void addLong(long value) {
            this.pushFloat(value);
        }

        @Override
        public void addInt(int value) {
            this.pushFloat(value);
        }

        @Override
        public float popFloat() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            float result = this.floatArray[i];
            this.length = i;
            this.floatArray[i] = 0.0f;
            return result;
        }

        @Override
        public void pushFloat(float value) {
            int i = (int)this.length;
            if ((long)i >= this.capacity()) {
                this.ensureCapacityImpl((long)i + 1L);
            }
            this.length = i + 1;
            this.floatArray[i] = value;
        }

        @Override
        public void removeTop() {
            int i = (int)this.length - 1;
            if (i < 0) {
                throw new EmptyStackException();
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.length = i;
        }

        @Override
        public MutableFloatArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableFloatArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableFloatArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableFloatArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableFloatArray asCopyOnNextWrite() {
            MutableJAFloatSubArray result = new MutableJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableFloatArray asUnresizable() {
            return new UpdatableJAFloatArray(this.floatArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public MutableFloatArray shallowClone() {
            return (MutableFloatArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "mutable simple AlgART array float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAFloatSubArray
    extends TrustedJAFloatSubArray
    implements UpdatableFloatArray {
        UpdatableJAFloatSubArray(float[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
        }

        UpdatableJAFloatSubArray(float[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setFloat(index, ((Float)value).floatValue());
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.floatArray[this.offset + (int)destIndex] = this.floatArray[this.offset + (int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            System.arraycopy(this.floatArray, this.offset + (int)srcIndex, this.floatArray, this.offset + (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            float temp = this.floatArray[i];
            this.floatArray[i] = this.floatArray[j];
            this.floatArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            int i = this.offset + (int)firstIndex;
            int j = this.offset + (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                float temp = this.floatArray[i];
                this.floatArray[i] = this.floatArray[j];
                this.floatArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAFloatSubArray) {
                JAFloatSubArray a = (JAFloatSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.floatArray[this.offset] = a.floatArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.floatArray, a.offset, this.floatArray, this.offset, count);
                    return this;
                }
            } else if (src instanceof JAFloatArray) {
                JAFloatArray a = (JAFloatArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    this.floatArray[this.offset] = a.floatArray[0];
                    return this;
                }
                if (count > 0) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    System.arraycopy(a.floatArray, 0, this.floatArray, this.offset, count);
                    return this;
                }
            }
            UpdatableJAFloatSubArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAFloatSubArray) {
                UpdatableJAFloatSubArray a = (UpdatableJAFloatSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    int j = a.offset;
                    int iMax = i + count;
                    while (i < iMax) {
                        float temp = this.floatArray[i];
                        this.floatArray[i] = a.floatArray[j];
                        a.floatArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAFloatArray) {
                UpdatableJAFloatArray a = (UpdatableJAFloatArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    if (this.capacity < 0L) {
                        this.reallocateStorage();
                    }
                    int i = this.offset;
                    for (int j = 0; j < count; ++j) {
                        float temp = this.floatArray[i];
                        this.floatArray[i] = a.floatArray[j];
                        a.floatArray[j] = temp;
                        ++i;
                    }
                    return this;
                }
            }
            UpdatableJAFloatSubArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setFloat(index, (float)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setFloat(index, value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.floatArray[this.offset + (int)index] = value;
        }

        @Override
        public final void setFloat(long index, float value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            this.floatArray[this.offset + (int)index] = value;
        }

        @Override
        public UpdatableFloatArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, double value) {
            return this.fill(position, count, (float)value);
        }

        @Override
        public UpdatableFloatArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, long value) {
            return this.fill(position, count, (float)value);
        }

        @Override
        public UpdatableFloatArray fill(float value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, float value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.capacity < 0L) {
                this.reallocateStorage();
            }
            JArrays.fillFloatArray(this.floatArray, this.offset + (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableFloatArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new UpdatableJAFloatArray(this.floatArray, (int)(toIndex - fromIndex));
            }
            UpdatableJAFloatSubArray result = new UpdatableJAFloatSubArray(this.floatArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public UpdatableFloatArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new UpdatableJAFloatArray(this.floatArray, (int)count);
            }
            UpdatableJAFloatSubArray result = new UpdatableJAFloatSubArray(this.floatArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public final FloatArray asImmutable() {
            return new JAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final FloatArray asTrustedImmutable() {
            TrustedJAFloatSubArray result = new TrustedJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableJAFloatSubArray result = new UpdatableJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableFloatArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART subarray float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableJAFloatArray
    extends TrustedJAFloatArray
    implements UpdatableFloatArray {
        UpdatableJAFloatArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        UpdatableJAFloatArray(float[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
        }

        UpdatableJAFloatArray(float[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setFloat(index, ((Float)value).floatValue());
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            this.floatArray[(int)destIndex] = this.floatArray[(int)srcIndex];
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            System.arraycopy(this.floatArray, (int)srcIndex, this.floatArray, (int)destIndex, (int)count);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            float temp = this.floatArray[i];
            this.floatArray[i] = this.floatArray[j];
            this.floatArray[j] = temp;
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            int i = (int)firstIndex;
            int j = (int)secondIndex;
            int iMax = i + (int)count;
            while (i < iMax) {
                float temp = this.floatArray[i];
                this.floatArray[i] = this.floatArray[j];
                this.floatArray[j] = temp;
                ++i;
                ++j;
            }
        }

        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof JAFloatSubArray) {
                JAFloatSubArray a = (JAFloatSubArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count == 1) {
                    this.floatArray[0] = a.floatArray[a.offset];
                    return this;
                }
                if (count > 0) {
                    System.arraycopy(a.floatArray, a.offset, this.floatArray, 0, count);
                    return this;
                }
            } else if (src instanceof JAFloatArray) {
                JAFloatArray a = (JAFloatArray)src;
                int count = (int)Math.min(a.length, this.length);
                if (count > 0) {
                    System.arraycopy(a.floatArray, 0, this.floatArray, 0, count);
                }
                return this;
            }
            UpdatableJAFloatArray.defaultCopy(this, src);
            return this;
        }

        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableJAFloatSubArray) {
                UpdatableJAFloatSubArray a = (UpdatableJAFloatSubArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    int j = a.offset;
                    int i = 0;
                    while (i < count) {
                        float temp = this.floatArray[i];
                        this.floatArray[i] = a.floatArray[j];
                        a.floatArray[j] = temp;
                        ++i;
                        ++j;
                    }
                    return this;
                }
            } else if (another instanceof UpdatableJAFloatArray) {
                UpdatableJAFloatArray a = (UpdatableJAFloatArray)another;
                int count = (int)Math.min(a.length, this.length);
                if (count < 100) {
                    for (int i = 0; i < count; ++i) {
                        float temp = this.floatArray[i];
                        this.floatArray[i] = a.floatArray[i];
                        a.floatArray[i] = temp;
                    }
                    return this;
                }
            }
            UpdatableJAFloatArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setFloat(index, (float)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setFloat(index, value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.floatArray[(int)index] = value;
        }

        @Override
        public final void setFloat(long index, float value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            this.floatArray[(int)index] = value;
        }

        @Override
        public UpdatableFloatArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, double value) {
            return this.fill(position, count, (float)value);
        }

        @Override
        public UpdatableFloatArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, long value) {
            return this.fill(position, count, (float)value);
        }

        @Override
        public UpdatableFloatArray fill(float value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, float value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            JArrays.fillFloatArray(this.floatArray, (int)position, (int)count, value);
            return this;
        }

        @Override
        public UpdatableFloatArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new UpdatableJAFloatArray(this.floatArray, (int)(toIndex - fromIndex));
            }
            return new UpdatableJAFloatSubArray(this.floatArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public UpdatableFloatArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new UpdatableJAFloatArray(this.floatArray, (int)count);
            }
            return new UpdatableJAFloatSubArray(this.floatArray, (int)count, (int)position);
        }

        @Override
        public final FloatArray asImmutable() {
            return new JAFloatArray(this.floatArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public final FloatArray asTrustedImmutable() {
            return new TrustedJAFloatArray(this.floatArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableJAFloatSubArray result = new UpdatableJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public UpdatableFloatArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableArray)((Object)this.standardObjectClone());
        }

        @Override
        public String toString() {
            return "unresizable simple AlgART array float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAFloatSubArray
    extends JAFloatSubArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAFloatSubArray(float[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, initialCapacity, initialLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAFloatSubArray(float[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, initialCapacityAndLength, initialOffset);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return this.offset;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.offset == 0 && this.length == (long)this.floatArray.length;
        }

        @Override
        public float[] ja() {
            if (this.offset == 0 && this.length == (long)this.floatArray.length) {
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                }
                return this.floatArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L && this.capacity >= 0L) {
                return new TrustedJAFloatArray(this.floatArray, (int)(toIndex - fromIndex));
            }
            TrustedJAFloatSubArray result = new TrustedJAFloatSubArray(this.floatArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L && this.capacity >= 0L) {
                return new TrustedJAFloatArray(this.floatArray, (int)count);
            }
            TrustedJAFloatSubArray result = new TrustedJAFloatSubArray(this.floatArray, (int)count, this.offset + (int)position);
            if (this.capacity < 0L) {
                result.capacity |= Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public FloatArray asImmutable() {
            return new JAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            TrustedJAFloatSubArray result = new TrustedJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), this.offset);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART subarray float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class TrustedJAFloatArray
    extends JAFloatArray
    implements DirectAccessible {
        private int startHashCode = -1;

        TrustedJAFloatArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
        }

        TrustedJAFloatArray(float[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, initialCapacity, initialLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        TrustedJAFloatArray(float[] initialArray, int initialCapacityAndLength) {
            super(initialArray, initialCapacityAndLength);
            if (!(this instanceof UpdatableArray)) {
                this.startHashCode = this.hashCode();
            }
        }

        @Override
        public int javaArrayOffset() {
            return 0;
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return this.length == (long)this.floatArray.length;
        }

        @Override
        public float[] ja() {
            if (this.length == (long)this.floatArray.length) {
                return this.floatArray;
            }
            return this.toJavaArray();
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new TrustedJAFloatArray(this.floatArray, (int)(toIndex - fromIndex));
            }
            return new TrustedJAFloatSubArray(this.floatArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new TrustedJAFloatArray(this.floatArray, (int)count);
            }
            return new TrustedJAFloatSubArray(this.floatArray, (int)count, (int)position);
        }

        @Override
        public FloatArray asImmutable() {
            return new JAFloatArray(this.floatArray, (int)this.capacity(), (int)this.length());
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
            if (this.hashCode() != this.startHashCode) {
                throw new UnallowedMutationError("Unallowed mutations of trusted immutable array are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            TrustedJAFloatSubArray result = new TrustedJAFloatSubArray(this.floatArray, (int)this.capacity(), (int)this.length(), 0);
            result.capacity |= Long.MIN_VALUE;
            return result;
        }

        @Override
        public String toString() {
            return "trusted immutable simple AlgART array float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAFloatSubArray
    extends AbstractJAArray
    implements FloatArray {
        float[] floatArray;
        int offset;

        JAFloatSubArray(float[] initialArray, int initialCapacity, int initialLength, int initialOffset) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.floatArray = initialArray;
            this.offset = initialOffset;
        }

        JAFloatSubArray(float[] initialArray, int initialCapacityAndLength, int initialOffset) {
            super(initialArray, (long)initialCapacityAndLength);
            this.floatArray = initialArray;
            this.offset = initialOffset;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.floatArray = (float[])this.array;
            this.offset = 0;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return this.offset;
        }

        @Override
        public final Class<?> elementType() {
            return Float.TYPE;
        }

        @Override
        public Class<? extends FloatArray> type() {
            return FloatArray.class;
        }

        @Override
        public Class<? extends UpdatableFloatArray> updatableType() {
            return UpdatableFloatArray.class;
        }

        @Override
        public Class<? extends MutableFloatArray> mutableType() {
            return MutableFloatArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return Float.valueOf(this.getFloat(index));
        }

        @Override
        public final long bitsPerElement() {
            return 32L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public long minPossibleValue() {
            return -157777L;
        }

        public long maxPossibleValue() {
            return 157778L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.floatArray[this.offset + (int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (long)this.floatArray[this.offset + (int)index];
        }

        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (int)this.floatArray[this.offset + (int)index];
        }

        public final long indexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public final float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.floatArray[this.offset + (int)index];
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.indexOfFloat(this.floatArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            long i = JArrays.lastIndexOfFloat(this.floatArray, this.offset + (int)lowIndex, this.offset + (int)highIndex, value);
            return i == -1L ? -1L : i - (long)this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if ((long)this.offset + fromIndex == 0L) {
                return new JAFloatArray(this.floatArray, (int)(toIndex - fromIndex));
            }
            return new JAFloatSubArray(this.floatArray, (int)(toIndex - fromIndex), this.offset + (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if ((long)this.offset + position == 0L) {
                return new JAFloatArray(this.floatArray, (int)count);
            }
            return new JAFloatSubArray(this.floatArray, (int)count, this.offset + (int)position);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataFloatBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataFloatBuffer)super.buffer(mode);
        }

        @Override
        public DataFloatBuffer buffer(long capacity) {
            return (DataFloatBuffer)super.buffer(capacity);
        }

        @Override
        public DataFloatBuffer buffer() {
            return (DataFloatBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public FloatArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public FloatArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableFloatArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableFloatArray)new MutableJAFloatArray(JArrays.copyOfRange(this.floatArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableFloatArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableFloatArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableFloatArray)new UpdatableJAFloatArray(JArrays.copyOfRange(this.floatArray, this.offset, this.offset + (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableFloatArray)super.updatableClone(memoryModel);
        }

        @Override
        public float[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART subarray float[" + this.length() + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + ", start offset = " + this.offset + (this.isNew() ? ", new" : ", view");
        }
    }

    static class JAFloatArray
    extends AbstractJAArray
    implements FloatArray {
        float[] floatArray;

        JAFloatArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.floatArray = (float[])this.array;
        }

        JAFloatArray(float[] initialArray, int initialCapacity, int initialLength) {
            super(initialArray, (long)initialCapacity, initialLength);
            this.floatArray = initialArray;
        }

        JAFloatArray(float[] initialArray, int initialCapacityAndLength) {
            super(initialArray, (long)initialCapacityAndLength);
            this.floatArray = initialArray;
        }

        @Override
        final void afterStorageFieldCorrection() {
            this.floatArray = (float[])this.array;
        }

        @Override
        final long longJavaArrayOffsetInternal() {
            return 0L;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }

        @Override
        public final Class<?> elementType() {
            return Float.TYPE;
        }

        @Override
        public Class<? extends FloatArray> type() {
            return FloatArray.class;
        }

        @Override
        public Class<? extends UpdatableFloatArray> updatableType() {
            return UpdatableFloatArray.class;
        }

        @Override
        public Class<? extends MutableFloatArray> mutableType() {
            return MutableFloatArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return Float.valueOf(this.getFloat(index));
        }

        @Override
        public final long bitsPerElement() {
            return 32L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public final long minPossibleValue() {
            return -157777L;
        }

        public final long maxPossibleValue() {
            return 157778L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.floatArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (long)this.floatArray[(int)index];
        }

        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (int)this.floatArray[(int)index];
        }

        public final long indexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public final float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.floatArray[(int)index];
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.indexOfFloat(this.floatArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JArrays.lastIndexOfFloat(this.floatArray, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            if (fromIndex == 0L) {
                return new JAFloatArray(this.floatArray, (int)(toIndex - fromIndex));
            }
            return new JAFloatSubArray(this.floatArray, (int)(toIndex - fromIndex), (int)fromIndex);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (position == 0L) {
                return new JAFloatArray(this.floatArray, (int)count);
            }
            return new JAFloatSubArray(this.floatArray, (int)count, (int)position);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataFloatBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataFloatBuffer)super.buffer(mode);
        }

        @Override
        public DataFloatBuffer buffer(long capacity) {
            return (DataFloatBuffer)super.buffer(capacity);
        }

        @Override
        public DataFloatBuffer buffer() {
            return (DataFloatBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public FloatArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public FloatArray asTrustedImmutable() {
            return this;
        }

        @Override
        public void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableFloatArray mutableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (MutableFloatArray)new MutableJAFloatArray(JArrays.copyOfRange(this.floatArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (MutableFloatArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableFloatArray updatableClone(MemoryModel memoryModel) {
            if (memoryModel == SimpleMemoryModel.INSTANCE) {
                return (UpdatableFloatArray)new UpdatableJAFloatArray(JArrays.copyOfRange(this.floatArray, 0, (int)this.length), (int)this.length).setNewStatus();
            }
            return (UpdatableFloatArray)super.updatableClone(memoryModel);
        }

        @Override
        public float[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable simple AlgART array float[" + this.length + "], built-in Java-array @" + Integer.toHexString(System.identityHashCode(this.floatArray)) + ", capacity " + this.capacity() + (this.isNew() ? ", new" : ", view");
        }
    }

    static abstract class AbstractJAArray
    extends AbstractArray {
        protected static final long HIGH_BIT = Long.MIN_VALUE;
        protected Object array;

        AbstractJAArray(long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            if (this.elementType() != null) {
                this.array = this.allocateArray(this.capacity());
            }
            if (!(this instanceof UpdatableArray)) {
                throw new AssertionError((Object)"Internal error in SimpleMemoryModel implementation (unallowed constructor call)");
            }
            this.setNewStatus();
        }

        AbstractJAArray(Object initialArray, long initialCapacity, long initialLength) {
            super(initialCapacity, initialLength);
            this.array = initialArray;
        }

        AbstractJAArray(Object initialArray, long initialCapacityAndLength) {
            super(initialCapacityAndLength);
            this.array = initialArray;
        }

        final Object allocateArray(long capacity) {
            if (capacity < 0L) {
                throw new AssertionError((Object)("Negative capacity in package-private method " + this.getClass().getName() + ".allocateArray(long)"));
            }
            long arrayLength = capacity;
            if (this instanceof BitArray) {
                arrayLength = PackedBitArrays.packedLength(capacity);
            }
            if (arrayLength != (long)((int)arrayLength)) {
                throw new TooLargeArrayException("Too large desired array capacity for SimpleMemoryModel: " + capacity + " = 0x" + Long.toHexString(capacity) + " (" + String.valueOf(this) + ")");
            }
            if (this instanceof BitArray) {
                return new long[(int)arrayLength];
            }
            return java.lang.reflect.Array.newInstance(this.elementType(), (int)arrayLength);
        }

        abstract long longJavaArrayOffsetInternal();

        final void reallocateStorage() {
            if (this.isImmutable()) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (unallowed reallocation)");
            }
            Object newArray = this.allocateArray(this.length);
            if (this instanceof BitArray) {
                PackedBitArrays.copyBits((long[])newArray, 0L, (long[])this.array, this.longJavaArrayOffsetInternal(), this.length);
            } else {
                System.arraycopy(this.array, this.javaArrayOffsetInternal(), newArray, 0, (int)this.length);
            }
            this.array = newArray;
            this.capacity &= Long.MAX_VALUE;
            this.afterStorageFieldCorrection();
            this.setNewStatus();
        }

        @Override
        public final void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            if (this instanceof BitArray) {
                PackedBitArrays.unpackBits((boolean[])destArray, destArrayOffset, (long[])this.array, this.longJavaArrayOffsetInternal() + arrayPos, count);
            } else {
                System.arraycopy(this.array, this.javaArrayOffsetInternal() + (int)arrayPos, destArray, destArrayOffset, count);
            }
        }

        @Override
        public final void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (arrayPos < 0L || arrayPos > this.length) {
                throw this.rangeException(arrayPos);
            }
            int count = java.lang.reflect.Array.getLength(destArray);
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            if (this instanceof BitArray) {
                PackedBitArrays.unpackBits((boolean[])destArray, 0, (long[])this.array, this.longJavaArrayOffsetInternal() + arrayPos, count);
            } else {
                System.arraycopy(this.array, this.javaArrayOffsetInternal() + (int)arrayPos, destArray, 0, count);
            }
        }

        public final void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            if (!(this instanceof BitArray)) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (unallowed getBits)");
            }
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - count) {
                throw this.rangeException(arrayPos + count - 1L);
            }
            PackedBitArrays.copyBits(destArray, destArrayOffset, (long[])this.array, this.longJavaArrayOffsetInternal() + arrayPos, count);
        }

        public long nextQuickPosition(long from) {
            if (from >= this.length) {
                return -1L;
            }
            long offset = this.longJavaArrayOffsetInternal();
            long result = (offset + (from < 0L ? 63L : from + 63L) & 0xFFFFFFFFFFFFFFC0L) - offset;
            assert ((offset + result) % 64L == 0L);
            if (result < 0L || result >= this.length) {
                return -1L;
            }
            return result;
        }

        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (unallowed setData)");
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            if (this instanceof BitArray) {
                PackedBitArrays.packBits((long[])this.array, this.longJavaArrayOffsetInternal() + arrayPos, (boolean[])srcArray, srcArrayOffset, count);
            } else {
                System.arraycopy(srcArray, srcArrayOffset, this.array, this.javaArrayOffsetInternal() + (int)arrayPos, count);
            }
            return (UpdatableArray)((Object)this);
        }

        public UpdatableArray setData(long arrayPos, Object srcArray) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (unallowed setData)");
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (arrayPos < 0L || arrayPos > this.length) {
                throw this.rangeException(arrayPos);
            }
            int count = java.lang.reflect.Array.getLength(srcArray);
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            if (this instanceof BitArray) {
                PackedBitArrays.packBits((long[])this.array, this.longJavaArrayOffsetInternal() + arrayPos, (boolean[])srcArray, 0, count);
            } else {
                System.arraycopy(srcArray, 0, this.array, this.javaArrayOffsetInternal() + (int)arrayPos, count);
            }
            return (UpdatableArray)((Object)this);
        }

        public Object get(long index) {
            return this.getElement(index);
        }

        public void set(long index, Object value) {
            ((UpdatableArray)((Object)this)).setElement(index, value);
        }

        public Object pop() {
            return ((MutableArray)((Object)this)).popElement();
        }

        public void push(Object value) {
            ((MutableArray)((Object)this)).pushElement(value);
        }

        public UpdatableBitArray setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            if (!(this instanceof UpdatableBitArray)) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (unallowed setBits)");
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - count) {
                throw this.rangeException(arrayPos + count - 1L);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            PackedBitArrays.copyBits((long[])this.array, this.longJavaArrayOffsetInternal() + arrayPos, srcArray, srcArrayOffset, count);
            return (UpdatableBitArray)((Object)this);
        }

        public void setNonNew() {
            this.setNewStatus(false);
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return false;
        }

        public final boolean hasJavaArray() {
            if (this instanceof BitArray) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (non-allowed hasJavaArray())");
            }
            return true;
        }

        public final Object javaArray() {
            if (this instanceof BitArray) {
                throw new InternalError("Internal error in SimpleMemoryModel implementation (non-allowed javaArray())");
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            return this.array;
        }

        public final int javaArrayLength() {
            return (int)this.length;
        }

        final void ensureCapacityImpl(long minCapacity) {
            long currentCapacity = this.capacity();
            if (minCapacity > currentCapacity) {
                long newCapacity = Math.min(SimpleMemoryModel.maxSupportedLengthImpl(this.elementType()), currentCapacity < 10000L ? currentCapacity * 3L : (currentCapacity < 500000L ? currentCapacity * 2L : currentCapacity * 3L / 2L + 1L));
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                Object newArray = this.allocateArray(newCapacity);
                if (this instanceof BitArray) {
                    PackedBitArrays.copyBits((long[])newArray, 0L, (long[])this.array, this.longJavaArrayOffsetInternal(), this.length);
                } else {
                    System.arraycopy(this.array, this.javaArrayOffsetInternal(), newArray, 0, (int)this.length);
                }
                this.array = newArray;
                this.capacity = newCapacity;
                this.afterStorageFieldCorrection();
            }
        }

        final void lengthImpl(long newLength) {
            if (newLength != this.length) {
                this.ensureCapacityImpl(newLength);
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                } else if (newLength < this.length) {
                    this.clearElements(newLength, this.length);
                }
                this.length = newLength;
            }
        }

        final void trimImpl() {
            if (this.length < this.capacity()) {
                Object newArray = this.allocateArray(this.length);
                if (this instanceof BitArray) {
                    PackedBitArrays.copyBits((long[])newArray, 0L, (long[])this.array, this.longJavaArrayOffsetInternal(), this.length);
                } else {
                    System.arraycopy(this.array, this.javaArrayOffsetInternal(), newArray, 0, (int)this.length);
                }
                this.array = newArray;
                this.capacity = this.length;
                this.afterStorageFieldCorrection();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        final void appendImpl(Array appendedArray) {
            if (appendedArray instanceof AbstractJAArray) {
                AbstractJAArray a = (AbstractJAArray)appendedArray;
                if (appendedArray.elementType() == this.elementType()) {
                    long currentLength = this.length;
                    long appendedLength = a.length;
                    Object vArray = a.array;
                    long vArrayOffset = a.longJavaArrayOffsetInternal();
                    if (appendedLength <= 0L) return;
                    Arrays.lengthUnsigned((MutableArray)((Object)this), currentLength + appendedLength);
                    if (this instanceof BitArray) {
                        PackedBitArrays.copyBits((long[])this.array, this.longJavaArrayOffsetInternal() + currentLength, (long[])vArray, vArrayOffset, appendedLength);
                        return;
                    }
                    System.arraycopy(vArray, (int)vArrayOffset, this.array, this.javaArrayOffsetInternal() + (int)currentLength, (int)appendedLength);
                    return;
                }
            }
            AbstractJAArray.defaultAppend((MutableArray)((Object)this), appendedArray);
        }

        @Override
        public final boolean isCopyOnNextWrite() {
            return this.capacity < 0L;
        }

        void clearElements(long fromIndex, long toIndex) {
        }

        void afterStorageFieldCorrection() {
        }

        @Override
        final Object javaArrayInternal() {
            if (this instanceof BitArray) {
                return null;
            }
            return this.array;
        }
    }
}

