/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Histogram;
import net.algart.arrays.JArrays;

public abstract class SummingHistogram
extends Histogram {
    SummingHistogram(int length) {
        super(length);
    }

    public static SummingHistogram newSummingLongHistogram(int histogramLength, int ... bitLevelsOfPyramid) {
        return SummingHistogram.newSummingLongHistogram(histogramLength, false, bitLevelsOfPyramid);
    }

    public static SummingHistogram newSummingLongHistogram(int histogramLength, boolean optimizeSimpleIntegral, int ... bitLevelsOfPyramid) {
        if (histogramLength < 0) {
            throw new IllegalArgumentException("Negative histogramLength");
        }
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        if (optimizeSimpleIntegral) {
            return bitLevelsOfPyramid.length == 0 ? new SimplifiedSummingLong1LevelHistogram(new long[histogramLength], bitLevelsOfPyramid, true) : new SimplifiedSummingLongHistogram(new long[histogramLength], bitLevelsOfPyramid, true);
        }
        return bitLevelsOfPyramid.length == 0 ? new SummingLong1LevelHistogram(new long[histogramLength], bitLevelsOfPyramid, true) : new SummingLongHistogram(new long[histogramLength], bitLevelsOfPyramid, true);
    }

    public static SummingHistogram newSummingLongHistogram(long[] histogram, int ... bitLevelsOfPyramid) {
        return SummingHistogram.newSummingLongHistogram(histogram, false, bitLevelsOfPyramid);
    }

    public static SummingHistogram newSummingLongHistogram(long[] histogram, boolean optimizeSimpleIntegral, int ... bitLevelsOfPyramid) {
        Objects.requireNonNull(histogram, "Null histogram argument");
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        if (optimizeSimpleIntegral) {
            return bitLevelsOfPyramid.length == 0 ? new SimplifiedSummingLong1LevelHistogram((long[])histogram.clone(), bitLevelsOfPyramid, false) : new SimplifiedSummingLongHistogram((long[])histogram.clone(), bitLevelsOfPyramid, false);
        }
        return bitLevelsOfPyramid.length == 0 ? new SummingLong1LevelHistogram((long[])histogram.clone(), bitLevelsOfPyramid, false) : new SummingLongHistogram((long[])histogram.clone(), bitLevelsOfPyramid, false);
    }

    public static SummingHistogram newSummingIntHistogram(int histogramLength, int ... bitLevelsOfPyramid) {
        return SummingHistogram.newSummingIntHistogram(histogramLength, false, bitLevelsOfPyramid);
    }

    public static SummingHistogram newSummingIntHistogram(int histogramLength, boolean optimizeSimpleIntegral, int ... bitLevelsOfPyramid) {
        if (histogramLength < 0) {
            throw new IllegalArgumentException("Negative histogramLength");
        }
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        if (optimizeSimpleIntegral) {
            return bitLevelsOfPyramid.length == 0 ? new SimplifiedSummingInt1LevelHistogram(new int[histogramLength], bitLevelsOfPyramid, true) : new SimplifiedSummingIntHistogram(new int[histogramLength], bitLevelsOfPyramid, true);
        }
        return bitLevelsOfPyramid.length == 0 ? new SummingInt1LevelHistogram(new int[histogramLength], bitLevelsOfPyramid, true) : new SummingIntHistogram(new int[histogramLength], bitLevelsOfPyramid, true);
    }

    public static SummingHistogram newSummingIntHistogram(int[] histogram, int ... bitLevelsOfPyramid) {
        return SummingHistogram.newSummingIntHistogram(histogram, false, bitLevelsOfPyramid);
    }

    public static SummingHistogram newSummingIntHistogram(int[] histogram, boolean optimizeSimpleIntegral, int ... bitLevelsOfPyramid) {
        Objects.requireNonNull(histogram, "Null histogram argument");
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        if (optimizeSimpleIntegral) {
            return bitLevelsOfPyramid.length == 0 ? new SimplifiedSummingInt1LevelHistogram((int[])histogram.clone(), bitLevelsOfPyramid, false) : new SimplifiedSummingIntHistogram((int[])histogram.clone(), bitLevelsOfPyramid, false);
        }
        return bitLevelsOfPyramid.length == 0 ? new SummingInt1LevelHistogram((int[])histogram.clone(), bitLevelsOfPyramid, false) : new SummingIntHistogram((int[])histogram.clone(), bitLevelsOfPyramid, false);
    }

    @Override
    public abstract SummingHistogram nextSharing();

    @Override
    public abstract SummingHistogram share();

    public abstract int currentNumberOfDifferentValues();

    public abstract double currentSum();

    public final double currentIntegral() {
        double s;
        long r;
        long total = this.total();
        assert (this.currentValue >= (double)this.currentIValue - 0.5001) : "currentValue = " + this.currentValue + " < currentIValue - 0.5001, currentIValue = " + this.currentIValue;
        assert (this.currentValue < (double)this.currentIValue + 1.0001) : "currentValue = " + this.currentValue + " >= currentIValue + 1.0 = " + ((double)this.currentIValue + 1.0);
        if (total == 0L) {
            return 0.0;
        }
        boolean shifted = this.currentValue < (double)this.currentIValue;
        int v = shifted ? this.currentIValue - 1 : this.currentIValue;
        long b = this.bar(v);
        long l = r = shifted ? this.currentIRank() - b : this.currentIRank();
        if (r + b == 0L) {
            return 0.0;
        }
        double d = s = shifted ? this.currentSum() - (double)b * (double)v : this.currentSum();
        if (b == 0L) {
            return s + 0.5 * (double)r;
        }
        double delta = this.currentValue - (double)v;
        if (delta == 0.0) {
            return s + 0.5 * (double)r;
        }
        double indexInBar = b == 1L ? delta : delta * (double)b;
        return s + 0.5 * (double)r + indexInBar * ((double)v + 0.5 * delta);
    }

    public final double currentPreciseIntegral() {
        double sum1;
        double v1;
        int ndv;
        long total = this.total();
        assert (this.currentValue >= (double)this.currentIValue - 0.5001) : "currentValue = " + this.currentValue + " < currentIValue - 0.5001, currentIValue = " + this.currentIValue;
        assert (this.currentValue < (double)this.currentIValue + 1.0001) : "currentValue = " + this.currentValue + " >= currentIValue + 1.0 = " + ((double)this.currentIValue + 1.0);
        if (total == 0L) {
            return 0.0;
        }
        boolean shifted = this.currentValue < (double)this.currentIValue;
        int v = shifted ? this.currentIValue - 1 : this.currentIValue;
        long b = this.bar(v);
        long r = shifted ? this.currentIRank() - b : this.currentIRank();
        int savedIValue = this.currentIValue;
        double savedValue = this.currentValue;
        if (r + b == 0L) {
            this.saveRanks();
            this.moveToIRank(0L);
            double result = 0.5 * this.currentValue;
            this.restoreRanks();
            this.currentIValue = savedIValue;
            this.currentValue = savedValue;
            return result;
        }
        int n = ndv = shifted && b > 0L ? this.currentNumberOfDifferentValues() - 1 : this.currentNumberOfDifferentValues();
        if (r == total) {
            assert (!shifted);
            this.saveRanks();
            this.moveToIRank(total);
            double result = this.currentSum() + 0.5 * (double)r + 0.5 * (this.currentValue - (double)ndv);
            this.restoreRanks();
            this.currentIValue = savedIValue;
            this.currentValue = savedValue;
            return result;
        }
        assert (r < total);
        double delta = this.currentValue - (double)v;
        if (b > 0L && delta == 0.0) {
            double s = shifted ? this.currentSum() - (double)b * (double)v : this.currentSum();
            return s + 0.5 * (double)r + 0.5 * (double)(v - ndv);
        }
        double savedPreciseRank = this.currentPreciseRank;
        boolean needRank = Double.isNaN(savedPreciseRank);
        if (b > 1L) {
            double s = shifted ? this.currentSum() - (double)b * (double)v : this.currentSum();
            double indexInBar = delta * (double)b;
            if (indexInBar <= (double)(b - 1L) || r + b == total) {
                if (needRank) {
                    this.currentPreciseRank = (double)r + indexInBar;
                }
                return s + 0.5 * (double)r + 0.5 * (double)(v - ndv) + indexInBar * ((double)v + 0.5 * delta);
            }
            v1 = (double)v + (double)(b - 1L) / (double)b;
            sum1 = s + 0.5 * (double)r + 0.5 * (double)(v - ndv) + (double)(b - 1L) * 0.5 * ((double)v + v1);
            this.saveRanks();
        } else {
            if (r + b == total) {
                assert (!shifted);
                assert (b == 1L);
                if (needRank) {
                    this.currentPreciseRank = (double)r + delta;
                }
                return this.currentSum() + 0.5 * (double)r + 0.5 * (double)(v - ndv) + delta * ((double)v + 0.5 * delta);
            }
            this.saveRanks();
            if (b == 1L) {
                v1 = v;
                double s = shifted ? this.currentSum() - (double)b * (double)v : this.currentSum();
                sum1 = s + 0.5 * (double)r + 0.5 * (double)(v - ndv);
            } else {
                assert (r > 0L);
                assert (b == 0L);
                this.moveToIRank(r - 1L);
                long r1 = this.currentIRank();
                long b1 = this.bar(this.currentIValue);
                assert (b1 == r - r1);
                assert (this.currentNumberOfDifferentValues() == ndv - 1);
                v1 = this.currentValue;
                sum1 = this.currentSum() + 0.5 * (double)r1 + 0.5 * (double)(this.currentIValue - ndv + 1) + (double)(b1 - 1L) * 0.5 * ((double)this.currentIValue + v1);
            }
        }
        this.moveToIRank(r + b);
        assert (this.currentValue == (double)this.currentIValue) : "bug: we are not at the left boundary of the bar #" + this.currentIValue + ", we at " + this.currentValue;
        double v2 = this.currentValue;
        this.restoreRanks();
        this.currentIValue = savedIValue;
        this.currentValue = savedValue;
        assert (v1 < v2) : "bug: illegal " + v1 + ".." + v2 + " range";
        assert (v1 <= this.currentValue && this.currentValue <= v2) : "bug: currentValue = " + this.currentValue + " is not in " + v1 + ".." + v2 + " range";
        double deltaRank = (this.currentValue - v1) / (v2 - v1);
        double newPreciseRank = (double)(r + b - 1L) + deltaRank;
        if (needRank) {
            this.currentPreciseRank = newPreciseRank;
        } else {
            this.currentPreciseRank = savedPreciseRank;
            assert (Math.abs(this.currentPreciseRank - newPreciseRank) <= 0.001) : "bug: currentPreciseRank should be " + newPreciseRank + ", but saved value is " + savedPreciseRank;
        }
        return sum1 + deltaRank * 0.5 * (v1 + this.currentValue);
    }

    public final double currentIntegralBetweenSharing() {
        double correction2;
        double indexInBar;
        double correction1;
        double delta;
        double s2;
        SummingHistogram next = this.nextSharing();
        long total = this.total();
        assert (this.currentValue >= (double)this.currentIValue - 0.5001) : "currentValue = " + this.currentValue + " < currentIValue - 0.5001, currentIValue = " + this.currentIValue;
        assert (this.currentValue < (double)this.currentIValue + 1.0001) : "currentValue = " + this.currentValue + " >= currentIValue + 1.0 = " + ((double)this.currentIValue + 1.0);
        assert (next.currentValue >= (double)next.currentIValue - 0.5001) : "next.currentValue = " + next.currentValue + " < next.currentIValue - 0.5001, next.currentIValue = " + next.currentIValue;
        assert (next.currentValue < (double)next.currentIValue + 1.0001) : "next.currentValue = " + next.currentValue + " >= next.currentIValue + 1.0 = " + ((double)next.currentIValue + 1.0);
        assert (total == next.total());
        if (total == 0L) {
            return 0.0;
        }
        boolean shifted1 = this.currentValue < (double)this.currentIValue;
        int v1 = shifted1 ? this.currentIValue - 1 : this.currentIValue;
        long b1 = this.bar(v1);
        long r1 = shifted1 ? this.currentIRank() - b1 : this.currentIRank();
        boolean shifted2 = next.currentValue < (double)next.currentIValue;
        int v2 = shifted2 ? next.currentIValue - 1 : next.currentIValue;
        long b2 = next.bar(v2);
        long r2 = shifted2 ? next.currentIRank() - b2 : next.currentIRank();
        double s1 = shifted1 ? this.currentSum() - (double)b1 * (double)v1 : this.currentSum();
        double d = s2 = shifted2 ? next.currentSum() - (double)b2 * (double)v2 : next.currentSum();
        if (b1 == 0L || (delta = this.currentValue - (double)v1) == 0.0) {
            correction1 = 0.0;
        } else {
            indexInBar = b1 == 1L ? delta : delta * (double)b1;
            correction1 = indexInBar * ((double)v1 + 0.5 * delta);
        }
        if (b2 == 0L || (delta = next.currentValue - (double)v2) == 0.0) {
            correction2 = 0.0;
        } else {
            indexInBar = b2 == 1L ? delta : delta * (double)b2;
            correction2 = indexInBar * ((double)v2 + 0.5 * delta);
        }
        return s2 - s1 + 0.5 * (double)(r2 - r1) + (correction2 - correction1);
    }

    public final double currentPreciseIntegralBetweenSharing() {
        return this.nextSharing().currentPreciseIntegral() - this.currentPreciseIntegral();
    }

    @Override
    public abstract SummingHistogram moveToIRank(long var1);

    @Override
    public abstract SummingHistogram moveToIValue(int var1);

    @Override
    public SummingHistogram moveToPreciseRank(double rank) {
        return (SummingHistogram)super.moveToPreciseRank(rank);
    }

    @Override
    public SummingHistogram moveToValue(double value) {
        return (SummingHistogram)super.moveToValue(value);
    }

    public static double integralBetweenRanks(long[] histogram, double fromRank, double toRank) {
        int toV;
        int fromV;
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(fromRank)) {
            throw new IllegalArgumentException("Illegal fromRank argument (NaN)");
        }
        if (Double.isNaN(toRank)) {
            throw new IllegalArgumentException("Illegal toRank argument (NaN)");
        }
        if (fromRank < 0.0) {
            fromRank = 0.0;
        }
        if (toRank < 0.0) {
            toRank = 0.0;
        }
        if (fromRank >= toRank) {
            return 0.0;
        }
        long fromR = (long)fromRank;
        long toR = (long)toRank;
        long acc = 0L;
        long b = 0L;
        for (fromV = 0; fromV < histogram.length; ++fromV) {
            b = histogram[fromV];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + fromV + "]=" + b);
            }
            if (fromR < (acc += b)) break;
        }
        if (fromV >= histogram.length) {
            return 0.0;
        }
        assert (b > 0L);
        assert (fromR < acc);
        if (toRank <= (double)acc) {
            double middleRank = 0.5 * (fromRank + toRank);
            return (toRank - fromRank) * ((double)toV - ((double)acc - middleRank) / (double)b);
        }
        double sum = ((double)acc - fromRank) * ((double)toV - 0.5 * ((double)acc - fromRank) / (double)b);
        for (toV = fromV + 1; toV < histogram.length; ++toV) {
            b = histogram[toV];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + toV + "]=" + b);
            }
            if (b <= 0L) continue;
            if (toR < (acc += b)) {
                sum += (toRank - (double)(acc - b)) * ((double)toV + 0.5 * (toRank - (double)(acc - b)) / (double)b);
                break;
            }
            sum += (double)b * ((double)toV + 0.5);
        }
        return sum;
    }

    public static double integralBetweenRanks(int[] histogram, double fromRank, double toRank) {
        int toV;
        int fromV;
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(fromRank)) {
            throw new IllegalArgumentException("Illegal fromRank argument (NaN)");
        }
        if (Double.isNaN(toRank)) {
            throw new IllegalArgumentException("Illegal toRank argument (NaN)");
        }
        if (fromRank < 0.0) {
            fromRank = 0.0;
        }
        if (toRank < 0.0) {
            toRank = 0.0;
        }
        if (fromRank >= toRank) {
            return 0.0;
        }
        int fromR = (int)fromRank;
        int toR = (int)toRank;
        int acc = 0;
        int b = 0;
        for (fromV = 0; fromV < histogram.length; ++fromV) {
            b = histogram[fromV];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + fromV + "]=" + b);
            }
            if (fromR < (acc += b)) break;
        }
        if (fromV >= histogram.length) {
            return 0.0;
        }
        assert (b > 0);
        assert (fromR < acc);
        if (toRank <= (double)acc) {
            double middleRank = 0.5 * (fromRank + toRank);
            return (toRank - fromRank) * ((double)toV - ((double)acc - middleRank) / (double)b);
        }
        double sum = ((double)acc - fromRank) * ((double)toV - 0.5 * ((double)acc - fromRank) / (double)b);
        for (toV = fromV + 1; toV < histogram.length; ++toV) {
            b = histogram[toV];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + toV + "]=" + b);
            }
            if (b <= 0) continue;
            if (toR < (acc += b)) {
                sum += (toRank - (double)(acc - b)) * ((double)toV + 0.5 * (toRank - (double)(acc - b)) / (double)b);
                break;
            }
            sum += (double)b * ((double)toV + 0.5);
        }
        return sum;
    }

    public static double preciseIntegralBetweenRanks(long[] histogram, double fromRank, double toRank) {
        double result = SummingHistogram.preciseIntegralBetweenRanksImpl(histogram, fromRank, toRank);
        return result;
    }

    public static double preciseIntegralBetweenRanks(int[] histogram, double fromRank, double toRank) {
        double result = SummingHistogram.preciseIntegralBetweenRanksImpl(histogram, fromRank, toRank);
        return result;
    }

    private static double preciseIntegralBetweenRanksImpl(long[] histogram, double fromRank, double toRank) {
        double fromIntegral;
        int leftV;
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(fromRank)) {
            throw new IllegalArgumentException("Illegal fromRank argument (NaN)");
        }
        if (Double.isNaN(toRank)) {
            throw new IllegalArgumentException("Illegal toRank argument (NaN)");
        }
        if (fromRank < 0.0) {
            fromRank = 0.0;
        }
        if (toRank < 0.0) {
            toRank = 0.0;
        }
        if (fromRank >= toRank) {
            return 0.0;
        }
        long fromR = (long)fromRank;
        long toR = (long)toRank;
        long acc = 0L;
        long b = 0L;
        for (leftV = 0; leftV < histogram.length; ++leftV) {
            b = histogram[leftV];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + b);
            }
            if (fromR < (acc += b)) break;
        }
        if (leftV >= histogram.length) {
            return 0.0;
        }
        long leftR = acc - b;
        assert (b > 0L);
        assert (leftR <= fromR);
        assert (fromRank < (double)(leftR + b));
        long indexInBar = fromR - leftR;
        assert (indexInBar < b);
        if (fromRank == (double)fromR || indexInBar < b - 1L) {
            fromIntegral = b == 1L ? 0.0 : (fromRank - (double)leftR) * ((double)leftV + 0.5 * (fromRank - (double)leftR) / (double)b);
        } else {
            assert (indexInBar == b - 1L);
            assert (fromR + 1L == acc);
            int rightV = SummingHistogram.nextNonZero(histogram, leftV + 1);
            if (rightV == -1) {
                if (toRank > (double)acc) {
                    toRank = acc;
                }
                double middleRank = 0.5 * (fromRank + toRank);
                return (toRank - fromRank) * ((double)leftV + (middleRank - (double)leftR) / (double)b);
            }
            double wideTrapDeltaV = b == 1L ? 0.0 : (double)(b - 1L) / (double)b;
            double wideTrap = b == 1L ? 0.0 : (double)(b - 1L) * ((double)leftV + 0.5 * wideTrapDeltaV);
            double leftValue = (double)leftV + wideTrapDeltaV;
            double fromDelta = fromRank - (double)fromR;
            double partialNarrowTrap = fromDelta * (leftValue + 0.5 * fromDelta * ((double)rightV - leftValue));
            fromIntegral = wideTrap + partialNarrowTrap;
        }
        double toIntegral = 0.0;
        if (toR >= acc) {
            int lastNonZero = Integer.MAX_VALUE;
            acc -= b;
            while (leftV < histogram.length) {
                b = histogram[leftV];
                if (b < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + b);
                }
                if (b > 0L) {
                    if (leftV - lastNonZero > 1) {
                        toIntegral += 0.5 * (double)(leftV - lastNonZero - 1);
                    }
                    lastNonZero = leftV;
                    if (toR < (acc += b)) break;
                    toIntegral += (double)b * ((double)leftV + 0.5);
                }
                ++leftV;
            }
            if (leftV >= histogram.length) {
                return toIntegral - fromIntegral;
            }
            leftR = acc - b;
        }
        assert (b > 0L);
        assert (toR < acc);
        assert (leftR <= toR);
        assert (toRank < (double)(leftR + b));
        indexInBar = toR - leftR;
        assert (indexInBar < b);
        if (toRank == (double)toR || indexInBar < b - 1L) {
            if (b > 1L) {
                toIntegral += (toRank - (double)leftR) * ((double)leftV + 0.5 * (toRank - (double)leftR) / (double)b);
            }
        } else {
            assert (indexInBar == b - 1L);
            assert (toR + 1L == acc);
            int rightV = SummingHistogram.nextNonZero(histogram, leftV + 1);
            if (rightV == -1) {
                if (toRank > (double)acc) {
                    toRank = acc;
                }
                return (toIntegral += (toRank - (double)leftR) * ((double)leftV + 0.5 * (toRank - (double)leftR) / (double)b)) - fromIntegral;
            }
            double wideTrapDeltaV = b == 1L ? 0.0 : (double)(b - 1L) / (double)b;
            double wideTrap = b == 1L ? 0.0 : (double)(b - 1L) * ((double)leftV + 0.5 * wideTrapDeltaV);
            double leftValue = (double)leftV + wideTrapDeltaV;
            double toDelta = toRank - (double)toR;
            double partialNarrowTrap = toDelta * (leftValue + 0.5 * toDelta * ((double)rightV - leftValue));
            toIntegral += wideTrap + partialNarrowTrap;
        }
        return toIntegral - fromIntegral;
    }

    private static double preciseIntegralBetweenRanksImpl(int[] histogram, double fromRank, double toRank) {
        double fromIntegral;
        int leftV;
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(fromRank)) {
            throw new IllegalArgumentException("Illegal fromRank argument (NaN)");
        }
        if (Double.isNaN(toRank)) {
            throw new IllegalArgumentException("Illegal toRank argument (NaN)");
        }
        if (fromRank < 0.0) {
            fromRank = 0.0;
        }
        if (toRank < 0.0) {
            toRank = 0.0;
        }
        if (fromRank >= toRank) {
            return 0.0;
        }
        int fromR = (int)fromRank;
        int toR = (int)toRank;
        int acc = 0;
        int b = 0;
        for (leftV = 0; leftV < histogram.length; ++leftV) {
            b = histogram[leftV];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + b);
            }
            if (fromR < (acc += b)) break;
        }
        if (leftV >= histogram.length) {
            return 0.0;
        }
        int leftR = acc - b;
        assert (b > 0);
        assert (leftR <= fromR);
        assert (fromRank < (double)(leftR + b));
        int indexInBar = fromR - leftR;
        assert (indexInBar < b);
        if (fromRank == (double)fromR || indexInBar < b - 1) {
            fromIntegral = b == 1 ? 0.0 : (fromRank - (double)leftR) * ((double)leftV + 0.5 * (fromRank - (double)leftR) / (double)b);
        } else {
            assert (indexInBar == b - 1);
            assert (fromR + 1 == acc);
            int rightV = SummingHistogram.nextNonZero(histogram, leftV + 1);
            if (rightV == -1) {
                if (toRank > (double)acc) {
                    toRank = acc;
                }
                double middleRank = 0.5 * (fromRank + toRank);
                return (toRank - fromRank) * ((double)leftV + (middleRank - (double)leftR) / (double)b);
            }
            double wideTrapDeltaV = b == 1 ? 0.0 : (double)(b - 1) / (double)b;
            double wideTrap = b == 1 ? 0.0 : (double)(b - 1) * ((double)leftV + 0.5 * wideTrapDeltaV);
            double leftValue = (double)leftV + wideTrapDeltaV;
            double fromDelta = fromRank - (double)fromR;
            double partialNarrowTrap = fromDelta * (leftValue + 0.5 * fromDelta * ((double)rightV - leftValue));
            fromIntegral = wideTrap + partialNarrowTrap;
        }
        double toIntegral = 0.0;
        if (toR >= acc) {
            int lastNonZero = Integer.MAX_VALUE;
            acc -= b;
            while (leftV < histogram.length) {
                b = histogram[leftV];
                if (b < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + b);
                }
                if (b > 0) {
                    if (leftV - lastNonZero > 1) {
                        toIntegral += 0.5 * (double)(leftV - lastNonZero - 1);
                    }
                    lastNonZero = leftV;
                    if (toR < (acc += b)) break;
                    toIntegral += (double)b * ((double)leftV + 0.5);
                }
                ++leftV;
            }
            if (leftV >= histogram.length) {
                return toIntegral - fromIntegral;
            }
            leftR = acc - b;
        }
        assert (b > 0);
        assert (toR < acc);
        assert (leftR <= toR);
        assert (toRank < (double)(leftR + b));
        indexInBar = toR - leftR;
        assert (indexInBar < b);
        if (toRank == (double)toR || indexInBar < b - 1) {
            if (b > 1) {
                toIntegral += (toRank - (double)leftR) * ((double)leftV + 0.5 * (toRank - (double)leftR) / (double)b);
            }
        } else {
            assert (indexInBar == b - 1);
            assert (toR + 1 == acc);
            int rightV = SummingHistogram.nextNonZero(histogram, leftV + 1);
            if (rightV == -1) {
                if (toRank > (double)acc) {
                    toRank = acc;
                }
                return (toIntegral += (toRank - (double)leftR) * ((double)leftV + 0.5 * (toRank - (double)leftR) / (double)b)) - fromIntegral;
            }
            double wideTrapDeltaV = b == 1 ? 0.0 : (double)(b - 1) / (double)b;
            double wideTrap = b == 1 ? 0.0 : (double)(b - 1) * ((double)leftV + 0.5 * wideTrapDeltaV);
            double leftValue = (double)leftV + wideTrapDeltaV;
            double toDelta = toRank - (double)toR;
            double partialNarrowTrap = toDelta * (leftValue + 0.5 * toDelta * ((double)rightV - leftValue));
            toIntegral += wideTrap + partialNarrowTrap;
        }
        return toIntegral - fromIntegral;
    }

    public static double integralBetweenValues(long[] histogram, double minValue, double maxValue, CountOfValues countOfValues) {
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(minValue)) {
            throw new IllegalArgumentException("Illegal minValue argument (NaN)");
        }
        if (Double.isNaN(maxValue)) {
            throw new IllegalArgumentException("Illegal maxValue argument (NaN)");
        }
        if (minValue < 0.0) {
            minValue = 0.0;
        }
        if (maxValue > (double)histogram.length) {
            maxValue = histogram.length;
        }
        if (minValue >= maxValue) {
            if (countOfValues != null) {
                countOfValues.count = 0.0;
                countOfValues.rightBound = false;
                countOfValues.leftBound = false;
            }
            return 0.0;
        }
        int minV = (int)minValue;
        int maxV = (int)maxValue;
        assert (minV <= maxV);
        assert (minValue < (double)histogram.length);
        assert (minV < histogram.length);
        assert (maxV <= histogram.length);
        long b = histogram[minV];
        if (b < 0L) {
            throw new IllegalArgumentException("Negative histogram[" + minV + "]=" + b);
        }
        if (minV == maxV) {
            double count;
            double d = count = b == 0L ? 0.0 : (maxValue - minValue) * (double)b;
            if (countOfValues != null) {
                countOfValues.count = count;
                countOfValues.leftBound = b == 0L && SummingHistogram.previousNonZero(histogram, minV - 1) == -1;
                countOfValues.rightBound = b == 0L && SummingHistogram.nextNonZero(histogram, maxV + 1) == -1;
            }
            return b == 0L ? 0.0 : 0.5 * (maxValue + minValue) * count;
        }
        double count = b == 0L ? 0.0 : ((double)(minV + 1) - minValue) * (double)b;
        double sum = b == 0L ? 0.0 : 0.5 * ((double)(minV + 1) + minValue) * count;
        for (int v = minV + 1; v < maxV; ++v) {
            b = histogram[v];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + v + "]=" + b);
            }
            if (b <= 0L) continue;
            count += (double)b;
            sum += ((double)v + 0.5) * (double)b;
        }
        if (maxValue > (double)maxV) {
            b = histogram[maxV];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + maxV + "]=" + b);
            }
            if (b > 0L) {
                count += (maxValue - (double)maxV) * (double)b;
                sum += 0.5 * (maxValue + (double)maxV) * (maxValue - (double)maxV) * (double)b;
            }
        }
        if (countOfValues != null) {
            countOfValues.count = count;
            countOfValues.leftBound = count <= 0.0 && SummingHistogram.previousNonZero(histogram, minV) == -1;
            countOfValues.rightBound = count <= 0.0 && SummingHistogram.nextNonZero(histogram, maxV) == -1;
        }
        return sum;
    }

    public static double integralBetweenValues(int[] histogram, double minValue, double maxValue, CountOfValues countOfValues) {
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(minValue)) {
            throw new IllegalArgumentException("Illegal minValue argument (NaN)");
        }
        if (Double.isNaN(maxValue)) {
            throw new IllegalArgumentException("Illegal maxValue argument (NaN)");
        }
        if (minValue < 0.0) {
            minValue = 0.0;
        }
        if (maxValue > (double)histogram.length) {
            maxValue = histogram.length;
        }
        if (minValue >= maxValue) {
            if (countOfValues != null) {
                countOfValues.count = 0.0;
                countOfValues.rightBound = false;
                countOfValues.leftBound = false;
            }
            return 0.0;
        }
        int minV = (int)minValue;
        int maxV = (int)maxValue;
        assert (minV <= maxV);
        assert (minValue < (double)histogram.length);
        assert (minV < histogram.length);
        assert (maxV <= histogram.length);
        int b = histogram[minV];
        if (b < 0) {
            throw new IllegalArgumentException("Negative histogram[" + minV + "]=" + b);
        }
        if (minV == maxV) {
            double count;
            double d = count = b == 0 ? 0.0 : (maxValue - minValue) * (double)b;
            if (countOfValues != null) {
                countOfValues.count = count;
                countOfValues.leftBound = b == 0 && SummingHistogram.previousNonZero(histogram, minV - 1) == -1;
                countOfValues.rightBound = b == 0 && SummingHistogram.nextNonZero(histogram, maxV + 1) == -1;
            }
            return b == 0 ? 0.0 : 0.5 * (maxValue + minValue) * count;
        }
        double count = b == 0 ? 0.0 : ((double)(minV + 1) - minValue) * (double)b;
        double sum = b == 0 ? 0.0 : 0.5 * ((double)(minV + 1) + minValue) * count;
        for (int v = minV + 1; v < maxV; ++v) {
            b = histogram[v];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + v + "]=" + b);
            }
            if (b <= 0) continue;
            count += (double)b;
            sum += ((double)v + 0.5) * (double)b;
        }
        if (maxValue > (double)maxV) {
            b = histogram[maxV];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + maxV + "]=" + b);
            }
            if (b > 0) {
                count += (maxValue - (double)maxV) * (double)b;
                sum += 0.5 * (maxValue + (double)maxV) * (maxValue - (double)maxV) * (double)b;
            }
        }
        if (countOfValues != null) {
            countOfValues.count = count;
            countOfValues.leftBound = count <= 0.0 && SummingHistogram.previousNonZero(histogram, minV) == -1;
            countOfValues.rightBound = count <= 0.0 && SummingHistogram.nextNonZero(histogram, maxV) == -1;
        }
        return sum;
    }

    public static double preciseIntegralBetweenValues(long[] histogram, double minValue, double maxValue, CountOfValues countOfValues) {
        int v;
        double maxIntegral;
        double maxCount;
        double minIntegral;
        double minCount;
        long b;
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(minValue)) {
            throw new IllegalArgumentException("Illegal minValue argument (NaN)");
        }
        if (Double.isNaN(maxValue)) {
            throw new IllegalArgumentException("Illegal maxValue argument (NaN)");
        }
        if (minValue < 0.0) {
            minValue = 0.0;
        }
        if (maxValue > (double)histogram.length) {
            maxValue = histogram.length;
        }
        if (minValue >= maxValue) {
            if (countOfValues != null) {
                countOfValues.count = 0.0;
                countOfValues.rightBound = false;
                countOfValues.leftBound = false;
            }
            return 0.0;
        }
        int minV = (int)minValue;
        int maxV = (int)maxValue;
        assert (minV <= maxV);
        assert (minValue < (double)histogram.length);
        assert (minV < histogram.length);
        assert (maxV <= histogram.length);
        boolean trapProcessed = false;
        int rightV = -157;
        double wideTrap = Double.NaN;
        double leftValue = Double.NaN;
        int minLeftV = minV;
        do {
            if ((b = histogram[minLeftV]) >= 0L) continue;
            throw new IllegalArgumentException("Negative histogram[" + minLeftV + "]=" + b);
        } while (b == 0L && --minLeftV >= 0);
        if (minLeftV == -1) {
            minCount = 0.0;
            minIntegral = 0.0;
        } else if (minV == minLeftV && b > 1L && (minValue - (double)minV) * (double)b <= (double)(b - 1L)) {
            minCount = (minValue - (double)minV) * (double)b;
            minIntegral = 0.5 * (minValue + (double)minV) * minCount;
        } else {
            assert (b > 0L);
            rightV = SummingHistogram.nextNonZero(histogram, minV + 1);
            if (rightV == -1) {
                if (minV > minLeftV) {
                    if (countOfValues != null) {
                        countOfValues.count = 0.0;
                        countOfValues.leftBound = false;
                        countOfValues.rightBound = true;
                    }
                    return 0.0;
                }
                assert (b == histogram[minV]);
                assert (b > 0L);
                if (minV == maxV) {
                    double count = (maxValue - minValue) * (double)b;
                    if (countOfValues != null) {
                        countOfValues.count = count;
                        countOfValues.leftBound = false;
                        countOfValues.rightBound = count <= 0.0;
                    }
                    return 0.5 * (maxValue + minValue) * count;
                }
                double count = ((double)(minV + 1) - minValue) * (double)b;
                if (countOfValues != null) {
                    countOfValues.count = count;
                    countOfValues.leftBound = false;
                    countOfValues.rightBound = count <= 0.0;
                }
                return 0.5 * ((double)(minV + 1) + minValue) * count;
            }
            trapProcessed = true;
            double wideTrapDeltaV = b == 1L ? 0.0 : (double)(b - 1L) / (double)b;
            wideTrap = b == 1L ? 0.0 : (double)(b - 1L) * ((double)minLeftV + 0.5 * wideTrapDeltaV);
            leftValue = (double)minLeftV + wideTrapDeltaV;
            assert (minValue >= leftValue - 0.001);
            double deltaRank = (minValue - leftValue) / ((double)rightV - leftValue);
            double partialNarrowTrap = 0.5 * (minValue + leftValue) * deltaRank;
            minCount = (double)(b - 1L) + deltaRank;
            minIntegral = wideTrap + partialNarrowTrap;
        }
        int maxLeftV = maxV;
        if (maxV < histogram.length) {
            do {
                if ((b = histogram[maxLeftV]) >= 0L) continue;
                throw new IllegalArgumentException("Negative histogram[" + maxLeftV + "]=" + b);
            } while (b == 0L && --maxLeftV >= 0);
        }
        if (maxV == histogram.length) {
            maxCount = 0.0;
            maxIntegral = 0.0;
        } else {
            if (maxLeftV == -1) {
                assert (minLeftV == -1);
                if (countOfValues != null) {
                    countOfValues.count = 0.0;
                    countOfValues.leftBound = true;
                    countOfValues.rightBound = false;
                }
                return 0.0;
            }
            if (maxV == maxLeftV && b > 1L && (maxValue - (double)maxV) * (double)b <= (double)(b - 1L)) {
                maxCount = (maxValue - (double)maxV) * (double)b;
                maxIntegral = 0.5 * (maxValue + (double)maxV) * maxCount;
            } else {
                assert (b > 0L);
                if (maxLeftV != minLeftV || !trapProcessed) {
                    rightV = SummingHistogram.nextNonZero(histogram, maxV + 1);
                }
                if (rightV == -1) {
                    if (maxV > maxLeftV) {
                        maxCount = b;
                        maxIntegral = ((double)maxLeftV + 0.5) * (double)b;
                    } else {
                        assert (b == histogram[maxV]);
                        assert (b > 0L);
                        maxCount = (maxValue - (double)maxV) * (double)b;
                        maxIntegral = 0.5 * (maxValue + (double)maxV) * maxCount;
                    }
                } else {
                    if (maxLeftV != minLeftV || !trapProcessed) {
                        double wideTrapDeltaV = b == 1L ? 0.0 : (double)(b - 1L) / (double)b;
                        wideTrap = b == 1L ? 0.0 : (double)(b - 1L) * ((double)maxLeftV + 0.5 * wideTrapDeltaV);
                        leftValue = (double)maxLeftV + wideTrapDeltaV;
                    }
                    assert (maxValue >= leftValue - 0.001);
                    double deltaRank = (maxValue - leftValue) / ((double)rightV - leftValue);
                    double partialNarrowTrap = 0.5 * (maxValue + leftValue) * deltaRank;
                    maxCount = (double)(b - 1L) + deltaRank;
                    maxIntegral = wideTrap + partialNarrowTrap;
                }
            }
        }
        if (minLeftV == maxLeftV) {
            if (countOfValues != null) {
                countOfValues.count = maxCount - minCount;
                countOfValues.leftBound = countOfValues.count <= 0.0 && SummingHistogram.previousNonZero(histogram, minV) == -1;
                countOfValues.rightBound = countOfValues.count <= 0.0 && SummingHistogram.nextNonZero(histogram, maxV) == -1;
            }
            return maxIntegral - minIntegral;
        }
        assert (minLeftV < maxLeftV);
        double middleCount = 0.0;
        double middleIntegral = 0.0;
        int lastNonZero = Integer.MAX_VALUE;
        if (minLeftV == -1) {
            assert (histogram[minV] == 0L);
            v = minV + 1;
        } else {
            assert (histogram[minLeftV] > 0L);
            v = minLeftV;
        }
        while (v < maxLeftV) {
            b = histogram[v];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + v + "]=" + b);
            }
            if (b > 0L) {
                if (v - lastNonZero > 1) {
                    middleIntegral += 0.5 * (double)(v - lastNonZero - 1);
                }
                lastNonZero = v;
                middleCount += (double)b;
                middleIntegral += ((double)v + 0.5) * (double)b;
            }
            ++v;
        }
        if (maxLeftV < histogram.length && maxLeftV - lastNonZero > 1) {
            middleIntegral += 0.5 * (double)(maxLeftV - lastNonZero - 1);
        }
        if (countOfValues != null) {
            countOfValues.count = maxCount - minCount + middleCount;
            countOfValues.leftBound = countOfValues.count <= 0.0 && SummingHistogram.previousNonZero(histogram, minV) == -1;
            countOfValues.rightBound = countOfValues.count <= 0.0 && SummingHistogram.nextNonZero(histogram, maxV) == -1;
        }
        return maxIntegral - minIntegral + middleIntegral;
    }

    public static double preciseIntegralBetweenValues(int[] histogram, double minValue, double maxValue, CountOfValues countOfValues) {
        int v;
        double maxIntegral;
        double maxCount;
        double minIntegral;
        double minCount;
        int b;
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (Double.isNaN(minValue)) {
            throw new IllegalArgumentException("Illegal minValue argument (NaN)");
        }
        if (Double.isNaN(maxValue)) {
            throw new IllegalArgumentException("Illegal maxValue argument (NaN)");
        }
        if (minValue < 0.0) {
            minValue = 0.0;
        }
        if (maxValue > (double)histogram.length) {
            maxValue = histogram.length;
        }
        if (minValue >= maxValue) {
            if (countOfValues != null) {
                countOfValues.count = 0.0;
                countOfValues.rightBound = false;
                countOfValues.leftBound = false;
            }
            return 0.0;
        }
        int minV = (int)minValue;
        int maxV = (int)maxValue;
        assert (minV <= maxV);
        assert (minValue < (double)histogram.length);
        assert (minV < histogram.length);
        assert (maxV <= histogram.length);
        boolean trapProcessed = false;
        int rightV = -157;
        double wideTrap = Double.NaN;
        double leftValue = Double.NaN;
        int minLeftV = minV;
        do {
            if ((b = histogram[minLeftV]) >= 0) continue;
            throw new IllegalArgumentException("Negative histogram[" + minLeftV + "]=" + b);
        } while (b == 0 && --minLeftV >= 0);
        if (minLeftV == -1) {
            minCount = 0.0;
            minIntegral = 0.0;
        } else if (minV == minLeftV && b > 1 && (minValue - (double)minV) * (double)b <= (double)(b - 1)) {
            minCount = (minValue - (double)minV) * (double)b;
            minIntegral = 0.5 * (minValue + (double)minV) * minCount;
        } else {
            assert (b > 0);
            rightV = SummingHistogram.nextNonZero(histogram, minV + 1);
            if (rightV == -1) {
                if (minV > minLeftV) {
                    if (countOfValues != null) {
                        countOfValues.count = 0.0;
                        countOfValues.leftBound = false;
                        countOfValues.rightBound = true;
                    }
                    return 0.0;
                }
                assert (b == histogram[minV]);
                assert (b > 0);
                if (minV == maxV) {
                    double count = (maxValue - minValue) * (double)b;
                    if (countOfValues != null) {
                        countOfValues.count = count;
                        countOfValues.leftBound = false;
                        countOfValues.rightBound = count <= 0.0;
                    }
                    return 0.5 * (maxValue + minValue) * count;
                }
                double count = ((double)(minV + 1) - minValue) * (double)b;
                if (countOfValues != null) {
                    countOfValues.count = count;
                    countOfValues.leftBound = false;
                    countOfValues.rightBound = count <= 0.0;
                }
                return 0.5 * ((double)(minV + 1) + minValue) * count;
            }
            trapProcessed = true;
            double wideTrapDeltaV = b == 1 ? 0.0 : (double)(b - 1) / (double)b;
            wideTrap = b == 1 ? 0.0 : (double)(b - 1) * ((double)minLeftV + 0.5 * wideTrapDeltaV);
            leftValue = (double)minLeftV + wideTrapDeltaV;
            assert (minValue >= leftValue - 0.001);
            double deltaRank = (minValue - leftValue) / ((double)rightV - leftValue);
            double partialNarrowTrap = 0.5 * (minValue + leftValue) * deltaRank;
            minCount = (double)(b - 1) + deltaRank;
            minIntegral = wideTrap + partialNarrowTrap;
        }
        int maxLeftV = maxV;
        if (maxV < histogram.length) {
            do {
                if ((b = histogram[maxLeftV]) >= 0) continue;
                throw new IllegalArgumentException("Negative histogram[" + maxLeftV + "]=" + b);
            } while (b == 0 && --maxLeftV >= 0);
        }
        if (maxV == histogram.length) {
            maxCount = 0.0;
            maxIntegral = 0.0;
        } else {
            if (maxLeftV == -1) {
                assert (minLeftV == -1);
                if (countOfValues != null) {
                    countOfValues.count = 0.0;
                    countOfValues.leftBound = true;
                    countOfValues.rightBound = false;
                }
                return 0.0;
            }
            if (maxV == maxLeftV && b > 1 && (maxValue - (double)maxV) * (double)b <= (double)(b - 1)) {
                maxCount = (maxValue - (double)maxV) * (double)b;
                maxIntegral = 0.5 * (maxValue + (double)maxV) * maxCount;
            } else {
                assert (b > 0);
                if (maxLeftV != minLeftV || !trapProcessed) {
                    rightV = SummingHistogram.nextNonZero(histogram, maxV + 1);
                }
                if (rightV == -1) {
                    if (maxV > maxLeftV) {
                        maxCount = b;
                        maxIntegral = ((double)maxLeftV + 0.5) * (double)b;
                    } else {
                        assert (b == histogram[maxV]);
                        assert (b > 0);
                        maxCount = (maxValue - (double)maxV) * (double)b;
                        maxIntegral = 0.5 * (maxValue + (double)maxV) * maxCount;
                    }
                } else {
                    if (maxLeftV != minLeftV || !trapProcessed) {
                        double wideTrapDeltaV = b == 1 ? 0.0 : (double)(b - 1) / (double)b;
                        wideTrap = b == 1 ? 0.0 : (double)(b - 1) * ((double)maxLeftV + 0.5 * wideTrapDeltaV);
                        leftValue = (double)maxLeftV + wideTrapDeltaV;
                    }
                    assert (maxValue >= leftValue - 0.001);
                    double deltaRank = (maxValue - leftValue) / ((double)rightV - leftValue);
                    double partialNarrowTrap = 0.5 * (maxValue + leftValue) * deltaRank;
                    maxCount = (double)(b - 1) + deltaRank;
                    maxIntegral = wideTrap + partialNarrowTrap;
                }
            }
        }
        if (minLeftV == maxLeftV) {
            if (countOfValues != null) {
                countOfValues.count = maxCount - minCount;
                countOfValues.leftBound = countOfValues.count <= 0.0 && SummingHistogram.previousNonZero(histogram, minV) == -1;
                countOfValues.rightBound = countOfValues.count <= 0.0 && SummingHistogram.nextNonZero(histogram, maxV) == -1;
            }
            return maxIntegral - minIntegral;
        }
        assert (minLeftV < maxLeftV);
        double middleCount = 0.0;
        double middleIntegral = 0.0;
        int lastNonZero = Integer.MAX_VALUE;
        if (minLeftV == -1) {
            assert (histogram[minV] == 0);
            v = minV + 1;
        } else {
            assert (histogram[minLeftV] > 0);
            v = minLeftV;
        }
        while (v < maxLeftV) {
            b = histogram[v];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + v + "]=" + b);
            }
            if (b > 0) {
                if (v - lastNonZero > 1) {
                    middleIntegral += 0.5 * (double)(v - lastNonZero - 1);
                }
                lastNonZero = v;
                middleCount += (double)b;
                middleIntegral += ((double)v + 0.5) * (double)b;
            }
            ++v;
        }
        if (maxLeftV < histogram.length && maxLeftV - lastNonZero > 1) {
            middleIntegral += 0.5 * (double)(maxLeftV - lastNonZero - 1);
        }
        if (countOfValues != null) {
            countOfValues.count = maxCount - minCount + middleCount;
            countOfValues.leftBound = countOfValues.count <= 0.0 && SummingHistogram.previousNonZero(histogram, minV) == -1;
            countOfValues.rightBound = countOfValues.count <= 0.0 && SummingHistogram.nextNonZero(histogram, maxV) == -1;
        }
        return maxIntegral - minIntegral + middleIntegral;
    }

    static class SimplifiedSummingLong1LevelHistogram
    extends SummingHistogram {
        private final long[][] histogram;
        private final long[] histogram0;
        private final double[][] sums;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private long total;
        private long[] currentIRanks;
        private double[] currentSums;
        private long[] alternativeIRanks;
        private double[] alternativeSums;
        private SimplifiedSummingLong1LevelHistogram nextSharing = this;
        private long shareCount = 1L;

        private SimplifiedSummingLong1LevelHistogram(long[][] histogram, double[][] sums, long total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new long[this.m];
            this.currentSums = new double[this.m];
            this.alternativeIRanks = new long[this.m];
            this.alternativeSums = new double[this.m];
        }

        SimplifiedSummingLong1LevelHistogram(long[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SimplifiedSummingLong1LevelHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new double[bitLevels.length + 1][], histogramIsZeroFilled ? 0L : SimplifiedSummingLong1LevelHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new long[levelCount];
                this.sums[k] = new double[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    long count = 0L;
                    double sum = 0.0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (double)value * (double)histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SimplifiedSummingLong1LevelHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Long.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Long.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1L;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                this.currentSums[0] = this.currentSums[0] + (double)value;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingLong1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                    hist.currentSums[0] = hist.currentSums[0] + (double)value;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1L;
            if (this.histogram0[n] < 0L) {
                long b = this.histogram0[value];
                this.histogram0[value] = 0L;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                this.currentSums[0] = this.currentSums[0] - (double)value;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingLong1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                    hist.currentSums[0] = hist.currentSums[0] - (double)value;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Long.MAX_VALUE - (long)values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Long.MAX_VALUE");
            }
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1L;
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (double)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (double)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] + 1L;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                        this.currentSums[0] = this.currentSums[0] + (double)value;
                    }
                    SimplifiedSummingLong1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                            hist.currentSums[0] = hist.currentSums[0] + (double)value;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1L;
                    if (this.histogram0[n2] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (double)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (double)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] - 1L;
                    if (this.histogram0[n3] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                        this.currentSums[0] = this.currentSums[0] - (double)value;
                    }
                    SimplifiedSummingLong1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                            hist.currentSums[0] = hist.currentSums[0] - (double)value;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.simpleCurrentNDV();
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        @Override
        public SummingHistogram moveToIRank(long rank) {
            if (this.total == 0L) {
                assert (this.currentIRanks[0] == 0L) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            assert (this.total > 0L);
            if (rank < 0L) {
                rank = 0L;
            } else if (rank > this.total) {
                rank = this.total;
            }
            if (rank == this.total) {
                this.moveToRightmostRank();
            } else if (rank < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                } while (rank < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (rank >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                double frac = (double)(rank - this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        @Override
        public Histogram moveToRank(double rank) {
            long b;
            long r;
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            if (this.total == 0L) {
                assert (this.currentIRanks[0] == 0L) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            this.currentPreciseRank = Double.NaN;
            assert (this.total > 0L);
            if (rank < 0.0) {
                r = 0L;
                rank = 0L;
            } else if (rank > (double)this.total) {
                r = this.total;
                rank = r;
            } else {
                r = (int)rank;
            }
            if (r == this.total) {
                this.moveToRightmostRank();
            } else if (r < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                } while (r < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (r >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                double frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)j;
                }
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                for (int j = this.currentIValue; j < value; ++j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)j;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1L) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            long[] lArray = this.histogram0;
            synchronized (this.histogram0) {
                SimplifiedSummingLong1LevelHistogram result = new SimplifiedSummingLong1LevelHistogram(this.histogram, this.sums, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SimplifiedSummingLong1LevelHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert ((long)count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SimplifiedSummingLong1LevelHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing long histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1L ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void restoreRanks() {
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0L || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                long s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = SimplifiedSummingLong1LevelHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                double sum = 0.0;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (double)this.histogram0[j] * (double)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SimplifiedSummingLong1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SimplifiedSummingLong1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SimplifiedSummingLong1LevelHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SimplifiedSummingLong1LevelHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            assert (this.total > 0L);
            assert (this.currentIRanks[0] <= this.total);
            if (this.currentIRanks[0] < this.total) {
                assert (this.currentIRanks[0] < this.total);
                do {
                    long b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                    ++this.currentIValue;
                } while (this.currentIRanks[0] < this.total);
                assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                assert (this.histogram0[this.currentIValue - 1] > 0L);
            } else if (this.histogram0[this.currentIValue - 1] == 0L) {
                assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0L);
                --this.currentIValue;
                assert (this.currentIValue > 0);
                assert (this.histogram0[this.currentIValue] == 0L);
                while (this.histogram0[this.currentIValue - 1] == 0L) {
                    --this.currentIValue;
                    assert (this.currentIValue > 0);
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0L) continue;
                ++result;
            }
            return result;
        }

        private static long[][] newMultilevelHistogram(long[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            long[][] result = new long[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static long sumOfAndCheck(long[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            long result = 0L;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0L) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Long.MAX_VALUE");
            }
            return result;
        }
    }

    static class SimplifiedSummingLongHistogram
    extends SummingHistogram {
        private final long[][] histogram;
        private final long[] histogram0;
        private final double[][] sums;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private long total;
        private long[] currentIRanks;
        private double[] currentSums;
        private long[] alternativeIRanks;
        private double[] alternativeSums;
        private SimplifiedSummingLongHistogram nextSharing = this;
        private long shareCount = 1L;

        private SimplifiedSummingLongHistogram(long[][] histogram, double[][] sums, long total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new long[this.m];
            this.currentSums = new double[this.m];
            this.alternativeIRanks = new long[this.m];
            this.alternativeSums = new double[this.m];
        }

        SimplifiedSummingLongHistogram(long[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SimplifiedSummingLongHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new double[bitLevels.length + 1][], histogramIsZeroFilled ? 0L : SimplifiedSummingLongHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new long[levelCount];
                this.sums[k] = new double[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    long count = 0L;
                    double sum = 0.0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (double)value * (double)histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SimplifiedSummingLongHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Long.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Long.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1L;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                long[] lArray = this.histogram[k];
                int n2 = v;
                lArray[n2] = lArray[n2] + 1L;
                double[] dArray = this.sums[k];
                int n3 = v;
                dArray[n3] = dArray[n3] + (double)value;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n4 = k;
                this.currentIRanks[n4] = this.currentIRanks[n4] + 1L;
                int n5 = k;
                this.currentSums[n5] = this.currentSums[n5] + (double)value;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                this.currentSums[0] = this.currentSums[0] + (double)value;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingLongHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n6 = k;
                    hist.currentIRanks[n6] = hist.currentIRanks[n6] + 1L;
                    int n7 = k;
                    hist.currentSums[n7] = hist.currentSums[n7] + (double)value;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                    hist.currentSums[0] = hist.currentSums[0] + (double)value;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1L;
            if (this.histogram0[n] < 0L) {
                long b = this.histogram0[value];
                this.histogram0[value] = 0L;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                long[] lArray = this.histogram[k];
                int n2 = v;
                lArray[n2] = lArray[n2] - 1L;
                double[] dArray = this.sums[k];
                int n3 = v;
                dArray[n3] = dArray[n3] - (double)value;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n4 = k;
                this.currentIRanks[n4] = this.currentIRanks[n4] - 1L;
                int n5 = k;
                this.currentSums[n5] = this.currentSums[n5] - (double)value;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                this.currentSums[0] = this.currentSums[0] - (double)value;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingLongHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n6 = k;
                    hist.currentIRanks[n6] = hist.currentIRanks[n6] - 1L;
                    int n7 = k;
                    hist.currentSums[n7] = hist.currentSums[n7] - (double)value;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                    hist.currentSums[0] = hist.currentSums[0] - (double)value;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Long.MAX_VALUE - (long)values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Long.MAX_VALUE");
            }
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n3 = v;
                        lArray[n3] = lArray[n3] + 1L;
                        double[] dArray = this.sums[k];
                        int n4 = v;
                        dArray[n4] = dArray[n4] + (double)value;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n5 = k;
                            this.currentIRanks[n5] = this.currentIRanks[n5] + 1L;
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] + (double)value;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n7 = k;
                        this.nextSharing.currentIRanks[n7] = this.nextSharing.currentIRanks[n7] + 1L;
                        int n8 = k;
                        this.nextSharing.currentSums[n8] = this.nextSharing.currentSums[n8] + (double)value;
                    }
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (double)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (double)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n9 = value = nArray[i];
                    this.histogram0[n9] = this.histogram0[n9] + 1L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n10 = v;
                        lArray[n10] = lArray[n10] + 1L;
                        double[] dArray = this.sums[k];
                        int n11 = v;
                        dArray[n11] = dArray[n11] + (double)value;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n12 = k;
                        this.currentIRanks[n12] = this.currentIRanks[n12] + 1L;
                        int n13 = k;
                        this.currentSums[n13] = this.currentSums[n13] + (double)value;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                        this.currentSums[0] = this.currentSums[0] + (double)value;
                    }
                    SimplifiedSummingLongHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n14 = k;
                            hist.currentIRanks[n14] = hist.currentIRanks[n14] + 1L;
                            int n15 = k;
                            hist.currentSums[n15] = hist.currentSums[n15] + (double)value;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                            hist.currentSums[0] = hist.currentSums[0] + (double)value;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1L;
                    if (this.histogram0[n2] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n3 = v;
                        lArray[n3] = lArray[n3] - 1L;
                        double[] dArray = this.sums[k];
                        int n4 = v;
                        dArray[n4] = dArray[n4] - (double)value;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n5 = k;
                            this.currentIRanks[n5] = this.currentIRanks[n5] - 1L;
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] - (double)value;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n7 = k;
                        this.nextSharing.currentIRanks[n7] = this.nextSharing.currentIRanks[n7] - 1L;
                        int n8 = k;
                        this.nextSharing.currentSums[n8] = this.nextSharing.currentSums[n8] - (double)value;
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (double)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (double)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n9 = value = nArray[i];
                    this.histogram0[n9] = this.histogram0[n9] - 1L;
                    if (this.histogram0[n9] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n10 = v;
                        lArray[n10] = lArray[n10] - 1L;
                        double[] dArray = this.sums[k];
                        int n11 = v;
                        dArray[n11] = dArray[n11] - (double)value;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n12 = k;
                        this.currentIRanks[n12] = this.currentIRanks[n12] - 1L;
                        int n13 = k;
                        this.currentSums[n13] = this.currentSums[n13] - (double)value;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                        this.currentSums[0] = this.currentSums[0] - (double)value;
                    }
                    SimplifiedSummingLongHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n14 = k;
                            hist.currentIRanks[n14] = hist.currentIRanks[n14] - 1L;
                            int n15 = k;
                            hist.currentSums[n15] = hist.currentSums[n15] - (double)value;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                            hist.currentSums[0] = hist.currentSums[0] - (double)value;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.simpleCurrentNDV();
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public SummingHistogram moveToIRank(long rank) {
            block33: {
                block34: {
                    block35: {
                        block32: {
                            if (this.total == 0L) {
                                if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] != 0L) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.total <= 0L) {
                                throw new AssertionError();
                            }
                            if (rank < 0L) {
                                rank = 0L;
                            } else if (rank > this.total) {
                                rank = this.total;
                            }
                            if (rank != this.total) break block32;
                            this.moveToRightmostRank();
                            break block33;
                        }
                        if (rank >= this.currentIRanks[0]) break block34;
                        if (this.m <= 1) break block35;
                        k = 0;
                        while (k + 1 < this.m && rank < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && rank >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                            } while (rank < this.currentIRanks[k]);
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] < 0L) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (double)b * (double)this.currentIValue);
                            } while (k > 0 && rank >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (rank >= this.currentIRanks[0]) break block33;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                    } while (rank < this.currentIRanks[0]);
                    if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] < 0L) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block33;
                }
                if (this.m > 1) {
                    if (rank >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && rank >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (rank >= this.currentIRanks[k] + b) {
                                v2 = k;
                                this.currentIRanks[v2] = this.currentIRanks[v2] + b;
                                v3 = k;
                                this.currentSums[v3] = this.currentSums[v3] + this.sums[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                            } while (k > 0 && rank < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (rank >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                frac = (double)(rank - this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToRank(double rank) {
            block35: {
                block36: {
                    block37: {
                        block34: {
                            if (Double.isNaN(rank)) {
                                throw new IllegalArgumentException("Illegal rank argument (NaN)");
                            }
                            if (this.total == 0L) {
                                if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] != 0L) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            this.currentPreciseRank = NaN;
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.total <= 0L) {
                                throw new AssertionError();
                            }
                            if (rank < 0.0) {
                                r = 0L;
                                rank = 0L;
                            } else if (rank > (double)this.total) {
                                r = this.total;
                                rank = r;
                            } else {
                                r = (int)rank;
                            }
                            if (r != this.total) break block34;
                            this.moveToRightmostRank();
                            break block35;
                        }
                        if (r >= this.currentIRanks[0]) break block36;
                        if (this.m <= 1) break block37;
                        k = 0;
                        while (k + 1 < this.m && r < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && r >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                            } while (r < this.currentIRanks[k]);
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] < 0L) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (double)b * (double)this.currentIValue);
                            } while (k > 0 && r >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (r >= this.currentIRanks[0]) break block35;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                    } while (r < this.currentIRanks[0]);
                    if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] < 0L) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block35;
                }
                if (this.m > 1) {
                    if (r >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && r >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (r >= this.currentIRanks[k] + b) {
                                v2 = k;
                                this.currentIRanks[v2] = this.currentIRanks[v2] + b;
                                v3 = k;
                                this.currentSums[v3] = this.currentSums[v3] + this.sums[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                            } while (k > 0 && r < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!SimplifiedSummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (r >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SimplifiedSummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] < this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        double sum;
                        long b;
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v < this.currentIValue);
                        do {
                            --this.currentIValue;
                            b = this.histogram[k][this.currentIValue];
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - b;
                            sum = this.sums[k][this.currentIValue];
                            int n2 = k;
                            this.currentSums[n2] = this.currentSums[n2] - sum;
                        } while (v < this.currentIValue);
                        assert (this.currentIRanks[k] >= 0L) : "currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for value=" + value;
                        assert (this.currentIValue == v);
                        int previousValue = this.currentIValue + 1 << level;
                        assert (value < previousValue);
                        long previousRank = this.currentIRanks[k] + b;
                        double previousSum = this.currentSums[k] + sum;
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIValue = (previousValue >> level) - 1;
                            b = this.histogram[k][this.currentIValue];
                            this.currentIRanks[k] = previousRank - b;
                            this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (double)b * (double)this.currentIValue);
                        } while (k > 0 && value >> level == this.currentIValue);
                        this.currentIValue <<= level;
                    }
                    assert (k == 0);
                    if (value == this.currentIValue) {
                        return this;
                    }
                    assert (value < this.currentIValue);
                }
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)j;
                }
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] > this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v > this.currentIValue);
                        do {
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][this.currentIValue];
                            int n3 = k;
                            this.currentSums[n3] = this.currentSums[n3] + this.sums[k][this.currentIValue];
                            ++this.currentIValue;
                        } while (v > this.currentIValue);
                        assert (this.currentIRanks[k] <= this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + "> total=" + this.total + " for value=" + value;
                        assert (this.currentIValue == v);
                        this.currentIValue <<= level;
                        assert (this.currentIValue <= value);
                        long lastRank = this.currentIRanks[k];
                        double lastSum = this.currentSums[k];
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIRanks[k] = lastRank;
                            this.currentSums[k] = lastSum;
                        } while (k > 0 && value >> level == this.currentIValue >> level);
                    }
                    assert (k == 0);
                }
                for (int j = this.currentIValue; j < value; ++j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)j;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1L) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            long[] lArray = this.histogram0;
            synchronized (this.histogram0) {
                SimplifiedSummingLongHistogram result = new SimplifiedSummingLongHistogram(this.histogram, this.sums, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SimplifiedSummingLongHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert ((long)count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SimplifiedSummingLongHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing long histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1L ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void restoreRanks() {
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0L || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                long s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = SimplifiedSummingLongHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                double sum = 0.0;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (double)this.histogram0[j] * (double)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SimplifiedSummingLongHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SimplifiedSummingLongHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SimplifiedSummingLongHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SimplifiedSummingLongHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            block34: {
                block33: {
                    int v;
                    assert (this.total > 0L);
                    assert (this.currentIRanks[0] <= this.total);
                    if (this.currentIRanks[0] >= this.total) break block33;
                    if (this.m > 1) {
                        int k = 0;
                        while (k + 1 < this.m && this.total > this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            long b = this.histogram[k][this.currentIValue];
                            while (this.total > this.currentIRanks[k] + b) {
                                int n = k;
                                this.currentIRanks[n] = this.currentIRanks[n] + b;
                                int n2 = k;
                                this.currentSums[n2] = this.currentSums[n2] + this.sums[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            assert (this.currentIRanks[k] < this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total;
                            this.currentIValue <<= level;
                            long lastRank = this.currentIRanks[k];
                            double lastSum = this.currentSums[k];
                            do {
                                level = this.bitLevels[--k];
                                assert (k > 0 || level == 0);
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                            } while (k > 0 && this.total <= this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        assert (k == 0);
                    }
                    assert (this.currentIRanks[0] < this.total);
                    do {
                        long b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                        ++this.currentIValue;
                    } while (this.currentIRanks[0] < this.total);
                    assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                    assert (this.histogram0[this.currentIValue - 1] > 0L);
                    if (this.m <= 1) break block34;
                    for (int k = 1; k < this.m && (v = this.currentIValue - 1 >> this.bitLevels[k]) < this.currentIValue >> this.bitLevels[k]; ++k) {
                        int n = k;
                        this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][v];
                        int n3 = k;
                        this.currentSums[n3] = this.currentSums[n3] + this.sums[k][v];
                    }
                    break block34;
                }
                if (this.histogram0[this.currentIValue - 1] == 0L) {
                    int k;
                    assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0L);
                    --this.currentIValue;
                    int previousValue = this.currentIValue + 1;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]] == 0L) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0L);
                            while (this.histogram[k][this.currentIValue - 1] == 0L) {
                                --this.currentIValue;
                                assert (this.currentIValue > 0);
                            }
                            int v = this.currentIValue - 1;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0L);
                            assert (this.histogram[k][v] > 0L);
                            this.currentIValue <<= level;
                            --k;
                        }
                    }
                    assert (this.currentIValue > 0);
                    assert (this.histogram0[this.currentIValue] == 0L);
                    while (this.histogram0[this.currentIValue - 1] == 0L) {
                        --this.currentIValue;
                        assert (this.currentIValue > 0);
                    }
                    if (this.m > 1) {
                        int v;
                        for (k = 1; k < this.m && (v = this.currentIValue >> this.bitLevels[k]) < previousValue >> this.bitLevels[k]; ++k) {
                            long b = this.histogram[k][v];
                            if (b <= 0L) continue;
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - this.histogram[k][v];
                            int n4 = k;
                            this.currentSums[n4] = this.currentSums[n4] - this.sums[k][v];
                        }
                    }
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0L) continue;
                ++result;
            }
            return result;
        }

        private static long[][] newMultilevelHistogram(long[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            long[][] result = new long[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static long sumOfAndCheck(long[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            long result = 0L;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0L) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Long.MAX_VALUE");
            }
            return result;
        }
    }

    static class SummingLong1LevelHistogram
    extends SummingHistogram {
        private final long[][] histogram;
        private final long[] histogram0;
        private final double[][] sums;
        private final int[][] numbersOfDifferentValues;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private long total;
        private long[] currentIRanks;
        private double[] currentSums;
        private int[] currentNumberOfDifferentValues;
        private long[] alternativeIRanks;
        private double[] alternativeSums;
        private int[] alternativeNumberOfDifferentValues;
        private SummingLong1LevelHistogram nextSharing = this;
        private long shareCount = 1L;

        private SummingLong1LevelHistogram(long[][] histogram, double[][] sums, int[][] numbersOfDifferentValues, long total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.numbersOfDifferentValues = numbersOfDifferentValues;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new long[this.m];
            this.currentSums = new double[this.m];
            this.currentNumberOfDifferentValues = new int[this.m];
            this.alternativeIRanks = new long[this.m];
            this.alternativeSums = new double[this.m];
            this.alternativeNumberOfDifferentValues = new int[this.m];
        }

        SummingLong1LevelHistogram(long[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SummingLong1LevelHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new double[bitLevels.length + 1][], new int[bitLevels.length + 1][], histogramIsZeroFilled ? 0L : SummingLong1LevelHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new long[levelCount];
                this.sums[k] = new double[levelCount];
                this.numbersOfDifferentValues[k] = new int[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    long count = 0L;
                    double sum = 0.0;
                    int numberOfDifferentValues = 0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (double)value * (double)histogram[value];
                        if (histogram[value] != 0L) {
                            ++numberOfDifferentValues;
                        }
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                    this.numbersOfDifferentValues[k][i] = numberOfDifferentValues;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SummingLong1LevelHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Long.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Long.MAX_VALUE");
            }
            boolean wasEmpty = this.histogram0[value] == 0L;
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1L;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                this.currentSums[0] = this.currentSums[0] + (double)value;
                if (wasEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SummingLong1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                    hist.currentSums[0] = hist.currentSums[0] + (double)value;
                    if (wasEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                    }
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            boolean becomeEmpty;
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1L;
            if (this.histogram0[n] < 0L) {
                long b = this.histogram0[value];
                this.histogram0[value] = 0L;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            boolean bl = becomeEmpty = this.histogram0[value] == 0L;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                this.currentSums[0] = this.currentSums[0] - (double)value;
                if (becomeEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SummingLong1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                    hist.currentSums[0] = hist.currentSums[0] - (double)value;
                    if (becomeEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                    }
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Long.MAX_VALUE - (long)values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Long.MAX_VALUE");
            }
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0L;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1L;
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (double)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (double)value;
                    if (!wasEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] + 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0L;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1L;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                        this.currentSums[0] = this.currentSums[0] + (double)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    SummingLong1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                            hist.currentSums[0] = hist.currentSums[0] + (double)value;
                            if (wasEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                            }
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean becomeEmpty;
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1L;
                    if (this.histogram0[n2] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean bl = becomeEmpty = this.histogram0[value] == 0L;
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (double)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (double)value;
                    if (!becomeEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] - 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean becomeEmpty;
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] - 1L;
                    if (this.histogram0[n3] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean bl = becomeEmpty = this.histogram0[value] == 0L;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                        this.currentSums[0] = this.currentSums[0] - (double)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    SummingLong1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                            hist.currentSums[0] = hist.currentSums[0] - (double)value;
                            if (becomeEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                            }
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.currentNumberOfDifferentValues[0];
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        @Override
        public SummingHistogram moveToIRank(long rank) {
            if (this.total == 0L) {
                assert (this.currentIRanks[0] == 0L) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            assert (this.total > 0L);
            if (rank < 0L) {
                rank = 0L;
            } else if (rank > this.total) {
                rank = this.total;
            }
            if (rank == this.total) {
                this.moveToRightmostRank();
            } else if (rank < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                    if (b == 0L) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                } while (rank < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (rank >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                    if (b != 0L) {
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                    }
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                double frac = (double)(rank - this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        @Override
        public Histogram moveToRank(double rank) {
            long b;
            long r;
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            if (this.total == 0L) {
                assert (this.currentIRanks[0] == 0L) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            this.currentPreciseRank = Double.NaN;
            assert (this.total > 0L);
            if (rank < 0.0) {
                r = 0L;
                rank = 0L;
            } else if (rank > (double)this.total) {
                r = this.total;
                rank = r;
            } else {
                r = (int)rank;
            }
            if (r == this.total) {
                this.moveToRightmostRank();
            } else if (r < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                    if (b == 0L) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                } while (r < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (r >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                    if (b != 0L) {
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                    }
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                double frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)j;
                    if (b == 0L) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                for (int j = this.currentIValue; j < value; ++j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)j;
                    if (b == 0L) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1L) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            long[] lArray = this.histogram0;
            synchronized (this.histogram0) {
                SummingLong1LevelHistogram result = new SummingLong1LevelHistogram(this.histogram, this.sums, this.numbersOfDifferentValues, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SummingLong1LevelHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert ((long)count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SummingLong1LevelHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing long histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1L ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            System.arraycopy(this.currentNumberOfDifferentValues, 0, this.alternativeNumberOfDifferentValues, 0, this.m);
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void restoreRanks() {
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0L || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            if (this.currentNumberOfDifferentValues[0] < 0 || (long)this.currentNumberOfDifferentValues[0] > Math.min((long)this.length, this.total)) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentNumberOfDifferentValues = " + this.currentNumberOfDifferentValues[0] + " is out of range 0..min(" + this.length + "," + this.total + ")"));
            }
            for (int k = 0; k < this.m; ++k) {
                int nDifferentValues = 0;
                if (k == 0) {
                    nDifferentValues = this.simpleCurrentNDV();
                } else {
                    for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                        nDifferentValues += this.histogram0[j] == 0L ? 0 : 1;
                    }
                }
                if (this.currentNumberOfDifferentValues[k] != nDifferentValues) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentNumberOfDifferentValues[" + k + "] = " + this.currentNumberOfDifferentValues[k] + " != " + nDifferentValues + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                long s = SummingLong1LevelHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]);
                if (this.currentIRanks[k] != s) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                double sum = 0.0;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (double)this.histogram0[j] * (double)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SummingLong1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SummingLong1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SummingLong1LevelHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SummingLong1LevelHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            assert (this.total > 0L);
            assert (this.currentIRanks[0] <= this.total);
            if (this.currentIRanks[0] < this.total) {
                assert (this.currentIRanks[0] < this.total);
                do {
                    long b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                    if (b != 0L) {
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                    }
                    ++this.currentIValue;
                } while (this.currentIRanks[0] < this.total);
                assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                assert (this.histogram0[this.currentIValue - 1] > 0L);
            } else if (this.histogram0[this.currentIValue - 1] == 0L) {
                assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0L);
                --this.currentIValue;
                assert (this.currentIValue > 0);
                assert (this.histogram0[this.currentIValue] == 0L);
                while (this.histogram0[this.currentIValue - 1] == 0L) {
                    --this.currentIValue;
                    assert (this.currentIValue > 0);
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0L) continue;
                ++result;
            }
            return result;
        }

        private static long[][] newMultilevelHistogram(long[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            long[][] result = new long[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static long sumOfAndCheck(long[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            long result = 0L;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0L) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Long.MAX_VALUE");
            }
            return result;
        }
    }

    static class SummingLongHistogram
    extends SummingHistogram {
        private final long[][] histogram;
        private final long[] histogram0;
        private final double[][] sums;
        private final int[][] numbersOfDifferentValues;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private long total;
        private long[] currentIRanks;
        private double[] currentSums;
        private int[] currentNumberOfDifferentValues;
        private long[] alternativeIRanks;
        private double[] alternativeSums;
        private int[] alternativeNumberOfDifferentValues;
        private SummingLongHistogram nextSharing = this;
        private long shareCount = 1L;

        private SummingLongHistogram(long[][] histogram, double[][] sums, int[][] numbersOfDifferentValues, long total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.numbersOfDifferentValues = numbersOfDifferentValues;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new long[this.m];
            this.currentSums = new double[this.m];
            this.currentNumberOfDifferentValues = new int[this.m];
            this.alternativeIRanks = new long[this.m];
            this.alternativeSums = new double[this.m];
            this.alternativeNumberOfDifferentValues = new int[this.m];
        }

        SummingLongHistogram(long[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SummingLongHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new double[bitLevels.length + 1][], new int[bitLevels.length + 1][], histogramIsZeroFilled ? 0L : SummingLongHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new long[levelCount];
                this.sums[k] = new double[levelCount];
                this.numbersOfDifferentValues[k] = new int[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    long count = 0L;
                    double sum = 0.0;
                    int numberOfDifferentValues = 0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (double)value * (double)histogram[value];
                        if (histogram[value] != 0L) {
                            ++numberOfDifferentValues;
                        }
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                    this.numbersOfDifferentValues[k][i] = numberOfDifferentValues;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SummingLongHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Long.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Long.MAX_VALUE");
            }
            boolean wasEmpty = this.histogram0[value] == 0L;
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1L;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                long[] lArray = this.histogram[k];
                int n2 = v;
                lArray[n2] = lArray[n2] + 1L;
                double[] dArray = this.sums[k];
                int n3 = v;
                dArray[n3] = dArray[n3] + (double)value;
                if (wasEmpty) {
                    int[] nArray = this.numbersOfDifferentValues[k];
                    int n4 = v;
                    nArray[n4] = nArray[n4] + 1;
                }
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n5 = k;
                this.currentIRanks[n5] = this.currentIRanks[n5] + 1L;
                int n6 = k;
                this.currentSums[n6] = this.currentSums[n6] + (double)value;
                if (!wasEmpty) continue;
                int n7 = k;
                this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] + 1;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                this.currentSums[0] = this.currentSums[0] + (double)value;
                if (wasEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SummingLongHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n8 = k;
                    hist.currentIRanks[n8] = hist.currentIRanks[n8] + 1L;
                    int n9 = k;
                    hist.currentSums[n9] = hist.currentSums[n9] + (double)value;
                    if (!wasEmpty) continue;
                    int n10 = k;
                    hist.currentNumberOfDifferentValues[n10] = hist.currentNumberOfDifferentValues[n10] + 1;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                    hist.currentSums[0] = hist.currentSums[0] + (double)value;
                    if (wasEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                    }
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1L;
            if (this.histogram0[n] < 0L) {
                long b = this.histogram0[value];
                this.histogram0[value] = 0L;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            boolean becomeEmpty = this.histogram0[value] == 0L;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                long[] lArray = this.histogram[k];
                int n2 = v;
                lArray[n2] = lArray[n2] - 1L;
                double[] dArray = this.sums[k];
                int n3 = v;
                dArray[n3] = dArray[n3] - (double)value;
                if (becomeEmpty) {
                    int[] nArray = this.numbersOfDifferentValues[k];
                    int n4 = v;
                    nArray[n4] = nArray[n4] - 1;
                }
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n5 = k;
                this.currentIRanks[n5] = this.currentIRanks[n5] - 1L;
                int n6 = k;
                this.currentSums[n6] = this.currentSums[n6] - (double)value;
                if (!becomeEmpty) continue;
                int n7 = k;
                this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] - 1;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                this.currentSums[0] = this.currentSums[0] - (double)value;
                if (becomeEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SummingLongHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n8 = k;
                    hist.currentIRanks[n8] = hist.currentIRanks[n8] - 1L;
                    int n9 = k;
                    hist.currentSums[n9] = hist.currentSums[n9] - (double)value;
                    if (!becomeEmpty) continue;
                    int n10 = k;
                    hist.currentNumberOfDifferentValues[n10] = hist.currentNumberOfDifferentValues[n10] - 1;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                    hist.currentSums[0] = hist.currentSums[0] - (double)value;
                    if (becomeEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                    }
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Long.MAX_VALUE - (long)values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Long.MAX_VALUE");
            }
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0L;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n2 = v;
                        lArray[n2] = lArray[n2] + 1L;
                        double[] dArray = this.sums[k];
                        int n3 = v;
                        dArray[n3] = dArray[n3] + (double)value;
                        if (wasEmpty) {
                            int[] nArray = this.numbersOfDifferentValues[k];
                            int n4 = v;
                            nArray[n4] = nArray[n4] + 1;
                        }
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n5 = k;
                            this.currentIRanks[n5] = this.currentIRanks[n5] + 1L;
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] + (double)value;
                            if (wasEmpty) {
                                int n7 = k;
                                this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] + 1;
                            }
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n8 = k;
                        this.nextSharing.currentIRanks[n8] = this.nextSharing.currentIRanks[n8] + 1L;
                        int n9 = k;
                        this.nextSharing.currentSums[n9] = this.nextSharing.currentSums[n9] + (double)value;
                        if (!wasEmpty) continue;
                        int n10 = k;
                        this.nextSharing.currentNumberOfDifferentValues[n10] = this.nextSharing.currentNumberOfDifferentValues[n10] + 1;
                    }
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (double)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (double)value;
                    if (!wasEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] + 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0L;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n11 = v;
                        lArray[n11] = lArray[n11] + 1L;
                        double[] dArray = this.sums[k];
                        int n12 = v;
                        dArray[n12] = dArray[n12] + (double)value;
                        if (wasEmpty) {
                            int[] nArray = this.numbersOfDifferentValues[k];
                            int n13 = v;
                            nArray[n13] = nArray[n13] + 1;
                        }
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n14 = k;
                        this.currentIRanks[n14] = this.currentIRanks[n14] + 1L;
                        int n15 = k;
                        this.currentSums[n15] = this.currentSums[n15] + (double)value;
                        if (!wasEmpty) continue;
                        int n16 = k;
                        this.currentNumberOfDifferentValues[n16] = this.currentNumberOfDifferentValues[n16] + 1;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                        this.currentSums[0] = this.currentSums[0] + (double)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    SummingLongHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n17 = k;
                            hist.currentIRanks[n17] = hist.currentIRanks[n17] + 1L;
                            int n18 = k;
                            hist.currentSums[n18] = hist.currentSums[n18] + (double)value;
                            if (!wasEmpty) continue;
                            int n19 = k;
                            hist.currentNumberOfDifferentValues[n19] = hist.currentNumberOfDifferentValues[n19] + 1;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                            hist.currentSums[0] = hist.currentSums[0] + (double)value;
                            if (wasEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                            }
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                double currentSum1 = this.currentSums[0];
                double currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1L;
                    if (this.histogram0[n2] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean becomeEmpty = this.histogram0[value] == 0L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n3 = v;
                        lArray[n3] = lArray[n3] - 1L;
                        double[] dArray = this.sums[k];
                        int n4 = v;
                        dArray[n4] = dArray[n4] - (double)value;
                        if (becomeEmpty) {
                            int[] nArray2 = this.numbersOfDifferentValues[k];
                            int n5 = v;
                            nArray2[n5] = nArray2[n5] - 1;
                        }
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n6 = k;
                            this.currentIRanks[n6] = this.currentIRanks[n6] - 1L;
                            int n7 = k;
                            this.currentSums[n7] = this.currentSums[n7] - (double)value;
                            if (becomeEmpty) {
                                int n8 = k;
                                this.currentNumberOfDifferentValues[n8] = this.currentNumberOfDifferentValues[n8] - 1;
                            }
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n9 = k;
                        this.nextSharing.currentIRanks[n9] = this.nextSharing.currentIRanks[n9] - 1L;
                        int n10 = k;
                        this.nextSharing.currentSums[n10] = this.nextSharing.currentSums[n10] - (double)value;
                        if (!becomeEmpty) continue;
                        int n11 = k;
                        this.nextSharing.currentNumberOfDifferentValues[n11] = this.nextSharing.currentNumberOfDifferentValues[n11] - 1;
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (double)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (double)value;
                    if (!becomeEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] - 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n12 = value = nArray[i];
                    this.histogram0[n12] = this.histogram0[n12] - 1L;
                    if (this.histogram0[n12] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean becomeEmpty = this.histogram0[value] == 0L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n13 = v;
                        lArray[n13] = lArray[n13] - 1L;
                        double[] dArray = this.sums[k];
                        int n14 = v;
                        dArray[n14] = dArray[n14] - (double)value;
                        if (becomeEmpty) {
                            int[] nArray3 = this.numbersOfDifferentValues[k];
                            int n15 = v;
                            nArray3[n15] = nArray3[n15] - 1;
                        }
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n16 = k;
                        this.currentIRanks[n16] = this.currentIRanks[n16] - 1L;
                        int n17 = k;
                        this.currentSums[n17] = this.currentSums[n17] - (double)value;
                        if (!becomeEmpty) continue;
                        int n18 = k;
                        this.currentNumberOfDifferentValues[n18] = this.currentNumberOfDifferentValues[n18] - 1;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                        this.currentSums[0] = this.currentSums[0] - (double)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    SummingLongHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n19 = k;
                            hist.currentIRanks[n19] = hist.currentIRanks[n19] - 1L;
                            int n20 = k;
                            hist.currentSums[n20] = hist.currentSums[n20] - (double)value;
                            if (!becomeEmpty) continue;
                            int n21 = k;
                            hist.currentNumberOfDifferentValues[n21] = hist.currentNumberOfDifferentValues[n21] - 1;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                            hist.currentSums[0] = hist.currentSums[0] - (double)value;
                            if (becomeEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                            }
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.currentNumberOfDifferentValues[0];
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public SummingHistogram moveToIRank(long rank) {
            block34: {
                block35: {
                    block36: {
                        block33: {
                            if (this.total == 0L) {
                                if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] != 0L) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            if (!SummingLongHistogram.$assertionsDisabled && this.total <= 0L) {
                                throw new AssertionError();
                            }
                            if (rank < 0L) {
                                rank = 0L;
                            } else if (rank > this.total) {
                                rank = this.total;
                            }
                            if (rank != this.total) break block33;
                            this.moveToRightmostRank();
                            break block34;
                        }
                        if (rank >= this.currentIRanks[0]) break block35;
                        if (this.m <= 1) break block36;
                        k = 0;
                        while (k + 1 < this.m && rank < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SummingLongHistogram.$assertionsDisabled && rank >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                                numberOfDifferentValues = this.numbersOfDifferentValues[k][this.currentIValue];
                                v2 = k;
                                this.currentNumberOfDifferentValues[v2] = this.currentNumberOfDifferentValues[v2] - numberOfDifferentValues;
                            } while (rank < this.currentIRanks[k]);
                            if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] < 0L) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            previousNumberOfDifferentValues = this.currentNumberOfDifferentValues[k] + numberOfDifferentValues;
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (double)b * (double)this.currentIValue);
                                this.currentNumberOfDifferentValues[k] = previousNumberOfDifferentValues - (k > 0 ? this.numbersOfDifferentValues[k][this.currentIValue] : (b > 0L ? 1 : 0));
                            } while (k > 0 && rank >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (rank >= this.currentIRanks[0]) break block34;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                        if (b == 0L) continue;
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                    } while (rank < this.currentIRanks[0]);
                    if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] < 0L) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block34;
                }
                if (this.m > 1) {
                    if (rank >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && rank >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (rank >= this.currentIRanks[k] + b) {
                                v3 = k;
                                this.currentIRanks[v3] = this.currentIRanks[v3] + b;
                                v4 = k;
                                this.currentSums[v4] = this.currentSums[v4] + this.sums[k][this.currentIValue];
                                v5 = k;
                                this.currentNumberOfDifferentValues[v5] = this.currentNumberOfDifferentValues[v5] + this.numbersOfDifferentValues[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                                this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                            } while (k > 0 && rank < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!SummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (rank >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                        if (b != 0L) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                frac = (double)(rank - this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToRank(double rank) {
            block36: {
                block37: {
                    block38: {
                        block35: {
                            if (Double.isNaN(rank)) {
                                throw new IllegalArgumentException("Illegal rank argument (NaN)");
                            }
                            if (this.total == 0L) {
                                if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] != 0L) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            this.currentPreciseRank = NaN;
                            if (!SummingLongHistogram.$assertionsDisabled && this.total <= 0L) {
                                throw new AssertionError();
                            }
                            if (rank < 0.0) {
                                r = 0L;
                                rank = 0L;
                            } else if (rank > (double)this.total) {
                                r = this.total;
                                rank = r;
                            } else {
                                r = (int)rank;
                            }
                            if (r != this.total) break block35;
                            this.moveToRightmostRank();
                            break block36;
                        }
                        if (r >= this.currentIRanks[0]) break block37;
                        if (this.m <= 1) break block38;
                        k = 0;
                        while (k + 1 < this.m && r < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SummingLongHistogram.$assertionsDisabled && r >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                                numberOfDifferentValues = this.numbersOfDifferentValues[k][this.currentIValue];
                                v2 = k;
                                this.currentNumberOfDifferentValues[v2] = this.currentNumberOfDifferentValues[v2] - numberOfDifferentValues;
                            } while (r < this.currentIRanks[k]);
                            if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] < 0L) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            previousNumberOfDifferentValues = this.currentNumberOfDifferentValues[k] + numberOfDifferentValues;
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (double)b * (double)this.currentIValue);
                                this.currentNumberOfDifferentValues[k] = previousNumberOfDifferentValues - (k > 0 ? this.numbersOfDifferentValues[k][this.currentIValue] : (b > 0L ? 1 : 0));
                            } while (k > 0 && r >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (r >= this.currentIRanks[0]) break block36;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (double)b * (double)this.currentIValue;
                        if (b == 0L) continue;
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                    } while (r < this.currentIRanks[0]);
                    if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] < 0L) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block36;
                }
                if (this.m > 1) {
                    if (r >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && r >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (r >= this.currentIRanks[k] + b) {
                                v3 = k;
                                this.currentIRanks[v3] = this.currentIRanks[v3] + b;
                                v4 = k;
                                this.currentSums[v4] = this.currentSums[v4] + this.sums[k][this.currentIValue];
                                v5 = k;
                                this.currentNumberOfDifferentValues[v5] = this.currentNumberOfDifferentValues[v5] + this.numbersOfDifferentValues[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingLongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                                this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                            } while (k > 0 && r < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!SummingLongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (r >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                        if (b != 0L) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SummingLongHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] < this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int numberOfDifferentValues;
                        double sum;
                        long b;
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v < this.currentIValue);
                        do {
                            --this.currentIValue;
                            b = this.histogram[k][this.currentIValue];
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - b;
                            sum = this.sums[k][this.currentIValue];
                            int n2 = k;
                            this.currentSums[n2] = this.currentSums[n2] - sum;
                            numberOfDifferentValues = this.numbersOfDifferentValues[k][this.currentIValue];
                            int n3 = k;
                            this.currentNumberOfDifferentValues[n3] = this.currentNumberOfDifferentValues[n3] - numberOfDifferentValues;
                        } while (v < this.currentIValue);
                        assert (this.currentIRanks[k] >= 0L) : "currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for value=" + value;
                        assert (this.currentIValue == v);
                        int previousValue = this.currentIValue + 1 << level;
                        assert (value < previousValue);
                        long previousRank = this.currentIRanks[k] + b;
                        double previousSum = this.currentSums[k] + sum;
                        int previousNumberOfDifferentValues = this.currentNumberOfDifferentValues[k] + numberOfDifferentValues;
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIValue = (previousValue >> level) - 1;
                            b = this.histogram[k][this.currentIValue];
                            this.currentIRanks[k] = previousRank - b;
                            this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (double)b * (double)this.currentIValue);
                            this.currentNumberOfDifferentValues[k] = previousNumberOfDifferentValues - (k > 0 ? this.numbersOfDifferentValues[k][this.currentIValue] : (b > 0L ? 1 : 0));
                        } while (k > 0 && value >> level == this.currentIValue);
                        this.currentIValue <<= level;
                    }
                    assert (k == 0);
                    if (value == this.currentIValue) {
                        return this;
                    }
                    assert (value < this.currentIValue);
                }
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (double)b * (double)j;
                    if (b == 0L) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] > this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v > this.currentIValue);
                        do {
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][this.currentIValue];
                            int n4 = k;
                            this.currentSums[n4] = this.currentSums[n4] + this.sums[k][this.currentIValue];
                            int n5 = k;
                            this.currentNumberOfDifferentValues[n5] = this.currentNumberOfDifferentValues[n5] + this.numbersOfDifferentValues[k][this.currentIValue];
                            ++this.currentIValue;
                        } while (v > this.currentIValue);
                        assert (this.currentIRanks[k] <= this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + "> total=" + this.total + " for value=" + value;
                        assert (this.currentIValue == v);
                        this.currentIValue <<= level;
                        assert (this.currentIValue <= value);
                        long lastRank = this.currentIRanks[k];
                        double lastSum = this.currentSums[k];
                        int lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIRanks[k] = lastRank;
                            this.currentSums[k] = lastSum;
                            this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                        } while (k > 0 && value >> level == this.currentIValue >> level);
                    }
                    assert (k == 0);
                }
                for (int j = this.currentIValue; j < value; ++j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (double)b * (double)j;
                    if (b == 0L) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1L) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            long[] lArray = this.histogram0;
            synchronized (this.histogram0) {
                SummingLongHistogram result = new SummingLongHistogram(this.histogram, this.sums, this.numbersOfDifferentValues, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SummingLongHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert ((long)count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SummingLongHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing long histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1L ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            System.arraycopy(this.currentNumberOfDifferentValues, 0, this.alternativeNumberOfDifferentValues, 0, this.m);
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void restoreRanks() {
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            double[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0L || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            if (this.currentNumberOfDifferentValues[0] < 0 || (long)this.currentNumberOfDifferentValues[0] > Math.min((long)this.length, this.total)) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentNumberOfDifferentValues = " + this.currentNumberOfDifferentValues[0] + " is out of range 0..min(" + this.length + "," + this.total + ")"));
            }
            for (int k = 0; k < this.m; ++k) {
                int nDifferentValues = 0;
                if (k == 0) {
                    nDifferentValues = this.simpleCurrentNDV();
                } else {
                    for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                        nDifferentValues += this.histogram0[j] == 0L ? 0 : 1;
                    }
                }
                if (this.currentNumberOfDifferentValues[k] != nDifferentValues) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentNumberOfDifferentValues[" + k + "] = " + this.currentNumberOfDifferentValues[k] + " != " + nDifferentValues + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                long s = SummingLongHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]);
                if (this.currentIRanks[k] != s) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                double sum = 0.0;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (double)this.histogram0[j] * (double)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SummingLongHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SummingLongHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SummingLongHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SummingLongHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            block35: {
                block34: {
                    int v;
                    assert (this.total > 0L);
                    assert (this.currentIRanks[0] <= this.total);
                    if (this.currentIRanks[0] >= this.total) break block34;
                    if (this.m > 1) {
                        int k = 0;
                        while (k + 1 < this.m && this.total > this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            long b = this.histogram[k][this.currentIValue];
                            while (this.total > this.currentIRanks[k] + b) {
                                int n = k;
                                this.currentIRanks[n] = this.currentIRanks[n] + b;
                                int n2 = k;
                                this.currentSums[n2] = this.currentSums[n2] + this.sums[k][this.currentIValue];
                                int n3 = k;
                                this.currentNumberOfDifferentValues[n3] = this.currentNumberOfDifferentValues[n3] + this.numbersOfDifferentValues[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            assert (this.currentIRanks[k] < this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total;
                            this.currentIValue <<= level;
                            long lastRank = this.currentIRanks[k];
                            double lastSum = this.currentSums[k];
                            int lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                            do {
                                level = this.bitLevels[--k];
                                assert (k > 0 || level == 0);
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                                this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                            } while (k > 0 && this.total <= this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        assert (k == 0);
                    }
                    assert (this.currentIRanks[0] < this.total);
                    do {
                        long b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (double)b * (double)this.currentIValue;
                        if (b != 0L) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                        ++this.currentIValue;
                    } while (this.currentIRanks[0] < this.total);
                    assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                    assert (this.histogram0[this.currentIValue - 1] > 0L);
                    if (this.m <= 1) break block35;
                    for (int k = 1; k < this.m && (v = this.currentIValue - 1 >> this.bitLevels[k]) < this.currentIValue >> this.bitLevels[k]; ++k) {
                        int n = k;
                        this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][v];
                        int n4 = k;
                        this.currentSums[n4] = this.currentSums[n4] + this.sums[k][v];
                        int n5 = k;
                        this.currentNumberOfDifferentValues[n5] = this.currentNumberOfDifferentValues[n5] + this.numbersOfDifferentValues[k][v];
                    }
                    break block35;
                }
                if (this.histogram0[this.currentIValue - 1] == 0L) {
                    int k;
                    assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0L);
                    --this.currentIValue;
                    int previousValue = this.currentIValue + 1;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]] == 0L) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0L);
                            while (this.histogram[k][this.currentIValue - 1] == 0L) {
                                --this.currentIValue;
                                assert (this.currentIValue > 0);
                            }
                            int v = this.currentIValue - 1;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0L);
                            assert (this.histogram[k][v] > 0L);
                            this.currentIValue <<= level;
                            --k;
                        }
                    }
                    assert (this.currentIValue > 0);
                    assert (this.histogram0[this.currentIValue] == 0L);
                    while (this.histogram0[this.currentIValue - 1] == 0L) {
                        --this.currentIValue;
                        assert (this.currentIValue > 0);
                    }
                    if (this.m > 1) {
                        int v;
                        for (k = 1; k < this.m && (v = this.currentIValue >> this.bitLevels[k]) < previousValue >> this.bitLevels[k]; ++k) {
                            long b = this.histogram[k][v];
                            if (b <= 0L) continue;
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - this.histogram[k][v];
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] - this.sums[k][v];
                            int n7 = k;
                            this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] - this.numbersOfDifferentValues[k][v];
                        }
                    }
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0L) continue;
                ++result;
            }
            return result;
        }

        private static long[][] newMultilevelHistogram(long[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            long[][] result = new long[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static long sumOfAndCheck(long[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            long result = 0L;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0L) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Long.MAX_VALUE");
            }
            return result;
        }
    }

    static class SimplifiedSummingInt1LevelHistogram
    extends SummingHistogram {
        private final int[][] histogram;
        private final int[] histogram0;
        private final long[][] sums;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private int total;
        private int[] currentIRanks;
        private long[] currentSums;
        private int[] alternativeIRanks;
        private long[] alternativeSums;
        private SimplifiedSummingInt1LevelHistogram nextSharing = this;
        private int shareCount = 1;

        private SimplifiedSummingInt1LevelHistogram(int[][] histogram, long[][] sums, int total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new int[this.m];
            this.currentSums = new long[this.m];
            this.alternativeIRanks = new int[this.m];
            this.alternativeSums = new long[this.m];
        }

        SimplifiedSummingInt1LevelHistogram(int[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SimplifiedSummingInt1LevelHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new long[bitLevels.length + 1][], histogramIsZeroFilled ? 0 : SimplifiedSummingInt1LevelHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new int[levelCount];
                this.sums[k] = new long[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    int count = 0;
                    long sum = 0L;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (long)value * (long)histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : (long)this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SimplifiedSummingInt1LevelHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Integer.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Integer.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1;
                this.currentSums[0] = this.currentSums[0] + (long)value;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingInt1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                    hist.currentSums[0] = hist.currentSums[0] + (long)value;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1;
            if (this.histogram0[n] < 0) {
                int b = this.histogram0[value];
                this.histogram0[value] = 0;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1;
                this.currentSums[0] = this.currentSums[0] - (long)value;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingInt1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                    hist.currentSums[0] = hist.currentSums[0] - (long)value;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Integer.MAX_VALUE - values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Integer.MAX_VALUE");
            }
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1;
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (long)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (long)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] + 1;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1;
                        this.currentSums[0] = this.currentSums[0] + (long)value;
                    }
                    SimplifiedSummingInt1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                            hist.currentSums[0] = hist.currentSums[0] + (long)value;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1;
                    if (this.histogram0[n2] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (long)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (long)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] - 1;
                    if (this.histogram0[n3] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1;
                        this.currentSums[0] = this.currentSums[0] - (long)value;
                    }
                    SimplifiedSummingInt1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                            hist.currentSums[0] = hist.currentSums[0] - (long)value;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.simpleCurrentNDV();
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        @Override
        public SummingHistogram moveToIRank(long rank) {
            if (this.total == 0) {
                assert (this.currentIRanks[0] == 0) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            assert (this.total > 0);
            if (rank < 0L) {
                rank = 0L;
            } else if (rank > (long)this.total) {
                rank = this.total;
            }
            if (rank == (long)this.total) {
                this.moveToRightmostRank();
            } else if (rank < (long)this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                } while (rank < (long)this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (rank >= (long)(this.currentIRanks[0] + b)) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (long)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                double frac = (double)(rank - (long)this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        @Override
        public Histogram moveToRank(double rank) {
            int b;
            int r;
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            if (this.total == 0) {
                assert (this.currentIRanks[0] == 0) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            this.currentPreciseRank = Double.NaN;
            assert (this.total > 0);
            if (rank < 0.0) {
                r = 0;
                rank = 0;
            } else if (rank > (double)this.total) {
                r = this.total;
                rank = r;
            } else {
                r = (int)rank;
            }
            if (r == this.total) {
                this.moveToRightmostRank();
            } else if (r < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                } while (r < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (r >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                double frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)j;
                }
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                for (int j = this.currentIValue; j < value; ++j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)j;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            int[] nArray = this.histogram0;
            synchronized (this.histogram0) {
                SimplifiedSummingInt1LevelHistogram result = new SimplifiedSummingInt1LevelHistogram(this.histogram, this.sums, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SimplifiedSummingInt1LevelHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert (count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SimplifiedSummingInt1LevelHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing int histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1 ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void restoreRanks() {
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0 || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                int s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = SimplifiedSummingInt1LevelHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                long sum = 0L;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (long)this.histogram0[j] * (long)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SimplifiedSummingInt1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SimplifiedSummingInt1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SimplifiedSummingInt1LevelHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SimplifiedSummingInt1LevelHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            assert (this.total > 0);
            assert (this.currentIRanks[0] <= this.total);
            if (this.currentIRanks[0] < this.total) {
                assert (this.currentIRanks[0] < this.total);
                do {
                    int b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                    ++this.currentIValue;
                } while (this.currentIRanks[0] < this.total);
                assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                assert (this.histogram0[this.currentIValue - 1] > 0);
            } else if (this.histogram0[this.currentIValue - 1] == 0) {
                assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0);
                --this.currentIValue;
                assert (this.currentIValue > 0);
                assert (this.histogram0[this.currentIValue] == 0);
                while (this.histogram0[this.currentIValue - 1] == 0) {
                    --this.currentIValue;
                    assert (this.currentIValue > 0);
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0) continue;
                ++result;
            }
            return result;
        }

        private static int[][] newMultilevelHistogram(int[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            int[][] result = new int[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static int sumOfAndCheck(int[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            int result = 0;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Integer.MAX_VALUE");
            }
            return result;
        }
    }

    static class SimplifiedSummingIntHistogram
    extends SummingHistogram {
        private final int[][] histogram;
        private final int[] histogram0;
        private final long[][] sums;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private int total;
        private int[] currentIRanks;
        private long[] currentSums;
        private int[] alternativeIRanks;
        private long[] alternativeSums;
        private SimplifiedSummingIntHistogram nextSharing = this;
        private int shareCount = 1;

        private SimplifiedSummingIntHistogram(int[][] histogram, long[][] sums, int total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new int[this.m];
            this.currentSums = new long[this.m];
            this.alternativeIRanks = new int[this.m];
            this.alternativeSums = new long[this.m];
        }

        SimplifiedSummingIntHistogram(int[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SimplifiedSummingIntHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new long[bitLevels.length + 1][], histogramIsZeroFilled ? 0 : SimplifiedSummingIntHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new int[levelCount];
                this.sums[k] = new long[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    int count = 0;
                    long sum = 0L;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (long)value * (long)histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : (long)this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SimplifiedSummingIntHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Integer.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Integer.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                int[] nArray = this.histogram[k];
                int n2 = v;
                nArray[n2] = nArray[n2] + 1;
                long[] lArray = this.sums[k];
                int n3 = v;
                lArray[n3] = lArray[n3] + (long)value;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n4 = k;
                this.currentIRanks[n4] = this.currentIRanks[n4] + 1;
                int n5 = k;
                this.currentSums[n5] = this.currentSums[n5] + (long)value;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1;
                this.currentSums[0] = this.currentSums[0] + (long)value;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingIntHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n6 = k;
                    hist.currentIRanks[n6] = hist.currentIRanks[n6] + 1;
                    int n7 = k;
                    hist.currentSums[n7] = hist.currentSums[n7] + (long)value;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                    hist.currentSums[0] = hist.currentSums[0] + (long)value;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1;
            if (this.histogram0[n] < 0) {
                int b = this.histogram0[value];
                this.histogram0[value] = 0;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                int[] nArray = this.histogram[k];
                int n2 = v;
                nArray[n2] = nArray[n2] - 1;
                long[] lArray = this.sums[k];
                int n3 = v;
                lArray[n3] = lArray[n3] - (long)value;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n4 = k;
                this.currentIRanks[n4] = this.currentIRanks[n4] - 1;
                int n5 = k;
                this.currentSums[n5] = this.currentSums[n5] - (long)value;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1;
                this.currentSums[0] = this.currentSums[0] - (long)value;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SimplifiedSummingIntHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n6 = k;
                    hist.currentIRanks[n6] = hist.currentIRanks[n6] - 1;
                    int n7 = k;
                    hist.currentSums[n7] = hist.currentSums[n7] - (long)value;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                    hist.currentSums[0] = hist.currentSums[0] - (long)value;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Integer.MAX_VALUE - values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Integer.MAX_VALUE");
            }
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray2 = this.histogram[k];
                        int n3 = v;
                        nArray2[n3] = nArray2[n3] + 1;
                        long[] lArray = this.sums[k];
                        int n4 = v;
                        lArray[n4] = lArray[n4] + (long)value;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n5 = k;
                            this.currentIRanks[n5] = this.currentIRanks[n5] + 1;
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] + (long)value;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n7 = k;
                        this.nextSharing.currentIRanks[n7] = this.nextSharing.currentIRanks[n7] + 1;
                        int n8 = k;
                        this.nextSharing.currentSums[n8] = this.nextSharing.currentSums[n8] + (long)value;
                    }
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (long)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (long)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n9 = value = nArray[i];
                    this.histogram0[n9] = this.histogram0[n9] + 1;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray3 = this.histogram[k];
                        int n10 = v;
                        nArray3[n10] = nArray3[n10] + 1;
                        long[] lArray = this.sums[k];
                        int n11 = v;
                        lArray[n11] = lArray[n11] + (long)value;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n12 = k;
                        this.currentIRanks[n12] = this.currentIRanks[n12] + 1;
                        int n13 = k;
                        this.currentSums[n13] = this.currentSums[n13] + (long)value;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1;
                        this.currentSums[0] = this.currentSums[0] + (long)value;
                    }
                    SimplifiedSummingIntHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n14 = k;
                            hist.currentIRanks[n14] = hist.currentIRanks[n14] + 1;
                            int n15 = k;
                            hist.currentSums[n15] = hist.currentSums[n15] + (long)value;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                            hist.currentSums[0] = hist.currentSums[0] + (long)value;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1;
                    if (this.histogram0[n2] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray2 = this.histogram[k];
                        int n3 = v;
                        nArray2[n3] = nArray2[n3] - 1;
                        long[] lArray = this.sums[k];
                        int n4 = v;
                        lArray[n4] = lArray[n4] - (long)value;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n5 = k;
                            this.currentIRanks[n5] = this.currentIRanks[n5] - 1;
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] - (long)value;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n7 = k;
                        this.nextSharing.currentIRanks[n7] = this.nextSharing.currentIRanks[n7] - 1;
                        int n8 = k;
                        this.nextSharing.currentSums[n8] = this.nextSharing.currentSums[n8] - (long)value;
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (long)value;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (long)value;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n9 = value = nArray[i];
                    this.histogram0[n9] = this.histogram0[n9] - 1;
                    if (this.histogram0[n9] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray3 = this.histogram[k];
                        int n10 = v;
                        nArray3[n10] = nArray3[n10] - 1;
                        long[] lArray = this.sums[k];
                        int n11 = v;
                        lArray[n11] = lArray[n11] - (long)value;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n12 = k;
                        this.currentIRanks[n12] = this.currentIRanks[n12] - 1;
                        int n13 = k;
                        this.currentSums[n13] = this.currentSums[n13] - (long)value;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1;
                        this.currentSums[0] = this.currentSums[0] - (long)value;
                    }
                    SimplifiedSummingIntHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n14 = k;
                            hist.currentIRanks[n14] = hist.currentIRanks[n14] - 1;
                            int n15 = k;
                            hist.currentSums[n15] = hist.currentSums[n15] - (long)value;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                            hist.currentSums[0] = hist.currentSums[0] - (long)value;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.simpleCurrentNDV();
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public SummingHistogram moveToIRank(long rank) {
            block33: {
                block34: {
                    block35: {
                        block32: {
                            if (this.total == 0) {
                                if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] != 0) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.total <= 0) {
                                throw new AssertionError();
                            }
                            if (rank < 0L) {
                                rank = 0L;
                            } else if (rank > (long)this.total) {
                                rank = this.total;
                            }
                            if (rank != (long)this.total) break block32;
                            this.moveToRightmostRank();
                            break block33;
                        }
                        if (rank >= (long)this.currentIRanks[0]) break block34;
                        if (this.m <= 1) break block35;
                        k = 0;
                        while (k + 1 < this.m && rank < (long)this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && rank >= (long)this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                            } while (rank < (long)this.currentIRanks[k]);
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] < 0) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (long)b * (long)this.currentIValue);
                            } while (k > 0 && rank >= (long)this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (rank >= (long)this.currentIRanks[0]) break block33;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                    } while (rank < (long)this.currentIRanks[0]);
                    if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] < 0) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block33;
                }
                if (this.m > 1) {
                    if (rank >= (long)(this.currentIRanks[0] + this.histogram0[this.currentIValue])) {
                        k = 0;
                        while (k + 1 < this.m && rank >= (long)(this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]])) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (rank >= (long)(this.currentIRanks[k] + b)) {
                                v2 = k;
                                this.currentIRanks[v2] = this.currentIRanks[v2] + b;
                                v3 = k;
                                this.currentSums[v3] = this.currentSums[v3] + this.sums[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                            } while (k > 0 && rank < (long)(this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]));
                        }
                        if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (rank >= (long)(this.currentIRanks[0] + b)) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (long)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                frac = (double)(rank - (long)this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToRank(double rank) {
            block35: {
                block36: {
                    block37: {
                        block34: {
                            if (Double.isNaN(rank)) {
                                throw new IllegalArgumentException("Illegal rank argument (NaN)");
                            }
                            if (this.total == 0) {
                                if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] != 0) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            this.currentPreciseRank = NaN;
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.total <= 0) {
                                throw new AssertionError();
                            }
                            if (rank < 0.0) {
                                r = 0;
                                rank = 0;
                            } else if (rank > (double)this.total) {
                                r = this.total;
                                rank = r;
                            } else {
                                r = (int)rank;
                            }
                            if (r != this.total) break block34;
                            this.moveToRightmostRank();
                            break block35;
                        }
                        if (r >= this.currentIRanks[0]) break block36;
                        if (this.m <= 1) break block37;
                        k = 0;
                        while (k + 1 < this.m && r < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && r >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                            } while (r < this.currentIRanks[k]);
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] < 0) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (long)b * (long)this.currentIValue);
                            } while (k > 0 && r >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (r >= this.currentIRanks[0]) break block35;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                    } while (r < this.currentIRanks[0]);
                    if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] < 0) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block35;
                }
                if (this.m > 1) {
                    if (r >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && r >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (r >= this.currentIRanks[k] + b) {
                                v2 = k;
                                this.currentIRanks[v2] = this.currentIRanks[v2] + b;
                                v3 = k;
                                this.currentSums[v3] = this.currentSums[v3] + this.sums[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                            } while (k > 0 && r < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!SimplifiedSummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (r >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SimplifiedSummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] < this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        long sum;
                        int b;
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v < this.currentIValue);
                        do {
                            --this.currentIValue;
                            b = this.histogram[k][this.currentIValue];
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - b;
                            sum = this.sums[k][this.currentIValue];
                            int n2 = k;
                            this.currentSums[n2] = this.currentSums[n2] - sum;
                        } while (v < this.currentIValue);
                        assert (this.currentIRanks[k] >= 0) : "currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for value=" + value;
                        assert (this.currentIValue == v);
                        int previousValue = this.currentIValue + 1 << level;
                        assert (value < previousValue);
                        int previousRank = this.currentIRanks[k] + b;
                        long previousSum = this.currentSums[k] + sum;
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIValue = (previousValue >> level) - 1;
                            b = this.histogram[k][this.currentIValue];
                            this.currentIRanks[k] = previousRank - b;
                            this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (long)b * (long)this.currentIValue);
                        } while (k > 0 && value >> level == this.currentIValue);
                        this.currentIValue <<= level;
                    }
                    assert (k == 0);
                    if (value == this.currentIValue) {
                        return this;
                    }
                    assert (value < this.currentIValue);
                }
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)j;
                }
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] > this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v > this.currentIValue);
                        do {
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][this.currentIValue];
                            int n3 = k;
                            this.currentSums[n3] = this.currentSums[n3] + this.sums[k][this.currentIValue];
                            ++this.currentIValue;
                        } while (v > this.currentIValue);
                        assert (this.currentIRanks[k] <= this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + "> total=" + this.total + " for value=" + value;
                        assert (this.currentIValue == v);
                        this.currentIValue <<= level;
                        assert (this.currentIValue <= value);
                        int lastRank = this.currentIRanks[k];
                        long lastSum = this.currentSums[k];
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIRanks[k] = lastRank;
                            this.currentSums[k] = lastSum;
                        } while (k > 0 && value >> level == this.currentIValue >> level);
                    }
                    assert (k == 0);
                }
                for (int j = this.currentIValue; j < value; ++j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)j;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            int[] nArray = this.histogram0;
            synchronized (this.histogram0) {
                SimplifiedSummingIntHistogram result = new SimplifiedSummingIntHistogram(this.histogram, this.sums, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SimplifiedSummingIntHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert (count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SimplifiedSummingIntHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing int histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1 ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void restoreRanks() {
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0 || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                int s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = SimplifiedSummingIntHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                long sum = 0L;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (long)this.histogram0[j] * (long)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SimplifiedSummingIntHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SimplifiedSummingIntHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SimplifiedSummingIntHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SimplifiedSummingIntHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            block34: {
                block33: {
                    int v;
                    int k;
                    assert (this.total > 0);
                    assert (this.currentIRanks[0] <= this.total);
                    if (this.currentIRanks[0] >= this.total) break block33;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.total > this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            int b = this.histogram[k][this.currentIValue];
                            while (this.total > this.currentIRanks[k] + b) {
                                int n = k;
                                this.currentIRanks[n] = this.currentIRanks[n] + b;
                                int n2 = k;
                                this.currentSums[n2] = this.currentSums[n2] + this.sums[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            assert (this.currentIRanks[k] < this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total;
                            this.currentIValue <<= level;
                            int lastRank = this.currentIRanks[k];
                            long lastSum = this.currentSums[k];
                            do {
                                level = this.bitLevels[--k];
                                assert (k > 0 || level == 0);
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                            } while (k > 0 && this.total <= this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        assert (k == 0);
                    }
                    assert (this.currentIRanks[0] < this.total);
                    do {
                        int b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                        ++this.currentIValue;
                    } while (this.currentIRanks[0] < this.total);
                    assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                    assert (this.histogram0[this.currentIValue - 1] > 0);
                    if (this.m <= 1) break block34;
                    for (k = 1; k < this.m && (v = this.currentIValue - 1 >> this.bitLevels[k]) < this.currentIValue >> this.bitLevels[k]; ++k) {
                        int n = k;
                        this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][v];
                        int n3 = k;
                        this.currentSums[n3] = this.currentSums[n3] + this.sums[k][v];
                    }
                    break block34;
                }
                if (this.histogram0[this.currentIValue - 1] == 0) {
                    int k;
                    assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0);
                    --this.currentIValue;
                    int previousValue = this.currentIValue + 1;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]] == 0) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0);
                            while (this.histogram[k][this.currentIValue - 1] == 0) {
                                --this.currentIValue;
                                assert (this.currentIValue > 0);
                            }
                            int v = this.currentIValue - 1;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0);
                            assert (this.histogram[k][v] > 0);
                            this.currentIValue <<= level;
                            --k;
                        }
                    }
                    assert (this.currentIValue > 0);
                    assert (this.histogram0[this.currentIValue] == 0);
                    while (this.histogram0[this.currentIValue - 1] == 0) {
                        --this.currentIValue;
                        assert (this.currentIValue > 0);
                    }
                    if (this.m > 1) {
                        int v;
                        for (k = 1; k < this.m && (v = this.currentIValue >> this.bitLevels[k]) < previousValue >> this.bitLevels[k]; ++k) {
                            int b = this.histogram[k][v];
                            if (b <= 0) continue;
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - this.histogram[k][v];
                            int n4 = k;
                            this.currentSums[n4] = this.currentSums[n4] - this.sums[k][v];
                        }
                    }
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0) continue;
                ++result;
            }
            return result;
        }

        private static int[][] newMultilevelHistogram(int[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            int[][] result = new int[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static int sumOfAndCheck(int[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            int result = 0;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Integer.MAX_VALUE");
            }
            return result;
        }
    }

    static class SummingInt1LevelHistogram
    extends SummingHistogram {
        private final int[][] histogram;
        private final int[] histogram0;
        private final long[][] sums;
        private final int[][] numbersOfDifferentValues;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private int total;
        private int[] currentIRanks;
        private long[] currentSums;
        private int[] currentNumberOfDifferentValues;
        private int[] alternativeIRanks;
        private long[] alternativeSums;
        private int[] alternativeNumberOfDifferentValues;
        private SummingInt1LevelHistogram nextSharing = this;
        private int shareCount = 1;

        private SummingInt1LevelHistogram(int[][] histogram, long[][] sums, int[][] numbersOfDifferentValues, int total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.numbersOfDifferentValues = numbersOfDifferentValues;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new int[this.m];
            this.currentSums = new long[this.m];
            this.currentNumberOfDifferentValues = new int[this.m];
            this.alternativeIRanks = new int[this.m];
            this.alternativeSums = new long[this.m];
            this.alternativeNumberOfDifferentValues = new int[this.m];
        }

        SummingInt1LevelHistogram(int[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SummingInt1LevelHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new long[bitLevels.length + 1][], new int[bitLevels.length + 1][], histogramIsZeroFilled ? 0 : SummingInt1LevelHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new int[levelCount];
                this.sums[k] = new long[levelCount];
                this.numbersOfDifferentValues[k] = new int[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    int count = 0;
                    long sum = 0L;
                    int numberOfDifferentValues = 0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (long)value * (long)histogram[value];
                        if (histogram[value] != 0) {
                            ++numberOfDifferentValues;
                        }
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                    this.numbersOfDifferentValues[k][i] = numberOfDifferentValues;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : (long)this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SummingInt1LevelHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Integer.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Integer.MAX_VALUE");
            }
            boolean wasEmpty = this.histogram0[value] == 0;
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1;
                this.currentSums[0] = this.currentSums[0] + (long)value;
                if (wasEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SummingInt1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                    hist.currentSums[0] = hist.currentSums[0] + (long)value;
                    if (wasEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                    }
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            boolean becomeEmpty;
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1;
            if (this.histogram0[n] < 0) {
                int b = this.histogram0[value];
                this.histogram0[value] = 0;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            boolean bl = becomeEmpty = this.histogram0[value] == 0;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1;
                this.currentSums[0] = this.currentSums[0] - (long)value;
                if (becomeEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SummingInt1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                    hist.currentSums[0] = hist.currentSums[0] - (long)value;
                    if (becomeEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                    }
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Integer.MAX_VALUE - values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Integer.MAX_VALUE");
            }
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1;
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (long)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (long)value;
                    if (!wasEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] + 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1;
                        this.currentSums[0] = this.currentSums[0] + (long)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    SummingInt1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                            hist.currentSums[0] = hist.currentSums[0] + (long)value;
                            if (wasEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                            }
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean becomeEmpty;
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1;
                    if (this.histogram0[n2] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean bl = becomeEmpty = this.histogram0[value] == 0;
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (long)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (long)value;
                    if (!becomeEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] - 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean becomeEmpty;
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] - 1;
                    if (this.histogram0[n3] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean bl = becomeEmpty = this.histogram0[value] == 0;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1;
                        this.currentSums[0] = this.currentSums[0] - (long)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    SummingInt1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                            hist.currentSums[0] = hist.currentSums[0] - (long)value;
                            if (becomeEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                            }
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.currentNumberOfDifferentValues[0];
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        @Override
        public SummingHistogram moveToIRank(long rank) {
            if (this.total == 0) {
                assert (this.currentIRanks[0] == 0) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            assert (this.total > 0);
            if (rank < 0L) {
                rank = 0L;
            } else if (rank > (long)this.total) {
                rank = this.total;
            }
            if (rank == (long)this.total) {
                this.moveToRightmostRank();
            } else if (rank < (long)this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                    if (b == 0) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                } while (rank < (long)this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (rank >= (long)(this.currentIRanks[0] + b)) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                    if (b != 0) {
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                    }
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (long)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                double frac = (double)(rank - (long)this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        @Override
        public Histogram moveToRank(double rank) {
            int b;
            int r;
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            if (this.total == 0) {
                assert (this.currentIRanks[0] == 0) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            this.currentPreciseRank = Double.NaN;
            assert (this.total > 0);
            if (rank < 0.0) {
                r = 0;
                rank = 0;
            } else if (rank > (double)this.total) {
                r = this.total;
                rank = r;
            } else {
                r = (int)rank;
            }
            if (r == this.total) {
                this.moveToRightmostRank();
            } else if (r < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                    if (b == 0) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                } while (r < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (r >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                    if (b != 0) {
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                    }
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                double frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)j;
                    if (b == 0) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                for (int j = this.currentIValue; j < value; ++j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)j;
                    if (b == 0) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            int[] nArray = this.histogram0;
            synchronized (this.histogram0) {
                SummingInt1LevelHistogram result = new SummingInt1LevelHistogram(this.histogram, this.sums, this.numbersOfDifferentValues, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SummingInt1LevelHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert (count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SummingInt1LevelHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing int histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1 ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            System.arraycopy(this.currentNumberOfDifferentValues, 0, this.alternativeNumberOfDifferentValues, 0, this.m);
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void restoreRanks() {
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0 || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            if (this.currentNumberOfDifferentValues[0] < 0 || this.currentNumberOfDifferentValues[0] > Math.min(this.length, this.total)) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentNumberOfDifferentValues = " + this.currentNumberOfDifferentValues[0] + " is out of range 0..min(" + this.length + "," + this.total + ")"));
            }
            for (int k = 0; k < this.m; ++k) {
                int nDifferentValues = 0;
                if (k == 0) {
                    nDifferentValues = this.simpleCurrentNDV();
                } else {
                    for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                        nDifferentValues += this.histogram0[j] == 0 ? 0 : 1;
                    }
                }
                if (this.currentNumberOfDifferentValues[k] != nDifferentValues) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentNumberOfDifferentValues[" + k + "] = " + this.currentNumberOfDifferentValues[k] + " != " + nDifferentValues + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                int s = SummingInt1LevelHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]);
                if (this.currentIRanks[k] != s) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                long sum = 0L;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (long)this.histogram0[j] * (long)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SummingInt1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SummingInt1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SummingInt1LevelHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SummingInt1LevelHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            assert (this.total > 0);
            assert (this.currentIRanks[0] <= this.total);
            if (this.currentIRanks[0] < this.total) {
                assert (this.currentIRanks[0] < this.total);
                do {
                    int b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                    if (b != 0) {
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                    }
                    ++this.currentIValue;
                } while (this.currentIRanks[0] < this.total);
                assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                assert (this.histogram0[this.currentIValue - 1] > 0);
            } else if (this.histogram0[this.currentIValue - 1] == 0) {
                assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0);
                --this.currentIValue;
                assert (this.currentIValue > 0);
                assert (this.histogram0[this.currentIValue] == 0);
                while (this.histogram0[this.currentIValue - 1] == 0) {
                    --this.currentIValue;
                    assert (this.currentIValue > 0);
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0) continue;
                ++result;
            }
            return result;
        }

        private static int[][] newMultilevelHistogram(int[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            int[][] result = new int[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static int sumOfAndCheck(int[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            int result = 0;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Integer.MAX_VALUE");
            }
            return result;
        }
    }

    static class SummingIntHistogram
    extends SummingHistogram {
        private final int[][] histogram;
        private final int[] histogram0;
        private final long[][] sums;
        private final int[][] numbersOfDifferentValues;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private int total;
        private int[] currentIRanks;
        private long[] currentSums;
        private int[] currentNumberOfDifferentValues;
        private int[] alternativeIRanks;
        private long[] alternativeSums;
        private int[] alternativeNumberOfDifferentValues;
        private SummingIntHistogram nextSharing = this;
        private int shareCount = 1;

        private SummingIntHistogram(int[][] histogram, long[][] sums, int[][] numbersOfDifferentValues, int total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            assert (sums.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.sums = sums;
            this.numbersOfDifferentValues = numbersOfDifferentValues;
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new int[this.m];
            this.currentSums = new long[this.m];
            this.currentNumberOfDifferentValues = new int[this.m];
            this.alternativeIRanks = new int[this.m];
            this.alternativeSums = new long[this.m];
            this.alternativeNumberOfDifferentValues = new int[this.m];
        }

        SummingIntHistogram(int[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(SummingIntHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), new long[bitLevels.length + 1][], new int[bitLevels.length + 1][], histogramIsZeroFilled ? 0 : SummingIntHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new int[levelCount];
                this.sums[k] = new long[levelCount];
                this.numbersOfDifferentValues[k] = new int[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    int count = 0;
                    long sum = 0L;
                    int numberOfDifferentValues = 0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        sum += (long)value * (long)histogram[value];
                        if (histogram[value] != 0) {
                            ++numberOfDifferentValues;
                        }
                        ++value;
                    }
                    this.histogram[k][i] = count;
                    this.sums[k][i] = sum;
                    this.numbersOfDifferentValues[k][i] = numberOfDifferentValues;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : (long)this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return SummingIntHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Integer.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Integer.MAX_VALUE");
            }
            boolean wasEmpty = this.histogram0[value] == 0;
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                int[] nArray = this.histogram[k];
                int n2 = v;
                nArray[n2] = nArray[n2] + 1;
                long[] lArray = this.sums[k];
                int n3 = v;
                lArray[n3] = lArray[n3] + (long)value;
                if (wasEmpty) {
                    int[] nArray2 = this.numbersOfDifferentValues[k];
                    int n4 = v;
                    nArray2[n4] = nArray2[n4] + 1;
                }
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n5 = k;
                this.currentIRanks[n5] = this.currentIRanks[n5] + 1;
                int n6 = k;
                this.currentSums[n6] = this.currentSums[n6] + (long)value;
                if (!wasEmpty) continue;
                int n7 = k;
                this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] + 1;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1;
                this.currentSums[0] = this.currentSums[0] + (long)value;
                if (wasEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            SummingIntHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n8 = k;
                    hist.currentIRanks[n8] = hist.currentIRanks[n8] + 1;
                    int n9 = k;
                    hist.currentSums[n9] = hist.currentSums[n9] + (long)value;
                    if (!wasEmpty) continue;
                    int n10 = k;
                    hist.currentNumberOfDifferentValues[n10] = hist.currentNumberOfDifferentValues[n10] + 1;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                    hist.currentSums[0] = hist.currentSums[0] + (long)value;
                    if (wasEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                    }
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1;
            if (this.histogram0[n] < 0) {
                int b = this.histogram0[value];
                this.histogram0[value] = 0;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            boolean becomeEmpty = this.histogram0[value] == 0;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                int[] nArray = this.histogram[k];
                int n2 = v;
                nArray[n2] = nArray[n2] - 1;
                long[] lArray = this.sums[k];
                int n3 = v;
                lArray[n3] = lArray[n3] - (long)value;
                if (becomeEmpty) {
                    int[] nArray2 = this.numbersOfDifferentValues[k];
                    int n4 = v;
                    nArray2[n4] = nArray2[n4] - 1;
                }
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n5 = k;
                this.currentIRanks[n5] = this.currentIRanks[n5] - 1;
                int n6 = k;
                this.currentSums[n6] = this.currentSums[n6] - (long)value;
                if (!becomeEmpty) continue;
                int n7 = k;
                this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] - 1;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1;
                this.currentSums[0] = this.currentSums[0] - (long)value;
                if (becomeEmpty) {
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            SummingIntHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n8 = k;
                    hist.currentIRanks[n8] = hist.currentIRanks[n8] - 1;
                    int n9 = k;
                    hist.currentSums[n9] = hist.currentSums[n9] - (long)value;
                    if (!becomeEmpty) continue;
                    int n10 = k;
                    hist.currentNumberOfDifferentValues[n10] = hist.currentNumberOfDifferentValues[n10] - 1;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                    hist.currentSums[0] = hist.currentSums[0] - (long)value;
                    if (becomeEmpty) {
                        hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                    }
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Integer.MAX_VALUE - values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Integer.MAX_VALUE");
            }
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray = this.histogram[k];
                        int n2 = v;
                        nArray[n2] = nArray[n2] + 1;
                        long[] lArray = this.sums[k];
                        int n3 = v;
                        lArray[n3] = lArray[n3] + (long)value;
                        if (wasEmpty) {
                            int[] nArray2 = this.numbersOfDifferentValues[k];
                            int n4 = v;
                            nArray2[n4] = nArray2[n4] + 1;
                        }
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n5 = k;
                            this.currentIRanks[n5] = this.currentIRanks[n5] + 1;
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] + (long)value;
                            if (wasEmpty) {
                                int n7 = k;
                                this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] + 1;
                            }
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n8 = k;
                        this.nextSharing.currentIRanks[n8] = this.nextSharing.currentIRanks[n8] + 1;
                        int n9 = k;
                        this.nextSharing.currentSums[n9] = this.nextSharing.currentSums[n9] + (long)value;
                        if (!wasEmpty) continue;
                        int n10 = k;
                        this.nextSharing.currentNumberOfDifferentValues[n10] = this.nextSharing.currentNumberOfDifferentValues[n10] + 1;
                    }
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                        currentSum1 += (long)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                    currentSum2 += (long)value;
                    if (!wasEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] + 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                for (int value : values) {
                    boolean wasEmpty = this.histogram0[value] == 0;
                    int n = value;
                    this.histogram0[n] = this.histogram0[n] + 1;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray = this.histogram[k];
                        int n11 = v;
                        nArray[n11] = nArray[n11] + 1;
                        long[] lArray = this.sums[k];
                        int n12 = v;
                        lArray[n12] = lArray[n12] + (long)value;
                        if (wasEmpty) {
                            int[] nArray3 = this.numbersOfDifferentValues[k];
                            int n13 = v;
                            nArray3[n13] = nArray3[n13] + 1;
                        }
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n14 = k;
                        this.currentIRanks[n14] = this.currentIRanks[n14] + 1;
                        int n15 = k;
                        this.currentSums[n15] = this.currentSums[n15] + (long)value;
                        if (!wasEmpty) continue;
                        int n16 = k;
                        this.currentNumberOfDifferentValues[n16] = this.currentNumberOfDifferentValues[n16] + 1;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1;
                        this.currentSums[0] = this.currentSums[0] + (long)value;
                        if (wasEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                    }
                    SummingIntHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n17 = k;
                            hist.currentIRanks[n17] = hist.currentIRanks[n17] + 1;
                            int n18 = k;
                            hist.currentSums[n18] = hist.currentSums[n18] + (long)value;
                            if (!wasEmpty) continue;
                            int n19 = k;
                            hist.currentNumberOfDifferentValues[n19] = hist.currentNumberOfDifferentValues[n19] + 1;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                            hist.currentSums[0] = hist.currentSums[0] + (long)value;
                            if (wasEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] + 1;
                            }
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                long currentSum1 = this.currentSums[0];
                long currentSum2 = this.nextSharing.currentSums[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1;
                    if (this.histogram0[n2] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean becomeEmpty = this.histogram0[value] == 0;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray2 = this.histogram[k];
                        int n3 = v;
                        nArray2[n3] = nArray2[n3] - 1;
                        long[] lArray = this.sums[k];
                        int n4 = v;
                        lArray[n4] = lArray[n4] - (long)value;
                        if (becomeEmpty) {
                            int[] nArray3 = this.numbersOfDifferentValues[k];
                            int n5 = v;
                            nArray3[n5] = nArray3[n5] - 1;
                        }
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n6 = k;
                            this.currentIRanks[n6] = this.currentIRanks[n6] - 1;
                            int n7 = k;
                            this.currentSums[n7] = this.currentSums[n7] - (long)value;
                            if (becomeEmpty) {
                                int n8 = k;
                                this.currentNumberOfDifferentValues[n8] = this.currentNumberOfDifferentValues[n8] - 1;
                            }
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n9 = k;
                        this.nextSharing.currentIRanks[n9] = this.nextSharing.currentIRanks[n9] - 1;
                        int n10 = k;
                        this.nextSharing.currentSums[n10] = this.nextSharing.currentSums[n10] - (long)value;
                        if (!becomeEmpty) continue;
                        int n11 = k;
                        this.nextSharing.currentNumberOfDifferentValues[n11] = this.nextSharing.currentNumberOfDifferentValues[n11] - 1;
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                        currentSum1 -= (long)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                    currentSum2 -= (long)value;
                    if (!becomeEmpty) continue;
                    this.nextSharing.currentNumberOfDifferentValues[0] = this.nextSharing.currentNumberOfDifferentValues[0] - 1;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.currentSums[0] = currentSum1;
                this.nextSharing.currentSums[0] = currentSum2;
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n12 = value = nArray[i];
                    this.histogram0[n12] = this.histogram0[n12] - 1;
                    if (this.histogram0[n12] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    boolean becomeEmpty = this.histogram0[value] == 0;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray4 = this.histogram[k];
                        int n13 = v;
                        nArray4[n13] = nArray4[n13] - 1;
                        long[] lArray = this.sums[k];
                        int n14 = v;
                        lArray[n14] = lArray[n14] - (long)value;
                        if (becomeEmpty) {
                            int[] nArray5 = this.numbersOfDifferentValues[k];
                            int n15 = v;
                            nArray5[n15] = nArray5[n15] - 1;
                        }
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n16 = k;
                        this.currentIRanks[n16] = this.currentIRanks[n16] - 1;
                        int n17 = k;
                        this.currentSums[n17] = this.currentSums[n17] - (long)value;
                        if (!becomeEmpty) continue;
                        int n18 = k;
                        this.currentNumberOfDifferentValues[n18] = this.currentNumberOfDifferentValues[n18] - 1;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1;
                        this.currentSums[0] = this.currentSums[0] - (long)value;
                        if (becomeEmpty) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                        }
                    }
                    SummingIntHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n19 = k;
                            hist.currentIRanks[n19] = hist.currentIRanks[n19] - 1;
                            int n20 = k;
                            hist.currentSums[n20] = hist.currentSums[n20] - (long)value;
                            if (!becomeEmpty) continue;
                            int n21 = k;
                            hist.currentNumberOfDifferentValues[n21] = hist.currentNumberOfDifferentValues[n21] - 1;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                            hist.currentSums[0] = hist.currentSums[0] - (long)value;
                            if (becomeEmpty) {
                                hist.currentNumberOfDifferentValues[0] = hist.currentNumberOfDifferentValues[0] - 1;
                            }
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public int currentNumberOfDifferentValues() {
            return this.currentNumberOfDifferentValues[0];
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public double currentSum() {
            return this.currentSums[0];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public SummingHistogram moveToIRank(long rank) {
            block34: {
                block35: {
                    block36: {
                        block33: {
                            if (this.total == 0) {
                                if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] != 0) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            if (!SummingIntHistogram.$assertionsDisabled && this.total <= 0) {
                                throw new AssertionError();
                            }
                            if (rank < 0L) {
                                rank = 0L;
                            } else if (rank > (long)this.total) {
                                rank = this.total;
                            }
                            if (rank != (long)this.total) break block33;
                            this.moveToRightmostRank();
                            break block34;
                        }
                        if (rank >= (long)this.currentIRanks[0]) break block35;
                        if (this.m <= 1) break block36;
                        k = 0;
                        while (k + 1 < this.m && rank < (long)this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SummingIntHistogram.$assertionsDisabled && rank >= (long)this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                                numberOfDifferentValues = this.numbersOfDifferentValues[k][this.currentIValue];
                                v2 = k;
                                this.currentNumberOfDifferentValues[v2] = this.currentNumberOfDifferentValues[v2] - numberOfDifferentValues;
                            } while (rank < (long)this.currentIRanks[k]);
                            if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] < 0) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            previousNumberOfDifferentValues = this.currentNumberOfDifferentValues[k] + numberOfDifferentValues;
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (long)b * (long)this.currentIValue);
                                this.currentNumberOfDifferentValues[k] = previousNumberOfDifferentValues - (k > 0 ? this.numbersOfDifferentValues[k][this.currentIValue] : (b > 0 ? 1 : 0));
                            } while (k > 0 && rank >= (long)this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (rank >= (long)this.currentIRanks[0]) break block34;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                        if (b == 0) continue;
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                    } while (rank < (long)this.currentIRanks[0]);
                    if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] < 0) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block34;
                }
                if (this.m > 1) {
                    if (rank >= (long)(this.currentIRanks[0] + this.histogram0[this.currentIValue])) {
                        k = 0;
                        while (k + 1 < this.m && rank >= (long)(this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]])) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (rank >= (long)(this.currentIRanks[k] + b)) {
                                v3 = k;
                                this.currentIRanks[v3] = this.currentIRanks[v3] + b;
                                v4 = k;
                                this.currentSums[v4] = this.currentSums[v4] + this.sums[k][this.currentIValue];
                                v5 = k;
                                this.currentNumberOfDifferentValues[v5] = this.currentNumberOfDifferentValues[v5] + this.numbersOfDifferentValues[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                                this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                            } while (k > 0 && rank < (long)(this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]));
                        }
                        if (!SummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (rank >= (long)(this.currentIRanks[0] + b)) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                        if (b != 0) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (long)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                frac = (double)(rank - (long)this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToRank(double rank) {
            block36: {
                block37: {
                    block38: {
                        block35: {
                            if (Double.isNaN(rank)) {
                                throw new IllegalArgumentException("Illegal rank argument (NaN)");
                            }
                            if (this.total == 0) {
                                if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] != 0) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            this.currentPreciseRank = NaN;
                            if (!SummingIntHistogram.$assertionsDisabled && this.total <= 0) {
                                throw new AssertionError();
                            }
                            if (rank < 0.0) {
                                r = 0;
                                rank = 0;
                            } else if (rank > (double)this.total) {
                                r = this.total;
                                rank = r;
                            } else {
                                r = (int)rank;
                            }
                            if (r != this.total) break block35;
                            this.moveToRightmostRank();
                            break block36;
                        }
                        if (r >= this.currentIRanks[0]) break block37;
                        if (this.m <= 1) break block38;
                        k = 0;
                        while (k + 1 < this.m && r < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!SummingIntHistogram.$assertionsDisabled && r >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                                sum = this.sums[k][this.currentIValue];
                                v1 = k;
                                this.currentSums[v1] = this.currentSums[v1] - sum;
                                numberOfDifferentValues = this.numbersOfDifferentValues[k][this.currentIValue];
                                v2 = k;
                                this.currentNumberOfDifferentValues[v2] = this.currentNumberOfDifferentValues[v2] - numberOfDifferentValues;
                            } while (r < this.currentIRanks[k]);
                            if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] < 0) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            previousSum = this.currentSums[k] + sum;
                            previousNumberOfDifferentValues = this.currentNumberOfDifferentValues[k] + numberOfDifferentValues;
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                                this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (long)b * (long)this.currentIValue);
                                this.currentNumberOfDifferentValues[k] = previousNumberOfDifferentValues - (k > 0 ? this.numbersOfDifferentValues[k][this.currentIValue] : (b > 0 ? 1 : 0));
                            } while (k > 0 && r >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!SummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (r >= this.currentIRanks[0]) break block36;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                        this.currentSums[0] = this.currentSums[0] - (long)b * (long)this.currentIValue;
                        if (b == 0) continue;
                        this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                    } while (r < this.currentIRanks[0]);
                    if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] < 0) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block36;
                }
                if (this.m > 1) {
                    if (r >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && r >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (r >= this.currentIRanks[k] + b) {
                                v3 = k;
                                this.currentIRanks[v3] = this.currentIRanks[v3] + b;
                                v4 = k;
                                this.currentSums[v4] = this.currentSums[v4] + this.sums[k][this.currentIValue];
                                v5 = k;
                                this.currentNumberOfDifferentValues[v5] = this.currentNumberOfDifferentValues[v5] + this.numbersOfDifferentValues[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            lastSum = this.currentSums[k];
                            lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!SummingIntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                                this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                            } while (k > 0 && r < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!SummingIntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (r >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                        if (b != 0) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!SummingIntHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public SummingHistogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] < this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int numberOfDifferentValues;
                        long sum;
                        int b;
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v < this.currentIValue);
                        do {
                            --this.currentIValue;
                            b = this.histogram[k][this.currentIValue];
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - b;
                            sum = this.sums[k][this.currentIValue];
                            int n2 = k;
                            this.currentSums[n2] = this.currentSums[n2] - sum;
                            numberOfDifferentValues = this.numbersOfDifferentValues[k][this.currentIValue];
                            int n3 = k;
                            this.currentNumberOfDifferentValues[n3] = this.currentNumberOfDifferentValues[n3] - numberOfDifferentValues;
                        } while (v < this.currentIValue);
                        assert (this.currentIRanks[k] >= 0) : "currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for value=" + value;
                        assert (this.currentIValue == v);
                        int previousValue = this.currentIValue + 1 << level;
                        assert (value < previousValue);
                        int previousRank = this.currentIRanks[k] + b;
                        long previousSum = this.currentSums[k] + sum;
                        int previousNumberOfDifferentValues = this.currentNumberOfDifferentValues[k] + numberOfDifferentValues;
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIValue = (previousValue >> level) - 1;
                            b = this.histogram[k][this.currentIValue];
                            this.currentIRanks[k] = previousRank - b;
                            this.currentSums[k] = previousSum - (k > 0 ? this.sums[k][this.currentIValue] : (long)b * (long)this.currentIValue);
                            this.currentNumberOfDifferentValues[k] = previousNumberOfDifferentValues - (k > 0 ? this.numbersOfDifferentValues[k][this.currentIValue] : (b > 0 ? 1 : 0));
                        } while (k > 0 && value >> level == this.currentIValue);
                        this.currentIValue <<= level;
                    }
                    assert (k == 0);
                    if (value == this.currentIValue) {
                        return this;
                    }
                    assert (value < this.currentIValue);
                }
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                    this.currentSums[0] = this.currentSums[0] - (long)b * (long)j;
                    if (b == 0) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] - 1;
                }
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] > this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v > this.currentIValue);
                        do {
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][this.currentIValue];
                            int n4 = k;
                            this.currentSums[n4] = this.currentSums[n4] + this.sums[k][this.currentIValue];
                            int n5 = k;
                            this.currentNumberOfDifferentValues[n5] = this.currentNumberOfDifferentValues[n5] + this.numbersOfDifferentValues[k][this.currentIValue];
                            ++this.currentIValue;
                        } while (v > this.currentIValue);
                        assert (this.currentIRanks[k] <= this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + "> total=" + this.total + " for value=" + value;
                        assert (this.currentIValue == v);
                        this.currentIValue <<= level;
                        assert (this.currentIValue <= value);
                        int lastRank = this.currentIRanks[k];
                        long lastSum = this.currentSums[k];
                        int lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIRanks[k] = lastRank;
                            this.currentSums[k] = lastSum;
                            this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                        } while (k > 0 && value >> level == this.currentIValue >> level);
                    }
                    assert (k == 0);
                }
                for (int j = this.currentIValue; j < value; ++j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    this.currentSums[0] = this.currentSums[0] + (long)b * (long)j;
                    if (b == 0) continue;
                    this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public SummingHistogram nextSharing() {
            if (this.shareCount == 1) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SummingHistogram share() {
            int[] nArray = this.histogram0;
            synchronized (this.histogram0) {
                SummingIntHistogram result = new SummingIntHistogram(this.histogram, this.sums, this.numbersOfDifferentValues, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                SummingIntHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert (count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                SummingIntHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "summing int histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1 ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            System.arraycopy(this.currentSums, 0, this.alternativeSums, 0, this.m);
            System.arraycopy(this.currentNumberOfDifferentValues, 0, this.alternativeNumberOfDifferentValues, 0, this.m);
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void restoreRanks() {
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
            long[] tempSums = this.currentSums;
            this.currentSums = this.alternativeSums;
            this.alternativeSums = tempSums;
            int[] tempNumberOfDifferentValues = this.currentNumberOfDifferentValues;
            this.currentNumberOfDifferentValues = this.alternativeNumberOfDifferentValues;
            this.alternativeNumberOfDifferentValues = tempNumberOfDifferentValues;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0 || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            if (this.currentNumberOfDifferentValues[0] < 0 || this.currentNumberOfDifferentValues[0] > Math.min(this.length, this.total)) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentNumberOfDifferentValues = " + this.currentNumberOfDifferentValues[0] + " is out of range 0..min(" + this.length + "," + this.total + ")"));
            }
            for (int k = 0; k < this.m; ++k) {
                int nDifferentValues = 0;
                if (k == 0) {
                    nDifferentValues = this.simpleCurrentNDV();
                } else {
                    for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                        nDifferentValues += this.histogram0[j] == 0 ? 0 : 1;
                    }
                }
                if (this.currentNumberOfDifferentValues[k] != nDifferentValues) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentNumberOfDifferentValues[" + k + "] = " + this.currentNumberOfDifferentValues[k] + " != " + nDifferentValues + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                int s = SummingIntHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]);
                if (this.currentIRanks[k] != s) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
                long sum = 0L;
                for (int j = 0; j < (this.currentIValue & this.highBitMasks[k]); ++j) {
                    sum += (long)this.histogram0[j] * (long)j;
                }
                if (this.currentSums[k] != sum) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentSums[" + k + "] = " + this.currentSums[k] + " != " + sum + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(SummingIntHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + SummingIntHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + SummingIntHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + SummingIntHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            block35: {
                block34: {
                    int v;
                    int k;
                    assert (this.total > 0);
                    assert (this.currentIRanks[0] <= this.total);
                    if (this.currentIRanks[0] >= this.total) break block34;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.total > this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            int b = this.histogram[k][this.currentIValue];
                            while (this.total > this.currentIRanks[k] + b) {
                                int n = k;
                                this.currentIRanks[n] = this.currentIRanks[n] + b;
                                int n2 = k;
                                this.currentSums[n2] = this.currentSums[n2] + this.sums[k][this.currentIValue];
                                int n3 = k;
                                this.currentNumberOfDifferentValues[n3] = this.currentNumberOfDifferentValues[n3] + this.numbersOfDifferentValues[k][this.currentIValue];
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            assert (this.currentIRanks[k] < this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total;
                            this.currentIValue <<= level;
                            int lastRank = this.currentIRanks[k];
                            long lastSum = this.currentSums[k];
                            int lastNumberOfDifferentValues = this.currentNumberOfDifferentValues[k];
                            do {
                                level = this.bitLevels[--k];
                                assert (k > 0 || level == 0);
                                this.currentIRanks[k] = lastRank;
                                this.currentSums[k] = lastSum;
                                this.currentNumberOfDifferentValues[k] = lastNumberOfDifferentValues;
                            } while (k > 0 && this.total <= this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        assert (k == 0);
                    }
                    assert (this.currentIRanks[0] < this.total);
                    do {
                        int b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        this.currentSums[0] = this.currentSums[0] + (long)b * (long)this.currentIValue;
                        if (b != 0) {
                            this.currentNumberOfDifferentValues[0] = this.currentNumberOfDifferentValues[0] + 1;
                        }
                        ++this.currentIValue;
                    } while (this.currentIRanks[0] < this.total);
                    assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                    assert (this.histogram0[this.currentIValue - 1] > 0);
                    if (this.m <= 1) break block35;
                    for (k = 1; k < this.m && (v = this.currentIValue - 1 >> this.bitLevels[k]) < this.currentIValue >> this.bitLevels[k]; ++k) {
                        int n = k;
                        this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][v];
                        int n4 = k;
                        this.currentSums[n4] = this.currentSums[n4] + this.sums[k][v];
                        int n5 = k;
                        this.currentNumberOfDifferentValues[n5] = this.currentNumberOfDifferentValues[n5] + this.numbersOfDifferentValues[k][v];
                    }
                    break block35;
                }
                if (this.histogram0[this.currentIValue - 1] == 0) {
                    int k;
                    assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0);
                    --this.currentIValue;
                    int previousValue = this.currentIValue + 1;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]] == 0) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0);
                            while (this.histogram[k][this.currentIValue - 1] == 0) {
                                --this.currentIValue;
                                assert (this.currentIValue > 0);
                            }
                            int v = this.currentIValue - 1;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0);
                            assert (this.histogram[k][v] > 0);
                            this.currentIValue <<= level;
                            --k;
                        }
                    }
                    assert (this.currentIValue > 0);
                    assert (this.histogram0[this.currentIValue] == 0);
                    while (this.histogram0[this.currentIValue - 1] == 0) {
                        --this.currentIValue;
                        assert (this.currentIValue > 0);
                    }
                    if (this.m > 1) {
                        int v;
                        for (k = 1; k < this.m && (v = this.currentIValue >> this.bitLevels[k]) < previousValue >> this.bitLevels[k]; ++k) {
                            int b = this.histogram[k][v];
                            if (b <= 0) continue;
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - this.histogram[k][v];
                            int n6 = k;
                            this.currentSums[n6] = this.currentSums[n6] - this.sums[k][v];
                            int n7 = k;
                            this.currentNumberOfDifferentValues[n7] = this.currentNumberOfDifferentValues[n7] - this.numbersOfDifferentValues[k][v];
                        }
                    }
                }
            }
        }

        private int simpleCurrentNDV() {
            int result = 0;
            for (int j = 0; j < this.currentIValue; ++j) {
                if (this.histogram0[j] == 0) continue;
                ++result;
            }
            return result;
        }

        private static int[][] newMultilevelHistogram(int[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            int[][] result = new int[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static int sumOfAndCheck(int[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            int result = 0;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Integer.MAX_VALUE");
            }
            return result;
        }
    }

    public static final class CountOfValues {
        double count = Double.NaN;
        boolean leftBound = false;
        boolean rightBound = false;

        public boolean isInitialized() {
            return !Double.isNaN(this.count);
        }

        public boolean isLeftBound() {
            this.checkInitialized();
            return this.leftBound;
        }

        public boolean isRightBound() {
            this.checkInitialized();
            return this.rightBound;
        }

        public double count() {
            this.checkInitialized();
            return this.count;
        }

        public String toString() {
            if (Double.isNaN(this.count)) {
                return "not initialized CountOfValues";
            }
            return this.count + " (" + (this.leftBound ? "" : "not ") + " left bound, " + (this.rightBound ? "" : "not ") + " right bound)";
        }

        private void checkInitialized() {
            if (Double.isNaN(this.count)) {
                throw new IllegalStateException("This instance is not initialized by integralBetweenValues or preciseIntegralBetweenValues method yet");
            }
        }
    }
}

