/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contexts;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.algart.contexts.Context;
import net.algart.contexts.UnsupportedContextException;

public abstract class AbstractContext
implements Context {
    private static final Logger LOGGER = Logger.getLogger(AbstractContext.class.getName());
    protected final boolean useServiceLoader;
    private static final ReentrantLock lock = new ReentrantLock();
    private static Set<Context> ALL_CONTEXTS = null;
    private static Map<Class<? extends Context>, Context> ACTIVE_CONTEXTS = null;

    protected AbstractContext(boolean useServiceLoader) {
        this.useServiceLoader = useServiceLoader;
    }

    @Override
    public <T extends Context> T as(Class<T> contextClass) {
        T result;
        Objects.requireNonNull(contextClass, "Null contextClass argument");
        if (!Context.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException("The contextClass argument is not a context class (" + contextClass.getName() + ")");
        }
        if (contextClass.isAssignableFrom(this.getClass())) {
            return (T)((Context)contextClass.cast(this));
        }
        if (this.useServiceLoader && (result = AbstractContext.getContextViaServiceLoader(contextClass)) != null) {
            return result;
        }
        throw new UnsupportedContextException(contextClass);
    }

    @Override
    public boolean is(Class<? extends Context> contextClass) {
        if (contextClass == null || !Context.class.isAssignableFrom(contextClass)) {
            return false;
        }
        if (contextClass.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (this.useServiceLoader) {
            return AbstractContext.getContextViaServiceLoader(contextClass) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Context> T getContextViaServiceLoader(Class<T> contextClass) {
        lock.lock();
        try {
            Context result;
            if (ALL_CONTEXTS == null) {
                ALL_CONTEXTS = new HashSet<Context>();
                ACTIVE_CONTEXTS = new HashMap<Class<? extends Context>, Context>();
                try {
                    Class<?> loaderClass2;
                    Iterator iterator = null;
                    try {
                        loaderClass2 = Class.forName("java.util.ServiceLoader");
                        Method loadMethod = loaderClass2.getMethod("load", Class.class);
                        Object loader = loadMethod.invoke(null, Context.class);
                        Method iteratorMethod = loaderClass2.getMethod("iterator", new Class[0]);
                        iterator = (Iterator)iteratorMethod.invoke(loader, new Object[0]);
                    }
                    catch (Throwable loaderClass2) {
                        // empty catch block
                    }
                    if (iterator == null) {
                        try {
                            loaderClass2 = Class.forName("sun.misc.Service");
                            Method providersMethod = loaderClass2.getMethod("providers", Class.class);
                            iterator = (Iterator)providersMethod.invoke(null, Context.class);
                        }
                        catch (Throwable loaderClass3) {
                            // empty catch block
                        }
                    }
                    Objects.requireNonNull(iterator, "Cannot find service provider feature. Maybe, current JVM version is too early: " + System.getProperty("java.version") + " (JVM 1.4+ is required)");
                    while (iterator.hasNext()) {
                        try {
                            Context context = (Context)iterator.next();
                            ALL_CONTEXTS.add(context);
                        }
                        catch (Throwable ex) {
                            LOGGER.log(Level.SEVERE, "Cannot load a context by the service loader", ex);
                        }
                    }
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.SEVERE, "Error while loading contexts by the service loader", ex);
                }
            }
            if (ACTIVE_CONTEXTS.containsKey(contextClass)) {
                result = (Context)contextClass.cast(ACTIVE_CONTEXTS.get(contextClass));
            } else {
                result = null;
                for (Context c : ALL_CONTEXTS) {
                    if (!contextClass.isInstance(c)) continue;
                    result = (Context)contextClass.cast(c);
                    break;
                }
                ACTIVE_CONTEXTS.put(contextClass, result);
            }
            Context context = result;
            return (T)context;
        }
        finally {
            lock.unlock();
        }
    }
}

