/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contexts;

import java.util.Objects;
import net.algart.contexts.InterruptionContext;
import net.algart.contexts.InterruptionException;

public abstract class InterruptibleAction<T> {
    private final InterruptionContext context;

    protected InterruptibleAction(InterruptionContext context) {
        Objects.requireNonNull(context, "Null context argument");
        this.context = context;
    }

    public T doInterruptibly() throws InterruptionException {
        Thread currentThread = Thread.currentThread();
        InterruptionContext.Listener listener = event -> currentThread.interrupt();
        this.context.addInterruptionListener(listener);
        try {
            T t = this.run();
            return t;
        }
        catch (InterruptedException ex) {
            throw new InterruptionException(ex);
        }
        finally {
            this.context.removeInterruptionListener(listener);
        }
    }

    public abstract T run() throws InterruptedException;
}

