/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contexts;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.contexts.AbstractContext;
import net.algart.contexts.ArrayMemoryContext;
import net.algart.contexts.Context;
import net.algart.contexts.UnsupportedContextException;

public class SubContext
extends AbstractContext
implements Context {
    private final Context superContext;
    private final HashSet<Class<?>> allowedClassesSet;
    private final MemoryModel memoryModel;

    protected SubContext(Context superContext) {
        super(false);
        Objects.requireNonNull(superContext, "Null superContext argument");
        this.superContext = superContext;
        this.allowedClassesSet = null;
        this.memoryModel = null;
    }

    public SubContext(Context superContext, Class<?> ... allowedClasses) {
        super(false);
        Objects.requireNonNull(superContext, "Null superContext argument");
        for (int k = 0; k < allowedClasses.length; ++k) {
            Class<?> c = allowedClasses[k];
            Objects.requireNonNull(c, "Null allowedClasses[" + k + "] argument");
            if (Context.class.isAssignableFrom(c)) continue;
            throw new IllegalArgumentException("allowedClasses[" + k + "] does not inherit Context (" + String.valueOf(c) + ")");
        }
        this.superContext = superContext;
        this.allowedClassesSet = new HashSet(Arrays.asList(allowedClasses));
        this.memoryModel = null;
    }

    public SubContext(Context superContext, MemoryModel memoryModel) {
        super(false);
        Objects.requireNonNull(superContext, "Null superContext argument");
        Objects.requireNonNull(memoryModel, "Null memoryModel argument");
        this.superContext = superContext;
        this.allowedClassesSet = null;
        this.memoryModel = memoryModel;
    }

    @Override
    public final <T extends Context> T as(Class<T> contextClass) {
        Objects.requireNonNull(contextClass, "Null contextClass argument");
        if (!Context.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException("The contextClass argument is not a context class (" + contextClass.getName() + ")");
        }
        if (contextClass.isAssignableFrom(this.getClass())) {
            return (T)((Context)contextClass.cast(this));
        }
        if (this.allowedClassesSet != null && !this.allowedClassesSet.contains(contextClass)) {
            throw new UnsupportedContextException("Unallowed context class: " + contextClass.getName());
        }
        if (contextClass == ArrayMemoryContext.class && this.memoryModel != null) {
            return (T)((Context)contextClass.cast(new MemorySubContext()));
        }
        return this.superContext.as(contextClass);
    }

    @Override
    public final boolean is(Class<? extends Context> contextClass) {
        if (contextClass == null || !Context.class.isAssignableFrom(contextClass)) {
            return false;
        }
        if (contextClass.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (this.allowedClassesSet != null && !this.allowedClassesSet.contains(contextClass)) {
            return false;
        }
        if (contextClass == ArrayMemoryContext.class && this.memoryModel != null) {
            return true;
        }
        return this.superContext.is(contextClass);
    }

    private class MemorySubContext
    extends AbstractContext
    implements ArrayMemoryContext {
        private MemorySubContext() {
            super(false);
        }

        @Override
        public MemoryModel getMemoryModel() {
            return SubContext.this.memoryModel;
        }

        @Override
        public MemoryModel getMemoryModel(Class<?> elementType) {
            return SubContext.this.memoryModel.isElementTypeSupported(elementType) ? SubContext.this.memoryModel : SimpleMemoryModel.getInstance();
        }

        @Override
        public MemoryModel getMemoryModel(String settings) {
            Objects.requireNonNull(settings, "Null settings argument");
            return SubContext.this.memoryModel;
        }
    }
}

