/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

import net.algart.contours.Contours;
import net.algart.math.IRectangularArea;

public final class ContourHeader {
    public static final int RESERVED = 0x7F000000;
    static final int MAX_ALLOWED_HEADER_LENGTH = 512;
    static final int HEADER_LENGTH_WITHOUT_FRAME_ID = 8;
    static final int HEADER_LENGTH_WITH_FRAME_ID = 10;
    static final int MIN_HEADER_LENGTH = 8;
    static final int CONTAINING_RECTANGLE_OFFSET = 2;
    static final int FLAGS_OFFSET = 6;
    static final int LABEL_OFFSET = 7;
    static final int FRAME_ID_OFFSET = 9;
    static final int HEADER_LENGTH_MASK = 255;
    static final int MAGIC_WORD_MASK = -256;
    static final int MAGIC_WORD = 2135109888;
    static final int MAGIC_WORD_1 = 2135109896;
    static final int MAGIC_WORD_2 = 2135109898;
    static final int STANDARD_RESERVED_INDICATOR = 0x7FFF0000;
    static final int INTERNAL_FLAG = 1;
    static final int TOUCHES_MIN_X_MATRIX_BOUNDARY_FLAG = 16;
    static final int TOUCHES_MAX_X_MATRIX_BOUNDARY_FLAG = 32;
    static final int TOUCHES_MIN_Y_MATRIX_BOUNDARY_FLAG = 64;
    static final int TOUCHES_MAX_Y_MATRIX_BOUNDARY_FLAG = 128;
    static final int HAS_FRAME_ID = 256;
    private int objectLabel = 0;
    private boolean hasContainingRectangle = false;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private Integer frameId;
    private boolean internalContour;
    private boolean contourTouchingMinXMatrixBoundary;
    private boolean contourTouchingMaxXMatrixBoundary;
    private boolean contourTouchingMinYMatrixBoundary;
    private boolean contourTouchingMaxYMatrixBoundary;

    public ContourHeader() {
        this.removeContainingRectangle();
        this.frameId = null;
        this.internalContour = false;
        this.contourTouchingMinXMatrixBoundary = false;
        this.contourTouchingMaxXMatrixBoundary = false;
        this.contourTouchingMinYMatrixBoundary = false;
        this.contourTouchingMaxYMatrixBoundary = false;
    }

    public ContourHeader(int objectLabel) {
        this.removeContainingRectangle();
        this.frameId = null;
        this.internalContour = false;
        this.contourTouchingMinXMatrixBoundary = false;
        this.contourTouchingMaxXMatrixBoundary = false;
        this.contourTouchingMinYMatrixBoundary = false;
        this.contourTouchingMaxYMatrixBoundary = false;
        this.objectLabel = objectLabel;
    }

    public ContourHeader(int objectLabel, boolean internalContour) {
        this.removeContainingRectangle();
        this.frameId = null;
        this.internalContour = false;
        this.contourTouchingMinXMatrixBoundary = false;
        this.contourTouchingMaxXMatrixBoundary = false;
        this.contourTouchingMinYMatrixBoundary = false;
        this.contourTouchingMaxYMatrixBoundary = false;
        this.objectLabel = objectLabel;
        this.internalContour = internalContour;
    }

    public ContourHeader(int objectLabel, boolean internalContour, int frameId) {
        this.removeContainingRectangle();
        this.frameId = null;
        this.internalContour = false;
        this.contourTouchingMinXMatrixBoundary = false;
        this.contourTouchingMaxXMatrixBoundary = false;
        this.contourTouchingMinYMatrixBoundary = false;
        this.contourTouchingMaxYMatrixBoundary = false;
        this.objectLabel = objectLabel;
        this.internalContour = internalContour;
        this.frameId = frameId;
    }

    public int getObjectLabel() {
        return this.objectLabel;
    }

    public ContourHeader setObjectLabel(int objectLabel) {
        this.objectLabel = objectLabel;
        return this;
    }

    public Integer getFrameIdOrNull() {
        return this.frameId;
    }

    public boolean hasFrameId() {
        return this.frameId != null;
    }

    public int getFrameId() {
        if (this.frameId == null) {
            throw new IllegalStateException("No frame ID");
        }
        return this.frameId;
    }

    public ContourHeader setFrameId(int frameId) {
        this.frameId = frameId;
        return this;
    }

    public ContourHeader removeFrameId() {
        this.frameId = null;
        return this;
    }

    public boolean isInternalContour() {
        return this.internalContour;
    }

    public ContourHeader setInternalContour(boolean internalContour) {
        this.internalContour = internalContour;
        return this;
    }

    public boolean isContourTouchingMinXMatrixBoundary() {
        return this.contourTouchingMinXMatrixBoundary;
    }

    public ContourHeader setContourTouchingMinXMatrixBoundary(boolean contourTouchingMinXMatrixBoundary) {
        this.contourTouchingMinXMatrixBoundary = contourTouchingMinXMatrixBoundary;
        return this;
    }

    public boolean isContourTouchingMaxXMatrixBoundary() {
        return this.contourTouchingMaxXMatrixBoundary;
    }

    public ContourHeader setContourTouchingMaxXMatrixBoundary(boolean contourTouchingMaxXMatrixBoundary) {
        this.contourTouchingMaxXMatrixBoundary = contourTouchingMaxXMatrixBoundary;
        return this;
    }

    public boolean isContourTouchingMinYMatrixBoundary() {
        return this.contourTouchingMinYMatrixBoundary;
    }

    public ContourHeader setContourTouchingMinYMatrixBoundary(boolean contourTouchingMinYMatrixBoundary) {
        this.contourTouchingMinYMatrixBoundary = contourTouchingMinYMatrixBoundary;
        return this;
    }

    public boolean isContourTouchingMaxYMatrixBoundary() {
        return this.contourTouchingMaxYMatrixBoundary;
    }

    public ContourHeader setContourTouchingMaxYMatrixBoundary(boolean contourTouchingMaxYMatrixBoundary) {
        this.contourTouchingMaxYMatrixBoundary = contourTouchingMaxYMatrixBoundary;
        return this;
    }

    public boolean hasContainingRectangle() {
        return this.hasContainingRectangle;
    }

    public int minX() {
        this.checkContainingRectangle();
        return this.minX;
    }

    public int maxX() {
        this.checkContainingRectangle();
        return this.maxX;
    }

    public int minY() {
        this.checkContainingRectangle();
        return this.minY;
    }

    public int maxY() {
        this.checkContainingRectangle();
        return this.maxY;
    }

    public IRectangularArea containingRectangle() {
        this.checkContainingRectangle();
        return IRectangularArea.of(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void removeContainingRectangle() {
        this.hasContainingRectangle = false;
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
    }

    public ContourHeader clear() {
        this.objectLabel = 0;
        this.removeContainingRectangle();
        this.frameId = null;
        this.internalContour = false;
        this.clearContourTouchingMatrixBoundary();
        return this;
    }

    public ContourHeader clearContourTouchingMatrixBoundary() {
        this.contourTouchingMinXMatrixBoundary = false;
        this.contourTouchingMaxXMatrixBoundary = false;
        this.contourTouchingMinYMatrixBoundary = false;
        this.contourTouchingMaxYMatrixBoundary = false;
        return this;
    }

    public String toString() {
        return "contour header: label " + this.objectLabel + (String)(this.hasFrameId() ? ", frame " + this.frameId : "") + (this.internalContour ? ", internal" : ", external") + (String)(this.hasContainingRectangle ? ", containing rectangle " + this.minX + ".." + this.maxX + "x" + this.minY + ".." + this.maxY : "");
    }

    int headerLength() {
        return this.frameId == null ? 8 : 10;
    }

    void read(Contours contours, int headerOffset) {
        this.objectLabel = contours.points[headerOffset + 7];
        this.minX = contours.minX(headerOffset);
        this.maxX = contours.maxX(headerOffset);
        this.minY = contours.minY(headerOffset);
        this.maxY = contours.maxY(headerOffset);
        if (this.minX > this.maxX || this.minY > this.maxY) {
            throw new IllegalArgumentException("Illegal header in the contour array at position " + (headerOffset + 2) + ": negative sizes of containing rectangle " + this.minX + ".." + this.maxX + "x" + this.minY + ".." + this.maxY);
        }
        if (this.minX < -1073741824 || this.maxX > 0x3FFFFFFF || this.minY < -1073741824 || this.maxY > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Illegal header in the contour array at position " + (headerOffset + 2) + ": containing rectangle " + this.minX + ".." + this.maxX + "x" + this.minY + ".." + this.maxY + " is outside allowed range-1073741824..1073741823");
        }
        this.hasContainingRectangle = true;
        int flags = contours.points[headerOffset + 6];
        this.setFlags(flags);
        this.frameId = (flags & 0x100) != 0 ? Integer.valueOf(contours.points[headerOffset + 9]) : null;
    }

    int write(Contours contours, int headerOffset, int contourNumberOfPoints) {
        int headerLength = this.headerLength();
        int offset = headerOffset;
        contours.points[offset++] = 0x7F433100 | headerLength;
        contours.points[offset++] = 2 * contourNumberOfPoints + headerLength;
        contours.points[offset++] = this.minX;
        contours.points[offset++] = this.maxX;
        contours.points[offset++] = this.minY;
        contours.points[offset++] = this.maxY;
        contours.points[offset++] = 0x7FFF0000 | this.getFlags();
        contours.points[offset++] = this.objectLabel;
        if (this.frameId != null) {
            contours.points[offset++] = 0x7FFF0000;
            contours.points[offset++] = this.frameId;
        }
        assert (offset - headerOffset == headerLength);
        return offset;
    }

    void appendToEnd(Contours contours, int contourNumberOfPoints) {
        int position = contours.pointsLength;
        long newPointsLength = (long)position + (long)this.headerLength();
        contours.ensureCapacityForPoints(newPointsLength);
        contours.pointsLength = (int)newPointsLength;
        this.write(contours, position, contourNumberOfPoints);
    }

    void appendToEndForAllocatingSpace(Contours contours) {
        this.appendToEnd(contours, 0);
    }

    void transformContainingRectangle(double scaleX, double scaleY, double shiftX, double shiftY) {
        if (this.hasContainingRectangle) {
            long x1 = Math.round(scaleX * (double)this.minX + shiftX);
            long y1 = Math.round(scaleY * (double)this.minY + shiftY);
            Contours.checkPoint(x1, y1);
            long x2 = Math.round(scaleX * (double)this.maxX + shiftX);
            long y2 = Math.round(scaleY * (double)this.maxY + shiftY);
            Contours.checkPoint(x2, y2);
            this.minX = (int)Math.min(x1, x2);
            this.minY = (int)Math.min(y1, y2);
            this.maxX = (int)Math.max(x1, x2);
            this.maxY = (int)Math.max(y1, y2);
        }
    }

    int getFlags() {
        return this.getFlagsWithoutContourTouching() | (this.contourTouchingMinXMatrixBoundary ? 16 : 0) | (this.contourTouchingMaxXMatrixBoundary ? 32 : 0) | (this.contourTouchingMinYMatrixBoundary ? 64 : 0) | (this.contourTouchingMaxYMatrixBoundary ? 128 : 0);
    }

    int getFlagsWithoutContourTouching() {
        return (this.internalContour ? 1 : 0) | (this.frameId != null ? 256 : 0);
    }

    void setFlags(int flags) {
        this.internalContour = (flags & 1) != 0;
        this.contourTouchingMinXMatrixBoundary = (flags & 0x10) != 0;
        this.contourTouchingMaxXMatrixBoundary = (flags & 0x20) != 0;
        this.contourTouchingMinYMatrixBoundary = (flags & 0x40) != 0;
        this.contourTouchingMaxYMatrixBoundary = (flags & 0x80) != 0;
    }

    private void checkContainingRectangle() {
        if (!this.hasContainingRectangle) {
            throw new IllegalStateException("This header does not contain information about containing rectangle");
        }
    }
}

