/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executable.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDocCorrector {
    private static final Pattern PATTERN = Pattern.compile("\\<\\!--\\s*algart(\\w+)\\s*--\\>(.*?)\\<\\!--\\s*\\/algart(\\w+)\\s*--\\>", 32);
    private static final String REPLACEMENT = "<!--(removed by " + JavaDocCorrector.class.getSimpleName() + ")-->";
    private boolean verbose = false;
    private int processedFilesCount = 0;

    public static void main(String[] args) throws IOException {
        JavaDocCorrector corrector = new JavaDocCorrector();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-verbose")) {
            corrector.verbose = true;
            ++startArgIndex;
        }
        if (args.length == startArgIndex) {
            System.out.println("Usage: " + JavaDocCorrector.class.getName() + " [-verbose] JavaDoc-directory");
            System.out.println("This utility will remove consequent fragment (besides the 1st");
            System.out.println("<!--algartXXXX-->...</!--algartXXXX-->");
            System.out.println("where XXXX is any character combination.");
            return;
        }
        File dir = new File(args[0]);
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("\"" + String.valueOf(dir) + "\" is not an existing directory");
        }
        corrector.processSubdirectory(dir);
        System.out.println(corrector.processedFilesCount + " files corrected in " + dir.getAbsolutePath());
    }

    private void processSubdirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        assert (files != null);
        for (File f : files) {
            String name;
            if (f.isDirectory()) {
                this.processSubdirectory(f);
                continue;
            }
            if (!f.isFile() || !(name = f.getName()).endsWith(".html") && !name.endsWith(".htm")) continue;
            this.processFile(f);
        }
    }

    private void processFile(File f) throws IOException {
        String data = JavaDocCorrector.readUTF8(f);
        StringBuilder sb = new StringBuilder();
        HashSet<String> alreadyAppeared = new HashSet<String>();
        Matcher m = PATTERN.matcher(data);
        int p = 0;
        while (m.find()) {
            int q = m.start();
            sb.append(data.substring(p, q));
            p = m.end();
            String blockName = m.group(1);
            if (!alreadyAppeared.contains(blockName)) {
                alreadyAppeared.add(blockName);
                sb.append(data.substring(q, p));
                continue;
            }
            sb.append(REPLACEMENT);
        }
        sb.append(data.substring(p));
        String result = sb.toString();
        if (!result.equals(data)) {
            if (this.verbose) {
                System.out.println("Processing " + String.valueOf(f));
            }
            JavaDocCorrector.writeUTF8(f, result);
            ++this.processedFilesCount;
        } else if (this.verbose) {
            System.out.println("Skipping " + String.valueOf(f));
        }
    }

    private static String readUTF8(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
            int len;
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[65536];
            while ((len = reader.read(buf)) >= 0) {
                sb.append(buf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static void writeUTF8(File file, String text) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        try {
            writer.write(text);
        }
        catch (IOException e) {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        ((Writer)writer).close();
    }
}

