/*
 * Decompiled with CFR 0.152.
 */
package net.algart.io.awt;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.ColorChannelOrder;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;

public abstract class ImageToMatrix {
    private boolean enableAlpha = true;

    public static List<Matrix<UpdatablePArray>> toChannels(BufferedImage bufferedImage) {
        return Matrices.separate(ImageToMatrix.toInterleaved(bufferedImage));
    }

    public static Matrix<UpdatablePArray> toInterleaved(BufferedImage bufferedImage) {
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        return new ToInterleavedRGB().toMatrix(bufferedImage);
    }

    public static Matrix<UpdatablePArray> toInterleavedBGR(BufferedImage bufferedImage) {
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        return new ToInterleavedBGR().toMatrix(bufferedImage);
    }

    public static int defaultNumberOfChannels(BufferedImage bufferedImage) {
        boolean gray;
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        ColorModel cm = bufferedImage.getColorModel();
        boolean bl = gray = cm.getNumComponents() == 1;
        return cm.hasAlpha() ? 4 : (gray ? 1 : 3);
    }

    public static Class<?> defaultElementType(BufferedImage bufferedImage) {
        Class<?> result = ImageToMatrix.resultElementTypeOrNullForUnsupported(bufferedImage);
        return result == null ? Byte.TYPE : result;
    }

    public boolean isEnableAlpha() {
        return this.enableAlpha;
    }

    public ImageToMatrix setEnableAlpha(boolean enableAlpha) {
        this.enableAlpha = enableAlpha;
        return this;
    }

    public Matrix<UpdatablePArray> toMatrix(BufferedImage bufferedImage) {
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        int dimX = bufferedImage.getWidth();
        int dimY = bufferedImage.getHeight();
        int bandCount = this.resultNumberOfChannels(bufferedImage);
        long[] dimensions = this.resultMatrixDimensions(dimX, dimY, bandCount);
        Class<?> elementType = this.resultElementType(bufferedImage);
        long size = Arrays.longMul(dimensions);
        if (size > Integer.MAX_VALUE || size == Long.MIN_VALUE) {
            throw new AssertionError((Object)"Illegal getResultMatrixDimensions implementation: too large results");
        }
        Object resultData = Array.newInstance(elementType, (int)size);
        this.toJavaArray(resultData, bufferedImage);
        return SimpleMemoryModel.asMatrix(resultData, dimensions);
    }

    public final int resultNumberOfChannels(BufferedImage bufferedImage) {
        int result = ImageToMatrix.defaultNumberOfChannels(bufferedImage);
        return !this.enableAlpha && result > 3 ? 3 : result;
    }

    public abstract ColorChannelOrder channelOrder();

    public abstract Class<?> resultElementType(BufferedImage var1);

    public final long[] resultMatrixDimensions(BufferedImage bufferedImage) {
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        return this.resultMatrixDimensions(bufferedImage.getWidth(), bufferedImage.getHeight(), this.resultNumberOfChannels(bufferedImage));
    }

    public abstract long[] resultMatrixDimensions(int var1, int var2, int var3);

    public static Class<?> tryToDetectElementType(SampleModel sampleModel) {
        return switch (sampleModel.getDataType()) {
            case 0 -> Byte.TYPE;
            case 1, 2 -> Short.TYPE;
            case 3 -> Integer.TYPE;
            case 4 -> Float.TYPE;
            case 5 -> Double.TYPE;
            default -> null;
        };
    }

    protected abstract void toJavaArray(Object var1, BufferedImage var2);

    private static Class<?> resultElementTypeOrNullForUnsupported(BufferedImage bufferedImage) {
        int numberOfChannels = ImageToMatrix.defaultNumberOfChannels(bufferedImage);
        ColorModel colorModel = bufferedImage.getColorModel();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int colorComponentsCount = colorModel.getNumComponents();
        if (numberOfChannels > colorComponentsCount || colorComponentsCount != sampleModel.getNumBands()) {
            return null;
        }
        if (!(colorModel instanceof ComponentColorModel) || !(sampleModel instanceof ComponentSampleModel)) {
            return null;
        }
        return switch (sampleModel.getDataType()) {
            case 0, 1, 3, 4, 5 -> ImageToMatrix.tryToDetectElementType(sampleModel);
            default -> null;
        };
    }

    public static class ToInterleavedRGB
    extends ImageToMatrix {
        public static final boolean DEFAULT_READING_VIA_COLOR_MODEL = false;
        public static final boolean DEFAULT_READING_VIA_GRAPHICS = false;
        private final boolean bgrOrder;
        private boolean readingViaColorModel = false;
        private boolean readingViaGraphics = false;

        public ToInterleavedRGB() {
            this(false);
        }

        ToInterleavedRGB(boolean bgrOrder) {
            this.bgrOrder = bgrOrder;
        }

        public boolean isReadingViaColorModel() {
            return this.readingViaColorModel;
        }

        public ToInterleavedRGB setReadingViaColorModel(boolean readingViaColorModel) {
            this.readingViaColorModel = readingViaColorModel;
            return this;
        }

        public boolean isReadingViaGraphics() {
            return this.readingViaGraphics;
        }

        public ToInterleavedRGB setReadingViaGraphics(boolean readingViaGraphics) {
            this.readingViaGraphics = readingViaGraphics;
            return this;
        }

        @Override
        public ColorChannelOrder channelOrder() {
            return this.bgrOrder ? ColorChannelOrder.BGR : ColorChannelOrder.RGB;
        }

        @Override
        public Class<?> resultElementType(BufferedImage bufferedImage) {
            Objects.requireNonNull(bufferedImage, "Null bufferedImage");
            if (this.readingViaColorModel || this.readingViaGraphics) {
                return Byte.TYPE;
            }
            return ToInterleavedRGB.defaultElementType(bufferedImage);
        }

        @Override
        public long[] resultMatrixDimensions(int width, int height, int bandCount) {
            return new long[]{bandCount, width, height};
        }

        public String toString() {
            return "ToInterleaved" + (this.bgrOrder ? "BGR" : "RGB") + (this.readingViaColorModel ? " (reading via color model)" : (this.readingViaGraphics ? " (reading via graphics)" : ""));
        }

        @Override
        protected void toJavaArray(Object resultJavaArray, BufferedImage bufferedImage) {
            boolean invertBandOrder;
            Objects.requireNonNull(resultJavaArray, "Null resultJavaArray");
            Objects.requireNonNull(bufferedImage, "Null bufferedImage");
            if (!resultJavaArray.getClass().isArray()) {
                throw new IllegalArgumentException("resultJavaArray is not an array: " + String.valueOf(resultJavaArray.getClass()));
            }
            int dimX = bufferedImage.getWidth();
            int dimY = bufferedImage.getHeight();
            int bandCount = this.resultNumberOfChannels(bufferedImage);
            assert (bandCount <= 4);
            if (Array.getLength(resultJavaArray) < dimX * dimY * bandCount) {
                throw new IllegalArgumentException("resultJavaArray too small for " + dimX + "x" + dimY + "x" + bandCount);
            }
            boolean bl = invertBandOrder = this.bgrOrder && (bandCount == 3 || bandCount == 4);
            if (this.readingViaColorModel) {
                this.toJavaArrayViaColorModel(resultJavaArray, bufferedImage);
                return;
            }
            if (this.readingViaGraphics || !this.isSupportedStructure(bufferedImage)) {
                this.toJavaArrayViaGraphics(resultJavaArray, bufferedImage);
                return;
            }
            WritableRaster r = bufferedImage.getRaster();
            int dataBufferType = r.getSampleModel().getDataType();
            int[] iBuffer = null;
            float[] fBuffer = null;
            switch (dataBufferType) {
                case 0: 
                case 1: 
                case 3: {
                    iBuffer = new int[dimX];
                    break;
                }
                case 4: 
                case 5: {
                    fBuffer = new float[dimX];
                }
            }
            int y = 0;
            int disp = 0;
            while (y < dimY) {
                block12: for (int bandIndex = 0; bandIndex < bandCount; ++bandIndex) {
                    int correctedBandIndex = invertBandOrder && bandIndex < 3 ? 2 - bandIndex : bandIndex;
                    switch (dataBufferType) {
                        case 0: {
                            if (!(resultJavaArray instanceof byte[])) {
                                throw new IllegalArgumentException("resultJavaArray must be byte[], but it is " + resultJavaArray.getClass().getSimpleName());
                            }
                            Object[] result = (byte[])resultJavaArray;
                            r.getSamples(0, y, dimX, 1, correctedBandIndex, iBuffer);
                            int i = 0;
                            int j = disp + bandIndex;
                            while (i < dimX) {
                                result[j] = (byte)(iBuffer[i] & 0xFF);
                                ++i;
                                j += bandCount;
                            }
                            continue block12;
                        }
                        case 1: {
                            if (!(resultJavaArray instanceof short[])) {
                                throw new IllegalArgumentException("resultJavaArray must be short[], but it is " + resultJavaArray.getClass().getSimpleName());
                            }
                            Object[] result = (short[])resultJavaArray;
                            r.getSamples(0, y, dimX, 1, correctedBandIndex, iBuffer);
                            int i = 0;
                            int j = disp + bandIndex;
                            while (i < dimX) {
                                result[j] = (short)(iBuffer[i] & 0xFFFF);
                                ++i;
                                j += bandCount;
                            }
                            continue block12;
                        }
                        case 3: {
                            if (!(resultJavaArray instanceof int[])) {
                                throw new IllegalArgumentException("resultJavaArray must be int[], but it is " + resultJavaArray.getClass().getSimpleName());
                            }
                            Object[] result = (int[])resultJavaArray;
                            r.getSamples(0, y, dimX, 1, correctedBandIndex, iBuffer);
                            int i = 0;
                            int j = disp + bandIndex;
                            while (i < dimX) {
                                result[j] = iBuffer[i];
                                ++i;
                                j += bandCount;
                            }
                            continue block12;
                        }
                        case 4: {
                            if (!(resultJavaArray instanceof float[])) {
                                throw new IllegalArgumentException("resultJavaArray must be float[], but it is " + resultJavaArray.getClass().getSimpleName());
                            }
                            Object[] result = (float[])resultJavaArray;
                            r.getSamples(0, y, dimX, 1, correctedBandIndex, fBuffer);
                            int i = 0;
                            int j = disp + bandIndex;
                            while (i < dimX) {
                                result[j] = (byte)fBuffer[i];
                                ++i;
                                j += bandCount;
                            }
                            continue block12;
                        }
                        case 5: {
                            if (!(resultJavaArray instanceof double[])) {
                                throw new IllegalArgumentException("resultJavaArray must be double[], but it is " + resultJavaArray.getClass().getSimpleName());
                            }
                            Object[] result = (double[])resultJavaArray;
                            r.getSamples(0, y, dimX, 1, correctedBandIndex, fBuffer);
                            int i = 0;
                            int j = disp + bandIndex;
                            while (i < dimX) {
                                result[j] = (byte)fBuffer[i];
                                ++i;
                                j += bandCount;
                            }
                            continue block12;
                        }
                        default: {
                            throw new AssertionError((Object)("Unsupported data buffer type: " + dataBufferType));
                        }
                    }
                }
                ++y;
                disp += dimX * bandCount;
            }
        }

        private void toJavaArrayViaGraphics(Object resultJavaArray, BufferedImage bufferedImage) {
            ComponentColorModel cm;
            WritableRaster wr;
            if (!(resultJavaArray instanceof byte[])) {
                throw new IllegalArgumentException("resultJavaArray must be byte[] for conversion via Graphics");
            }
            byte[] result = (byte[])resultJavaArray;
            int dimX = bufferedImage.getWidth();
            int dimY = bufferedImage.getHeight();
            int bandCount = this.resultNumberOfChannels(bufferedImage);
            boolean gray = bandCount == 1;
            boolean invertBandOrder = this.bgrOrder && (bandCount == 3 || bandCount == 4);
            boolean banded = bufferedImage.getSampleModel() instanceof BandedSampleModel;
            byte[][] rgbAlpha = new byte[gray && !banded ? 3 : 1][];
            rgbAlpha[0] = result;
            for (int k = 1; k < rgbAlpha.length; ++k) {
                rgbAlpha[k] = new byte[result.length];
            }
            ColorSpace cs = ColorSpace.getInstance(gray && banded ? 1003 : 1000);
            DataBufferByte db = new DataBufferByte(rgbAlpha, rgbAlpha[0].length);
            if (gray) {
                int[] indexes = new int[rgbAlpha.length];
                int[] offsets = new int[rgbAlpha.length];
                for (int k = 0; k < indexes.length; ++k) {
                    indexes[k] = k;
                    offsets[k] = 0;
                }
                wr = Raster.createBandedRaster(db, dimX, dimY, dimX, indexes, offsets, null);
                cm = new ComponentColorModel(cs, null, bufferedImage.getColorModel().hasAlpha(), false, 1, db.getDataType());
            } else {
                int[] offsets = new int[bandCount];
                for (int k = 0; k < offsets.length; ++k) {
                    offsets[k] = invertBandOrder ? (k == 0 ? 2 : (k == 2 ? 0 : k)) : k;
                }
                wr = Raster.createInterleavedRaster(db, dimX, dimY, dimX * bandCount, bandCount, offsets, null);
                boolean hasAlpha = bandCount >= 4;
                cm = new ComponentColorModel(cs, null, hasAlpha, false, hasAlpha ? 3 : 1, db.getDataType());
            }
            BufferedImage resultImage = new BufferedImage(cm, wr, false, null);
            resultImage.getGraphics().drawImage(bufferedImage, 0, 0, null);
        }

        private void toJavaArrayViaColorModel(Object resultJavaArray, BufferedImage bufferedImage) {
            if (!(resultJavaArray instanceof byte[])) {
                throw new IllegalArgumentException("resultJavaArray must be byte[] for conversion via color model");
            }
            byte[] result = (byte[])resultJavaArray;
            int dimX = bufferedImage.getWidth();
            int dimY = bufferedImage.getHeight();
            int bandCount = this.resultNumberOfChannels(bufferedImage);
            ColorModel colorModel = bufferedImage.getColorModel();
            WritableRaster r = bufferedImage.getRaster();
            Object outData = null;
            int rIndex = this.bgrOrder ? 2 : 0;
            boolean gIndex = true;
            int bIndex = this.bgrOrder ? 0 : 2;
            switch (bandCount) {
                case 4: {
                    int disp = 0;
                    for (int y = 0; y < dimY; ++y) {
                        for (int x = 0; x < dimX; ++x) {
                            outData = r.getDataElements(x, y, outData);
                            result[disp + rIndex] = (byte)colorModel.getRed(outData);
                            result[disp + 1] = (byte)colorModel.getGreen(outData);
                            result[disp + bIndex] = (byte)colorModel.getBlue(outData);
                            result[disp + 3] = (byte)colorModel.getAlpha(outData);
                            disp += 4;
                        }
                    }
                    break;
                }
                case 3: {
                    int disp = 0;
                    for (int y = 0; y < dimY; ++y) {
                        for (int x = 0; x < dimX; ++x) {
                            outData = r.getDataElements(x, y, outData);
                            result[disp + rIndex] = (byte)colorModel.getRed(outData);
                            result[disp + 1] = (byte)colorModel.getGreen(outData);
                            result[disp + bIndex] = (byte)colorModel.getBlue(outData);
                            disp += 3;
                        }
                    }
                    break;
                }
                case 1: {
                    int disp = 0;
                    for (int y = 0; y < dimY; ++y) {
                        for (int x = 0; x < dimX; ++x) {
                            outData = r.getDataElements(x, y, outData);
                            result[disp++] = (byte)colorModel.getGreen(outData);
                        }
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Illegal bandCount = " + bandCount));
                }
            }
        }

        private boolean isSupportedStructure(BufferedImage bufferedImage) {
            return ImageToMatrix.resultElementTypeOrNullForUnsupported(bufferedImage) != null;
        }
    }

    public static final class ToInterleavedBGR
    extends ToInterleavedRGB {
        public ToInterleavedBGR() {
            super(true);
        }
    }
}

