/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public class MaxFromTwoSelectedNumbersFunc
extends AbstractFunc
implements Func {
    private final int indexShift;

    private MaxFromTwoSelectedNumbersFunc(int indexShift) {
        if (indexShift < 0) {
            throw new IllegalArgumentException("Negative index shift " + indexShift);
        }
        this.indexShift = indexShift;
    }

    public static MaxFromTwoSelectedNumbersFunc getInstance(int indexShift) {
        return new MaxFromTwoSelectedNumbersFunc(indexShift);
    }

    @Override
    public double get(double ... x) {
        int k1 = (int)x[0] + 1;
        int k2 = k1 + this.indexShift;
        if (k2 >= x.length) {
            k2 -= x.length - 1;
        }
        return Math.max(x[k1], x[k2]);
    }

    public String toString() {
        return "max from 2 selected numbers f(x0,x1,...)=max(x[(int)x0+1],x[(int)x0+1+sh]), sh=" + this.indexShift;
    }
}

