/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.Range;
import net.algart.math.functions.Func;

public final class RectangularFunc
implements Func {
    final Range range;
    final double min;
    final double max;
    final double in;
    final double out;

    private RectangularFunc(Range range, double in, double out) {
        this.range = range;
        this.min = range.min();
        this.max = range.max();
        this.in = in;
        this.out = out;
    }

    public static RectangularFunc getInstance(Range range, double in, double out) {
        return new RectangularFunc(range, in, out);
    }

    public static RectangularFunc getInstance(double min, double max, double in, double out) {
        return new RectangularFunc(Range.of(min, max), in, out);
    }

    public Range range() {
        return this.range;
    }

    public double in() {
        return this.in;
    }

    public double out() {
        return this.out;
    }

    @Override
    public double get(double ... x) {
        return x[0] >= this.min && x[0] <= this.max ? this.in : this.out;
    }

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 1 argument required");
    }

    @Override
    public double get(double x0) {
        return x0 >= this.min && x0 <= this.max ? this.in : this.out;
    }

    @Override
    public double get(double x0, double x1) {
        return x0 >= this.min && x0 <= this.max ? this.in : this.out;
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return x0 >= this.min && x0 <= this.max ? this.in : this.out;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return x0 >= this.min && x0 <= this.max ? this.in : this.out;
    }

    public String toString() {
        return "rectangular function f(x)=" + this.min + "<=x<=" + this.max + "?" + this.in + ":" + this.out;
    }
}

